// ConditionSearch.cpp :  Դϴ.
//

#include "stdafx.h"
#include "ChampionAgentTest.h"
#include "ConditionSearch.h"
#include "ChampionAgentTestDlg.h"
#include "afxdialogex.h"


// CConditionSearch ȭ Դϴ.
extern CChampionAgentTestDlg*	g_pTestDlg;

IMPLEMENT_DYNAMIC(CConditionSearch, CDialogEx)

CConditionSearch::CConditionSearch(CWnd* pParent /*=NULL*/)
	: CDialogEx(CConditionSearch::IDD, pParent)
{
	m_pParent = pParent;
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_nListIndex = -1;
}

CConditionSearch::~CConditionSearch()
{
}

void CConditionSearch::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST, m_List);
	DDX_Control(pDX, IDC_CODE, m_Code);
	DDX_Control(pDX, ID_LIST, m_BtnList);
	DDX_Control(pDX, IDCODE, m_BtnCode);
	DDX_Control(pDX, IDREGREAL, m_BtnRegReal);
	DDX_Control(pDX, IDREAL, m_BtnReal);
	DDX_Control(pDX, IDC_EDITCNT, m_EditCnt);
	DDX_Control(pDX, IDC_EDITLIST, m_EditList);
	DDX_Control(pDX, IDC_EDITCNT2, m_EditChoice);
	DDX_Control(pDX, IDC_EDITCONDITION, m_realcondition);

	DDX_Control(pDX, IDC_EDITREGISEQ, m_editRegiSeq);
	DDX_Control(pDX, IDC_EDITREGITIME, m_EditRegiTime);
	DDX_Control(pDX, IDC_EDITMSG, m_EditMsg);
	DDX_Control(pDX, IDC_EDITREGI, m_EditRegi);
	DDX_Control(pDX, IDC_EDITRESPONDREAL, m_EditRespondReal);
}


BEGIN_MESSAGE_MAP(CConditionSearch, CDialogEx)
	ON_BN_CLICKED(ID_LIST, &CConditionSearch::OnBnClickedList)
	ON_BN_CLICKED(IDCODE, &CConditionSearch::OnBnClickedCode)
	ON_BN_CLICKED(IDREGREAL, &CConditionSearch::OnBnClickedRegreal)
	ON_BN_CLICKED(IDREAL, &CConditionSearch::OnBnClickedReal)
	ON_NOTIFY(NM_CLICK, IDC_LIST, &CConditionSearch::OnClickList)
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CLOSE()
END_MESSAGE_MAP()


// CConditionSearch ޽ óԴϴ.
// ʱ ó
BOOL CConditionSearch::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	//  ȭ   մϴ.  α׷  â ȭ ڰ ƴ 쿡
	//  ӿũ  ۾ ڵ մϴ.
	SetIcon(m_hIcon, TRUE);			// ū  մϴ.
	SetIcon(m_hIcon, FALSE);		//   մϴ.
	
	m_strId = theApp.m_strUserID;		//theApp.m_CommAgent.GetLoginInfo(_T("USER_ID"));
	//ʱ⸮Ʈ 
	InitListCtrl();

	return TRUE;  // Ŀ Ʈѿ   TRUE ȯմϴ.
}

void CConditionSearch::OnDestroy()
{
	CString strId;
	strId = theApp.m_strUserID;		//theApp.m_CommAgent.GetLoginInfo(_T("USER_ID"));

	if (!strId.IsEmpty())
	{
		SetRealRemove();
	}

	CDialogEx::OnDestroy();

	// TODO: ⿡ ޽ ó ڵ带 ߰մϴ.
}


void CConditionSearch::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // ׸⸦  ̽ ؽƮԴϴ.

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Ŭ̾Ʈ 簢   ϴ.
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		//  ׸ϴ.
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}

}


HCURSOR CConditionSearch::OnQueryDragIcon()
{
	// TODO: ⿡ ޽ ó ڵ带 ߰ /Ǵ ⺻ ȣմϴ.
	return static_cast<HCURSOR>(m_hIcon);
	//return CDialogEx::OnQueryDragIcon();
}


void CConditionSearch::OnClose()
{
	// TODO: ⿡ ޽ ó ڵ带 ߰ /Ǵ ⺻ ȣմϴ.
	SetRealRemove();
	CDialogEx::OnClose();
}

void CConditionSearch::InitListCtrl()
{

	m_List.InsertColumn(1, _T("峯¥"), LVCFMT_RIGHT, 80, 0);
	m_List.InsertColumn(2, _T("ð"), LVCFMT_RIGHT, 80, 0);
	m_List.InsertColumn(3, _T("ȣ"), LVCFMT_RIGHT, 80, 0);
	m_List.InsertColumn(4, _T("Ǹ"), LVCFMT_RIGHT, 150, 0);
	m_List.InsertColumn(5, _T("׷"), LVCFMT_RIGHT, 120, 0);
	m_List.InsertColumn(6, _T("Ǽ"), LVCFMT_RIGHT, 200, 0);
	m_List.SetExtendedStyle(LVS_EX_ONECLICKACTIVATE | LVS_EX_INFOTIP | LVS_EX_GRIDLINES);

	m_Code.InsertColumn(1, _T("ڵ"), LVCFMT_CENTER, 120, 0);
	m_Code.InsertColumn(2, _T(""), LVCFMT_CENTER, 120, 0);
	m_Code.InsertColumn(3, _T("ذ"), LVCFMT_RIGHT, 80, 0);
	m_Code.InsertColumn(4, _T("ð"), LVCFMT_RIGHT, 80, 0);
	m_Code.InsertColumn(5, _T(""), LVCFMT_RIGHT, 80, 0);
	m_Code.InsertColumn(6, _T(""), LVCFMT_RIGHT, 80, 0);
	m_Code.InsertColumn(7, _T("ʵ"), LVCFMT_RIGHT, 200, 0);
	m_Code.SetExtendedStyle(LVS_EX_ONECLICKACTIVATE | LVS_EX_INFOTIP | LVS_EX_GRIDLINES);

}

void CConditionSearch::InitListRqDataCtrl(int nType)
{
	CFont nFont;
	NONCLIENTMETRICS ncm;

	ncm.cbSize = sizeof(NONCLIENTMETRICS) - sizeof(ncm.iPaddedBorderWidth);
	VERIFY(SystemParametersInfo(SPI_GETNONCLIENTMETRICS, sizeof(NONCLIENTMETRICS), &ncm, 0));
	nFont.CreateFontIndirect(&(ncm.lfMessageFont));

	m_List.DeleteAllItems();
	m_Code.DeleteAllItems();
	m_EditChoice.SetWindowText(_T(""));
	m_EditCnt.SetWindowText(_T(""));
	m_EditList.SetWindowText(_T(""));

}


void CConditionSearch::OnBnClickedList()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	long nRet(0);
	if(m_strId.IsEmpty())
	{
		return;
	}

	m_List.DeleteAllItems();
	m_EditChoice.SetWindowText(_T(""));
	RequestUserConditionList();

}


void CConditionSearch::OnBnClickedCode()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	long nRet(0);
	if(m_strId.IsEmpty())
	{
		return;
	}
	if(m_nListIndex < 0)
	{
		AfxMessageBox("ȸ ϴ ǸƮ ù° ÷ Ŭּ.");
		return;
	}

	CString sEditCnt;					// ׸ 
	m_EditCnt.GetWindowText(sEditCnt);
	if(atoi(sEditCnt) > 17)
	{
		AfxMessageBox("߰ ȸ  ִ ׸ ִ 17Դϴ.");
		return;
	}

	CString sEditList(_T(""));			// ׸ Ʈ
	if(atoi(sEditCnt) > 0)
	{
		m_EditList.GetWindowText(sEditList);
	}

	CString sDate = m_List.GetItemText(m_nListIndex, 0);		//峯¥
	CString sTime = m_List.GetItemText(m_nListIndex, 1);		//ð
	CString sSeq = m_List.GetItemText(m_nListIndex, 2);			//ȣ

	m_Code.DeleteAllItems();
	RequestConditionCode( sDate, sTime, sSeq, sEditCnt, sEditList);
}


void CConditionSearch::OnBnClickedRegreal()
{
	m_EditRegiTime.SetWindowText(_T(""));
	m_EditMsg.SetWindowText(_T(""));

	long nRet(0);
	if(m_strId.IsEmpty())
	{
		m_realcondition.SetWindowText(_T(""));
		m_EditRegi.SetWindowText(_T(""));	
		m_editRegiSeq.SetWindowText(_T(""));
		return;
	}
	if(m_nListIndex < 0)
	{
		m_realcondition.SetWindowText(_T(""));
		m_EditRegi.SetWindowText(_T(""));	
		m_editRegiSeq.SetWindowText(_T(""));
		AfxMessageBox("ǽðȸ ϴ ǸƮ ù° ÷ Ŭּ.");
		return;
	}
	
	CString sDate = m_List.GetItemText(m_nListIndex, 0);		//峯¥
	CString sTime = m_List.GetItemText(m_nListIndex, 1);		//ð
	CString sSeq = m_List.GetItemText(m_nListIndex, 2);			//ȣ
	
	CString sCurRegi(_T("")), sRegi(_T("")), sDelSeq(_T(""));
	m_EditRegi.GetWindowText(sCurRegi);
	sRegi = (sCurRegi == "ǽð") ? _T("D"):_T("E");
	if( sRegi == "D")
		m_editRegiSeq.GetWindowText(sDelSeq);

	m_EditRegi.SetWindowText(_T(""));	
	m_editRegiSeq.SetWindowText(_T(""));
	RequestRegisterReal( sDate, sTime, sSeq, sRegi, sDelSeq);


	CString sCondName = m_List.GetItemText(m_nListIndex, 3);						//Ǹ
	m_realcondition.SetWindowText(sCondName);
}


void CConditionSearch::OnBnClickedReal()
{
	SetReal();
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
}

void CConditionSearch::RequestUserConditionList()
{ 
	g_pTestDlg->RequestUserConditionList(m_strId);
}

void CConditionSearch::RequestConditionCode(CString sDate, CString sTime, CString sSeq, CString sEditCnt, CString sEditList)
{ 
	g_pTestDlg->RequestConditionCode(m_strId, sDate, sTime, sSeq, sEditCnt, sEditList);
}

void CConditionSearch::RequestRegisterReal(CString sDate, CString sTime, CString sSeq, CString sRegi, CString sDelSeq)
{ 
	g_pTestDlg->RequestRegisterReal(m_strId, sDate, sTime, sSeq, sRegi, sDelSeq);
}

// TR Ÿ  ̺Ʈ
void CConditionSearch::OnReceiveTrDataChampioncommagentctrl(long nRqId, LPCTSTR sTrCode, LPCTSTR sData, long nDataLength,	LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage, LPCTSTR sSplmMsg)
{
	CString strTrCode(sTrCode);
	SetRealRemove();
	if (strTrCode == RQ_TRNAME_COND_LIST)
	{	// ں ǸƮ ȸ
		ReceiveCondList( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
	else if (strTrCode == RQ_TRNAME_COND_CODE)
	{	// Ǻ ȸ
		ReceiveCondCode( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
	else if (strTrCode == RQ_TRNAME_REGI_REAL)
	{	// ǽð 
		ReceiveRegiReal( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
}


void CConditionSearch::ReceiveCondList(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strValue, strTemp;
	int nDataCnt = 0;
	char szTemp[128] = {0x00};
	long lTemp;
	int nItem;
	int nListRowCnt = m_List.GetItemCount();

	if ( nDataLength > 0 )
	{	// Data OK
		//Ű

		typedef struct _COND_LIST_OUTREC1
		{
			char		SFLAG[1];			/*  [ý÷]     */
			char		LSAVECNT[4];		/*  [尡Ǽ]     */
			char		LCNT[4];			/*  [Ǽ]     */

		}COND_LIST_OUTREC1;

		typedef struct _COND_LIST_OUTREC2
		{
			char		SDATE[8];			/*  [峯¥]     */
			char		STIME[6];			/*  [ð]     */
			char		LSEQ[4];			/*  [ȣ]     */
			char		SFLAG[1];			/*  [Ǳ]     */
			char		LBLINDFLAG[1];		/*  [ǳ⿩]     */
			char		SCONTNAME[40];		/*  [Ǹ]     */
			char		SGROUPNAME[40];		/*  [׷]     */
			char		SMEMO[400];			/*  [Ǽ]     */
			char		LLANGCHECK[1];		/*  []     */
			char		LCOMPLEXFLAG[1];	/*  [ǿ]     */
			
		}COND_LIST_OUTREC2;

		COND_LIST_OUTREC1* pOutRec1 = (COND_LIST_OUTREC1*)sData;
		COND_LIST_OUTREC2* pOutRec2 = (COND_LIST_OUTREC2*)(sData + sizeof(COND_LIST_OUTREC1));
		memcpy(szTemp, pOutRec1->LCNT, sizeof(pOutRec1->LCNT));
		nDataCnt = _ttoi(szTemp);	// Ǽ

		if(nDataCnt > 0)
		{
			// Ʈ 
			for (int i = 0; i < nDataCnt; i++)
			{
				strTemp = CString(pOutRec2[i].SDATE, _countof(pOutRec2[i].SDATE));		strTemp.Trim();
				nItem = m_List.InsertItem( LVIF_TEXT, i + nListRowCnt, strTemp, 0, 0, 0, NULL );		
				m_List.SetItemText(nItem, 0, strTemp.Trim());		// 峯¥

				strTemp = CString(pOutRec2[i].STIME, _countof(pOutRec2[i].STIME));		strTemp.Trim();
				m_List.SetItemText(nItem, 1, strTemp.Trim());		// ð

				strTemp = CString(pOutRec2[i].LSEQ, _countof(pOutRec2[i].LSEQ));		strTemp.Trim();
				m_List.SetItemText(nItem, 2, strTemp.Trim());		// ȣ

				strTemp = CString(pOutRec2[i].SCONTNAME, _countof(pOutRec2[i].SCONTNAME));		strTemp.Trim();
				m_List.SetItemText(nItem, 3, strTemp.Trim());		// Ǹ

				strTemp = CString(pOutRec2[i].SGROUPNAME, _countof(pOutRec2[i].SGROUPNAME));		strTemp.Trim();
				m_List.SetItemText(nItem, 4, strTemp.Trim());		// ׷

				strTemp = CString(pOutRec2[i].SMEMO, _countof(pOutRec2[i].SMEMO));		strTemp.Trim();
				m_List.SetItemText(nItem, 5, strTemp.Trim());		// Ǽ
			}
		}
	}
	else
	{	// Error
		AfxMessageBox(sMessage);
	}
}

void CConditionSearch::ReceiveCondCode(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strValue, strTemp;
	int nDataCnt = 0;
	char szTemp[128] = {0x00};
	long lTemp;
	int nItem;
	int nListRowCnt = m_Code.GetItemCount();

	if ( nDataLength > 0 )
	{	// Data OK
		//Ű

		typedef struct _COND_CODE_OUTREC1
		{
			char		SCALLGUBUN[4];			/*  [ݱ]     */
			char		LOUTFILEDCNT[2];		/*  [OutfieldCount]     */
			char		SOUTLISTPACKETSIZE[4];	/*  []     */
			char		SFINDTIME[8];			/*  [ǰ˻ð]		*/
			char		LTOTCNT[4];				/*  [ü]		*/

		}COND_CODE_OUTREC1;

		typedef struct _COND_CODE_OUTREC2
		{
			char		SDEBI[1];			/*  [ȣ]     */
			char		SCODE[9];			/*  [ڵ]     */
			char		SHNAME[40];			/*  []     */
			char		SMARKET[1];			/*  [ϱ]     */
			char		SPREPRICE[16];		/*  [ذ]     */
			char		SOPEN[16];			/*  [ð]     */
			char		SHIGH[16];			/*  []     */
			char		SLOW[16];			/*  []     */
			char		SPRICE[16];			/*  []     */
			char		SORDERRANK[4];		/*  [˻]     */
			char		SRESULTFILED[272];	/*  [ʵ]     */			
		}COND_CODE_OUTREC2;

		COND_CODE_OUTREC1* pOutRec1 = (COND_CODE_OUTREC1*)sData;
		COND_CODE_OUTREC2* pOutRec2 = (COND_CODE_OUTREC2*)(sData + sizeof(COND_CODE_OUTREC1));
		memcpy(szTemp, pOutRec1->LTOTCNT, sizeof(pOutRec1->LTOTCNT));
		nDataCnt = _ttoi(szTemp);	// ü

		if(nDataCnt > 0)
		{
			// Ʈ 
			for (int i = 0; i < nDataCnt; i++)
			{
				strTemp = CString(pOutRec2[i].SCODE, _countof(pOutRec2[i].SCODE));		strTemp.Trim();
				nItem = m_Code.InsertItem( LVIF_TEXT, i + nListRowCnt, strTemp, 0, 0, 0, NULL );		
				m_Code.SetItemText(nItem, 0, strTemp.Trim());		// ڵ

				strTemp = CString(pOutRec2[i].SHNAME, _countof(pOutRec2[i].SHNAME));		strTemp.Trim();
				m_Code.SetItemText(nItem, 1, strTemp.Trim());		// 

				strTemp = CString(pOutRec2[i].SPREPRICE, _countof(pOutRec2[i].SPREPRICE));		strTemp.Trim();
				m_Code.SetItemText(nItem, 2, strTemp.Trim());		// ذ

				strTemp = CString(pOutRec2[i].SOPEN, _countof(pOutRec2[i].SOPEN));		strTemp.Trim();
				m_Code.SetItemText(nItem, 3, strTemp.Trim());		// ð

				strTemp = CString(pOutRec2[i].SHIGH, _countof(pOutRec2[i].SHIGH));		strTemp.Trim();
				m_Code.SetItemText(nItem, 4, strTemp.Trim());		// 

				strTemp = CString(pOutRec2[i].SLOW, _countof(pOutRec2[i].SLOW));		strTemp.Trim();
				m_Code.SetItemText(nItem, 5, strTemp.Trim());		// 

				strTemp = CString(pOutRec2[i].SRESULTFILED, _countof(pOutRec2[i].SRESULTFILED));		strTemp.Trim();
				m_Code.SetItemText(nItem, 6, strTemp.Trim());		// ʵ
			}
		}
	}
	else
	{	// Error
		AfxMessageBox(sMessage);
	}
}

void CConditionSearch::ReceiveRegiReal(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString sRegiGubun, sRegSeq, sRegiTime, sErrMsg;
	int		nDataCnt = 0, nDataOffset = 0;

	if ( nDataLength > 0 )
	{
		
		sRegiGubun = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_REGI_REAL, _T("OutRec1"), _T("sGubun"), 0);		// ڵ
		sRegSeq		= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_REGI_REAL, _T("OutRec1"), _T("sRegSeq"), 0);			//ȣ
		sRegiTime	= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_REGI_REAL, _T("OutRec1"), _T("sRegTime"), 0);		//ð
		sErrMsg		= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_REGI_REAL, _T("OutRec1"), _T("sErrMsg"), 0);			//޽
		CString sRegi;
		if(sRegiGubun == "E")	sRegi = _T("ǽð");
		else if(sRegiGubun == "D") sRegi = _T("ǽð");

		m_EditRegi.SetWindowText(sRegi);
		m_editRegiSeq.SetWindowText(sRegSeq);
		m_EditRegiTime.SetWindowText(sRegiTime);
		m_EditMsg.SetWindowText(sErrMsg);
	}
}

//ǽð 
LONG CConditionSearch::SetReal()
{
	long nRet(0);
	m_EditRespondReal.SetWindowText("");
	// ǽð 
	if ( theApp.m_pCommAgent && theApp.m_pCommAgent->GetSafeHwnd() != NULL )
	{
		CString sRealSeq, sSeq;
		m_editRegiSeq.GetWindowText(sRealSeq);
		sSeq.Format("%04d", atoi(sRealSeq));
		// (ǽð) Ÿ ûѴ.
		nRet = theApp.m_pCommAgent->RegisterReal(154, (LPCTSTR)sSeq );
	}
	else
	{
		AfxMessageBox(" Ǿ  ʽϴ.  ¸ Ȯ Ͻʽÿ. \r\n");
		return 0L;
	}
	return nRet;
}

//ǽð 
LONG CConditionSearch::SetRealRemove()
{
	long nRet(0);

	if ( theApp.m_pCommAgent && theApp.m_pCommAgent->GetSafeHwnd() != NULL )
	{
		CString sRealSeq;
		m_editRegiSeq.GetWindowText(sRealSeq);
		// (ǽð) Ÿ ûѴ.
		theApp.m_pCommAgent->UnRegisterReal(154, (LPCTSTR)sRealSeq);
	}
	else
	{
		AfxMessageBox(" Ǿ  ʽϴ.  ¸ Ȯ Ͻʽÿ. \r\n");
		return 0L;
	}
	return nRet;
}
// ǽð 
void CConditionSearch::OnReceiveRealDataChampioncommagentctrl(LPCTSTR sJongmokCode, short nPBID, LPCTSTR sRealData)
{
CString strTemp , strData, strITMSCode;
	switch(nPBID)
	{
	case 154:	// ǰ˻ ǽð /
		{
			CString sItemCode, sItemName, sPrice, sOpen, sHigh, sLow;

			sItemCode = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("sItemCode"));		// ڵ
			sItemCode.Trim();

			sItemName = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("sItemName"));		//	
			sItemName.Trim();

			sPrice = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("sPrice"));		//	
			sPrice.Trim();

			sOpen = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("sOpen"));		//	ð
			sOpen.Trim();

			sHigh = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("sHigh"));		//	
			sHigh.Trim();

			sLow = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("sLow"));		//	
			sLow.Trim();

		
			strData.Format("[ǽð ǰ˻ Ȯâ] --> ");
			strTemp.Format("    ڵ : [%s]    : [%s]\r\n", sItemCode, sItemName);
			strData += strTemp;
			strTemp.Format("    簡 : [%s]   ð// : [%s / %s / %s]", sPrice,sOpen, sHigh, sLow);
			strData += strTemp;
			m_EditRespondReal.SetWindowText(strData);
		}
		break;

		
	}

}

void CConditionSearch::OnClickList(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	int itemindex;
	itemindex = pNMItemActivate->iItem;

	if (itemindex < 0)
	{
		m_EditChoice.SetWindowText(_T(""));
		return;
	}
	m_nListIndex = itemindex;
	CString sChoice = m_List.GetItemText(m_nListIndex, 3);	//Ǹ
	m_EditChoice.SetWindowText(sChoice);
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	*pResult = 0;
}

