// OvrsStCurrentDlg.cpp :  

///////////////////////////////////////////////////////////////////////////////////////////////////
// Header Files
#include "stdafx.h"
#include "ChampionAgentTest.h"
#include "ChampionAgentTestDlg.h"
#include "OvrsStCurrentDlg.h"

// #include "../../ChampionAgentHeader/TR_SACZ010Q1.h"
// #include "../../ChampionAgentHeader/realheader.h"

///////////////////////////////////////////////////////////////////////////////////////////////////
// Define Values
#define ARRAY_INDATA_COUNT_SIZE		5							// 迭 ڷϰ ޸byteũ
#define ARRAY_OUTDATA_COUNT_SIZE	ARRAY_INDATA_COUNT_SIZE		// 迭 ڷϰ ޸byteũ
#define RQ_VI						1

extern CChampionAgentTestDlg*	g_pTestDlg;

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

COvrsStCurrentDlg::COvrsStCurrentDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(COvrsStCurrentDlg::IDD, pParent)
{
	m_pParent = pParent;
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void COvrsStCurrentDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRealAddDlg)
	DDX_Control(pDX, IDC_LIST_HOGA,		m_ListHoga);
	DDX_Control(pDX, IDC_LIST_TICK,		m_ListTick);
	DDX_Control(pDX, IDC_LIST_NOW,		m_ListNow);
	DDX_Control(pDX, IDC_JONGMOK,		m_JongMok);
	DDX_Control(pDX, IDC_LIST_RQDATA,	m_ListRqData);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(COvrsStCurrentDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_CLOSE()
	ON_WM_QUERYDRAGICON()

	ON_BN_CLICKED(IDC_BTN_SEARCH,			&COvrsStCurrentDlg::OnBnClickedBtnSearch)
	//ON_BN_CLICKED(IDC_BTN_JONGMOK_FO, &COvrsStCurrentDlg::OnBnClickedBtnJongmokFo)
	ON_BN_CLICKED(IDC_BTN_JONGMOK_STOCK,	&COvrsStCurrentDlg::OnBnClickedBtnJongmokStock)
	ON_BN_CLICKED(IDC_BTN_JONGMOK_FO,		&COvrsStCurrentDlg::OnBnClickedBtnJongmokFo)
	ON_BN_CLICKED(IDC_RQ_VI_BTN,			OnBnClickedBtnRqVI)
END_MESSAGE_MAP()

// ʱ ó
BOOL COvrsStCurrentDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	//  ȭ   մϴ.  α׷  â ȭ ڰ ƴ 쿡
	//  ӿũ  ۾ ڵ մϴ.
	SetIcon(m_hIcon, TRUE);			// ū  մϴ.
	SetIcon(m_hIcon, FALSE);		//   մϴ.

	//ʱ⸮Ʈ 
	InitListCtrl();

// #ifdef RECV_MESSAGE
// 	theApp.m_CommAgent.CommSetRecvEvent(FALSE);
// #endif
// 
// 	SetRealReg("0", 42);		// [VIߵ] VIߵ ȣ 
// 	SetRealReg("*", 41);		// [VIߵ] VIߵ  
// 	SetRealReg("3", 151);		// ð ˶ 

	return TRUE;  // Ŀ Ʈѿ   TRUE ȯմϴ.
}

void COvrsStCurrentDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // ׸⸦  ̽ ؽƮԴϴ.

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Ŭ̾Ʈ 簢   ϴ.
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		//  ׸ϴ.
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

void COvrsStCurrentDlg::OnClose()
{
	//ǽð 
	long nRet(0);

	nRet = SetRealRemove(m_strCode, 230);
	nRet = SetRealRemove(m_strCode, 231);

	CDialogEx::OnClose();
}

HCURSOR COvrsStCurrentDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void COvrsStCurrentDlg::InitListCtrl()
{
	CFont nFont;
	NONCLIENTMETRICS ncm;
	//ncm.cbSize = sizeof(NONCLIENTMETRICS);
	ncm.cbSize = sizeof(NONCLIENTMETRICS) - sizeof(ncm.iPaddedBorderWidth);
	VERIFY(SystemParametersInfo(SPI_GETNONCLIENTMETRICS, sizeof(NONCLIENTMETRICS), &ncm, 0));
	nFont.CreateFontIndirect(&(ncm.lfMessageFont));

	m_ListHoga.SetFont(&nFont);
	m_ListHoga.InsertColumn(1, _T("ŵ"), LVCFMT_RIGHT, 80, 0);
	m_ListHoga.InsertColumn(2, _T(""), LVCFMT_RIGHT, 80, 0);
	m_ListHoga.InsertColumn(3, _T("ż"), LVCFMT_RIGHT, 80, 0);

	for (int i = 0; i < 11; i++)
	{
		m_ListHoga.InsertItem(i + 1, _T(""));
	}

	m_ListHoga.SetItemText(0, 0, _T("ŵ"));
	m_ListHoga.SetItemText(0, 2, _T("ż"));

	m_ListHoga.SetExtendedStyle(LVS_EX_ONECLICKACTIVATE | LVS_EX_INFOTIP | LVS_EX_GRIDLINES);

	m_ListTick.SetFont(&nFont);
	m_ListTick.InsertColumn(1, _T("ð"), LVCFMT_CENTER, 100, 0);
	m_ListTick.InsertColumn(2, _T("üᰡ"), LVCFMT_RIGHT, 100, 0);
	m_ListTick.InsertColumn(3, _T("üᷮ"), LVCFMT_RIGHT, 105, 0);
	m_ListTick.InsertColumn(4, _T("ŷ"), LVCFMT_RIGHT, 110, 0);

	m_ListTick.SetExtendedStyle(LVS_EX_ONECLICKACTIVATE | LVS_EX_INFOTIP | LVS_EX_GRIDLINES);

	m_ListNow.SetFont(&nFont);
	m_ListNow.InsertColumn(1, _T("簡"), LVCFMT_RIGHT, 80, 0);
	m_ListNow.InsertColumn(2, _T("ȣ"), LVCFMT_LEFT, 30, 0);
	m_ListNow.InsertColumn(3, _T(""), LVCFMT_RIGHT, 80, 0);
	m_ListNow.InsertColumn(4, _T(""), LVCFMT_RIGHT, 80, 0);
	m_ListNow.InsertColumn(5, _T(""), LVCFMT_RIGHT, 80, 0);
	m_ListNow.InsertColumn(6, _T("ŷȸ"), LVCFMT_RIGHT, 80, 0);

	m_ListNow.InsertItem(1, _T(""));
	
	m_ListNow.SetExtendedStyle(LVS_EX_ONECLICKACTIVATE | LVS_EX_INFOTIP | LVS_EX_GRIDLINES);
}

void COvrsStCurrentDlg::InitListRqDataCtrl(int nType)
{
	CFont nFont;
	NONCLIENTMETRICS ncm;

	ncm.cbSize = sizeof(NONCLIENTMETRICS) - sizeof(ncm.iPaddedBorderWidth);
	VERIFY(SystemParametersInfo(SPI_GETNONCLIENTMETRICS, sizeof(NONCLIENTMETRICS), &ncm, 0));
	nFont.CreateFontIndirect(&(ncm.lfMessageFont));
	m_ListRqData.SetFont(&nFont);

	///////////////////////////////////////////////////////////////////////////////////////////////
	// LIST ʱȭ
	///////////////////////////////////////////////////////////////////////////////////////////////
	// List Item 
	m_ListRqData.DeleteAllItems();

	// List Column 
	int nListColumn = 0;

	nListColumn = m_ListRqData.GetHeaderCtrl()->GetItemCount();

	for (int i = 0; i < nListColumn; i++)
	{
		m_ListRqData.DeleteColumn(i);
	}
	///////////////////////////////////////////////////////////////////////////////////////////////

//	if (nType == RQ_VI)
	{
		m_ListRqData.InsertColumn(0, _T("ڵ(153)"),	LVCFMT_CENTER, 64, 0);
		m_ListRqData.InsertColumn(1, _T("(154)"),		LVCFMT_LEFT, 100, 0);
		m_ListRqData.InsertColumn(2, _T("簡(000)"),		LVCFMT_RIGHT, 80, 0);
		m_ListRqData.InsertColumn(3, _T("ϴ(002)"),	LVCFMT_RIGHT, 80, 0);
		m_ListRqData.InsertColumn(4, _T("(003)"),		LVCFMT_RIGHT, 80, 0);
		m_ListRqData.InsertColumn(5, _T("ŷ(004)"),		LVCFMT_RIGHT, 80, 0);
		m_ListRqData.InsertColumn(6, _T("Ѱ(011)"),		LVCFMT_RIGHT, 80, 0);
		m_ListRqData.InsertColumn(7, _T("Ѱ(012)"),		LVCFMT_RIGHT, 80, 0);
		m_ListRqData.InsertColumn(8, _T("ð(013)"),		LVCFMT_RIGHT, 80, 0);
		m_ListRqData.InsertColumn(9, _T("(014)"),		LVCFMT_RIGHT, 80, 0);
		m_ListRqData.InsertColumn(10, _T("(015)"),		LVCFMT_RIGHT, 80, 0);

		m_ListRqData.SetExtendedStyle(LVS_EX_ONECLICKACTIVATE | LVS_EX_INFOTIP | LVS_EX_GRIDLINES);
	}
}

//  ȣ, ƽ, 簡 ȸ  ǽð 
void COvrsStCurrentDlg::OnBnClickedBtnSearch()
{
	long nRet(0);
	CString strCode;
	// ȣ ȸ
	m_JongMok.GetWindowText(strCode);
	
	if (m_strCode != "" && m_strCode != strCode)
	{
		nRet = SetRealRemove(m_strCode, 230);
		nRet = SetRealRemove(m_strCode, 231);
	}
	
	m_strCode = strCode;

	if (strCode.IsEmpty())
	{
		m_JongMok.SetFocus();
		return;
	}

	// ü ׸ Ŭ
	m_ListTick.DeleteAllItems();

	//InitListRqDataCtrl(0);

	
	// 簡 ü ȸ
	RequestSise(strCode);

	// ȣ ȸ
	RequestHoga(strCode);

	// ü ü ȸ
	RequestChe(strCode);
	// ǽð 
	nRet = SetRealReg(strCode, 230);
	nRet = SetRealReg(strCode, 231);
	
}


void COvrsStCurrentDlg::RequestSise(CString strCode)
{ 
	g_pTestDlg->RequestOvrsSise(strCode);
}

void COvrsStCurrentDlg::RequestHoga(CString strCode)
{ 
	g_pTestDlg->RequestOvrsHoga(strCode);
}

void COvrsStCurrentDlg::RequestChe(CString strCode)
{ 
	g_pTestDlg->RequestOvrsChe(strCode);
}

void COvrsStCurrentDlg::RequestFIDPortfolio(CString strCode)
{ 
	InitListRqDataCtrl(0);
	g_pTestDlg->RequestOvrsFIDPortfolio(strCode);
}

//ǽð 
LONG COvrsStCurrentDlg::SetRealReg(CString strCode, short nRealType)
{
	long nRet(0);

	// ǽð 
	if ( theApp.m_pCommAgent && theApp.m_pCommAgent->GetSafeHwnd() != NULL )
	{
		// (ǽð) Ÿ ûѴ.
		nRet = theApp.m_pCommAgent->RegisterReal(nRealType, (LPCTSTR)strCode );
	}
	else
	{
		AfxMessageBox(" Ǿ  ʽϴ.  ¸ Ȯ Ͻʽÿ. \r\n");
		return 0L;
	}
	return nRet;
}

//ǽð 
LONG COvrsStCurrentDlg::SetRealRemove(CString strCode, short nRealType)
{
	long nRet(0);

	if ( theApp.m_pCommAgent && theApp.m_pCommAgent->GetSafeHwnd() != NULL )
	{
		// (ǽð) Ÿ ûѴ.
		theApp.m_pCommAgent->UnRegisterReal(nRealType, (LPCTSTR)strCode);
	}
	else
	{
		AfxMessageBox(" Ǿ  ʽϴ.  ¸ Ȯ Ͻʽÿ. \r\n");
		return 0L;
	}
	return nRet;
}


void COvrsStCurrentDlg::OnReceiveRealDataChampioncommagentctrl(LPCTSTR sJongmokCode, short nPBID, LPCTSTR sRealData)
{
	switch(nPBID)
	{
		case 231:		//ؿֽ ȣ(ǽð)
		case 241:		//ؿֽ ȣ()
		{
			CString strTemp, strTime, strCode, strOutValue;

			strCode = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("SCODE"));
			strCode.Trim();

			if (m_strCode == strCode)
			{
				// ' Ҽڸ
				int nPlaces = _tstoi(theApp.m_pCommAgent->GetOverseaStockInfo(strCode, 11));

				//ð
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LKORTIME"));
				strTemp.Trim();
				if ( strTemp.GetLength() == 5 )
					strTemp.Insert(0, _T('0'));
				strTime = strTemp.Left(2) + ":" + strTemp.Mid(2,2) + ":" + strTemp.Right(2);
				m_ListHoga.SetItemText(0, 1, strTime);

				CString strOfferName = _T("LOFFER"), strBidName = _T("LBID"), strOfferrest = _T("LOFFERREST"), strBidrest = _T("LBIDREST");
				for (int i = 0; i < 5; i++)
				{
					// ŵȣ
					strTemp.Format(_T("%s%d"), strOfferName, i+1);
					strOutValue = theApp.m_pCommAgent->GetRealOutputData(nPBID, strTemp);
					strOutValue.Trim();
					if(strOutValue != "0")
						strOutValue.Format(_T("%0.*f"), nPlaces, (double)(_ttol(strOutValue) / 10000.0) );
					else
						strOutValue = _T("");
					strOutValue = theApp.SetComma(strOutValue);
					memset(m_Quote.szMaedoHoga[i], 0x00, _countof(m_Quote.szMaedoHoga[i]));
					memcpy(m_Quote.szMaedoHoga[i], strOutValue, strOutValue.GetLength());

					// żȣ
					strTemp.Format(_T("%s%d"), strBidName, i+1);
					strOutValue = theApp.m_pCommAgent->GetRealOutputData(nPBID, strTemp);
					strOutValue.Trim();
					if(strOutValue != "0")
						strOutValue.Format(_T("%0.*f"), nPlaces, (double)(_ttol(strOutValue) / 10000.0) );
					else
						strOutValue = _T("");
					strOutValue = theApp.SetComma(strOutValue);
					memset(m_Quote.szMaesuHoga[i], 0x00, _countof(m_Quote.szMaesuHoga[i]));
					memcpy(m_Quote.szMaesuHoga[i], strOutValue, strOutValue.GetLength());

					// ŵȣ ܷ
					strTemp.Format(_T("%s%d"), strOfferrest, i+1);
					strOutValue = theApp.m_pCommAgent->GetRealOutputData(nPBID, strTemp);
					strOutValue.Trim();
					if(strOutValue == "0")		strOutValue = _T("");
					strOutValue = theApp.SetComma(strOutValue);
					memset(m_Quote.szMaedoHoga_cnt[i], 0x00, _countof(m_Quote.szMaedoHoga_cnt[i]));
					memcpy(m_Quote.szMaedoHoga_cnt[i], strOutValue, strOutValue.GetLength());

					// żȣ
					strTemp.Format(_T("%s%d"), strBidrest, i+1);
					strOutValue = theApp.m_pCommAgent->GetRealOutputData(nPBID, strTemp);
					strOutValue.Trim();
					if(strOutValue == "0")		strOutValue = _T("");
					strOutValue = theApp.SetComma(strOutValue);
					memset(m_Quote.szMaesuHoga_cnt[i], 0x00, _countof(m_Quote.szMaesuHoga_cnt[i]));
					memcpy(m_Quote.szMaesuHoga_cnt[i], strOutValue, strOutValue.GetLength());
				}

				m_ListHoga.SetItemText(1, 1, m_Quote.szMaedoHoga[4]);
				m_ListHoga.SetItemText(2, 1, m_Quote.szMaedoHoga[3]);
				m_ListHoga.SetItemText(3, 1, m_Quote.szMaedoHoga[2]);
				m_ListHoga.SetItemText(4, 1, m_Quote.szMaedoHoga[1]);
				m_ListHoga.SetItemText(5, 1, m_Quote.szMaedoHoga[0]);
				m_ListHoga.SetItemText(6, 1, m_Quote.szMaesuHoga[0]);
				m_ListHoga.SetItemText(7, 1, m_Quote.szMaesuHoga[1]);
				m_ListHoga.SetItemText(8, 1, m_Quote.szMaesuHoga[2]);
				m_ListHoga.SetItemText(9, 1, m_Quote.szMaesuHoga[3]);
				m_ListHoga.SetItemText(10, 1, m_Quote.szMaesuHoga[4]);

				m_ListHoga.SetItemText(1, 0, m_Quote.szMaedoHoga_cnt[4]);
				m_ListHoga.SetItemText(2, 0, m_Quote.szMaedoHoga_cnt[3]);
				m_ListHoga.SetItemText(3, 0, m_Quote.szMaedoHoga_cnt[2]);
				m_ListHoga.SetItemText(4, 0, m_Quote.szMaedoHoga_cnt[1]);
				m_ListHoga.SetItemText(5, 0, m_Quote.szMaedoHoga_cnt[0]);
				m_ListHoga.SetItemText(6, 2, m_Quote.szMaesuHoga_cnt[0]);
				m_ListHoga.SetItemText(7, 2, m_Quote.szMaesuHoga_cnt[1]);
				m_ListHoga.SetItemText(8, 2, m_Quote.szMaesuHoga_cnt[2]);
				m_ListHoga.SetItemText(9, 2, m_Quote.szMaesuHoga_cnt[3]);
				m_ListHoga.SetItemText(10, 2, m_Quote.szMaesuHoga_cnt[4]);
			}

		}
		break;
		case 230:		//ؿֽ ü ü(ǽð)
		case 240:		//ؿֽ ü ü()
		{
			CString strCode, strPrice, strChangeGb, strChange, strRate, strQty, strQtyRate, strTime, strVol, strTemp;

			strCode = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("SCODE"));
			strCode.Trim();

			if (m_strCode == strCode)
			{
				// ' Ҽڸ
				int nPlaces = _tstoi(theApp.m_pCommAgent->GetOverseaStockInfo(strCode, 11));

				//簡
				strPrice = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LCPRICE"));		//簡
				strPrice.Trim();
				if(strPrice != "0")
					strPrice.Format(_T("%0.*f"), nPlaces, (double)(_ttol(strPrice) / 10000.0) );
				strPrice = theApp.SetComma(strPrice);

				//񱸺
				strChangeGb = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("CPCHECK"));	strChangeGb.Trim();
				if (strChangeGb == _T("2"))
				{
					strChangeGb = _T("");
				}
				else if (strChangeGb == _T("5"))
				{
					strChangeGb = _T("");
				}
				else if (strChangeGb == _T("1"))
				{
					strChangeGb = _T("");
				}
				else if (strChangeGb == _T("4"))
				{
					strChangeGb = _T("");
				}
				else
				{
					strChangeGb = _T("");
				}

				//
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LDIFF"));	strTemp.Trim();
				if(strTemp != "0")
					strTemp.Format(_T("%0.*f"), nPlaces, (double)(_ttol(strTemp) / 10000.0) );
				strChange = theApp.SetComma(strTemp);

				//
				strRate.Format(_T("%0.2f"), _ttol(theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LDIFFRATE"))) / 100.0);
				strRate = strRate + "%";

				//ŷ
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LVOLUME"));	strTemp.Trim();
				strQty = theApp.SetComma(strTemp);

				//ϴŷ
				strQtyRate = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LVOLRATE"));	strQtyRate.Trim();

				//ð
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LKORTIME"));		strTemp.Trim();
				strTemp.Trim();
				if ( strTemp.GetLength() == 5 )
					strTemp.Insert(0, _T('0'));
				strTime = strTemp.Left(2) + ":" + strTemp.Mid(2,2) + ":" + strTemp.Right(2);

				//üᷮ
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LCURVOLUME"));	strTemp.Trim();
				strVol = theApp.SetComma(strTemp);

				//簡 Ʈ
				m_ListNow.SetItemText(0, 0, strPrice);
				m_ListNow.SetItemText(0, 1, strChangeGb);
				m_ListNow.SetItemText(0, 2, strChange);
				m_ListNow.SetItemText(0, 3, strRate);
				m_ListNow.SetItemText(0, 4, strQty);
				m_ListNow.SetItemText(0, 5, strQtyRate);

				//ð Ʈ
				m_ListTick.InsertItem(0, _T(""));
				m_ListTick.SetItemText(0, 0, strTime);	//ð
				m_ListTick.SetItemText(0, 1, strPrice);	//üᰡ
				m_ListTick.SetItemText(0, 2, strVol);	//üᷮ
				m_ListTick.SetItemText(0, 3, strQty);	//ŷ
			}
		}
		break;
	}
}

// FID Ÿ  ̺Ʈ
void COvrsStCurrentDlg::OnReceiveFidDataChampioncommagentctrl(long nRqId, LPCTSTR sTrCode, LPCTSTR sData, long nDataLength,	LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage, LPCTSTR sSplmMsg)
{
	CString strTrCode(sTrCode);

	if (strTrCode == RQ_FIDNAME_OVERSEAS_STOCK)
	{	// ü
		ReceiveFIDPortfolio( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
}


void COvrsStCurrentDlg::OnBnClickedBtnJongmokStock()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	OnBnClickedBtnSearch();
	
}
// 
	
void COvrsStCurrentDlg::OnBnClickedBtnJongmokFo()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	OnBnClickedBtnSearch();
}

void COvrsStCurrentDlg::OnBnClickedBtnRqVI()
{
	RequestFIDPortfolio(RQ_FID_OVERSEAS_REQUEST_CODE);
		// ǽð ȣ  ϱ
	int nStartIndex = 0; int nFoundIndex =0; int nSize = 0;
	CString sTemp=_T("");
	CString	strCodeList=_T("");
	CString strExpCode=_T("");
	CString strKeyString = RQ_FID_OVERSEAS_REQUEST_CODE;
	strKeyString += _T(",");
	while( (nFoundIndex = strKeyString.Find(",", nStartIndex)) != -1 )
	{
		sTemp = strKeyString.Mid( nStartIndex, nFoundIndex - nStartIndex);
		sTemp.Trim();

		if(sTemp.IsEmpty())
		{
			nStartIndex = nFoundIndex + 1;
			continue;
		}
		sTemp.Remove(',');
		if(nSize < 100)	// ǽð ѹ   ִ Ű   ִ 100̴.
		{
			nSize++;
			nStartIndex = nFoundIndex + 1;
			strCodeList += sTemp;
			strCodeList += _T(";");
		}
		else
		{
			break;
		}
	}
	int nRet=0;

	nRet = SetRealReg(strCodeList, 230);
	nRet = SetRealReg(strCodeList, 231);
}


// TR Ÿ  ̺Ʈ
void COvrsStCurrentDlg::OnReceiveTrDataChampioncommagentctrl(long nRqId, LPCTSTR sTrCode, LPCTSTR sData, long nDataLength,	LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage, LPCTSTR sSplmMsg)
{
	CString strTrCode(sTrCode);

	if (strTrCode == RQ_TRNAME_OVERSEAS_PRICE)
	{	// ؿֽ Master (簡, )
		ReceiveTrSise( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
	else if (strTrCode == RQ_TRNAME_OVERSEAS_HOGA)
	{	// ؿֽ  켱ȣ
		ReceiveTrHoga( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
	else if (strTrCode == RQ_TRNAME_OVERSEAS_CHE)
	{	// ؿֽü
		ReceiveTrChe( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
}

void COvrsStCurrentDlg::ReceiveTrSise(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strCode, strTime, strPrice, strVolume, strPrevVolume, strTemp;
	int		nDataCnt = 0, nDataOffset = 0, nPlaces = 0;

	if ( nDataLength > 0 )
	{
		CString strOutValue = _T("");
//		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_PRICE, _T("OutRec1"), _T("SKORNAME"), 0);		//Ī(20)
// 		strTime		= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_PRICE, _T("OutRec1"), _T("LTIME"), 0);			//ð(4)
// 		strTime.Trim();
// 		if ( strTime.GetLength() == 5 )
// 			strTime.Insert(0, _T('0'));
// 		strTemp = strTime.Left(2) + ":" + strTime.Mid(2,2) + ":" + strTime.Right(2);
// 		m_ListHoga.SetItemText(0, 1, strTemp);

		// ' Ҽڸ
		nPlaces = _tstoi(theApp.m_pCommAgent->GetOverseaStockInfo(m_strCode, 11));

		strPrice	= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_PRICE, _T("OutRec1"), _T("LCPRICE"), 0);		//簡(4)
		strPrice.Trim();
		if(strPrice != "0")
			strPrice.Format(_T("%0.*f"), nPlaces, (double)(_ttol(strPrice) / 10000.0) );
		m_ListNow.SetItemText(0, 0, theApp.SetComma(strPrice));	//簡

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_PRICE, _T("OutRec1"), _T("LPAR"), 0);			//׸鰡(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_PRICE, _T("OutRec1"), _T("LDIFF"), 0);			//ϴ(4)
		strOutValue.Trim();
		if(strOutValue != "0")
			strOutValue.Format(_T("%0.*f"), nPlaces, (double)(_ttol(strOutValue) / 10000.0) );
		m_ListNow.SetItemText(0, 2, theApp.SetComma(strOutValue));	//

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_PRICE, _T("OutRec1"), _T("CPCHECK"), 0);		//ȣ(1)
		if(strOutValue == _T("2"))
			strOutValue = _T("");
		else if(strOutValue == _T("5"))
			strOutValue = _T("");
		else if (strOutValue == _T("1"))
			strOutValue = _T("");
		else if (strOutValue == _T("4"))
			strOutValue = _T("");
		else
			strOutValue = _T("");
		m_ListNow.SetItemText(0, 1, strOutValue);	//ȣ

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_PRICE, _T("OutRec1"), _T("LBPRICE"), 0);		//ذ(4)
		strOutValue.Trim();
		if(strOutValue != "0")
			strOutValue.Format(_T("%0.*f"), nPlaces, (double)(_ttol(strOutValue) / 10000.0) );

		//	  = ((簡-ذ)/ذ)*100
		strTemp.Format(_T("%0.2f"), (double)(_ttof(strPrice) - _ttof(strOutValue)) / _ttof(strOutValue) * 100.0 );
		if (strTemp == "0.00") strTemp = "0";
		strTemp = strTemp + "%";
		m_ListNow.SetItemText(0, 3, strTemp);	//
		
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_PRICE, _T("OutRec1"), _T("LOPRICE"), 0);		//ð(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_PRICE, _T("OutRec1"), _T("LHPRICE"), 0);		//(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_PRICE, _T("OutRec1"), _T("LLPRICE"), 0);		//(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_PRICE, _T("OutRec1"), _T("LULIMITPRICE"), 0);	//Ѱ(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_PRICE, _T("OutRec1"), _T("LLLIMITPRICE"), 0);	//Ѱ(4)
		strVolume	= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_PRICE, _T("OutRec1"), _T("LVOLUME"), 0);		//ŷ(4)
		m_ListNow.SetItemText(0, 4, theApp.SetComma(strVolume));	//ŷ

//		strPrevVolume = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_PRICE, _T("OutRec1"), _T("LLSTVOLUME"), 0);		//ϰŷ(4)

		//ŷ
		strTemp = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_PRICE, _T("OutRec1"), _T("VOLTURN_RATE"), 0);		//ŷȸ(4)
		strTemp.Format(_T("%0.2f"), _ttof(strTemp) / 100.0 );
		strTemp = strTemp + "%";
		// =IF(OR(ŷ==0,ϰŷ==0),"0",IF(ŷ>ϰŷ,(ŷ/ϰŷ)*100,IF((ŷ/ϰŷ)<0.0001,"0",(ŷ/ϰŷ)*100*-1)))
// 		long nVolume = _ttol(strVolume), nPrevVolume = _ttol(strPrevVolume);
// 		if ( nVolume == 0 || nPrevVolume == 0)
// 			strTemp = _T("0");
// 		else
// 		{
// 			if (nVolume > nPrevVolume)
// 				strTemp.Format(_T("%0.2f"), (double)(nVolume / nPrevVolume) * 100.0 );
// 			else 
// 			{
// 				if ( (nVolume / nPrevVolume) < 0.0001 )
// 					strTemp = _T("0");
// 				else
// 					strTemp.Format(_T("%0.2f"), (double)(nVolume / nPrevVolume) * 100.0 * -1 );
// 			}
// 		}
		m_ListNow.SetItemText(0, 5, strTemp);	//ŷ

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_PRICE, _T("OutRec1"), _T("SNAME"), 0);			//Ī(20)
	}
}

void COvrsStCurrentDlg::ReceiveTrHoga(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
//	InitListRqDataCtrl(0);

	CString strCode, strTime, strPrice, strVolume, strPrevVolume, strTemp;
	int		nDataCnt = 0, nDataOffset = 0;

	if ( nDataLength > 0 )
	{
		CString strOutValue = _T("");

		// ' Ҽڸ
		int nPlaces = _tstoi(theApp.m_pCommAgent->GetOverseaStockInfo(m_strCode, 11));

		CString strOfferName = _T("LOFFER"), strBidName = _T("LBID"), strOfferrest = _T("LOFFERREST"), strBidrest = _T("LBIDREST");
		for (int i = 0; i < 5; i++)
		{
			// ŵȣ
			strTemp.Format(_T("%s%d"), strOfferName, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_HOGA, _T("OutRec1"), strTemp, 0);
			strOutValue.Trim();
			if(strOutValue == "0")
				strOutValue = _T("");
			else
			{
				strTemp.Format(_T("%0.*f"), nPlaces, (double)(_ttol(strOutValue) / 10000.0) );
				strOutValue = theApp.SetComma(strTemp);
			}
			memset(m_Quote.szMaedoHoga[i], 0x00, _countof(m_Quote.szMaedoHoga[i]));
			memcpy(m_Quote.szMaedoHoga[i], strOutValue, strOutValue.GetLength());

			// żȣ
			strTemp.Format(_T("%s%d"), strBidName, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_HOGA, _T("OutRec1"), strTemp, 0);
			strOutValue.Trim();
			if(strOutValue == "0")
				strOutValue = _T("");
			else
			{
				strTemp.Format(_T("%0.*f"), nPlaces, (double)(_ttol(strOutValue) / 10000.0) );
				strOutValue = theApp.SetComma(strTemp);
			}
			memset(m_Quote.szMaesuHoga[i], 0x00, _countof(m_Quote.szMaesuHoga[i]));
			memcpy(m_Quote.szMaesuHoga[i], strOutValue, strOutValue.GetLength());

			// ŵȣ ܷ
			strTemp.Format(_T("%s%d"), strOfferrest, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_HOGA, _T("OutRec1"), strTemp, 0);
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strOutValue = theApp.SetComma(strOutValue);
			memset(m_Quote.szMaedoHoga_cnt[i], 0x00, _countof(m_Quote.szMaedoHoga_cnt[i]));
			memcpy(m_Quote.szMaedoHoga_cnt[i], strOutValue, strOutValue.GetLength());

			// żȣ ܷ
			strTemp.Format(_T("%s%d"), strBidrest, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_HOGA, _T("OutRec1"), strTemp, 0);
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strOutValue = theApp.SetComma(strOutValue);
			memset(m_Quote.szMaesuHoga_cnt[i], 0x00, _countof(m_Quote.szMaesuHoga_cnt[i]));
			memcpy(m_Quote.szMaesuHoga_cnt[i], strOutValue, strOutValue.GetLength());
		}

		m_ListHoga.SetItemText(1, 1, m_Quote.szMaedoHoga[4]);
		m_ListHoga.SetItemText(2, 1, m_Quote.szMaedoHoga[3]);
		m_ListHoga.SetItemText(3, 1, m_Quote.szMaedoHoga[2]);
		m_ListHoga.SetItemText(4, 1, m_Quote.szMaedoHoga[1]);
		m_ListHoga.SetItemText(5, 1, m_Quote.szMaedoHoga[0]);
		m_ListHoga.SetItemText(6, 1, m_Quote.szMaesuHoga[0]);
		m_ListHoga.SetItemText(7, 1, m_Quote.szMaesuHoga[1]);
		m_ListHoga.SetItemText(8, 1, m_Quote.szMaesuHoga[2]);
		m_ListHoga.SetItemText(9, 1, m_Quote.szMaesuHoga[3]);
		m_ListHoga.SetItemText(10, 1, m_Quote.szMaesuHoga[4]);

		m_ListHoga.SetItemText(1, 0, m_Quote.szMaedoHoga_cnt[4]);
		m_ListHoga.SetItemText(2, 0, m_Quote.szMaedoHoga_cnt[3]);
		m_ListHoga.SetItemText(3, 0, m_Quote.szMaedoHoga_cnt[2]);
		m_ListHoga.SetItemText(4, 0, m_Quote.szMaedoHoga_cnt[1]);
		m_ListHoga.SetItemText(5, 0, m_Quote.szMaedoHoga_cnt[0]);
		m_ListHoga.SetItemText(6, 2, m_Quote.szMaesuHoga_cnt[0]);
		m_ListHoga.SetItemText(7, 2, m_Quote.szMaesuHoga_cnt[1]);
		m_ListHoga.SetItemText(8, 2, m_Quote.szMaesuHoga_cnt[2]);
		m_ListHoga.SetItemText(9, 2, m_Quote.szMaesuHoga_cnt[3]);
		m_ListHoga.SetItemText(10, 2, m_Quote.szMaesuHoga_cnt[4]);

	}
}

void COvrsStCurrentDlg::ReceiveTrChe(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	//	InitListRqDataCtrl(0);

	CString strCode, strTime, strPrice, strVolume, strPrevVolume, strTemp;
	int		nDataCnt = 0, nDataOffset = 0;

	if ( nDataLength > 0 )
	{
		long nRowCount = theApp.m_pCommAgent->GetTranOutputRowCnt(RQ_TRNAME_OVERSEAS_CHE, _T("OutRec1"));						//  Ǽ

		// ' Ҽڸ
		int nPlaces = _tstoi(theApp.m_pCommAgent->GetOverseaStockInfo(m_strCode, 11));

		CString strOutValue = _T("");
		for (int i = 0; i < nRowCount; i++)
		{ 	
			//	 ߰
			m_ListTick.InsertItem(i, _T(""));

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_CHE, _T("OutRec1"), _T("LTIME"), i);		//ð
			strOutValue.Trim();
			if ( strOutValue.GetLength() == 5 )
				strOutValue.Insert(0, _T('0'));
			strTemp.Format(_T("%s:%s:%s"), strOutValue.Left(2), strOutValue.Mid(2,2), strOutValue.Right(2));
			m_ListTick.SetItemText(i, 0, strTemp);	//ð

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_CHE, _T("OutRec1"), _T("LCPRICE"), i);		//簡
			strOutValue.Trim();
			if(strOutValue == "0")
				strOutValue = _T("");
			else
			{
				strTemp.Format(_T("%0.*f"), nPlaces, (double)(_ttol(strOutValue) / 10000.0) );
				strOutValue = theApp.SetComma(strTemp);
			}
			m_ListTick.SetItemText(i, 1, strTemp);	//簡

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_CHE, _T("OutRec1"), _T("LNETVOLUME"), i);	//üᷮ
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strTemp = theApp.SetComma(strOutValue);
			m_ListTick.SetItemText(i, 2, strTemp);	//üᷮ

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVERSEAS_CHE, _T("OutRec1"), _T("LVOLUME"), i);		//ŷ
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strTemp = theApp.SetComma(strOutValue);
			m_ListTick.SetItemText(i, 3, strTemp);	//ŷ

		}
	}
}


void COvrsStCurrentDlg::ReceiveFIDPortfolio(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	//	InitListRqDataCtrl(0);

	CString strCode, strTime, strPrice, strVolume, strPrevVolume, strTemp;
	int		nDataCnt = 0, nDataOffset = 0;

	if ( nDataLength > 0 )
	{
		long nRowCount = theApp.m_pCommAgent->GetFidOutputRowCnt(nRqId);						//  Ǽ

		// ' Ҽڸ
		int nPlaces = 0;	// = _tstoi(theApp.m_pCommAgent->GetOverseaStockInfo(m_strCode, 11));

		CString strOutValue = _T("");
		long	nValue = 0;
		for (int i = 0; i < nRowCount; i++)
		{ 	
			//	 ߰
			m_ListRqData.InsertItem(i, _T(""));

			strOutValue = theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("153"), i);		strOutValue.Trim();
			m_ListRqData.SetItemText(i, 0, theApp.m_pCommAgent->GetShCode(strOutValue));	//ڵ(153)

			// ' Ҽڸ
			nPlaces = _tstoi(theApp.m_pCommAgent->GetOverseaStockInfo(strOutValue, 11));

			strOutValue = theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("154"), i);		strOutValue.Trim();
			m_ListRqData.SetItemText(i, 1, strOutValue);	//(154)

			nValue = _ttol(theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("000"), i));
			strOutValue.Format(_T("%0.*f"), nPlaces, nValue / 10000.0);
			m_ListRqData.SetItemText(i, 2, theApp.SetComma(strOutValue));	//簡(000)

			nValue = _ttol(theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("002"), i));
			strOutValue.Format(_T("%0.*f"), nPlaces, nValue / 10000.0);
			m_ListRqData.SetItemText(i, 3, theApp.SetComma(strOutValue));	//ϴ(002)

			strOutValue.Format(_T("%0.2f"), _ttof(theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("003"), i)) / 100.0);
			m_ListRqData.SetItemText(i, 4, strOutValue + _T("%"));	//(003)

			strOutValue.Format(_T("%ld"), _ttol(theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("004"), i)));
			m_ListRqData.SetItemText(i, 5, theApp.SetComma(strOutValue));	//ŷ(004)

			nValue = _ttol(theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("011"), i));
			strOutValue.Format(_T("%0.*f"), nPlaces, nValue / 10000.0);
			m_ListRqData.SetItemText(i, 6, theApp.SetComma(strOutValue));	//Ѱ(011)

			nValue = _ttol(theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("012"), i));
			strOutValue.Format(_T("%0.*f"), nPlaces, nValue / 10000.0);
			m_ListRqData.SetItemText(i, 7, theApp.SetComma(strOutValue));	//Ѱ(012)

			nValue = _ttol(theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("013"), i));
			strOutValue.Format(_T("%0.*f"), nPlaces, nValue / 10000.0);
			m_ListRqData.SetItemText(i, 8, theApp.SetComma(strOutValue));	//ð(013)

			nValue = _ttol(theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("014"), i));
			strOutValue.Format(_T("%0.*f"), nPlaces, nValue / 10000.0);
			m_ListRqData.SetItemText(i, 9, theApp.SetComma(strOutValue));	//(014)

			nValue = _ttol(theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("015"), i));
			strOutValue.Format(_T("%0.*f"), nPlaces, nValue / 10000.0);
			m_ListRqData.SetItemText(i, 10, theApp.SetComma(strOutValue));	//(015)
		}
	}
}