
// OvrsStckOrderDlg.cpp :  
//

#include "stdafx.h"
#include "ChampionAgentTest.h"
#include "ChampionAgentTestDlg.h"
#include "OvrsStckOrderDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// COvrsStckOrderDlg ȭ 

COvrsStckOrderDlg::COvrsStckOrderDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(COvrsStckOrderDlg::IDD, pParent)
	, m_bSiseOnly(FALSE)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);	
}

void COvrsStckOrderDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_OUTPUT,			m_edOutput);
	DDX_Control(pDX, IDC_OUTMSG,			m_edOutMsg);
	DDX_Control(pDX, IDC_OUTMSG_Real,		m_edOutMsg_real);
	DDX_Control(pDX, IDC_ACCOUNT_ED,		m_CtrlEdAccNoCtl);
	DDX_Control(pDX, IDC_ACCNAME_ED,		m_CtrlEdAccName);
	DDX_Control(pDX, IDC_ACCPWD_ED,			m_CtrlEdAccPwd);
	DDX_Control(pDX, IDC_CODE_ED,			m_CtrlEdCode);
	DDX_Control(pDX, IDC_COND_CB,			m_CtrlCbOrdType);
	DDX_Control(pDX, IDC_QTY_ED,			m_CtrlEdQty);
	DDX_Control(pDX, IDC_PRICE_ED,			m_CtrlEdPrice);
	DDX_Control(pDX, IDC_ORDNO_ED,			m_CtrlEdOrdNo);
	DDX_Control(pDX, IDC_SRCORDNO_ED,		m_CtrlSrcOrdNo);
	DDX_Control(pDX, IDC_OUTSTDORD_LIST,	m_CtrlListOutStdOrd);
	DDX_Control(pDX, IDC_STOCK_LIST,		m_CtrlListStock);
	DDX_Control(pDX, IDC_EXCODE_CB,			m_CtrlCbExchangeType);
	DDX_Control(pDX, IDC_ORDERDATE,			m_CtrlCreditDate);
	
}

BEGIN_MESSAGE_MAP(COvrsStckOrderDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()

	ON_WM_DESTROY()
	ON_WM_CLOSE()

	ON_BN_CLICKED(IDC_OFFER_ORDER,				&COvrsStckOrderDlg::OnBnClickedOfferOrder)
	ON_BN_CLICKED(IDC_BID_ORDER,				&COvrsStckOrderDlg::OnBnClickedBidOrder)
	ON_BN_CLICKED(IDC_CORRECT_ORDER,			&COvrsStckOrderDlg::OnBnClickedCorrectOrder)
	ON_BN_CLICKED(IDC_CANCEL_ORDER,				&COvrsStckOrderDlg::OnBnClickedCancelOrder)
	ON_BN_CLICKED(IDC_OUTSTDORDER,				&COvrsStckOrderDlg::OnBnClickedOutstdorder)
	ON_BN_CLICKED(IDC_STOCK_BTN,				&COvrsStckOrderDlg::OnBnClickedStockBtn)
	ON_BN_CLICKED(IDC_STOCKACCINFO_BTN,			&COvrsStckOrderDlg::OnBnClickedStockaccinfoBtn)
	ON_BN_CLICKED(IDC_STOCK_JAN_BTN,			&COvrsStckOrderDlg::OnBnClickedStockJanBtn)
	ON_CBN_SELCHANGE(IDC_ACCOUNT_CM,			&COvrsStckOrderDlg::OnCbnSelchangeCmbCon)
END_MESSAGE_MAP()

// COvrsStckOrderDlg ޽ ó
BOOL COvrsStckOrderDlg::PreTranslateMessage(MSG* pMsg) 
{
	if (pMsg->message == WM_KEYUP)
	{
		if (pMsg->wParam == VK_RETURN)
		{
			return TRUE;
		}
	}
	else if (pMsg->message == WM_KEYDOWN)
	{
		if (pMsg->wParam == VK_ESCAPE)
			return TRUE;

		if (pMsg->wParam == VK_RETURN)
			return TRUE;
	}

	return CDialogEx::PreTranslateMessage(pMsg);
}

BOOL COvrsStckOrderDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	//  ȭ   մϴ.  α׷  â ȭ ڰ ƴ 쿡
	//  ӿũ  ۾ ڵ մϴ.
	SetIcon(m_hIcon, TRUE);			// ū  մϴ.
	SetIcon(m_hIcon, FALSE);		//   մϴ.

	// ü Ʈ  ŸƲ
	m_CtrlListOutStdOrd.InsertColumn( 0, _T("ֹȣ"),			LVCFMT_LEFT, 60,  0);
	m_CtrlListOutStdOrd.InsertColumn( 1, _T("Ÿű"),			LVCFMT_CENTER, 60,  1);
	m_CtrlListOutStdOrd.InsertColumn( 2, _T("ֹ"),			LVCFMT_CENTER, 60,	2);
	m_CtrlListOutStdOrd.InsertColumn( 3, _T(""),			LVCFMT_LEFT, 80,	3);
	m_CtrlListOutStdOrd.InsertColumn( 4, _T("ֹ"),			LVCFMT_RIGHT, 80,  4);
	m_CtrlListOutStdOrd.InsertColumn( 5, _T("ֹ"),			LVCFMT_RIGHT, 60,  5);
	m_CtrlListOutStdOrd.InsertColumn( 6, _T("ü"),			LVCFMT_RIGHT, 60,	6);
	m_CtrlListOutStdOrd.InsertColumn( 8, _T("ֹȣ"),		LVCFMT_CENTER, 70,  8);
	m_CtrlListOutStdOrd.InsertColumn( 9, _T(""),				LVCFMT_CENTER, 80,  9);
	m_CtrlListOutStdOrd.InsertColumn(10, _T("ֹð"),			LVCFMT_CENTER, 70, 10);
	m_CtrlListOutStdOrd.InsertColumn(11, _T("ڵ"),			LVCFMT_LEFT, 80, 11);
	m_CtrlListOutStdOrd.InsertColumn(12, _T("ŷ"),			LVCFMT_CENTER, 60, 12);
	m_CtrlListOutStdOrd.ModifyStyle(LVS_TYPEMASK, LVS_REPORT);

	// ܰ Ʈ  ŸƲ
	m_CtrlListStock.InsertColumn( 0, _T("ڵ"),		LVCFMT_LEFT, 80,  0);
	m_CtrlListStock.InsertColumn( 1, _T(""),		LVCFMT_LEFT, 80,  1);
	m_CtrlListStock.InsertColumn( 2, _T("屸"),		LVCFMT_LEFT, 60,  2);
	m_CtrlListStock.InsertColumn( 3, _T(""),		LVCFMT_RIGHT, 60,	3);
	m_CtrlListStock.InsertColumn( 4, _T("ŵ"),		LVCFMT_RIGHT, 60,	4);
	m_CtrlListStock.InsertColumn( 5, _T("Դܰ"),		LVCFMT_RIGHT, 80,  5);
	m_CtrlListStock.InsertColumn( 6, _T("簡"),		LVCFMT_RIGHT, 80,  6);
	m_CtrlListStock.InsertColumn( 7, _T("򰡼"),		LVCFMT_RIGHT, 80,	7);
	m_CtrlListStock.InsertColumn( 8, _T(""),		LVCFMT_RIGHT, 60,	8);
	m_CtrlListStock.InsertColumn( 9, _T("򰡱ݾ"),		LVCFMT_RIGHT, 80,  9);
	m_CtrlListStock.InsertColumn(10, _T("Աݾ"),		LVCFMT_RIGHT, 80, 10);
	m_CtrlListStock.ModifyStyle(LVS_TYPEMASK, LVS_REPORT);

	m_CtrlCbOrdType.AddString(_T(""));												// ֹ Setting
	m_CtrlCbOrdType.AddString(_T("尡"));
	m_CtrlCbOrdType.AddString(_T("MOO"));
	m_CtrlCbOrdType.AddString(_T("MOC"));
	m_CtrlCbOrdType.AddString(_T("LOO"));
	m_CtrlCbOrdType.AddString(_T("LOC"));
	m_CtrlCbOrdType.AddString(_T("TWAP"));
	m_CtrlCbOrdType.AddString(_T("VWAP"));
	m_CtrlCbOrdType.SetCurSel(0);

	m_CtrlCbExchangeType.AddString(_T("ü"));												// "%"
	m_CtrlCbExchangeType.AddString(_T("̱ Ƹ߽, ,  "));					// "020"
	m_CtrlCbExchangeType.AddString(_T("߱()"));								// "014"
	m_CtrlCbExchangeType.AddString(_T("߱õ()"));								// "018"
	m_CtrlCbExchangeType.AddString(_T("ȫ()"));									// "001"
	m_CtrlCbExchangeType.SetCurSel(0);

	SetAccNo();

	CString strId;
	strId = theApp.m_strUserID;		//theApp.m_CommAgent.GetLoginInfo(_T("USER_ID"));

	SetRealCode(1, strId);		// ؿֽ ֹ  ü  
//	SetRealCode(2, strId);		// ؿֽ ֹ  ü  

	return TRUE;  // Ŀ Ʈѿ   TRUE ȯմϴ.
}

// ȭ ڿ ּȭ ߸ ߰   ׸
//  Ʒ ڵ尡 ʿմϴ. /  ϴ MFC  α׷ 쿡
//  ӿũ  ۾ ڵ մϴ.

void COvrsStckOrderDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // ׸⸦  ̽ ؽƮԴϴ.

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Ŭ̾Ʈ 簢   ϴ.
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		//  ׸ϴ.
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// ڰ ּȭ â  ȿ Ŀ ǥõǵ ýۿ
//   Լ ȣմϴ.
HCURSOR COvrsStckOrderDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void COvrsStckOrderDlg::OnDestroy()
{
	CString strId;
	strId = theApp.m_strUserID;		//theApp.m_CommAgent.GetLoginInfo(_T("USER_ID"));

	if (!strId.IsEmpty())
	{
		UnSetRealCode(1, strId);		// ؿֽ ֹ  ü  
	}

	CDialog::OnDestroy();
}

void COvrsStckOrderDlg::OnClose()
{
	CString strId;
	strId = theApp.m_strUserID;		//theApp.m_CommAgent.GetLoginInfo(_T("USER_ID"));

	if (!strId.IsEmpty())
	{
		UnSetRealCode(1, strId);	// ؿֽ ֹ  ü  
	}
	
	CDialog::OnClose();
}

/////////////////////    (TR, FID  ) //////////////////////
// sPreNext ('0':Ѵ , '1': , '2': , '3':Ѵ )

// TR Ÿ  ̺Ʈ
void COvrsStckOrderDlg::OnReceiveTrDataChampioncommagentctrl(long nRqId, LPCTSTR sTrCode, LPCTSTR sData, long nDataLength,
														LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage, LPCTSTR sSplmMsg)
{
	CString strTemp;
	CString strData;
	m_edOutMsg.SetWindowText(_T(""));
	m_edOutput.SetWindowText(_T(""));
	m_CtrlEdOrdNo.SetWindowText(_T(""));
// 	m_CtrlListOutStdOrd.DeleteAllItems();
// 	m_CtrlListStock.DeleteAllItems();

	m_CtrlSrcOrdNo.SetWindowText( _T("") );	// ֹȣ
	m_CtrlEdOrdNo.SetWindowText( _T("") );	// ֹȣ


	strData.Format("RQID		: %d\r\n", nRqId);
	strTemp.Format("TR CODE		: %s\r\n", sTrCode);
	strData += strTemp;

	if ( strcmp(RQ_TRNAME_OVRS_BS_ORDER, sTrCode) == 0)					//	ؿ ŵ, ż ֹ 
	{
		ReceiveTrSendOrder(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage, 1);
	}
	else if ( strcmp(RQ_TRNAME_OVRS_MC_ORDER, sTrCode) == 0)			//	ؿ ,  ֹ 
	{
		ReceiveTrSendOrder(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage, 2);
	}
	else if ( strcmp(RQ_TRNAME_OVRS_ORDER_CHE, sTrCode) == 0)			//	ؿںֹü᳻ȸ
	{
		ReceiveTrStockChekeyol( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
	else if ( strcmp(RQ_TRNAME_OVRS_ORDER_MICHE, sTrCode) == 0)			//	ؿǴϹü᳻ȸ
	{
		ReceiveTrStockChekeyol( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
	else if ( strcmp(RQ_TRNAME_OVRS_ORDER_EXCHANGE, sTrCode) == 0)		//	ֱ ȯ ȸ
	{
		ReceiveTrOvrsExchange( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
	else if ( strcmp(RQ_TRNAME_OVRS_ORDER_DEPOSIT, sTrCode) == 0)		//	ؿֽ Źȸ
	{
		ReceiveTrStockAccInfo( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
	else if ( strcmp(RQ_TRNAME_OVRS_ORDER_JAN, sTrCode) == 0)		//	ؿ  ֽ   ȸ
	{
		ReceiveTrOvrsJango( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
	
	
	
	

	
// 	if ( strcmp( TR_SACA609Q1, sTrCode) == 0 )
// 	{
// 		ReceiveTrStockJango( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
// 	}
// 	else if ( strcmp( TR_SACA073Q2, sTrCode) == 0 ) 
// 	{
// 		ReceiveTrStockChekeyol( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
// 	}
// 	else if ( strcmp( TR_SAFA000Q7 , sTrCode) == 0 )
// 	{
// 		ReceiveTrFOJango( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
// 	}
// 	else if ( strcmp( TR_SAFA000Q5, sTrCode) == 0 )
// 	{
// 		ReceiveTrFOCheKyeol( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
// 	}
// 	else if ( strcmp( TR_SAFZ881Q1, sTrCode) == 0 )
// 	{
// 		ReceiveTrFOAccInfo( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
// 	}
// 	else if ( strcmp( TR_SACA314Q1, sTrCode) == 0 )
// 	{
// 		ReceiveTrStockAccInfo( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
// 	}
// 	else if ( strcmp(TR_SAFZ812Q1, sTrCode) == 0)
// 	{
// 		ReceiveTrFOAccBalance(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage);
// 	}
// 	else if ( strcmp(TR_SAFZ824Q1, sTrCode) == 0)
// 	{
// 		ReceiveTrFOGainLoss(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage);
// 	}
// 	else if ( strcmp(TR_SACA001U1, sTrCode) == 0)
// 	{
// 		ReceiveTrSendOrder(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage, 1);
// 	}
// 	else if ( strcmp(TR_SACA002U1, sTrCode) == 0)
// 	{
// 		ReceiveTrSendOrder(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage, 2);
// 	}
// 	else if ( strcmp(TR_SAFA110C1, sTrCode) == 0)
// 	{
// 		ReceiveTrSendOrder(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage, 3);
// 	}
// 	else if ( strcmp(TR_SAFA110C2, sTrCode) == 0)
// 	{
// 		ReceiveTrSendOrder(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage, 4);
// 	}

	m_strTrPreNext = sPreNext;

	strTemp.Format("	: %s\r\n", sPreNext);
	strData += strTemp;
	strTemp.Format("ڵ		: %s\r\n", sErrorCode);
	strData += strTemp;
	strTemp.Format("޼		: %s\r\n", sMessage);
	strData += strTemp;
	strTemp.Format("޼		: %s\r\n", sSplmMsg);
	strData += strTemp;
	strTemp.Format(" Ÿ		: %s\r\n", sData);
	strData += strTemp;

	m_edOutMsg.SetWindowText(strData);
}

// ǽð 
void COvrsStckOrderDlg::OnReceiveRealDataChampioncommagentctrl(LPCTSTR sJongmokCode, short nPBID, LPCTSTR sRealData)
{
	CString strTemp , strData, strITMSCode;
	switch(nPBID)
	{
	case 204:	// ؿֽ ü
		{
			CString strOderID, strOrorID, strQty, strPrice, strMEDOSU, strORDST, strJUGB, strTime;

			strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("ITEM_COD"));
			strTemp.Trim();
			strITMSCode = strTemp;	//theApp.m_pCommAgent->GetShCode(strTemp);				//	ڵ

			strOderID = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("ORD_NO"));		//	ֹȣ
			strOderID.Trim();

			strMEDOSU = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("BUY_SEL_TR_TCD"));//	ŵż
			if ( strMEDOSU == _T("1") )
				strMEDOSU	= _T("ŵ");
			else
				strMEDOSU	= _T("ż");

			strORDST = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("ORDST"));			//	ֹ
			if (strORDST != _T("21"))
			{
				// ֹ
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("JQTY"));
				strTemp.Trim();
				strQty.Format		("%ld", _tstol(strTemp));
				strQty = theApp.SetComma(strQty);

				// ֹ
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("JPRC"));
				strTemp.Trim();
				strPrice.Format		("%0.4f", _tstof(strTemp) );

				strPrice = theApp.SetComma(strPrice);
			}
			else
			{
				// ü
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("CHEQTY"));
				strTemp.Trim();
				strQty.Format		("%ld", _tstol(strTemp));
				strQty = theApp.SetComma(strQty);

				// üᰡ
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("CHEPRICE"));
				strTemp.Trim();
				strPrice.Format		("%0.4f", _tstof(strTemp) );

				strPrice = theApp.SetComma(strPrice);
			}

			if		(strORDST == _T("21"))
				strORDST = (strMEDOSU + _T("ü"));
			else if (strORDST == _T("22"))
				strORDST = (strMEDOSU + _T(""));	//strOrdst = _T("Ȯ");
			else if (strORDST == _T("23"))
				strORDST = (strMEDOSU + _T(""));	//strOrdst = _T("Ȯ");
			else if (strORDST == _T("25"))
				strORDST = (strMEDOSU + _T(""));	//	strOrdst = _T("");
			else if (strORDST == _T("24"))
				strORDST = (strMEDOSU + _T("ź"));
			else
				strORDST = (strMEDOSU + _T(""));

			strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("JUGB"));		//	ֹ
			if		((strTemp == _T("03")) || (strTemp == _T("04")))
				strJUGB = _T("");
			else if ((strTemp == _T("53")) || (strTemp == _T("54")))
				strJUGB = _T("");
			else if ((strTemp == _T("11")) || (strTemp == _T("12")))
				strJUGB = _T("");
			else
				strJUGB = _T("");

			strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("CHETIME"));		strTemp.Trim();	//	ֹ/ü ð
			strTemp.Trim();
			if ( strTemp.GetLength() == 5 )
				strTemp.Insert(0, _T('0'));
			strTime = strTemp.Left(2) + ":" + strTemp.Mid(2,2) + ":" + strTemp.Right(2);


			strData.Format("[ǽð ؿֽ Ȯâ] --> ");
			strTemp.Format("%s %s\r\n", strJUGB, strORDST);
			strData += strTemp;
			strTemp.Format("    ڵ : [%s]   ֹȣ : [%s]\r\n", strITMSCode, strOderID);
			strData += strTemp;
			strTemp.Format("     : [%s]    : [%s]", strQty,strPrice);
			strData += strTemp;
			m_edOutMsg_real.SetWindowText(strData);
		}
		break;

	case 205:	// ؿֽ ܰ
		{
			CString strACNO, strLasttrSonik, strORD_ABLE_CSH_A, strORD_ABLE_SBST_A, strCSH_RBUY_ABLE_A, strSBST_RBUY_ABLE_A, strAD_MGE_CSH;

			strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("ITEM_COD"));
			strTemp.Trim();
			strITMSCode = theApp.m_pCommAgent->GetShCode(strTemp);							//	ڵ

			strACNO = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("ACNO"));			//	¹ȣ
			strACNO.Trim();

			strLasttrSonik = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LASTTRSONIK"));		//	Ͻ()
			strLasttrSonik.Trim();
			strLasttrSonik = theApp.SetComma(strLasttrSonik);

			//	ֹ
			strORD_ABLE_CSH_A = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("ORD_ABLE_CSH_A"));		//	ֹݱݾ
			strORD_ABLE_CSH_A.Trim();
			strORD_ABLE_CSH_A = theApp.SetComma(strORD_ABLE_CSH_A);
			//	ֹɴ
			strORD_ABLE_SBST_A = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("ORD_ABLE_SBST_A"));		//	ֹɴݾ
			strORD_ABLE_SBST_A.Trim();
			strORD_ABLE_SBST_A = theApp.SetComma(strORD_ABLE_SBST_A);
			//	żɱݾ
			strCSH_RBUY_ABLE_A = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("CSH_RBUY_ABLE_A"));		//	żɱݾ
			strCSH_RBUY_ABLE_A.Trim();
			strCSH_RBUY_ABLE_A = theApp.SetComma(strCSH_RBUY_ABLE_A);
			//	żɱݾ
			strSBST_RBUY_ABLE_A = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("SBST_RBUY_ABLE_A"));		//	żɱݾ
			strSBST_RBUY_ABLE_A.Trim();
			strSBST_RBUY_ABLE_A = theApp.SetComma(strSBST_RBUY_ABLE_A);
			//	߰㺸
			strAD_MGE_CSH = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("AD_MGE_CSH"));		//	߰㺸ݱݾ
			strAD_MGE_CSH.Trim();
			strAD_MGE_CSH = theApp.SetComma(strAD_MGE_CSH);

			strData.Format("[ǽð ؿֽ ܰ  Ȯâ] --> ");
			strTemp.Format("    ڵ : [%s]   ¹ȣ : [%s]\r\n", strITMSCode, strACNO);
			strData += strTemp;
			strTemp.Format("    Ͻ : [%s]\r\n", strLasttrSonik);
			strData += strTemp;
			strTemp.Format("    ֹݱݾ : [%s]\r\n", strORD_ABLE_CSH_A);
			strData += strTemp;
			strTemp.Format("    ֹɴݾ : [%s]\r\n", strORD_ABLE_SBST_A);
			strData += strTemp;
			strTemp.Format("    żɱݾ : [%s]\r\n", strCSH_RBUY_ABLE_A);
			strData += strTemp;
			strTemp.Format("    żɱݾ : [%s]\r\n", strSBST_RBUY_ABLE_A);
			strData += strTemp;
			strTemp.Format("    ߰㺸 : [%s]\r\n", strAD_MGE_CSH);
			strData += strTemp;
			m_edOutMsg_real.SetWindowText(strData);
		}
		break;
	}

//  	CString strTemp , strData, strTRCode, strOderID, strOrorID, strITMSCode, strQNTY, strPRC;
// 	long lQnty, lPrc;
// 	double dPrc;
// 	
// 	switch(nRealType)
// 	{
// 		case REAL_S40:	// űֹ /Ȯ
// 		case REAL_F40:
// 		{
// 			NONE_EXECUTED* pData = (NONE_EXECUTED*)sRealData;
// 			strTRCode = CString(pData->TR_CODE, _countof(pData->TR_CODE));
// 			strOderID = CString(pData->ODER_ID, _countof(pData->ODER_ID));
// 			strOderID.Trim();
// 			strITMSCode = CString(pData->ITMS_CODE, _countof(pData->ITMS_CODE));
// 			strITMSCode.Trim();
// 			strQNTY = CString(pData->ASPR_QNTY, _countof(pData->ASPR_QNTY));
// 			strQNTY.Trim();
// 			lQnty = atol((LPCTSTR)strQNTY);
// 			strQNTY.Format("%ld", lQnty);
// 
// 			strPRC = CString(pData->ASPR_PRC, _countof(pData->ASPR_PRC));
// 			strPRC.Trim();
// 			if (nRealType == REAL_S40){
// 				lPrc = atol((LPCTSTR)strPRC);
// 				strPRC.Format("%ld", lPrc);
// 			}else{
// 				dPrc = atof((LPCTSTR)strPRC);
// 				strPRC.Format("%.02f", dPrc);
// 			}
// 			
// 
// 			// űֹ 
// 			if (strTRCode == TCHODR10001)
// 				strTemp.Format("[ǽð Ȯâ]-> ű ֹ Ǿϴ.\r\n");
// 			else if (strTRCode == TCHODR10002)
// 				strTemp.Format("[ǽð Ȯâ]->  ֹ Ǿϴ.\r\n");
// 			else if (strTRCode == TCHODR10003)
// 				strTemp.Format("[ǽð Ȯâ]->  ֹ Ǿϴ.\r\n");
// 			
// 			strData += strTemp;
// 			strTemp.Format("    ڵ : [%s]   ֹȣ : [%s]\r\n", strITMSCode, strOderID);
// 			strData += strTemp;
// 			strTemp.Format("     : [%s]    : [%s]", strQNTY ,strPRC);
// 			strData += strTemp;
// 			m_edOutMsg_real.SetWindowText(strData);
// 		}
// 		break;
// 	
// 		case REAL_S42:
// 		case REAL_F42:
// 		{
// 			EXECUTED* pData = (EXECUTED*)sRealData;
// 			strTRCode = CString(pData->TR_CODE, _countof(pData->TR_CODE));
// 			strOderID = CString(pData->ODER_ID, _countof(pData->ODER_ID));
// 			strOderID.Trim();
// 			strITMSCode = CString(pData->ITMS_CODE, _countof(pData->ITMS_CODE));
// 			strITMSCode.Trim();
// 			strQNTY = CString(pData->CNCD_QNTY, _countof(pData->CNCD_QNTY));
// 			strQNTY.Trim();
// 			lQnty = atol((LPCTSTR)strQNTY);
// 			strQNTY.Format("%ld", lQnty);
// 
// 			strPRC = CString(pData->CNCD_PRC, _countof(pData->CNCD_PRC));
// 			strPRC.Trim();
// 			if (nRealType == REAL_S40){
// 				lPrc = atol((LPCTSTR)strPRC);
// 				strPRC.Format("%ld", lPrc);
// 			}else{
// 				dPrc = atof((LPCTSTR)strPRC);
// 				strPRC.Format("%.02f", dPrc);
// 			}
// 			
// 			strTemp.Format("[ǽð Ȯâ] -> ֹ ü Ǿϴ.\r\n");
// 			strData += strTemp;
// 			strTemp.Format("    ڵ : [%s]   ֹȣ : [%s]\r\n", strITMSCode, strOderID);
// 			strData += strTemp;
// 			strTemp.Format("     : [%s]    : [%s]", strQNTY ,strPRC);
// 			strData += strTemp;
// 
// 			m_edOutMsg_real.SetWindowText(strData);
// 		}
// 		break;
// 	
// 		case REAL_S43:
// 		case REAL_F43:
// 		{
// 			HOGA_PROC* pData = (HOGA_PROC*)sRealData;
// 			strTRCode = CString(pData->TR_CODE, _countof(pData->TR_CODE));
// 			// űֹ 
// 			if (strTRCode == "TTRODP11301")         return;
// 
// 			if (strTRCode == TTRODP11303)	// IOC 
// 				strTemp.Format("[ǽð Ȯâ] -> IOC ֹ ҵǾϴ.\r\n");
// 			else if (strTRCode == TTRODP11311)	// ǽðȯ
// 				strTemp.Format("[ǽð Ȯâ] -> ǽðȯ.\r\n");
// 			else if (strTRCode == TTRODP11321)	// źȮ
// 				strTemp.Format("[ǽð Ȯâ] -> źȮ.\r\n");
// 			else
// 			{
// 				switch (pData->CRCT_CNCL_DTCD[0])
// 				{
// 				case '2' : // 
// 					strTemp.Format("->  ֹ Ȯ Ǿϴ. \r\n");
// 					break;
// 				case '3' : // 
// 					strTemp.Format("->  ֹ Ȯ Ǿϴ. \r\n");
// 					break;
// 				}
// 			}
// 
// 			strData += strTemp;
// 			
// 			m_edOutMsg_real.SetWindowText(strData);
// 		}
// 	}
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	strExchangeName		: ŷ ڵ
///////////////////////////////////////////////////////////////////////////////////////////////////
CString COvrsStckOrderDlg::GetExchangeCode( CString strExchangeName )
{
	if ( strExchangeName.Find(_T("̱")) >= 0 )
		return _T("020");
	else if ( strExchangeName.Find(_T("")) >= 0 )
		return _T("014");
	else if ( strExchangeName.Find(_T("õ")) >= 0 )
		return _T("018");
	else if ( strExchangeName.Find(_T("ȫ")) >= 0 )
		return _T("001");
	else
		return _T("%");
}

///////////////////////////////////////////////////////////////////////////////////////////////////
//	ֹ  ŵ/ż//
///////////////////////////////////////////////////////////////////////////////////////////////////
void COvrsStckOrderDlg::OnBnClickedOfferOrder()
{
	if(theApp.m_TRCnt > 0)
	{
		for(int i =0; i < theApp.m_TRCnt; i++) {
			RequestSendOrder(1); }
	}
	else
	{	RequestSendOrder(1); }
}

void COvrsStckOrderDlg::OnBnClickedBidOrder()
{
	if(theApp.m_TRCnt > 0)
	{
		for(int i =0; i < theApp.m_TRCnt; i++) {
			RequestSendOrder(2); }
	}
	else
	{	RequestSendOrder(2); }
}

void COvrsStckOrderDlg::OnBnClickedCorrectOrder()
{
	if(theApp.m_TRCnt > 0)
	{
		for(int i =0; i < theApp.m_TRCnt; i++) {
			RequestSendOrder(3); }
	}
	else
	{	RequestSendOrder(3); }
}

void COvrsStckOrderDlg::OnBnClickedCancelOrder()
{
	if(theApp.m_TRCnt > 0)
	{
		for(int i =0; i < theApp.m_TRCnt; i++) {
			RequestSendOrder(4); }
	}
	else
	{	RequestSendOrder(4); }
}

void COvrsStckOrderDlg::RequestSendOrder(int nOrderType)
{
	CString strTemp, strAccNo, strAccPass, strExCode, strCode, strQty, strOrderPrice, strBidOffer, strOrderCode, strOrderNo, strOrgOrderNo, strEXG_COD;
	m_CtrlEdAccNoCtl.GetWindowText( strAccNo );				// ¹ȣ( ڰ Էϴ  )
//	m_CtrlEdAccName.GetWindowText( strCode );				// ¸
	m_CtrlEdAccPwd.GetWindowText( strAccPass );				// ºйȣ
	m_CtrlEdCode.GetWindowText( strCode );					// ڵ
	m_CtrlEdQty.GetWindowText( strQty );					// ֹ
	m_CtrlEdPrice.GetWindowText( strOrderPrice );			// ֹ
	m_CtrlEdOrdNo.GetWindowText( strOrderNo );				// ֹȣ
	m_CtrlSrcOrdNo.GetWindowText( strOrgOrderNo );			// ֹȣ

	m_CtrlCbExchangeType.GetLBText(m_CtrlCbExchangeType.GetCurSel(), strEXG_COD);	// ֹŸ  
	strEXG_COD = GetExchangeCode( strEXG_COD );

	m_CtrlCbOrdType.GetLBText(m_CtrlCbOrdType.GetCurSel(), strTemp);	// ֹŸ  
	if (strTemp == "")
	{
		strOrderCode = "010";
	}
	else if (strTemp == "尡")
	{
		strOrderCode = "020";
	}
	else if (strTemp == "MOO")
	{
		strOrderCode = "720";
	}
	else if (strTemp == "MOC")
	{
		strOrderCode = "740";
	}
	else if (strTemp == "LOO")
	{
		strOrderCode = "710";
	}
	else if (strTemp == "LOC")
	{
		strOrderCode = "730";
	}
	else if (strTemp == "TWAP")
	{
		strOrderCode = "750";
	}
	else if (strTemp == "VWAP")
	{
		strOrderCode = "760";
	}
	else
	{
		strOrderCode = "010";
	}

	short nMarketType = theApp.m_pCommAgent->GetMarketKubun(strCode, _T(""));

	CString strTrCode;
	long nRQID = theApp.m_pCommAgent->CreateRequestID();
	if ( nOrderType == 1 || nOrderType == 2)					//	ŵ, ż
	{
		strTrCode = RQ_TRNAME_OVRS_BS_ORDER;
		if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ACNO"), strAccNo) <= 0 )
		{
			::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "¹ȣ Է ", MB_OK|MB_TOPMOST);
			return;
		}
		if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("AC_PWD"), strAccPass) <= 0 )
		{
			::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "º Է ", MB_OK|MB_TOPMOST);
			return;
		}
		theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("EXG_COD"), strEXG_COD);
		theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ITEM_COD"), strCode);
		theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_Q"), strQty);
		theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("FGST_ORD_UPR"), strOrderPrice);
		theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("BUY_SEL_TR_TCD"), (nOrderType == 1) ? "10" : "20");
		theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("FGST_BNS_TCD"), strOrderCode);
	}
	else if ( nOrderType == 3 || nOrderType == 4)	//	, 
	{
		strTrCode = RQ_TRNAME_OVRS_MC_ORDER;
		if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ACNO"), strAccNo) <= 0 )
		{
			::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "¹ȣ Է ", MB_OK|MB_TOPMOST);
			return;
		}
		if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("AC_PWD"), strAccPass) <= 0 )
		{
			::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "º Է ", MB_OK|MB_TOPMOST);
			return;
		}
		theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("OORD_NO"), strOrgOrderNo);
		theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_MDFY_CNCL_TCD"), (nOrderType == 3) ? "20" : "30");	//	"20" :  "30" : 
		theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("PAT_ALL_TCD"), _T("20"));									//	"10" : Ϻ "20" : 
		theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("EXG_COD"), strEXG_COD);
		theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ITEM_COD"), strCode);
		theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_Q"), strQty);
		theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("FGST_ORD_UPR"), strOrderPrice);
		theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("FGST_BNS_TCD"), strOrderCode);
	}

	if ( theApp.m_pCommAgent->RequestTran(nRQID, strTrCode, _T(""), 20) <= 0 )
	{
		CString strLastErrMsg = theApp.m_pCommAgent->GetLastErrMsg();
		::MessageBox(GetSafeHwnd(), strLastErrMsg, "ֹ  û ", MB_OK|MB_TOPMOST);
		return;
	}


// 	CString strAccNo, strPwd, strCode, strBidPriceCode, strOrgOrderNo, strCreditType, strLoanDate, strTemp, strOderGB, strOrderDTCD;
// 	int		nJangTimeGb, nCondType, nCreditOrderCode, nCndtDTCD;
// 	LONG	nQty, nPrice;
// 	BOOL	nLen = 0, bCredit = FALSE;
// 
// 	strOrgOrderNo		= _T("");
// 	strCreditType		= _T("");
// 	strLoanDate			= _T("");
// 	nCreditOrderCode	= 0;
// 
// 	int nIndex = m_AccNoCtl.GetCurSel();
// 	if (nIndex == CB_ERR)		return;
// 	m_AccNoCtl.GetLBText(nIndex, strAccNo);
// 	strAccNo.Remove('-');
// 
// 	m_CtrlEdAccPwd.GetWindowText( strPwd );
// 	m_CtrlEdCode.GetWindowText( strCode );
// 
// 	m_CtrlEdQty.GetWindowText( strTemp );
// 	if ( strTemp.GetLength() > 0 )
// 		nQty = atol((LPCTSTR)strTemp);
// 	else
// 		nQty = 0L;
// 
// 	
// 	m_CtrlEdPrice.GetWindowText( strTemp );
// 	if(strTemp.Find(_T(".")) >= 0)
// 	{
// 		strTemp.Remove(_T('.'));
// 	}
// 
// 	if ( strTemp.GetLength() > 0 )
// 		nPrice = atol((LPCTSTR)strTemp);
// 	else
// 		nPrice = 0L;
// 
// 	m_CtrlSrcOrdNo.GetWindowText( strOrgOrderNo );	// ֹȣ
// 
// 	m_CtrlCbOrdType.GetLBText(m_CtrlCbOrdType.GetCurSel(), strTemp);
// 	strOderGB = strTemp;
// 
// 	if (strAccNo.GetLength() != 11)
// 	{
// 		AfxMessageBox("õ  ȣ ϴ.  ȣ ٽ ȮϽʽÿ");
// 		return;
// 	}
// 
// 	if (strPwd.GetLength() == 0)
// 	{
// 		AfxMessageBox("  ȣ ٽ ȮϽʽÿ.");
// 		return;
// 	}
// 
// 	if (strCode.GetLength() == 0)
// 	{
// 		AfxMessageBox("ڵ带 Է ֽñ ٶϴ.");
// 		return;
// 	}
// 
// 	if (nQty == 0)
// 	{
// 		AfxMessageBox("ֹ Ȯ ֽñ ٶϴ.");
// 		return;
// 	}
// 
// 	if (strOderGB == "" || strOderGB == "Ǻ" || strOderGB == "(IOC)" || strOderGB == "(FOK)")
// 	{
// 		if (nPrice == 0)
// 		{
// 			AfxMessageBox("ֹ Ȯ ֽñ ٶϴ.");
// 			return;
// 		}
// 	}
// 	else
// 	{
// 		if (nPrice != 0)
// 		{
// 			AfxMessageBox("ֹ ԷҼ ϴ.");
// 			return;
// 		}
// 	}
// 
// 	if (strOderGB.GetLength() == 0)
// 	{
// 		AfxMessageBox("ֹ Ȯֽñ ٶϴ.");
// 		return;
// 	}
// 
// 	if (nOrderType == 3 || nOrderType == 4)
// 	{
// 		if (strOrgOrderNo.GetLength() == 0)
// 		{
// 			AfxMessageBox("ֹȣ Ȯֽñ ٶϴ.");
// 			return;
// 		}
// 	}
// 
// 	GetOrderElementsType(strTemp, nJangTimeGb, strBidPriceCode, nCondType);
// 
// 	if (strCode.GetLength() == 6)
// 		SendOrder(_T("1111"), strAccNo, strPwd, nOrderType, strCode, nQty, nPrice, nJangTimeGb, strBidPriceCode, nCondType, strOrgOrderNo, \
// 		bCredit, strCreditType, nCreditOrderCode, strLoanDate);
// 	else{
// 		// strOrderDTCD : ֹ ڵ. ("01" : , "02" : 尡, "03" : Ǻ , "04" : )
// 		// nCndtDTCD  : ֹǱڵ. (0: Ϲ, 1: IOC, 2: FOK)
// 		if (strOderGB == "")
// 		{
// 			strOrderDTCD = "01";
// 			nCndtDTCD = 0;
// 		}
// 		else if (strOderGB == "尡")
// 		{
// 			strOrderDTCD = "02";
// 			nCndtDTCD = 0;
// 		}
// 		else if (strOderGB == "Ǻ")
// 		{
// 			strOrderDTCD = "03";
// 			nCndtDTCD = 0;
// 		}
// 		else if (strOderGB == "")
// 		{
// 			strOrderDTCD = "04";
// 			nCndtDTCD = 0;
// 		}
// 		else if (strOderGB == "(IOC)")
// 		{
// 			strOrderDTCD = "01";
// 			nCndtDTCD = 1;
// 		}
// 		else if (strOderGB == "尡(IOC)")
// 		{
// 			strOrderDTCD = "02";
// 			nCndtDTCD = 1;
// 		}
// 		else if (strOderGB == "(IOC)")
// 		{
// 			strOrderDTCD = "04";
// 			nCndtDTCD = 1;
// 		}
// 		else if (strOderGB == "(FOK)")
// 		{
// 			strOrderDTCD = "01";
// 			nCndtDTCD = 2;
// 		}
// 		else if (strOderGB == "尡(FOK)")
// 		{
// 			strOrderDTCD = "02";
// 			nCndtDTCD = 2;
// 		}
// 		else if (strOderGB == "(FOK)")
// 		{
// 			strOrderDTCD = "04";
// 			nCndtDTCD = 2;
// 		}
// 		else
// 		{
// 			strOrderDTCD = "01";
// 			nCndtDTCD = 0;
// 		}
// 
// 		SendOrderFO(_T("1111"), strAccNo, strPwd, strCode, nOrderType, nQty, nPrice, strOrderDTCD, nCndtDTCD, strOrgOrderNo);
// 	}

}

///////////////////////////////////////////////////////////////////////////////////////////////////
//	ֽĹü/üȸ Transaction
//	CString strAccNo,				/* ¹ȣ */
//	CString strAccPass,				/* º */
//	int		nPrevNext,				/*  0:Ϲ, 1:, 2: */
//	CString strOrderNo = _T("")		/* ֹȣ (Ű ) */
///////////////////////////////////////////////////////////////////////////////////////////////////
int COvrsStckOrderDlg::RequestTrStockCheKyeol(CString strACNO, CString strAC_PWD, CString strORD_DT, CString strBUY_SEL_TR_TCD, 
											  CString strORD_RJT_YN, CString strEXG_COD, CString strPrevNext/* = _T("")*/)
{
	CString strTemp, strTrCode = RQ_TRNAME_OVRS_ORDER_CHE;

	long nRQID = theApp.m_pCommAgent->CreateRequestID();
	if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ACNO"), strACNO) <= 0 )
	{
		::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "¹ȣ Է ", MB_OK|MB_TOPMOST);
		return 0;
	}
	if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("AC_PWD"), strAC_PWD) <= 0 )
	{
		::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "º Է ", MB_OK|MB_TOPMOST);
		return 0;
	}
	theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_DT"), strORD_DT);
	theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("BUY_SEL_TR_TCD"), strBUY_SEL_TR_TCD);
	theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_RJT_YN"), strORD_RJT_YN);
	theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("EXG_COD"), strEXG_COD);			//	ŷڵ 

	if ( strPrevNext == _T("") )
		m_CtrlListOutStdOrd.DeleteAllItems();

	//	ſû
	if ( theApp.m_pCommAgent->RequestTran(nRQID, strTrCode, strPrevNext, 20) <= 0 )
	{
		CString strLastErrMsg = theApp.m_pCommAgent->GetLastErrMsg();
		::MessageBox(GetSafeHwnd(), strLastErrMsg, "ֽ ü  û ", MB_OK|MB_TOPMOST);
		return 0;
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
//	ֱ ȯ ȸ
///////////////////////////////////////////////////////////////////////////////////////////////////
int COvrsStckOrderDlg::RequestTrStockExchange( CString strACURR_COD)
{
	CString strTemp, strTrCode = RQ_TRNAME_OVRS_ORDER_EXCHANGE;

	long nRQID = theApp.m_pCommAgent->CreateRequestID();
	theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("CURR_COD"), strACURR_COD);

	//	ſû
	if ( theApp.m_pCommAgent->RequestTran(nRQID, strTrCode, _T(""), 20) <= 0 )
	{
		CString strLastErrMsg = theApp.m_pCommAgent->GetLastErrMsg();
		::MessageBox(GetSafeHwnd(), strLastErrMsg, "ֱ ȯ ȸ û ", MB_OK|MB_TOPMOST);
		return 0;
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
//	ܰ Transaction
///////////////////////////////////////////////////////////////////////////////////////////////////
int COvrsStckOrderDlg::RequestTrOvrsJango( CString strACNO, CString strAC_PWD, CString strCMSN_ICLN_YN, CString strPrevNext/* = _T("")*/)
{
	CString strTemp, strTrCode = RQ_TRNAME_OVRS_ORDER_JAN;

	long nRQID = theApp.m_pCommAgent->CreateRequestID();
	if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ACNO"), strACNO) <= 0 )
	{
		::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "¹ȣ Է ", MB_OK|MB_TOPMOST);
		return 0;
	}
	if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("AC_PWD"), strAC_PWD) <= 0 )
	{
		::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "º Է ", MB_OK|MB_TOPMOST);
		return 0;
	}
	theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("CMSN_ICLN_YN"), strCMSN_ICLN_YN);

	if ( strPrevNext == _T("") )
		m_CtrlListStock.DeleteAllItems();

	//	ſû
	if ( theApp.m_pCommAgent->RequestTran(nRQID, strTrCode, strPrevNext, 20) <= 0 )
	{
		CString strLastErrMsg = theApp.m_pCommAgent->GetLastErrMsg();
		::MessageBox(GetSafeHwnd(), strLastErrMsg, "ؿ ֽ  ȸ û ", MB_OK|MB_TOPMOST);
		return 0;
	}

	return 0;
}

void COvrsStckOrderDlg::ReceiveTrStockChekeyol(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strValue, strTemp;
	int nDataCnt = 0;
	char szTemp[128] = {0x00};
	long lTemp;
	double dTemp;
	int nItem;
	int nListRowCnt = m_CtrlListOutStdOrd.GetItemCount();

	if ( nDataLength > 0 )
	{	// Data OK
		//Ű

		typedef struct _STOCK_CHEKEYOL_OUTREC1
		{
			char		RECNM[19];				/*  [ڵ]     */
		}STOCK_CHEKEYOL_OUTREC1;

		typedef struct _STOCK_CHEKEYOL_OUTREC2
		{
			char		ORD_NO[11];				/*  [ֹȣ]     */
			char		ITEM_COD[12];			/*  [ڵ]     */
			char		ITEM_NM[50];			/*  []     */
			char		BUY_SEL_TR_TCD[2];		/*  [żŵŷڵ]     */
			char		ORD_Q[19];				/*  [ֹ]     */
			char		FGST_ORD_UPR[17];		/*  [ؿֹܰ]     */
			char		CLSN_Q[19];				/*  [ü]     */
			char		FGST_CLSN_UPR[17];		/*  [ؿüܰ]     */
			char		FRGN_NCLSN_Q[19];		/*  [ؿܹü]     */
			char		FGST_ORD_SCD[3];		/*  [ؿֹڵ]     */
			char		OORD_NO[11];			/*  [ֹȣ]     */
			char		CURR_COD[3];			/*  [ȭڵ]     */
			char		EXG_COD[3];				/*  [ŷڵ]     */
			char		CTRY_COD[3];			/*  [ڵ]     */
			char		FGST_BNS_TCD[3];		/*  [ؿǸŸűڵ]     */
			char		ORD_TMD[6];				/*  [ֹð]     */
			char		FGST_KOR_MSG_CN[100];	/*  [ؿѱ۸޽]     */
			char		FRGN_STK_MKT_TCD[2];	/*  [ؿֽĽ屸ڵ]     */
			char		BNS_CLSN_TMD[6];		/*  [Ÿüð]     */

		}STOCK_CHEKEYOL_OUTREC2;

		STOCK_CHEKEYOL_OUTREC1* pOutRec1 = (STOCK_CHEKEYOL_OUTREC1*)sData;
		STOCK_CHEKEYOL_OUTREC2* pOutRec2 = (STOCK_CHEKEYOL_OUTREC2*)(sData + sizeof(STOCK_CHEKEYOL_OUTREC1));
		memcpy(szTemp, pOutRec1->RECNM, sizeof(pOutRec1->RECNM));
		nDataCnt = _ttoi(szTemp);

		if(nDataCnt > 0)
		{
			//ֹü Ÿ .
			for (int i = 0; i < nDataCnt; i++)
			{
				//	ֹü ڵ 
				

				strTemp = CString(pOutRec2[i].ORD_NO, _countof(pOutRec2[i].ORD_NO));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				nItem = m_CtrlListOutStdOrd.InsertItem( LVIF_TEXT, i + nListRowCnt, strTemp, 0, 0, 0, NULL );		// ֹȣ
//				m_CtrlListOutStdOrd.SetItemText(nItem, 0, strTemp.Trim());		// ֹȣ

				//	ŵ/ż ̿ а ڵ忡 ߰ ʴ´. 
				strTemp = CString(pOutRec2[i].BUY_SEL_TR_TCD, _countof(pOutRec2[i].BUY_SEL_TR_TCD));
				if (_tstol(strTemp) == 10) 
					strTemp = _T("ŵ");
				else	strTemp = _T("ż");
				m_CtrlListOutStdOrd.SetItemText(nItem, 1, strTemp.Trim());		// Ÿű

				lTemp = _tstol(CString(pOutRec2[i].FGST_BNS_TCD, _countof(pOutRec2[i].FGST_BNS_TCD)));
				if (lTemp == 20) 
					strTemp = _T("尡");
				else if (lTemp == 720)
					strTemp = _T("MOO");
				else if (lTemp == 740)
					strTemp = _T("MOC");
				else if (lTemp == 710)
					strTemp = _T("LOO");
				else if (lTemp == 730)
					strTemp = _T("LOC");
				else if (lTemp == 750)
					strTemp = _T("TWAP");
				else if (lTemp == 760)
					strTemp = _T("VWAP");
				else
					strTemp = _T("");
				m_CtrlListOutStdOrd.SetItemText(nItem, 2, strTemp.Trim());		// ֹ


				strTemp = CString(pOutRec2[i].ITEM_NM, _countof(pOutRec2[i].ITEM_NM));	strTemp.Trim();
				m_CtrlListOutStdOrd.SetItemText(nItem, 3, strTemp.Trim());		// 

				strTemp = CString(pOutRec2[i].FGST_ORD_UPR, _countof(pOutRec2[i].FGST_ORD_UPR));
				dTemp = _tstof(strTemp);
				strTemp.Format("%0.4f", dTemp);
				m_CtrlListOutStdOrd.SetItemText(nItem, 4, strTemp.Trim());		// ֹ

				strTemp = CString(pOutRec2[i].ORD_Q, _countof(pOutRec2[i].ORD_Q));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListOutStdOrd.SetItemText(nItem, 5, theApp.SetComma(strTemp));		// ֹ

				strTemp = CString(pOutRec2[i].CLSN_Q, _countof(pOutRec2[i].CLSN_Q));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListOutStdOrd.SetItemText(nItem, 6, theApp.SetComma(strTemp));		// ü

				strTemp = CString(pOutRec2[i].OORD_NO, _countof(pOutRec2[i].OORD_NO));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListOutStdOrd.SetItemText(nItem, 7, strTemp.Trim());		// ֹȣ

				strTemp = CString(pOutRec2[i].FGST_ORD_SCD, _countof(pOutRec2[i].FGST_ORD_SCD));
				if (strTemp == _T("1"))
					strTemp = _T("κü");
				else if (strTemp == _T("2"))
					strTemp = _T("ü");
				else if (strTemp == _T("3"))
					strTemp = _T("DFD");
				else if (strTemp == _T("4"))
					strTemp = _T("Ȯ");
				else if (strTemp == _T("5"))
					strTemp = _T("Ȯ");
				else if (strTemp == _T("6"))
					strTemp = _T("");
				else if (strTemp == _T("8"))
					strTemp = _T("ź");
				else if (strTemp == _T("A"))
					strTemp = _T("ű");
				else if (strTemp == _T("C"))
					strTemp = _T("EXP");
				else if (strTemp == _T("E"))
					strTemp = _T("");
				else
					strTemp = _T("ű");
				m_CtrlListOutStdOrd.SetItemText(nItem, 8, strTemp.Trim());		// ֹ

				strValue = CString(pOutRec2[i].ORD_TMD, _countof(pOutRec2[i].ORD_TMD));
				strTemp.Format("%s:%s:%s", strValue.Left(2),strValue.Mid(2,2),strValue.Right(2));
				m_CtrlListOutStdOrd.SetItemText(nItem, 9, strTemp.Trim());		// ֹð

				strTemp = CString(pOutRec2[i].ITEM_COD, _countof(pOutRec2[i].ITEM_COD));
				m_CtrlListOutStdOrd.SetItemText(nItem, 10, strTemp.Trim());		// ڵ

				strTemp = CString(pOutRec2[i].EXG_COD, _countof(pOutRec2[i].EXG_COD));
				if (strTemp == _T("020"))
					strTemp = _T("̱");
				else if (strTemp == _T("014"))
					strTemp = _T("");
				else if (strTemp == _T("018"))
					strTemp = _T("õ");
				else
					strTemp = _T("ȫ");
				m_CtrlListOutStdOrd.SetItemText(nItem, 11, strTemp.Trim());		// ŷ

			}

			//	ȸ
			CString strNextKey = sPreNext;
			if(strNextKey != _T("") )
			{
				int		nPrevNext = 1;
				CString strACNO;				//¹ȣ
				CString strAC_PWD;				//ºйȣ
				CString strORD_DT;				//ֹ
				CString strBUY_SEL_TR_TCD;		//żŵŷڵ
				CString strORD_RJT_YN;			//ֹźο
				CString strEXG_COD;				//ŷڵ

				m_CtrlEdAccNoCtl.GetWindowText( strACNO );				// ¹ȣ.- ڸ 11ڸ
				strACNO.Remove('-');
				m_CtrlEdAccPwd.GetWindowText( strAC_PWD );				// ºйȣ

				strORD_DT = _T("");
				m_CtrlCreditDate.GetWindowTextA(strORD_DT);
				strORD_DT.Replace("-", "");								// ֹ

				strBUY_SEL_TR_TCD = _T("%");							// "%" : ü "10" : ŵ "20" : ż
				strORD_RJT_YN = _T("%");								// "%" : ü, "N" : Ϸ "Y" : ź

				// 	"%" : ü 
				// 	"020" : ̱ Ƹ߽, ,  
				// 	"014" : ߱()
				// 	"018" : ߱õ()
				// 	"001" : ȫ()
				m_CtrlCbExchangeType.GetLBText(m_CtrlCbExchangeType.GetCurSel(), strEXG_COD);	// ֹŸ  
				strEXG_COD = GetExchangeCode( strEXG_COD );

				if ( RequestTrStockCheKyeol( strACNO, strAC_PWD, strORD_DT, strBUY_SEL_TR_TCD, strORD_RJT_YN, strEXG_COD, strNextKey ) > 0 )
					return;
				else
					TRACE("ֽ ֹü  ȸ \n");
			}
		}
	}
	else
	{	// Error
		AfxMessageBox(sMessage);
	}
}

void COvrsStckOrderDlg::ReceiveTrOvrsExchange(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strValue, strTemp;
	int nDataCnt = 0;
	char szTemp[128] = {0x00};
	long lTemp;
	int nItem;

	if ( nDataLength > 0 )
	{	// Data OK
		//Ű

		typedef struct _OVRS_EXCHANGE_OUTREC1
		{
			char		AC_TDA[19];						/*  [ѿ]     */
			char		D1_ESTI_DA[19];					/*  [D1]     */
			char		D2_ESTI_DA[19];					/*  [D2]     */
			char		AC_TSBA[19];					/*  [Ѵ]     */
			char		CSH_DFA[19];					/*  [ݹ̼]     */
			char		ORD_ABLE_CSH[19];				/*  [ֹ]     */
			char		GNRL_AGRD_MAX_ORD_ABLE_A[19];	/*  [ϹAִֹɱݾ]     */
			char		GNRL_BGRD_MAX_ORD_ABLE_A[19];	/*  [ϹBִֹɱݾ]     */
			char		GNRL_CGRD_MAX_ORD_ABLE_A[19];	/*  [ϹCִֹɱݾ]     */
			char		GNRL_DGRD_MAX_ORD_ABLE_A[19];	/*  [ϹDִֹɱݾ]     */
			char		LS_MAX_ORD_ABLE_A[19];			/*  [ִֹɱݾ]     */
			char		CRD_BGRD_MAX_ORD_ABLE_A[19];	/*  [ſBִֹɱݾ]     */
			char		CRD_CGRD_MAX_ORD_ABLE_A[19];	/*  [ſCִֹɱݾ]     */
			char		CRD_DGRD_MAX_ORD_ABLE_A[19];	/*  [ſDִֹɱݾ]     */
			char		CRD_MLN_A[19];					/*  [ſڱݾ]     */
			char		MGE_MNTN_RT[17];				/*  [㺸]     */
			char		MGLCK_A[19];					/*  [㺸ݾ]     */
			char		LS_SUM_A[19];					/*  [հݾ]     */
			char		AM_BAL_A[19];					/*  [ܰݾ]     */
			char		BNS_BAL_A[19];					/*  [Ÿܰݾ]     */
			char		AM_PL_A[19];					/*  [ͱݾ]     */
			char		AM_PL_R[17];					/*  []     */
			char		RECNM[19];						/*  [ڵ]     */

		}OVRS_EXCHANGE_OUTREC1;

		typedef struct _OVRS_EXCHANGE_OUTREC2
		{
			char		ITEM_COD[12];					/*  [ڵ]     */
			char		ITEM_NM[50];					/*  []     */
			char		CRD_TCD[3];						/*  [ſ뱸ڵ]     */
			char		BNS_ABLE_Q[19];					/*  [ŸŰɼ]     */
			char		SEL_PRGS_Q[19];					/*  [ŵ]     */
			char		STL_BAL_Q[19];					/*  [ܰ]     */
			char		BNS_BAL_Q[19];					/*  [Ÿܰ]     */
			char		BFDY_CLSN_BUY_Q[19];			/*  [üż]     */
			char		BFDY_CLSN_SEL_Q[19];			/*  [üŵ]     */
			char		TDY_CLSN_BUY_Q[19];				/*  [üż]     */
			char		TDY_CLSN_SEL_Q[19];				/*  [üŵ]     */
			char		BUY_UPR[17];					/*  [żܰ]     */
			char		ACBK_A[19];						/*  [αݾ]     */
			char		RLZ_PL_A[19];					/*  [ͱݾ]     */
			char		SEL_UPR[17];					/*  [ŵܰ]     */
			char		ESTI_CMSN[19];					/*  []     */
			char		ESTI_TXA[19];					/*  []     */
			char		LN_DT[8];						/*  []     */
			char		DUE_DT[8];						/*  []     */
			char		RPY_ABLE_Q[19];					/*  [ȯɼ]     */
			char		CRD_A[19];						/*  [ſݾ]     */
			char		STK_CRPR[19];					/*  [ֽ簡]     */
			char		STK_EA[19];						/*  [ֽ򰡱ݾ]     */
			char		EV_PL_A[19];					/*  [򰡼ͱݾ]     */
			char		ERN_R[17];						/*  [ͷ]     */
			char		VRTL_EA[19];					/*  [򰡱ݾ]     */
			char		VRTL_EV_PL_A[19];				/*  [򰡼ͱݾ]     */
			char		VRTL_EV_PL_R[17];				/*  [򰡼ͷ]     */

		}OVRS_EXCHANGE_OUTREC2;

		OVRS_EXCHANGE_OUTREC1* pOutRec1 = (OVRS_EXCHANGE_OUTREC1*)sData;
		OVRS_EXCHANGE_OUTREC2* pOutRec2 = (OVRS_EXCHANGE_OUTREC2*)(sData + sizeof(OVRS_EXCHANGE_OUTREC1));
		memcpy(szTemp, pOutRec1->RECNM, sizeof(pOutRec1->RECNM));
		nDataCnt = _ttoi(szTemp);

		if(nDataCnt > 0)
		{
			//ֹü Ÿ .
			for (int i = 0; i < nDataCnt; i++)
			{
				//	ֹü ڵ 
				strTemp = CString(pOutRec2[i].ITEM_COD, _countof(pOutRec2[i].ITEM_COD));
				strTemp.Remove(_T('A'));
				strTemp.Remove(_T('J'));
				strTemp.Remove(_T('Q'));
				nItem = m_CtrlListStock.InsertItem( LVIF_TEXT, i, strTemp.Trim(), 0, 0, 0, NULL );		// ڵ

				strTemp = CString(pOutRec2[i].ITEM_NM, _countof(pOutRec2[i].ITEM_NM));
				m_CtrlListStock.SetItemText(nItem, 1, strTemp.Trim());								// 

				lTemp = _tstol(CString(pOutRec2[i].CRD_TCD, _countof(pOutRec2[i].CRD_TCD)));
				if (lTemp == 20) 
					strTemp = _T("");
				else if (lTemp == 30)
					strTemp = _T("ڱ");
				else if (lTemp == 40)
					strTemp = _T("");
				else if (lTemp == 50)
					strTemp = _T("ڱ");
				else
					strTemp = _T("");
				m_CtrlListStock.SetItemText(nItem, 2, strTemp.Trim());					// ܰ

				strTemp = CString(pOutRec2[i].BNS_BAL_Q, _countof(pOutRec2[i].BNS_BAL_Q));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListStock.SetItemText(nItem, 3, theApp.SetComma(strTemp));		// 

				strTemp = CString(pOutRec2[i].BNS_ABLE_Q, _countof(pOutRec2[i].BNS_ABLE_Q));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListStock.SetItemText(nItem, 4, theApp.SetComma(strTemp));		// ŵ

				strTemp = CString(pOutRec2[i].BUY_UPR, _countof(pOutRec2[i].BUY_UPR));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListStock.SetItemText(nItem, 5, theApp.SetComma(strTemp));		// Դܰ

				strTemp = CString(pOutRec2[i].EV_PL_A, _countof(pOutRec2[i].EV_PL_A));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListStock.SetItemText(nItem, 6, theApp.SetComma(strTemp));		// 򰡼

				strTemp = CString(pOutRec2[i].ERN_R, _countof(pOutRec2[i].ERN_R));
				strTemp.Format("%0.2f", _tstof(strTemp));
				m_CtrlListStock.SetItemText(nItem, 7, strTemp.Trim());					// 

				strTemp = CString(pOutRec2[i].STK_EA, _countof(pOutRec2[i].STK_EA));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListStock.SetItemText(nItem, 8, theApp.SetComma(strTemp));		// 򰡱ݾ

				strTemp = CString(pOutRec2[i].ACBK_A, _countof(pOutRec2[i].ACBK_A));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListStock.SetItemText(nItem, 9, theApp.SetComma(strTemp));		// Աݾ

				strTemp = CString(pOutRec2[i].ESTI_CMSN, _countof(pOutRec2[i].ESTI_CMSN));
				lTemp = _tstol(strTemp);
				strTemp = CString(pOutRec2[i].ESTI_TXA, _countof(pOutRec2[i].ESTI_TXA));
				strTemp.Format("%ld", _tstol(strTemp) + lTemp);
				m_CtrlListStock.SetItemText(nItem, 10, theApp.SetComma(strTemp));		// 

				strTemp = CString(pOutRec2[i].LN_DT, _countof(pOutRec2[i].LN_DT));
				m_CtrlListStock.SetItemText(nItem, 11, strTemp.Trim());					// 

			}

// 			//	ȸ
// 			CString strNextKey = sPreNext;
// 			if(strNextKey != _T("") )
// 			{
// 				int		nPrevNext = 1;
// 				CString strCURR_COD;		//ȭڵ
// 				strCURR_COD = _T("USD");									//"USD", "CNY", "HKD"
// 
// 				if ( RequestTrStockExchange( strCURR_COD ) > 0 )
// 					return;
// 				else
// 					TRACE("ֽ ܰ  ȸ \n");
// 			}
		}
	}
	else
	{	// Error
		AfxMessageBox(sMessage);
	}
}

void COvrsStckOrderDlg::ReceiveTrOvrsJango(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strValue, strTemp;
	int nDataCnt = 0;
	char szTemp[128] = {0x00};
	long lTemp;
	double dTemp;
	int nItem;

	if ( nDataLength > 0 )
	{	// Data OK
		//Ű

		typedef struct _OVRS_JANGO_OUTREC1
		{
			char		RECNM[19];				/*  [ڵ]     */

		}OVRS_JANGO_OUTREC1;

		typedef struct _OVRS_JANGO_OUTREC2
		{
			char		EXG_COD[3];				/*  [ŷڵ]     */
			char		ITEM_COD[12];			/*  [ڵ]     */
			char		ITEM_NM[50];			/*  []     */
			char		HLDG_Q[19];				/*  []     */
			char		SEL_ABLE_Q[19];			/*  [ŵɼ]     */
			char		BUY_UPR[17];			/*  [żܰ]     */
			char		FRGN_STK_CLPR[17];		/*  [ؿֽ]     */
			char		ERN_R[17];				/*  [ͷ]     */
			char		EV_PL_SUM_A[17];		/*  [򰡼հݾ]     */
			char		FGST_CBAS_BUY_A[17];	/*  [ؿüظżݾ]     */
			char		BNS_BAL_EA[17];			/*  [Ÿܰ򰡱ݾ]     */
			char		FRGN_STK_MKT_TCD[2];	/*  [ؿֽĽ屸ڵ]     */


		}OVRS_JANGO_OUTREC2;

		OVRS_JANGO_OUTREC1* pOutRec1 = (OVRS_JANGO_OUTREC1*)sData;
		OVRS_JANGO_OUTREC2* pOutRec2 = (OVRS_JANGO_OUTREC2*)(sData + sizeof(OVRS_JANGO_OUTREC1));
		memcpy(szTemp, pOutRec1->RECNM, sizeof(pOutRec1->RECNM));
		nDataCnt = _ttoi(szTemp);

		if(nDataCnt > 0)
		{
			//ֹü Ÿ .
			for (int i = 0; i < nDataCnt; i++)
			{
				//	ֹü ڵ 
				strTemp = CString(pOutRec2[i].ITEM_COD, _countof(pOutRec2[i].ITEM_COD));
// 				strTemp.Remove(_T('A'));
// 				strTemp.Remove(_T('J'));
// 				strTemp.Remove(_T('Q'));
				nItem = m_CtrlListStock.InsertItem( LVIF_TEXT, i, strTemp.Trim(), 0, 0, 0, NULL );		// ڵ

				strTemp = CString(pOutRec2[i].ITEM_NM, _countof(pOutRec2[i].ITEM_NM));
				m_CtrlListStock.SetItemText(nItem, 1, strTemp.Trim());								// 

				lTemp = _tstol(CString(pOutRec2[i].FRGN_STK_MKT_TCD, _countof(pOutRec2[i].FRGN_STK_MKT_TCD)));
				if (lTemp == 3)
					strTemp = _T("NASD(ڰ)");
				else if (lTemp == 6)
					strTemp = _T("");
				else if (lTemp == 7)
					strTemp = _T("õ");
				else if (lTemp == 8) 
					strTemp = _T("");
				else if (lTemp == 9) 
					strTemp = _T("");
				else if (lTemp == 10) 
					strTemp = _T("Ƹ߽");
				else if (lTemp == 1) 
					strTemp = _T("ȫ");
				else
					strTemp = _T("κ");

				m_CtrlListStock.SetItemText(nItem, 2, strTemp.Trim());					// ؿֽĽ屸ڵ

				strTemp = CString(pOutRec2[i].HLDG_Q, _countof(pOutRec2[i].HLDG_Q));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListStock.SetItemText(nItem, 3, theApp.SetComma(strTemp));		// 

				strTemp = CString(pOutRec2[i].SEL_ABLE_Q, _countof(pOutRec2[i].SEL_ABLE_Q));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListStock.SetItemText(nItem, 4, theApp.SetComma(strTemp));		// ŵ

				strTemp = CString(pOutRec2[i].BUY_UPR, _countof(pOutRec2[i].BUY_UPR));
				dTemp = _tstof(strTemp);
				strTemp.Format("%0.4f", dTemp);
				m_CtrlListStock.SetItemText(nItem, 5, theApp.SetComma(strTemp));					// Դܰ

				strTemp = CString(pOutRec2[i].FRGN_STK_CLPR, _countof(pOutRec2[i].FRGN_STK_CLPR));
				dTemp = _tstof(strTemp);
				strTemp.Format("%0.4f", dTemp);
				m_CtrlListStock.SetItemText(nItem, 6, theApp.SetComma(strTemp));					// 簡

				strTemp = CString(pOutRec2[i].EV_PL_SUM_A, _countof(pOutRec2[i].EV_PL_SUM_A));
				dTemp = _tstof(strTemp);
				strTemp.Format("%0.2f", dTemp);
				m_CtrlListStock.SetItemText(nItem, 7, theApp.SetComma(strTemp));		// 򰡼

				strTemp = CString(pOutRec2[i].ERN_R, _countof(pOutRec2[i].ERN_R));
				dTemp = _tstof(strTemp);
				strTemp.Format("%0.2f", dTemp);
				m_CtrlListStock.SetItemText(nItem, 8, theApp.SetComma(strTemp));		// 

				strTemp = CString(pOutRec2[i].BNS_BAL_EA, _countof(pOutRec2[i].BNS_BAL_EA));
				dTemp = _tstof(strTemp);
				strTemp.Format("%0.2f", dTemp);
				m_CtrlListStock.SetItemText(nItem, 9, theApp.SetComma(strTemp));		// ֽ򰡱ݾ

				strTemp = CString(pOutRec2[i].FGST_CBAS_BUY_A, _countof(pOutRec2[i].FGST_CBAS_BUY_A));
				dTemp = _tstof(strTemp);
				strTemp.Format("%0.2f", dTemp);
				m_CtrlListStock.SetItemText(nItem, 10, theApp.SetComma(strTemp));		// ؿüظżݾ
			}

			//	ȸ
			CString strNextKey = sPreNext;
			if(strNextKey != _T("") )
			{
				int		nPrevNext = 1;
				CString strACNO;			//¹ȣ
				CString strAC_PWD;			//ºйȣ
				CString strCMSN_ICLN_YN;	//Կ

				m_CtrlEdAccNoCtl.GetWindowText( strACNO );				// ¹ȣ.- ڸ 11ڸ
				strACNO.Remove('-');
				m_CtrlEdAccPwd.GetWindowText( strAC_PWD );				// ºйȣ
				strCMSN_ICLN_YN = _T("N");

				if ( RequestTrOvrsJango( strACNO, strAC_PWD, strCMSN_ICLN_YN, strNextKey ) > 0 )
					return;
				else
					TRACE("ֽ ܰ  ȸ \n");
			}
		}
	}
	else
	{	// Error
		AfxMessageBox(sMessage);
	}
}

// ü ȸ
void COvrsStckOrderDlg::OnBnClickedOutstdorder()
{
	int		nPrevNext = 0;

	CString strACNO;				//¹ȣ
	CString strAC_PWD;				//ºйȣ
	CString strORD_DT;				//ֹ
	CString strBUY_SEL_TR_TCD;		//żŵŷڵ
	CString strORD_RJT_YN;			//ֹźο
	CString strEXG_COD;				//ŷڵ

	m_CtrlEdAccNoCtl.GetWindowText( strACNO );				// ¹ȣ.- ڸ 11ڸ
	strACNO.Remove('-');
	m_CtrlEdAccPwd.GetWindowText( strAC_PWD );				// ºйȣ

	strORD_DT = _T("");
	m_CtrlCreditDate.GetWindowText(strORD_DT);
	strORD_DT.Replace("-", "");								// ֹ

	strBUY_SEL_TR_TCD = _T("%");							// "%" : ü "10" : ŵ "20" : ż
	strORD_RJT_YN = _T("%");								// "%" : ü, "N" : Ϸ "Y" : ź

	// 	"%" : ü 
	// 	"020" : ̱ Ƹ߽, ,  
	// 	"014" : ߱()
	// 	"018" : ߱õ()
	// 	"001" : ȫ()
	m_CtrlCbExchangeType.GetLBText(m_CtrlCbExchangeType.GetCurSel(), strEXG_COD);	// ֹŸ  
	strEXG_COD = GetExchangeCode( strEXG_COD );
	if(theApp.m_TRCnt > 0)
	{
		for(int i=0; i < theApp.m_TRCnt; i++)
		{ RequestTrStockCheKyeol( strACNO, strAC_PWD, strORD_DT, strBUY_SEL_TR_TCD, strORD_RJT_YN, strEXG_COD ); }
	}
	else
	{	RequestTrStockCheKyeol( strACNO, strAC_PWD, strORD_DT, strBUY_SEL_TR_TCD, strORD_RJT_YN, strEXG_COD );	}
}

// ֱٱȯȸ
void COvrsStckOrderDlg::OnBnClickedStockBtn()
{
	int		nPrevNext = 0;

	CString strCURR_COD;		//ȭڵ

	strCURR_COD = _T("USD");									//"USD", "CNY", "HKD"
	if(theApp.m_TRCnt > 0)
	{
		for(int i=0; i < theApp.m_TRCnt; i++)
		{ RequestTrStockExchange( strCURR_COD ); }
	}
	else
	{ RequestTrStockExchange( strCURR_COD ); }
}

void COvrsStckOrderDlg::OnBnClickedStockaccinfoBtn()
{
	int		nPrevNext = 0;

	CString strACNO;			//¹ȣ
	CString strAC_PWD;			//ºйȣ

	m_CtrlEdAccNoCtl.GetWindowText( strACNO );				// ¹ȣ.- ڸ 11ڸ
	strACNO.Remove('-');
	m_CtrlEdAccPwd.GetWindowText( strAC_PWD );				// ºйȣ
	if(theApp.m_TRCnt > 0)
	{
		for(int i=0; i < theApp.m_TRCnt; i++)
		{	RequestTrStockAccInfo( strACNO, strAC_PWD ); }
	}
	else
	{	RequestTrStockAccInfo( strACNO, strAC_PWD ); }

// 	CString strAccNo, strPwd;
// 
// 	int nIndex = m_AccNoCtl.GetCurSel();
// 	if (nIndex == CB_ERR)		return;
// 	m_AccNoCtl.GetLBText(nIndex, strAccNo);
// 	strAccNo.Remove('-');
// 
// 	m_CtrlEdAccPwd.GetWindowText( strPwd );
// 
// 	RequestTrStockAccInfo(strAccNo, strPwd);	
}

//  ȸ
int COvrsStckOrderDlg::RequestTrStockAccInfo(CString strACNO, CString strAC_PWD)
{
	CString strTemp, strTrCode = RQ_TRNAME_OVRS_ORDER_DEPOSIT;

	long nRQID = theApp.m_pCommAgent->CreateRequestID();
	if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ACNO"), strACNO) <= 0 )
	{
		::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "¹ȣ Է ", MB_OK|MB_TOPMOST);
		return 0;
	}
	if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("AC_PWD"), strAC_PWD) <= 0 )
	{
		::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "º Է ", MB_OK|MB_TOPMOST);
		return 0;
	}

	//	ſû
	if ( theApp.m_pCommAgent->RequestTran(nRQID, strTrCode, _T(""), 20) <= 0 )
	{
		CString strLastErrMsg = theApp.m_pCommAgent->GetLastErrMsg();
		::MessageBox(GetSafeHwnd(), strLastErrMsg, "ؿ Ź  û ", MB_OK|MB_TOPMOST);
		return 0;
	}

	return 0;

// 	TR_SACA314Q1_InRec1 InRec1;
// 	memset(&InRec1, 0x20, sizeof(TR_SACA314Q1_InRec1));
// 
// 	BOOL bCopyResult = FALSE;
// 
// 	//	¹ȣ(11)
// 	strAccNo.Remove('-');
// 	if ( strAccNo.GetLength() == 11 )
// 	{
// 		bCopyResult = CopyStrToChar(strAccNo, InRec1.acno, _countof(InRec1.acno));
// 		if(!bCopyResult) return FALSE;
// 	}
// 	else
// 	{
// 		AfxMessageBox("õ  ȣ ϴ.  ȣ ٽ ȮϽʽÿ \r\n");
// 		return FALSE;
// 	}
// 
// 	//	йȣ(11)
// 	strPwd.Trim();
// 	if ( strPwd.GetLength() > 0 )
// 	{
// 		CString strEncPwd = theApp.m_CommAgent.Encrypt(TRUE, strPwd);
// 		bCopyResult = CopyStrToChar(strEncPwd, InRec1.pwd, _countof(InRec1.pwd));
// 		if(!bCopyResult) return FALSE;
// 	}
// 	else
// 	{
// 		AfxMessageBox(" йȣ ϴ. йȣ ٽ ȮϽʽÿ \r\n");
// 		return FALSE;
// 	}
// 
// 	CString strTrCode, strDestination, strScreenNo;
// 
// 	strTrCode		= TR_SACA314Q1;
// 	strScreenNo		= _T("1234");
// 	strDestination	= (CString)TR_SACA314Q1_DEST_SERVER;
// 
// 
// 	int nRqID = theApp.m_CommAgent.CommRqData(strTrCode, (LPCTSTR)&InRec1, sizeof(TR_SACA314Q1_InRec1), 0, 0, 0, (LPCTSTR)strDestination, strScreenNo);
// 	return nRqID;
}

//	ܰȸ
void COvrsStckOrderDlg::OnBnClickedStockJanBtn()
{
	int		nPrevNext = 0;

	CString strACNO;			//¹ȣ
	CString strAC_PWD;			//ºйȣ
	CString strCMSN_ICLN_YN;	//Կ

	m_CtrlEdAccNoCtl.GetWindowText( strACNO );				// ¹ȣ.- ڸ 11ڸ
	strACNO.Remove('-');
	m_CtrlEdAccPwd.GetWindowText( strAC_PWD );				// ºйȣ
	strCMSN_ICLN_YN = _T("N");
	if(theApp.m_TRCnt > 0)
	{
		for(int i=0; i < theApp.m_TRCnt; i++)
		{	RequestTrOvrsJango( strACNO, strAC_PWD, strCMSN_ICLN_YN );	}
	}
	else
	{	RequestTrOvrsJango( strACNO, strAC_PWD, strCMSN_ICLN_YN );	}
}

void COvrsStckOrderDlg::ReceiveTrStockAccInfo(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	if ( nDataLength > 0 )
	{	// Data OK
		CString strAC_TDA, strMNYO_ABLE_A, strCSH_DFA, strCHCK_A, strETC_LND_A, strTemp;
		strAC_TDA = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVRS_ORDER_DEPOSIT, _T("OutRec1"), _T("AC_TDA"), 0);			//ѿ
		strAC_TDA.Trim();

		strMNYO_ABLE_A= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVRS_ORDER_DEPOSIT, _T("OutRec1"), _T("MNYO_ABLE_A"), 0);	//ݰɱݾ
		strMNYO_ABLE_A.Trim();

		strCSH_DFA= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVRS_ORDER_DEPOSIT, _T("OutRec1"), _T("CSH_DFA"), 0);			//ݹ̼
		strCSH_DFA.Trim();
		strCHCK_A= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVRS_ORDER_DEPOSIT, _T("OutRec1"), _T("CHCK_A"), 0);			//ǥݾ
		strCHCK_A.Trim();
		strETC_LND_A= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVRS_ORDER_DEPOSIT, _T("OutRec1"), _T("ETC_LND_A"), 0);		//Ÿ뿩ݾ
		strETC_LND_A.Trim();

		strTemp.Format("[] = ѿ(%s), ݰɱݾ(%s), ݹ̼(%s), ǥݾ(%s), Ÿ뿩ݾ(%s)", 
			theApp.SetComma(strAC_TDA), theApp.SetComma(strMNYO_ABLE_A), theApp.SetComma(strCSH_DFA), theApp.SetComma(strCHCK_A), theApp.SetComma(strETC_LND_A));

		AfxMessageBox(strTemp);
	}
	else
	{	// Error
		AfxMessageBox(sMessage);
	}
}

// ֹ 
void COvrsStckOrderDlg::ReceiveTrSendOrder(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage, int nType)
{
	if ( nDataLength > 0 )
	{	// Data Receive OK
		CString strMsg = _T(""), strOrderNo, strReceiveMsg = sMessage;
		strOrderNo = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OVRS_BS_ORDER, _T("OutRec1"), _T("ORD_NO"), 0);			//ֹȣ
		strOrderNo.Trim();

		// ֹȣ 0̸ . ڵ üũص 
		if ( _ttol(strOrderNo) == 0 || _ttol(sErrorCode) > 0 )
		{
			AfxMessageBox(sMessage);
			return;
		}

		strMsg = strReceiveMsg + "\r\n" + _T("[ֹȣ] ") + strOrderNo;
		m_edOutput.SetWindowText(strMsg);
		m_CtrlEdOrdNo.SetWindowText(strOrderNo);
	}
	else
	{	// Error
		AfxMessageBox(sMessage);
	}
}


void COvrsStckOrderDlg::SetAccNo()
{
/*	//1. 
		int nAccCount = theApp.m_CommAgent.GetAccountCount();
	
		CString strAccNo, strAccTemp, strAccSerialNo, strAccName, strAccCode;
		int nIndex(0);
	
		m_AccNoCtl.ResetContent();
	
		for (int i = 0; i < nAccCount; i++)
		{
			strAccNo = theApp.m_CommAgent.GetAccountNo(i);
			strAccNo = FormattingAcc(strAccNo);
	
			//    (0:ǰϷùȣ, 2:¸, 3:ǰڵ)
			strAccTemp = strAccNo;
			strAccTemp.Remove('-');
			strAccSerialNo	= theApp.m_CommAgent.GetAccInfo(strAccTemp, 0);
			strAccSerialNo.TrimLeft();		strAccSerialNo.TrimRight();
	
			strAccCode		= theApp.m_CommAgent.GetAccInfo(strAccTemp, 3);
			strAccCode.TrimLeft();			strAccCode.TrimRight();
	
			if (strAccCode == _T("1A") || strAccCode == _T("5A") || strAccCode == _T("5B"))
			{	// Ź, 
				m_AccNoCtl.InsertString(nIndex, strAccNo);
				nIndex++;
			}
		}
	
		m_AccNoCtl.SetCurSel(0);
	
		strAccNo = _T("");
		strAccName = _T("");
		m_AccNoCtl.GetLBText(0, strAccNo);
		strAccNo.Remove('-');
		strAccName		= theApp.m_CommAgent.GetAccInfo(strAccNo, 2);
		strAccName.TrimLeft();			strAccName.TrimRight();
		m_CtrlEdAccName.SetWindowText(strAccName);
*/
}

void COvrsStckOrderDlg::OnCbnSelchangeCmbCon()
{
// 	CString strAccNo;
// 	m_AccNoCtl.GetLBText(m_AccNoCtl.GetCurSel(), strAccNo);
// 	strAccNo.Remove('-');
// 
// 	CString strAccName = theApp.m_CommAgent.GetAccInfo(strAccNo, 2);
// 	strAccName.TrimLeft();			strAccName.TrimRight();
// 	m_CtrlEdAccName.SetWindowText(strAccName);
}


//*******************************************************************/
/*! Function Name : SetRealCode
/*! Function      : ֹ/ü  
/*! Param         : int nType (1:ֽ, 2:/)
/*! Return        : void
/*! Comment       : 
//******************************************************************/
void COvrsStckOrderDlg::SetRealCode(int nType, CString strUserId)
{
	if (strUserId.GetLength() == 0)
		return;

	if ( !theApp.m_pCommAgent || theApp.m_pCommAgent->GetSafeHwnd() == NULL )
	{
		AfxMessageBox(" Ǿ  ʽϴ.  ¸ Ȯ Ͻʽÿ. \r\n");
		return;
	}

	// ؿ ֹü  
	// (ǽð) Ÿ ûѴ.
	theApp.m_pCommAgent->RegisterReal(204, (LPCTSTR)strUserId );		//ü
	theApp.m_pCommAgent->RegisterReal(205, (LPCTSTR)strUserId );		//ܰ
}



//*******************************************************************/
/*! Function Name : UnSetRealCode
/*! Function      : ֹ/ü  
/*! Param         : int nType (1:ֽ, 2:/)
/*! Return        : void
/*! Comment       : 
//******************************************************************/
void COvrsStckOrderDlg::UnSetRealCode(int nType, CString strUserId)
{
	if (strUserId.GetLength() == 0)
		return;

	if ( !theApp.m_pCommAgent || theApp.m_pCommAgent->GetSafeHwnd() == NULL )
	{
		AfxMessageBox(" Ǿ  ʽϴ.  ¸ Ȯ Ͻʽÿ. \r\n");
		return;
	}

	// ؿ ֹü  
	// (ǽð) Ÿ Ѵ.
	theApp.m_pCommAgent->UnRegisterReal(204, (LPCTSTR)strUserId );		//ü
	theApp.m_pCommAgent->UnRegisterReal(205, (LPCTSTR)strUserId );		//ܰ
}
