// StCurrentDlg.cpp :  

///////////////////////////////////////////////////////////////////////////////////////////////////
// Header Files
#include "stdafx.h"
#include "ChampionAgentTest.h"
#include "ChampionAgentTestDlg.h"
#include "StCurrentDlg.h"

// #include "../../ChampionAgentHeader/TR_SACZ010Q1.h"
// #include "../../ChampionAgentHeader/realheader.h"

///////////////////////////////////////////////////////////////////////////////////////////////////
// Define Values
#define ARRAY_INDATA_COUNT_SIZE		5							// 迭 ڷϰ ޸byteũ
#define ARRAY_OUTDATA_COUNT_SIZE	ARRAY_INDATA_COUNT_SIZE		// 迭 ڷϰ ޸byteũ
#define RQ_VI						1

extern CChampionAgentTestDlg*	g_pTestDlg;

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

CStCurrentDlg::CStCurrentDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CStCurrentDlg::IDD, pParent)
{
	m_pParent = pParent;
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CStCurrentDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRealAddDlg)
	DDX_Control(pDX, IDC_LIST_HOGA,		m_ListHoga);
	DDX_Control(pDX, IDC_LIST_TICK,		m_ListTick);
	DDX_Control(pDX, IDC_LIST_NOW,		m_ListNow);
	DDX_Control(pDX, IDC_JONGMOK,		m_JongMok);
	DDX_Control(pDX, IDC_LIST_RQDATA,	m_ListRqData);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_EDIT_HOGA, m_pRealHoga);
	DDX_Control(pDX, IDC_EDIT_CHEGYUL, m_pRealChegyul);
}

BEGIN_MESSAGE_MAP(CStCurrentDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_CLOSE()
	ON_WM_QUERYDRAGICON()

	ON_BN_CLICKED(IDC_BTN_SEARCH,			&CStCurrentDlg::OnBnClickedBtnSearch)
	//ON_BN_CLICKED(IDC_BTN_JONGMOK_FO, &CStCurrentDlg::OnBnClickedBtnJongmokFo)
	ON_BN_CLICKED(IDC_BTN_JONGMOK_STOCK,	&CStCurrentDlg::OnBnClickedBtnJongmokStock)
	ON_BN_CLICKED(IDC_BTN_JONGMOK_FO,		&CStCurrentDlg::OnBnClickedBtnJongmokFo)
	ON_BN_CLICKED(IDC_RQ_VI_BTN,			OnBnClickedBtnRqVI)
END_MESSAGE_MAP()

// ʱ ó
BOOL CStCurrentDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	//  ȭ   մϴ.  α׷  â ȭ ڰ ƴ 쿡
	//  ӿũ  ۾ ڵ մϴ.
	SetIcon(m_hIcon, TRUE);			// ū  մϴ.
	SetIcon(m_hIcon, FALSE);		//   մϴ.

	//ʱ⸮Ʈ 
	InitListCtrl();

	return TRUE;  // Ŀ Ʈѿ   TRUE ȯմϴ.
}

void CStCurrentDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // ׸⸦  ̽ ؽƮԴϴ.

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Ŭ̾Ʈ 簢   ϴ.
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		//  ׸ϴ.
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

void CStCurrentDlg::OnClose()
{
	//ǽð 
	long nRet(0);
	short nMarketType = theApp.m_pCommAgent->GetMarketKubun(m_strCode, _T(""));
	if ( nMarketType == 24 )			//	
	{
		nRet = SetRealRemove(m_strCode, 65);	//	ü
		nRet = SetRealRemove(m_strCode, 51);	//	ȣ
	}
	else if ( nMarketType == 25 )		//	ɼ
	{
		nRet = SetRealRemove(m_strCode, 66);	//	ü
		nRet = SetRealRemove(m_strCode, 52);	//	ȣ
	}
	else if ( nMarketType == 64 )		//	ֽļ
	{
		nRet = SetRealRemove(m_strCode, 71);	//	ü
		nRet = SetRealRemove(m_strCode, 57);	//	ȣ
	}
	else if ( nMarketType == 38 )		//	ֽĿɼ
	{
		nRet = SetRealRemove(m_strCode, 72);	//	ü
		nRet = SetRealRemove(m_strCode, 58);	//	ȣ
	}
	else
	{
		nRet = SetRealRemove(m_strCode, 21);
		nRet = SetRealRemove(m_strCode, 1);

		// ǽð ȣ  ϱ
		int nStartIndex = 0; int nFoundIndex =0; int nSize = 0;
		CString sTemp=_T("");
		CString	strCodeList=_T("");
		CString strExpCode=_T("");
		CString strKeyString = RQ_FID_REQUEST_CODE;
		strKeyString += _T(",");
		while( (nFoundIndex = strKeyString.Find(",", nStartIndex)) != -1 )
		{
			sTemp = strKeyString.Mid( nStartIndex, nFoundIndex - nStartIndex);
			sTemp.Trim();

			if(sTemp.IsEmpty())
			{
				nStartIndex = nFoundIndex + 1;
				continue;
			}
			sTemp.Remove(',');
			if(nSize < 100)	// ǽð ѹ   ִ Ű   ִ 100̴.
			{
				nSize++;
				nStartIndex = nFoundIndex + 1;
				strExpCode = theApp.m_pCommAgent->GetExpCode(sTemp);
				strCodeList += strExpCode;
				strCodeList += _T(";");
			}
			else
			{
				break;
			}
		}
		int nRet=0;
	
		nRet = SetRealRemove(strCodeList, 21);	//ü
		nRet = SetRealRemove(strCodeList, 1);	//ȣ
	}

	CDialogEx::OnClose();
}

HCURSOR CStCurrentDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CStCurrentDlg::InitListCtrl()
{
	CFont nFont;
	NONCLIENTMETRICS ncm;
	//ncm.cbSize = sizeof(NONCLIENTMETRICS);
	ncm.cbSize = sizeof(NONCLIENTMETRICS) - sizeof(ncm.iPaddedBorderWidth);
	VERIFY(SystemParametersInfo(SPI_GETNONCLIENTMETRICS, sizeof(NONCLIENTMETRICS), &ncm, 0));
	nFont.CreateFontIndirect(&(ncm.lfMessageFont));

	m_ListHoga.SetFont(&nFont);
	m_ListHoga.InsertColumn(1, _T("ŵ"), LVCFMT_RIGHT, 80, 0);
	m_ListHoga.InsertColumn(2, _T(""), LVCFMT_RIGHT, 80, 0);
	m_ListHoga.InsertColumn(3, _T("ż"), LVCFMT_RIGHT, 80, 0);

	for (int i = 0; i < 11; i++)
	{
		m_ListHoga.InsertItem(i + 1, _T(""));
	}

	m_ListHoga.SetItemText(0, 0, _T("ŵ"));
	m_ListHoga.SetItemText(0, 2, _T("ż"));

	m_ListHoga.SetExtendedStyle(LVS_EX_ONECLICKACTIVATE | LVS_EX_INFOTIP | LVS_EX_GRIDLINES);

	m_ListTick.SetFont(&nFont);
	m_ListTick.InsertColumn(1, _T("ð"), LVCFMT_CENTER, 100, 0);
	m_ListTick.InsertColumn(2, _T("üᰡ"), LVCFMT_RIGHT, 100, 0);
	m_ListTick.InsertColumn(3, _T("üᷮ"), LVCFMT_RIGHT, 105, 0);
	m_ListTick.InsertColumn(4, _T("ŷ"), LVCFMT_RIGHT, 110, 0);

	m_ListTick.SetExtendedStyle(LVS_EX_ONECLICKACTIVATE | LVS_EX_INFOTIP | LVS_EX_GRIDLINES);

	m_ListNow.SetFont(&nFont);
	m_ListNow.InsertColumn(1, _T("簡"), LVCFMT_RIGHT, 80, 0);
	m_ListNow.InsertColumn(2, _T("ȣ"), LVCFMT_LEFT, 30, 0);
	m_ListNow.InsertColumn(3, _T(""), LVCFMT_RIGHT, 80, 0);
	m_ListNow.InsertColumn(4, _T(""), LVCFMT_RIGHT, 80, 0);
	m_ListNow.InsertColumn(5, _T(""), LVCFMT_RIGHT, 80, 0);
	m_ListNow.InsertColumn(6, _T(""), LVCFMT_RIGHT, 80, 0);

	m_ListNow.InsertItem(1, _T(""));
	
	m_ListNow.SetExtendedStyle(LVS_EX_ONECLICKACTIVATE | LVS_EX_INFOTIP | LVS_EX_GRIDLINES);
}

void CStCurrentDlg::InitListRqDataCtrl(int nType)
{
	CFont nFont;
	NONCLIENTMETRICS ncm;

	ncm.cbSize = sizeof(NONCLIENTMETRICS) - sizeof(ncm.iPaddedBorderWidth);
	VERIFY(SystemParametersInfo(SPI_GETNONCLIENTMETRICS, sizeof(NONCLIENTMETRICS), &ncm, 0));
	nFont.CreateFontIndirect(&(ncm.lfMessageFont));
	m_ListRqData.SetFont(&nFont);

	///////////////////////////////////////////////////////////////////////////////////////////////
	// LIST ʱȭ
	///////////////////////////////////////////////////////////////////////////////////////////////
	// List Item 
	m_ListRqData.DeleteAllItems();

	// List Column 
	int nListColumn = 0;

	nListColumn = m_ListRqData.GetHeaderCtrl()->GetItemCount();

	for (int i = 0; i < nListColumn; i++)
	{
		m_ListRqData.DeleteColumn(i);
	}
	///////////////////////////////////////////////////////////////////////////////////////////////

	m_ListRqData.InsertColumn(0, _T("ڵ(153)"),	LVCFMT_CENTER, 64, 0);
	m_ListRqData.InsertColumn(1, _T("(154)"),		LVCFMT_LEFT, 100, 0);
	m_ListRqData.InsertColumn(2, _T("簡(000)"),		LVCFMT_RIGHT, 80, 0);
	m_ListRqData.InsertColumn(3, _T("ϴ(002)"),	LVCFMT_RIGHT, 80, 0);
	m_ListRqData.InsertColumn(4, _T("(003)"),		LVCFMT_RIGHT, 80, 0);
	m_ListRqData.InsertColumn(5, _T("ŷ(004)"),		LVCFMT_RIGHT, 80, 0);
	m_ListRqData.InsertColumn(6, _T("Ѱ(011)"),		LVCFMT_RIGHT, 80, 0);
	m_ListRqData.InsertColumn(7, _T("Ѱ(012)"),		LVCFMT_RIGHT, 80, 0);
	m_ListRqData.InsertColumn(8, _T("ð(013)"),		LVCFMT_RIGHT, 80, 0);
	m_ListRqData.InsertColumn(9, _T("(014)"),		LVCFMT_RIGHT, 80, 0);
	m_ListRqData.InsertColumn(10, _T("(015)"),		LVCFMT_RIGHT, 80, 0);

	m_ListRqData.SetExtendedStyle(LVS_EX_ONECLICKACTIVATE | LVS_EX_INFOTIP | LVS_EX_GRIDLINES);

}

//  ȣ, ƽ, 簡 ȸ  ǽð 
void CStCurrentDlg::OnBnClickedBtnSearch()
{
	long nRet(0);
	CString strCode;
	// ȣ ȸ
	m_JongMok.GetWindowText(strCode);
	
	if (m_strCode != "" && m_strCode != strCode)
	{
		short nMarketType = theApp.m_pCommAgent->GetMarketKubun(m_strCode, _T(""));
		if ( nMarketType == 24 )			//	
		{
			nRet = SetRealRemove(m_strCode, 65);	//	ü
			nRet = SetRealRemove(m_strCode, 51);	//	ȣ
		}
		else if ( nMarketType == 25 )		//	ɼ
		{
			nRet = SetRealRemove(m_strCode, 66);	//	ü
			nRet = SetRealRemove(m_strCode, 52);	//	ȣ
		}
		else if ( nMarketType == 64 )		//	ֽļ
		{
			nRet = SetRealRemove(m_strCode, 71);	//	ü
			nRet = SetRealRemove(m_strCode, 57);	//	ȣ
		}
		else if ( nMarketType == 38 )		//	ֽĿɼ
		{
			nRet = SetRealRemove(m_strCode, 72);	//	ü
			nRet = SetRealRemove(m_strCode, 58);	//	ȣ
		}
		else
		{
			nRet = SetRealRemove(m_strCode, 21);
			nRet = SetRealRemove(m_strCode, 1);
		}
	}
	
	m_strCode = strCode;

	if (strCode.IsEmpty())
	{
		m_JongMok.SetFocus();
		return;
	}

	// ü ׸ Ŭ
	m_ListTick.DeleteAllItems();

	//	#define CODE_JONGMOK_D		1	//  
	//	#define CODE_KJONGMOK_D		2	// ڽ 
	//	#define CODE_OTCBB_D		3	// 3(OTCBB)
	//	#define CODE_KONEX_D		8	// ڳؽ
	//	#define CODE_FUTURE_D		24	// 
	//	#define CODE_OPTION_D		25	// ɼ
	//	#define CODE_UPJONG_D		26	// 峻
	//	#define CODE_KUPJONG_D		33	// ڽ 

	short nMarketType = theApp.m_pCommAgent->GetMarketKubun(strCode, _T(""));
	if ( nMarketType == 24 )			//	
	{
		//  簡 ü/ȣ ȸ
		RequestFutureSiseHoga(strCode);

		//  ü ü ȸ
		RequestFutureChe(strCode);
	}
	else if ( nMarketType == 25 )		//	ɼ
	{
		// ɼ 簡 ü/ȣ ȸ
		RequestOptionSiseHoga(strCode);

		// ɼ ü ü ȸ
		RequestOptionChe(strCode);
	}
	else if ( nMarketType == 64 )		//	ֽļ
	{
		//  簡 ü/ȣ ȸ
		RequestStockFutureSiseHoga(strCode);

		//  ü ü ȸ
		RequestStockFutureChe(strCode);
	}
	else if ( nMarketType == 38 )		//	ֽĿɼ
	{
		// ɼ 簡 ü/ȣ ȸ
		RequestStockOptionSiseHoga(strCode);

		// ɼ ü ü ȸ
		RequestStockOptionChe(strCode);
	}
	else
	{
	// 簡 ü ȸ
	RequestSise(strCode);

	// ȣ ȸ
	RequestHoga(strCode);

	// ü ü ȸ
	RequestChe(strCode);

	}


	// ǽð 
	if ( nMarketType == 24 )			//	
	{
		nRet = SetRealReg(strCode, 65);	//	ü
		nRet = SetRealReg(strCode, 51);	//	ȣ
	}
	else if ( nMarketType == 25 )		//	ɼ
	{
		nRet = SetRealReg(strCode, 66);	//	ü
		nRet = SetRealReg(strCode, 52);	//	ȣ
	}
	else if ( nMarketType == 64 )		//	ֽļ
	{
		nRet = SetRealReg(strCode, 71);	//	ü
		nRet = SetRealReg(strCode, 57);	//	ȣ
	}
	else if ( nMarketType == 38 )		//	ֽĿɼ
	{
		nRet = SetRealReg(strCode, 72);	//	ü
		nRet = SetRealReg(strCode, 58);	//	ȣ
	}
	else
	{
		nRet = SetRealReg(strCode, 21);	//	ü
		nRet = SetRealReg(strCode, 1); 	//	ȣ
	}

}


void CStCurrentDlg::RequestSise(CString strCode)
{ 
	g_pTestDlg->RequestSise(strCode);
}

void CStCurrentDlg::RequestHoga(CString strCode)
{ 
	g_pTestDlg->RequestHoga(strCode);
}

void CStCurrentDlg::RequestChe(CString strCode)
{ 
	g_pTestDlg->RequestChe(strCode);
}

void CStCurrentDlg::RequestFIDPortfolio(CString strCode)
{ 
	InitListRqDataCtrl(0);
	g_pTestDlg->RequestFIDPortfolio(strCode);
}

//  簡 ü/ȣ ȸ
void CStCurrentDlg::RequestFutureSiseHoga(CString strCode)
{ 
	g_pTestDlg->RequestFutureSiseHoga(strCode);
}

//  ü ü ȸ
void CStCurrentDlg::RequestFutureChe(CString strCode)
{ 
	g_pTestDlg->RequestFutureChe(strCode);
}

// ɼ 簡 ü/ȣ ȸ
void CStCurrentDlg::RequestOptionSiseHoga(CString strCode)
{ 
	g_pTestDlg->RequestOptionSiseHoga(strCode);
}

// ɼ ü ü ȸ
void CStCurrentDlg::RequestOptionChe(CString strCode)
{ 
	g_pTestDlg->RequestOptionChe(strCode);
}

// ֽļ 簡 ü/ȣ ȸ
void CStCurrentDlg::RequestStockFutureSiseHoga(CString strCode)
{ 
	g_pTestDlg->RequestStockFutureSiseHoga(strCode);
}

// ֽļ ü ü ȸ
void CStCurrentDlg::RequestStockFutureChe(CString strCode)
{ 
	g_pTestDlg->RequestStockFutureChe(strCode);
}

// ֽĿɼ 簡 ü/ȣ ȸ
void CStCurrentDlg::RequestStockOptionSiseHoga(CString strCode)
{ 
	g_pTestDlg->RequestStockOptionSiseHoga(strCode);
}

// ֽĿɼ ü ü ȸ
void CStCurrentDlg::RequestStockOptionChe(CString strCode)
{ 
	g_pTestDlg->RequestStockOptionChe(strCode);
}

//ǽð 
LONG CStCurrentDlg::SetRealReg(CString strCode, short nRealType)
{
	long nRet(0);

	// ǽð 
	if ( theApp.m_pCommAgent && theApp.m_pCommAgent->GetSafeHwnd() != NULL )
	{
		// (ǽð) Ÿ ûѴ.
		nRet = theApp.m_pCommAgent->RegisterReal(nRealType, (LPCTSTR)strCode );
	}
	else
	{
		AfxMessageBox(" Ǿ  ʽϴ.  ¸ Ȯ Ͻʽÿ. \r\n");
		return 0L;
	}
	return nRet;
}

//ǽð 
LONG CStCurrentDlg::SetRealRemove(CString strCode, short nRealType)
{
	long nRet(0);

	if ( theApp.m_pCommAgent && theApp.m_pCommAgent->GetSafeHwnd() != NULL )
	{
		// (ǽð) Ÿ ûѴ.
		theApp.m_pCommAgent->UnRegisterReal(nRealType, (LPCTSTR)strCode);
	}
	else
	{
		AfxMessageBox(" Ǿ  ʽϴ.  ¸ Ȯ Ͻʽÿ. \r\n");
		return 0L;
	}
	return nRet;
}


void CStCurrentDlg::OnReceiveRealDataChampioncommagentctrl(LPCTSTR sJongmokCode, short nPBID, LPCTSTR sRealData)
{
	switch(nPBID)
	{
		case 1:		//ȣ ֽ
		{
			CString strTemp, strTime, strCode, strOutValue;

			strCode = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("SCODE"));
			strCode.Trim();

			if (m_strCode == strCode)
			{
				//ð
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LTIME"));
				strTemp.Trim();
				if ( strTemp.GetLength() == 5 )
					strTemp.Insert(0, _T('0'));
				strTime = strTemp.Left(2) + ":" + strTemp.Mid(2,2) + ":" + strTemp.Right(2);
				m_ListHoga.SetItemText(0, 1, strTime);

				CString strOfferName = _T("LOFFER"), strBidName = _T("LBID"), strOfferrest = _T("LOFFERREST"), strBidrest = _T("LBIDREST");
				for (int i = 0; i < 5; i++)
				{
					// ŵȣ
					strTemp.Format(_T("%s%d"), strOfferName, i+1);
					strOutValue = theApp.m_pCommAgent->GetRealOutputData(nPBID, strTemp);
					strOutValue.Trim();
					if(strOutValue == "0")		strOutValue = _T("");
					strOutValue = theApp.SetComma(strOutValue);
					memset(m_Quote.szMaedoHoga[i], 0x00, _countof(m_Quote.szMaedoHoga[i]));
					memcpy(m_Quote.szMaedoHoga[i], strOutValue, strOutValue.GetLength());

					// żȣ
					strTemp.Format(_T("%s%d"), strBidName, i+1);
					strOutValue = theApp.m_pCommAgent->GetRealOutputData(nPBID, strTemp);
					strOutValue.Trim();
					if(strOutValue == "0")		strOutValue = _T("");
					strOutValue = theApp.SetComma(strOutValue);
					memset(m_Quote.szMaesuHoga[i], 0x00, _countof(m_Quote.szMaesuHoga[i]));
					memcpy(m_Quote.szMaesuHoga[i], strOutValue, strOutValue.GetLength());

					// ŵȣ ܷ
					strTemp.Format(_T("%s%d"), strOfferrest, i+1);
					strOutValue = theApp.m_pCommAgent->GetRealOutputData(nPBID, strTemp);
					strOutValue.Trim();
					if(strOutValue == "0")		strOutValue = _T("");
					strOutValue = theApp.SetComma(strOutValue);
					memset(m_Quote.szMaedoHoga_cnt[i], 0x00, _countof(m_Quote.szMaedoHoga_cnt[i]));
					memcpy(m_Quote.szMaedoHoga_cnt[i], strOutValue, strOutValue.GetLength());

					// żȣ
					strTemp.Format(_T("%s%d"), strBidrest, i+1);
					strOutValue = theApp.m_pCommAgent->GetRealOutputData(nPBID, strTemp);
					strOutValue.Trim();
					if(strOutValue == "0")		strOutValue = _T("");
					strOutValue = theApp.SetComma(strOutValue);
					memset(m_Quote.szMaesuHoga_cnt[i], 0x00, _countof(m_Quote.szMaesuHoga_cnt[i]));
					memcpy(m_Quote.szMaesuHoga_cnt[i], strOutValue, strOutValue.GetLength());
				}

				m_ListHoga.SetItemText(1, 1, m_Quote.szMaedoHoga[4]);
				m_ListHoga.SetItemText(2, 1, m_Quote.szMaedoHoga[3]);
				m_ListHoga.SetItemText(3, 1, m_Quote.szMaedoHoga[2]);
				m_ListHoga.SetItemText(4, 1, m_Quote.szMaedoHoga[1]);
				m_ListHoga.SetItemText(5, 1, m_Quote.szMaedoHoga[0]);
				m_ListHoga.SetItemText(6, 1, m_Quote.szMaesuHoga[0]);
				m_ListHoga.SetItemText(7, 1, m_Quote.szMaesuHoga[1]);
				m_ListHoga.SetItemText(8, 1, m_Quote.szMaesuHoga[2]);
				m_ListHoga.SetItemText(9, 1, m_Quote.szMaesuHoga[3]);
				m_ListHoga.SetItemText(10, 1, m_Quote.szMaesuHoga[4]);

				m_ListHoga.SetItemText(1, 0, m_Quote.szMaedoHoga_cnt[4]);
				m_ListHoga.SetItemText(2, 0, m_Quote.szMaedoHoga_cnt[3]);
				m_ListHoga.SetItemText(3, 0, m_Quote.szMaedoHoga_cnt[2]);
				m_ListHoga.SetItemText(4, 0, m_Quote.szMaedoHoga_cnt[1]);
				m_ListHoga.SetItemText(5, 0, m_Quote.szMaedoHoga_cnt[0]);
				m_ListHoga.SetItemText(6, 2, m_Quote.szMaesuHoga_cnt[0]);
				m_ListHoga.SetItemText(7, 2, m_Quote.szMaesuHoga_cnt[1]);
				m_ListHoga.SetItemText(8, 2, m_Quote.szMaesuHoga_cnt[2]);
				m_ListHoga.SetItemText(9, 2, m_Quote.szMaesuHoga_cnt[3]);
				m_ListHoga.SetItemText(10, 2, m_Quote.szMaesuHoga_cnt[4]);
			}
			else
			{
				strCode = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("SCODE"));
				strCode.Trim();
				strTime = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LTIME"));
				strTime.Trim();
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LOFFER1"));
				strTemp.Trim();
				strOutValue.Format("[ڵ] %s [ð] %s [ŵȣ] %s", strCode, strTime, strTemp);

				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LBID1"));
				strTemp.Trim();
				strOutValue += _T("[żȣ]");
				strOutValue += strTemp;

				m_pRealHoga.SetWindowText(strOutValue);
			}
		}
		break;
		case 21:	// ü ֽ
		{
			CString strCode, strPrice, strChangeGb, strChange, strRate, strQty, strQtyRate, strTime, strVol, strTemp;

			strCode = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("SCODE"));
			strCode.Trim();

			if (m_strCode == strCode)
			{
				//簡
				strPrice = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LCPRICE"));	strPrice.Trim();
				strPrice = theApp.SetComma(strPrice);

				//񱸺
				strChangeGb = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("CPCHECK"));	strChangeGb.Trim();
				if (strChangeGb == _T("2"))
				{
					strChangeGb = _T("");
				}
				else if (strChangeGb == _T("5"))
				{
					strChangeGb = _T("");
				}
				else if (strChangeGb == _T("1"))
				{
					strChangeGb = _T("");
				}
				else if (strChangeGb == _T("4"))
				{
					strChangeGb = _T("");
				}
				else
				{
					strChangeGb = _T("");
				}

				//
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LCPRICE"));	strTemp.Trim();
				strChange = theApp.SetComma(strTemp);

				//
				strRate.Format(_T("%0.2f"), _ttol(theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LDIFFRATE"))) / 100.0);
				strRate = strRate + "%";

				//ŷ
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LVOLUME"));	strTemp.Trim();
				strQty = theApp.SetComma(strTemp);

				//ϴŷ
				strQtyRate = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LVOLRATE"));	strQtyRate.Trim();

				//ð
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LTIME"));		strTemp.Trim();
				strTemp.Trim();
				if ( strTemp.GetLength() == 5 )
					strTemp.Insert(0, _T('0'));
				strTime = strTemp.Left(2) + ":" + strTemp.Mid(2,2) + ":" + strTemp.Right(2);

				//üᷮ
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LCURVOLUME"));	strTemp.Trim();
				strVol = theApp.SetComma(strTemp);

				//簡 Ʈ
				m_ListNow.SetItemText(0, 0, strPrice);
				m_ListNow.SetItemText(0, 1, strChangeGb);
				m_ListNow.SetItemText(0, 2, strChange);
				m_ListNow.SetItemText(0, 3, strRate);
				m_ListNow.SetItemText(0, 4, strQty);
				m_ListNow.SetItemText(0, 5, strQtyRate);

				//ð Ʈ
				m_ListTick.InsertItem(0, _T(""));
				m_ListTick.SetItemText(0, 0, strTime);	//ð
				m_ListTick.SetItemText(0, 1, strPrice);	//üᰡ
				m_ListTick.SetItemText(0, 2, strVol);	//üᷮ
				m_ListTick.SetItemText(0, 3, strQty);	//ŷ
			}
			else
			{
				CString strOutValue;
				strCode = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("SCODE"));
				strCode.Trim();
				strTime = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LTIME"));
				strTime.Trim();
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LCPRICE"));
				strTemp.Trim();
				strOutValue.Format("[ڵ] %s [ð] %s [簡] %s", strCode, strTime, strTemp);

				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LCURVOLUME"));
				strTemp.Trim();
				strOutValue += _T("[üᷮ]");
				strOutValue += strTemp;

				m_pRealChegyul.SetWindowText(strOutValue);
			}
		}
		break;
		case 65:	// üü ( ȣ Ʈ )
		case 66:	//ɼ üü ( ȣ Ʈ )
		case 71:	//ֽļ üü
		case 72:	//ֽĿɼ üü
		{
			CString strTemp, strTime, strCode, strOutValue;

			strCode = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("SCODE"));
			strCode.Trim();

			if (m_strCode == strCode)
			{
				if ( nPBID == 65 || nPBID == 66 )		//	 /ɼ ϰ츸 ȣ äش.
				{
					//ð
					strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LTIME"));
					strTemp.Trim();
					if ( strTemp.GetLength() == 5 )
						strTemp.Insert(0, _T('0'));
					strTime = strTemp.Left(2) + ":" + strTemp.Mid(2,2) + ":" + strTemp.Right(2);
					m_ListHoga.SetItemText(0, 1, strTime);

					CString strOfferName = _T("LOFFER"), strBidName = _T("LBID"), strOfferrest = _T("LOFFERREST"), strBidrest = _T("LBIDREST");
					for (int i = 0; i < 5; i++)
					{
						// ŵȣ
						strTemp.Format(_T("%s%d"), strOfferName, i+1);
						strOutValue = theApp.m_pCommAgent->GetRealOutputData(nPBID, strTemp);
						strOutValue.Trim();
						if(strOutValue == "0")		strOutValue = _T("");
						strTemp.Format(_T("%0.2f"), _ttol(strOutValue) / 100.0);
						strOutValue = theApp.SetComma(strTemp);
						memset(m_Quote.szMaedoHoga[i], 0x00, _countof(m_Quote.szMaedoHoga[i]));
						memcpy(m_Quote.szMaedoHoga[i], strOutValue, strOutValue.GetLength());

						// żȣ
						strTemp.Format(_T("%s%d"), strBidName, i+1);
						strOutValue = theApp.m_pCommAgent->GetRealOutputData(nPBID, strTemp);
						strOutValue.Trim();
						if(strOutValue == "0")		strOutValue = _T("");
						strTemp.Format(_T("%0.2f"), _ttol(strOutValue) / 100.0);
						strOutValue = theApp.SetComma(strTemp);
						memset(m_Quote.szMaesuHoga[i], 0x00, _countof(m_Quote.szMaesuHoga[i]));
						memcpy(m_Quote.szMaesuHoga[i], strOutValue, strOutValue.GetLength());

						// ŵȣ ܷ
						strTemp.Format(_T("%s%d"), strOfferrest, i+1);
						strOutValue = theApp.m_pCommAgent->GetRealOutputData(nPBID, strTemp);
						strOutValue.Trim();
						if(strOutValue == "0")		strOutValue = _T("");
						strOutValue = theApp.SetComma(strOutValue);
						memset(m_Quote.szMaedoHoga_cnt[i], 0x00, _countof(m_Quote.szMaedoHoga_cnt[i]));
						memcpy(m_Quote.szMaedoHoga_cnt[i], strOutValue, strOutValue.GetLength());

						// żȣ ܷ
						strTemp.Format(_T("%s%d"), strBidrest, i+1);
						strOutValue = theApp.m_pCommAgent->GetRealOutputData(nPBID, strTemp);
						strOutValue.Trim();
						if(strOutValue == "0")		strOutValue = _T("");
						strOutValue = theApp.SetComma(strOutValue);
						memset(m_Quote.szMaesuHoga_cnt[i], 0x00, _countof(m_Quote.szMaesuHoga_cnt[i]));
						memcpy(m_Quote.szMaesuHoga_cnt[i], strOutValue, strOutValue.GetLength());
					}

					m_ListHoga.SetItemText(1, 1, m_Quote.szMaedoHoga[4]);
					m_ListHoga.SetItemText(2, 1, m_Quote.szMaedoHoga[3]);
					m_ListHoga.SetItemText(3, 1, m_Quote.szMaedoHoga[2]);
					m_ListHoga.SetItemText(4, 1, m_Quote.szMaedoHoga[1]);
					m_ListHoga.SetItemText(5, 1, m_Quote.szMaedoHoga[0]);
					m_ListHoga.SetItemText(6, 1, m_Quote.szMaesuHoga[0]);
					m_ListHoga.SetItemText(7, 1, m_Quote.szMaesuHoga[1]);
					m_ListHoga.SetItemText(8, 1, m_Quote.szMaesuHoga[2]);
					m_ListHoga.SetItemText(9, 1, m_Quote.szMaesuHoga[3]);
					m_ListHoga.SetItemText(10, 1, m_Quote.szMaesuHoga[4]);

					m_ListHoga.SetItemText(1, 0, m_Quote.szMaedoHoga_cnt[4]);
					m_ListHoga.SetItemText(2, 0, m_Quote.szMaedoHoga_cnt[3]);
					m_ListHoga.SetItemText(3, 0, m_Quote.szMaedoHoga_cnt[2]);
					m_ListHoga.SetItemText(4, 0, m_Quote.szMaedoHoga_cnt[1]);
					m_ListHoga.SetItemText(5, 0, m_Quote.szMaedoHoga_cnt[0]);
					m_ListHoga.SetItemText(6, 2, m_Quote.szMaesuHoga_cnt[0]);
					m_ListHoga.SetItemText(7, 2, m_Quote.szMaesuHoga_cnt[1]);
					m_ListHoga.SetItemText(8, 2, m_Quote.szMaesuHoga_cnt[2]);
					m_ListHoga.SetItemText(9, 2, m_Quote.szMaesuHoga_cnt[3]);
					m_ListHoga.SetItemText(10, 2, m_Quote.szMaesuHoga_cnt[4]);
				}

				//	簡 Ʈ ä ( ȣ+ü    ȣ ö ü͸ Ʈ ش.
				CString strPrice, strChangeGb, strChange, strRate, strQty, strVol, strTemp;

				//簡
				//strPrice = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LCPRICE"));	strPrice.Trim();
				strTemp.Format(_T("%0.2f"), _ttol(theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LCPRICE"))) / 100.0);
				strPrice = theApp.SetComma(strTemp);

				//񱸺
				strChangeGb = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("CPCHECK"));	strChangeGb.Trim();
				if (strChangeGb == _T("2"))
				{
					strChangeGb = _T("");
				}
				else if (strChangeGb == _T("5"))
				{
					strChangeGb = _T("");
				}
				else if (strChangeGb == _T("1"))
				{
					strChangeGb = _T("");
				}
				else if (strChangeGb == _T("4"))
				{
					strChangeGb = _T("");
				}
				else
				{
					strChangeGb = _T("");
				}

				//
				//strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LCPRICE"));	strTemp.Trim();
				strTemp.Format(_T("%0.2f"), _ttol(theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LCPRICE"))) / 100.0);
				strChange = theApp.SetComma(strTemp);

				//
				//strRate = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LDIFFRATE"));	strRate.Trim();
				strTemp.Format(_T("%0.2f"), _ttol(theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LDIFFRATE"))) / 100.0);
				strRate = theApp.SetComma(strTemp) + "%";

				//ŷ
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LVOLUME"));	strTemp.Trim();
				strQty = theApp.SetComma(strTemp);

// 				//ϴŷ
// 				strQtyRate = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LVOLRATE"));	strQtyRate.Trim();

				//ð
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LTIME"));		strTemp.Trim();
				strTemp.Trim();
				if ( strTemp.GetLength() == 5 )
					strTemp.Insert(0, _T('0'));
				strTime = strTemp.Left(2) + ":" + strTemp.Mid(2,2) + ":" + strTemp.Right(2);

				//üᷮ
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LCURVOLUME"));	strTemp.Trim();
				strVol = theApp.SetComma(strTemp);

				//簡 Ʈ
				m_ListNow.SetItemText(0, 0, strPrice);
				m_ListNow.SetItemText(0, 1, strChangeGb);
				m_ListNow.SetItemText(0, 2, strChange);
				m_ListNow.SetItemText(0, 3, strRate);
				m_ListNow.SetItemText(0, 4, strQty);
//				m_ListNow.SetItemText(0, 5, strQtyRate);
				m_ListNow.SetItemText(0, 5, _T(""));

				//ð Ʈ
				m_ListTick.InsertItem(0, _T(""));
				m_ListTick.SetItemText(0, 0, strTime);	//ð
				m_ListTick.SetItemText(0, 1, strPrice);	//üᰡ
				m_ListTick.SetItemText(0, 2, strVol);	//üᷮ
				m_ListTick.SetItemText(0, 3, strQty);	//ŷ

			}
		}
		break;
		case 51:	//  ȣ
		case 52:	// ɼ ȣ
		case 57:	// ֽļ ȣ
		case 58:	// ֽĿɼ ȣ
			{
				CString strCode, strPrice, strChangeGb, strChange, strRate, strQty, strQtyRate, strTime, strVol, strTemp, strOutValue;

				strCode = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("SCODE"));
				strCode.Trim();

				if (m_strCode == strCode)
				{
					//ð
					strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LTIME"));
					strTemp.Trim();
					if ( strTemp.GetLength() == 5 )
						strTemp.Insert(0, _T('0'));
					strTime = strTemp.Left(2) + ":" + strTemp.Mid(2,2) + ":" + strTemp.Right(2);
					m_ListHoga.SetItemText(0, 1, strTime);

					CString strOfferName = _T("LOFFER"), strBidName = _T("LBID"), strOfferrest = _T("LOFFERREST"), strBidrest = _T("LBIDREST");
					for (int i = 0; i < 5; i++)
					{
						// ŵȣ
						strTemp.Format(_T("%s%d"), strOfferName, i+1);
						strOutValue = theApp.m_pCommAgent->GetRealOutputData(nPBID, strTemp);
						strOutValue.Trim();
						if(strOutValue == "0")		strOutValue = _T("");
						strTemp.Format(_T("%0.2f"), _ttol(strOutValue) / 100.0);
						strOutValue = theApp.SetComma(strTemp);
						memset(m_Quote.szMaedoHoga[i], 0x00, _countof(m_Quote.szMaedoHoga[i]));
						memcpy(m_Quote.szMaedoHoga[i], strOutValue, strOutValue.GetLength());

						// żȣ
						strTemp.Format(_T("%s%d"), strBidName, i+1);
						strOutValue = theApp.m_pCommAgent->GetRealOutputData(nPBID, strTemp);
						strOutValue.Trim();
						if(strOutValue == "0")		strOutValue = _T("");
						strTemp.Format(_T("%0.2f"), _ttol(strOutValue) / 100.0);
						strOutValue = theApp.SetComma(strTemp);
						memset(m_Quote.szMaesuHoga[i], 0x00, _countof(m_Quote.szMaesuHoga[i]));
						memcpy(m_Quote.szMaesuHoga[i], strOutValue, strOutValue.GetLength());

						// ŵȣ ܷ
						strTemp.Format(_T("%s%d"), strOfferrest, i+1);
						strOutValue = theApp.m_pCommAgent->GetRealOutputData(nPBID, strTemp);
						strOutValue.Trim();
						if(strOutValue == "0")		strOutValue = _T("");
						strOutValue = theApp.SetComma(strOutValue);
						memset(m_Quote.szMaedoHoga_cnt[i], 0x00, _countof(m_Quote.szMaedoHoga_cnt[i]));
						memcpy(m_Quote.szMaedoHoga_cnt[i], strOutValue, strOutValue.GetLength());

						// żȣ ܷ
						strTemp.Format(_T("%s%d"), strBidrest, i+1);
						strOutValue = theApp.m_pCommAgent->GetRealOutputData(nPBID, strTemp);
						strOutValue.Trim();
						if(strOutValue == "0")		strOutValue = _T("");
						strOutValue = theApp.SetComma(strOutValue);
						memset(m_Quote.szMaesuHoga_cnt[i], 0x00, _countof(m_Quote.szMaesuHoga_cnt[i]));
						memcpy(m_Quote.szMaesuHoga_cnt[i], strOutValue, strOutValue.GetLength());
					}

					m_ListHoga.SetItemText(1, 1, m_Quote.szMaedoHoga[4]);
					m_ListHoga.SetItemText(2, 1, m_Quote.szMaedoHoga[3]);
					m_ListHoga.SetItemText(3, 1, m_Quote.szMaedoHoga[2]);
					m_ListHoga.SetItemText(4, 1, m_Quote.szMaedoHoga[1]);
					m_ListHoga.SetItemText(5, 1, m_Quote.szMaedoHoga[0]);
					m_ListHoga.SetItemText(6, 1, m_Quote.szMaesuHoga[0]);
					m_ListHoga.SetItemText(7, 1, m_Quote.szMaesuHoga[1]);
					m_ListHoga.SetItemText(8, 1, m_Quote.szMaesuHoga[2]);
					m_ListHoga.SetItemText(9, 1, m_Quote.szMaesuHoga[3]);
					m_ListHoga.SetItemText(10, 1, m_Quote.szMaesuHoga[4]);

					m_ListHoga.SetItemText(1, 0, m_Quote.szMaedoHoga_cnt[4]);
					m_ListHoga.SetItemText(2, 0, m_Quote.szMaedoHoga_cnt[3]);
					m_ListHoga.SetItemText(3, 0, m_Quote.szMaedoHoga_cnt[2]);
					m_ListHoga.SetItemText(4, 0, m_Quote.szMaedoHoga_cnt[1]);
					m_ListHoga.SetItemText(5, 0, m_Quote.szMaedoHoga_cnt[0]);
					m_ListHoga.SetItemText(6, 2, m_Quote.szMaesuHoga_cnt[0]);
					m_ListHoga.SetItemText(7, 2, m_Quote.szMaesuHoga_cnt[1]);
					m_ListHoga.SetItemText(8, 2, m_Quote.szMaesuHoga_cnt[2]);
					m_ListHoga.SetItemText(9, 2, m_Quote.szMaesuHoga_cnt[3]);
					m_ListHoga.SetItemText(10, 2, m_Quote.szMaesuHoga_cnt[4]);
				}
			}
			break;
	}
}

// FID Ÿ  ̺Ʈ
void CStCurrentDlg::OnReceiveFidDataChampioncommagentctrl(long nRqId, LPCTSTR sTrCode, LPCTSTR sData, long nDataLength,	LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage, LPCTSTR sSplmMsg)
{
	CString strTrCode(sTrCode);

	if (strTrCode == RQ_FIDNAME_STOCK)
	{	// ü
		ReceiveFIDPortfolio( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
}


void CStCurrentDlg::OnBnClickedBtnJongmokStock()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	OnBnClickedBtnSearch();
	
}
// 
	
void CStCurrentDlg::OnBnClickedBtnJongmokFo()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	OnBnClickedBtnSearch();
}

void CStCurrentDlg::OnBnClickedBtnRqVI()
{
	RequestFIDPortfolio(RQ_FID_REQUEST_CODE);
	// ǽð ȣ  ϱ
	int nStartIndex = 0; int nFoundIndex =0; int nSize = 0;
	CString sTemp=_T("");
	CString	strCodeList=_T("");
	CString strExpCode=_T("");
	CString strKeyString = RQ_FID_REQUEST_CODE;
	strKeyString += _T(",");
	while( (nFoundIndex = strKeyString.Find(",", nStartIndex)) != -1 )
	{
		sTemp = strKeyString.Mid( nStartIndex, nFoundIndex - nStartIndex);
		sTemp.Trim();

		if(sTemp.IsEmpty())
		{
			nStartIndex = nFoundIndex + 1;
			continue;
		}
		sTemp.Remove(',');
		if(nSize < 100)	// ǽð ѹ   ִ Ű   ִ 100̴.
		{
			nSize++;
			nStartIndex = nFoundIndex + 1;
			strExpCode = theApp.m_pCommAgent->GetExpCode(sTemp);
			strCodeList += strExpCode;
			strCodeList += _T(";");
		}
		else
		{
			break;
		}
	}
	int nRet=0;
		
	nRet = SetRealReg(strCodeList, 21);	//ü
	nRet = SetRealReg(strCodeList, 1);	//ȣ
	// ǽð ȣ  ϱ
}


// TR Ÿ  ̺Ʈ
void CStCurrentDlg::OnReceiveTrDataChampioncommagentctrl(long nRqId, LPCTSTR sTrCode, LPCTSTR sData, long nDataLength,	LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage, LPCTSTR sSplmMsg)
{
	CString strTrCode(sTrCode);

	if (strTrCode == RQ_TRNAME_STOCK_PRICE)
	{	// ü
		ReceiveTrSise( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
	else if (strTrCode == RQ_TRNAME_STOCK_HOGA)
	{	// ֽ켱ȣDATATR
		ReceiveTrHoga( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
	else if (strTrCode == RQ_TRNAME_STOCK_CHE)
	{	// ֽ  ü DATA
		ReceiveTrChe( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
	else if (strTrCode == RQ_TRNAME_FUTURE_PRICE)
	{	//   Master(üü+ȣ)
		ReceiveTrFutureSiseHoga(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage);
	}
	else if (strTrCode == RQ_TRNAME_FUTURE_CHE)
	{	//   ü ƽ array
		ReceiveTrFutureChe(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage);
	}
	else if (strTrCode == RQ_TRNAME_OPTION_PRICE)
	{	//  ɼ Master(üü+ȣ)
		ReceiveTrOptionSiseHoga(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage);
	}
	else if (strTrCode == RQ_TRNAME_OPTION_CHE)
	{	//  ɼ ü ƽ array
		ReceiveTrOptionChe(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage);
	}
	else if (strTrCode == RQ_TRNAME_STOCK_FUTURE_PRICE)
	{	// ֽ  Master(üü+ȣ)
		ReceiveTrStockFutureSiseHoga(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage);
	}
	else if (strTrCode == RQ_TRNAME_STOCK_FUTURE_CHE)
	{	// ֽ  ü ƽ array
		ReceiveTrStockFutureChe(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage);
	}
	else if (strTrCode == RQ_TRNAME_STOCK_OPTION_PRICE)
	{	// ֽ ɼ Master(üü+ȣ)
		ReceiveTrStockOptionSiseHoga(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage);
	}
	else if (strTrCode == RQ_TRNAME_STOCK_OPTION_CHE)
	{	// ֽ ɼ ü ƽ array
		ReceiveTrStockOptionChe(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage);
	}
}

void CStCurrentDlg::ReceiveTrSise(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strCode, strTime, strPrice, strVolume, strPrevVolume, strTemp;
	int		nDataCnt = 0, nDataOffset = 0;

	if ( nDataLength > 0 )
	{
		CString strOutValue = _T("");
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_PRICE, _T("OutRec1"), _T("SNAME"), 0);			//Ī(20)
		strTemp		= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_PRICE, _T("OutRec1"), _T("LTIME"), 0);			//ð(4)
		strTemp.Trim();
		if ( strTemp.GetLength() == 5 )
			strTemp.Insert(0, _T('0'));
		strTime = strTemp.Left(2) + ":" + strTemp.Mid(2,2) + ":" + strTemp.Right(2);
		m_ListHoga.SetItemText(0, 1, strTime);

		strPrice	= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_PRICE, _T("OutRec1"), _T("LCPRICE"), 0);			//簡(4)
		m_ListNow.SetItemText(0, 0, theApp.SetComma(strPrice));	//簡

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_PRICE, _T("OutRec1"), _T("LFACEPRICE"), 0);	//׸鰡(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_PRICE, _T("OutRec1"), _T("LDIFF"), 0);			//ϴ(4)
		m_ListNow.SetItemText(0, 2, theApp.SetComma(strOutValue));	//

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_PRICE, _T("OutRec1"), _T("CPCHECK"), 0);		//ȣ(1)
		if(strOutValue == _T("2"))
			strOutValue = _T("");
		else if(strOutValue == _T("5"))
			strOutValue = _T("");
		else if (strOutValue == _T("1"))
			strOutValue = _T("");
		else if (strOutValue == _T("4"))
			strOutValue = _T("");
		else
			strOutValue = _T("");
		m_ListNow.SetItemText(0, 1, strOutValue);	//ȣ

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_PRICE, _T("OutRec1"), _T("LLSTCPRICE"), 0);		//(4)
		//	  = ((簡-ذ)/ذ)*100
		strTemp.Format(_T("%0.2f"), (double)(_ttol(strPrice) - _ttol(strOutValue)) / _ttol(strOutValue) * 100.0 );
		if (strTemp == "0.00") strTemp = "0";
		strTemp = strTemp + "%";
		m_ListNow.SetItemText(0, 3, strTemp);	//
		
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_PRICE, _T("OutRec1"), _T("LOPRICE"), 0);		//ð(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_PRICE, _T("OutRec1"), _T("LHPRICE"), 0);		//(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_PRICE, _T("OutRec1"), _T("LLPRICE"), 0);		//(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_PRICE, _T("OutRec1"), _T("LULIMITPRICE"), 0);	//Ѱ(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_PRICE, _T("OutRec1"), _T("LLLIMITPRICE"), 0);	//Ѱ(4)
		strVolume	= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_PRICE, _T("OutRec1"), _T("LVOLUME"), 0);		//ŷ(4)
		m_ListNow.SetItemText(0, 4, theApp.SetComma(strVolume));	//ŷ

		strPrevVolume = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_PRICE, _T("OutRec1"), _T("LLSTVOLUME"), 0);		//ϰŷ(4)

		//ŷ
		// =IF(OR(ŷ==0,ϰŷ==0),"0",IF(ŷ>ϰŷ,(ŷ/ϰŷ)*100,IF((ŷ/ϰŷ)<0.0001,"0",(ŷ/ϰŷ)*100*-1)))
		long nVolume = _ttol(strVolume), nPrevVolume = _ttol(strPrevVolume);
		if ( nVolume == 0 || nPrevVolume == 0)
			strTemp = _T("0");
		else
		{
			if (nVolume > nPrevVolume)
				strTemp.Format(_T("%0.2f"), (double)(nVolume / nPrevVolume) * 100.0 );
			else 
			{
				if ( (nVolume / nPrevVolume) < 0.0001 )
					strTemp = _T("0");
				else
					strTemp.Format(_T("%0.2f"), (double)(nVolume / nPrevVolume) * 100.0 * -1 );
			}
		}
		strTemp = strTemp + "%";
		m_ListNow.SetItemText(0, 5, _T("0"));	//ŷ

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_PRICE, _T("OutRec1"), _T("SNAME"), 0);			//Ī(20)
	}
}

void CStCurrentDlg::ReceiveTrHoga(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strCode, strTime, strPrice, strVolume, strPrevVolume, strTemp;
	int		nDataCnt = 0, nDataOffset = 0;

	if ( nDataLength > 0 )
	{
		CString strOutValue = _T("");
		CString strOfferName = _T("LOFFER"), strBidName = _T("LBID"), strOfferrest = _T("LOFFERREST"), strBidrest = _T("LBIDREST");
		for (int i = 0; i < 5; i++)
		{
			// ŵȣ
			strTemp.Format(_T("%s%d"), strOfferName, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_HOGA, _T("OutRec1"), strTemp, 0);
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strOutValue = theApp.SetComma(strOutValue);
			memset(m_Quote.szMaedoHoga[i], 0x00, _countof(m_Quote.szMaedoHoga[i]));
			memcpy(m_Quote.szMaedoHoga[i], strOutValue, strOutValue.GetLength());

			// żȣ
			strTemp.Format(_T("%s%d"), strBidName, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_HOGA, _T("OutRec1"), strTemp, 0);
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strOutValue = theApp.SetComma(strOutValue);
			memset(m_Quote.szMaesuHoga[i], 0x00, _countof(m_Quote.szMaesuHoga[i]));
			memcpy(m_Quote.szMaesuHoga[i], strOutValue, strOutValue.GetLength());

			// ŵȣ ܷ
			strTemp.Format(_T("%s%d"), strOfferrest, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_HOGA, _T("OutRec1"), strTemp, 0);
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strOutValue = theApp.SetComma(strOutValue);
			memset(m_Quote.szMaedoHoga_cnt[i], 0x00, _countof(m_Quote.szMaedoHoga_cnt[i]));
			memcpy(m_Quote.szMaedoHoga_cnt[i], strOutValue, strOutValue.GetLength());

			// żȣ
			strTemp.Format(_T("%s%d"), strBidrest, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_HOGA, _T("OutRec1"), strTemp, 0);
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strOutValue = theApp.SetComma(strOutValue);
			memset(m_Quote.szMaesuHoga_cnt[i], 0x00, _countof(m_Quote.szMaesuHoga_cnt[i]));
			memcpy(m_Quote.szMaesuHoga_cnt[i], strOutValue, strOutValue.GetLength());
		}

		m_ListHoga.SetItemText(1, 1, m_Quote.szMaedoHoga[4]);
		m_ListHoga.SetItemText(2, 1, m_Quote.szMaedoHoga[3]);
		m_ListHoga.SetItemText(3, 1, m_Quote.szMaedoHoga[2]);
		m_ListHoga.SetItemText(4, 1, m_Quote.szMaedoHoga[1]);
		m_ListHoga.SetItemText(5, 1, m_Quote.szMaedoHoga[0]);
		m_ListHoga.SetItemText(6, 1, m_Quote.szMaesuHoga[0]);
		m_ListHoga.SetItemText(7, 1, m_Quote.szMaesuHoga[1]);
		m_ListHoga.SetItemText(8, 1, m_Quote.szMaesuHoga[2]);
		m_ListHoga.SetItemText(9, 1, m_Quote.szMaesuHoga[3]);
		m_ListHoga.SetItemText(10, 1, m_Quote.szMaesuHoga[4]);

		m_ListHoga.SetItemText(1, 0, m_Quote.szMaedoHoga_cnt[4]);
		m_ListHoga.SetItemText(2, 0, m_Quote.szMaedoHoga_cnt[3]);
		m_ListHoga.SetItemText(3, 0, m_Quote.szMaedoHoga_cnt[2]);
		m_ListHoga.SetItemText(4, 0, m_Quote.szMaedoHoga_cnt[1]);
		m_ListHoga.SetItemText(5, 0, m_Quote.szMaedoHoga_cnt[0]);
		m_ListHoga.SetItemText(6, 2, m_Quote.szMaesuHoga_cnt[0]);
		m_ListHoga.SetItemText(7, 2, m_Quote.szMaesuHoga_cnt[1]);
		m_ListHoga.SetItemText(8, 2, m_Quote.szMaesuHoga_cnt[2]);
		m_ListHoga.SetItemText(9, 2, m_Quote.szMaesuHoga_cnt[3]);
		m_ListHoga.SetItemText(10, 2, m_Quote.szMaesuHoga_cnt[4]);

	}
}

void CStCurrentDlg::ReceiveTrChe(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strCode, strTime, strPrice, strVolume, strPrevVolume, strTemp;
	int		nDataCnt = 0, nDataOffset = 0;

	if ( nDataLength > 0 )
	{
		long nRowCount = theApp.m_pCommAgent->GetTranOutputRowCnt(RQ_TRNAME_STOCK_CHE, _T("OutRec2"));						//  Ǽ

		CString strOutValue = _T("");
		for (int i = 0; i < nRowCount; i++)
		{ 	
			//	 ߰
			m_ListTick.InsertItem(i, _T(""));

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_CHE, _T("OutRec2"), _T("LTIME"), i);		//ð
			strOutValue.Trim();
			if ( strOutValue.GetLength() == 5 )
				strOutValue.Insert(0, _T('0'));
			strTemp.Format(_T("%s:%s:%s"), strOutValue.Left(2), strOutValue.Mid(2,2), strOutValue.Right(2));
			m_ListTick.SetItemText(i, 0, strTemp);	//ð

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_CHE, _T("OutRec2"), _T("LCPRICE"), i);	//簡
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strTemp = theApp.SetComma(strOutValue);
			m_ListTick.SetItemText(i, 1, strTemp);	//簡

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_CHE, _T("OutRec2"), _T("LNETVOLUME"), i);	//üᷮ
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strTemp = theApp.SetComma(strOutValue);
			m_ListTick.SetItemText(i, 2, strTemp);	//üᷮ

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_CHE, _T("OutRec2"), _T("LVOLUME"), i);	//ŷ
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strTemp = theApp.SetComma(strOutValue);
			m_ListTick.SetItemText(i, 3, strTemp);	//ŷ

		}
	}
}

void CStCurrentDlg::ReceiveTrFutureSiseHoga(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strCode, strTime, strPrice, strVolume, strPrevVolume, strTemp;
	int		nDataCnt = 0, nDataOffset = 0;

	if ( nDataLength > 0 )
	{
		CString strOutValue = _T("");
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_PRICE, _T("OutRec1"), _T("SHNAME"), 0);		//Ī(20)
		strTemp		= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_PRICE, _T("OutRec1"), _T("LTIME"), 0);			//ð(4)
		strTemp.Trim();
		if ( strTemp.GetLength() == 5 )
			strTemp.Insert(0, _T('0'));
		strTime = strTemp.Left(2) + ":" + strTemp.Mid(2,2) + ":" + strTemp.Right(2);
		m_ListHoga.SetItemText(0, 1, strTime);

		strPrice	= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_PRICE, _T("OutRec1"), _T("LCPRICE"), 0);			//簡(4)
		strTemp.Format(_T("%0.2f"), _ttol(strPrice) / 100.0);
		strOutValue = theApp.SetComma(strTemp);
		m_ListNow.SetItemText(0, 0, strOutValue);	//簡

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_PRICE, _T("OutRec1"), _T("LFACEPRICE"), 0);	//׸鰡(4)
		strTemp.Format(_T("%0.2f"), _ttol(strOutValue) / 100.0);
		strOutValue = theApp.SetComma(strTemp);

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_PRICE, _T("OutRec1"), _T("LDIFF"), 0);			//ϴ(4)
		strTemp.Format(_T("%0.2f"), _ttol(strOutValue) / 100.0);
		strOutValue = theApp.SetComma(strTemp);
		m_ListNow.SetItemText(0, 2, strOutValue);	//

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_PRICE, _T("OutRec1"), _T("CPCHECK"), 0);		//ȣ(1)
		if(strOutValue == _T("2"))
			strOutValue = _T("");
		else if(strOutValue == _T("5"))
			strOutValue = _T("");
		else if (strOutValue == _T("1"))
			strOutValue = _T("");
		else if (strOutValue == _T("4"))
			strOutValue = _T("");
		else
			strOutValue = _T("");
		m_ListNow.SetItemText(0, 1, strOutValue);	//ȣ

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_PRICE, _T("OutRec1"), _T("LLSTCPRICE"), 0);		//(4)
		//	  = ((簡-ذ)/ذ)*100
		strTemp.Format(_T("%0.2f"), (double)(_ttol(strPrice) - _ttol(strOutValue)) / _ttol(strOutValue) * 100.0 );
		if (strTemp == "0.00") strTemp = "0";
		strTemp = strTemp + "%";
		m_ListNow.SetItemText(0, 3, strTemp);	//

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_PRICE, _T("OutRec1"), _T("LOPRICE"), 0);		//ð(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_PRICE, _T("OutRec1"), _T("LHPRICE"), 0);		//(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_PRICE, _T("OutRec1"), _T("LLPRICE"), 0);		//(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_PRICE, _T("OutRec1"), _T("LULIMITPRICE"), 0);	//Ѱ(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_PRICE, _T("OutRec1"), _T("LLLIMITPRICE"), 0);	//Ѱ(4)
		strVolume	= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_PRICE, _T("OutRec1"), _T("LVOLUME"), 0);		//ŷ(4)
		m_ListNow.SetItemText(0, 4, theApp.SetComma(strVolume));	//ŷ

		strPrevVolume = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_PRICE, _T("OutRec1"), _T("LLSTVOLUME"), 0);		//ϰŷ(4)

		//ŷ
		// =IF(OR(ŷ==0,ϰŷ==0),"0",IF(ŷ>ϰŷ,(ŷ/ϰŷ)*100,IF((ŷ/ϰŷ)<0.0001,"0",(ŷ/ϰŷ)*100*-1)))
		long nVolume = _ttol(strVolume), nPrevVolume = _ttol(strPrevVolume);
		if ( nVolume == 0 || nPrevVolume == 0)
			strTemp = _T("0");
		else
		{
			if (nVolume > nPrevVolume)
				strTemp.Format(_T("%0.2f"), (double)(nVolume / nPrevVolume) * 100.0 );
			else 
			{
				if ( (nVolume / nPrevVolume) < 0.0001 )
					strTemp = _T("0");
				else
					strTemp.Format(_T("%0.2f"), (double)(nVolume / nPrevVolume) * 100.0 * -1 );
			}
		}
		strTemp = strTemp + "%";
		m_ListNow.SetItemText(0, 5, _T("0"));	//ŷ

		//	ȣ  ó
		CString strOfferName = _T("LOFFER"), strBidName = _T("LBID"), strOfferrest = _T("LOFFERREST"), strBidrest = _T("LBIDREST");
		for (int i = 0; i < 5; i++)
		{
			// ŵȣ
			strTemp.Format(_T("%s%d"), strOfferName, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_PRICE, _T("OutRec1"), strTemp, 0);
			strTemp.Format(_T("%0.2f"), _ttol(strOutValue) / 100.0);
			if(strTemp == "0.00")		strTemp = _T("");
			strOutValue = theApp.SetComma(strTemp);
			memset(m_Quote.szMaedoHoga[i], 0x00, _countof(m_Quote.szMaedoHoga[i]));
			memcpy(m_Quote.szMaedoHoga[i], strOutValue, strOutValue.GetLength());

			// żȣ
			strTemp.Format(_T("%s%d"), strBidName, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_PRICE, _T("OutRec1"), strTemp, 0);
			strTemp.Format(_T("%0.2f"), _ttol(strOutValue) / 100.0);
			if(strTemp == "0.00")		strTemp = _T("");
			strOutValue = theApp.SetComma(strTemp);
			memset(m_Quote.szMaesuHoga[i], 0x00, _countof(m_Quote.szMaesuHoga[i]));
			memcpy(m_Quote.szMaesuHoga[i], strOutValue, strOutValue.GetLength());

			// ŵȣ ܷ
			strTemp.Format(_T("%s%d"), strOfferrest, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_PRICE, _T("OutRec1"), strTemp, 0);
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strOutValue = theApp.SetComma(strOutValue);
			memset(m_Quote.szMaedoHoga_cnt[i], 0x00, _countof(m_Quote.szMaedoHoga_cnt[i]));
			memcpy(m_Quote.szMaedoHoga_cnt[i], strOutValue, strOutValue.GetLength());

			// żȣ ܷ
			strTemp.Format(_T("%s%d"), strBidrest, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_PRICE, _T("OutRec1"), strTemp, 0);
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strOutValue = theApp.SetComma(strOutValue);
			memset(m_Quote.szMaesuHoga_cnt[i], 0x00, _countof(m_Quote.szMaesuHoga_cnt[i]));
			memcpy(m_Quote.szMaesuHoga_cnt[i], strOutValue, strOutValue.GetLength());
		}

		m_ListHoga.SetItemText(1, 1, m_Quote.szMaedoHoga[4]);
		m_ListHoga.SetItemText(2, 1, m_Quote.szMaedoHoga[3]);
		m_ListHoga.SetItemText(3, 1, m_Quote.szMaedoHoga[2]);
		m_ListHoga.SetItemText(4, 1, m_Quote.szMaedoHoga[1]);
		m_ListHoga.SetItemText(5, 1, m_Quote.szMaedoHoga[0]);
		m_ListHoga.SetItemText(6, 1, m_Quote.szMaesuHoga[0]);
		m_ListHoga.SetItemText(7, 1, m_Quote.szMaesuHoga[1]);
		m_ListHoga.SetItemText(8, 1, m_Quote.szMaesuHoga[2]);
		m_ListHoga.SetItemText(9, 1, m_Quote.szMaesuHoga[3]);
		m_ListHoga.SetItemText(10, 1, m_Quote.szMaesuHoga[4]);

		m_ListHoga.SetItemText(1, 0, m_Quote.szMaedoHoga_cnt[4]);
		m_ListHoga.SetItemText(2, 0, m_Quote.szMaedoHoga_cnt[3]);
		m_ListHoga.SetItemText(3, 0, m_Quote.szMaedoHoga_cnt[2]);
		m_ListHoga.SetItemText(4, 0, m_Quote.szMaedoHoga_cnt[1]);
		m_ListHoga.SetItemText(5, 0, m_Quote.szMaedoHoga_cnt[0]);
		m_ListHoga.SetItemText(6, 2, m_Quote.szMaesuHoga_cnt[0]);
		m_ListHoga.SetItemText(7, 2, m_Quote.szMaesuHoga_cnt[1]);
		m_ListHoga.SetItemText(8, 2, m_Quote.szMaesuHoga_cnt[2]);
		m_ListHoga.SetItemText(9, 2, m_Quote.szMaesuHoga_cnt[3]);
		m_ListHoga.SetItemText(10, 2, m_Quote.szMaesuHoga_cnt[4]);

	}
}

void CStCurrentDlg::ReceiveTrFutureChe(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strCode, strTime, strPrice, strVolume, strPrevVolume, strTemp;
	int		nDataCnt = 0, nDataOffset = 0;

	if ( nDataLength > 0 )
	{
		long nRowCount = theApp.m_pCommAgent->GetTranOutputRowCnt(RQ_TRNAME_FUTURE_CHE, _T("OutRec2"));						//  Ǽ

		CString strOutValue = _T("");
		for (int i = 0; i < nRowCount; i++)
		{ 	
			//	 ߰
			m_ListTick.InsertItem(i, _T(""));

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_CHE, _T("OutRec2"), _T("LTIME"), i);		//ð
			strOutValue.Trim();
			if ( strOutValue.GetLength() == 5 )
				strOutValue.Insert(0, _T('0'));
			strTemp.Format(_T("%s:%s:%s"), strOutValue.Left(2), strOutValue.Mid(2,2), strOutValue.Right(2));
			m_ListTick.SetItemText(i, 0, strTemp);	//ð

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_CHE, _T("OutRec2"), _T("LCPRICE"), i);	//簡
			strTemp.Format(_T("%0.2f"), _ttol(strOutValue) / 100.0);
			if(strTemp == "0.00")		strTemp = _T("");
			strOutValue = theApp.SetComma(strTemp);
			m_ListTick.SetItemText(i, 1, strOutValue);	//簡

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_CHE, _T("OutRec2"), _T("LCURVOLUME"), i);	//üᷮ
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strTemp = theApp.SetComma(strOutValue);
			m_ListTick.SetItemText(i, 2, strTemp);	//üᷮ

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUTURE_CHE, _T("OutRec2"), _T("LVOLUME"), i);	//ŷ
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strTemp = theApp.SetComma(strOutValue);
			m_ListTick.SetItemText(i, 3, strTemp);	//ŷ

		}
	}
}

void CStCurrentDlg::ReceiveTrOptionSiseHoga(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strCode, strTime, strPrice, strVolume, strPrevVolume, strTemp;
	int		nDataCnt = 0, nDataOffset = 0;

	if ( nDataLength > 0 )
	{
		CString strOutValue = _T("");
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_PRICE, _T("OutRec1"), _T("SHNAME"), 0);		//Ī(20)
		strTemp		= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_PRICE, _T("OutRec1"), _T("LTIME"), 0);			//ð(4)
		strTemp.Trim();
		if ( strTemp.GetLength() == 5 )
			strTemp.Insert(0, _T('0'));
		strTime = strTemp.Left(2) + ":" + strTemp.Mid(2,2) + ":" + strTemp.Right(2);
		m_ListHoga.SetItemText(0, 1, strTime);

		strPrice	= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_PRICE, _T("OutRec1"), _T("LCPRICE"), 0);			//簡(4)
		strTemp.Format(_T("%0.2f"), _ttol(strPrice) / 100.0);
		strOutValue = theApp.SetComma(strTemp);
		m_ListNow.SetItemText(0, 0, strOutValue);	//簡

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_PRICE, _T("OutRec1"), _T("LFACEPRICE"), 0);	//׸鰡(4)
		strTemp.Format(_T("%0.2f"), _ttol(strOutValue) / 100.0);
		strOutValue = theApp.SetComma(strTemp);

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_PRICE, _T("OutRec1"), _T("LDIFF"), 0);			//ϴ(4)
		strTemp.Format(_T("%0.2f"), _ttol(strOutValue) / 100.0);
		strOutValue = theApp.SetComma(strTemp);
		m_ListNow.SetItemText(0, 2, strOutValue);	//

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_PRICE, _T("OutRec1"), _T("CPCHECK"), 0);		//ȣ(1)
		if(strOutValue == _T("2"))
			strOutValue = _T("");
		else if(strOutValue == _T("5"))
			strOutValue = _T("");
		else if (strOutValue == _T("1"))
			strOutValue = _T("");
		else if (strOutValue == _T("4"))
			strOutValue = _T("");
		else
			strOutValue = _T("");
		m_ListNow.SetItemText(0, 1, strOutValue);	//ȣ

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_PRICE, _T("OutRec1"), _T("LLSTCPRICE"), 0);		//(4)
		//	  = ((簡-ذ)/ذ)*100
		strTemp.Format(_T("%0.2f"), (double)(_ttol(strPrice) - _ttol(strOutValue)) / _ttol(strOutValue) * 100.0 );
		if (strTemp == "0.00") strTemp = "0";
		strTemp = strTemp + "%";
		m_ListNow.SetItemText(0, 3, strTemp);	//

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_PRICE, _T("OutRec1"), _T("LOPRICE"), 0);		//ð(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_PRICE, _T("OutRec1"), _T("LHPRICE"), 0);		//(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_PRICE, _T("OutRec1"), _T("LLPRICE"), 0);		//(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_PRICE, _T("OutRec1"), _T("LULIMITPRICE"), 0);	//Ѱ(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_PRICE, _T("OutRec1"), _T("LLLIMITPRICE"), 0);	//Ѱ(4)
		strVolume	= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_PRICE, _T("OutRec1"), _T("LVOLUME"), 0);		//ŷ(4)
		m_ListNow.SetItemText(0, 4, theApp.SetComma(strVolume));	//ŷ

		strPrevVolume = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_PRICE, _T("OutRec1"), _T("LLSTVOLUME"), 0);		//ϰŷ(4)

		//ŷ
		// =IF(OR(ŷ==0,ϰŷ==0),"0",IF(ŷ>ϰŷ,(ŷ/ϰŷ)*100,IF((ŷ/ϰŷ)<0.0001,"0",(ŷ/ϰŷ)*100*-1)))
		long nVolume = _ttol(strVolume), nPrevVolume = _ttol(strPrevVolume);
		if ( nVolume == 0 || nPrevVolume == 0)
			strTemp = _T("0");
		else
		{
			if (nVolume > nPrevVolume)
				strTemp.Format(_T("%0.2f"), (double)(nVolume / nPrevVolume) * 100.0 );
			else 
			{
				if ( (nVolume / nPrevVolume) < 0.0001 )
					strTemp = _T("0");
				else
					strTemp.Format(_T("%0.2f"), (double)(nVolume / nPrevVolume) * 100.0 * -1 );
			}
		}
		strTemp = strTemp + "%";
		m_ListNow.SetItemText(0, 5, _T("0"));	//ŷ

		//	ȣ  ó
		CString strOfferName = _T("LOFFER"), strBidName = _T("LBID"), strOfferrest = _T("LOFFERREST"), strBidrest = _T("LBIDREST");
		for (int i = 0; i < 5; i++)
		{
			// ŵȣ
			strTemp.Format(_T("%s%d"), strOfferName, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_PRICE, _T("OutRec1"), strTemp, 0);
			strTemp.Format(_T("%0.2f"), _ttol(strOutValue) / 100.0);
			if(strTemp == "0.00")		strTemp = _T("");
			strOutValue = theApp.SetComma(strTemp);
			memset(m_Quote.szMaedoHoga[i], 0x00, _countof(m_Quote.szMaedoHoga[i]));
			memcpy(m_Quote.szMaedoHoga[i], strOutValue, strOutValue.GetLength());

			// żȣ
			strTemp.Format(_T("%s%d"), strBidName, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_PRICE, _T("OutRec1"), strTemp, 0);
			strTemp.Format(_T("%0.2f"), _ttol(strOutValue) / 100.0);
			if(strTemp == "0.00")		strTemp = _T("");
			strOutValue = theApp.SetComma(strTemp);
			memset(m_Quote.szMaesuHoga[i], 0x00, _countof(m_Quote.szMaesuHoga[i]));
			memcpy(m_Quote.szMaesuHoga[i], strOutValue, strOutValue.GetLength());

			// ŵȣ ܷ
			strTemp.Format(_T("%s%d"), strOfferrest, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_PRICE, _T("OutRec1"), strTemp, 0);
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strOutValue = theApp.SetComma(strOutValue);
			memset(m_Quote.szMaedoHoga_cnt[i], 0x00, _countof(m_Quote.szMaedoHoga_cnt[i]));
			memcpy(m_Quote.szMaedoHoga_cnt[i], strOutValue, strOutValue.GetLength());

			// żȣ ܷ
			strTemp.Format(_T("%s%d"), strBidrest, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_PRICE, _T("OutRec1"), strTemp, 0);
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strOutValue = theApp.SetComma(strOutValue);
			memset(m_Quote.szMaesuHoga_cnt[i], 0x00, _countof(m_Quote.szMaesuHoga_cnt[i]));
			memcpy(m_Quote.szMaesuHoga_cnt[i], strOutValue, strOutValue.GetLength());
		}

		m_ListHoga.SetItemText(1, 1, m_Quote.szMaedoHoga[4]);
		m_ListHoga.SetItemText(2, 1, m_Quote.szMaedoHoga[3]);
		m_ListHoga.SetItemText(3, 1, m_Quote.szMaedoHoga[2]);
		m_ListHoga.SetItemText(4, 1, m_Quote.szMaedoHoga[1]);
		m_ListHoga.SetItemText(5, 1, m_Quote.szMaedoHoga[0]);
		m_ListHoga.SetItemText(6, 1, m_Quote.szMaesuHoga[0]);
		m_ListHoga.SetItemText(7, 1, m_Quote.szMaesuHoga[1]);
		m_ListHoga.SetItemText(8, 1, m_Quote.szMaesuHoga[2]);
		m_ListHoga.SetItemText(9, 1, m_Quote.szMaesuHoga[3]);
		m_ListHoga.SetItemText(10, 1, m_Quote.szMaesuHoga[4]);

		m_ListHoga.SetItemText(1, 0, m_Quote.szMaedoHoga_cnt[4]);
		m_ListHoga.SetItemText(2, 0, m_Quote.szMaedoHoga_cnt[3]);
		m_ListHoga.SetItemText(3, 0, m_Quote.szMaedoHoga_cnt[2]);
		m_ListHoga.SetItemText(4, 0, m_Quote.szMaedoHoga_cnt[1]);
		m_ListHoga.SetItemText(5, 0, m_Quote.szMaedoHoga_cnt[0]);
		m_ListHoga.SetItemText(6, 2, m_Quote.szMaesuHoga_cnt[0]);
		m_ListHoga.SetItemText(7, 2, m_Quote.szMaesuHoga_cnt[1]);
		m_ListHoga.SetItemText(8, 2, m_Quote.szMaesuHoga_cnt[2]);
		m_ListHoga.SetItemText(9, 2, m_Quote.szMaesuHoga_cnt[3]);
		m_ListHoga.SetItemText(10, 2, m_Quote.szMaesuHoga_cnt[4]);

	}
}

void CStCurrentDlg::ReceiveTrOptionChe(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strCode, strTime, strPrice, strVolume, strPrevVolume, strTemp;
	int		nDataCnt = 0, nDataOffset = 0;

	if ( nDataLength > 0 )
	{
		long nRowCount = theApp.m_pCommAgent->GetTranOutputRowCnt(RQ_TRNAME_OPTION_CHE, _T("OutRec2"));						//  Ǽ

		CString strOutValue = _T("");
		for (int i = 0; i < nRowCount; i++)
		{ 	
			//	 ߰
			m_ListTick.InsertItem(i, _T(""));

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_CHE, _T("OutRec2"), _T("LTIME"), i);		//ð
			strOutValue.Trim();
			if ( strOutValue.GetLength() == 5 )
				strOutValue.Insert(0, _T('0'));
			strTemp.Format(_T("%s:%s:%s"), strOutValue.Left(2), strOutValue.Mid(2,2), strOutValue.Right(2));
			m_ListTick.SetItemText(i, 0, strTemp);	//ð

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_CHE, _T("OutRec2"), _T("LCPRICE"), i);	//簡
			strTemp.Format(_T("%0.2f"), _ttol(strOutValue) / 100.0);
			if(strTemp == "0.00")		strTemp = _T("");
			strOutValue = theApp.SetComma(strTemp);
			m_ListTick.SetItemText(i, 1, strOutValue);	//簡

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_CHE, _T("OutRec2"), _T("LCURVOLUME"), i);	//üᷮ
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strTemp = theApp.SetComma(strOutValue);
			m_ListTick.SetItemText(i, 2, strTemp);	//üᷮ

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_OPTION_CHE, _T("OutRec2"), _T("LVOLUME"), i);	//ŷ
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strTemp = theApp.SetComma(strOutValue);
			m_ListTick.SetItemText(i, 3, strTemp);	//ŷ

		}
	}
}

void CStCurrentDlg::ReceiveTrStockFutureSiseHoga(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strCode, strTime, strPrice, strVolume, strPrevVolume, strTemp;
	int		nDataCnt = 0, nDataOffset = 0;

	if ( nDataLength > 0 )
	{
		CString strOutValue = _T("");
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_PRICE, _T("OutRec1"), _T("SHNAME"), 0);		//Ī(20)
		strTemp		= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_PRICE, _T("OutRec1"), _T("LTIME"), 0);			//ð(4)
		strTemp.Trim();
		if ( strTemp.GetLength() == 5 )
			strTemp.Insert(0, _T('0'));
		strTime = strTemp.Left(2) + ":" + strTemp.Mid(2,2) + ":" + strTemp.Right(2);
		m_ListHoga.SetItemText(0, 1, strTime);

		strPrice	= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_PRICE, _T("OutRec1"), _T("LCPRICE"), 0);			//簡(4)
		strTemp.Format(_T("%ld"), _ttol(strPrice));
		m_ListNow.SetItemText(0, 0, theApp.SetComma(strTemp));	//簡

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_PRICE, _T("OutRec1"), _T("LFACEPRICE"), 0);	//׸鰡(4)
		strTemp.Format(_T("%ld"), _ttol(strOutValue));
		strOutValue = theApp.SetComma(strTemp);

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_PRICE, _T("OutRec1"), _T("LDIFF"), 0);			//ϴ(4)
		strTemp.Format(_T("%ld"), _ttol(strOutValue));
		m_ListNow.SetItemText(0, 2, theApp.SetComma(strOutValue));	//

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_PRICE, _T("OutRec1"), _T("CPCHECK"), 0);		//ȣ(1)
		if(strOutValue == _T("2"))
			strOutValue = _T("");
		else if(strOutValue == _T("5"))
			strOutValue = _T("");
		else if (strOutValue == _T("1"))
			strOutValue = _T("");
		else if (strOutValue == _T("4"))
			strOutValue = _T("");
		else
			strOutValue = _T("");
		m_ListNow.SetItemText(0, 1, strOutValue);	//ȣ

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_PRICE, _T("OutRec1"), _T("LLSTCPRICE"), 0);		//(4)
		//	  = ((簡-ذ)/ذ)*100
		strTemp.Format(_T("%0.2f"), (double)(_ttol(strPrice) - _ttol(strOutValue)) / _ttol(strOutValue) * 100.0 );
		if (strTemp == "0.00") strTemp = "0";
		strTemp = strTemp + "%";
		m_ListNow.SetItemText(0, 3, strTemp);	//

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_PRICE, _T("OutRec1"), _T("LOPRICE"), 0);		//ð(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_PRICE, _T("OutRec1"), _T("LHPRICE"), 0);		//(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_PRICE, _T("OutRec1"), _T("LLPRICE"), 0);		//(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_PRICE, _T("OutRec1"), _T("LULIMITPRICE"), 0);	//Ѱ(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_PRICE, _T("OutRec1"), _T("LLLIMITPRICE"), 0);	//Ѱ(4)
		strVolume	= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_PRICE, _T("OutRec1"), _T("LVOLUME"), 0);		//ŷ(4)
		m_ListNow.SetItemText(0, 4, theApp.SetComma(strVolume));	//ŷ

		strPrevVolume = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_PRICE, _T("OutRec1"), _T("LLSTVOLUME"), 0);		//ϰŷ(4)

		//ŷ
		// =IF(OR(ŷ==0,ϰŷ==0),"0",IF(ŷ>ϰŷ,(ŷ/ϰŷ)*100,IF((ŷ/ϰŷ)<0.0001,"0",(ŷ/ϰŷ)*100*-1)))
		long nVolume = _ttol(strVolume), nPrevVolume = _ttol(strPrevVolume);
		if ( nVolume == 0 || nPrevVolume == 0)
			strTemp = _T("0");
		else
		{
			if (nVolume > nPrevVolume)
				strTemp.Format(_T("%0.2f"), (double)(nVolume / nPrevVolume) * 100.0 );
			else 
			{
				if ( (nVolume / nPrevVolume) < 0.0001 )
					strTemp = _T("0");
				else
					strTemp.Format(_T("%0.2f"), (double)(nVolume / nPrevVolume) * 100.0 * -1 );
			}
		}
		strTemp = strTemp + "%";
		m_ListNow.SetItemText(0, 5, _T("0"));	//ŷ

		//	ȣ  ó
		CString strOfferName = _T("LOFFER"), strBidName = _T("LBID"), strOfferrest = _T("LOFFERREST"), strBidrest = _T("LBIDREST");
		for (int i = 0; i < 5; i++)
		{
			// ŵȣ
			strTemp.Format(_T("%s%d"), strOfferName, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_PRICE, _T("OutRec1"), strTemp, 0);
			strTemp.Format(_T("%ld"), _ttol(strOutValue));
			strOutValue = theApp.SetComma(strTemp);
			if(strOutValue == "0")		strOutValue = _T("");
			memset(m_Quote.szMaedoHoga[i], 0x00, _countof(m_Quote.szMaedoHoga[i]));
			memcpy(m_Quote.szMaedoHoga[i], strOutValue, strOutValue.GetLength());

			// żȣ
			strTemp.Format(_T("%s%d"), strBidName, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_PRICE, _T("OutRec1"), strTemp, 0);
			strTemp.Format(_T("%ld"), _ttol(strOutValue));
			strOutValue = theApp.SetComma(strTemp);
			if(strOutValue == "0")		strOutValue = _T("");
			memset(m_Quote.szMaesuHoga[i], 0x00, _countof(m_Quote.szMaesuHoga[i]));
			memcpy(m_Quote.szMaesuHoga[i], strOutValue, strOutValue.GetLength());

			// ŵȣ ܷ
			strTemp.Format(_T("%s%d"), strOfferrest, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_PRICE, _T("OutRec1"), strTemp, 0);
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strOutValue = theApp.SetComma(strOutValue);
			memset(m_Quote.szMaedoHoga_cnt[i], 0x00, _countof(m_Quote.szMaedoHoga_cnt[i]));
			memcpy(m_Quote.szMaedoHoga_cnt[i], strOutValue, strOutValue.GetLength());

			// żȣ ܷ
			strTemp.Format(_T("%s%d"), strBidrest, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_PRICE, _T("OutRec1"), strTemp, 0);
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strOutValue = theApp.SetComma(strOutValue);
			memset(m_Quote.szMaesuHoga_cnt[i], 0x00, _countof(m_Quote.szMaesuHoga_cnt[i]));
			memcpy(m_Quote.szMaesuHoga_cnt[i], strOutValue, strOutValue.GetLength());
		}

		m_ListHoga.SetItemText(1, 1, m_Quote.szMaedoHoga[4]);
		m_ListHoga.SetItemText(2, 1, m_Quote.szMaedoHoga[3]);
		m_ListHoga.SetItemText(3, 1, m_Quote.szMaedoHoga[2]);
		m_ListHoga.SetItemText(4, 1, m_Quote.szMaedoHoga[1]);
		m_ListHoga.SetItemText(5, 1, m_Quote.szMaedoHoga[0]);
		m_ListHoga.SetItemText(6, 1, m_Quote.szMaesuHoga[0]);
		m_ListHoga.SetItemText(7, 1, m_Quote.szMaesuHoga[1]);
		m_ListHoga.SetItemText(8, 1, m_Quote.szMaesuHoga[2]);
		m_ListHoga.SetItemText(9, 1, m_Quote.szMaesuHoga[3]);
		m_ListHoga.SetItemText(10, 1, m_Quote.szMaesuHoga[4]);

		m_ListHoga.SetItemText(1, 0, m_Quote.szMaedoHoga_cnt[4]);
		m_ListHoga.SetItemText(2, 0, m_Quote.szMaedoHoga_cnt[3]);
		m_ListHoga.SetItemText(3, 0, m_Quote.szMaedoHoga_cnt[2]);
		m_ListHoga.SetItemText(4, 0, m_Quote.szMaedoHoga_cnt[1]);
		m_ListHoga.SetItemText(5, 0, m_Quote.szMaedoHoga_cnt[0]);
		m_ListHoga.SetItemText(6, 2, m_Quote.szMaesuHoga_cnt[0]);
		m_ListHoga.SetItemText(7, 2, m_Quote.szMaesuHoga_cnt[1]);
		m_ListHoga.SetItemText(8, 2, m_Quote.szMaesuHoga_cnt[2]);
		m_ListHoga.SetItemText(9, 2, m_Quote.szMaesuHoga_cnt[3]);
		m_ListHoga.SetItemText(10, 2, m_Quote.szMaesuHoga_cnt[4]);

	}
}

void CStCurrentDlg::ReceiveTrStockFutureChe(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strCode, strTime, strPrice, strVolume, strPrevVolume, strTemp;
	int		nDataCnt = 0, nDataOffset = 0;

	if ( nDataLength > 0 )
	{
		long nRowCount = theApp.m_pCommAgent->GetTranOutputRowCnt(RQ_TRNAME_STOCK_FUTURE_CHE, _T("OutRec2"));						//  Ǽ

		CString strOutValue = _T("");
		for (int i = 0; i < nRowCount; i++)
		{ 	
			//	 ߰
			m_ListTick.InsertItem(i, _T(""));

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_CHE, _T("OutRec2"), _T("LTIME"), i);		//ð
			strOutValue.Trim();
			if ( strOutValue.GetLength() == 5 )
				strOutValue.Insert(0, _T('0'));
			strTemp.Format(_T("%s:%s:%s"), strOutValue.Left(2), strOutValue.Mid(2,2), strOutValue.Right(2));
			m_ListTick.SetItemText(i, 0, strTemp);	//ð

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_CHE, _T("OutRec2"), _T("LCPRICE"), i);	//簡
			strTemp.Format(_T("%ld"), _ttol(strOutValue));
			strOutValue = theApp.SetComma(strTemp);
			if(strOutValue == "0")		strOutValue = _T("");
			m_ListTick.SetItemText(i, 1, strOutValue);	//簡

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_CHE, _T("OutRec2"), _T("LCURVOLUME"), i);	//üᷮ
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strTemp = theApp.SetComma(strOutValue);
			m_ListTick.SetItemText(i, 2, strTemp);	//üᷮ

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_FUTURE_CHE, _T("OutRec2"), _T("LVOLUME"), i);	//ŷ
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strTemp = theApp.SetComma(strOutValue);
			m_ListTick.SetItemText(i, 3, strTemp);	//ŷ

		}
	}
}

void CStCurrentDlg::ReceiveTrStockOptionSiseHoga(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strCode, strTime, strPrice, strVolume, strPrevVolume, strTemp;
	int		nDataCnt = 0, nDataOffset = 0;

	if ( nDataLength > 0 )
	{
		CString strOutValue = _T("");
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_PRICE, _T("OutRec1"), _T("SHNAME"), 0);		//Ī(20)
		strTemp		= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_PRICE, _T("OutRec1"), _T("LTIME"), 0);			//ð(4)
		strTemp.Trim();
		if ( strTemp.GetLength() == 5 )
			strTemp.Insert(0, _T('0'));
		strTime = strTemp.Left(2) + ":" + strTemp.Mid(2,2) + ":" + strTemp.Right(2);
		m_ListHoga.SetItemText(0, 1, strTime);

		strPrice	= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_PRICE, _T("OutRec1"), _T("LCPRICE"), 0);			//簡(4)
		strTemp.Format(_T("%ld"), _ttol(strPrice));
		strOutValue = theApp.SetComma(strTemp);
		m_ListNow.SetItemText(0, 0, strOutValue);	//簡

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_PRICE, _T("OutRec1"), _T("LFACEPRICE"), 0);	//׸鰡(4)
		strTemp.Format(_T("%ld"), _ttol(strOutValue));
		strOutValue = theApp.SetComma(strTemp);

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_PRICE, _T("OutRec1"), _T("LDIFF"), 0);			//ϴ(4)
		strTemp.Format(_T("%ld"), _ttol(strOutValue));
		strOutValue = theApp.SetComma(strTemp);
		m_ListNow.SetItemText(0, 2, strOutValue);	//

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_PRICE, _T("OutRec1"), _T("CPCHECK"), 0);		//ȣ(1)
		if(strOutValue == _T("2"))
			strOutValue = _T("");
		else if(strOutValue == _T("5"))
			strOutValue = _T("");
		else if (strOutValue == _T("1"))
			strOutValue = _T("");
		else if (strOutValue == _T("4"))
			strOutValue = _T("");
		else
			strOutValue = _T("");
		m_ListNow.SetItemText(0, 1, strOutValue);	//ȣ

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_PRICE, _T("OutRec1"), _T("LLSTCPRICE"), 0);		//(4)
		//	  = ((簡-ذ)/ذ)*100
		strTemp.Format(_T("%0.2f"), (double)(_ttol(strPrice) - _ttol(strOutValue)) / _ttol(strOutValue) * 100.0 );
		if (strTemp == "0.00") strTemp = "0";
		strTemp = strTemp + "%";
		m_ListNow.SetItemText(0, 3, strTemp);	//

		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_PRICE, _T("OutRec1"), _T("LOPRICE"), 0);		//ð(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_PRICE, _T("OutRec1"), _T("LHPRICE"), 0);		//(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_PRICE, _T("OutRec1"), _T("LLPRICE"), 0);		//(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_PRICE, _T("OutRec1"), _T("LULIMITPRICE"), 0);	//Ѱ(4)
		strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_PRICE, _T("OutRec1"), _T("LLLIMITPRICE"), 0);	//Ѱ(4)
		strVolume	= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_PRICE, _T("OutRec1"), _T("LVOLUME"), 0);		//ŷ(4)
		m_ListNow.SetItemText(0, 4, theApp.SetComma(strVolume));	//ŷ

		strPrevVolume = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_PRICE, _T("OutRec1"), _T("LLSTVOLUME"), 0);		//ϰŷ(4)

		//ŷ
		// =IF(OR(ŷ==0,ϰŷ==0),"0",IF(ŷ>ϰŷ,(ŷ/ϰŷ)*100,IF((ŷ/ϰŷ)<0.0001,"0",(ŷ/ϰŷ)*100*-1)))
		long nVolume = _ttol(strVolume), nPrevVolume = _ttol(strPrevVolume);
		if ( nVolume == 0 || nPrevVolume == 0)
			strTemp = _T("0");
		else
		{
			if (nVolume > nPrevVolume)
				strTemp.Format(_T("%0.2f"), (double)(nVolume / nPrevVolume) * 100.0 );
			else 
			{
				if ( (nVolume / nPrevVolume) < 0.0001 )
					strTemp = _T("0");
				else
					strTemp.Format(_T("%0.2f"), (double)(nVolume / nPrevVolume) * 100.0 * -1 );
			}
		}
		strTemp = strTemp + "%";
		m_ListNow.SetItemText(0, 5, _T("0"));	//ŷ

		//	ȣ  ó
		CString strOfferName = _T("LOFFER"), strBidName = _T("LBID"), strOfferrest = _T("LOFFERREST"), strBidrest = _T("LBIDREST");
		for (int i = 0; i < 5; i++)
		{
			// ŵȣ
			strTemp.Format(_T("%s%d"), strOfferName, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_PRICE, _T("OutRec1"), strTemp, 0);
			strTemp.Format(_T("%ld"), _ttol(strOutValue));
			if(strOutValue == "0")		strOutValue = _T("");
			strOutValue = theApp.SetComma(strOutValue);
			memset(m_Quote.szMaedoHoga[i], 0x00, _countof(m_Quote.szMaedoHoga[i]));
			memcpy(m_Quote.szMaedoHoga[i], strOutValue, strOutValue.GetLength());

			// żȣ
			strTemp.Format(_T("%s%d"), strBidName, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_PRICE, _T("OutRec1"), strTemp, 0);
			strTemp.Format(_T("%ld"), _ttol(strOutValue));
			if(strOutValue == "0")		strOutValue = _T("");
			strOutValue = theApp.SetComma(strOutValue);
			memset(m_Quote.szMaesuHoga[i], 0x00, _countof(m_Quote.szMaesuHoga[i]));
			memcpy(m_Quote.szMaesuHoga[i], strOutValue, strOutValue.GetLength());

			// ŵȣ ܷ
			strTemp.Format(_T("%s%d"), strOfferrest, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_PRICE, _T("OutRec1"), strTemp, 0);
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strOutValue = theApp.SetComma(strOutValue);
			memset(m_Quote.szMaedoHoga_cnt[i], 0x00, _countof(m_Quote.szMaedoHoga_cnt[i]));
			memcpy(m_Quote.szMaedoHoga_cnt[i], strOutValue, strOutValue.GetLength());

			// żȣ ܷ
			strTemp.Format(_T("%s%d"), strBidrest, i+1);
			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_PRICE, _T("OutRec1"), strTemp, 0);
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strOutValue = theApp.SetComma(strOutValue);
			memset(m_Quote.szMaesuHoga_cnt[i], 0x00, _countof(m_Quote.szMaesuHoga_cnt[i]));
			memcpy(m_Quote.szMaesuHoga_cnt[i], strOutValue, strOutValue.GetLength());
		}

		m_ListHoga.SetItemText(1, 1, m_Quote.szMaedoHoga[4]);
		m_ListHoga.SetItemText(2, 1, m_Quote.szMaedoHoga[3]);
		m_ListHoga.SetItemText(3, 1, m_Quote.szMaedoHoga[2]);
		m_ListHoga.SetItemText(4, 1, m_Quote.szMaedoHoga[1]);
		m_ListHoga.SetItemText(5, 1, m_Quote.szMaedoHoga[0]);
		m_ListHoga.SetItemText(6, 1, m_Quote.szMaesuHoga[0]);
		m_ListHoga.SetItemText(7, 1, m_Quote.szMaesuHoga[1]);
		m_ListHoga.SetItemText(8, 1, m_Quote.szMaesuHoga[2]);
		m_ListHoga.SetItemText(9, 1, m_Quote.szMaesuHoga[3]);
		m_ListHoga.SetItemText(10, 1, m_Quote.szMaesuHoga[4]);

		m_ListHoga.SetItemText(1, 0, m_Quote.szMaedoHoga_cnt[4]);
		m_ListHoga.SetItemText(2, 0, m_Quote.szMaedoHoga_cnt[3]);
		m_ListHoga.SetItemText(3, 0, m_Quote.szMaedoHoga_cnt[2]);
		m_ListHoga.SetItemText(4, 0, m_Quote.szMaedoHoga_cnt[1]);
		m_ListHoga.SetItemText(5, 0, m_Quote.szMaedoHoga_cnt[0]);
		m_ListHoga.SetItemText(6, 2, m_Quote.szMaesuHoga_cnt[0]);
		m_ListHoga.SetItemText(7, 2, m_Quote.szMaesuHoga_cnt[1]);
		m_ListHoga.SetItemText(8, 2, m_Quote.szMaesuHoga_cnt[2]);
		m_ListHoga.SetItemText(9, 2, m_Quote.szMaesuHoga_cnt[3]);
		m_ListHoga.SetItemText(10, 2, m_Quote.szMaesuHoga_cnt[4]);

	}
}

void CStCurrentDlg::ReceiveTrStockOptionChe(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strCode, strTime, strPrice, strVolume, strPrevVolume, strTemp;
	int		nDataCnt = 0, nDataOffset = 0;

	if ( nDataLength > 0 )
	{
		long nRowCount = theApp.m_pCommAgent->GetTranOutputRowCnt(RQ_TRNAME_STOCK_OPTION_CHE, _T("OutRec2"));						//  Ǽ

		CString strOutValue = _T("");
		for (int i = 0; i < nRowCount; i++)
		{ 	
			//	 ߰
			m_ListTick.InsertItem(i, _T(""));

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_CHE, _T("OutRec2"), _T("LTIME"), i);		//ð
			strOutValue.Trim();
			if ( strOutValue.GetLength() == 5 )
				strOutValue.Insert(0, _T('0'));
			strTemp.Format(_T("%s:%s:%s"), strOutValue.Left(2), strOutValue.Mid(2,2), strOutValue.Right(2));
			m_ListTick.SetItemText(i, 0, strTemp);	//ð

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_CHE, _T("OutRec2"), _T("LCPRICE"), i);	//簡
			strTemp.Format(_T("%ld"), _ttol(strOutValue));
			if(strTemp == "0")		strTemp = _T("");
			strOutValue = theApp.SetComma(strTemp);
			m_ListTick.SetItemText(i, 1, strOutValue);	//簡

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_CHE, _T("OutRec2"), _T("LCURVOLUME"), i);	//üᷮ
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strTemp = theApp.SetComma(strOutValue);
			m_ListTick.SetItemText(i, 2, strTemp);	//üᷮ

			strOutValue = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_OPTION_CHE, _T("OutRec2"), _T("LVOLUME"), i);	//ŷ
			strOutValue.Trim();
			if(strOutValue == "0")		strOutValue = _T("");
			strTemp = theApp.SetComma(strOutValue);
			m_ListTick.SetItemText(i, 3, strTemp);	//ŷ

		}
	}
}

void CStCurrentDlg::ReceiveFIDPortfolio(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strCode, strTime, strPrice, strVolume, strPrevVolume, strTemp;
	int		nDataCnt = 0, nDataOffset = 0;

	if ( nDataLength > 0 )
	{
		long nRowCount = theApp.m_pCommAgent->GetFidOutputRowCnt(nRqId);						//  Ǽ

		CString strOutValue = _T("");
		long	nValue = 0;
		for (int i = 0; i < nRowCount; i++)
		{ 	
			//	 ߰
			m_ListRqData.InsertItem(i, _T(""));

			strOutValue = theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("153"), i);		strOutValue.Trim();
			m_ListRqData.SetItemText(i, 0, theApp.m_pCommAgent->GetShCode(strOutValue));	//ڵ(153)

			strOutValue = theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("154"), i);		strOutValue.Trim();
			m_ListRqData.SetItemText(i, 1, strOutValue);	//(154)

			nValue = _ttol(theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("000"), i));
			strOutValue.Format(_T("%ld"), nValue);
			m_ListRqData.SetItemText(i, 2, theApp.SetComma(strOutValue));	//簡(000)

			nValue = _ttol(theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("002"), i));
			strOutValue.Format(_T("%ld"), nValue);
			m_ListRqData.SetItemText(i, 3, theApp.SetComma(strOutValue));	//ϴ(002)

			strOutValue.Format(_T("%0.2f"), _ttof(theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("003"), i)) / 100.0);
			m_ListRqData.SetItemText(i, 4, strOutValue + _T("%"));	//(003)

			strOutValue.Format(_T("%ld"), _ttol(theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("004"), i)));
			m_ListRqData.SetItemText(i, 5, theApp.SetComma(strOutValue));	//ŷ(004)

			strOutValue.Format(_T("%ld"), _ttol(theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("011"), i)));
			m_ListRqData.SetItemText(i, 6, theApp.SetComma(strOutValue));	//Ѱ(011)

			strOutValue.Format(_T("%ld"), _ttol(theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("012"), i)));
			m_ListRqData.SetItemText(i, 7, theApp.SetComma(strOutValue));	//Ѱ(012)

			strOutValue.Format(_T("%ld"), _ttol(theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("013"), i)));
			m_ListRqData.SetItemText(i, 8, theApp.SetComma(strOutValue));	//ð(013)

			strOutValue.Format(_T("%ld"), _ttol(theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("014"), i)));
			m_ListRqData.SetItemText(i, 9, theApp.SetComma(strOutValue));	//(014)

			strOutValue.Format(_T("%ld"), _ttol(theApp.m_pCommAgent->GetFidOutputData(nRqId, _T("015"), i)));
			m_ListRqData.SetItemText(i, 10, theApp.SetComma(strOutValue));	//(015)
		}
	}
}