
// StockFuOpOrderDlg.cpp :  
//

#include "stdafx.h"
#include "ChampionAgentTest.h"
#include "ChampionAgentTestDlg.h"
#include "StockFuOpOrderDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

extern CChampionAgentTestApp theApp;

// CStockFuOpOrderDlg ȭ 

CStockFuOpOrderDlg::CStockFuOpOrderDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CStockFuOpOrderDlg::IDD, pParent)
	, m_bSiseOnly(FALSE)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);	
}

void CStockFuOpOrderDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_OUTPUT,			m_edOutput);
	DDX_Control(pDX, IDC_OUTMSG,			m_edOutMsg);
	DDX_Control(pDX, IDC_OUTMSG_Real,		m_edOutMsg_real);
	DDX_Control(pDX, IDC_ACCOUNT_ED,		m_CtrlEdAccNoCtl);
	DDX_Control(pDX, IDC_ACCNAME_ED,		m_CtrlEdAccName);
	DDX_Control(pDX, IDC_ACCPWD_ED,			m_CtrlEdAccPwd);
	DDX_Control(pDX, IDC_CODE_ED,			m_CtrlEdCode);
	DDX_Control(pDX, IDC_COND_CB,			m_CtrlCbOrdType);
	DDX_Control(pDX, IDC_QTY_ED,			m_CtrlEdQty);
	DDX_Control(pDX, IDC_PRICE_ED,			m_CtrlEdPrice);
	DDX_Control(pDX, IDC_ORDNO_ED,			m_CtrlEdOrdNo);
	DDX_Control(pDX, IDC_SRCORDNO_ED,		m_CtrlSrcOrdNo);
	DDX_Control(pDX, IDC_OUTSTDORD_LIST,	m_CtrlListOutStdOrd);
	DDX_Control(pDX, IDC_STOCK_LIST,		m_CtrlListStock);
	
}

BEGIN_MESSAGE_MAP(CStockFuOpOrderDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()

	ON_WM_DESTROY()
	ON_WM_CLOSE()

	ON_BN_CLICKED(IDC_OFFER_ORDER,				&CStockFuOpOrderDlg::OnBnClickedOfferOrder)
	ON_BN_CLICKED(IDC_BID_ORDER,				&CStockFuOpOrderDlg::OnBnClickedBidOrder)
	ON_BN_CLICKED(IDC_CORRECT_ORDER,			&CStockFuOpOrderDlg::OnBnClickedCorrectOrder)
	ON_BN_CLICKED(IDC_CANCEL_ORDER,				&CStockFuOpOrderDlg::OnBnClickedCancelOrder)
	ON_BN_CLICKED(IDC_OUTSTDORDER,				&CStockFuOpOrderDlg::OnBnClickedOutstdorder)
	ON_BN_CLICKED(IDC_STOCK_BTN,				&CStockFuOpOrderDlg::OnBnClickedStockBtn)
	ON_BN_CLICKED(IDC_STOCKACCINFO_BTN,			&CStockFuOpOrderDlg::OnBnClickedStockaccinfoBtn)
	ON_BN_CLICKED(IDC_OUTFODORDER,				&CStockFuOpOrderDlg::OnBnClickedOutfodorder)
	ON_BN_CLICKED(IDC_FUTOPT_BTN,				&CStockFuOpOrderDlg::OnBnClickedFutoptBtn)
	ON_BN_CLICKED(IDC_FOACCINFO_BTN,			&CStockFuOpOrderDlg::OnBnClickedFoaccinfoBtn)
END_MESSAGE_MAP()

// CStockFuOpOrderDlg ޽ ó
BOOL CStockFuOpOrderDlg::PreTranslateMessage(MSG* pMsg) 
{
	if (pMsg->message == WM_KEYUP)
	{
		if (pMsg->wParam == VK_RETURN)
		{
			return TRUE;
		}
	}
	else if (pMsg->message == WM_KEYDOWN)
	{
		if (pMsg->wParam == VK_ESCAPE)
			return TRUE;

		if (pMsg->wParam == VK_RETURN)
			return TRUE;
	}

	return CDialogEx::PreTranslateMessage(pMsg);
}

BOOL CStockFuOpOrderDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	//  ȭ   մϴ.  α׷  â ȭ ڰ ƴ 쿡
	//  ӿũ  ۾ ڵ մϴ.
	SetIcon(m_hIcon, TRUE);			// ū  մϴ.
	SetIcon(m_hIcon, FALSE);		//   մϴ.

	// ü Ʈ  ŸƲ
	m_CtrlListOutStdOrd.InsertColumn( 0, _T("ֹȣ"),			LVCFMT_CENTER, 80,  0);
	m_CtrlListOutStdOrd.InsertColumn( 1, _T("Ÿű"),			LVCFMT_CENTER, 70,  1);
	m_CtrlListOutStdOrd.InsertColumn( 2, _T("ֹ"),			LVCFMT_CENTER, 80,	2);
	m_CtrlListOutStdOrd.InsertColumn( 3, _T(""),			LVCFMT_CENTER, 80,	3);
	m_CtrlListOutStdOrd.InsertColumn( 4, _T("ֹ"),			LVCFMT_RIGHT, 80,  4);
	m_CtrlListOutStdOrd.InsertColumn( 5, _T("ֹ"),			LVCFMT_RIGHT, 80,  5);
	m_CtrlListOutStdOrd.InsertColumn( 6, _T("ü"),			LVCFMT_RIGHT, 80,	6);
	m_CtrlListOutStdOrd.InsertColumn( 8, _T("ֹȣ"),		LVCFMT_CENTER, 80,  8);
	m_CtrlListOutStdOrd.InsertColumn( 9, _T(""),				LVCFMT_CENTER, 80,  9);
	m_CtrlListOutStdOrd.InsertColumn(10, _T("ֹð"),			LVCFMT_CENTER, 80, 10);
	m_CtrlListOutStdOrd.InsertColumn(11, _T("ڵ"),			LVCFMT_CENTER, 80, 11);
	m_CtrlListOutStdOrd.ModifyStyle(LVS_TYPEMASK, LVS_REPORT);

	// ܰ Ʈ  ŸƲ
	m_CtrlListStock.InsertColumn( 0, _T("ڵ"),		LVCFMT_CENTER, 80,  0);
	m_CtrlListStock.InsertColumn( 1, _T(""),		LVCFMT_CENTER, 80,  1);
	m_CtrlListStock.InsertColumn( 2, _T(""),			LVCFMT_CENTER, 50,  2);
	m_CtrlListStock.InsertColumn( 3, _T(""),		LVCFMT_RIGHT, 80,	3);
	m_CtrlListStock.InsertColumn( 4, _T("ŵ"),		LVCFMT_RIGHT, 80,	4);
	m_CtrlListStock.InsertColumn( 5, _T("Դܰ"),		LVCFMT_RIGHT, 80,  5);
	m_CtrlListStock.InsertColumn( 6, _T("簡"),		LVCFMT_RIGHT, 80,  6);
	m_CtrlListStock.InsertColumn( 7, _T("򰡼"),		LVCFMT_RIGHT, 80,	7);
	m_CtrlListStock.InsertColumn( 8, _T(""),		LVCFMT_RIGHT, 80,	8);
	m_CtrlListStock.InsertColumn( 9, _T("򰡱ݾ"),		LVCFMT_RIGHT, 80,  9);
	m_CtrlListStock.InsertColumn(10, _T(""),		LVCFMT_RIGHT, 80, 11);
	m_CtrlListStock.ModifyStyle(LVS_TYPEMASK, LVS_REPORT);

	//m_CtrlEdCode.SetWindowTextA(_T("000660"));											//  : ̴н(000660)

	m_CtrlCbOrdType.AddString(_T(""));												// ֹ Setting
	m_CtrlCbOrdType.AddString(_T("尡"));
	m_CtrlCbOrdType.AddString(_T("Ǻ"));
	m_CtrlCbOrdType.AddString(_T(""));
	m_CtrlCbOrdType.AddString(_T("ֿ켱"));
	m_CtrlCbOrdType.AddString(_T("(IOC)"));
	m_CtrlCbOrdType.AddString(_T("尡(IOC)"));
	m_CtrlCbOrdType.AddString(_T("(IOC)"));
	m_CtrlCbOrdType.AddString(_T("(FOK)"));
	m_CtrlCbOrdType.AddString(_T("尡(FOK)"));
	m_CtrlCbOrdType.AddString(_T("(FOK)"));
	m_CtrlCbOrdType.AddString(_T("ð"));
	m_CtrlCbOrdType.AddString(_T("Ľð"));
	m_CtrlCbOrdType.AddString(_T("ðܴϰ"));
	m_CtrlCbOrdType.SetCurSel(0);

 	CString strId;
 	strId = theApp.m_strUserID;	//theApp.m_CommAgent.GetLoginInfo(_T("USER_ID"));
 
 	SetRealCode(1, strId);		// ֽ ֹ  ü  
 	SetRealCode(2, strId);		// / ֹ  ü  

	return TRUE;  // Ŀ Ʈѿ   TRUE ȯմϴ.
}

// ȭ ڿ ּȭ ߸ ߰   ׸
//  Ʒ ڵ尡 ʿմϴ. /  ϴ MFC  α׷ 쿡
//  ӿũ  ۾ ڵ մϴ.

void CStockFuOpOrderDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // ׸⸦  ̽ ؽƮԴϴ.

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Ŭ̾Ʈ 簢   ϴ.
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		//  ׸ϴ.
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// ڰ ּȭ â  ȿ Ŀ ǥõǵ ýۿ
//   Լ ȣմϴ.
HCURSOR CStockFuOpOrderDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CStockFuOpOrderDlg::OnDestroy()
{
	CString strId;
	strId = theApp.m_strUserID;	//theApp.m_CommAgent.GetLoginInfo(_T("USER_ID"));

	if (!strId.IsEmpty())
	{
		UnSetRealCode(1, strId);		// JSR ADD - ֽ ֹ  ü  
		UnSetRealCode(2, strId);		// JSR ADD - / ֹ  ü  
	}

	CDialog::OnDestroy();
}

void CStockFuOpOrderDlg::OnClose()
{
	CString strId;
	strId = theApp.m_strUserID;	//theApp.m_CommAgent.GetLoginInfo(_T("USER_ID"));

	if (!strId.IsEmpty())
	{
		UnSetRealCode(1, strId);		// JSR ADD - ֽ ֹ  ü  
		UnSetRealCode(2, strId);		// JSR ADD - / ֹ  ü  
	}
	
	CDialog::OnClose();
}

/////////////////////    (TR, FID  ) //////////////////////
// sPreNext ('0':Ѵ , '1': , '2': , '3':Ѵ )

// TR Ÿ  ̺Ʈ
void CStockFuOpOrderDlg::OnReceiveTrDataChampioncommagentctrl(long nRqId, LPCTSTR sTrCode, LPCTSTR sData, long nDataLength,
														LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage, LPCTSTR sSplmMsg)
{
	CString strTemp;
	CString strData;
	m_edOutMsg.SetWindowText(_T(""));
	m_edOutput.SetWindowText(_T(""));
	m_CtrlEdOrdNo.SetWindowText(_T(""));

	m_CtrlSrcOrdNo.SetWindowText( _T("") );	// ֹȣ
	m_CtrlEdOrdNo.SetWindowText( _T("") );	// ֹȣ


	strData.Format("RQID		: %d\r\n", nRqId);
	strTemp.Format("TR CODE		: %s\r\n", sTrCode);
	strData += strTemp;

	if ( strcmp(RQ_TRNAME_STOCK_BS_ORDER, sTrCode) == 0)				//	ֽ ŵ, ż ֹ 
	{
		ReceiveTrSendOrder(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage, 1);
	}
	else if ( strcmp(RQ_TRNAME_STOCK_MC_ORDER, sTrCode) == 0)			//	ֽ ,  ֹ 
	{
		ReceiveTrSendOrder(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage, 2);
	}
	else if ( strcmp(RQ_TRNAME_FUOP_BS_ORDER, sTrCode) == 0)			//	ɼ ŵ, ż ֹ 
	{
		ReceiveTrSendOrder(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage, 3);
	}
	else if ( strcmp(RQ_TRNAME_FUOP_MC_ORDER, sTrCode) == 0)			//	ɼ ,  ֹ 
	{
		ReceiveTrSendOrder(nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage, 4);
	}
	else if ( strcmp(RQ_TRNAME_STOCK_ORDER_CHE, sTrCode) == 0)			//	ֽ ºֹü/ü᳻
	{
		ReceiveTrStockChekeyol( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
	else if ( strcmp(RQ_TRNAME_FUOP_ORDER_CHE, sTrCode) == 0)			//	/ɼ ֹü᳻ȸ
	{
		ReceiveTrFOCheKyeol( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
	else if ( strcmp(RQ_TRNAME_STOCK_ORDER_JANGO, sTrCode) == 0)		//	ֽ ºܰȸ
	{
		ReceiveTrStockJango( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
	else if ( strcmp(RQ_TRNAME_FUOP_ORDER_JANGO, sTrCode) == 0)			//	/ɼ 곻ȸ
	{
		ReceiveTrFOJango( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
	else if ( strcmp(RQ_TRNAME_STOCK_ORDER_DEPOSIT, sTrCode) == 0)		//	ֽ Źȸ
	{
		ReceiveTrStockAccInfo( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}
	else if ( strcmp(RQ_TRNAME_FUOP_ORDER_DEPOSIT, sTrCode) == 0)		//	/ɼ Ź
	{
		ReceiveTrFOAccInfo( nRqId, sData, nDataLength, sPreNext, sErrorCode, sMessage );
	}

	m_strTrPreNext = sPreNext;

	strTemp.Format("	: %s\r\n", sPreNext);
	strData += strTemp;
	strTemp.Format("ڵ		: %s\r\n", sErrorCode);
	strData += strTemp;
	strTemp.Format("޼		: %s\r\n", sMessage);
	strData += strTemp;
	strTemp.Format("޼		: %s\r\n", sSplmMsg);
	strData += strTemp;
	strTemp.Format(" Ÿ		: %s\r\n", sData);
	strData += strTemp;

	m_edOutMsg.SetWindowText(strData);
}

// ǽð 
void CStockFuOpOrderDlg::OnReceiveRealDataChampioncommagentctrl(LPCTSTR sJongmokCode, short nPBID, LPCTSTR sRealData)
{
	CString strTemp , strData, strITMSCode;
	switch(nPBID)
	{
		case 191:	// ֽ ü
		case 193:	// /ɼ ü
		{
			CString strOderID, strOrorID, strQty, strPrice, strMEDOSU, strORDST, strJUGB;

			strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("EXPCODE"));
			strTemp.Trim();
			strITMSCode = theApp.m_pCommAgent->GetShCode(strTemp);							//	ڵ

			strOderID = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("ORDERNO"));		//	ֹȣ
			strOderID.Trim();

			strMEDOSU = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("MEDOSU"));		//	ŵż
			if ( strMEDOSU == _T("1") )
				strMEDOSU	= _T("ŵ");
			else
				strMEDOSU	= _T("ż");

			strORDST = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("ORDST"));			//	ֹ
			if (strORDST != _T("21"))
			{
				// ֹ
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("JQTY"));
				strTemp.Trim();
				strQty.Format		("%ld", _tstol(strTemp));
				strQty = theApp.SetComma(strQty);

				// ֹ
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("JPRC"));
				strTemp.Trim();
				if (nPBID == 191)
					strPrice.Format		("%ld", _tstol(strTemp));
				else
					strPrice.Format		("%0.2f", _tstof(strTemp) / 100.0 );

				strPrice = theApp.SetComma(strPrice);
			}
			else
			{
				// ü
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("CHEQTY"));
				strTemp.Trim();
				strQty.Format		("%ld", _tstol(strTemp));
				strQty = theApp.SetComma(strQty);

				// üᰡ
				strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("CHEPRICE"));
				strTemp.Trim();
				if (nPBID == 191)
					strPrice.Format		("%ld", _tstol(strTemp));
				else
					strPrice.Format		("%0.2f", _tstof(strTemp) / 100.0 );

				strPrice = theApp.SetComma(strPrice);
			}

			if		(strORDST == _T("21"))
				strORDST = (strMEDOSU + _T("ü"));
			else if (strORDST == _T("22"))
				strORDST = (strMEDOSU + _T(""));	//strOrdst = _T("Ȯ");
			else if (strORDST == _T("23"))
				strORDST = (strMEDOSU + _T(""));	//strOrdst = _T("Ȯ");
			else if (strORDST == _T("25"))
				strORDST = (strMEDOSU + _T(""));	//	strOrdst = _T("");
			else if (strORDST == _T("24"))
				strORDST = (strMEDOSU + _T("ź"));
			else
				strORDST = (strMEDOSU + _T(""));

			strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("JUGB"));		//	ֹ
			if		((strTemp == _T("03")) || (strTemp == _T("04")))
				strJUGB = _T("");
			else if ((strTemp == _T("53")) || (strTemp == _T("54")))
				strJUGB = _T("");
			else if ((strTemp == _T("11")) || (strTemp == _T("12")))
				strJUGB = _T("");
			else
				strJUGB = _T("");


			strData.Format("[ǽð Ȯâ] --> ");
			strTemp.Format("%s %s\r\n", strJUGB, strORDST);
			strData += strTemp;
			strTemp.Format("    ڵ : [%s]   ֹȣ : [%s]\r\n", strITMSCode, strOderID);
			strData += strTemp;
			strTemp.Format("     : [%s]    : [%s]", strQty,strPrice);
			strData += strTemp;
			m_edOutMsg_real.SetWindowText(strData);
		}
		break;
	
		case 192:	// ֽ ܰ
		{
			CString strACNO, strLasttrSonik, strORD_ABLE_CSH_A, strORD_ABLE_SBST_A, strCSH_RBUY_ABLE_A, strSBST_RBUY_ABLE_A, strAD_MGE_CSH;
			INT64	nTemp64;

			strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("ITEM_COD"));
			strTemp.Trim();
			strITMSCode = theApp.m_pCommAgent->GetShCode(strTemp);										//	ڵ

			strACNO = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("ACNO"));						//	¹ȣ
			strACNO.Trim();

			nTemp64 = _atoi64(theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("LASTTRSONIK")));		//	Ͻ()
			strTemp.Format("%I64d", nTemp64);
			strLasttrSonik = theApp.SetComma(strTemp);

			//	ֹ
			nTemp64 = _atoi64(theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("ORD_ABLE_CSH_A")));		//	ֹݱݾ
			strTemp.Format("%I64d", nTemp64);
			strORD_ABLE_CSH_A = theApp.SetComma(strTemp);
			//	ֹɴ
			nTemp64 = _atoi64(theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("ORD_ABLE_SBST_A")));	//	ֹɴݾ
			strTemp.Format("%I64d", nTemp64);
			strORD_ABLE_SBST_A = theApp.SetComma(strTemp);
			//	żɱݾ
			nTemp64 = _atoi64(theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("CSH_RBUY_ABLE_A")));	//	żɱݾ
			strTemp.Format("%I64d", nTemp64);
			strCSH_RBUY_ABLE_A = theApp.SetComma(strTemp);
			//	żɱݾ
			nTemp64 = _atoi64(theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("SBST_RBUY_ABLE_A")));	//	żɱݾ
			strTemp.Format("%I64d", nTemp64);
			strSBST_RBUY_ABLE_A = theApp.SetComma(strTemp);
			//	߰㺸
			nTemp64 = _atoi64(theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("AD_MGE_CSH")));			//	߰㺸ݱݾ
			strTemp.Format("%I64d", nTemp64);
			strAD_MGE_CSH = theApp.SetComma(strTemp);
			
			strData.Format("[ǽð ֽ ܰ ] --> ");
			strTemp.Format("    ڵ : [%s]   ¹ȣ : [%s]\r\n", strITMSCode, strACNO);
			strData += strTemp;
			strTemp.Format("    Ͻ : [%s]\r\n", strLasttrSonik);
			strData += strTemp;
			strTemp.Format("    ֹݱݾ : [%s]\r\n", strORD_ABLE_CSH_A);
			strData += strTemp;
			strTemp.Format("    ֹɴݾ : [%s]\r\n", strORD_ABLE_SBST_A);
			strData += strTemp;
			strTemp.Format("    żɱݾ : [%s]\r\n", strCSH_RBUY_ABLE_A);
			strData += strTemp;
			strTemp.Format("    żɱݾ : [%s]\r\n", strSBST_RBUY_ABLE_A);
			strData += strTemp;
			strTemp.Format("    ߰㺸 : [%s]\r\n", strAD_MGE_CSH);
			strData += strTemp;
			m_edOutMsg_real.SetWindowText(strData);
		}
		break;
		case 194:	// /ɼ ܰ
		{
			CString strACNO, strORD_ABLE_TOT_A, strORD_ABLE_CSH, strCSH_RBUY_ABLE_A, strSBST_RBUY_ABLE_A;
			INT64 nTemp64;

			strTemp = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("EXPCODE"));
			strTemp.Trim();
			strITMSCode = theApp.m_pCommAgent->GetShCode(strTemp);											//	ڵ

			strACNO = theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("ACCNO"));							//	¹ȣ
			strACNO.Trim();

			//	ֹѾ
			nTemp64 = _atoi64(theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("ORD_ABLE_TOT_A")));			//	ֹѾ
			strTemp.Format("%I64d", nTemp64);
			strORD_ABLE_TOT_A = theApp.SetComma(strTemp);
			//	ֹ
			nTemp64 = _atoi64(theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("ORD_ABLE_CSH")));			//	ֹ
			strTemp.Format("%I64d", nTemp64);
			strORD_ABLE_CSH = theApp.SetComma(strTemp);
			//	Źű
			nTemp64 = _atoi64(theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("CSH_RBUY_ABLE_A")));		//	Źű
			strTemp.Format("%I64d", nTemp64);
			strCSH_RBUY_ABLE_A = theApp.SetComma(strTemp);
			//	żɱݾ
			nTemp64 = _atoi64(theApp.m_pCommAgent->GetRealOutputData(nPBID, _T("SBST_RBUY_ABLE_A")));		//	ű
			strTemp.Format("%I64d", nTemp64);
			strSBST_RBUY_ABLE_A = theApp.SetComma(strTemp);

			strData.Format("[ǽð  ܰ ] --> ");
			strTemp.Format("    ڵ : [%s]   ¹ȣ : [%s]\r\n", strITMSCode, strACNO);
			strData += strTemp;
			strTemp.Format("    ֹѾ : [%s]\r\n", strORD_ABLE_TOT_A);
			strData += strTemp;
			strTemp.Format("    ֹ : [%s]\r\n", strORD_ABLE_CSH);
			strData += strTemp;
			strTemp.Format("    Źű : [%s]\r\n", strCSH_RBUY_ABLE_A);
			strData += strTemp;
			strTemp.Format("    ű : [%s]\r\n", strSBST_RBUY_ABLE_A);
			strData += strTemp;
			m_edOutMsg_real.SetWindowText(strData);
		}
		break;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////
//	strOrdType		: ֹ
//	nJangTimeGb		: Խðܱڵ(1:, 2:ð, 3:Ľð)
//	strBidPriceCode	: ȣڵ(1:尡, 2:, 3:뷮, I:Ǻ, X:, Y:ֿ켱)
//	nCondType		: ֹǱڵ(0:Ϲ, 1:IOC, 2:FOK)
///////////////////////////////////////////////////////////////////////////////////////////////////
BOOL CStockFuOpOrderDlg::GetOrderElementsType( CString strOrdType, int &nJangTimeGb, CString &strBidPriceCode, int &nCondType)
{
	BOOL bRet = FALSE;

	if ( strOrdType == _T("") )
	{
		nJangTimeGb		= 1;
		strBidPriceCode	= "2";
		nCondType		= 0;
		bRet = TRUE;
	}
	else if ( strOrdType == _T("尡"))
	{
		nJangTimeGb		= 1;
		strBidPriceCode	= "1";
		nCondType		= 0;
		bRet = TRUE;
	}
	else if ( strOrdType == _T("Ǻ"))
	{
		nJangTimeGb		= 1;
		strBidPriceCode	= "I";
		nCondType	= '0';
		bRet = TRUE;
	}
	else if ( strOrdType == _T(""))
	{
		nJangTimeGb		= 1;
		strBidPriceCode	= "X";
		nCondType		= 0;
		bRet = TRUE;
	}
	else if ( strOrdType == _T("ֿ켱"))
	{
		nJangTimeGb		= 1;
		strBidPriceCode	= "Y";
		nCondType		= 0;
		bRet = TRUE;
	}
	else if ( strOrdType == _T("(IOC)"))
	{
		nJangTimeGb		= 1;
		strBidPriceCode	= "2";
		nCondType		= 3;
		bRet = TRUE;
	}
	else if ( strOrdType == _T("尡(IOC)"))
	{
		nJangTimeGb		= 1;
		strBidPriceCode	= "1";
		nCondType		= 3;
		bRet = TRUE;
	}
	else if ( strOrdType == _T("(IOC)"))
	{
		nJangTimeGb		= 1;
		strBidPriceCode	= "X";
		nCondType		= 3;
		bRet = TRUE;
	}
	else if ( strOrdType == _T("(FOK)"))
	{
		nJangTimeGb		= 1;
		strBidPriceCode	= "2";
		nCondType		= 4;
		bRet = TRUE;
	}
	else if ( strOrdType == _T("尡(FOK)"))
	{
		nJangTimeGb		= 1;
		strBidPriceCode	= "1";
		nCondType		= 4;
		bRet = TRUE;
	}
	else if ( strOrdType == _T("(FOK)"))
	{
		nJangTimeGb		= 1;
		strBidPriceCode	= "X";
		nCondType		= 4;
		bRet = TRUE;
	}
	else if ( strOrdType == _T("ð"))
	{
		nJangTimeGb		= 2;
		strBidPriceCode	= "2";
		nCondType		= 0;
		bRet = TRUE;
	}
	else if ( strOrdType == _T("Ľð"))
	{
		nJangTimeGb		= 3;
		strBidPriceCode	= "2";
		nCondType		= 0;
		bRet = TRUE;
	}
	else if ( strOrdType == _T("ðܴϰ"))
	{
		nJangTimeGb		= 4;
		strBidPriceCode	= "2";
		nCondType		= 0;
		bRet = TRUE;
	}

	return bRet;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
//	ֹ  ŵ/ż//
///////////////////////////////////////////////////////////////////////////////////////////////////
void CStockFuOpOrderDlg::OnBnClickedOfferOrder()
{
	if(theApp.m_TRCnt > 0)
	{
		for(int i =0; i < theApp.m_TRCnt; i++) {
			RequestSendOrder(1); }
	}
	else
	{	RequestSendOrder(1); }
}

void CStockFuOpOrderDlg::OnBnClickedBidOrder()
{
	if(theApp.m_TRCnt > 0)
	{
		for(int i =0; i < theApp.m_TRCnt; i++) {
			RequestSendOrder(2); }
	}
	else
	{	RequestSendOrder(2); }
}

void CStockFuOpOrderDlg::OnBnClickedCorrectOrder()
{
	if(theApp.m_TRCnt > 0)
	{
		for(int i =0; i < theApp.m_TRCnt; i++) {
			RequestSendOrder(3); }
	}
	else
	{	RequestSendOrder(3); }
}

void CStockFuOpOrderDlg::OnBnClickedCancelOrder()
{
	if(theApp.m_TRCnt > 0)
	{
		for(int i =0; i < theApp.m_TRCnt; i++) {
			RequestSendOrder(4); }
	}
	else
	{	RequestSendOrder(4); }
}

void CStockFuOpOrderDlg::RequestSendOrder(int nOrderType)
{
	CString strTemp, strAccNo, strAccPass, strCode, strQty, strOrderPrice, strBidOffer, strOrderCode, strOrderCond, strOrderNo, strOrgOrderNo;
	m_CtrlEdAccNoCtl.GetWindowText( strAccNo );				// ¹ȣ( ڰ Էϴ  )
//	m_CtrlEdAccName.GetWindowText( strCode );				// ¸
	m_CtrlEdAccPwd.GetWindowText( strAccPass );				// ºйȣ
	m_CtrlEdCode.GetWindowText( strCode );					// ڵ
	m_CtrlEdQty.GetWindowText( strQty );					// ֹ
	m_CtrlEdPrice.GetWindowText( strOrderPrice );			// ֹ
	m_CtrlEdOrdNo.GetWindowText( strOrderNo );				// ֹȣ
	m_CtrlSrcOrdNo.GetWindowText( strOrgOrderNo );			// ֹȣ

	m_CtrlCbOrdType.GetLBText(m_CtrlCbOrdType.GetCurSel(), strTemp);	// ֹŸ  

// ORD_BNS_TCD[3] ֹŸűڵ  + ORD_COND_TCD[1] ֹǱڵ 0  1 IOC 2 FOK
	// 010  020 尡 030 Ǻ 040  050 ֿ켱 
	// 060 ڻ 070 ɼڻ 080 Źڻ 090 Ϲݸε 100 ϸε 
	// 110 ECN() 120 뷮 130 ߰뷮 
	// 140 Ű뷮(ð)() 150 Ű뷮()() 160 ߴ뷮 170 ߹ٽ 180 ðܹٽ 
	// 190 ðܽŹ뷮ڻ 200 ðܴ뷮ڻ 
	// 210 ð 220 ðܴ뷮 230 ðܹٽ 
	// 240 ðܴϰ 250 ðܽŹ뷮ڻ 260 ðܴ뷮ڻ 270 ðܴ뷮 280 ð
	
	if (strTemp == "")
	{
		strOrderCode = "010";
		strOrderCond = "0";
	}
	else if (strTemp == "尡")
	{
		strOrderCode = "020";
		strOrderCond = "0";
	}
	else if (strTemp == "Ǻ")
	{
		strOrderCode = "030";
		strOrderCond = "0";
	}
	else if (strTemp == "")
	{
		strOrderCode = "040";
		strOrderCond = "0";
	}
	else if (strTemp == "ֿ켱")
	{
		strOrderCode = "050";
		strOrderCond = "0";
	}
	else 	if (strTemp == "(IOC)")
	{
		strOrderCode = "010";
		strOrderCond = "1";
	}
	else if (strTemp == "尡(IOC)")
	{
		strOrderCode = "020";
		strOrderCond = "1";
	}
	else if (strTemp == "(IOC)")
	{
		strOrderCode = "040";
		strOrderCond = "1";
	}
	else if (strTemp == "(FOK)")
	{
		strOrderCode = "010";
		strOrderCond = "2";
	}
	else if (strTemp == "尡(FOK)")
	{
		strOrderCode = "020";
		strOrderCond = "2";
	}
	else if (strTemp == "(FOK)")
	{
		strOrderCode = "040";
		strOrderCond = "2";
	}
	else if (strTemp == "ð")
	{
		strOrderCode = "210";
		strOrderCond = "0";
		strOrderPrice = "0";
	}
else if (strTemp == "Ľð")
	{
		strOrderCode = "280";
		strOrderCond = "0";
		strOrderPrice = "0";
	}
else if (strTemp == "ðܴϰ")
	{
		strOrderCode = "240";
		strOrderCond = "0";
	}
	
	short nMarketType = theApp.m_pCommAgent->GetMarketKubun(strCode, _T(""));

	CString strTrCode;
	long nRQID = theApp.m_pCommAgent->CreateRequestID();
	if ( nOrderType == 1 || nOrderType == 2)					//	ŵ, ż
	{
		if ( nMarketType == 24 || nMarketType == 25 || nMarketType == 64 || nMarketType == 38 )			//	, ɼ, ֽļ, ֽĿɼ
		{
			strTrCode = RQ_TRNAME_FUOP_BS_ORDER;
			if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ACNO"), strAccNo) <= 0 )
			{
				::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "¹ȣ Է ", MB_OK|MB_TOPMOST);
				return;
			}
			if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("AC_PWD"), strAccPass) <= 0 )
			{
				::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "º Է ", MB_OK|MB_TOPMOST);
				return;
			}
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ITEM_COD"), strCode);
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_Q"), strQty);
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_UPR"), strOrderPrice);
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("BUY_SEL_TR_TCD"), (nOrderType == 1) ? "10" : "20");
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_BNS_TCD"), strOrderCode);
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_COND_TCD"), strOrderCond);
		}
		else
		{
			strTrCode = RQ_TRNAME_STOCK_BS_ORDER;
			if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ACNO"), strAccNo) <= 0 )
			{
				::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "¹ȣ Է ", MB_OK|MB_TOPMOST);
				return;
			}
			if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("AC_PWD"), strAccPass) <= 0 )
			{
				::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "º Է ", MB_OK|MB_TOPMOST);
				return;
			}
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ITEM_COD"), strCode);
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_Q"), strQty);
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("STK_BD_ORD_UPR"), strOrderPrice);
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("BUY_SEL_TR_TCD"), (nOrderType == 1) ? "10" : "20");
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_BNS_TCD"), strOrderCode);
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_COND_TCD"), strOrderCond);
		}
	}
	else if ( nOrderType == 3 || nOrderType == 4)	//	, 
	{
		if ( nMarketType == 24 || nMarketType == 25 || nMarketType == 64 || nMarketType == 38 )			//	, ɼ, ֽļ, ֽĿɼ
		{
			strTrCode = RQ_TRNAME_FUOP_MC_ORDER;
			if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ACNO"), strAccNo) <= 0 )
			{
				::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "¹ȣ Է ", MB_OK|MB_TOPMOST);
				return;
			}
			if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("AC_PWD"), strAccPass) <= 0 )
			{
				::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "º Է ", MB_OK|MB_TOPMOST);
				return;
			}
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("OORD_NO"), strOrgOrderNo);
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ITEM_COD"), strCode);
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_Q"), strQty);
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_UPR"), strOrderPrice);
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_MDFY_CNCL_TCD"), (nOrderType == 3) ? "20" : "30");	//	"20" :  "30" : 
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("BUY_SEL_TR_TCD"), _T("20"));								//	ϴ ׽Ʈ ̹Ƿ ż  Ѵ.
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("PAT_ALL_TCD"), _T("20"));									//	"10" : Ϻ "20" : 
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_BNS_TCD"), strOrderCode);
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_COND_TCD"), strOrderCond);
		}
		else
		{
			strTrCode = RQ_TRNAME_STOCK_MC_ORDER;
			if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ACNO"), strAccNo) <= 0 )
			{
				::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "¹ȣ Է ", MB_OK|MB_TOPMOST);
				return;
			}
			if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("AC_PWD"), strAccPass) <= 0 )
			{
				::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "º Է ", MB_OK|MB_TOPMOST);
				return;
			}
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("OORD_NO"), strOrgOrderNo);
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_MDFY_CNCL_TCD"), (nOrderType == 3) ? "20" : "30");	//	"20" :  "30" : 
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("PAT_ALL_TCD"), _T("20"));									//	"10" : Ϻ "20" : 
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ITEM_COD"), strCode);
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_Q"), strQty);
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("STK_BD_ORD_UPR"), strOrderPrice);
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_BNS_TCD"), strOrderCode);
			theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_COND_TCD"), strOrderCond);
		}
	}

	if ( theApp.m_pCommAgent->RequestTran(nRQID, strTrCode, _T(""), 20) <= 0 )
	{
		CString strLastErrMsg = theApp.m_pCommAgent->GetLastErrMsg();
		::MessageBox(GetSafeHwnd(), strLastErrMsg, "ֹ  û ", MB_OK|MB_TOPMOST);
//		AfxMessageBox(("ֹ  û Ͽϴ.");
		return;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////
//	ֽĹü/üȸ Transaction
//	CString strAccNo,				/* ¹ȣ */
//	CString strAccPass,				/* º */
//	int		nPrevNext,				/*  0:Ϲ, 1:, 2: */
//	CString strOrderNo = _T("")		/* ֹȣ (Ű ) */
///////////////////////////////////////////////////////////////////////////////////////////////////
int CStockFuOpOrderDlg::RequestTrStockCheKyeol(CString strACNO, CString strAC_PWD, CString strORD_NO, CString strBUY_SEL_TR_TCD, 
											   CString strITEM_COD, CString strSORT_TURN_IO1CD, CString strSCR_QRY_TCD, CString strPrevNext/* = _T("")*/)
{
	CString strTemp, strTrCode = RQ_TRNAME_STOCK_ORDER_CHE;
	
	long nRQID = theApp.m_pCommAgent->CreateRequestID();
	if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ACNO"), strACNO) <= 0 )
	{
		::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "¹ȣ Է ", MB_OK|MB_TOPMOST);
		return 0;
	}
	if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("AC_PWD"), strAC_PWD) <= 0 )
	{
		::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "º Է ", MB_OK|MB_TOPMOST);
		return 0;
	}
	theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ORD_NO"), strORD_NO);
	theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("BUY_SEL_TR_TCD"), strBUY_SEL_TR_TCD);
	theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ITEM_COD"), strITEM_COD);
	theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("SORT_TURN_IO1CD"), strSORT_TURN_IO1CD);
	theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("SCR_QRY_TCD"), strSCR_QRY_TCD);

	if ( strPrevNext == _T("") )
		m_CtrlListOutStdOrd.DeleteAllItems();

	//	ſû
	if ( theApp.m_pCommAgent->RequestTran(nRQID, strTrCode, strPrevNext, 20) <= 0 )
	{
		CString strLastErrMsg = theApp.m_pCommAgent->GetLastErrMsg();
		::MessageBox(GetSafeHwnd(), strLastErrMsg, "ֽ ü  û ", MB_OK|MB_TOPMOST);
		return 0;
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
//	ܰ Transaction
///////////////////////////////////////////////////////////////////////////////////////////////////
int CStockFuOpOrderDlg::RequestTrStockJango( CString strACNO, CString strAC_PWD, CString strCMSN_ICLN_YN, CString strPrevNext/* = _T("")*/)
{
	CString strTemp, strTrCode = RQ_TRNAME_STOCK_ORDER_JANGO;

	long nRQID = theApp.m_pCommAgent->CreateRequestID();
	if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ACNO"), strACNO) <= 0 )
	{
		::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "¹ȣ Է ", MB_OK|MB_TOPMOST);
		return 0;
	}
	if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("AC_PWD"), strAC_PWD) <= 0 )
	{
		::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "º Է ", MB_OK|MB_TOPMOST);
		return 0;
	}
	theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("CMSN_ICLN_YN"), strCMSN_ICLN_YN);

	if ( strPrevNext == _T("") )
		m_CtrlListStock.DeleteAllItems();

	//	ſû
	if ( theApp.m_pCommAgent->RequestTran(nRQID, strTrCode, strPrevNext, 20) <= 0 )
	{
		CString strLastErrMsg = theApp.m_pCommAgent->GetLastErrMsg();
		::MessageBox(GetSafeHwnd(), strLastErrMsg, "ֽ ܰ  û ", MB_OK|MB_TOPMOST);
		return 0;
	}

	return 0;
}

void CStockFuOpOrderDlg::ReceiveTrStockChekeyol(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strValue, strTemp;
	int nDataCnt = 0;
	char szTemp[128] = {0x00};
	long lTemp;
	int nItem;
	int nListRowCnt = m_CtrlListOutStdOrd.GetItemCount();

	if ( nDataLength > 0 )
	{	// Data OK
		//Ű

		typedef struct _STOCK_CHEKEYOL_OUTREC1
		{
			char		LMKT_STK_SEL_A[19];		/*  [峻ֽĸŵݾ]     */
			char		LMKT_STK_BUY_A[19];		/*  [峻ֽĸżݾ]     */
			char		AC_NM[50];				/*  [¸]     */
			char		RECNM[19];				/*  [ڵ]     */
		}STOCK_CHEKEYOL_OUTREC1;

		typedef struct _STOCK_CHEKEYOL_OUTREC2
		{
			char		ORD_DT[8];				/*  [ֹ]     */
			char		ACMT_BR_COD[3];			/*  [°ڵ]     */
			char		DEPT_NM[50];			/*  [μ]     */
			char		MKTR_PCD[3];			/*  [ŷڵ]     */
			char		ORD_NO[11];				/*  [ֹȣ]     */
			char		OORD_NO[11];			/*  [ֹȣ]     */
			char		ITEM_COD[12];			/*  [ڵ]     */
			char		ITEM_ABBR_NM[50];		/*  []     */
			char		ORD_MDFY_CNCL_TCD[2];	/*  [ֹұڵ]     */
			char		ORD_KCD[4];				/*  [ֹڵ]     */
			char		ORD_BNS_TCD[3];			/*  [ֹŸűڵ]     */
			char		ORD_Q[19];				/*  [ֹ]     */
			char		ORD_UPR[17];			/*  [ֹܰ]     */
			char		ORD_RQ[19];				/*  [ֹܷ]     */
			char		CLSN_Q[19];				/*  [ü]     */
			char		ORD_DTTM[14];			/*  [ֹϽ]     */
			char		CFMT_Q[19];				/*  [Ȯμ]     */
			char		ORD_MDA_TCD[3];			/*  [ֹüڵ]     */
			char		ORD_SCD[3];				/*  [ֹڵ]     */
			char		STL_Q[19];				/*  []     */
			char		ORD_PRC_STAT_TCD[3];	/*  [ֹó±ڵ]     */
			char		WKER_ID[9];				/*  [۾ID]     */
			char		MTEMP_NM[50];			/*  []     */
			char		RJT_TCD[4];				/*  [źαڵ]     */
			char		ST_TCD[3];				/*  [Ǳڵ]     */
			char		BUY_SEL_TR_TCD[2];		/*  [żŵŷڵ]     */
			char		TCLSN_Q[19];			/*  [ü]     */
			char		CRDTR_TCD[3];			/*  [ſŷڵ]     */
			char		CLN_DT[8];				/*  [ſ]     */
			char		RESV_ORD_YN[1];			/*  [ֹ]     */
			char		ORD_COND_TCD[1];		/*  [ֹǱڵ]     */
			char		IOCD_NM[50];			/*  [IOڵ]     */
			char		CLSN_UPR[17];			/*  [üܰ]     */
		}STOCK_CHEKEYOL_OUTREC2;

		STOCK_CHEKEYOL_OUTREC1* pOutRec1 = (STOCK_CHEKEYOL_OUTREC1*)sData;
		STOCK_CHEKEYOL_OUTREC2* pOutRec2 = (STOCK_CHEKEYOL_OUTREC2*)(sData + sizeof(STOCK_CHEKEYOL_OUTREC1));
		memcpy(szTemp, pOutRec1->RECNM, sizeof(pOutRec1->RECNM));
		nDataCnt = _ttoi(szTemp);

		if(nDataCnt > 0)
		{
			//ֹü Ÿ .
			for (int i = 0; i < nDataCnt; i++)
			{
				//	ֹü ڵ 
				strTemp = CString(pOutRec2[i].ORD_NO, _countof(pOutRec2[i].ORD_NO));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				nItem = m_CtrlListOutStdOrd.InsertItem( LVIF_TEXT, i + nListRowCnt, strTemp, 0, 0, 0, NULL );		// ֹȣ
//				m_CtrlListOutStdOrd.SetItemText(nItem, 0, strTemp.Trim());		// ֹȣ

				//	ŵ/ż ̿ а ڵ忡 ߰ ʴ´. 
				strTemp = CString(pOutRec2[i].ORD_KCD, _countof(pOutRec2[i].ORD_KCD));
				if (_tstol(strTemp) == 10 || _tstol(strTemp) == 270 || _tstol(strTemp) == 310 || _tstol(strTemp) == 470) 
					strTemp = _T("ŵ");
				else if (_tstol(strTemp) == 20 || _tstol(strTemp) == 280 || _tstol(strTemp) == 320 || _tstol(strTemp) == 480) 
					strTemp = _T("ż");
				else
					strTemp.Format("(%ld)ڵ尪", _tstol(strTemp));
				m_CtrlListOutStdOrd.SetItemText(nItem, 1, strTemp.Trim());		// Ÿű

				lTemp = _tstol(CString(pOutRec2[i].ORD_BNS_TCD, _countof(pOutRec2[i].ORD_BNS_TCD)));
				if (lTemp == 20) 
					strTemp = _T("尡");
				else if (lTemp == 30)
					strTemp = _T("Ǻ");
				else if (lTemp == 40)
					strTemp = _T("");
				else if (lTemp == 50)
					strTemp = _T("ֿ켱");
				else
					strTemp.Format("(%ld)ڵ尪", lTemp);
				m_CtrlListOutStdOrd.SetItemText(nItem, 2, strTemp.Trim());		// ֹ


				strTemp = CString(pOutRec2[i].ITEM_ABBR_NM, _countof(pOutRec2[i].ITEM_ABBR_NM));	strTemp.Trim();
				m_CtrlListOutStdOrd.SetItemText(nItem, 3, strTemp.Trim());		// 

				strTemp = CString(pOutRec2[i].ORD_UPR, _countof(pOutRec2[i].ORD_UPR));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListOutStdOrd.SetItemText(nItem, 4, theApp.SetComma(strTemp));		// ֹ

				strTemp = CString(pOutRec2[i].ORD_Q, _countof(pOutRec2[i].ORD_Q));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListOutStdOrd.SetItemText(nItem, 5, theApp.SetComma(strTemp));		// ֹ

				strTemp = CString(pOutRec2[i].ORD_RQ, _countof(pOutRec2[i].ORD_RQ));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListOutStdOrd.SetItemText(nItem, 6, theApp.SetComma(strTemp));		// ü

				strTemp = CString(pOutRec2[i].OORD_NO, _countof(pOutRec2[i].OORD_NO));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListOutStdOrd.SetItemText(nItem, 7, strTemp.Trim());		// ֹȣ

				lTemp = _tstol(CString(pOutRec2[i].ORD_PRC_STAT_TCD, _countof(pOutRec2[i].ORD_PRC_STAT_TCD)));
				if (lTemp == 10) 
					strTemp = _T("Ϸ");
				else if (lTemp == 20)
					strTemp = _T("ҿϷ");
				else if (lTemp == 30)
					strTemp = _T("Ұ");
				else if (lTemp == 40)
					strTemp = _T("ҺҰ");
				else
					strTemp.Format("(%ld)ڵ尪", lTemp);
				m_CtrlListOutStdOrd.SetItemText(nItem, 8, strTemp.Trim());		// ֹ

				strValue = CString(pOutRec2[i].ORD_DTTM, _countof(pOutRec2[i].ORD_DTTM));
				strValue.Trim();
				strTemp.Format("%s:%s:%s", strValue.Left(2),strValue.Mid(2,2),strValue.Right(2));
				m_CtrlListOutStdOrd.SetItemText(nItem, 9, strTemp.Trim());		// ֹð

				strTemp = CString(pOutRec2[i].ITEM_COD, _countof(pOutRec2[i].ITEM_COD));
				m_CtrlListOutStdOrd.SetItemText(nItem, 10, strTemp.Trim());		// ڵ

			}

			//	ȸ
			CString strNextKey = sPreNext;
			if(strNextKey != _T("") )
			{
				int		nPrevNext = 1;
				CString strACNO;				//¹ȣ
				CString strAC_PWD;				//ºйȣ
				CString strORD_NO;				//ֹȣ
				CString strBUY_SEL_TR_TCD;		//żŵŷڵ
				CString strITEM_COD;			//ڵ
				CString strSORT_TURN_IO1CD;		//ļIO1ڵ
				CString strSCR_QRY_TCD;			//ȭȸڵ

				m_CtrlEdAccNoCtl.GetWindowText( strACNO );				// ¹ȣ.- ڸ 11ڸ
				strACNO.Remove('-');
				m_CtrlEdAccPwd.GetWindowText( strAC_PWD );				// ºйȣ
				strORD_NO = _T("");										// ȸ ֹȣ. NULL̸ ֹ . Է½ Ưֹȣ   . 1 ֹȣ̸ "1" 
				strBUY_SEL_TR_TCD = _T("%");							// "%" : ü "10" : ŵ "20" : ż
				strITEM_COD = _T("");									// ڵ Է½ Ư ֹü᳻ ."%"(ü)  Էϸ  ܰ 
				strSORT_TURN_IO1CD = _T("2");							// "1" :  "2" : ,	ֹȣ  / ȸ
				strSCR_QRY_TCD = _T("01");								// "01" : ü "02" : ü

				if ( RequestTrStockCheKyeol( strACNO, strAC_PWD, strORD_NO, strBUY_SEL_TR_TCD, strITEM_COD, strSORT_TURN_IO1CD, strSCR_QRY_TCD, strNextKey ) > 0 )
					return;
				else
					TRACE("ֽ ֹü  ȸ \n");
			}
		}
	}
	else
	{	// Error
		AfxMessageBox(sMessage);
	}
}

void CStockFuOpOrderDlg::ReceiveTrStockJango(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strValue, strTemp;
	int nDataCnt = 0;
	char szTemp[128] = {0x00};
	long lTemp;
	double dTemp;
	int nItem;

	if ( nDataLength > 0 )
	{	// Data OK
		//Ű

		typedef struct _STOCK_JANGO_OUTREC1
		{
			char		AC_TDA[19];						/*  [ѿ]     */
			char		D1_ESTI_DA[19];					/*  [D1]     */
			char		D2_ESTI_DA[19];					/*  [D2]     */
			char		AC_TSBA[19];					/*  [Ѵ]     */
			char		CSH_DFA[19];					/*  [ݹ̼]     */
			char		ORD_ABLE_CSH[19];				/*  [ֹ]     */
			char		GNRL_AGRD_MAX_ORD_ABLE_A[19];	/*  [ϹAִֹɱݾ]     */
			char		GNRL_BGRD_MAX_ORD_ABLE_A[19];	/*  [ϹBִֹɱݾ]     */
			char		GNRL_CGRD_MAX_ORD_ABLE_A[19];	/*  [ϹCִֹɱݾ]     */
			char		GNRL_DGRD_MAX_ORD_ABLE_A[19];	/*  [ϹDִֹɱݾ]     */
			char		LS_MAX_ORD_ABLE_A[19];			/*  [ִֹɱݾ]     */
			char		CRD_BGRD_MAX_ORD_ABLE_A[19];	/*  [ſBִֹɱݾ]     */
			char		CRD_CGRD_MAX_ORD_ABLE_A[19];	/*  [ſCִֹɱݾ]     */
			char		CRD_DGRD_MAX_ORD_ABLE_A[19];	/*  [ſDִֹɱݾ]     */
			char		CRD_MLN_A[19];					/*  [ſڱݾ]     */
			char		MGE_MNTN_RT[17];				/*  [㺸]     */
			char		MGLCK_A[19];					/*  [㺸ݾ]     */
			char		LS_SUM_A[19];					/*  [հݾ]     */
			char		AM_BAL_A[19];					/*  [ܰݾ]     */
			char		BNS_BAL_A[19];					/*  [Ÿܰݾ]     */
			char		AM_PL_A[19];					/*  [ͱݾ]     */
			char		AM_PL_R[17];					/*  []     */
			char		RECNM[19];						/*  [ڵ]     */

		}STOCK_JANGO_OUTREC1;

		typedef struct _STOCK_JANGO_OUTREC2
		{
			char		ITEM_COD[12];					/*  [ڵ]     */
			char		ITEM_NM[50];					/*  []     */
			char		CRD_TCD[3];						/*  [ſ뱸ڵ]     */
			char		BNS_ABLE_Q[19];					/*  [ŸŰɼ]     */
			char		SEL_PRGS_Q[19];					/*  [ŵ]     */
			char		STL_BAL_Q[19];					/*  [ܰ]     */
			char		BNS_BAL_Q[19];					/*  [Ÿܰ]     */
			char		BFDY_CLSN_BUY_Q[19];			/*  [üż]     */
			char		BFDY_CLSN_SEL_Q[19];			/*  [üŵ]     */
			char		TDY_CLSN_BUY_Q[19];				/*  [üż]     */
			char		TDY_CLSN_SEL_Q[19];				/*  [üŵ]     */
			char		BUY_UPR[17];					/*  [żܰ]     */
			char		ACBK_A[19];						/*  [αݾ]     */
			char		RLZ_PL_A[19];					/*  [ͱݾ]     */
			char		SEL_UPR[17];					/*  [ŵܰ]     */
			char		ESTI_CMSN[19];					/*  []     */
			char		ESTI_TXA[19];					/*  []     */
			char		LN_DT[8];						/*  []     */
			char		DUE_DT[8];						/*  []     */
			char		RPY_ABLE_Q[19];					/*  [ȯɼ]     */
			char		CRD_A[19];						/*  [ſݾ]     */
			char		STK_CRPR[19];					/*  [ֽ簡]     */
			char		STK_EA[19];						/*  [ֽ򰡱ݾ]     */
			char		EV_PL_A[19];					/*  [򰡼ͱݾ]     */
			char		ERN_R[17];						/*  [ͷ]     */
			char		VRTL_EA[19];					/*  [򰡱ݾ]     */
			char		VRTL_EV_PL_A[19];				/*  [򰡼ͱݾ]     */
			char		VRTL_EV_PL_R[17];				/*  [򰡼ͷ]     */

		}STOCK_JANGO_OUTREC2;

		STOCK_JANGO_OUTREC1* pOutRec1 = (STOCK_JANGO_OUTREC1*)sData;
		STOCK_JANGO_OUTREC2* pOutRec2 = (STOCK_JANGO_OUTREC2*)(sData + sizeof(STOCK_JANGO_OUTREC1));
		memcpy(szTemp, pOutRec1->RECNM, sizeof(pOutRec1->RECNM));
		nDataCnt = _ttoi(szTemp);

		if(nDataCnt > 0)
		{
			//ֹü Ÿ .
			for (int i = 0; i < nDataCnt; i++)
			{
				//	ֹü ڵ 
				strTemp = CString(pOutRec2[i].ITEM_COD, _countof(pOutRec2[i].ITEM_COD));
				strTemp.Remove(_T('A'));
				strTemp.Remove(_T('J'));
				strTemp.Remove(_T('Q'));
				nItem = m_CtrlListStock.InsertItem( LVIF_TEXT, i, strTemp.Trim(), 0, 0, 0, NULL );		// ڵ

				strTemp = CString(pOutRec2[i].ITEM_NM, _countof(pOutRec2[i].ITEM_NM));
				m_CtrlListStock.SetItemText(nItem, 1, strTemp.Trim());								// 

				lTemp = _tstol(CString(pOutRec2[i].CRD_TCD, _countof(pOutRec2[i].CRD_TCD)));
				if (lTemp == 20) 
					strTemp = _T("");
				else if (lTemp == 30)
					strTemp = _T("ڱ");
				else if (lTemp == 40)
					strTemp = _T("");
				else if (lTemp == 50)
					strTemp = _T("ڱ");
				else
					strTemp = _T("");
				m_CtrlListStock.SetItemText(nItem, 2, strTemp.Trim());					// ܰ

				strTemp = CString(pOutRec2[i].BNS_BAL_Q, _countof(pOutRec2[i].BNS_BAL_Q));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListStock.SetItemText(nItem, 3, strTemp.Trim());					// 

				strTemp = CString(pOutRec2[i].BNS_ABLE_Q, _countof(pOutRec2[i].BNS_ABLE_Q));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListStock.SetItemText(nItem, 4, theApp.SetComma(strTemp));		// ŵ

				strTemp = CString(pOutRec2[i].BUY_UPR, _countof(pOutRec2[i].BUY_UPR));
				strTemp.Format("%ld", _tstol(strTemp));
				m_CtrlListStock.SetItemText(nItem, 5, theApp.SetComma(strTemp));		// Դܰ

				strTemp = CString(pOutRec2[i].STK_CRPR, _countof(pOutRec2[i].STK_CRPR));
				strTemp.Format("%ld", _tstol(strTemp));
				m_CtrlListStock.SetItemText(nItem, 6, theApp.SetComma(strTemp));		// 簡

				strTemp = CString(pOutRec2[i].EV_PL_A, _countof(pOutRec2[i].EV_PL_A));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListStock.SetItemText(nItem, 7, theApp.SetComma(strTemp));		// 򰡼

				strTemp = CString(pOutRec2[i].ERN_R, _countof(pOutRec2[i].ERN_R));
				dTemp = _tstof(strTemp);
				strTemp.Format("%0.2f", dTemp);
				m_CtrlListStock.SetItemText(nItem, 8, theApp.SetComma(strTemp));		// 

				strTemp = CString(pOutRec2[i].STK_EA, _countof(pOutRec2[i].STK_EA));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListStock.SetItemText(nItem, 9, theApp.SetComma(strTemp));		// ֽ򰡱ݾ

				strTemp = CString(pOutRec2[i].ESTI_CMSN, _countof(pOutRec2[i].ESTI_CMSN));
				lTemp = _tstol(strTemp);
				strTemp = CString(pOutRec2[i].ESTI_TXA, _countof(pOutRec2[i].ESTI_TXA));
				strTemp.Format("%ld", _tstol(strTemp) + lTemp);
				m_CtrlListStock.SetItemText(nItem, 10, theApp.SetComma(strTemp));		// 

			}

			//	ȸ
			CString strNextKey = sPreNext;
			if(strNextKey != _T("") )
			{
				int		nPrevNext = 1;
				CString strACNO;			//¹ȣ
				CString strAC_PWD;			//ºйȣ
				CString strCMSN_ICLN_YN;	//Կ

				m_CtrlEdAccNoCtl.GetWindowText( strACNO );				// ¹ȣ.- ڸ 11ڸ
				strACNO.Remove('-');
				m_CtrlEdAccPwd.GetWindowText( strAC_PWD );				// ºйȣ
				strCMSN_ICLN_YN = _T("N");

				if ( RequestTrStockJango( strACNO, strAC_PWD, strCMSN_ICLN_YN, strNextKey ) > 0 )
					return;
				else
					TRACE("ֽ ܰ  ȸ \n");
			}
		}
	}
	else
	{	// Error
		AfxMessageBox(sMessage);
	}
}

// ü ȸ
void CStockFuOpOrderDlg::OnBnClickedOutstdorder()
{
	int		nPrevNext = 0;

	CString strACNO;				//¹ȣ
	CString strAC_PWD;				//ºйȣ
	CString strORD_NO;				//ֹȣ
	CString strBUY_SEL_TR_TCD;		//żŵŷڵ
	CString strITEM_COD;			//ڵ
	CString strSORT_TURN_IO1CD;		//ļIO1ڵ
	CString strSCR_QRY_TCD;			//ȭȸڵ

	m_CtrlEdAccNoCtl.GetWindowText( strACNO );				// ¹ȣ.- ڸ 11ڸ
	strACNO.Remove('-');
	m_CtrlEdAccPwd.GetWindowText( strAC_PWD );				// ºйȣ
	strORD_NO = _T("");										// ȸ ֹȣ. NULL̸ ֹ . Է½ Ưֹȣ   . 1 ֹȣ̸ "1" 
	strBUY_SEL_TR_TCD = _T("%");							// "% " : ü "10" : ŵ "20" : ż
	strITEM_COD = _T("");									// ڵ Է½ Ư ֹü᳻ ."%"(ü)  Էϸ  ܰ 
	strSORT_TURN_IO1CD = _T("2");							// "1" :  "2" : ,	ֹȣ  / ȸ
	strSCR_QRY_TCD = _T("01");								// "01" : ü "02" : ü
	if(theApp.m_TRCnt > 0)
	{
		for(int i=0; i < theApp.m_TRCnt; i++)
		{	RequestTrStockCheKyeol( strACNO, strAC_PWD, strORD_NO, strBUY_SEL_TR_TCD, strITEM_COD, strSORT_TURN_IO1CD, strSCR_QRY_TCD );	}
	}
	else
		{	RequestTrStockCheKyeol( strACNO, strAC_PWD, strORD_NO, strBUY_SEL_TR_TCD, strITEM_COD, strSORT_TURN_IO1CD, strSCR_QRY_TCD );	}
}

// ֽ ܰ ȸ
void CStockFuOpOrderDlg::OnBnClickedStockBtn()
{
	int		nPrevNext = 0;

	CString strACNO;			//¹ȣ
	CString strAC_PWD;			//ºйȣ
	CString strCMSN_ICLN_YN;	//Կ

	m_CtrlEdAccNoCtl.GetWindowText( strACNO );				// ¹ȣ.- ڸ 11ڸ
	strACNO.Remove('-');
	m_CtrlEdAccPwd.GetWindowText( strAC_PWD );				// ºйȣ
	strCMSN_ICLN_YN = _T("N");
	if(theApp.m_TRCnt > 0)
	{
		for(int i=0; i < theApp.m_TRCnt; i++)
		{  RequestTrStockJango( strACNO, strAC_PWD, strCMSN_ICLN_YN ); }
	}
	else
		{  RequestTrStockJango( strACNO, strAC_PWD, strCMSN_ICLN_YN ); }
}

void CStockFuOpOrderDlg::OnBnClickedStockaccinfoBtn()
{
	int		nPrevNext = 0;

	CString strACNO;			//¹ȣ
	CString strAC_PWD;			//ºйȣ

	m_CtrlEdAccNoCtl.GetWindowText( strACNO );				// ¹ȣ.- ڸ 11ڸ
	strACNO.Remove('-');
	m_CtrlEdAccPwd.GetWindowText( strAC_PWD );				// ºйȣ
	if(theApp.m_TRCnt > 0)
	{
		for(int i=0; i < theApp.m_TRCnt; i++)
		{	RequestTrStockAccInfo( strACNO, strAC_PWD );	}
	}
	else
		{	RequestTrStockAccInfo( strACNO, strAC_PWD );	}
}

//  ȸ
int CStockFuOpOrderDlg::RequestTrStockAccInfo(CString strACNO, CString strAC_PWD)
{
	CString strTemp, strTrCode = RQ_TRNAME_STOCK_ORDER_DEPOSIT;

	long nRQID = theApp.m_pCommAgent->CreateRequestID();
	if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ACNO"), strACNO) <= 0 )
	{
		::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "¹ȣ Է ", MB_OK|MB_TOPMOST);
		return 0;
	}
	if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("AC_PWD"), strAC_PWD) <= 0 )
	{
		::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "º Է ", MB_OK|MB_TOPMOST);
		return 0;
	}

	//	ſû
	if ( theApp.m_pCommAgent->RequestTran(nRQID, strTrCode, _T(""), 20) <= 0 )
	{
		CString strLastErrMsg = theApp.m_pCommAgent->GetLastErrMsg();
		::MessageBox(GetSafeHwnd(), strLastErrMsg, "ֽ Ź  û ", MB_OK|MB_TOPMOST);
		return 0;
	}

	return 0;
}

void CStockFuOpOrderDlg::ReceiveTrStockAccInfo(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	if ( nDataLength > 0 )
	{	// Data OK
		CString strAC_TDA, strCSH_MA, strTemp;
		strAC_TDA = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_ORDER_DEPOSIT, _T("OutRec1"), _T("AC_TDA"), 0);			//ѿ
		strAC_TDA.Trim();

		strCSH_MA= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_ORDER_DEPOSIT, _T("OutRec1"), _T("CSH_MA"), 0);			//ű
		strCSH_MA.Trim();

		strTemp.Format("[] = (%s), ű(%s)", theApp.SetComma(strAC_TDA), theApp.SetComma(strCSH_MA));

		AfxMessageBox(strTemp);
	}
	else
	{	// Error
		AfxMessageBox(sMessage);
	}
}

void CStockFuOpOrderDlg::OnBnClickedOutfodorder()
{
	int		nPrevNext = 0;

	CString strORD_DT;				//ֹ
	CString strACNO;				//¹ȣ
	CString strAC_PWD;				//ºйȣ
	CString strSORT_TURN_IO1CD;		//ļIO1ڵ
	CString strCLSN_TP_IO1CD;		//üᱸIO1ڵ
	CString strBUY_SEL_TR_TCD;		//żŵŷڵ
	CString strITEM_TP_IO1CD;		//񱸺IO1ڵ
	CString strITEM_COD;			//ڵ

	m_CtrlEdAccNoCtl.GetWindowText( strACNO );				// ¹ȣ.- ڸ 11ڸ
	strACNO.Remove('-');
	m_CtrlEdAccPwd.GetWindowText( strAC_PWD );				// ºйȣ
	strORD_DT = _T("");
	strSORT_TURN_IO1CD = _T("2");							// "1" :  "2" : ,	ֹȣ  / ȸ
	strCLSN_TP_IO1CD = _T("%");								// "%":ü, "1":ü, "2":ü
	strBUY_SEL_TR_TCD = _T("%");							// "% " : ü "10" : ŵ "20" : ż
	strITEM_TP_IO1CD = _T("%");								// "%":ü, "1":, "2":Call, "3":Put, "4":
	strITEM_COD = _T("");									// ڵ. ȸ ڵ. NULL̸ ü ֹ . Է½ Ưڵ ֹ  
	if(theApp.m_TRCnt > 0)
	{
		for(int i=0; i < theApp.m_TRCnt; i++)
		{	RequestTrFOCheKyeol( strACNO, strAC_PWD, strSORT_TURN_IO1CD, strCLSN_TP_IO1CD, strBUY_SEL_TR_TCD, strITEM_TP_IO1CD, strITEM_COD);	}
	}
	else
		{	RequestTrFOCheKyeol( strACNO, strAC_PWD, strSORT_TURN_IO1CD, strCLSN_TP_IO1CD, strBUY_SEL_TR_TCD, strITEM_TP_IO1CD, strITEM_COD);	}

}

//	 ü/ü
int CStockFuOpOrderDlg::RequestTrFOCheKyeol( CString strACNO, CString strAC_PWD, CString strSORT_TURN_IO1CD, CString strCLSN_TP_IO1CD, CString strBUY_SEL_TR_TCD,
											CString strITEM_TP_IO1CD, CString strITEM_COD, CString strPrevNext/* = _T("")*/)
{
	CString strTemp, strTrCode = RQ_TRNAME_FUOP_ORDER_CHE;

	long nRQID = theApp.m_pCommAgent->CreateRequestID();
	if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ACNO"), strACNO) <= 0 )
	{
		::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "¹ȣ Է ", MB_OK|MB_TOPMOST);
		return 0;
	}
	if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("AC_PWD"), strAC_PWD) <= 0 )
	{
		::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "º Է ", MB_OK|MB_TOPMOST);
		return 0;
	}
	theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("SORT_TURN_IO1CD"), strSORT_TURN_IO1CD);
	theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("CLSN_TP_IO1CD"), strCLSN_TP_IO1CD);
	theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("BUY_SEL_TR_TCD"), strBUY_SEL_TR_TCD);
	theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ITEM_TP_IO1CD"), strITEM_TP_IO1CD);
	theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ITEM_COD"), strITEM_COD);

	if ( strPrevNext == _T("") )
		m_CtrlListOutStdOrd.DeleteAllItems();

	//	ſû
	if ( theApp.m_pCommAgent->RequestTran(nRQID, strTrCode, strPrevNext, 20) <= 0 )
	{
		CString strLastErrMsg = theApp.m_pCommAgent->GetLastErrMsg();
		::MessageBox(GetSafeHwnd(), strLastErrMsg, "/ɼ ü  û ", MB_OK|MB_TOPMOST);
		return 0;
	}

	return 0;

}

void CStockFuOpOrderDlg::OnBnClickedFutoptBtn()
{
	int		nPrevNext = 0;

	CString strACNO;			//¹ȣ
	CString strAC_PWD;			//ºйȣ

	m_CtrlEdAccNoCtl.GetWindowText( strACNO );				// ¹ȣ.- ڸ 11ڸ
	strACNO.Remove('-');
	m_CtrlEdAccPwd.GetWindowText( strAC_PWD );				// ºйȣ

	RequestTrFOJango( strACNO, strAC_PWD );
}

//  ܰ Transaction
int CStockFuOpOrderDlg::RequestTrFOJango(CString strACNO, CString strAC_PWD, CString strPrevNext)
{
	CString strTemp, strTrCode = RQ_TRNAME_FUOP_ORDER_JANGO;

	long nRQID = theApp.m_pCommAgent->CreateRequestID();
	if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ACNO"), strACNO) <= 0 )
	{
		::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "¹ȣ Է ", MB_OK|MB_TOPMOST);
		return 0;
	}
	if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("AC_PWD"), strAC_PWD) <= 0 )
	{
		::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "º Է ", MB_OK|MB_TOPMOST);
		return 0;
	}

	if ( strPrevNext == _T("") )
		m_CtrlListStock.DeleteAllItems();

	//	ſû
	if ( theApp.m_pCommAgent->RequestTran(nRQID, strTrCode, strPrevNext, 20) <= 0 )
	{
		CString strLastErrMsg = theApp.m_pCommAgent->GetLastErrMsg();
		::MessageBox(GetSafeHwnd(), strLastErrMsg, "/ɼ ܰ  û ", MB_OK|MB_TOPMOST);
		return 0;
	}

	return 0;
}

void CStockFuOpOrderDlg::OnBnClickedFoaccinfoBtn()
{
	int		nPrevNext = 0;

	CString strACNO;			//¹ȣ
	CString strAC_PWD;			//ºйȣ

	m_CtrlEdAccNoCtl.GetWindowText( strACNO );				// ¹ȣ.- ڸ 11ڸ
	strACNO.Remove('-');
	m_CtrlEdAccPwd.GetWindowText( strAC_PWD );				// ºйȣ
	if(theApp.m_TRCnt > 0)
	{
		for(int i=0; i < theApp.m_TRCnt; i++)
		{	RequestTrFOAccInfo( strACNO, strAC_PWD );	}
	}
	else
	{	RequestTrFOAccInfo( strACNO, strAC_PWD );	}

}

// ɰ  ȸ
int CStockFuOpOrderDlg::RequestTrFOAccInfo(CString strACNO, CString strAC_PWD)
{
	CString strTemp, strTrCode = RQ_TRNAME_FUOP_ORDER_DEPOSIT;

	long nRQID = theApp.m_pCommAgent->CreateRequestID();
	if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("ACNO"), strACNO) <= 0 )
	{
		::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "¹ȣ Է ", MB_OK|MB_TOPMOST);
		return 0;
	}
	if (theApp.m_pCommAgent->SetTranInputData(nRQID, strTrCode, _T("InRec1"), _T("AC_PWD"), strAC_PWD) <= 0 )
	{
		::MessageBox(GetSafeHwnd(), theApp.m_pCommAgent->GetLastErrMsg(), "º Է ", MB_OK|MB_TOPMOST);
		return 0;
	}

	//	ſû
	if ( theApp.m_pCommAgent->RequestTran(nRQID, strTrCode, _T(""), 20) <= 0 )
	{
		CString strLastErrMsg = theApp.m_pCommAgent->GetLastErrMsg();
		::MessageBox(GetSafeHwnd(), strLastErrMsg, "ֽ Ź  û ", MB_OK|MB_TOPMOST);
		return 0;
	}

	return 0;
}

void CStockFuOpOrderDlg::ReceiveTrFOCheKyeol(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strValue, strTemp;
	int nDataCnt = 0;
	char szTemp[128] = {0x00};
	long lTemp;
	int nItem;
	int nListRowCnt = m_CtrlListOutStdOrd.GetItemCount();

	if ( nDataLength > 0 )
	{	// Data OK
		//Ű

		typedef struct _FUOP_CHEKEYOL_OUTREC1
		{
			char		ORD_Q_1[19];			/*  [ֹ_1]     */
			char		CLSN_Q_1[19];			/*  [ü_1]     */
			char		ORD_Q_2[19];			/*  [ֹ_2]     */
			char		CLSN_Q_2[19];			/*  [ü_2]     */
			char		CLSN_A[19];				/*  [üݾ]     */
			char		RECNM[19];				/*  [ڵ]     */
		}FUOP_CHEKEYOL_OUTREC1;

		typedef struct _FUOP_CHEKEYOL_OUTREC2
		{
			char		ORD_DT[8];				/*  [ֹ]     */
			char		ACMT_BR_COD[3];			/*  [°ڵ]     */
			char		ACNO[11];				/*  [¹ȣ]     */
			char		ORD_NO[11];				/*  [ֹȣ]     */
			char		OORD_NO[11];			/*  [ֹȣ]     */
			char		ITEM_COD[12];			/*  [ڵ]     */
			char		ITEM_NM[50];			/*  []     */
			char		BUY_SEL_TR_TCD[2];		/*  [żŵŷڵ]     */
			char		TP_NM[50];				/*  [и]     */
			char		ORD_Q[19];				/*  [ֹ]     */
			char		ORD_UPR[17];			/*  [ֹܰ]     */
			char		CLSN_Q[19];				/*  [ü]     */
			char		CLSN_UPR[17];			/*  [üܰ]     */
			char		ORD_RQ[19];				/*  [ֹܷ]     */
			char		MDFY_CNCL_Q[19];		/*  [Ҽ]     */
			char		TCLSN_A[19];			/*  [üݾ]     */
			char		NMPR_ORD_BNS_TCD[3];	/*  [ȣֹŸűڵ]     */
			char		FUOP_ORD_STAT_TCD[3];	/*  [ɼֹ±ڵ]     */
			char		ORD_TMD[6];				/*  [ֹð]     */
			char		BNS_CLSN_TMD[6];		/*  [Ÿüð]     */
			char		ORD_COND_TCD[1];		/*  [ֹǱڵ]     */
			char		RJT_Q[19];				/*  [źμ]     */
			char		RESP_MSG_CN[100];		/*  [޽]     */
			char		ORD_MDA_TCD[3];			/*  [ֹüڵ]     */
			char		CLSN_NO[12];			/*  [üȣ]     */
		}FUOP_CHEKEYOL_OUTREC2;

		FUOP_CHEKEYOL_OUTREC1* pOutRec1 = (FUOP_CHEKEYOL_OUTREC1*)sData;
		FUOP_CHEKEYOL_OUTREC2* pOutRec2 = (FUOP_CHEKEYOL_OUTREC2*)(sData + sizeof(FUOP_CHEKEYOL_OUTREC1));
		memcpy(szTemp, pOutRec1->RECNM, sizeof(pOutRec1->RECNM));
		nDataCnt = _ttoi(szTemp);

		if(nDataCnt > 0)
		{
			//ֹü Ÿ .
			for (int i = 0; i < nDataCnt; i++)
			{
				//	ֹü ڵ 
				strTemp = CString(pOutRec2[i].ORD_NO, _countof(pOutRec2[i].ORD_NO));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				nItem = m_CtrlListOutStdOrd.InsertItem( LVIF_TEXT, i + nListRowCnt, strTemp, 0, 0, 0, NULL );		// ֹȣ

				//	ŵ/ż ̿ а ڵ忡 ߰ ʴ´. 
				strTemp = CString(pOutRec2[i].TP_NM, _countof(pOutRec2[i].TP_NM));
				m_CtrlListOutStdOrd.SetItemText(nItem, 1, strTemp.Trim());		// ŵż + ұ ex) "ŵ"

				lTemp = _tstol(CString(pOutRec2[i].NMPR_ORD_BNS_TCD, _countof(pOutRec2[i].NMPR_ORD_BNS_TCD)));
				if (lTemp == 20) 
					strTemp = _T("尡");
				else if (lTemp == 30)
					strTemp = _T("Ǻ");
				else if (lTemp == 40)
					strTemp = _T("");
				else if (lTemp == 50)
					strTemp = _T("ֿ켱");
				else
					strTemp = _T("");
				m_CtrlListOutStdOrd.SetItemText(nItem, 2, strTemp.Trim());					// ֹ


				strTemp = CString(pOutRec2[i].ITEM_NM, _countof(pOutRec2[i].ITEM_NM));
				m_CtrlListOutStdOrd.SetItemText(nItem, 3, strTemp.Trim());					// 

				strTemp = CString(pOutRec2[i].ORD_UPR, _countof(pOutRec2[i].ORD_UPR));
				strTemp.Format("%0.2f", _tstof(strTemp));
				m_CtrlListOutStdOrd.SetItemText(nItem, 4, theApp.SetComma(strTemp));		// ֹ

				strTemp = CString(pOutRec2[i].ORD_Q, _countof(pOutRec2[i].ORD_Q));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListOutStdOrd.SetItemText(nItem, 5, theApp.SetComma(strTemp));		// ֹ

				strTemp = CString(pOutRec2[i].ORD_RQ, _countof(pOutRec2[i].ORD_RQ));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListOutStdOrd.SetItemText(nItem, 6, theApp.SetComma(strTemp));		// ü

				strTemp = CString(pOutRec2[i].OORD_NO, _countof(pOutRec2[i].OORD_NO));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListOutStdOrd.SetItemText(nItem, 7, strTemp.Trim());		// ֹȣ

				lTemp = _tstol(CString(pOutRec2[i].FUOP_ORD_STAT_TCD, _countof(pOutRec2[i].FUOP_ORD_STAT_TCD)));
				if (lTemp == 10) 
					strTemp = _T("Ϸ");
				else if (lTemp == 20)
					strTemp = _T("ҿϷ");
				else if (lTemp == 30)
					strTemp = _T("Ұ");
				else if (lTemp == 40)
					strTemp = _T("ҺҰ");
				else
					strTemp = _T("Ϲ");
				m_CtrlListOutStdOrd.SetItemText(nItem, 8, strTemp.Trim());		// ֹ

				strValue = CString(pOutRec2[i].ORD_TMD, _countof(pOutRec2[i].ORD_TMD));
				strTemp.Format("%s:%s:%s", strValue.Left(2),strValue.Mid(2,2),strValue.Mid(4,2));
				m_CtrlListOutStdOrd.SetItemText(nItem, 9, strTemp.Trim());		// ֹð

				strTemp = CString(pOutRec2[i].ITEM_COD, _countof(pOutRec2[i].ITEM_COD));
				m_CtrlListOutStdOrd.SetItemText(nItem, 10, strTemp.Trim());		// ڵ

			}

			//	ȸ
			CString strNextKey = sPreNext;
			if(strNextKey != _T("") )
			{
				int		nPrevNext = 1;
				CString strORD_DT;				//ֹ
				CString strACNO;				//¹ȣ
				CString strAC_PWD;				//ºйȣ
				CString strSORT_TURN_IO1CD;		//ļIO1ڵ
				CString strCLSN_TP_IO1CD;		//üᱸIO1ڵ
				CString strBUY_SEL_TR_TCD;		//żŵŷڵ
				CString strITEM_TP_IO1CD;		//񱸺IO1ڵ
				CString strITEM_COD;			//ڵ

				m_CtrlEdAccNoCtl.GetWindowText( strACNO );				// ¹ȣ.- ڸ 11ڸ
				strACNO.Remove('-');
				m_CtrlEdAccPwd.GetWindowText( strAC_PWD );				// ºйȣ
				strORD_DT = _T("");
				strSORT_TURN_IO1CD = _T("2");							// "1" :  "2" : ,	ֹȣ  / ȸ
				strCLSN_TP_IO1CD = _T("%");								// "%":ü, "1":ü, "2":ü
				strBUY_SEL_TR_TCD = _T("%");							// "% " : ü "10" : ŵ "20" : ż
				strITEM_TP_IO1CD = _T("%");								// "%":ü, "1":, "2":Call, "3":Put, "4":
				strITEM_COD = _T("");									// ڵ. ȸ ڵ. NULL̸ ü ֹ . Է½ Ưڵ ֹ  

				if ( RequestTrFOCheKyeol( strACNO, strAC_PWD, strSORT_TURN_IO1CD, strCLSN_TP_IO1CD, strBUY_SEL_TR_TCD, strITEM_TP_IO1CD, strITEM_COD, strNextKey ) > 0 )
					return;
				else
					TRACE("ֽ ֹü  ȸ \n");
			}
		}
	}
	else
	{	// Error
		AfxMessageBox(sMessage);
	}
}

void CStockFuOpOrderDlg::ReceiveTrFOJango(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	CString strValue, strTemp, strAmt, strPyung;
	int nDataCnt = 0;
	char szTemp[128] = {0x00};
	long lTemp;
	double dTemp;
	int nItem;

	if ( nDataLength > 0 )
	{	// Data OK
		//Ű

		typedef struct _FUOP_JANGO_OUTREC1
		{
			char		FUOP_DPS_CSH[19];		/*  [ɼǿŹ]     */
			char		AC_TDA[19];				/*  [ѿ]     */
			char		FU_EXCC_DIA[19];		/*  []     */
			char		OP_SEL_A[19];			/*  [ɼǸŵݾ]     */
			char		OP_BUY_A[19];			/*  [ɼǸżݾ]     */
			char		FUOP_CMSN[17];			/*  [ɼǼ]     */
			char		ORD_ABLE_TOA[19];		/*  [ֹѱݾ]     */
			char		ORD_ABLE_CSH[19];		/*  [ֹ]     */
			char		WTHD_ABLE_CSH[19];		/*  [Ⱑ]     */
			char		FUOP_EV_PL_A[19];		/*  [ɼ򰡼ͱݾ]     */
			char		ESTI_DPAST_EA[19];		/*  [Źڻ򰡱ݾ]     */
			char		RECNM[19];				/*  [ڵ]     */
		}FUOP_JANGO_OUTREC1;

		typedef struct _FUOP_JANGO_OUTREC2
		{
			char		ITEM_COD[12];			/*  [ڵ]     */
			char		ITEM_NM[50];			/*  []     */
			char		BUY_SEL_TP_NM[50];		/*  [żŵи]     */
			char		FUOP_USCTR_Q[19];		/*  [ɼǹ̰]     */
			char		LQDT_ABLE_Q[19];		/*  [û갡ɼ]     */
			char		USCTR_UPR[17];			/*  [̰ܰ]     */
			char		FUOP_CRPR[17];			/*  [ɼ簡]     */
			char		PL_A[19];				/*  [ͱݾ]     */
			char		PCHS_A[19];				/*  [Աݾ]     */
			char		FUOP_EA[19];			/*  [ɼ򰡱ݾ]     */
			char		BUY_SEL_TR_TCD[2];		/*  [żŵŷڵ]     */


		}FUOP_JANGO_OUTREC2;

		FUOP_JANGO_OUTREC1* pOutRec1 = (FUOP_JANGO_OUTREC1*)sData;
		FUOP_JANGO_OUTREC2* pOutRec2 = (FUOP_JANGO_OUTREC2*)(sData + sizeof(FUOP_JANGO_OUTREC1));
		memcpy(szTemp, pOutRec1->RECNM, sizeof(pOutRec1->RECNM));
		nDataCnt = _ttoi(szTemp);

		if(nDataCnt > 0)
		{
			//ֹü Ÿ .
			for (int i = 0; i < nDataCnt; i++)
			{
				//	ֹü ڵ 
				strTemp = CString(pOutRec2[i].ITEM_COD, _countof(pOutRec2[i].ITEM_COD));
				nItem = m_CtrlListStock.InsertItem( LVIF_TEXT, i, strTemp, 0, 0, 0, NULL );		// ڵ

				strTemp = CString(pOutRec2[i].ITEM_NM, _countof(pOutRec2[i].ITEM_NM));
				m_CtrlListStock.SetItemText(nItem, 1, strTemp.Trim());								// 

				strTemp = CString(pOutRec2[i].BUY_SEL_TP_NM, _countof(pOutRec2[i].BUY_SEL_TP_NM));
				m_CtrlListStock.SetItemText(nItem, 2, strTemp.Trim());								// ܰ

				strTemp = CString(pOutRec2[i].FUOP_USCTR_Q, _countof(pOutRec2[i].FUOP_USCTR_Q));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListStock.SetItemText(nItem, 3, strTemp.Trim());					// 

				strTemp = CString(pOutRec2[i].LQDT_ABLE_Q, _countof(pOutRec2[i].LQDT_ABLE_Q));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListStock.SetItemText(nItem, 4, theApp.SetComma(strTemp));		// ŵ

				strTemp = CString(pOutRec2[i].USCTR_UPR, _countof(pOutRec2[i].USCTR_UPR));
				dTemp = _tstof(strTemp);
				strTemp.Format("%0.2f", dTemp);
				m_CtrlListStock.SetItemText(nItem, 5, theApp.SetComma(strTemp));		// ̰ܰ

				strTemp = CString(pOutRec2[i].FUOP_CRPR, _countof(pOutRec2[i].FUOP_CRPR));
				dTemp = _tstof(strTemp);
				strTemp.Format("%0.2f", dTemp);
				m_CtrlListStock.SetItemText(nItem, 6, theApp.SetComma(strTemp));		// ɼ簡				

				strTemp = CString(pOutRec2[i].PL_A, _countof(pOutRec2[i].PL_A));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListStock.SetItemText(nItem, 7, theApp.SetComma(strTemp));		// 򰡼
				strPyung = strTemp;

				strTemp = CString(pOutRec2[i].FUOP_EA, _countof(pOutRec2[i].FUOP_EA));
				lTemp = _tstol(strTemp);
				strTemp.Format("%ld", lTemp);
				m_CtrlListStock.SetItemText(nItem, 9, theApp.SetComma(strTemp));		// 򰡱ݾ
				strAmt = strTemp;

				//			( 򰡼 * 100 / Աݾ )
				strTemp.Format("%0.2f", _tstof(strPyung) * 100 / _tstof(strAmt));
				m_CtrlListStock.SetItemText(nItem, 8, strTemp.Trim());					// 

				m_CtrlListStock.SetItemText(nItem, 10, _T(""));		// 
				
			}

			//	ȸ
			CString strNextKey = sPreNext;
			if(strNextKey != _T("") )
			{
				int		nPrevNext = 1;
				CString strACNO;			//¹ȣ
				CString strAC_PWD;			//ºйȣ

				m_CtrlEdAccNoCtl.GetWindowText( strACNO );				// ¹ȣ.- ڸ 11ڸ
				strACNO.Remove('-');
				m_CtrlEdAccPwd.GetWindowText( strAC_PWD );				// ºйȣ

				if ( RequestTrFOJango( strACNO, strAC_PWD, strNextKey ) > 0 )
					return;
				else
					TRACE("ֽ ܰ  ȸ \n");
			}
		}
	}
	else
	{	// Error
		AfxMessageBox(sMessage);
	}
}

void CStockFuOpOrderDlg::ReceiveTrFOAccInfo(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage)
{
	if ( nDataLength > 0 )
	{	// Data OK
		CString strAC_TDA, strCSGN_MA, strTemp;
		strAC_TDA = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUOP_ORDER_DEPOSIT, _T("OutRec1"), _T("AC_TDA"), 0);			//ѿ
		strAC_TDA.Trim();

		strCSGN_MA= theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_FUOP_ORDER_DEPOSIT, _T("OutRec1"), _T("CSGN_MA"), 0);			//Źű
		strCSGN_MA.Trim();

		strTemp.Format("[] = (%s), Źű(%s)", theApp.SetComma(strAC_TDA), theApp.SetComma(strCSGN_MA));

		AfxMessageBox(strTemp);
	}
	else
	{	// Error
		AfxMessageBox(sMessage);
	}
}

// ֹ 
void CStockFuOpOrderDlg::ReceiveTrSendOrder(long nRqId, LPCTSTR sData, long nDataLength, LPCTSTR sPreNext, LPCTSTR sErrorCode, LPCTSTR sMessage, int nType)
{
	if ( nDataLength > 0 )
	{	// Data Receive OK
		CString strMsg = _T(""), strOrderNo, strReceiveMsg = sMessage;
		strOrderNo = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_BS_ORDER, _T("OutRec1"), _T("ORD_NO"), 0);			//ֹȣ
		strOrderNo.Trim();

		// ֹȣ 0̸ . ڵ üũص 
		if ( _ttol(strOrderNo) == 0 || _ttol(sErrorCode) > 0 )
		{
			AfxMessageBox(sMessage);
			return;
		}

		//	ɼ ֹ 񽺿 ޽  ֱ⶧  ƴ ͺ ޽ ǥش.
		if(nType == 3 || nType == 4)
		{
			strReceiveMsg = theApp.m_pCommAgent->GetTranOutputData(RQ_TRNAME_STOCK_BS_ORDER, _T("OutRec1"), _T("RESP_MSG_CN"), 0);	//޽
			strReceiveMsg.Trim();
		}

		strMsg = strReceiveMsg + "\r\n" + _T("[ֹȣ] ") + strOrderNo;
		m_edOutput.SetWindowText(strMsg);
		m_CtrlEdOrdNo.SetWindowText(strOrderNo);
	}
	else
	{	// Error
		AfxMessageBox(sMessage);
	}
}

//*******************************************************************/
/*! Function Name : SetRealCode
/*! Function      : ֹ/ü  
/*! Param         : int nType (1:ֽ, 2:/)
/*! Return        : void
/*! Comment       : 
//******************************************************************/
void CStockFuOpOrderDlg::SetRealCode(int nType, CString strUserId)
{
	if (strUserId.GetLength() == 0)
		return;

	if ( !theApp.m_pCommAgent || theApp.m_pCommAgent->GetSafeHwnd() == NULL )
	{
		AfxMessageBox(" Ǿ  ʽϴ.  ¸ Ȯ Ͻʽÿ. \r\n");
		return;
	}
	
	if(nType == 1)				// ֽ ֹü  
	{
		
		// (ǽð) Ÿ ûѴ.
		theApp.m_pCommAgent->RegisterReal(191, (LPCTSTR)strUserId );		//ü
		theApp.m_pCommAgent->RegisterReal(192, (LPCTSTR)strUserId );		//ܰ
	}
	else if (nType == 2)		// / ֹü  
	{
		// (ǽð) Ÿ ûѴ.
		theApp.m_pCommAgent->RegisterReal(193, (LPCTSTR)strUserId );		//ü
		theApp.m_pCommAgent->RegisterReal(194, (LPCTSTR)strUserId );		//ܰ
	}
}



//*******************************************************************/
/*! Function Name : UnSetRealCode
/*! Function      : ֹ/ü  
/*! Param         : int nType (1:ֽ, 2:/)
/*! Return        : void
/*! Comment       : 
//******************************************************************/
void CStockFuOpOrderDlg::UnSetRealCode(int nType, CString strUserId)
{
	if (strUserId.GetLength() == 0)
		return;

	if ( !theApp.m_pCommAgent || theApp.m_pCommAgent->GetSafeHwnd() == NULL )
	{
		AfxMessageBox(" Ǿ  ʽϴ.  ¸ Ȯ Ͻʽÿ. \r\n");
		return;
	}

	if(nType == 1)				// ֽ ֹü  
	{
		// (ǽð) Ÿ Ѵ.
		theApp.m_pCommAgent->UnRegisterReal(191, (LPCTSTR)strUserId );		//ü
		theApp.m_pCommAgent->UnRegisterReal(192, (LPCTSTR)strUserId );		//ܰ
	}
	else if (nType == 2)		// / ֹü  
	{
		// (ǽð) Ÿ Ѵ.
		theApp.m_pCommAgent->UnRegisterReal(193, (LPCTSTR)strUserId );		//ü
		theApp.m_pCommAgent->UnRegisterReal(194, (LPCTSTR)strUserId );		//ܰ
	}
}

