# -*- coding: utf-8 -*-

# Form implementation generated from reading ui file 'eumain.ui'
#
# Created by: PyQt5 UI code generator 5.15.9
#
# WARNING: Any manual changes made to this file will be lost when pyuic5 is
# run again.  Do not edit this file unless you know what you are doing.


from PyQt5 import QtCore, QtGui, QtWidgets
from PyQt5.QtCore import QThread, pyqtSignal, QCoreApplication, QTime
from eugene import EugeneVersion
from eugene_manager import EugeneManager
import sys
from PyQt5.QtWidgets import QButtonGroup, QTableWidgetItem, QMessageBox
from pprint import pprint
import threading
from datetime import datetime
import logging


class Ui_mainWindow(object):
    
    def __init__(self):
        self.user_id = ""
        self.user_pw = ""
        self.cert_pw = ""
        self.real_gubun = False
        self.rqId = 0
        self.login_state = 0
        self.em = EugeneManager(self.user_id, self.user_pw, self.cert_pw)

    def setupUi(self, mainWindow):
        mainWindow.setObjectName("mainWindow")
        mainWindow.resize(1119, 506)
        self.centralwidget = QtWidgets.QWidget(mainWindow)
        self.centralwidget.setObjectName("centralwidget")
        self.loginBtn = QtWidgets.QPushButton(self.centralwidget)
        self.loginBtn.setGeometry(QtCore.QRect(20, 70, 171, 23))
        self.loginBtn.setObjectName("loginBtn")
        self.closeBtn = QtWidgets.QPushButton(self.centralwidget)
        self.closeBtn.setGeometry(QtCore.QRect(200, 70, 75, 23))
        self.closeBtn.setObjectName("closeBtn")
        self.getAccBtn = QtWidgets.QPushButton(self.centralwidget)
        self.getAccBtn.setGeometry(QtCore.QRect(282, 70, 101, 23))
        self.getAccBtn.setObjectName("getAccBtn")
        self.label = QtWidgets.QLabel(self.centralwidget)
        self.label.setGeometry(QtCore.QRect(20, 40, 61, 16))
        self.label.setObjectName("label")
        self.userID = QtWidgets.QLineEdit(self.centralwidget)
        self.userID.setGeometry(QtCore.QRect(73, 38, 81, 20))
        self.userID.setText("")
        self.userID.setObjectName("userID")
        self.userPW = QtWidgets.QLineEdit(self.centralwidget)
        self.userPW.setGeometry(QtCore.QRect(191, 38, 81, 20))
        self.userPW.setEchoMode(QtWidgets.QLineEdit.Password)
        self.userPW.setObjectName("userPW")
        self.label_2 = QtWidgets.QLabel(self.centralwidget)
        self.label_2.setGeometry(QtCore.QRect(163, 40, 31, 16))
        self.label_2.setAlignment(QtCore.Qt.AlignCenter)
        self.label_2.setObjectName("label_2")
        self.label_3 = QtWidgets.QLabel(self.centralwidget)
        self.label_3.setGeometry(QtCore.QRect(284, 40, 41, 16))
        self.label_3.setObjectName("label_3")
        self.certPW = QtWidgets.QLineEdit(self.centralwidget)
        self.certPW.setGeometry(QtCore.QRect(321, 38, 81, 20))
        self.certPW.setEchoMode(QtWidgets.QLineEdit.Password)
        self.certPW.setObjectName("certPW")
        self.loginstate = QtWidgets.QLabel(self.centralwidget)
        self.loginstate.setGeometry(QtCore.QRect(20, 100, 81, 16))
        self.loginstate.setObjectName("loginstate")
        self.label_6 = QtWidgets.QLabel(self.centralwidget)
        self.label_6.setGeometry(QtCore.QRect(19, 12, 40, 16))
        font = QtGui.QFont()
        font.setFamily("Agency FB")
        font.setBold(True)
        font.setWeight(75)
        self.label_6.setFont(font)
        self.label_6.setObjectName("label_6")
        self.frame = QtWidgets.QFrame(self.centralwidget)
        self.frame.setGeometry(QtCore.QRect(10, 8, 561, 113))
        self.frame.setAccessibleDescription("")
        self.frame.setFrameShape(QtWidgets.QFrame.StyledPanel)
        self.frame.setFrameShadow(QtWidgets.QFrame.Raised)
        self.frame.setObjectName("frame")
        self.frame_2 = QtWidgets.QFrame(self.centralwidget)
        self.frame_2.setGeometry(QtCore.QRect(9, 128, 561, 151))
        self.frame_2.setFrameShape(QtWidgets.QFrame.StyledPanel)
        self.frame_2.setFrameShadow(QtWidgets.QFrame.Raised)
        self.frame_2.setObjectName("frame_2")
        self.kstk = QtWidgets.QRadioButton(self.frame_2)
        self.kstk.setGeometry(QtCore.QRect(72, 4, 70, 16))
        self.kstk.setObjectName("kstk")
        self.kfuopt = QtWidgets.QRadioButton(self.frame_2)
        self.kfuopt.setGeometry(QtCore.QRect(145, 4, 80, 16))
        self.kfuopt.setObjectName("kfuopt")
        self.kSise = QtWidgets.QTableWidget(self.frame_2)
        self.kSise.setEnabled(True)
        self.kSise.setGeometry(QtCore.QRect(10, 30, 521, 31))                   
        self.kSise.setMinimumSize(QtCore.QSize(0, 31))
        self.kSise.setVerticalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
        self.kSise.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
        self.kSise.setAutoScroll(False)
        self.kSise.setAutoScrollMargin(16)
        self.kSise.setEditTriggers(QtWidgets.QAbstractItemView.NoEditTriggers)
        self.kSise.setDragDropOverwriteMode(True)
        self.kSise.setRowCount(1)
        self.kSise.setColumnCount(6)                                            
        self.kSise.setObjectName("kSise")
        self.kSise.horizontalHeader().setVisible(False)
        self.kSise.horizontalHeader().setDefaultSectionSize(100)
        self.kSise.horizontalHeader().setHighlightSections(True)
        self.kSise.horizontalHeader().setMinimumSectionSize(34)
        self.kSise.verticalHeader().setVisible(False)
        self.kSise.verticalHeader().setDefaultSectionSize(25)
        self.kSise.verticalHeader().setHighlightSections(True)
        self.kSise.verticalHeader().setMinimumSectionSize(25)
        self.label_4 = QtWidgets.QLabel(self.frame_2)
        self.label_4.setGeometry(QtCore.QRect(320, 4, 51, 16))
        self.label_4.setObjectName("label_4")
        self.lineEdit = QtWidgets.QLineEdit(self.frame_2)
        self.lineEdit.setGeometry(QtCore.QRect(372, 2, 113, 20))
        self.lineEdit.setObjectName("lineEdit")
        self.ksearch = QtWidgets.QPushButton(self.frame_2)
        self.ksearch.setGeometry(QtCore.QRect(490, 1, 41, 23))
        self.ksearch.setObjectName("ksearch")
        self.label_7 = QtWidgets.QLabel(self.frame_2)
        self.label_7.setGeometry(QtCore.QRect(9, 0, 56, 20))
        font = QtGui.QFont()
        font.setFamily("Agency FB")
        font.setBold(True)
        font.setWeight(75)
        self.label_7.setFont(font)
        self.label_7.setFrameShadow(QtWidgets.QFrame.Plain)
        self.label_7.setScaledContents(False)
        self.label_7.setObjectName("label_7")
        self.userAccNo = QtWidgets.QLineEdit(self.frame_2)
        self.userAccNo.setGeometry(QtCore.QRect(61, 68, 110, 20))
        self.userAccNo.setObjectName("userAccNo")
        self.label_5 = QtWidgets.QLabel(self.frame_2)
        self.label_5.setGeometry(QtCore.QRect(9, 72, 56, 12))
        self.label_5.setObjectName("label_5")
        self.label_9 = QtWidgets.QLabel(self.frame_2)
        self.label_9.setGeometry(QtCore.QRect(179, 72, 30, 16))
        self.label_9.setObjectName("label_9")
        self.kuserPw = QtWidgets.QLineEdit(self.frame_2)
        self.kuserPw.setGeometry(QtCore.QRect(207, 68, 60, 20))
        self.kuserPw.setObjectName("kuserPw")
        self.kuserPw.setEchoMode(QtWidgets.QLineEdit.Password)
        self.label_10 = QtWidgets.QLabel(self.frame_2)
        self.label_10.setGeometry(QtCore.QRect(275, 72, 30, 12))
        self.label_10.setObjectName("label_10")
        self.kAmount = QtWidgets.QLineEdit(self.frame_2)
        self.kAmount.setGeometry(QtCore.QRect(303, 68, 80, 20))
        self.kAmount.setObjectName("kAmount")
        self.label_11 = QtWidgets.QLabel(self.frame_2)
        self.label_11.setGeometry(QtCore.QRect(390, 72, 30, 12))
        self.label_11.setObjectName("label_11")
        self.kPrice = QtWidgets.QLineEdit(self.frame_2)
        self.kPrice.setGeometry(QtCore.QRect(420, 68, 113, 20))
        self.kPrice.setObjectName("kPrice")
        self.label_12 = QtWidgets.QLabel(self.frame_2)
        self.label_12.setGeometry(QtCore.QRect(10, 100, 30, 12))
        self.label_12.setObjectName("label_12")
        self.kOrdNo = QtWidgets.QLineEdit(self.frame_2)
        self.kOrdNo.setGeometry(QtCore.QRect(39, 96, 70, 20))
        self.kOrdNo.setObjectName("kOrdNo")
        self.label_13 = QtWidgets.QLabel(self.frame_2)
        self.label_13.setGeometry(QtCore.QRect(120, 100, 30, 12))
        self.label_13.setObjectName("label_13")
        self.kOrgOrdNo = QtWidgets.QLineEdit(self.frame_2)
        self.kOrgOrdNo.setGeometry(QtCore.QRect(149, 96, 70, 20))
        self.kOrgOrdNo.setObjectName("kOrgOrdNo")
        self.label_14 = QtWidgets.QLabel(self.frame_2)
        self.label_14.setGeometry(QtCore.QRect(240, 100, 30, 12))
        self.label_14.setObjectName("label_14")
        self.kOrdType = QtWidgets.QComboBox(self.frame_2)
        self.kOrdType.setGeometry(QtCore.QRect(270, 96, 100, 22))
        self.kOrdType.setObjectName("kOrdType")
        self.kOrdType.addItem("")
        self.kOrdType.addItem("")
        self.kOrdType.addItem("")
        self.kOrdType.addItem("")
        self.kOrdType.addItem("")
        self.kOrdType.addItem("")
        self.kOrdType.addItem("")
        self.kOrdType.addItem("")
        self.kOrdType.addItem("")
        self.kOrdType.addItem("")
        self.kOrdType.addItem("")
        self.kOrdType.addItem("")
        self.kOrdType.addItem("")
        self.kOrdType.addItem("")
        self.kMedo = QtWidgets.QPushButton(self.frame_2)
        self.kMedo.setGeometry(QtCore.QRect(10, 122, 75, 23))
        self.kMedo.setObjectName("kMedo")
        self.kMesu = QtWidgets.QPushButton(self.frame_2)
        self.kMesu.setGeometry(QtCore.QRect(100, 122, 75, 23))
        self.kMesu.setObjectName("kMesu")
        self.kJungJung = QtWidgets.QPushButton(self.frame_2)
        self.kJungJung.setGeometry(QtCore.QRect(190, 122, 75, 23))
        self.kJungJung.setObjectName("kJungJung")
        self.kCancel = QtWidgets.QPushButton(self.frame_2)
        self.kCancel.setGeometry(QtCore.QRect(280, 122, 75, 23))
        self.kCancel.setObjectName("kCancel")
        self.foType = QtWidgets.QComboBox(self.frame_2)
        self.foType.setEnabled(False)
        self.foType.setGeometry(QtCore.QRect(220, 2, 90, 22))
        self.foType.setObjectName("foType")
        self.foType.addItem("")
        self.foType.addItem("")
        self.foType.addItem("")
        self.foType.addItem("")
        self.foType.addItem("")
        self.kAccBtn = QtWidgets.QPushButton(self.frame_2)
        self.kAccBtn.setGeometry(QtCore.QRect(370, 122, 75, 23))
        self.kAccBtn.setObjectName("kAccBtn")
        self.label_8 = QtWidgets.QLabel(self.centralwidget)
        self.label_8.setGeometry(QtCore.QRect(18, 302, 56, 20))
        font = QtGui.QFont()
        font.setFamily("Agency FB")
        font.setBold(True)
        font.setWeight(75)
        self.label_8.setFont(font)
        self.label_8.setObjectName("label_8")
        self.frame_3 = QtWidgets.QFrame(self.centralwidget)
        self.frame_3.setGeometry(QtCore.QRect(10, 302, 561, 151))
        self.frame_3.setFrameShape(QtWidgets.QFrame.StyledPanel)
        self.frame_3.setFrameShadow(QtWidgets.QFrame.Raised)
        self.frame_3.setObjectName("frame_3")
        self.ovstkSise = QtWidgets.QTableWidget(self.frame_3)
        self.ovstkSise.setEnabled(True)
        self.ovstkSise.setGeometry(QtCore.QRect(10, 30, 521, 31))                  
        self.ovstkSise.setMinimumSize(QtCore.QSize(0, 31))
        self.ovstkSise.setVerticalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
        self.ovstkSise.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
        self.ovstkSise.setAutoScroll(False)
        self.ovstkSise.setAutoScrollMargin(16)
        self.ovstkSise.setEditTriggers(QtWidgets.QAbstractItemView.NoEditTriggers)
        self.ovstkSise.setDragDropOverwriteMode(True)
        self.ovstkSise.setRowCount(1)
        self.ovstkSise.setColumnCount(6)                                            
        self.ovstkSise.setObjectName("ovstkSise")
        self.ovstkSise.horizontalHeader().setVisible(False)
        self.ovstkSise.horizontalHeader().setDefaultSectionSize(100)
        self.ovstkSise.horizontalHeader().setHighlightSections(True)
        self.ovstkSise.horizontalHeader().setMinimumSectionSize(34)
        self.ovstkSise.verticalHeader().setVisible(False)
        self.ovstkSise.verticalHeader().setDefaultSectionSize(25)
        self.ovstkSise.verticalHeader().setHighlightSections(True)
        self.ovstkSise.verticalHeader().setMinimumSectionSize(25)
        self.ovsPrice = QtWidgets.QLineEdit(self.frame_3)
        self.ovsPrice.setGeometry(QtCore.QRect(420, 70, 113, 20))
        self.ovsPrice.setObjectName("ovsPrice")
        self.label_15 = QtWidgets.QLabel(self.frame_3)
        self.label_15.setGeometry(QtCore.QRect(179, 74, 30, 16))
        self.label_15.setObjectName("label_15")
        self.ovsUserPw = QtWidgets.QLineEdit(self.frame_3)
        self.ovsUserPw.setGeometry(QtCore.QRect(207, 70, 60, 20))
        self.ovsUserPw.setObjectName("ovsUserPw")
        self.ovsUserPw.setEchoMode(QtWidgets.QLineEdit.Password)
        self.label_16 = QtWidgets.QLabel(self.frame_3)
        self.label_16.setGeometry(QtCore.QRect(390, 74, 30, 12))
        self.label_16.setObjectName("label_16")
        self.ovsAmount = QtWidgets.QLineEdit(self.frame_3)
        self.ovsAmount.setGeometry(QtCore.QRect(303, 70, 80, 20))
        self.ovsAmount.setObjectName("ovsAmount")
        self.label_17 = QtWidgets.QLabel(self.frame_3)
        self.label_17.setGeometry(QtCore.QRect(9, 74, 56, 12))
        self.label_17.setObjectName("label_17")
        self.label_18 = QtWidgets.QLabel(self.frame_3)
        self.label_18.setGeometry(QtCore.QRect(275, 74, 30, 12))
        self.label_18.setObjectName("label_18")
        self.ovsUserAccNo = QtWidgets.QLineEdit(self.frame_3)
        self.ovsUserAccNo.setGeometry(QtCore.QRect(61, 70, 110, 20))
        self.ovsUserAccNo.setObjectName("ovsUserAccNo")
        self.ovsOrdType = QtWidgets.QComboBox(self.frame_3)
        self.ovsOrdType.setGeometry(QtCore.QRect(270, 96, 100, 22))
        self.ovsOrdType.setObjectName("ovsOrdType")
        self.ovsOrdType.addItem("")
        self.ovsOrdType.addItem("")
        self.ovsOrdType.addItem("")
        self.ovsOrdType.addItem("")
        self.ovsOrdType.addItem("")
        self.ovsOrdType.addItem("")
        self.ovsOrdType.addItem("")
        self.ovsOrdType.addItem("")
        self.label_19 = QtWidgets.QLabel(self.frame_3)
        self.label_19.setGeometry(QtCore.QRect(240, 100, 30, 12))
        self.label_19.setObjectName("label_19")
        self.label_20 = QtWidgets.QLabel(self.frame_3)
        self.label_20.setGeometry(QtCore.QRect(10, 100, 30, 12))
        self.label_20.setObjectName("label_20")
        self.label_21 = QtWidgets.QLabel(self.frame_3)
        self.label_21.setGeometry(QtCore.QRect(120, 100, 30, 12))
        self.label_21.setObjectName("label_21")
        self.ovsMesu = QtWidgets.QPushButton(self.frame_3)
        self.ovsMesu.setGeometry(QtCore.QRect(100, 122, 75, 23))
        self.ovsMesu.setObjectName("ovsMesu")
        self.ovsJungJung = QtWidgets.QPushButton(self.frame_3)
        self.ovsJungJung.setGeometry(QtCore.QRect(190, 122, 75, 23))
        self.ovsJungJung.setObjectName("ovsJungJung")
        self.ovsCancel = QtWidgets.QPushButton(self.frame_3)
        self.ovsCancel.setGeometry(QtCore.QRect(280, 122, 75, 23))
        self.ovsCancel.setObjectName("ovsCancel")
        self.ovsOrdNo = QtWidgets.QLineEdit(self.frame_3)
        self.ovsOrdNo.setGeometry(QtCore.QRect(39, 96, 70, 20))
        self.ovsOrdNo.setObjectName("ovsOrdNo")
        self.ovsMedo = QtWidgets.QPushButton(self.frame_3)
        self.ovsMedo.setGeometry(QtCore.QRect(10, 122, 75, 23))
        self.ovsMedo.setObjectName("ovsMedo")
        self.ovsOrgOrdNo = QtWidgets.QLineEdit(self.frame_3)
        self.ovsOrgOrdNo.setGeometry(QtCore.QRect(149, 96, 70, 20))
        self.ovsOrgOrdNo.setObjectName("ovsOrgOrdNo")
        self.lineEdit_2 = QtWidgets.QLineEdit(self.frame_3)
        self.lineEdit_2.setGeometry(QtCore.QRect(372, 2, 113, 20))
        self.lineEdit_2.setObjectName("lineEdit_2")
        self.ksearch_2 = QtWidgets.QPushButton(self.frame_3)
        self.ksearch_2.setGeometry(QtCore.QRect(490, 1, 41, 23))
        self.ksearch_2.setObjectName("ksearch_2")
        self.label_22 = QtWidgets.QLabel(self.frame_3)
        self.label_22.setGeometry(QtCore.QRect(320, 4, 51, 16))
        self.label_22.setObjectName("label_22")
        self.ovsAccBtn = QtWidgets.QPushButton(self.frame_3)
        self.ovsAccBtn.setGeometry(QtCore.QRect(370, 122, 75, 23))
        self.ovsAccBtn.setObjectName("ovsAccBtn")
        self.notice = QtWidgets.QPushButton(self.frame_3)
        self.notice.setGeometry(QtCore.QRect(289, 2, 23, 23))
        self.notice.setObjectName("notice")
        self.exp_code_check = QtWidgets.QPushButton(self.frame_3)
        self.exp_code_check.setGeometry(QtCore.QRect(180, 2, 101, 23))
        self.exp_code_check.setObjectName("exp_code_check")
        self.label_23 = QtWidgets.QLabel(self.centralwidget)
        self.label_23 = QtWidgets.QLabel(self.centralwidget)
        self.label_23.setGeometry(QtCore.QRect(580, 6, 150, 16))
        font = QtGui.QFont()
        font.setFamily("Agency FB")
        font.setBold(True)
        font.setWeight(75)
        self.label_23.setFont(font)
        self.label_23.setObjectName("label_23")
        self.chejan = QtWidgets.QTableWidget(self.centralwidget)
        self.chejan.setGeometry(QtCore.QRect(580, 51, 531, 192))
        self.chejan.setGridStyle(QtCore.Qt.SolidLine)
        self.chejan.setRowCount(0)
        self.chejan.setColumnCount(11)
        self.chejan.setObjectName("chejan")
        item = QtWidgets.QTableWidgetItem()
        self.chejan.setHorizontalHeaderItem(0, item)
        item = QtWidgets.QTableWidgetItem()
        self.chejan.setHorizontalHeaderItem(1, item)
        item = QtWidgets.QTableWidgetItem()
        self.chejan.setHorizontalHeaderItem(2, item)
        item = QtWidgets.QTableWidgetItem()
        self.chejan.setHorizontalHeaderItem(3, item)
        item = QtWidgets.QTableWidgetItem()
        self.chejan.setHorizontalHeaderItem(4, item)
        item = QtWidgets.QTableWidgetItem()
        self.chejan.setHorizontalHeaderItem(5, item)
        item = QtWidgets.QTableWidgetItem()
        self.chejan.setHorizontalHeaderItem(6, item)
        item = QtWidgets.QTableWidgetItem()
        self.chejan.setHorizontalHeaderItem(7, item)
        item = QtWidgets.QTableWidgetItem()
        self.chejan.setHorizontalHeaderItem(8, item)
        item = QtWidgets.QTableWidgetItem()
        self.chejan.setHorizontalHeaderItem(9, item)
        item = QtWidgets.QTableWidgetItem()
        self.chejan.setHorizontalHeaderItem(10, item)
        self.chejan.horizontalHeader().setCascadingSectionResizes(False)
        self.chejan.horizontalHeader().setSortIndicatorShown(False)
        self.chejan.verticalHeader().setSortIndicatorShown(False)
        self.chejan.verticalHeader().setStretchLastSection(False)
        self.label_24 = QtWidgets.QLabel(self.centralwidget)
        self.label_24.setGeometry(QtCore.QRect(580, 31, 111, 16))
        font = QtGui.QFont()
        font.setFamily("Agency FB")
        font.setBold(True)
        font.setWeight(75)
        self.label_24.setFont(font)
        self.label_24.setObjectName("label_24")
        self.label_25 = QtWidgets.QLabel(self.centralwidget)
        self.label_25.setGeometry(QtCore.QRect(580, 251, 81, 16))
        font = QtGui.QFont()
        font.setFamily("Agency FB")
        font.setBold(True)
        font.setWeight(75)
        self.label_25.setFont(font)
        self.label_25.setObjectName("label_25")
        self.siljan = QtWidgets.QTableWidget(self.centralwidget)
        self.siljan.setGeometry(QtCore.QRect(580, 270, 531, 192))
        self.siljan.setColumnCount(11)
        self.siljan.setObjectName("siljan")
        self.siljan.setRowCount(0)
        item = QtWidgets.QTableWidgetItem()
        self.siljan.setHorizontalHeaderItem(0, item)
        item = QtWidgets.QTableWidgetItem()
        self.siljan.setHorizontalHeaderItem(1, item)
        item = QtWidgets.QTableWidgetItem()
        self.siljan.setHorizontalHeaderItem(2, item)
        item = QtWidgets.QTableWidgetItem()
        self.siljan.setHorizontalHeaderItem(3, item)
        item = QtWidgets.QTableWidgetItem()
        self.siljan.setHorizontalHeaderItem(4, item)
        item = QtWidgets.QTableWidgetItem()
        self.siljan.setHorizontalHeaderItem(5, item)
        item = QtWidgets.QTableWidgetItem()
        self.siljan.setHorizontalHeaderItem(6, item)
        item = QtWidgets.QTableWidgetItem()
        self.siljan.setHorizontalHeaderItem(7, item)
        item = QtWidgets.QTableWidgetItem()
        self.siljan.setHorizontalHeaderItem(8, item)
        item = QtWidgets.QTableWidgetItem()
        self.siljan.setHorizontalHeaderItem(9, item)
        item = QtWidgets.QTableWidgetItem()
        self.siljan.setHorizontalHeaderItem(10, item)
        self.frame.raise_()
        self.frame_3.raise_()
        self.frame_2.raise_()
        self.loginBtn.raise_()
        self.closeBtn.raise_()
        self.getAccBtn.raise_()
        self.label.raise_()
        self.userID.raise_()
        self.userPW.raise_()
        self.label_2.raise_()
        self.label_3.raise_()
        self.certPW.raise_()
        self.loginstate.raise_()
        self.label_6.raise_()
        self.label_8.raise_()
        self.label_23.raise_()
        self.chejan.raise_()
        self.label_24.raise_()
        self.label_25.raise_()
        self.siljan.raise_()
        mainWindow.setCentralWidget(self.centralwidget)
        self.menubar = QtWidgets.QMenuBar(mainWindow)
        self.menubar.setGeometry(QtCore.QRect(0, 0, 582, 21))
        self.menubar.setObjectName("menubar")
        mainWindow.setMenuBar(self.menubar)
        self.statusbar = QtWidgets.QStatusBar(mainWindow)
        self.statusbar.setObjectName("statusbar")
        mainWindow.setStatusBar(self.statusbar)
        if self.kstk.isChecked():
            self.lineEdit.setMaxLength(6)
        elif self.kfuopt.isChecked():
            self.lineEdit.setMaxLength(8)

        # 국내주식, 선물옵션 라디오박스 체크(한개만 선택 되도록)
        self.kstk.setChecked(True)
        self.button_group = QButtonGroup()
        self.button_group.setExclusive(True)
        self.button_group.addButton(self.kstk)
        self.button_group.addButton(self.kfuopt)

        # 테이블 너비 설정
        self.kSise.setColumnWidth(0, 120)
        self.kSise.setColumnWidth(1, 85)
        self.kSise.setColumnWidth(2, 25)
        self.kSise.setColumnWidth(3, 70)
        self.kSise.setColumnWidth(4, 100)
        self.kSise.setColumnWidth(5, 121)

        self.ovstkSise.setColumnWidth(0, 120)
        self.ovstkSise.setColumnWidth(1, 85)
        self.ovstkSise.setColumnWidth(2, 25)
        self.ovstkSise.setColumnWidth(3, 70)
        self.ovstkSise.setColumnWidth(4, 100)
        self.ovstkSise.setColumnWidth(5, 121)

        self.retranslateUi(mainWindow)
        QtCore.QMetaObject.connectSlotsByName(mainWindow)

    def retranslateUi(self, mainWindow):
        _translate = QtCore.QCoreApplication.translate
        mainWindow.setWindowTitle(_translate("mainWindow", "유진투자증권 OPENAPI"))
        self.loginBtn.setText(_translate("mainWindow", "로그인 (버전처리 후 로그인)"))
        self.closeBtn.setText(_translate("mainWindow", "닫기"))
        self.getAccBtn.setText(_translate("mainWindow", "계좌 확인하기"))
        self.label.setText(_translate("mainWindow", "사용자 ID"))
        self.label_2.setText(_translate("mainWindow", "비번"))
        self.label_3.setText(_translate("mainWindow", "인증서"))
        self.loginstate.setText(_translate("mainWindow", "로그인 상태값"))
        self.label_6.setText(_translate("mainWindow", "로그인"))
        self.kstk.setText(_translate("mainWindow", "국내주식"))
        self.kfuopt.setText(_translate("mainWindow", "선물/옵션"))
        self.label_4.setText(_translate("mainWindow", "종목코드"))
        self.ksearch.setText(_translate("mainWindow", "조회"))
        self.label_7.setText(_translate("mainWindow", "국내상품"))
        self.label_5.setText(_translate("mainWindow", "계좌번호"))
        self.label_9.setText(_translate("mainWindow", "비번"))
        self.label_10.setText(_translate("mainWindow", "수량"))
        self.label_11.setText(_translate("mainWindow", "가격"))
        self.label_12.setText(_translate("mainWindow", "주번"))
        self.label_13.setText(_translate("mainWindow", "원번"))
        self.label_14.setText(_translate("mainWindow", "유형"))
        self.kOrdType.setItemText(0, _translate("mainWindow", "지정가"))
        self.kOrdType.setItemText(1, _translate("mainWindow", "시장가"))
        self.kOrdType.setItemText(2, _translate("mainWindow", "조건부지정가"))
        self.kOrdType.setItemText(3, _translate("mainWindow", "최유리지정가"))
        self.kOrdType.setItemText(4, _translate("mainWindow", "최우선지정가"))
        self.kOrdType.setItemText(5, _translate("mainWindow", "장전시간외"))
        self.kOrdType.setItemText(6, _translate("mainWindow", "장후시간외"))
        self.kOrdType.setItemText(7, _translate("mainWindow", "시간외단일가"))
        self.kOrdType.setItemText(8, _translate("mainWindow", "지정가(IOC)"))
        self.kOrdType.setItemText(9, _translate("mainWindow", "시장가(IOC)"))
        self.kOrdType.setItemText(10, _translate("mainWindow", "최유리(IOC)"))
        self.kOrdType.setItemText(11, _translate("mainWindow", "지정가(FOK)"))
        self.kOrdType.setItemText(12, _translate("mainWindow", "시장가(FOK)"))
        self.kOrdType.setItemText(13, _translate("mainWindow", "최유리(FOK)"))
        self.kMedo.setText(_translate("mainWindow", "매도"))
        self.kMesu.setText(_translate("mainWindow", "매수"))
        self.kJungJung.setText(_translate("mainWindow", "정정"))
        self.kCancel.setText(_translate("mainWindow", "취소"))
        self.foType.setItemText(0, _translate("mainWindow", "지수선물"))
        self.foType.setItemText(1, _translate("mainWindow", "지수옵션"))
        self.foType.setItemText(2, _translate("mainWindow", "주식선물"))
        self.foType.setItemText(3, _translate("mainWindow", "주식옵션"))
        self.foType.setItemText(4, _translate("mainWindow", "변동성/섹터"))
        self.kAccBtn.setText(_translate("mainWindow", "잔고조회"))
        self.label_8.setText(_translate("mainWindow", "해외주식"))
        self.label_15.setText(_translate("mainWindow", "비번"))
        self.label_16.setText(_translate("mainWindow", "가격"))
        self.label_17.setText(_translate("mainWindow", "계좌번호"))
        self.label_18.setText(_translate("mainWindow", "수량"))
        self.ovsOrdType.setItemText(0, _translate("mainWindow", "지정가"))
        self.ovsOrdType.setItemText(1, _translate("mainWindow", "시장가"))
        self.ovsOrdType.setItemText(2, _translate("mainWindow", "MOO"))
        self.ovsOrdType.setItemText(3, _translate("mainWindow", "MOC"))
        self.ovsOrdType.setItemText(4, _translate("mainWindow", "LOO"))
        self.ovsOrdType.setItemText(5, _translate("mainWindow", "LOC"))
        self.ovsOrdType.setItemText(6, _translate("mainWindow", "TWAP"))
        self.ovsOrdType.setItemText(7, _translate("mainWindow", "VWAP"))
        self.label_19.setText(_translate("mainWindow", "유형"))
        self.label_20.setText(_translate("mainWindow", "주번"))
        self.label_21.setText(_translate("mainWindow", "원번"))
        self.ovsMesu.setText(_translate("mainWindow", "매수"))
        self.ovsJungJung.setText(_translate("mainWindow", "정정"))
        self.ovsCancel.setText(_translate("mainWindow", "취소"))
        self.ovsMedo.setText(_translate("mainWindow", "매도"))
        self.ksearch_2.setText(_translate("mainWindow", "조회"))
        self.label_22.setText(_translate("mainWindow", "종목코드"))
        self.ovsAccBtn.setText(_translate("mainWindow", "잔고조회"))
        self.notice.setText(_translate("mainWindow", "?"))
        self.exp_code_check.setText(_translate("mainWindow", "거래소코드 확인"))
        self.label_23.setText(_translate("mainWindow", "잔고"))
        item = self.chejan.horizontalHeaderItem(0)
        item.setText(_translate("mainWindow", "주문번호"))
        item = self.chejan.horizontalHeaderItem(1)
        item.setText(_translate("mainWindow", "매매구분"))
        item = self.chejan.horizontalHeaderItem(2)
        item.setText(_translate("mainWindow", "주문유형"))
        item = self.chejan.horizontalHeaderItem(3)
        item.setText(_translate("mainWindow", "종목명"))
        item = self.chejan.horizontalHeaderItem(4)
        item.setText(_translate("mainWindow", "주문가격"))
        item = self.chejan.horizontalHeaderItem(5)
        item.setText(_translate("mainWindow", "주문수량"))
        item = self.chejan.horizontalHeaderItem(6)
        item.setText(_translate("mainWindow", "미체결"))
        item = self.chejan.horizontalHeaderItem(7)
        item.setText(_translate("mainWindow", "원주문번호"))
        item = self.chejan.horizontalHeaderItem(8)
        item.setText(_translate("mainWindow", "상태"))
        item = self.chejan.horizontalHeaderItem(9)
        item.setText(_translate("mainWindow", "주문시간"))
        item = self.chejan.horizontalHeaderItem(10)
        item.setText(_translate("mainWindow", "종목코드"))
        self.label_24.setText(_translate("mainWindow", "주문체결(내역)"))
        self.label_25.setText(_translate("mainWindow", "잔고"))
        item = self.siljan.horizontalHeaderItem(0)
        item.setText(_translate("mainWindow", "종목코드"))
        item = self.siljan.horizontalHeaderItem(1)
        item.setText(_translate("mainWindow", "종목명"))
        item = self.siljan.horizontalHeaderItem(2)
        item.setText(_translate("mainWindow", "구분"))
        item = self.siljan.horizontalHeaderItem(3)
        item.setText(_translate("mainWindow", "보유수량"))
        item = self.siljan.horizontalHeaderItem(4)
        item.setText(_translate("mainWindow", "매도가능"))
        item = self.siljan.horizontalHeaderItem(5)
        item.setText(_translate("mainWindow", "매입단가"))
        item = self.siljan.horizontalHeaderItem(6)
        item.setText(_translate("mainWindow", "현재가"))
        item = self.siljan.horizontalHeaderItem(7)
        item.setText(_translate("mainWindow", "평가손익"))
        item = self.siljan.horizontalHeaderItem(8)
        item.setText(_translate("mainWindow", "수익률"))
        item = self.siljan.horizontalHeaderItem(9)
        item.setText(_translate("mainWindow", "평가금액"))
        item = self.siljan.horizontalHeaderItem(10)
        item.setText(_translate("mainWindow", "제비용"))
        
        self.kfuopt.toggled.connect(self.enable_foType)
        
        self.loginBtn.clicked.connect(self.login)
        self.closeBtn.clicked.connect(self.close)
        self.getAccBtn.clicked.connect(self.getAcc)
        self.ksearch.clicked.connect(self.getKorSise)
        self.ksearch_2.clicked.connect(self.getOvsSise)
        
        self.kMesu.clicked.connect(self.bidOrder)
        self.kMedo.clicked.connect(self.sidOrder)
        self.kJungJung.clicked.connect(self.jidOrder)
        self.kCancel.clicked.connect(self.cidOrder)

        self.ovsMesu.clicked.connect(self.ovsBiOrder)
        self.ovsMedo.clicked.connect(self.ovsSidOrder)
        self.kAccBtn.clicked.connect(self.getKJango)
        self.ovsJungJung.clicked.connect(self.ovsJidOrder)
        self.ovsCancel.clicked.connect(self.ovsCidOrder)
        self.ovsAccBtn.clicked.connect(self.getOvsJango)
        self.exp_code_check.clicked.connect(self.expCodeCheck)
        self.notice.clicked.connect(self.ovsNotification)
        
    def enable_foType(self):
        if self.kfuopt.isChecked():
            self.foType.setEnabled(True)
        else:
            self.foType.setEnabled(False)
            
################ 공통함수 ################            
    # 주문시, 비밀번호 체크        
    def checkPw(self, input):
        if self.userPW != input:
            msg = QMessageBox()
            msg.setText('처리되지않았습니다') 
            msg.setWindowTitle('오류')
            msg.setIcon(QMessageBox.Information) 

            msg.exec_()
            return 
        else:
            pass
        
    def errPopup(self):
        msg = QMessageBox()
        msg.setText('잘못된 조회입니다.') 
        msg.setWindowTitle('오류')
        msg.setIcon(QMessageBox.Information) 

        msg.exec_()
        
    def validOrdPopup(self, ordNum):
        if ordNum:
            msg = QMessageBox()
            msg.setText('정상처리되었습니다.') 
            msg.setWindowTitle('주문')
            msg.setIcon(QMessageBox.Information) 

            msg.exec_()
        else:
            msg = QMessageBox()
            msg.setText('주문오류입니다.') 
            msg.setWindowTitle('주문')
            msg.setIcon(QMessageBox.Information) 

            msg.exec_()
        
    def validAccPopup(self, accNo, accPw):
        self.em.put_method(("getAccInfo", ""))
        accInfo = self.em.get_method()

        if(len(accNo) != 11 or len(accPw) != 4):
            msg = QMessageBox()
            msg.setText('사용자 정보를 올바르게 입력했는지 확인하세요.') 
            msg.setWindowTitle('오류')
            msg.setIcon(QMessageBox.Information) 

            msg.exec_()
            
            return 0
        
        elif self.certPW == "":
            msg = QMessageBox()
            msg.setText('인증서 로그인이 필요합니다.') 
            msg.setWindowTitle('오류')
            msg.setIcon(QMessageBox.Information) 

            msg.exec_()
            
            return 0
        
        elif accNo not in accInfo:
            msg = QMessageBox()
            msg.setText('계좌 정보가 없습니다.') 
            msg.setWindowTitle('오류')
            msg.setIcon(QMessageBox.Information) 

            msg.exec_()
            
            return 0
        
        else:    
            tr_cmd = {
                'rqId': self.rqId,
                'trCode': 'OAC0424Q',
                'input': {
                    "ACNO": accNo,
                    "AC_PWD" : accPw
                },
                'output': {
                    'OutRec1': ['AC_NM']
                }
            }

            self.em.put_tr(tr_cmd)
            data = self.em.get_tr()
        
            if(len(data['OutRec1']['AC_NM']) <= 0):
                msg = QMessageBox()
                msg.setText('계좌 정보가 없습니다.') 
                msg.setWindowTitle('오류')
                msg.setIcon(QMessageBox.Information) 

                msg.exec_()
                return 0
            else:
                return 1
################ 공통함수 ################            
            
################ 로그인 ################   
    def getError(self):
        while True:
            self.em.put_method(("getLastErrMsg", ""))
            data = self.em.get_method()
            if data:
                print("[Error] ", data)
                sys.exit(0)
                     
    # 로그인
    def login(self):
        t = threading.Thread(target=self.getError, daemon=True)
        t.start()
        self.user_id = self.userID.text()
        self.user_pw = self.userPW.text()
        self.cert_pw = self.certPW.text()

        eugeneVersion = EugeneVersion()
        eugeneVersion.show()
        wparam, lparam = eugeneVersion.get_version()
        eugeneVersion.close()
        
        self.em.put_method(("login", wparam, lparam, self.user_id, self.user_pw, self.cert_pw))
        self.em.get_method()

        self.em.put_method(("getRqId", ""))
        self.rqId = self.em.get_method()
        
        if(self.userID.text() == "" or self.userPW.text() == ""):
            self.login_state = 0
        else:
            self.em.put_method(("getLoginState", ""))
            self.login_state = self.em.get_method()        
          
        if(self.login_state == 1):
            self.loginstate.setText("로그인 성공")
        else:
            self.loginstate.setText("로그인 실패")
    
    # 닫기
    def close(self): 
        self.em.put_method(("releaseRqId", self.rqId))
        self.em.get_method()
        self.em.put_method(("logout", self.user_id))
        self.em.get_method()
        self.em.put_method(("commTerminate", True))
        self.em.get_method()
        QCoreApplication.quit()
        sys.exit()
               
            
    # 계좌번호확인
    def getAcc(self):
        t = threading.Thread(target=self.getError, daemon=True)
        t.start()
        if(self.login_state != 1):
            msg = QMessageBox()
            msg.setText('로그인이 필요합니다.') 
            msg.setWindowTitle('오류')
            msg.setIcon(QMessageBox.Information) 

            msg.exec_()
            return
        else:
            self.em.put_method(("getAccInfo", ""))
            accNo = self.em.get_method().replace(";", " ")
            strText = '계좌번호 : ' + accNo
            msg = QMessageBox()
            msg.setText(strText) 
            msg.setWindowTitle('계좌조회')
            msg.setIcon(QMessageBox.Information) 

            msg.exec_()

################ 로그인 ################  

################ 시세 ################
    # Threading 방식으로 Real 데이터 수신 위함
    def getKRealSise(self, realId, realKey):
        t = threading.Thread(target=self.getError, daemon=True)
        t.start()
        self.real_gubun = True
        
        real_cmd = {
            'realId': realId,
            'realKey': realKey,
            'output': ["LDIFF", "CPCHECK", "LCPRICE", "LVOLUME", "LDIFFRATE"]
        }
        
        self.em.put_real(real_cmd)
        while self.real_gubun:
            real_data = self.em.get_real()
            pprint(real_data)
                      
    # Threading 방식으로 Real 데이터 수신 위함
    def foRealSise(self, mgubun, realKey):
        t = threading.Thread(target=self.getError, daemon=True)
        t.start()
        # 지수선물
        if (mgubun == 0):
            fo_real_cmd = {
                'realId': '65',
                'realKey': realKey,
                'output': ["LDIFF", "CPCHECK", "LCPRICE", "LVOLUME", "LDIFFRATE"]
            }
                
        # 지수옵션
        elif (mgubun == 1):
            fo_real_cmd = {
                'realId': '66',
                'realKey': realKey,
                'output': ["LDIFF", "CPCHECK", "LCPRICE", "LVOLUME", "LDIFFRATE"]
            }
        
        # 주식선물
        elif (mgubun == 2):
            fo_real_cmd = {
                'realId': '71',
                'realKey': realKey,
                'output': ["LDIFF", "CPCHECK", "LCPRICE", "LVOLUME", "LDIFFRATE"]
            }
            
        # 주식옵션
        elif (mgubun == 3):
            fo_real_cmd = {
                'realId': '72',
                'realKey': realKey,
                'output': ["LDIFF", "CPCHECK", "LCPRICE", "LVOLUME", "LDIFFRATE"]
            }
            
        # 지수변동성/섹터 선물
        elif (mgubun == 4):
            fo_real_cmd = {
                'realId': '76',
                'realKey': realKey,
                'output': ["LDIFF", "CPCHECK", "LCPRICE", "LVOLUME", "LDIFFRATE"]
            }
            
        self.em.put_real(fo_real_cmd)
        while True:
            real_data = self.em.get_real()
            pprint(real_data)
        
    
    # 국내상품 시세조회
    def getKorSise(self):
        if(self.login_state != 1):
            return
        
        t = threading.Thread(target=self.getError, daemon=True)
        t.start()
        self.real_gubun = False
        # Real 해제
        self.em.put_method(("allUnRegisterReal", ""))
        self.em.get_method()
        
        
        # 국내주식 조회
        if self.kstk.isChecked():
            self.em.put_method(("getNameByCode", str(self.lineEdit.text())))

            sName = self.em.get_method()
            if(len(sName) <= 0):
                self.errPopup()
                return
            else:
                pass
            
            tr_cmd = {
                'rqId': self.rqId,
                'trCode': 'stmst2',
                'input': {
                    "sCode": self.lineEdit.text()
                },
                'output': {
                    'OutRec1': ['lCPrice', 'cPCheck', 'lDiff', 'oprice_drate', 'lVolume']
                }
            }

            self.em.put_tr(tr_cmd)
            data = self.em.get_tr()
            
            try:
                oprice_drate = str(float(data['OutRec1']['oprice_drate']) / 100) + "%"
            except ValueError:
                oprice_drate = 0 
            
            self.kSise.setItem(0, 0, QTableWidgetItem(sName))
            self.kSise.setItem(0, 1, QTableWidgetItem('{:,}'.format(int(data['OutRec1']['lCPrice']))))
            self.kSise.setItem(0, 2, QTableWidgetItem(data['OutRec1']['cPCheck']))
            self.kSise.setItem(0, 3, QTableWidgetItem('{:,}'.format(int(data['OutRec1']['lDiff']))))
            self.kSise.setItem(0, 4, QTableWidgetItem((oprice_drate)))
            self.kSise.setItem(0, 5, QTableWidgetItem('{:,}'.format(int(data['OutRec1']['lVolume']))))

            if ((data['OutRec1']['cPCheck'] == '1') or (data['OutRec1']['cPCheck'] == '2')):
                self.kSise.item(0, 2).setText("▲")
            elif ((data['OutRec1']['cPCheck'] == '4') or (data['OutRec1']['cPCheck'] == '5')):
                self.kSise.item(0, 2).setText("▼")
            elif (data['OutRec1']['cPCheck'] == '3'):
                self.kSise.item(0, 2).setText("")

            real_id = '21'
            real_key = self.lineEdit.text()
 
            t1 = threading.Thread(target=self.getKRealSise, args=(real_id, real_key), daemon=True)
            t1.start()      

        # 선물옵션 조회
        if self.kfuopt.isChecked():
            # 지수선물
            if (self.foType.currentIndex() == 0):
                tr_cmd = {
                    'rqId': self.rqId,
                    'trCode': 'ffcur',
                    'input': {
                        "sCode": self.lineEdit.text().upper()
                    },
                    'output': {
                        'OutRec1': ['SHNAME', 'LCPRICE', 'CPCHECK', 'LDIFF', 'LDIFFRATE', 'LVOLUME']
                    }
                }
            
            # 지수옵션
            elif (self.foType.currentIndex() == 1):
                tr_cmd = {
                    'rqId': self.rqId,
                    'trCode': 'ogibon',
                    'input': {
                        "sCode": self.lineEdit.text().upper()
                    },
                    'output': {
                        'OutRec1': ['SHNAME', 'LCPRICE', 'CPCHECK', 'LDIFF', 'LDIFFRATE', 'LVOLUME']
                    }
                }
            
            # 주식선물
            elif (self.foType.currentIndex() == 2):
                tr_cmd = {
                    'rqId': self.rqId,
                    'trCode': 'sfcur',
                    'input': {
                        "sCode": self.lineEdit.text().upper()
                    },
                    'output': {
                        'OutRec1': ['SHNAME', 'LCPRICE', 'CPCHECK', 'LDIFF', 'LDIFFRATE', 'LVOLUME']
                    }
                }
            
            # 주식옵션
            elif (self.foType.currentIndex() == 3):
                tr_cmd = {
                    'rqId': self.rqId,
                    'trCode': 'sogibon',
                    'input': {
                        "sCode": self.lineEdit.text().upper()
                    },
                    'output': {
                        'OutRec1': ['SHNAME', 'LCPRICE', 'CPCHECK', 'LDIFF', 'LDIFFRATE', 'LVOLUME']
                    }
                }
            
            #변동성/섹터
            elif (self.foType.currentIndex() == 4):
                tr_cmd = {
                    'rqId': self.rqId,
                    'trCode': 'vtcur',
                    'input': {
                        "sCode": self.lineEdit.text().upper()
                    },
                    'output': {
                        'OutRec1': ['SHNAME', 'LCPRICE', 'CPCHECK', 'LDIFF', 'LDIFFRATE', 'LVOLUME']
                    }
                }
            
            self.em.put_tr(tr_cmd)
            data = self.em.get_tr()
            
            if len(data['OutRec1']['SHNAME']) <= 0:
                self.errPopup()
                return
            else:
                pass
            
            if self.foType.currentIndex() == 0 or self.foType.currentIndex() == 1:
                lcprice = str(float(data['OutRec1']['LCPRICE']) / 100)
                ldiff = str(float(data['OutRec1']['LDIFF']) / 100)
            elif self.foType.currentIndex() == 2 or self.foType.currentIndex() == 3 or self.foType.currentIndex() == 4:
                lcprice = data['OutRec1']['LCPRICE']
                ldiff = data['OutRec1']['LDIFF']
                
            LDIFFRATE = str(int(data['OutRec1']['LDIFFRATE']) / 100) + "%"
            self.kSise.setItem(0, 0, QTableWidgetItem(data['OutRec1']['SHNAME']))
            self.kSise.setItem(0, 1, QTableWidgetItem(lcprice))
            self.kSise.setItem(0, 2, QTableWidgetItem(data['OutRec1']['CPCHECK']))
            self.kSise.setItem(0, 3, QTableWidgetItem(ldiff))
            self.kSise.setItem(0, 4, QTableWidgetItem((LDIFFRATE)))
            self.kSise.setItem(0, 5, QTableWidgetItem('{:,}'.format(int(data['OutRec1']['LVOLUME']))))
            
            if ((data['OutRec1']['CPCHECK'] == '1') or (data['OutRec1']['CPCHECK'] == '2')):
                self.kSise.item(0, 2).setText("▲")
            elif ((data['OutRec1']['CPCHECK'] == '4') or (data['OutRec1']['CPCHECK'] == '5')):
                self.kSise.item(0, 2).setText("▼")
            elif (data['OutRec1']['CPCHECK'] == '3'):
                self.kSise.item(0, 2).setText("")
            
            real_key = self.lineEdit.text().upper()
            mgubun = self.foType.currentIndex()
            t3 = threading.Thread(target=self.foRealSise, args=(mgubun, real_key), daemon=True)
            t3.start()    
            
    # 해외주식 거래소코드 확인
    def expCodeCheck(self):
        exchange_code = """
        미국 뉴욕 0321 / 미국 아멕스 0066 / 미국 나스닥 0537
        중국 상해 0215 / 중국 심천 0214 / 홍콩 0104
        """
        msg = QMessageBox()
        msg.setText(exchange_code) 
        msg.setWindowTitle('거래소코드 확인')
        msg.setIcon(QMessageBox.Information) 

        msg.exec_()
        
    def ovsNotification(self):
        notification = """
        종목코드에 거래소코드와 종목코드를 같이 입력하세요.
        예) 0537AAPL
        """
        msg = QMessageBox()
        msg.setText(notification) 
        msg.setWindowTitle('알림')
        msg.setIcon(QMessageBox.Information) 

        msg.exec_()

    # Threading 방식으로 Real 데이터 수신 위함
    def ovsRealSise(self, realId, realKey):  
        t = threading.Thread(target=self.getError, daemon=True)
        t.start()      
        real_cmd = {
            'realId': realId,
            'realKey': realKey,
            'output': ["LDIFF", "CPCHECK", "LCPRICE", "LVOLUME", "LDIFFRATE"]
        }
            
        self.em.put_real(real_cmd)
        while True:
            real_data = self.em.get_real()
            pprint(real_data)            
    
    # 해외주식 시세
    def getOvsSise(self):
        if(self.login_state != 1):
            return
        
        t = threading.Thread(target=self.getError, daemon=True)
        t.start()
        # Real 해제
        self.em.put_method(("allUnRegisterReal", ""))
        self.em.get_method()

        tr_cmd = {
            'rqId': self.rqId,
            'trCode': 'gbmst',
            'input': {
                "sCode": self.lineEdit_2.text().upper()
            },
            'output': {
                'OutRec1': ['sKorName', 'cPCheck', 'lDiff', 'lCPrice', 'oprice_drate', 'lVolume']
            }
        }

        self.em.put_tr(tr_cmd)
        data = self.em.get_tr()
        

        if(len(data['OutRec1']['sKorName']) <= 0):
            self.errPopup()
            return
        
        try:
            oprice_drate = str(float(data['OutRec1']['oprice_drate']) / 100) + "%"
        except ValueError:
            oprice_drate = 0 
        #print("해주 등락 : ", oprice_drate)    
        try:
            self.ovstkSise.setItem(0, 1, QTableWidgetItem(format(float(data['OutRec1']['lCPrice'])/10000, ".4f")))
        except ValueError:
            return

        self.ovstkSise.setItem(0, 0, QTableWidgetItem(data['OutRec1']['sKorName']))
        self.ovstkSise.setItem(0, 2, QTableWidgetItem(data['OutRec1']['cPCheck']))
        self.ovstkSise.setItem(0, 3, QTableWidgetItem(format(float(data['OutRec1']['lDiff'])/10000, ".4f")))
        self.ovstkSise.setItem(0, 4, QTableWidgetItem(oprice_drate))
        self.ovstkSise.setItem(0, 5, QTableWidgetItem('{:,}'.format(int(data['OutRec1']['lVolume']))))

        if ((data['OutRec1']['cPCheck'] == '1') or (data['OutRec1']['cPCheck'] == '2')):
            self.ovstkSise.item(0, 2).setText("▲")
        elif ((data['OutRec1']['cPCheck'] == '4') or (data['OutRec1']['cPCheck'] == '5')):
            self.ovstkSise.item(0, 2).setText("▼")
        elif (data['OutRec1']['cPCheck'] == '3'):
            self.ovstkSise.item(0, 2).setText("")

        real_id = '230'
        real_key = self.lineEdit_2.text().upper()
        t2 = threading.Thread(target=self.ovsRealSise, args=(real_id, real_key), daemon=True)
        t2.start()
################ 시세 ################

################ 국내상품 주문 ################
    def getKOrdType(self, idx):
        t = threading.Thread(target=self.getError, daemon=True)
        t.start()
        # 국내주식 주문
        if self.kstk.isChecked():
            if idx == 0:
                return "010", 0
            elif idx == 1:
                return "020", 0
            elif idx == 2:
                return "030", 0
            elif idx == 3:
                return "040", 0
            elif idx == 4:
                return "050", 0
            elif idx == 5:
                return "210", 0
            elif idx == 6:
                return "280", 0
            elif idx == 7:
                return "240", 0
            elif idx == 8:
                return "010", 1
            elif idx == 9:
                return "020", 1
            elif idx == 10:
                return "040", 1
            elif idx == 11:
                return "010", 2
            elif idx == 12:
                return "020", 2
            elif idx == 13:
                return "040", 2
        # 선옵 주문    
        elif self.kfuopt.isChecked():
            if idx == 0:
                return "010", 0
            elif idx == 1:
                return "020", 0
            elif idx == 2:
                return "030", 0
            elif idx == 3:
                return "040", 0
            elif idx == 8:
                return "010", 1
            elif idx == 9:
                return "020", 1
            elif idx == 10:
                return "040", 1
            elif idx == 11:
                return "010", 2
            elif idx == 12:
                return "020", 2
            elif idx == 13:
                return "040", 2

        else:
            msg = QMessageBox()
            msg.setText('잘못된 주문입니다.') 
            msg.setWindowTitle('주문오류')
            msg.setIcon(QMessageBox.Information) 

            msg.exec_()

        
    #매수 주문
    def bidOrder(self):
        t = threading.Thread(target=self.getError, daemon=True)
        t.start()
        
        user_acc = self.userAccNo.text() 
        user_accpw = self.kuserPw.text()
        sCode = self.lineEdit.text().upper()
        sQty = self.kAmount.text()
        
        if self.validAccPopup(user_acc, user_accpw):
            pass
        else:
            return
        
        ret = self.getKOrdType(self.kOrdType.currentIndex())

        if ret is not None:
            BNS, ORD_COND_TCD = ret
        else:
            msg = QMessageBox()
            msg.setText('잘못된 주문입니다') 
            msg.setWindowTitle('주문오류')
            msg.setIcon(QMessageBox.Information) 

            msg.exec_()
            return
        
        if BNS == "020":
            sPrice = ""
        else:
            sPrice = self.kPrice.text()
        
        if self.kstk.isChecked() :
            tr_cmd = {
                'rqId': self.rqId,
                'trCode': 'OTD1101U',
                'input': {
                    "ACNO": user_acc,
                    "AC_PWD": user_accpw,
                    "ITEM_COD": sCode,
                    "ORD_Q": sQty, 
                    "STK_BD_ORD_UPR" : sPrice,
                    "BUY_SEL_TR_TCD" : "20",
                    "ORD_BNS_TCD" : BNS, 
                    "CRDTR_TCD": "010",
                    "LN_DT": "",
                    "ORD_COND_TCD" : str(ORD_COND_TCD)
                },
                'output': {
                    'OutRec1': ['ORD_NO']
                }
            }

            self.em.put_tr(tr_cmd)
            data = self.em.get_tr()
            ord_num = data['OutRec1']['ORD_NO']
            print("매수주문번호 : ", ord_num)
            
            self.validOrdPopup(ord_num)
            
        if self.kfuopt.isChecked():
            if BNS == '010' or BNS == '030':
                sPrice = self.kPrice.text()
            else:
                sPrice = '0'
            
            tr_cmd = {
                'rqId': self.rqId,
                'trCode': 'OFU1101U',
                'input': {
                    "ACNO": user_acc,
                    "AC_PWD": user_accpw,
                    "ITEM_COD": sCode,
                    "ORD_Q": sQty, 
                    "ORD_UPR" : sPrice,
                    "BUY_SEL_TR_TCD" : "20",
                    "ORD_BNS_TCD" : BNS, 
                    "ORD_COND_TCD" : str(ORD_COND_TCD)
                },
                'output': {
                    'OutRec1': ['ORD_NO']
                }
            }
            
            self.em.put_tr(tr_cmd)
            data = self.em.get_tr()
            fuord_num = data['OutRec1']['ORD_NO']
            print("선옵매수주문번호 : ", fuord_num)
            self.validOrdPopup(fuord_num)
            
            
    #매도 주문
    def sidOrder(self):
        t = threading.Thread(target=self.getError, daemon=True)
        t.start()
        user_acc = self.userAccNo.text() 
        user_accpw = self.kuserPw.text()
        sCode = self.lineEdit.text().upper()
        sQty = self.kAmount.text()
        sPrice = self.kPrice.text()
        if self.validAccPopup(user_acc, user_accpw):
            pass
        else:
            return
        ret = self.getKOrdType(self.kOrdType.currentIndex())
        if ret is not None:
            BNS, ORD_COND_TCD = ret
        else:
            msg = QMessageBox()
            msg.setText('잘못된 주문입니다') 
            msg.setWindowTitle('주문오류')
            msg.setIcon(QMessageBox.Information) 

            msg.exec_()
        
        if self.kstk.isChecked() :
            tr_cmd = {
                'rqId': self.rqId,
                'trCode': 'OTD1101U',
                'input': {
                    "ACNO": user_acc,
                    "AC_PWD": user_accpw,
                    "ITEM_COD": sCode,
                    "ORD_Q": sQty, 
                    "STK_BD_ORD_UPR" : sPrice,
                    "BUY_SEL_TR_TCD" : "10",
                    "ORD_BNS_TCD" : BNS, 
                    "CRDTR_TCD": "010",
                    "LN_DT": "",
                    "ORD_COND_TCD" : str(ORD_COND_TCD)
                },
                'output': {
                    'OutRec1': ['ORD_NO']
                }
            }

            self.em.put_tr(tr_cmd)
            data = self.em.get_tr()
            ord_num = data['OutRec1']['ORD_NO']
            print("매도주문번호 : ", ord_num)
            self.validOrdPopup(ord_num)
            
        if self.kfuopt.isChecked():
            if BNS == '010' or BNS == '030':
                sPrice = self.kPrice.text()
            else:
                sPrice = '0'
            
            tr_cmd = {
                'rqId': self.rqId,
                'trCode': 'OFU1101U',
                'input': {
                    "ACNO": user_acc,
                    "AC_PWD": user_accpw,
                    "ITEM_COD": sCode,
                    "ORD_Q": sQty, 
                    "ORD_UPR" : sPrice,
                    "BUY_SEL_TR_TCD" : "10",
                    "ORD_BNS_TCD" : BNS, 
                    "ORD_COND_TCD" : str(ORD_COND_TCD)
                },
                'output': {
                    'OutRec1': ['ORD_NO']
                }
            }
            
            self.em.put_tr(tr_cmd)
            data = self.em.get_tr()
            fuord_num = data['OutRec1']['ORD_NO']
            print("선옵매도주문번호 : ", fuord_num)
            self.validOrdPopup(fuord_num)
            
    #정정 주문
    def jidOrder(self):
        t = threading.Thread(target=self.getError, daemon=True)
        t.start()
        user_acc = self.userAccNo.text() 
        user_accpw = self.kuserPw.text()
        sCode = self.lineEdit.text().upper()
        sQty = self.kAmount.text()
        sPrice = self.kPrice.text()
        ordNo = self.kOrdNo.text()
        if self.validAccPopup(user_acc, user_accpw):
            pass
        else:
            return
        
        ret = self.getKOrdType(self.kOrdType.currentIndex())
        if ret is not None:
            BNS, ORD_COND_TCD = ret
        else:
            msg = QMessageBox()
            msg.setText('잘못된 주문입니다') 
            msg.setWindowTitle('주문오류')
            msg.setIcon(QMessageBox.Information) 

            msg.exec_()
        
        if self.kstk.isChecked() :
            tr_cmd = {
                'rqId': self.rqId,
                'trCode': 'OTD1102U',
                'input': {
                    "ACNO": user_acc,
                    "AC_PWD": user_accpw,
                    "OORD_NO": ordNo,
                    "ORD_MDFY_CNCL_TCD": "20",
                    "PAT_ALL_TCD": "10",
                    "ITEM_COD": sCode,                    
                    "ORD_Q": sQty, 
                    "STK_BD_ORD_UPR" : sPrice,
                    "ORD_BNS_TCD" : BNS, 
                    "ORD_COND_TCD" : str(ORD_COND_TCD)
                },
                'output': {
                    'OutRec1': ['ORD_NO']
                }
            }

            self.em.put_tr(tr_cmd)
            data = self.em.get_tr()
            ord_num = data['OutRec1']['ORD_NO']
            print("정정주문번호 : ", ord_num)
            self.validOrdPopup(ord_num)
            
        if self.kfuopt.isChecked():
            if BNS == '010' or BNS == '030':
                sPrice = self.kPrice.text()
            else:
                sPrice = '0'
            tr_cmd = {
                'rqId': self.rqId,
                'trCode': 'OFU1102U',
                'input': {
                    "ACNO": user_acc,
                    "AC_PWD": user_accpw,
                    "OORD_NO": ordNo,
                    "ITEM_COD": sCode,
                    "ORD_Q": sQty, 
                    "ORD_UPR" : sPrice,
                    "ORD_MDFY_CNCL_TCD": "20",
                    "BUY_SEL_TR_TCD" : "",
                    "PAT_ALL_TCD": "10",
                    "ORD_BNS_TCD" : BNS, 
                    "ORD_COND_TCD" : str(ORD_COND_TCD)
                },
                'output': {
                    'OutRec1': ['ORD_NO']
                }
            }
            
            self.em.put_tr(tr_cmd)
            data = self.em.get_tr()
            fuord_num = data['OutRec1']['ORD_NO']
            print("선옵정정주문번호 : ", fuord_num)
            self.validOrdPopup(fuord_num)
            
    #취소 주문
    def cidOrder(self):
        t = threading.Thread(target=self.getError, daemon=True)
        t.start()
        user_acc = self.userAccNo.text() 
        user_accpw = self.kuserPw.text()
        sCode = self.lineEdit.text().upper()
        sQty = self.kAmount.text()
        sPrice = self.kPrice.text()
        ordNo = self.kOrdNo.text()
        if self.validAccPopup(user_acc, user_accpw):
            pass
        else:
            return
        ret = self.getKOrdType(self.kOrdType.currentIndex())
        if ret is not None:
            BNS, ORD_COND_TCD = ret
        else:
            msg = QMessageBox()
            msg.setText('잘못된 주문입니다') 
            msg.setWindowTitle('주문오류')
            msg.setIcon(QMessageBox.Information) 

            msg.exec_()
        
        if self.kstk.isChecked() :
            tr_cmd = {
                'rqId': self.rqId,
                'trCode': 'OTD1102U',
                'input': {
                    "ACNO": user_acc,
                    "AC_PWD": user_accpw,
                    "OORD_NO": ordNo,
                    "ORD_MDFY_CNCL_TCD": "30",
                    "PAT_ALL_TCD": "10",
                    "ITEM_COD": sCode,                    
                    "ORD_Q": sQty, 
                    "STK_BD_ORD_UPR" : sPrice,
                    "ORD_BNS_TCD" : BNS, 
                    "ORD_COND_TCD" : str(ORD_COND_TCD)
                },
                'output': {
                    'OutRec1': ['ORD_NO']
                }
            }

            self.em.put_tr(tr_cmd)
            data = self.em.get_tr()
            ord_num = data['OutRec1']['ORD_NO']
            print("취소주문번호 : ", ord_num)
            self.validOrdPopup(ord_num)
            
        if self.kfuopt.isChecked():
            if BNS == '010' or BNS == '030':
                sPrice = self.kPrice.text()
            else:
                sPrice = '0'
            tr_cmd = {
                'rqId': self.rqId,
                'trCode': 'OFU1102U',
                'input': {
                    "ACNO": user_acc,
                    "AC_PWD": user_accpw,
                    "OORD_NO": ordNo,
                    "ITEM_COD": sCode,
                    "ORD_Q": sQty, 
                    "ORD_UPR" : sPrice,
                    "ORD_MDFY_CNCL_TCD": "30",
                    "BUY_SEL_TR_TCD" : "",
                    "PAT_ALL_TCD": "10",
                    "ORD_BNS_TCD" : BNS, 
                    "ORD_COND_TCD" : str(ORD_COND_TCD)
                },
                'output': {
                    'OutRec1': ['ORD_NO']
                }
            }
            
            self.em.put_tr(tr_cmd)
            data = self.em.get_tr()
            fuord_num = data['OutRec1']['ORD_NO']
            print("선옵취소주문번호 : ", fuord_num)
            self.validOrdPopup(fuord_num)


################ 국내상품 주문 ################

################ 해외주식 주문 ################
    # 해외증권매매구분코드
    def getOvsOrdType(self, idx):
        if idx == 0:
            return "010"
        elif idx == 1:
            return "020"
        elif idx == 2:
            return "720"
        elif idx == 3:
            return "740"
        elif idx == 4:
            return "710"
        elif idx == 5:
            return "730"
        elif idx == 6:
            return "750"
        elif idx == 7:
            return "760"
    
    # 매수
    def ovsBiOrder(self):
        t = threading.Thread(target=self.getError, daemon=True)
        t.start()
        if self.validAccPopup(self.ovsUserAccNo.text(), self.ovsUserPw.text()):
            pass
        else:
            return
        self.em.put_method(("getOverseaStockInfo", self.lineEdit_2.text(), 15))
        exg_cod = self.em.get_method()
        FGST_BNS_TCD = self.getOvsOrdType(self.ovsOrdType.currentIndex())

        tr_cmd = {
            'rqId': self.rqId,
            'trCode': 'OTD6101U',
            'input': {
                "ACNO": self.ovsUserAccNo.text(),
                "AC_PWD": self.ovsUserPw.text(),
                "EXG_COD": exg_cod,
                "ITEM_COD": self.lineEdit_2.text()[4:],
                "ORD_Q": self.ovsAmount.text(),
                "FGST_ORD_UPR": self.ovsPrice.text(),
                "BUY_SEL_TR_TCD": "20",
                "FGST_BNS_TCD": FGST_BNS_TCD
            },
            'output': {
                'OutRec1': ['ORD_NO']
            }
        }
        
        self.em.put_tr(tr_cmd)
        data = self.em.get_tr()
        ord_num = data['OutRec1']['ORD_NO']
        
        print("해주매수주문번호 : ", ord_num)
        self.validOrdPopup(ord_num)
        
    # 매도
    def ovsSidOrder(self):
        t = threading.Thread(target=self.getError, daemon=True)
        t.start()
        if self.validAccPopup(self.ovsUserAccNo.text(), self.ovsUserPw.text()):
            pass
        else:
            return
        self.em.put_method(("getOverseaStockInfo", self.lineEdit_2.text(), 15))
        exg_cod = self.em.get_method()
        FGST_BNS_TCD = self.getOvsOrdType(self.ovsOrdType.currentIndex())

        tr_cmd = {
            'rqId': self.rqId,
            'trCode': 'OTD6101U',
            'input': {
                "ACNO": self.ovsUserAccNo.text(),
                "AC_PWD": self.ovsUserPw.text(),
                "EXG_COD": exg_cod,
                "ITEM_COD": self.lineEdit_2.text()[4:],
                "ORD_Q": self.ovsAmount.text(),
                "FGST_ORD_UPR": self.ovsPrice.text(),
                "BUY_SEL_TR_TCD": "10",
                "FGST_BNS_TCD": FGST_BNS_TCD
            },
            'output': {
                'OutRec1': ['ORD_NO']
            }
        }
        
        self.em.put_tr(tr_cmd)
        data = self.em.get_tr()
        ord_num = data['OutRec1']['ORD_NO']
        print("해주매도주문번호 : ", ord_num)
        self.validOrdPopup(ord_num)
        
    #정정 주문
    def ovsJidOrder(self):
        t = threading.Thread(target=self.getError, daemon=True)
        t.start()
        if self.validAccPopup(self.ovsUserAccNo.text(), self.ovsUserPw.text()):
            pass
        else:
            return
        self.em.put_method(("getOverseaStockInfo", self.lineEdit_2.text(), 15))
        exg_cod = self.em.get_method()
        FGST_BNS_TCD = self.getOvsOrdType(self.ovsOrdType.currentIndex())
        tr_cmd = {
            'rqId': self.rqId,
            'trCode': 'OTD6103U',
            'input': {
                "ACNO": self.ovsUserAccNo.text(),
                "AC_PWD": self.ovsUserPw.text(),
                "OORD_NO": self.ovsOrdNo.text(),
                "ORD_MDFY_CNCL_TCD": "20",
                "PAT_ALL_TCD": "20",
                "EXG_COD": exg_cod,
                "ITEM_COD": self.lineEdit_2.text()[4:],
                "FGST_ORD_UPR": self.ovsPrice.text(),
                "FGST_BNS_TCD": FGST_BNS_TCD
            },
            'output': {
                'OutRec1': ['ORD_NO']
            }
        }
        
        self.em.put_tr(tr_cmd)
        data = self.em.get_tr()
        ord_num = data['OutRec1']['ORD_NO']
        print("해주정정주문번호 : ", ord_num)
        self.validOrdPopup(ord_num)
        
    #취소 주문
    def ovsCidOrder(self):
        t = threading.Thread(target=self.getError, daemon=True)
        t.start()
        if self.validAccPopup(self.ovsUserAccNo.text(), self.ovsUserPw.text()):
            pass
        else:
            return
        self.em.put_method(("getOverseaStockInfo", self.lineEdit_2.text(), 15))
        exg_cod = self.em.get_method()
        FGST_BNS_TCD = self.getOvsOrdType(self.ovsOrdType.currentIndex())
        tr_cmd = {
            'rqId': self.rqId,
            'trCode': 'OTD6103U',
            'input': {
                "ACNO": self.ovsUserAccNo.text(),
                "AC_PWD": self.ovsUserPw.text(),
                "OORD_NO": self.ovsOrdNo.text(),
                "ORD_MDFY_CNCL_TCD": "30",
                "PAT_ALL_TCD": "20",
                "EXG_COD": exg_cod,
                "ITEM_COD": self.lineEdit_2.text()[4:],
                "FGST_ORD_UPR": self.ovsPrice.text(),
                "FGST_BNS_TCD": FGST_BNS_TCD
            },
            'output': {
                'OutRec1': ['ORD_NO']
            }
        }
        
        self.em.put_tr(tr_cmd)
        data = self.em.get_tr()
        ord_num = data['OutRec1']['ORD_NO']
        print("해주취소주문번호 : ", ord_num)
        self.validOrdPopup(ord_num)
        
################ 해외주식 주문 ################

################ 잔고 ################
    def getKJango(self):
        t = threading.Thread(target=self.getError, daemon=True)
        t.start()
        
        if(self.validAccPopup(self.userAccNo.text(), self.kuserPw.text())):
            self.kCheJan()
            self.kSilJan()
        else:
            return
                     
    # 체결잔고    
    def kCheJan(self):
        # 국내주식
        if self.kstk.isChecked():
            tr_cmd = {
                'rqId': self.rqId,
                'trCode': 'OTD4105Q',
                'input': {
                    "ACNO": self.userAccNo.text(),
                    "AC_PWD": self.kuserPw.text(),
                    "ORD_NO": "",
                    "BUY_SEL_TR_TCD": "%",
                    "ITEM_COD": "",
                    "SORT_TURN_IO1CD": "2",
                    "SCR_QRY_TCD": "01"
                },
                'output': {
                    'OutRec1': ['LMKT_STK_SEL_A', 'LMKT_STK_BUY_A', 'RECNM', 'AC_NM'],
                    'OutRec2': ["ORD_NO", "ORD_BNS_TCD", "ORD_KCD", "ITEM_ABBR_NM", 
                                "ORD_UPR", "ORD_Q", "ORD_RQ", "OORD_NO", "ORD_SCD", 
                                "ORD_PRC_STAT_TCD", "ORD_DTTM", "ITEM_COD", 
                                "TCLSN_Q", "STL_Q"]
                }
            }
            
            self.em.put_tr(tr_cmd)
            data = self.em.get_tr()
            
            nRow = data['OutRec1']['RECNM']
            try:
                nRow = int(data['OutRec1']['RECNM'])
            except ValueError:
                nRow = 0           
                
            self.chejan.setRowCount(nRow)
            
            for i in range(nRow):
                Unsigned = int(data['OutRec2'][i]['TCLSN_Q']) - int(data['OutRec2'][i]['STL_Q'])
                ord_time = QTime.fromString(data['OutRec2'][i]['ORD_DTTM'], "hhmmss")
                formatted_ord_time = ord_time.toString("hh:mm:ss")
                self.chejan.setItem(i, 0, QTableWidgetItem(data['OutRec2'][i]['ORD_NO']))
                self.chejan.setItem(i, 1, QTableWidgetItem(data['OutRec2'][i]['ORD_BNS_TCD']))
                self.chejan.setItem(i, 2, QTableWidgetItem(data['OutRec2'][i]['ORD_KCD'] + " (문서참고)"))
                self.chejan.setItem(i, 3, QTableWidgetItem(data['OutRec2'][i]['ITEM_ABBR_NM']))
                self.chejan.setItem(i, 4, QTableWidgetItem(data['OutRec2'][i]['ORD_UPR']))
                self.chejan.setItem(i, 5, QTableWidgetItem(data['OutRec2'][i]['ORD_Q']))
                self.chejan.setItem(i, 6, QTableWidgetItem(Unsigned))
                self.chejan.setItem(i, 7, QTableWidgetItem(data['OutRec2'][i]['OORD_NO']))
                self.chejan.setItem(i, 8, QTableWidgetItem(data['OutRec2'][i]['ORD_SCD']))
                self.chejan.setItem(i, 9, QTableWidgetItem(formatted_ord_time))
                self.chejan.setItem(i, 10, QTableWidgetItem(data['OutRec2'][i]['ITEM_COD'].replace("A", "")))
        
        # 선물옵션 체결잔고
        if self.kfuopt.isChecked():
            today = datetime.now().strftime("%Y%m%d")

            tr_cmd = {
                'rqId': self.rqId,
                'trCode': 'OFU4772Q',
                'input': {
                    "ORD_DT": today,
                    "ACNO": self.userAccNo.text(),
                    "AC_PWD": self.kuserPw.text(),
                    "SORT_TURN_IO1CD": "2",
                    "CLSN_TP_IO1CD": "%",
                    "BUY_SEL_TR_TCD": "%",
                    "ITEM_TP_IO1CD": "%",
                    "ITEM_COD": ""
                },
                'output': {
                    'OutRec1': ['RECNM'],
                    'OutRec2': ["ORD_NO", "TP_NM", "NMPR_ORD_BNS_TCD", "ITEM_NM", 
                                "ORD_UPR", "ORD_Q", "ORD_RQ", "OORD_NO", "FUOP_ORD_STAT_TCD", 
                                "ORD_TMD", "ITEM_COD"]
                }
            }
            
            self.em.put_tr(tr_cmd)
            data = self.em.get_tr()
            
            nRow = data['OutRec1']['RECNM']
            try:
                nRow = int(data['OutRec1']['RECNM'])
            except ValueError:
                nRow = 0 
            self.chejan.setRowCount(nRow)
            
            for i in range(nRow):
                ord_time = QTime.fromString(data['OutRec2'][i]['ORD_TMD'], "hhmmss")
                formatted_ord_time = ord_time.toString("hh:mm:ss")
                self.chejan.setItem(i, 0, QTableWidgetItem(data['OutRec2'][i]['ORD_NO']))
                self.chejan.setItem(i, 1, QTableWidgetItem(data['OutRec2'][i]['TP_NM']))
                self.chejan.setItem(i, 2, QTableWidgetItem(data['OutRec2'][i]['NMPR_ORD_BNS_TCD']))
                self.chejan.setItem(i, 3, QTableWidgetItem(data['OutRec2'][i]['ITEM_NM']))
                self.chejan.setItem(i, 4, QTableWidgetItem(data['OutRec2'][i]['ORD_UPR']))
                self.chejan.setItem(i, 5, QTableWidgetItem(data['OutRec2'][i]['ORD_Q']))
                self.chejan.setItem(i, 6, QTableWidgetItem(data['OutRec2'][i]['ORD_RQ']))
                self.chejan.setItem(i, 7, QTableWidgetItem(data['OutRec2'][i]['OORD_NO']))
                self.chejan.setItem(i, 8, QTableWidgetItem(data['OutRec2'][i]['FUOP_ORD_STAT_TCD']))
                self.chejan.setItem(i, 9, QTableWidgetItem(formatted_ord_time))
                self.chejan.setItem(i, 10, QTableWidgetItem(data['OutRec2'][i]['ITEM_COD']))
            
        
    # 잔고        
    def kSilJan(self):
        # Real 해제
        self.em.put_method(("allUnRegisterReal", ""))
        self.em.get_method()
        
        if self.kstk.isChecked():
            self.label_23.setText("국내주식 잔고조회")
            tr_cmd = {
                'rqId': self.rqId,
                'trCode': 'OTD3108Q',
                'input': {
                    "ACNO": self.userAccNo.text(),
                    "AC_PWD": self.kuserPw.text(),
                    "CMSN_ICLN_YN": "Y"
                },
                'output': {
                    'OutRec1': ['RECNM'],
                    'OutRec2': ["ITEM_COD", "ITEM_NM", "CRD_TCD", "BNS_ABLE_Q", 
                                "BNS_BAL_Q", "BUY_UPR", "STK_CRPR", "EV_PL_A", 
                                "ERN_R", "STK_EA", "ESTI_CMSN", "ESTI_TXA"]
                }
            }
            
            self.em.put_tr(tr_cmd)
            data = self.em.get_tr()
                      
            nRow = data['OutRec1']['RECNM']
            try:
                nRow = int(data['OutRec1']['RECNM'])
            except ValueError:
                nRow = 0           
            self.siljan.setRowCount(nRow)
            for i in range(nRow):
                tax = int(data['OutRec2'][i]['ESTI_CMSN']) + int(data['OutRec2'][i]['ESTI_TXA'])
                self.siljan.setItem(i, 0, QTableWidgetItem(data['OutRec2'][i]['ITEM_COD'].replace("A", "")))
                self.siljan.setItem(i, 1, QTableWidgetItem(data['OutRec2'][i]['ITEM_NM']))
                self.siljan.setItem(i, 2, QTableWidgetItem(data['OutRec2'][i]['CRD_TCD'] + " (문서 참고)"))
                self.siljan.setItem(i, 3, QTableWidgetItem(data['OutRec2'][i]['BNS_ABLE_Q']))
                self.siljan.setItem(i, 4, QTableWidgetItem(data['OutRec2'][i]['BNS_BAL_Q']))
                self.siljan.setItem(i, 5, QTableWidgetItem('{:,}'.format(int(float(data['OutRec2'][i]['BUY_UPR'])))))
                self.siljan.setItem(i, 6, QTableWidgetItem('{:,}'.format(int(data['OutRec2'][i]['STK_CRPR']))))
                self.siljan.setItem(i, 7, QTableWidgetItem('{:,}'.format(int(data['OutRec2'][i]['EV_PL_A']))))
                self.siljan.setItem(i, 8, QTableWidgetItem(format(float(data['OutRec2'][i]['ERN_R']), ".2f") + "%"))
                self.siljan.setItem(i, 9, QTableWidgetItem('{:,}'.format(int(data['OutRec2'][i]['STK_EA']))))
                self.siljan.setItem(i, 10, QTableWidgetItem('{:,}'.format(int(tax))))
        
        elif self.kfuopt.isChecked():
            self.label_23.setText("선물옵션 잔고조회")
            tr_cmd = {
                'rqId': self.rqId,
                'trCode': 'OFU4793Q',
                'input': {
                    "ACNO": self.userAccNo.text(),
                    "AC_PWD": self.kuserPw.text()
                },
                'output': {
                    'OutRec1': ['RECNM'],
                    'OutRec2': ["ITEM_COD", "ITEM_NM", "BUY_SEL_TP_NM", "FUOP_CRPR",
                                "FUOP_USCTR_Q", "LQDT_ABLE_Q", "USCTR_UPR", 
                                "PL_A", "FUOP_EA", "PCHS_A"]
                }
            }
            
            self.em.put_tr(tr_cmd)
            data = self.em.get_tr()
            
            nRow = data['OutRec1']['RECNM']
            try:
                nRow = int(data['OutRec1']['RECNM'])
            except ValueError:
                nRow = 0
            self.siljan.setRowCount(nRow)
            
            for i in range(nRow):
                
                return_ratio = format((float(data['OutRec2'][i]['PL_A']) / float(data['OutRec2'][i]['FUOP_EA']) * 100), ".2f")
                
                self.siljan.setItem(i, 0, QTableWidgetItem(data['OutRec2'][i]['ITEM_COD']))
                self.siljan.setItem(i, 1, QTableWidgetItem(data['OutRec2'][i]['ITEM_NM']))
                self.siljan.setItem(i, 2, QTableWidgetItem(data['OutRec2'][i]['BUY_SEL_TP_NM']))
                self.siljan.setItem(i, 3, QTableWidgetItem(data['OutRec2'][i]['FUOP_USCTR_Q']))
                self.siljan.setItem(i, 4, QTableWidgetItem(data['OutRec2'][i]['LQDT_ABLE_Q']))
                # self.siljan.setItem(i, 5, QTableWidgetItem(data['OutRec2'][i]['USCTR_UPR']))
                self.siljan.setItem(i, 5, QTableWidgetItem(format( float( data['OutRec2'][i]['USCTR_UPR'] ), ".2f" )))
                # self.siljan.setItem(i, 6, QTableWidgetItem(data['OutRec2'][i]['FUOP_CRPR']))
                self.siljan.setItem(i, 6, QTableWidgetItem(format( float( data['OutRec2'][i]['FUOP_CRPR'] ), ".2f" )))
                self.siljan.setItem(i, 7, QTableWidgetItem('{:,}'.format( int( float( data['OutRec2'][i]['PL_A'] ) ) )))
                self.siljan.setItem(i, 8, QTableWidgetItem(str(return_ratio) + "%"))
                self.siljan.setItem(i, 9, QTableWidgetItem('{:,}'.format( int( float( data['OutRec2'][i]['FUOP_EA'] ) ) )))
                
################ 잔고 ################

################ 해외잔고 ################       
    # 해주잔고조회
    def getOvsJango(self):
        t = threading.Thread(target=self.getError, daemon=True)
        t.start()
                
        if self.validAccPopup(self.ovsUserAccNo.text(), self.ovsUserPw.text()):
            self.ovsCheJan()
            self.ovsSiljan()
        else:
            return
    
    # 체결잔고
    def ovsCheJan(self):
        self.label_23.setText("해외주식 잔고조회")
        today = datetime.now().strftime("%Y%m%d")
        tr_cmd = {
            'rqId': self.rqId,
            'trCode': 'OTD6214Q',
            'input': {
                "ACNO": self.ovsUserAccNo.text(),
                "AC_PWD": self.ovsUserPw.text(),
                "ORD_DT": today,
                "BUY_SEL_TR_TCD": "%",
                "ORD_RJT_YN": "%",
                "EXG_COD": "%"
            },
            'output': {
                'OutRec1': ['RECNM'],
                'OutRec2': ["ORD_NO", "BUY_SEL_TR_TCD", "FGST_BNS_TCD", "ITEM_NM", "FGST_ORD_UPR",
                        "FRGN_NCLSN_Q", "OORD_NO", "FGST_ORD_SCD", "ORD_TMD", "ITEM_COD", "ORD_Q"]
            }
        }
        
        self.em.put_tr(tr_cmd)
        data = self.em.get_tr()
           
        nRow = data['OutRec1']['RECNM']
        try:
            nRow = int(data['OutRec1']['RECNM'])
        except ValueError:
            nRow = 0
        self.chejan.setRowCount(nRow)
        
        for i in range(nRow):  
            ord_time = QTime.fromString(data['OutRec2'][i]['ORD_TMD'], "hhmmss")
            formatted_ord_time = ord_time.toString("hh:mm:ss")              
            self.chejan.setItem(i, 0, QTableWidgetItem(data['OutRec2'][i]['ORD_NO']))
            self.chejan.setItem(i, 1, QTableWidgetItem(data['OutRec2'][i]['BUY_SEL_TR_TCD']))
            self.chejan.setItem(i, 2, QTableWidgetItem(data['OutRec2'][i]['FGST_BNS_TCD'] + " (가이드문서 참고)"))
            self.chejan.setItem(i, 3, QTableWidgetItem(data['OutRec2'][i]['ITEM_NM']))
            self.chejan.setItem(i, 4, QTableWidgetItem(data['OutRec2'][i]['FGST_ORD_UPR']))
            self.chejan.setItem(i, 5, QTableWidgetItem(data['OutRec2'][i]['ORD_Q']))
            self.chejan.setItem(i, 6, QTableWidgetItem(data['OutRec2'][i]['FRGN_NCLSN_Q']))
            self.chejan.setItem(i, 7, QTableWidgetItem(data['OutRec2'][i]['OORD_NO']))
            self.chejan.setItem(i, 8, QTableWidgetItem(data['OutRec2'][i]['FGST_ORD_SCD']))
            self.chejan.setItem(i, 9, QTableWidgetItem(formatted_ord_time))
            self.chejan.setItem(i, 10, QTableWidgetItem(data['OutRec2'][i]['ITEM_COD']))
            
    # 실잔
    def ovsSiljan(self):
        tr_cmd = {
            'rqId': self.rqId,
            'trCode': 'OTD6209Q',
            'input': {
                "ACNO": self.ovsUserAccNo.text(),
                "AC_PWD": self.ovsUserPw.text(),
            },
            'output': {
                'OutRec1': ['RECNM'],
                'OutRec2': ["ITEM_COD", "ITEM_NM", "FRGN_STK_MKT_TCD", "HLDG_Q", 
                            "SEL_ABLE_Q", "BUY_UPR", "FRGN_STK_CLPR", "EV_PL_SUM_A", "ERN_R", 
                            "BNS_BAL_EA"]
            }
        }
        
        self.em.put_tr(tr_cmd)
        data = self.em.get_tr()
                      
        nRow = data['OutRec1']['RECNM']
        try:
            nRow = int(data['OutRec1']['RECNM'])
        except ValueError:
            nRow = 0           
        self.siljan.setRowCount(nRow)
        
        for i in range(nRow):
            self.siljan.setItem(i, 0, QTableWidgetItem(data['OutRec2'][i]['ITEM_COD']))
            self.siljan.setItem(i, 1, QTableWidgetItem(data['OutRec2'][i]['ITEM_NM']))
            self.siljan.setItem(i, 2, QTableWidgetItem(data['OutRec2'][i]['FRGN_STK_MKT_TCD'] + " (문서 참고)"))
            self.siljan.setItem(i, 3, QTableWidgetItem(data['OutRec2'][i]['HLDG_Q']))
            self.siljan.setItem(i, 4, QTableWidgetItem(data['OutRec2'][i]['SEL_ABLE_Q']))
            self.siljan.setItem(i, 5, QTableWidgetItem(format(float(data['OutRec2'][i]['BUY_UPR']), ".4f")))
            self.siljan.setItem(i, 6, QTableWidgetItem(format(float(data['OutRec2'][i]['FRGN_STK_CLPR']), ".4f")))
            self.siljan.setItem(i, 7, QTableWidgetItem(format(float(data['OutRec2'][i]['EV_PL_SUM_A']), ".2f")))
            self.siljan.setItem(i, 8, QTableWidgetItem(format(float(data['OutRec2'][i]['ERN_R']), ".2f") + "%"))
            self.siljan.setItem(i, 9, QTableWidgetItem(format(float(data['OutRec2'][i]['BNS_BAL_EA']), ".2f")))
            self.siljan.setItem(i, 10, QTableWidgetItem(""))

################ 해외잔고 ################              

if __name__ == "__main__":
    import multiprocessing as mp
    mp.freeze_support()
    
    app = QtWidgets.QApplication(sys.argv)
    mainWindow = QtWidgets.QMainWindow()
    ui = Ui_mainWindow()
    ui.setupUi(mainWindow)
    mainWindow.show()
    app.lastWindowClosed.connect(app.quit)
    sys.exit(app.exec_())

