﻿Public Class Form1

    Private Declare Function SetCurrentDirectory Lib "kernel32" Alias "SetCurrentDirectoryA" (ByVal lpPathName As String) As Long
    Private Declare Function FindWindow Lib "user32.dll" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As Integer

    Dim g_nVersionPassKey As Integer    '버전처리 체크 키값
    Dim g_sOpenAPI_PATH As String      'Open Api 설치경로
    Dim g_bLogin As Boolean             '로그인여부
    Dim g_bSetReal As Boolean           '실시간등록여부
    Dim g_sMsg As String                '처리결과 메세지
    Dim g_sLoginId As String            '로그인 아이디

    '국내주식
    Dim g_sTrcode_Sise As String        '현재가 TrCode
    Dim g_sTrcode_Hoga As String        '호가 TrCode
    Dim g_sTrcode_Che As String         '체결 TrCode
    Dim g_sTrcode_Kwansim As String     '관심종목FID Trcode
    Dim g_sTrcode_BSOrder As String     '매수/매도 주문전송 TrCode
    Dim g_sTrcode_MCOrder As String     '정정/취소 주문전송 TrCode
    Dim g_sTrcode_CheList As String     '체결/미체결 내역조회 TrCode
    Dim g_sTrcode_JanList As String     '잔고 내역조회 TrCode
    Dim g_sNextKey_Jan As String        '잔고조회 연속조회키
    Dim g_sNextKey_Che As String        '체결내역 연속조회키

    '해외주식
    Dim g_sTrcode_gbSise As String      '해외주식 현재가 TrCode
    Dim g_sTrcode_gbHoga As String      '해외주식 호가 TrCode
    Dim g_sTrcode_gbChe As String       '해외주식 체결시세 TrCode
    Dim g_sTrcode_gbKwansim As String   '해외주식 관심종목FID TrCode
    Dim g_sTrcode_gbBSOrder As String   '해외주식 매수/매도 주문전송 TrCode
    Dim g_sTrcode_gbMCOrder As String   '해외주식 정정/취소 주문전송 TrCode
    Dim g_sTrcode_gbCheList As String   '해외주식 일자별 주문체결 내역조회 TrCode
    Dim g_sTrcode_gbMiCheList As String '해외주식 당일 미체결 내역조회 TrCode
    Dim g_sTrcode_gbJanList As String   '해외주식 종목별 주식평가손익 조회 TrCode
    Dim g_sTrcode_gbAccInfo As String   '해외주식 예수금 조회 TrCode
    Dim g_sNextKey_gbJan As String      '해외주식 잔고조회 연속조회키
    Dim g_sNextKey_gbChe As String      '해외주식 체결내역 연속조회키

    '선물옵션
    Dim g_sTrcode_FSise As String       '지수선물 현재가+호가 시세 TrCode
    Dim g_sTrcode_OSise As String       '지수옵션 현재가+호가 시세 TrCode
    Dim g_sTrcode_FChe As String        '지수선물 체결시세 TrCode
    Dim g_sTrcode_OChe As String        '지수옵션 체결시세 TrCode
    Dim g_sTrcode_FOBSOrder As String   '선물옵션 매수/매도 주문전송 TrCode
    Dim g_sTrcode_FOMCOrder As String   '선물옵션 정정/취소 주문전송 TrCode
    Dim g_sTrcode_FOCheList As String   '선물옵션 체결/미체결 내역조회 TrCode
    Dim g_sTrcode_FOJanList As String   '선물옵션 잔고내역 조회 TrCode
    Dim g_sTrcode_FOAccInfo As String   '선물옵션 예수금 조회 TrCode
    Dim g_sNextKey_FOJan As String      '선물옵션 잔고조회 연속조회키
    Dim g_sNextKey_FOChe As String      '선물옵션 체결내역 연속조회키

    '조건검색
    Dim g_sTrcode_007 As String         '조건검색 리스트 조회(msvf007)
    Dim g_sTrcode_027 As String         '조건검색 내용 조회(msvf027)
    Dim g_sTrcode_028 As String         '조건검색 실시간 등록(msvf028)
    Dim g_sOldRealKey As String         '마지막에 등록된 조건검색 실시간 등록키

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        Call Crtl_Init()    '컨트롤 상태 및 전역변수 초기화
    End Sub

    Private Sub Form1_form_Closing(sender As Object, e As FormClosingEventArgs) Handles Me.FormClosing
        Call SetLogout()    '로그아웃
    End Sub

    '================================
    ' 컨트롤 상태 및 전역변수 초기화
    '================================
    Private Sub Crtl_Init()
        '컨트롤 상태 초기화
        Btn_Logout.Enabled = False
        Btn_Search.Enabled = False
        Btn_SetReal.Enabled = False
        Btn_UnReal.Enabled = False
        Btn_Kwansim.Enabled = False

        Btn_GBSearch.Enabled = False
        Btn_GBSetReal.Enabled = False
        Btn_GBUnReal.Enabled = False
        Btn_GBKwansim.Enabled = False

        Btn_FOSearch.Enabled = False
        Btn_FOSetReal.Enabled = False
        Btn_FOUnReal.Enabled = False

        CB_OrdType.Text = "지정가"
        CB_GBOrdType.Text = "지정가"
        CB_CheExgCode.Text = "전체"
        CB_FOOrdType.Text = "지정가"

        g_nVersionPassKey = 0
        g_sOpenAPI_PATH = ""
        g_bLogin = False
        g_bSetReal = False
        g_sMsg = ""
        g_sLoginId = ""

        TB_ID.Select()

        '국내주식
        g_sTrcode_Sise = "stscur"       '현재가 TrCode
        g_sTrcode_Hoga = "stpbid"       '호가 TrCode
        g_sTrcode_Che = "msvstbid"      '체결시세 TrCode
        g_sTrcode_Kwansim = "concern"   '관심종목FID TrCode
        g_sTrcode_BSOrder = "OTD1101U"  '매수/매도 주문전공 TrCode
        g_sTrcode_MCOrder = "OTD1102U"  '정정/취소 주문전송 TrCode
        g_sTrcode_CheList = "OTD4105Q"  '체결/미체결 내역조회 TrCode
        g_sTrcode_JanList = "OTD3108Q"  '잔고 내역조회 TrCode

        '해외주식
        g_sTrcode_gbSise = "gbmst"          '해외주식 현재가 TrCode
        g_sTrcode_gbHoga = "gbpbid"         '해외주식 호가 TrCode
        g_sTrcode_gbChe = "gbtick"          '해외주식 체결시세 TrCode
        g_sTrcode_gbKwansim = "concern2"    '해외주식 관심종목FID TrCode
        g_sTrcode_gbBSOrder = "OTD6101U"    '해외주식 매수/매도 주문전송 TrCode
        g_sTrcode_gbMCOrder = "OTD6103U"    '해외주식 정정/취소 주문전송 TrCode
        g_sTrcode_gbCheList = "OTD6214Q"    '해외주식 일자별 주문체결 내역조회 TrCode
        g_sTrcode_gbMiCheList = "OTD6216Q"  '해외주식 당일 미체결 내역조회 TrCode
        g_sTrcode_gbJanList = "OTD6209Q"    '해외주식 종목별 주식평가손익 조회 TrCode
        g_sTrcode_gbAccInfo = "OCA1725Q"    '해외주식 예수금 조회 TrCode

        '선물옵션
        g_sTrcode_FSise = "ffcur"           '지수선물 체결 + 호가 시세 TrCode
        g_sTrcode_OSise = "ogibon"          '지수옵션 체결 + 호가 시세 TrCode
        g_sTrcode_FChe = "msvifbid"         '지수선물 체결시세 TrCode
        g_sTrcode_OChe = "msviobid"         '지수옵션 체결시세 TrCode
        g_sTrcode_FOBSOrder = "OFU1101U"    '선물옵션 매수/매도 주문전송 TrCode
        g_sTrcode_FOMCOrder = "OFU1102U"    '선물옵션 정정/취소 주문전송 TrCode
        g_sTrcode_FOCheList = "OFU4772Q"    '선물옵션 체결/미체결 내역조회 TrCode
        g_sTrcode_FOJanList = "OFU4793Q"    '선물옵션 잔고내역 조회 TrCode
        g_sTrcode_FOAccInfo = "OFU5628Q"    '선물옵션 예수금 조회 TrCode

        '조건검색
        g_sTrcode_007 = "msvf007"           '조건검색 리스트 조회(msvf007)
        g_sTrcode_027 = "msvf027"           '조건검색 내용 조회(msvf027)
        g_sTrcode_028 = "msvf028"           '조건검색 실시간 등록(msvf028)
    End Sub

    '================================
    '로그아웃 & 통신종료 처리
    '================================
    Public Sub SetLogout()
        Dim sID As String       '로그인ID
        sID = TB_ID.Text

        Dim nRtn As Integer
        If Len(g_sLoginId) > 0 Then
            nRtn = AxChampionCommAgent1.CommLogout(g_sLoginId)
        End If

        If nRtn <= 0 Then
            g_sMsg = "로그아웃 실패"
            Btn_Logout.Enabled = True
        Else
            g_bLogin = False
            g_sMsg = "로그아웃 성공"
            Btn_Login.Enabled = True
            Btn_Logout.Enabled = False

            Btn_Search.Enabled = False
            Btn_SetReal.Enabled = False
            Btn_UnReal.Enabled = False
            Btn_Kwansim.Enabled = False

            Btn_GBSearch.Enabled = False
            Btn_GBSetReal.Enabled = False
            Btn_GBUnReal.Enabled = False
            Btn_GBKwansim.Enabled = False

            Btn_FOSearch.Enabled = False
            Btn_FOSetReal.Enabled = False
            Btn_FOUnReal.Enabled = False

            AxChampionCommAgent1.AllUnRegisterReal() '모든 실시간 해제
            AxChampionCommAgent1.CommTerminate(1)
        End If
    End Sub

    '================================
    ' 현재가 시세 조회
    '================================
    Private Sub Requset_Sise(sCode As String)
        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_Sise, "InRec1", "SCODE", sCode)

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_Sise, "", 20)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "현재가 조회 요청 실패")
        End If
    End Sub

    '================================
    ' 호가 시세 조회
    '================================
    Private Sub Requset_Hoga(sCode As String)
        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_Hoga, "InRec1", "SCODE", sCode)

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_Hoga, "", 20)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "호가 조회 요청 실패")
        End If

    End Sub

    '================================
    ' 체결 시세 조회
    '================================
    Private Sub Requset_Che(sCode As String)
        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_Che, "InRec1", "CMODE", "A")
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_Che, "InRec1", "SCODE", sCode)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_Che, "InRec1", "LTIME", "0")
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_Che, "InRec1", "LCNT", "20")

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_Che, "", 20)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "체결시세 조회 요청 실패")
        End If
    End Sub

    '================================
    ' 현재가 시세조회 응답결과 처리
    '================================
    Private Sub OnGetData_Sise()
        Dim sOutPut As String
        Dim nOutVal As Long

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Sise, "OutRec1", "SNAME", 0)) '종목명
        LB_JmName.Text = sOutPut

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Sise, "OutRec1", "LCPRICE", 0)) '현재가
        nOutVal = Val(sOutPut)
        LV_Sise.Items.Item(0).SubItems(1).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Sise, "OutRec1", "LDIFF", 0)) '전일대비
        nOutVal = Val(sOutPut)
        LV_Sise.Items.Item(1).SubItems(1).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Sise, "OutRec1", "LVOLUME", 0)) '거래량
        nOutVal = Val(sOutPut)
        LV_Sise.Items.Item(2).SubItems(1).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Sise, "OutRec1", "LOPRICE", 0)) '시가    
        nOutVal = Val(sOutPut)
        LV_Sise.Items.Item(3).SubItems(1).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Sise, "OutRec1", "LHPRICE", 0)) '고가
        nOutVal = Val(sOutPut)
        LV_Sise.Items.Item(4).SubItems(1).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Sise, "OutRec1", "LLPRICE", 0)) '저가
        nOutVal = Val(sOutPut)
        LV_Sise.Items.Item(5).SubItems(1).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Sise, "OutRec1", "LULIMITPRICE", 0)) '상한가
        nOutVal = Val(sOutPut)
        LV_Sise.Items.Item(6).SubItems(1).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Sise, "OutRec1", "LLLIMITPRICE", 0)) '하한가
        nOutVal = Val(sOutPut)
        LV_Sise.Items.Item(7).SubItems(1).Text = nOutVal.ToString("###,##0")
    End Sub

    '================================
    ' 호가 시세조회 응답결과 처리
    '================================
    Private Sub OnGetData_Hoga()
        Dim sOutPut As String
        Dim nOutVal As Long
        Dim sTime As String     '호가 시간
        Dim sPrevPrc As String  '전일종가
        Dim sCurrPrc As String  '현재가

        sPrevPrc = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Hoga, "OutRec1", "LLSTCPRICE", 0)) '전일종가
        sCurrPrc = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Hoga, "OutRec1", "LCPRICE", 0)) '현재가

        Dim sOutRecItem As String   '아웃풋 아이템명
        Dim sIdx As String          '아웃풋 아이템명 순번
        Dim nAskRow As Integer      '매도호가 Row 위치
        Dim nBidRow As Integer      '매수호가 Row 위치
        nAskRow = 9
        nBidRow = 0

        '1호가 ~ 10호가 처리
        Dim i As Integer
        For i = 1 To 10
            '2호가부터 Row위치 변경
            If i > 1 Then
                nAskRow = nAskRow - 1
                nBidRow = nBidRow + 1
            End If

            sIdx = i.ToString()
            sOutRecItem = "LOFFER" & sIdx
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Hoga, "OutRec1", sOutRecItem, 0)) '매도 호가
            nOutVal = Val(sOutPut)
            LV_MedoHoga.Items.Item(nAskRow).SubItems(3).Text = nOutVal.ToString("###,###")

            sOutRecItem = "LOFFERREST" & sIdx
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Hoga, "OutRec1", sOutRecItem, 0)) '매도 잔량
            nOutVal = Val(sOutPut)
            LV_MedoHoga.Items.Item(nAskRow).SubItems(2).Text = nOutVal.ToString("###,###")

            sOutRecItem = "LOFFERRESTPRE" & sIdx
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Hoga, "OutRec1", sOutRecItem, 0)) '매도직전잔량
            nOutVal = Val(sOutPut)
            LV_MedoHoga.Items.Item(nAskRow).SubItems(1).Text = nOutVal.ToString("###,###")

            sOutRecItem = "LBID" & sIdx
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Hoga, "OutRec1", sOutRecItem, 0)) '매수 호가
            nOutVal = Val(sOutPut)
            LV_MesuHoga.Items.Item(nBidRow).SubItems(3).Text = nOutVal.ToString("###,###")

            sOutRecItem = "LBIDREST" & sIdx
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Hoga, "OutRec1", sOutRecItem, 0)) '매수 잔량
            nOutVal = Val(sOutPut)
            LV_MesuHoga.Items.Item(nBidRow).SubItems(4).Text = nOutVal.ToString("###,###")

            sOutRecItem = "LBIDRESTPRE" & sIdx
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Hoga, "OutRec1", sOutRecItem, 0)) '매수직전잔량
            nOutVal = Val(sOutPut)
            LV_MesuHoga.Items.Item(nBidRow).SubItems(5).Text = nOutVal.ToString("###,###")
        Next

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Hoga, "OutRec1", "LTOT_PREOFFERCHA", 0)) '총매도호가직전잔량
        nOutVal = Val(sOutPut)
        LV_HogaTot.Items.Item(0).SubItems(1).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Hoga, "OutRec1", "LTOTOFFERREST", 0)) '총매도호가잔량
        nOutVal = Val(sOutPut)
        LV_HogaTot.Items.Item(0).SubItems(2).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Hoga, "OutRec1", "LTIME", 0)) '시간
        If sOutPut.Length = 5 Then
            sOutPut = "0" & sOutPut
        End If
        sTime = Strings.Left(sOutPut, 2) & ":" & Strings.Mid(sOutPut, 3, 2) & ":" & Strings.Right(sOutPut, 2)
        LV_HogaTot.Items.Item(0).SubItems(3).Text = sTime

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Hoga, "OutRec1", "LTOTBIDREST", 0)) '총매수호가잔량
        nOutVal = Val(sOutPut)
        LV_HogaTot.Items.Item(0).SubItems(4).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Hoga, "OutRec1", "LTOT_PREBIDCHA", 0)) '총매수호가직전잔량
        nOutVal = Val(sOutPut)
        LV_HogaTot.Items.Item(0).SubItems(5).Text = nOutVal.ToString("###,##0")
    End Sub

    '================================
    ' 체결 시세조회 응답결과 처리
    '================================
    Private Sub OnGetData_Che()
        Dim sOutPut As String
        Dim nOutVal As Long
        Dim sTime As String

        Dim nDataCnt As Long
        nDataCnt = AxChampionCommAgent1.GetTranOutputRowCnt(g_sTrcode_Che, "OutRec2") '조회건수

        LV_CheSise.Items.Clear()

        If nDataCnt = 0 Then
            Exit Sub
        End If

        Dim sColText(4) As String
        sColText(0) = ""

        Dim lvitem As ListViewItem

        Dim i As Integer
        For i = 0 To nDataCnt - 1
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Che, "OutRec2", "LTIME", i))        '시간
            If sOutPut.Length = 5 Then
                sOutPut = "0" & sOutPut
            End If
            sTime = Strings.Left(sOutPut, 2) & ":" & Strings.Mid(sOutPut, 3, 2) & ":" & Strings.Right(sOutPut, 2)
            sColText(1) = sTime

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Che, "OutRec2", "LCPRICE", i))      '현재가(체결가)
            nOutVal = Val(sOutPut)
            sColText(2) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_Che, "OutRec2", "LNETVOLUME", i))   '체결량
            nOutVal = Val(sOutPut)
            sColText(3) = nOutVal.ToString("###,##0")

            lvitem = New ListViewItem(sColText)
            LV_CheSise.Items.Add(lvitem)
        Next

    End Sub

    '================================
    ' 매수/매도 주문 전송
    '================================
    Private Sub SendBSOrder(bBuy As Boolean)
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Dim sAccNo As String    '계좌번호
        Dim sAccPwd As String   '계좌비번
        Dim sOrdType As String  '주문유형
        Dim sOrdQty As String   '주문수량
        Dim sOrdPrc As String   '주문가격
        Dim sJmCode As String   '종목코드

        'Dim sTradeGb As String  '매매구분(20:매수, 10:매도)
        'If bBuy = True Then
        '    sTradeGb = "20"
        'Else
        '    sTradeGb = "10"
        'End If
        Dim sTradeGb = If(bBuy, "20", "10") '매매구분(20:매수, 10:매도)

        sJmCode = TB_OrdJmCode.Text
        sAccNo = TB_AccNo.Text
        sAccPwd = TB_AccPwd.Text
        sOrdType = CB_OrdType.Text
        sOrdQty = UD_OrdQty.Text
        sOrdPrc = TB_OrdPrc.Text

        If Len(Trim(sJmCode)) = 0 Then
            MsgBox("종목코드를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccNo)) = 0 Then
            MsgBox("계좌번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccPwd)) = 0 Then
            MsgBox("계좌 비밀번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sOrdType)) = 0 Then
            MsgBox("주문유형을 선택해주세요.")
            Exit Sub
        End If

        If Val(sOrdQty) = 0 Then
            MsgBox("주문수량을 입력해주세요.")
            Exit Sub
        End If

        '주문유형 코드값 변환
        Dim sOrdTypeCode As String
        Dim sOrdCond As String
        sOrdTypeCode = ""
        sOrdCond = ""

        If sOrdType = "지정가" Then
            sOrdTypeCode = "010"
            sOrdCond = "0"
        ElseIf sOrdType = "시장가" Then
            sOrdTypeCode = "020"
            sOrdCond = "0"
        ElseIf sOrdType = "조건부지정가" Then
            sOrdTypeCode = "030"
            sOrdCond = "0"
        ElseIf sOrdType = "최유리지정가" Then
            sOrdTypeCode = "040"
            sOrdCond = "0"
        ElseIf sOrdType = "최우선지정가" Then
            sOrdTypeCode = "050"
            sOrdCond = "0"
        ElseIf sOrdType = "지정가(IOC)" Then
            sOrdTypeCode = "010"
            sOrdCond = "1"
        ElseIf sOrdType = "시장가(IOC)" Then
            sOrdTypeCode = "020"
            sOrdCond = "1"
        ElseIf sOrdType = "최유리(IOC)" Then
            sOrdTypeCode = "040"
            sOrdCond = "1"
        ElseIf sOrdType = "지정가(FOK)" Then
            sOrdTypeCode = "010"
            sOrdCond = "2"
        ElseIf sOrdType = "시장가(FOK)" Then
            sOrdTypeCode = "020"
            sOrdCond = "2"
        ElseIf sOrdType = "최유리(FOK)" Then
            sOrdTypeCode = "040"
            sOrdCond = "2"
        ElseIf sOrdType = "장전시간외" Then
            sOrdTypeCode = "210"
            sOrdCond = "0"
        ElseIf sOrdType = "장후시간외" Then
            sOrdTypeCode = "280"
            sOrdCond = "0"
        End If

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Integer
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_BSOrder, "InRec1", "ACNO", sAccNo)              '계좌번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_BSOrder, "InRec1", "AC_PWD", sAccPwd)           '계좌비밀번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌 비밀번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_BSOrder, "InRec1", "ITEM_COD", sJmCode)         '종목코드
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_BSOrder, "InRec1", "ORD_Q", sOrdQty)            '주문수량
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_BSOrder, "InRec1", "STK_BD_ORD_UPR", sOrdPrc)   '주문단가
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_BSOrder, "InRec1", "BUY_SEL_TR_TCD", sTradeGb)  '매매구분(10:매수, 20:매도)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_BSOrder, "InRec1", "ORD_BNS_TCD", sOrdTypeCode) '주문유형구분
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_BSOrder, "InRec1", "ORD_COND_TCD", sOrdCond)    '주문조건구분

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_BSOrder, "", 20)
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "매수/매도 주문전송 실패")
        End If
    End Sub

    '================================
    ' 정정/취소 주문 전송
    '================================
    Private Sub SendMCOrder(bModify As Boolean)
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Dim sAccNo As String    '계좌번호
        Dim sAccPwd As String   '계좌비번
        Dim sOrdType As String  '주문유형
        Dim sOrdQty As String   '주문수량
        Dim sOrdPrc As String   '주문가격
        Dim sOrgOrdNo As String '원주문번호
        Dim sJmCode As String   '종목코드

        'Dim sTradeGb As String  '매매구분(20:정정, 30:취소)
        'If bModify = True Then
        '    sTradeGb = "20"
        'Else
        '    sTradeGb = "30"
        'End If
        Dim sTradeGb = If(bModify, "20", "30") '매매구분(20:정정, 30:취소)

        sJmCode = TB_OrdJmCode.Text
        sAccNo = TB_AccNo.Text
        sAccPwd = TB_AccPwd.Text
        sOrdType = CB_OrdType.Text
        sOrdQty = UD_OrdQty.Text
        sOrdPrc = TB_OrdPrc.Text
        sOrgOrdNo = TB_OrgOrdNo.Text

        If Len(Trim(sJmCode)) = 0 Then
            MsgBox("종목코드를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccNo)) = 0 Then
            MsgBox("계좌번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccPwd)) = 0 Then
            MsgBox("계좌 비밀번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sOrdType)) = 0 Then
            MsgBox("주문유형을 선택해주세요.")
            Exit Sub
        End If

        If Val(sOrdQty) = 0 Then
            MsgBox("주문수량을 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sOrgOrdNo)) = 0 Then
            MsgBox("원주문번호를 입력해주세요.")
            Exit Sub
        End If

        '주문유형 코드값 변환
        Dim sOrdTypeCode As String
        Dim sOrdCond As String
        sOrdTypeCode = ""
        sOrdCond = ""

        If sOrdType = "지정가" Then
            sOrdTypeCode = "010"
            sOrdCond = "0"
        ElseIf sOrdType = "시장가" Then
            sOrdTypeCode = "020"
            sOrdCond = "0"
        ElseIf sOrdType = "조건부지정가" Then
            sOrdTypeCode = "030"
            sOrdCond = "0"
        ElseIf sOrdType = "최유리지정가" Then
            sOrdTypeCode = "040"
            sOrdCond = "0"
        ElseIf sOrdType = "최우선지정가" Then
            sOrdTypeCode = "050"
            sOrdCond = "0"
        ElseIf sOrdType = "지정가(IOC)" Then
            sOrdTypeCode = "010"
            sOrdCond = "1"
        ElseIf sOrdType = "시장가(IOC)" Then
            sOrdTypeCode = "020"
            sOrdCond = "1"
        ElseIf sOrdType = "최유리(IOC)" Then
            sOrdTypeCode = "040"
            sOrdCond = "1"
        ElseIf sOrdType = "지정가(FOK)" Then
            sOrdTypeCode = "010"
            sOrdCond = "2"
        ElseIf sOrdType = "시장가(FOK)" Then
            sOrdTypeCode = "020"
            sOrdCond = "2"
        ElseIf sOrdType = "최유리(FOK)" Then
            sOrdTypeCode = "040"
            sOrdCond = "2"
        ElseIf sOrdType = "장전시간외" Then
            sOrdTypeCode = "210"
            sOrdCond = "0"
        ElseIf sOrdType = "장후시간외" Then
            sOrdTypeCode = "280"
            sOrdCond = "0"
        End If

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_MCOrder, "InRec1", "ACNO", sAccNo)                  '계좌번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_MCOrder, "InRec1", "AC_PWD", sAccPwd)               '계좌비밀번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌 비밀번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_MCOrder, "InRec1", "OORD_NO", sOrgOrdNo)            '원주문번호
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_MCOrder, "InRec1", "ORD_MDFY_CNCL_TCD", sTradeGb)   '매매구분(20:정정, 30:취소)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_MCOrder, "InRec1", "PAT_ALL_TCD", "20")             '일부/전부 구분(10:일부, 20:전부)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_MCOrder, "InRec1", "ITEM_COD", sJmCode)             '종목코드
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_MCOrder, "InRec1", "ORD_Q", sOrdQty)                '주문수량
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_MCOrder, "InRec1", "STK_BD_ORD_UPR", sOrdPrc)       '주문단가
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_MCOrder, "InRec1", "ORD_BNS_TCD", sOrdTypeCode)     '주문유형구분
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_MCOrder, "InRec1", "ORD_COND_TCD", sOrdCond)        '주문조건구분

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_MCOrder, "", 20)
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "정정/취소 주문전송 실패")
        End If
    End Sub

    '================================
    ' 체결/미체결 내역 조회 응답결과 처리
    '================================
    Private Sub OnGetData_CheList(sNextGb As String, sNextKey As String)
        If sNextGb = "6" Or sNextGb = "7" Then '다음조회있음
            Btn_CheNext.Enabled = True
            g_sNextKey_Che = sNextKey
        Else
            Btn_CheNext.Enabled = False
            g_sNextKey_Che = ""
        End If

        Dim sOutPut As String
        Dim nOutVal As Long
        Dim nDataCnt As Integer
        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_CheList, "OutRec1", "RECNM", 0))  '레코드수
        nDataCnt = Val(sOutPut)

        Dim sOrdTypeNm As String    '주문유형
        Dim sTradeGb As String      '매매구분
        Dim sOrdTime As String      '주문시간
        sOrdTypeNm = ""
        sTradeGb = ""
        sOrdTime = ""

        Dim sColText(10) As String
        sColText(0) = ""

        Dim lvitem As ListViewItem
        Dim i As Integer
        For i = 0 To (nDataCnt - 1)
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_CheList, "OutRec2", "ITEM_COD", i))     '종목코드
            sColText(0) = Strings.Right(sOutPut, 6)

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_CheList, "OutRec2", "ITEM_ABBR_NM", i)) '종목명
            sColText(1) = sOutPut

            '매매구분(매수,매도)(첨부문서참조)
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_CheList, "OutRec2", "ORD_KCD ", i))
            If sOutPut = "0010" Then
                sTradeGb = "매도"
            ElseIf sOutPut = "0020" Then
                sTradeGb = "매수"
            End If
            sColText(2) = sTradeGb

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_CheList, "OutRec2", "ORD_UPR", i))  '주문가격
            nOutVal = Val(sOutPut)
            sColText(3) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_CheList, "OutRec2", "ORD_Q", i))    '주문수량
            nOutVal = Val(sOutPut)
            sColText(4) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_CheList, "OutRec2", "ORD_RQ", i))   '미체결수량
            nOutVal = Val(sOutPut)
            sColText(5) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_CheList, "OutRec2", "ORD_NO", i))   '주문번호
            sColText(6) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_CheList, "OutRec2", "OORD_NO", i))  '원주문번호
            sColText(7) = sOutPut

            '주문유형(10:지정가, 20:시장가, 30:조건부지정가, 40:최유리지정가, 50:최우선지정가)(첨부문서참조)
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_CheList, "OutRec2", "ORD_BNS_TCD ", i))
            If sOutPut = "010" Then
                sOrdTypeNm = "지정가"
            ElseIf sOutPut = "020" Then
                sOrdTypeNm = "시장가"
            ElseIf sOutPut = "030" Then
                sOrdTypeNm = "조건부지정가"
            ElseIf sOutPut = "040" Then
                sOrdTypeNm = "최유리지정가"
            ElseIf sOutPut = "050" Then
                sOrdTypeNm = "최우선지정가"
            End If
            sColText(8) = sOrdTypeNm

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_CheList, "OutRec2", "ORD_DTTM", i)) '주문시간
            If sOutPut.Length = 5 Then
                sOutPut = "0" & sOutPut
            End If
            sOrdTime = Strings.Left(sOutPut, 2) & ":" & Strings.Mid(sOutPut, 3, 2) & ":" & Strings.Right(sOutPut, 2)
            sColText(9) = sOrdTime

            lvitem = New ListViewItem(sColText)
            LV_CheList.Items.Add(lvitem)
        Next

    End Sub

    '================================
    ' 잔고 내역 조회 응답결과 처리
    '================================
    Private Sub OnGetData_JanList(sNextGb As String, sNextKey As String)
        If sNextGb = "6" Or sNextGb = "7" Then  '다음조회있음
            Btn_JanNext.Enabled = True
            g_sNextKey_Jan = sNextKey
        Else
            Btn_JanNext.Enabled = False         '다음조회없음
            g_sNextKey_Jan = ""
        End If

        Dim sOutPut As String
        Dim nOutVal As Long
        Dim nDataCnt As Integer

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_JanList, "OutRec1", "RECNM", 0))        '레코드수
        nDataCnt = Val(sOutPut)

        Dim sColText(9) As String
        sColText(0) = ""

        Dim lvitem As ListViewItem
        Dim i As Integer
        For i = 0 To (nDataCnt - 1)
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_JanList, "OutRec2", "ITEM_COD", i))     '종목코드
            sColText(0) = Strings.Right(sOutPut, 6)

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_JanList, "OutRec2", "ITEM_NM", i))      '종목명
            sColText(1) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_JanList, "OutRec2", "BNS_BAL_Q", i))    '보유수량
            nOutVal = Val(sOutPut)
            sColText(2) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_JanList, "OutRec2", "BNS_ABLE_Q", i))   '매도가능수량
            nOutVal = Val(sOutPut)
            sColText(3) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_JanList, "OutRec2", "BUY_UPR", i))      '매입단가
            nOutVal = Val(sOutPut)
            sColText(4) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_JanList, "OutRec2", "STK_CRPR", i))     '현재가
            nOutVal = Val(sOutPut)
            sColText(5) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_JanList, "OutRec2", "EV_PL_A", i))      '평가손익
            nOutVal = Val(sOutPut)
            sColText(6) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_JanList, "OutRec2", "STK_EA", i))       '평가금액
            nOutVal = Val(sOutPut)
            sColText(7) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_JanList, "OutRec2", "ACBK_A", i))       '매입금액
            nOutVal = Val(sOutPut)
            sColText(8) = nOutVal.ToString("###,##0")

            lvitem = New ListViewItem(sColText)
            LV_JanList.Items.Add(lvitem)
        Next

    End Sub

    '================================
    ' TR 조회 응답 처리
    '================================
    Private Sub AxChampionCommAgent1_OnGetTranData(sender As Object, e As AxChampionCommAgentLib._DChampionCommAgentEvents_OnGetTranDataEvent) Handles AxChampionCommAgent1.OnGetTranData
        Dim sTrcode As String
        Dim sNextGb As String
        Dim sNextKey As String
        Dim sMsg As String
        Dim sSubMsg As String
        Dim sErrCode As String

        sTrcode = AxChampionCommAgent1.GetCommRecvOptionValue(0)    'TR 코드
        sNextGb = AxChampionCommAgent1.GetCommRecvOptionValue(1)    '연속조회구분(0:없음, 4:다음없음, 5:다음없음, 6:다음있음, 7:다음있음)
        sNextKey = AxChampionCommAgent1.GetCommRecvOptionValue(2)   '연속조회키
        sMsg = AxChampionCommAgent1.GetCommRecvOptionValue(4)       '메세지
        sSubMsg = AxChampionCommAgent1.GetCommRecvOptionValue(5)    '부가메세지
        sErrCode = AxChampionCommAgent1.GetCommRecvOptionValue(7)   '에러여부

        '국내주식
        If sTrcode = g_sTrcode_Sise Then
            Call OnGetData_Sise()   '현재가 조회
        ElseIf sTrcode = g_sTrcode_Hoga Then
            Call OnGetData_Hoga()    '호가 조회
        ElseIf sTrcode = g_sTrcode_Che Then
            Call OnGetData_Che()    '체결시세 조회
        ElseIf sTrcode = g_sTrcode_BSOrder Or sTrcode = g_sTrcode_MCOrder Then  '매수/매도/정정/취소 주문
            Dim sOrdNo = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", "ORD_NO", 0)) '주문번호
            If Val(sOrdNo) > 0 Then
                TB_OrdNo.Text = sOrdNo
                Call Requset_CheList("")  '체결내역 조회
                Call Requset_JanList("")  '잔고내역 조회
            End If
        ElseIf sTrcode = g_sTrcode_CheList Then
            Call OnGetData_CheList(sNextGb, sNextKey)   '체결/미체결 내역 조회
        ElseIf sTrcode = g_sTrcode_JanList Then
            Call OnGetData_JanList(sNextGb, sNextKey)   '잔고내역 조회
        End If

        '해외주식(global)
        If sTrcode = g_sTrcode_gbSise Then
            Call OnGetData_GBSise()                         '해외주식 현재가 조회
        ElseIf sTrcode = g_sTrcode_gbHoga Then
            Call OnGetData_GBHoga()                         '해외주식 호가 조회
        ElseIf sTrcode = g_sTrcode_gbChe Then
            Call OnGetData_GBChe()                          '해외주식 체결시세 조회
        ElseIf sTrcode = g_sTrcode_gbAccInfo Then
            Call OnGetData_GBAccInfo()                      '해외주식 예수금 조회
        ElseIf sTrcode = g_sTrcode_gbCheList Or sTrcode = g_sTrcode_gbMiCheList Then
            Call OnGetData_GBCheList(sTrcode, sNextGb, sNextKey)  '해외주식 체결/미체결 내역
        ElseIf sTrcode = g_sTrcode_gbJanList Then
            Call OnGetData_GBJanList(sNextGb, sNextKey)   '해외주식 잔고내역 조회
        ElseIf sTrcode = g_sTrcode_gbBSOrder Or sTrcode = g_sTrcode_gbMCOrder Then  '매수/매도/정정/취소 주문
            Dim sOrdNo = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", "ORD_NO", 0)) '주문번호
            If Val(sOrdNo) > 0 Then
                TB_GBOrdNo.Text = sOrdNo
                Call Requset_GBAccInfo()    '계좌 예수금 조회
                Call Requset_GBCheList("")  '해외주식 체결내역 조회
                Call Requset_GBJanList("")  '해외주식 잔고내역 조회
            End If
        End If

        '선물옵션
        If sTrcode = g_sTrcode_FSise Or sTrcode = g_sTrcode_OSise Then
            Call OnGetData_FOSise(sTrcode)   '선물옵션 현재가+호가 조회
        ElseIf sTrcode = g_sTrcode_FChe Or sTrcode = g_sTrcode_OChe Then
            Call OnGetData_FOChe(sTrcode)    '선물옵션 체결시세 조회
        ElseIf sTrcode = g_sTrcode_FOCheList Then
            Call OnGetData_FOCheList(sNextGb, sNextKey)  '선물옵션 체결/미체결 내역
        ElseIf sTrcode = g_sTrcode_FOJanList Then
            Call OnGetData_FOJanList(sNextGb, sNextKey)   '선물옵션 잔고내역 조회
        ElseIf sTrcode = g_sTrcode_FOBSOrder Or sTrcode = g_sTrcode_FOMCOrder Then  '매수/매도/정정/취소 주문
            Dim sOrdNo = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", "ORD_NO", 0)) '주문번호
            If Val(sOrdNo) > 0 Then
                TB_FOOrdNo.Text = sOrdNo
                Call Requset_FOCheList("")  '선물옵션 체결내역 조회
                Call Requset_FOJanList("")  '선물옵션 잔고내역 조회
            End If
        End If

        '조건검색
        If sTrcode = g_sTrcode_007 Then
            Call OnGetData_007()
        ElseIf sTrcode = g_sTrcode_027 Then
            Call OnGetData_027()
        ElseIf sTrcode = g_sTrcode_028 Then
            Call OnGetData_028()
        End If

    End Sub

    '================================
    ' FID 조회 응답 처리
    '================================
    Private Sub AxChampionCommAgent1_OnGetFidData(sender As Object, e As AxChampionCommAgentLib._DChampionCommAgentEvents_OnGetFidDataEvent) Handles AxChampionCommAgent1.OnGetFidData
        Dim sTrcode As String
        Dim sNextGb As String
        Dim sNextKey As String
        Dim sMsg As String
        Dim sSubMsg As String
        Dim sErrCode As String

        sTrcode = AxChampionCommAgent1.GetCommRecvOptionValue(0)    'TR 코드
        sNextGb = AxChampionCommAgent1.GetCommRecvOptionValue(1)    '연속조회구분(0:없음, 4:다음없음, 5:다음없음, 6:다음있음, 7:다음있음)
        sNextKey = AxChampionCommAgent1.GetCommRecvOptionValue(2)   '연속조회키
        sMsg = AxChampionCommAgent1.GetCommRecvOptionValue(4)       '메세지
        sSubMsg = AxChampionCommAgent1.GetCommRecvOptionValue(5)    '부가메세지
        sErrCode = AxChampionCommAgent1.GetCommRecvOptionValue(7)   '에러여부

        Dim nDataCnt As Long    '조회건수
        nDataCnt = AxChampionCommAgent1.GetFidOutputRowCnt(e.nRequestId)

        Dim sOutPut As String   '조회데이터
        Dim fOutVal As Double
        Dim nOutVal As Long
        Dim sCode As String     '종목코드
        Dim sRate As String     '등락률

        Dim sColText(12) As String
        sColText(0) = ""

        Dim i As Long
        Dim lvitem As ListViewItem
        '관심종목 FID조회 응답 처리
        If sTrcode = g_sTrcode_Kwansim Then ' "153,154,000,002,003,004,011,012,013,014,015"
            LV_Kwansim.Items.Clear()
            For i = 0 To (nDataCnt - 1)
                sOutPut = Trim(AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "153", i))   ' 표준코드로 조회
                sCode = AxChampionCommAgent1.GetShCode(sOutPut)   ' 표준코드를 단축코드로 변환
                sColText(1) = sCode

                sOutPut = Trim(AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "154", i))   '종목명
                sColText(2) = sOutPut

                sOutPut = AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "000", i)   '현재가
                nOutVal = Val(sOutPut)
                sColText(3) = nOutVal.ToString("###,##0")

                sOutPut = AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "002", i)   '전일대비
                nOutVal = Val(sOutPut)
                sColText(4) = nOutVal.ToString("###,##0")

                sOutPut = AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "003", i)   '등락률(소수점 미포함)
                sRate = CStr(Math.Round(Val(sOutPut) / 100, 2)) & "%"
                sColText(5) = sRate

                sOutPut = AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "004", i)   '거래량
                nOutVal = Val(sOutPut)
                sColText(6) = nOutVal.ToString("###,##0")

                sOutPut = AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "011", i)   '상한가
                nOutVal = Val(sOutPut)
                sColText(7) = nOutVal.ToString("###,##0")

                sOutPut = AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "012", i)   '하한가
                nOutVal = Val(sOutPut)
                sColText(8) = nOutVal.ToString("###,##0")

                sOutPut = AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "013", i)   '시가
                nOutVal = Val(sOutPut)
                sColText(9) = nOutVal.ToString("###,##0")

                sOutPut = AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "014", i)   '고가
                nOutVal = Val(sOutPut)
                sColText(10) = nOutVal.ToString("###,##0")

                sOutPut = AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "015", i)   '저가
                nOutVal = Val(sOutPut)
                sColText(11) = nOutVal.ToString("###,##0")

                lvitem = New ListViewItem(sColText)
                LV_Kwansim.Items.Insert(0, lvitem)
            Next
        ElseIf sTrcode = g_sTrcode_gbKwansim Then ' "153,154,000,002,003,004,011,012,013,014,015"
            LV_GBKwansim.Items.Clear()
            Dim sFormat As String
            For i = 0 To (nDataCnt - 1)
                sOutPut = Trim(AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "153", i))   ' 표준코드로 조회
                sCode = AxChampionCommAgent1.GetShCode(sOutPut)   ' 표준코드를 단축코드로 변환
                sColText(1) = sCode

                sFormat = GetOverStockPlaces(sCode)
                sOutPut = Trim(AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "154", i))   '종목명
                sColText(2) = sOutPut

                sOutPut = AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "000", i)   '현재가
                fOutVal = Val(sOutPut) / 10000
                sColText(3) = fOutVal.ToString(sFormat)

                sOutPut = AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "002", i)   '전일대비
                fOutVal = Val(sOutPut) / 10000
                sColText(4) = fOutVal.ToString(sFormat)

                sOutPut = AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "003", i)   '등락률(소수점 미포함)
                sRate = CStr(Math.Round(Val(sOutPut) / 100, 2)) & "%"
                sColText(5) = sRate

                sOutPut = AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "004", i)   '거래량
                nOutVal = Val(sOutPut)
                sColText(6) = nOutVal.ToString("###,##0")

                sOutPut = AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "011", i)   '상한가
                fOutVal = Val(sOutPut) / 10000
                sColText(7) = fOutVal.ToString(sFormat)

                sOutPut = AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "012", i)   '하한가
                fOutVal = Val(sOutPut) / 10000
                sColText(8) = fOutVal.ToString(sFormat)

                sOutPut = AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "013", i)   '시가
                fOutVal = Val(sOutPut) / 10000
                sColText(9) = fOutVal.ToString(sFormat)

                sOutPut = AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "014", i)   '고가
                fOutVal = Val(sOutPut) / 10000
                sColText(10) = fOutVal.ToString(sFormat)

                sOutPut = AxChampionCommAgent1.GetFidOutputData(e.nRequestId, "015", i)   '저가
                fOutVal = Val(sOutPut) / 10000
                sColText(11) = fOutVal.ToString(sFormat)

                lvitem = New ListViewItem(sColText)
                LV_GBKwansim.Items.Add(lvitem)
            Next
        End If
    End Sub

    '================================
    ' 호가 시세 실시간 수신 처리
    '================================
    Private Sub OnGetRealData_Hoga(nPBID As Short)
        Dim sRealData As String
        Dim nRealVal As Long
        Dim sRealItem As String '실시간 아이템명
        Dim sIdx As String      '실시간 아이템명 순번
        Dim sTime As String     '호가 시간

        sRealData = AxChampionCommAgent1.GetRealOutputData(nPBID, "SCODE")    '표준종목코드

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LTOTOFFERPRE"))   '총매도잔량변동수량
        nRealVal = Val(sRealData)
        LV_HogaTot.Items.Item(0).SubItems(1).Text = nRealVal.ToString("###,##0")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LTOTOFFER"))      '총매도수량
        nRealVal = Val(sRealData)
        LV_HogaTot.Items.Item(0).SubItems(2).Text = nRealVal.ToString("###,##0")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LTIME"))    '시간
        If sRealData.Length = 5 Then
            sRealData = "0" & sRealData
        End If
        sTime = Strings.Left(sRealData, 2) & ":" & Strings.Mid(sRealData, 3, 2) & ":" & Strings.Right(sRealData, 2)
        LV_HogaTot.Items.Item(0).SubItems(3).Text = sTime

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LTOTBID"))    '총매수수량
        nRealVal = Val(sRealData)
        LV_HogaTot.Items.Item(0).SubItems(4).Text = nRealVal.ToString("###,##0")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LTOTBIDPRE")) '총매수잔량변동수량
        nRealVal = Val(sRealData)
        LV_HogaTot.Items.Item(0).SubItems(5).Text = nRealVal.ToString("###,##0")

        Dim nAskRow As Integer      '매도호가 Row 위치
        Dim nBidRow As Integer      '매수호가 Row 위치
        nAskRow = 9
        nBidRow = 0

        Dim i As Integer
        For i = 1 To 10
            '2호가부터 Row위치 변경
            If i > 1 Then
                nAskRow = nAskRow - 1
                nBidRow = nBidRow + 1
            End If

            sIdx = Trim(CStr(i)) ' 문자형 변환후 공백제거

            sRealItem = "LOFFER" & sIdx
            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, sRealItem))       '매도 호가
            nRealVal = Val(sRealData)
            LV_MedoHoga.Items.Item(nAskRow).SubItems(3).Text = nRealVal.ToString("###,###")

            sRealItem = "LOFFERREST" & sIdx
            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, sRealItem))       '매도 잔량
            nRealVal = Val(sRealData)
            LV_MedoHoga.Items.Item(nAskRow).SubItems(2).Text = nRealVal.ToString("###,###")

            sRealItem = "LOFFERRESTPRE" & sIdx
            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, sRealItem))       '매도직전잔량
            nRealVal = Val(sRealData)
            LV_MedoHoga.Items.Item(nAskRow).SubItems(1).Text = nRealVal.ToString("###,###")

            sRealItem = "LBID" & sIdx
            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, sRealItem))       '매수 호가
            nRealVal = Val(sRealData)
            LV_MesuHoga.Items.Item(nBidRow).SubItems(3).Text = nRealVal.ToString("###,###")

            sRealItem = "LBIDREST" & sIdx
            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, sRealItem))       '매수 잔량
            nRealVal = Val(sRealData)
            LV_MesuHoga.Items.Item(nBidRow).SubItems(4).Text = nRealVal.ToString("###,###")

            sRealItem = "LBIDRESTPRE" & sIdx
            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, sRealItem))       '매수직전잔량
            nRealVal = Val(sRealData)
            LV_MesuHoga.Items.Item(nBidRow).SubItems(5).Text = nRealVal.ToString("###,###")
        Next
    End Sub

    '================================
    ' 체결 시세 실시간 수신 처리
    '================================
    Private Sub OnGetRealData_Che(nPBID As Short)
        Dim sRealData As String
        Dim nRealVal As Long
        Dim sTime As String

        Dim sColText(4) As String
        sColText(0) = ""

        Dim lvitem As ListViewItem

        Dim nRowCnt As Integer
        nRowCnt = LV_CheSise.Items.Count

        If nRowCnt > 19 Then
            LV_CheSise.Items.RemoveAt(nRowCnt - 1)
        End If

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LTIME"))    '시간
        If sRealData.Length = 5 Then
            sRealData = "0" & sRealData
        End If
        sTime = Strings.Left(sRealData, 2) & ":" & Strings.Mid(sRealData, 3, 2) & ":" & Strings.Right(sRealData, 2)
        sColText(1) = sTime

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LCPRICE"))  '현재가
        nRealVal = Val(sRealData)
        sColText(2) = nRealVal.ToString("###,##0")
        LV_Sise.Items.Item(0).SubItems(1).Text = nRealVal.ToString("###,##0")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LCURVOLUME"))  '체결량
        nRealVal = Val(sRealData)
        sColText(3) = nRealVal.ToString("###,##0")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LDIFF"))    '전일대비
        nRealVal = Val(sRealData)
        LV_Sise.Items.Item(1).SubItems(1).Text = nRealVal.ToString("###,##0")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LVOLUME"))  '누적거래량
        nRealVal = Val(sRealData)
        LV_Sise.Items.Item(2).SubItems(1).Text = nRealVal.ToString("###,##0")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LOPRICE"))  '시가
        nRealVal = Val(sRealData)
        LV_Sise.Items.Item(3).SubItems(1).Text = nRealVal.ToString("###,##0")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LHPRICE"))  '고가
        nRealVal = Val(sRealData)
        LV_Sise.Items.Item(4).SubItems(1).Text = nRealVal.ToString("###,##0")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LLPRICE"))  '저가
        nRealVal = Val(sRealData)
        LV_Sise.Items.Item(5).SubItems(1).Text = nRealVal.ToString("###,##0")

        lvitem = New ListViewItem(sColText)
        LV_CheSise.Items.Insert(0, lvitem)
    End Sub

    '================================
    ' 주문 체결/미체결 실시간 통보 처리([191]RSC)
    '================================
    Private Sub OnGetRealData_CheList(nPBID As Short)
        Dim sRealData As String
        Dim nRealVal As Long

        Dim sOrdNo As String    '주문번호
        Dim sJmCode As String   '종목코드
        Dim sJmName As String   '종목명
        Dim nOrdPrc As Long     '주문가격
        Dim nOrdQty As Long     '주문수량
        Dim nCheQty As Long     '체결수량
        Dim nMiCheQty As Long   '미체결수량
        Dim sOrdTypeNm As String    '주문유형
        Dim sTradeGb As String      '매매구분
        Dim sOrdTime As String      '주문시간

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "ORDERNO"))   '주문번호
        nRealVal = Val(sRealData)   '앞에 '0' 제거
        sOrdNo = nRealVal.ToString()

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "EXPCODE"))     '종목코드
        sJmCode = AxChampionCommAgent1.GetShCode(sRealData)

        sJmName = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "HNAME"))      '종목명

        '매매구분(매수,매도)(첨부문서참조)
        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "MEDOSU"))
        If sRealData = "1" Then
            sTradeGb = "매도"
        Else
            sTradeGb = "매수"
        End If

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "JPRC"))  '주문가격
        nOrdPrc = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "JQTY"))    '주문수량
        nOrdQty = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "CHEQTY"))   '체결수량
        nCheQty = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "MICHEQTY"))   '미체결수량
        nMiCheQty = Val(sRealData)

        '매매구분(010:지정가, 020:시장가, 030:조건부지정가, 040:최유리지정가, 050:최우선지정가)(첨부문서참조)
        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "MEMEGB"))
        If sRealData = "020" Then
            sOrdTypeNm = "시장가"
        ElseIf sRealData = "030" Then
            sOrdTypeNm = "조건부지정가"
        ElseIf sRealData = "040" Then
            sOrdTypeNm = "최유리지정가"
        ElseIf sRealData = "050" Then
            sOrdTypeNm = "최우선지정가"
        Else
            sOrdTypeNm = "지정가"
        End If

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "CHETIME")) '주문/체결시간
        If sRealData.Length = 5 Then
            sRealData = "0" & sRealData
        End If
        sOrdTime = Strings.Left(sRealData, 2) & ":" & Strings.Mid(sRealData, 3, 2) & ":" & Strings.Right(sRealData, 2)

        Dim sRealMsg As String
        sRealMsg = "종   목 : " & sJmName & "(" & sJmCode & ")" & vbCrLf
        sRealMsg = sRealMsg & "주문번호 : " & sOrdNo & vbCrLf
        sRealMsg = sRealMsg & "매매구분 : " & sTradeGb & vbCrLf
        sRealMsg = sRealMsg & "주문유형 : " & sOrdTypeNm & vbCrLf
        sRealMsg = sRealMsg & "주문수량 : " & nOrdQty.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "주문가격 : " & nOrdPrc.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "체결수량 : " & nCheQty.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "미체결수량 : " & nMiCheQty.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "체결시간 : " & sOrdTime
        MsgBox(sRealMsg, MsgBoxStyle.OkOnly, "[주문 체결/미체결 실시간 통보 확인]")
    End Sub

    '================================
    ' 잔고 실시간 통보 처리([192]RSJ)
    '================================
    Private Sub OnGetRealData_JanList(nPBID As Short)
        Dim sRealData As String
        Dim sJmCode As String
        Dim sJmName As String
        Dim nJanQty As Integer  '잔고수량(보유수량)
        Dim nOrdQty As Integer  '주문가능수량
        Dim nCurPrc As Integer  '현재가
        Dim nOrdPrc As Integer  '매입단가
        Dim nSonick As Long     '평가손익

        sJmCode = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "ITEM_COD"))     '종목코드
        sJmCode = AxChampionCommAgent1.GetShCode(sJmCode)   '단축코드 변환

        sJmName = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "HNAME"))      '종목명

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "BQTY"))    '보유수량
        nJanQty = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "ORDGAQTY"))   '주문가능수량
        nOrdQty = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "BUYAMT"))      '매입단가
        nOrdPrc = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "PRICE"))     '현재가
        nCurPrc = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "ESTSONIK"))      '평가손익
        nSonick = Val(sRealData)

        Dim sRealMsg As String
        sRealMsg = "종  목 : " & sJmName & "(" & sJmCode & ")" & vbCrLf
        sRealMsg = sRealMsg & "보유수량 : " & nJanQty.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "주문가능수량 : " & nOrdQty.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "매입단가 : " & nOrdPrc.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "현 재 가 : " & nCurPrc.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "평가손익 : " & nSonick.ToString("###,##0") & vbCrLf
        MsgBox(sRealMsg, MsgBoxStyle.OkOnly, "[잔고 실시간 통보 확인]")
    End Sub

    '================================
    ' 실시간 응답 처리
    '================================
    Private Sub AxChampionCommAgent1_OnGetRealData(sender As Object, e As AxChampionCommAgentLib._DChampionCommAgentEvents_OnGetRealDataEvent) Handles AxChampionCommAgent1.OnGetRealData

        '시세 실시간
        If e.nPBID = 1 Then '주식종목 우선호가(S01)
            Call OnGetRealData_Hoga(e.nPBID)
        ElseIf e.nPBID = 21 Then  '주식,ELW종목 체결시세(S00)
            Call OnGetRealData_Che(e.nPBID)
        ElseIf e.nPBID = 230 Then '해외주식 체결시세(G00)
            Call OnGetRealData_GBChe(e.nPBID)
        ElseIf e.nPBID = 231 Then  '해외주식 호가(G01)
            Call OnGetRealData_GBHoga(e.nPBID)
        ElseIf e.nPBID = 51 Or e.nPBID = 52 Then  '지수선물 호가(F01) / 지수선물 체결(O01)
            OnGetRealData_FOHoga(e.nPBID)
        ElseIf e.nPBID = 65 Or e.nPBID = 66 Then  '지수선물 체결(F00) / 지수옵션 체결(O00)
            OnGetRealData_FOChe(e.nPBID)
        End If

        '주문체결 실시간
        If e.nPBID = 191 Then '국내주식 주문/체결 통보
            Call OnGetRealData_CheList(e.nPBID)
        ElseIf e.nPBID = 192 Then '국내주식 잔고통보
            Call OnGetRealData_JanList(e.nPBID)
        ElseIf e.nPBID = 193 Then '선물옵션 주문/체결 통보
            Call OnGetRealData_FOCheList(e.nPBID)
        ElseIf e.nPBID = 194 Then '선물옵션 잔고통보
            Call OnGetRealData_FOJanList(e.nPBID)
        ElseIf e.nPBID = 204 Then '해외주식 주문/체결 통보
            Call OnGetRealData_GBCheList(e.nPBID)
        ElseIf e.nPBID = 205 Then '해외주식 잔고통보
            Call OnGetRealData_GBJanList(e.nPBID)
        End If

        '조건검색
        If e.nPBID = 154 Then '조건검색 실시간
            Dim sRealData As String
            Dim sJmCode As String
            Dim sJmName As String
            Dim nCurPrc As Long     '현재가
            Dim nOpenPrc As Long    '시가
            Dim nHighPrc As Long    '고가
            Dim nLowPrc As Long     '저가
            Dim nVolume As Long     '거래량

            sJmCode = Trim(AxChampionCommAgent1.GetRealOutputData(e.nPBID, "sItemCode"))    '종목코드
            sJmName = Trim(AxChampionCommAgent1.GetRealOutputData(e.nPBID, "sItemName"))    '종목명

            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(e.nPBID, "sPrice"))   '현재가
            nCurPrc = Val(sRealData)

            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(e.nPBID, "sOpen"))   '시가
            nOpenPrc = Val(sRealData)

            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(e.nPBID, "sHigh"))   '고가
            nHighPrc = Val(sRealData)

            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(e.nPBID, "sLow"))   '저가
            nLowPrc = Val(sRealData)

            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(e.nPBID, "sVolume"))   '거래량
            nVolume = Val(sRealData)

            Dim sRealMsg As String
            sRealMsg = "종   목 : " & sJmName & "(" & sJmCode & ")" & vbCrLf
            sRealMsg = sRealMsg & "현재가 : " & nCurPrc.ToString("###,##0") & vbCrLf
            sRealMsg = sRealMsg & "시   가 : " & nOpenPrc.ToString("###,##0") & vbCrLf
            sRealMsg = sRealMsg & "고   가 : " & nHighPrc.ToString("###,##0") & vbCrLf
            sRealMsg = sRealMsg & "저   가 : " & nLowPrc.ToString("###,##0") & vbCrLf
            sRealMsg = sRealMsg & "거래량 : " & nVolume.ToString("###,##0") & vbCrLf
            TB_RealMsg.Text = sRealMsg
        End If

    End Sub

    Protected Overrides Sub WndProc(ByRef m As Message)
        If m.Msg = 7422 Then
            If m.LParam.ToInt32 = 1 Then
                g_nVersionPassKey = m.WParam.ToInt32
            Else
                g_nVersionPassKey = 0
            End If

            If g_nVersionPassKey > 0 Then
                Btn_Login.Enabled = True
                Btn_Login.Select()
            End If
        End If
        MyBase.WndProc(m)
    End Sub

    Private Sub Btn_VerChk_Click(sender As Object, e As EventArgs) Handles Btn_VerChk.Click

        Call Crtl_Init()    '컨트롤 상태 및 전역변수 초기화

        ' 자신의 윈도우 핸들 찾기
        Dim nHwnd As Long
        nHwnd = FindWindow(vbNullString, "유진투자증권 OPENAPI(VB)")

        ' Open API가 설치된 경로를 레지스트리에서 가져온다.
        Dim readValue = My.Computer.Registry.GetValue("HKEY_CURRENT_USER\Software\EugeneFN\Champion", "PATH", Nothing)
        g_sOpenAPI_PATH = CType(readValue, String)

        ' 실행모듈 Path경로 설정(외부모듈에서 사용)
        SetCurrentDirectory(g_sOpenAPI_PATH)

        '버전처리 프로그램 실행
        Dim sRunPath As String
        sRunPath = g_sOpenAPI_PATH & "\ChampionOpenAPIVersionProcess.exe /" & nHwnd.ToString()
        Dim RetVal = Shell(sRunPath, vbNormalNoFocus)

    End Sub

    Private Sub Btn_Login_Click(sender As Object, e As EventArgs) Handles Btn_Login.Click

        If (AxChampionCommAgent1 Is Nothing) Then
            MsgBox("Open API 모듈 로드에 실패 하였습니다. 재실행 해주세요.")
            Exit Sub
        End If

        Dim sID As String       '로그인ID
        sID = TB_ID.Text

        Dim sPwd As String      '비밀번호
        sPwd = TB_Pwd.Text

        Dim sCretPwd As String  '인증비밀번호
        sCretPwd = TB_CretPwd.Text

        Dim sPartnerCode As String       '필요시 제휴사코드 입력
        sPartnerCode = ComCode.Text

        If Len(sID) = 0 Then
            MsgBox("로그인ID 입력을 확인 바랍니다.")
            Exit Sub
        End If

        If Len(sPwd) = 0 Then
            MsgBox("비밀번호 입력을 확인 바랍니다.")
            Exit Sub
        End If

        If Len(sCretPwd) = 0 Then
            'MsgBox("인증비밀번호 입력을 확인 바랍니다.")
            If MsgBox("시세전용으로 로그인 하시겠습니까?" & vbCrLf & "인증서 비밀번호를 입력하시려면 취소를 누르십시오.", MsgBoxStyle.OkCancel, "확인") = 2 Then
                TB_CretPwd.Select()
                Exit Sub
            End If
        End If
        
        Dim nRtn As Integer
        If ChkPartner.Checked = 0 Then
            nRtn = AxChampionCommAgent1.CommLogin(g_nVersionPassKey, sID, sPwd, sCretPwd)   '일반로그인
        Else
            nRtn = AxChampionCommAgent1.CommLoginPartner(g_nVersionPassKey, sID, sPwd, sCretPwd, sPartnerCode)  '제휴사 로그인
        End If


        If nRtn = 0 Then
            g_sLoginId = sID
            g_bLogin = True
            g_sMsg = "로그인 성공"
            Btn_Logout.Enabled = True
            Btn_Search.Enabled = True
            Btn_SetReal.Enabled = True
            Btn_UnReal.Enabled = True
            Btn_Kwansim.Enabled = True

            Btn_GBSearch.Enabled = True
            Btn_GBSetReal.Enabled = True
            Btn_GBUnReal.Enabled = True
            Btn_GBKwansim.Enabled = True

            Btn_FOSearch.Enabled = True
            Btn_FOSetReal.Enabled = True
            Btn_FOUnReal.Enabled = True
            MsgBox(g_sMsg)
        Else
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "로그인 실패")
        End If
    End Sub

    Private Sub Btn_Logout_Click(sender As Object, e As EventArgs) Handles Btn_Logout.Click
        Call SetLogout()
    End Sub

    Private Sub TB_JmCode_KeyUp(sender As Object, e As KeyEventArgs) Handles TB_JmCode.KeyUp
        If e.KeyValue = Keys.Enter Then
            If g_bLogin = False Then
                MsgBox("로그인 상태를 확인 바랍니다.")
                Exit Sub
            Else
                Btn_Search.PerformClick()
            End If
        End If

    End Sub

    Private Sub Btn_Search_Click(sender As Object, e As EventArgs) Handles Btn_Search.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Call AxChampionCommAgent1.AllUnRegisterReal()
        g_bSetReal = False

        Dim sJmCode As String
        sJmCode = TB_JmCode.Text
        If Len(sJmCode) = 0 Then
            MsgBox("종목코드 입력을 확인 해주세요.")
            Exit Sub
        End If

        Dim nMarketGb As Integer
        nMarketGb = AxChampionCommAgent1.GetMarketKubun(sJmCode, "")    '종목 시장구분 조회(1:코스피, 2:코스닥,...)
        If nMarketGb < 1 Or nMarketGb > 8 Then
            MsgBox("주식 종목코드를 확인 해주세요.")
            Exit Sub
        End If

        Call Requset_Sise(sJmCode)
        Call Requset_Hoga(sJmCode)
        Call Requset_Che(sJmCode)
    End Sub

    Private Sub Btn_Kwansim_Click(sender As Object, e As EventArgs) Handles Btn_Kwansim.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Dim sFidCodes As String 'Fid조회 종목코드 리스트
        Dim sFidNums As String  'Fid조회 항목 리스트

        sFidNums = "153,154,000,002,003,004,011,012,013,014,015"
        sFidCodes = "006400,373220,003670,000660,005930,000270,035420,035720,024110,001040"

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.RequestPortfolioFid(nRqId, g_sTrcode_Kwansim, sFidNums, sFidCodes, 44, 20) ' 44(,)

        If nRtn <= 0 Then
            g_sMsg = "관심종목 FID조회 요청 실패"
            MsgBox(g_sMsg)
        End If
    End Sub

    Private Sub TB_AccPwd_KeyUp(sender As Object, e As KeyEventArgs) Handles TB_AccPwd.KeyUp
        If e.KeyValue = Keys.Enter Then
            If g_bLogin = False Then
                MsgBox("로그인 상태를 확인 바랍니다.")
                Exit Sub
            Else
                Call Requset_CheList("")
                Call Requset_JanList("")
            End If
        End If
    End Sub

    Private Sub Btn_BuyOrd_Click(sender As Object, e As EventArgs) Handles Btn_BuyOrd.Click
        Call SendBSOrder(True)
    End Sub

    Private Sub Btn_SellOrd_Click(sender As Object, e As EventArgs) Handles Btn_SellOrd.Click
        Call SendBSOrder(False)
    End Sub

    Private Sub Btn_ModifyOrd_Click(sender As Object, e As EventArgs) Handles Btn_ModifyOrd.Click
        Call SendMCOrder(True)
    End Sub

    Private Sub Btn_CancelOrd_Click(sender As Object, e As EventArgs) Handles Btn_CancelOrd.Click
        Call SendMCOrder(False)
    End Sub

    Private Sub Btn_CheList_Click(sender As Object, e As EventArgs) Handles Btn_CheList.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Call Requset_CheList("")
    End Sub

    Private Sub Btn_CheNext_Click(sender As Object, e As EventArgs) Handles Btn_CheNext.Click
        Call Requset_CheList(g_sNextKey_Che)
    End Sub

    Private Sub Btn_JanList_Click(sender As Object, e As EventArgs) Handles Btn_JanList.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Call Requset_JanList("")
    End Sub

    Private Sub Btn_JanNext_Click(sender As Object, e As EventArgs) Handles Btn_JanNext.Click
        If Len(g_sNextKey_Jan) > 0 Then
            Requset_JanList(g_sNextKey_Jan)
        Else
            MsgBox("다음조회 내역이 없습니다.")
        End If
    End Sub

    '================================
    ' 체결/미체결 내역 조회 요청
    '================================
    Private Sub Requset_CheList(sNextKey As String)
        g_sNextKey_Che = sNextKey

        If g_sNextKey_Che = "" Then
            LV_CheList.Items.Clear()    '체결/미체결내역 초기화
        End If

        Dim sAccNo As String    '계좌번호
        Dim sAccPwd As String   '계좌비번
        sAccNo = TB_AccNo.Text
        sAccPwd = TB_AccPwd.Text

        If Len(Trim(sAccNo)) = 0 Then
            MsgBox("계좌번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccPwd)) < 4 Then
            MsgBox("계좌 비밀번호를 확인해주세요.")
            Exit Sub
        End If

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_CheList, "InRec1", "ACNO", sAccNo)
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_CheList, "InRec1", "AC_PWD", sAccPwd)
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌 비밀번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_CheList, "InRec1", "ORD_NO", "")              '주문번호(연속조최 키값)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_CheList, "InRec1", "BUY_SEL_TR_TCD", "%")     '조회구분(%:전체, 10:매도, 20:매수)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_CheList, "InRec1", "ITEM_COD", "%")           '종목코드(%:전체)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_CheList, "InRec1", "SORT_TURN_IO1CD", "2")    '주문번호를 기준으로 정순/역순 조회(1:정순, 2:역순)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_CheList, "InRec1", "SCR_QRY_TCD", "01")       '조회구분(01:전체, 02:미체결)

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_CheList, g_sNextKey_Che, 20)
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "체결/미체결내역 조회요청 실패")
        End If
    End Sub


    '================================
    ' 잔고 내역 조회 요청
    '================================
    Private Sub Requset_JanList(sNextKey As String)
        g_sNextKey_Jan = sNextKey

        If g_sNextKey_Jan = "" Then
            LV_JanList.Items.Clear()    '체결/미체결내역 초기화
        End If

        Dim sAccNo As String    '계좌번호
        Dim sAccPwd As String   '계좌비번
        sAccNo = TB_AccNo.Text
        sAccPwd = TB_AccPwd.Text

        If Len(Trim(sAccNo)) = 0 Then
            MsgBox("계좌번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccPwd)) < 4 Then
            MsgBox("계좌 비밀번호를 확인해주세요.")
            Exit Sub
        End If

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_JanList, "InRec1", "ACNO", sAccNo)        '계좌번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_JanList, "InRec1", "AC_PWD", sAccPwd)     '계좌 비밀번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌 비밀번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_JanList, "InRec1", "CMSN_ICLN_YN", "Y")   '수수료포함여부(Y:포함, N:미포함)

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_JanList, g_sNextKey_Jan, 20)
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "잔고내역 조회요청 실패")
        End If
    End Sub

    Private Sub Btn_SetReal_Click(sender As Object, e As EventArgs) Handles Btn_SetReal.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Dim sJmCode As String
        sJmCode = TB_JmCode.Text
        If Len(sJmCode) = 0 Then
            MsgBox("종목코드 입력을 확인 해주세요.")
            Exit Sub
        End If

        Dim nMarketGb As Integer
        nMarketGb = AxChampionCommAgent1.GetMarketKubun(sJmCode, "")    '종목 시장구분 조회(1:코스피, 2:코스닥,...)
        If nMarketGb < 1 Or nMarketGb > 8 Then
            MsgBox("주식 종목코드를 확인 해주세요.")
            Exit Sub
        End If

        '기존에 등록된 실시간이 있다면 모든 실시간을 해제 후 신규 등록
        If g_bSetReal = True Then
            AxChampionCommAgent1.AllUnRegisterReal() '모든 실시간 해제
        End If

        g_bSetReal = True   '실시간 등록

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.RegisterReal(1, sJmCode)  '주식 종목 우선호가
        nRtn = AxChampionCommAgent1.RegisterReal(21, sJmCode) '주식,ELW 종목 체결시세
    End Sub

    Private Sub Btn_UnReal_Click(sender As Object, e As EventArgs) Handles Btn_UnReal.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        If g_bSetReal = True Then
            g_bSetReal = False  '실시간 해제
        End If

        AxChampionCommAgent1.AllUnRegisterReal() '모든 실시간 해제

        '개별 실시간 해제
        'Dim sJmCode As String
        'sJmCode = TB_JmCode.Text
        '
        'If Len(sJmCode) = 0 Then
        '    MsgBox("종목코드 입력을 확인 해주세요")
        '    Exit Sub
        'End If
        'nRtn = ChampionCommAPIExcel.UnRegisterReal(1, sJmCode)    '주식 종목 우선호가 실시간 해제
        'nRtn = ChampionCommAPIExcel.UnRegisterReal(21, sJmCode)   '주식,ELW 종목 체결시세 실시간 해제
    End Sub

    '================================
    ' 해외주식
    '================================

    '입력받은 종목의 소숫점 자리수에 맞게 Format 문자열을 리턴
    Private Function GetOverStockPlaces(sJmCode As String) As String
        Dim sPlaces As String
        sPlaces = AxChampionCommAgent1.GetOverseaStockInfo(sJmCode, 11)  '가격 소수점자리수

        Dim i As Integer
        Dim sFormat As String
        If Val(sPlaces) > 0 Then
            sFormat = "###,##0."
            For i = 1 To Val(sPlaces)
                sFormat = sFormat & "0"
            Next
        Else
            sFormat = "###,##0"
        End If
        GetOverStockPlaces = sFormat
    End Function

    Private Sub Btn_GBSearch_Click(sender As Object, e As EventArgs) Handles Btn_GBSearch.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Call AxChampionCommAgent1.AllUnRegisterReal()
        g_bSetReal = False

        'TB_GBJmCode.Text = "0537AAPL"
        'TB_GBJmCode.Text = "010400700"
        'TB_GBJmCode.Text = "0214000002"
        'TB_GBJmCode.Text = "010409988"

        Dim sJmCode As String
        sJmCode = TB_GBJmCode.Text

        If Len(sJmCode) = 0 Then
            MsgBox("종목코드 입력을 확인 해주세요")
            Exit Sub
        End If

        Dim nMarketGb As Integer
        nMarketGb = AxChampionCommAgent1.GetMarketKubun(sJmCode, "")    '종목 시장구분 조회(91:뉴욕, 92:아멕스, 93:나스닥, 94:상해, 95:심천, 96:홍콩)
        If nMarketGb < 91 Or nMarketGb > 96 Then
            MsgBox("해외주식 종목코드를 확인 해주세요.")
            Exit Sub
        End If

        Call Requset_GBSise(sJmCode)
        Call Requset_GBHoga(sJmCode)
        Call Requset_GBChe(sJmCode)
    End Sub

    '================================
    ' 해외주식 현재가 시세 조회
    '================================
    Private Sub Requset_GBSise(sCode As String)
        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_GBSise, "InRec1", "SCODE", sCode)

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_GBSise, "", 20)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "해외주식 현재가 조회요청 실패")
        End If
    End Sub

    '================================
    ' 해외주식 호가 시세 조회
    '================================
    Private Sub Requset_GBHoga(sCode As String)
        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_GBHoga, "InRec1", "SCODE", sCode)

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_GBHoga, "", 20)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "해외주식 호가 조회요청 실패")
        End If

    End Sub

    '================================
    ' 해외주식 체결 시세 조회
    '================================
    Private Sub Requset_GBChe(sCode As String)
        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbChe, "InRec1", "SCODE", sCode)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbChe, "InRec1", "STP", "A")

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_gbChe, "", 20)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "해외주식 체결시세 조회요청 실패")
        End If
    End Sub

    '================================
    ' 해외주식 현재가 시세조회 응답결과 처리
    '================================
    Private Sub OnGetData_GBSise()
        Dim sOutPut As String
        Dim nOutVal As Long
        Dim fOutVal As Double

        Dim sJmCode = TB_GBJmCode.Text
        If Len(sJmCode) = 0 Then
            Exit Sub
        End If

        Dim sFormat = GetOverStockPlaces(sJmCode)

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbSise, "OutRec1", "SKORNAME", 0)) '종목명
        LB_GBJmName.Text = sOutPut

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbSise, "OutRec1", "LCPRICE", 0)) '현재가
        fOutVal = Val(sOutPut) / 10000
        LV_GBSise.Items.Item(0).SubItems(1).Text = fOutVal.ToString(sFormat)

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbSise, "OutRec1", "LDIFF", 0)) '전일대비
        fOutVal = Val(sOutPut) / 10000
        LV_GBSise.Items.Item(1).SubItems(1).Text = fOutVal.ToString(sFormat)

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbSise, "OutRec1", "LVOLUME", 0)) '거래량
        nOutVal = Val(sOutPut)
        LV_GBSise.Items.Item(2).SubItems(1).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbSise, "OutRec1", "LOPRICE", 0)) '시가    
        fOutVal = Val(sOutPut) / 10000
        LV_GBSise.Items.Item(3).SubItems(1).Text = fOutVal.ToString(sFormat)

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbSise, "OutRec1", "LHPRICE", 0)) '고가
        fOutVal = Val(sOutPut) / 10000
        LV_GBSise.Items.Item(4).SubItems(1).Text = fOutVal.ToString(sFormat)

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbSise, "OutRec1", "LLPRICE", 0)) '저가
        fOutVal = Val(sOutPut) / 10000
        LV_GBSise.Items.Item(5).SubItems(1).Text = fOutVal.ToString(sFormat)

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbSise, "OutRec1", "LULIMITPRICE", 0)) '상한가
        fOutVal = Val(sOutPut) / 10000
        If Val(sOutPut) = 0 Then
            LV_GBSise.Items.Item(6).SubItems(1).Text = ""
        Else
            LV_GBSise.Items.Item(6).SubItems(1).Text = fOutVal.ToString(sFormat)
        End If

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbSise, "OutRec1", "LLLIMITPRICE", 0)) '하한가
        fOutVal = Val(sOutPut) / 10000
        If Val(sOutPut) = 0 Then
            LV_GBSise.Items.Item(7).SubItems(1).Text = ""
        Else
            LV_GBSise.Items.Item(7).SubItems(1).Text = fOutVal.ToString(sFormat)
        End If

        'nOutVal = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbSise, "OutRec1", "LBPRICE", 0)) '기준가
        'fOutVal = Val(sOutPut) / 10000
        'LV_GBSise.Items.Item(8).SubItems(1).Text = fOutVal.ToString(sFormat)
    End Sub

    '================================
    ' 해외주식 호가 시세조회 응답결과 처리
    '================================
    Private Sub OnGetData_GBHoga()
        Dim sOutPut As String
        Dim nOutVal As Long
        Dim fOutVal As Double
        Dim nDataCnt As Integer '조회건수

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbHoga, "OutRec1", "LCNT", 0)) '조회건수
        nDataCnt = Val(sOutPut)
        If nDataCnt = 0 Then
            Exit Sub
        End If

        Dim sJmCode = TB_GBJmCode.Text
        If Len(sJmCode) = 0 Then
            Exit Sub
        End If

        Dim sFormat = GetOverStockPlaces(sJmCode)

        Dim sPrevPrc = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbHoga, "OutRec1", "LLSTCPRICE", 0)) '전일종가
        Dim sCurrPrc = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbHoga, "OutRec1", "LCPRICE", 0)) '현재가

        Dim sOutRecItem As String   '아웃풋 아이템명
        Dim sIdx As String          '아웃풋 아이템명 순번
        Dim nAskRow = 9
        Dim nBidRow = 0

        '1호가 ~ 10호가 처리
        Dim i As Integer
        For i = 1 To 10
            '2호가부터 Row위치 변경
            If i > 1 Then
                nAskRow = nAskRow - 1
                nBidRow = nBidRow + 1
            End If

            sIdx = i.ToString()

            sOutRecItem = "LOFFERRESTPRE" & sIdx
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbHoga, "OutRec1", sOutRecItem, 0)) '매도직전잔량
            nOutVal = Val(sOutPut)
            '0 표시 안함 처리
            If nOutVal = 0 Then
                sOutPut = ""
            Else
                sOutPut = nOutVal.ToString("###,##0")
            End If
            LV_GBMedoHoga.Items.Item(nAskRow).SubItems(1).Text = sOutPut

            sOutRecItem = "LOFFERREST" & sIdx
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbHoga, "OutRec1", sOutRecItem, 0)) '매도 잔량
            nOutVal = Val(sOutPut)
            If nOutVal = 0 Then
                sOutPut = ""
            Else
                sOutPut = nOutVal.ToString("###,##0")
            End If
            LV_GBMedoHoga.Items.Item(nAskRow).SubItems(2).Text = sOutPut

            sOutRecItem = "LOFFER" & sIdx
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbHoga, "OutRec1", sOutRecItem, 0)) '매도 호가
            fOutVal = Val(sOutPut) / 10000
            If fOutVal = 0 Then
                sOutPut = ""
            Else
                sOutPut = fOutVal.ToString(sFormat)
            End If
            LV_GBMedoHoga.Items.Item(nAskRow).SubItems(3).Text = sOutPut

            sOutRecItem = "LBID" & sIdx
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbHoga, "OutRec1", sOutRecItem, 0)) '매수 호가
            fOutVal = Val(sOutPut) / 10000
            If fOutVal = 0 Then
                sOutPut = ""
            Else
                sOutPut = fOutVal.ToString(sFormat)
            End If
            LV_GBMesuHoga.Items.Item(nBidRow).SubItems(3).Text = sOutPut

            sOutRecItem = "LBIDREST" & sIdx
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbHoga, "OutRec1", sOutRecItem, 0)) '매수 잔량
            nOutVal = Val(sOutPut)
            If nOutVal = 0 Then
                sOutPut = ""
            Else
                sOutPut = nOutVal.ToString("###,##0")
            End If
            LV_GBMesuHoga.Items.Item(nBidRow).SubItems(4).Text = sOutPut

            sOutRecItem = "LBIDRESTPRE" & sIdx
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbHoga, "OutRec1", sOutRecItem, 0)) '매수직전잔량
            nOutVal = Val(sOutPut)
            If nOutVal = 0 Then
                sOutPut = ""
            Else
                sOutPut = nOutVal.ToString("###,##0")
            End If
            LV_GBMesuHoga.Items.Item(nBidRow).SubItems(5).Text = sOutPut
        Next

        Dim nSellTotQty As Integer
        Dim nBuyTotQty As Integer
        Dim nNetBuyQty As Integer

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbHoga, "OutRec1", "LTOTOFFERPRE", 0)) '총매도잔량변동수량
        nOutVal = Val(sOutPut)
        LV_GBHogaTot.Items.Item(0).SubItems(1).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbHoga, "OutRec1", "LTOTOFFER", 0)) '총매도수량
        nSellTotQty = Val(sOutPut)
        LV_GBHogaTot.Items.Item(0).SubItems(2).Text = nSellTotQty.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbHoga, "OutRec1", "LTOTBID", 0)) '총매수수량
        nBuyTotQty = Val(sOutPut)
        LV_GBHogaTot.Items.Item(0).SubItems(4).Text = nBuyTotQty.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbHoga, "OutRec1", "LTOTBIDPRE", 0)) '총매수잔량변동수량
        nOutVal = Val(sOutPut)
        LV_GBHogaTot.Items.Item(0).SubItems(5).Text = nOutVal.ToString("###,##0")

        nNetBuyQty = nBuyTotQty - nSellTotQty
        LV_GBHogaTot.Items.Item(0).SubItems(3).Text = nNetBuyQty.ToString("###,##0")    '순매수수량
    End Sub

    '================================
    ' 해외주식 체결 시세조회 응답결과 처리
    '================================
    Private Sub OnGetData_GBChe()
        Dim sOutPut As String
        Dim nOutVal As Long
        Dim fOutVal As Double
        Dim sTime As String

        Dim nDataCnt As Long
        nDataCnt = AxChampionCommAgent1.GetTranOutputRowCnt(g_sTrcode_gbChe, "OutRec1") '조회건수

        LV_GBCheSise.Items.Clear()

        If nDataCnt = 0 Then
            Exit Sub
        End If

        Dim sJmCode = TB_GBJmCode.Text
        If Len(sJmCode) = 0 Then
            Exit Sub
        End If

        Dim sFormat = GetOverStockPlaces(sJmCode)

        Dim sColText(4) As String
        sColText(0) = ""

        Dim lvitem As ListViewItem
        Dim i As Integer
        For i = 0 To nDataCnt - 1
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbChe, "OutRec1", "LTIME", i))        '시간
            If sOutPut.Length = 5 Then
                sOutPut = "0" & sOutPut
            End If
            sTime = Strings.Left(sOutPut, 2) & ":" & Strings.Mid(sOutPut, 3, 2) & ":" & Strings.Right(sOutPut, 2)
            sColText(1) = sTime

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbChe, "OutRec1", "LCPRICE", i))      '현재가(체결가)
            fOutVal = Val(sOutPut) / 10000
            sColText(2) = fOutVal.ToString(sFormat)

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbChe, "OutRec1", "LNETVOLUME", i))   '체결량
            nOutVal = Val(sOutPut)
            sColText(3) = nOutVal.ToString("###,##0")

            lvitem = New ListViewItem(sColText)
            LV_GBCheSise.Items.Add(lvitem)
        Next

    End Sub

    Private Sub Btn_GBSetReal_Click(sender As Object, e As EventArgs) Handles Btn_GBSetReal.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Dim sJmCode As String
        sJmCode = TB_GBJmCode.Text
        If Len(sJmCode) = 0 Then
            MsgBox("종목코드 입력을 확인 해주세요.")
            Exit Sub
        End If

        Dim nMarketGb As Integer
        nMarketGb = AxChampionCommAgent1.GetMarketKubun(sJmCode, "")    '종목 시장구분 조회(91:뉴욕, 92:아멕스, 93:나스닥, 94:상해, 95:심천, 96:홍콩)
        If nMarketGb < 91 Or nMarketGb > 96 Then
            MsgBox("해외주식 종목코드를 확인 해주세요.")
            Exit Sub
        End If

        '기존에 등록된 실시간이 있다면 모든 실시간을 해제 후 신규 등록
        If g_bSetReal = True Then
            AxChampionCommAgent1.AllUnRegisterReal() '모든 실시간 해제
        End If

        g_bSetReal = True   '실시간 등록

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.RegisterReal(230, sJmCode)  '해외주식 체결시세(G00)
        nRtn = AxChampionCommAgent1.RegisterReal(231, sJmCode)  '해외주식 호가(G01)

    End Sub

    Private Sub Btn_GBUnReal_Click(sender As Object, e As EventArgs) Handles Btn_GBUnReal.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        If g_bSetReal = True Then
            g_bSetReal = False  '실시간 해제
        End If

        AxChampionCommAgent1.AllUnRegisterReal() '모든 실시간 해제

        '개별 실시간 해제
        'Dim sJmCode As String
        'sJmCode = TB_GBJmCode.Text
        '
        'If Len(sJmCode) = 0 Then
        '    MsgBox("종목코드 입력을 확인 해주세요")
        '    Exit Sub
        'End If
        'nRtn = ChampionCommAPIExcel.UnRegisterReal(230, sJmCode)
        'nRtn = ChampionCommAPIExcel.UnRegisterReal(231, sJmCode)
    End Sub

    '================================
    ' 해외주식 호가 시세 실시간 수신 처리([231]G01)
    '================================
    Private Sub OnGetRealData_GBHoga(nPBID As Short)
        Dim sRealData As String
        Dim nRealVal As Long
        Dim fRealVal As Double
        Dim sRealItem As String '실시간 아이템명
        Dim sIdx As String      '실시간 아이템명 순번
        Dim sJmCode As String     '호가 시간

        sRealData = AxChampionCommAgent1.GetRealOutputData(nPBID, "SCODE")    '표준종목코드
        sJmCode = sRealData.Trim()
        Dim sFormat = GetOverStockPlaces(sJmCode)

        Dim nSellTotQty As Integer
        Dim nBuyTotQty As Integer
        Dim nNetTotQty As Integer
        sRealData = AxChampionCommAgent1.GetRealOutputData(nPBID, "LTOT_PREOFFERCHA")   '총매도호가직전잔량
        nRealVal = Val(sRealData)
        LV_GBHogaTot.Items.Item(0).SubItems(1).Text = nRealVal.ToString("###,##0")

        sRealData = AxChampionCommAgent1.GetRealOutputData(nPBID, "LTOTOFFERREST")      '총매도호가잔량
        nSellTotQty = Val(sRealData)
        LV_GBHogaTot.Items.Item(0).SubItems(1).Text = nSellTotQty.ToString("###,##0")

        sRealData = AxChampionCommAgent1.GetRealOutputData(nPBID, "LTOTBIDREST")        '총매수호가잔량
        nBuyTotQty = Val(sRealData)
        LV_GBHogaTot.Items.Item(0).SubItems(1).Text = nBuyTotQty.ToString("###,##0")

        sRealData = AxChampionCommAgent1.GetRealOutputData(nPBID, "LTOT_PREBIDCHA")     '총매수호가직전잔량
        nRealVal = Val(sRealData)
        LV_GBHogaTot.Items.Item(0).SubItems(1).Text = nRealVal.ToString("###,##0")

        nNetTotQty = nBuyTotQty - nBuyTotQty
        LV_GBHogaTot.Items.Item(0).SubItems(1).Text = nNetTotQty.ToString("###,##0")

        Dim nAskRow As Integer      '매도호가 Row 위치
        Dim nBidRow As Integer      '매수호가 Row 위치
        nAskRow = 9
        nBidRow = 0

        Dim i As Integer
        For i = 1 To 10
            '2호가부터 Row위치 변경
            If i > 1 Then
                nAskRow = nAskRow - 1
                nBidRow = nBidRow + 1
            End If

            sIdx = Trim(CStr(i)) ' 문자형 변환후 공백제거

            sRealItem = "LOFFER" & sIdx
            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, sRealItem))       '매도 호가
            fRealVal = Val(sRealData) / 10000
            LV_GBMedoHoga.Items.Item(nAskRow).SubItems(3).Text = fRealVal.ToString(sFormat)

            sRealItem = "LOFFERREST" & sIdx
            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, sRealItem))       '매도 잔량
            nRealVal = Val(sRealData)
            LV_GBMedoHoga.Items.Item(nAskRow).SubItems(2).Text = nRealVal.ToString("###,##0")

            sRealItem = "LPREOFFERCHA"
            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, sRealItem))       '매도직전잔량
            nRealVal = Val(sRealData)
            LV_GBMedoHoga.Items.Item(nAskRow).SubItems(1).Text = nRealVal.ToString("###,##0")

            sRealItem = "LBID" & sIdx
            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, sRealItem))       '매수 호가
            fRealVal = Val(sRealData) / 10000
            LV_GBMesuHoga.Items.Item(nBidRow).SubItems(3).Text = fRealVal.ToString(sFormat)

            sRealItem = "LBIDREST" & sIdx
            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, sRealItem))       '매수 잔량
            nRealVal = Val(sRealData)
            LV_GBMesuHoga.Items.Item(nBidRow).SubItems(4).Text = nRealVal.ToString("###,##0")

            sRealItem = "LPREBIDCHA" & sIdx
            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, sRealItem))       '매수직전잔량
            nRealVal = Val(sRealData)
            LV_GBMesuHoga.Items.Item(nBidRow).SubItems(5).Text = nRealVal.ToString("###,##0")
        Next
    End Sub

    '================================
    ' 해외주식 체결 시세 실시간 수신 처리([230]G00)
    '================================
    Private Sub OnGetRealData_GBChe(nPBID As Short)
        Dim sRealData As String
        Dim nRealVal As Long
        Dim fRealVal As Double
        Dim sTime As String
        Dim sJmCode As String
        Dim sFormat As String

        Dim sColText(4) As String
        sColText(0) = ""

        Dim lvitem As ListViewItem

        Dim nRowCnt As Integer
        nRowCnt = LV_GBCheSise.Items.Count

        If nRowCnt > 19 Then
            LV_GBCheSise.Items.RemoveAt(nRowCnt - 1)
        End If

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "SCODE"))    '거래소코드(4)+심볼(16)
        sJmCode = sRealData.Trim()
        sFormat = GetOverStockPlaces(sJmCode)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LLOCTIME"))    '현지시간
        If sRealData.Length = 5 Then
            sRealData = "0" & sRealData
        End If
        sTime = Strings.Left(sRealData, 2) & ":" & Strings.Mid(sRealData, 3, 2) & ":" & Strings.Right(sRealData, 2)
        sColText(1) = sTime

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LCPRICE"))  '현재가
        fRealVal = Val(sRealData) / 10000
        sColText(2) = nRealVal.ToString(sFormat)
        LV_GBSise.Items.Item(0).SubItems(1).Text = fRealVal.ToString(sFormat)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LCURVOLUME"))  '체결량
        nRealVal = Val(sRealData)
        sColText(3) = nRealVal.ToString("###,##0")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LDIFF"))    '전일대비
        fRealVal = Val(sRealData) / 10000
        LV_GBSise.Items.Item(1).SubItems(1).Text = fRealVal.ToString(sFormat)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LVOLUME"))  '누적거래량
        nRealVal = Val(sRealData)
        LV_GBSise.Items.Item(2).SubItems(1).Text = nRealVal.ToString("###,##0")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LOPRICE"))  '시가
        fRealVal = Val(sRealData) / 10000
        LV_GBSise.Items.Item(3).SubItems(1).Text = nRealVal.ToString(sFormat)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LHPRICE"))  '고가
        fRealVal = Val(sRealData) / 10000
        LV_GBSise.Items.Item(4).SubItems(1).Text = nRealVal.ToString(sFormat)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LLPRICE"))  '저가
        fRealVal = Val(sRealData) / 10000
        LV_GBSise.Items.Item(5).SubItems(1).Text = nRealVal.ToString(sFormat)

        lvitem = New ListViewItem(sColText)
        LV_GBCheSise.Items.Insert(0, lvitem)
    End Sub


    '================================
    ' 해외주식 주문 체결/미체결 실시간 통보 처리([204]RGC)
    '================================
    Private Sub OnGetRealData_GBCheList(nPBID As Short)
        Dim sRealData As String
        Dim nRealVal As Long

        Dim sOrdNo As String    '주문번호
        Dim sJmCode As String   '종목코드
        Dim sJmName As String   '종목명
        Dim nOrdPrc As Long     '주문가격
        Dim nOrdQty As Long     '주문수량
        Dim nCheQty As Long     '체결수량
        Dim nMiCheQty As Long   '미체결수량
        Dim sOrdTypeNm As String    '주문유형
        Dim sTradeGb As String      '매매구분
        Dim sOrdTime As String      '주문시간

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "ORD_NO"))   '주문번호
        nRealVal = Val(sRealData)   '앞에 '0' 제거
        sOrdNo = nRealVal.ToString()

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "ITEM_COD"))     '종목코드
        sJmCode = AxChampionCommAgent1.GetShCode(sRealData)

        sJmName = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "HNAME"))      '종목명

        '매매구분(매수,매도)(첨부문서참조)
        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "BUY_SEL_TR_TCD"))
        If sRealData = "1" Then
            sTradeGb = "매도"
        Else
            sTradeGb = "매수"
        End If

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "JPRC"))  '주문가격
        nOrdPrc = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "JQTY"))    '주문수량
        nOrdQty = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "PERCHEQTY"))   '체결수량
        nCheQty = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "MICHEQTY"))   '미체결수량
        nMiCheQty = Val(sRealData)

        '매매구분(첨부문서참조)
        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "ORD_BNS_TCD"))
        If sRealData = "020" Then
            sOrdTypeNm = "시장가"
        ElseIf sRealData = "720" Then
            sOrdTypeNm = "MOO"
        ElseIf sRealData = "740" Then
            sOrdTypeNm = "MOC"
        ElseIf sRealData = "710" Then
            sOrdTypeNm = "LOO"
        ElseIf sRealData = "730" Then
            sOrdTypeNm = "LOC"
        ElseIf sRealData = "750" Then
            sOrdTypeNm = "TWAP"
        ElseIf sRealData = "760" Then
            sOrdTypeNm = "VWAP"
        Else
            sOrdTypeNm = "지정가"
        End If

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "CHETIME")) '주문/체결시간
        If sRealData.Length = 5 Then
            sRealData = "0" & sRealData
        End If
        sOrdTime = Strings.Left(sRealData, 2) & ":" & Strings.Mid(sRealData, 3, 2) & ":" & Strings.Right(sRealData, 2)

        '"0321" : 미국뉴욕종목
        '"0066" : 미국아멕스종목
        '"0537" : 미국나스닥종목
        '"0215" : 중국상해종목
        '"0214" : 중국심천종목
        '"0104" : 홍콩종목

        Dim sRealMsg As String
        sRealMsg = "종   목 : " & sJmName & "(" & sJmCode & ")" & vbCrLf
        sRealMsg = sRealMsg & "주문번호 : " & sOrdNo & vbCrLf
        sRealMsg = sRealMsg & "매매구분 : " & sTradeGb & vbCrLf
        sRealMsg = sRealMsg & "주문유형 : " & sOrdTypeNm & vbCrLf
        sRealMsg = sRealMsg & "주문수량 : " & nOrdQty.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "주문가격 : " & nOrdPrc.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "체결수량 : " & nCheQty.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "미체결수량 : " & nMiCheQty.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "체결시간 : " & sOrdTime
        MsgBox(sRealMsg, MsgBoxStyle.OkOnly, "[해외주식 주문 체결/미체결 실시간 통보 확인]")
    End Sub

    '================================
    ' 해외주식 잔고 실시간 통보 처리([205]RGJ)
    '================================
    Private Sub OnGetRealData_GBJanList(nPBID As Short)
        Dim sRealData As String
        Dim sJmCode As String
        Dim sJmName As String
        Dim nJanQty As Integer  '잔고수량(보유수량)
        Dim nOrdQty As Integer  '주문가능수량
        Dim nCurPrc As Integer  '현재가
        Dim nOrdPrc As Integer  '매입단가
        Dim nSonick As Long     '평가손익

        sJmCode = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "ITEM_COD"))     '종목코드
        sJmCode = AxChampionCommAgent1.GetShCode(sJmCode)   '단축코드 변환

        'sJmName = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "HNAME"))      '종목명

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "BQTY"))    '보유수량
        nJanQty = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "ORDGAQTY"))   '주문가능수량
        nOrdQty = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "BUYAMT"))      '매입단가
        nOrdPrc = Val(sRealData)

        'sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "PRICE"))     '현재가
        'nCurPrc = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LASTTRSONIK"))      '당일실현손익
        nSonick = Val(sRealData)

        Dim sRealMsg As String
        sRealMsg = "종  목 : " & sJmName & "(" & sJmCode & ")" & vbCrLf
        sRealMsg = sRealMsg & "보유수량 : " & nJanQty.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "주문가능수량 : " & nOrdQty.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "매입단가 : " & nOrdPrc.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "현 재 가 : " & nCurPrc.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "평가손익 : " & nSonick.ToString("###,##0") & vbCrLf
        MsgBox(sRealMsg, MsgBoxStyle.OkOnly, "[해외주식 잔고 실시간 통보 확인]")
    End Sub


    Private Sub Btn_GBKwansim_Click(sender As Object, e As EventArgs) Handles Btn_GBKwansim.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Dim sFidCodes As String 'Fid조회 종목코드 리스트
        Dim sFidNums As String  'Fid조회 항목 리스트

        sFidNums = "153,154,000,002,003,004,011,012,013,014,015"
        sFidCodes = "0537AAPL,0537AMZN,0537MSFT,0214000002,0214000333,0215600050,0215601288,010400700,010409988"

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.RequestPortfolioFid(nRqId, g_sTrcode_gbKwansim, sFidNums, sFidCodes, 44, 20) ' 44(,)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "관심종목 FID조회요청 실패")
        End If
    End Sub

    Private Sub Btn_GBBuyOrd_Click(sender As Object, e As EventArgs) Handles Btn_GBBuyOrd.Click
        SendBSOrderGB(True)
    End Sub

    Private Sub Btn_GBSellOrd_Click(sender As Object, e As EventArgs) Handles Btn_GBSellOrd.Click
        SendBSOrderGB(False)
    End Sub

    Private Sub Btn_GBModifyOrd_Click(sender As Object, e As EventArgs) Handles Btn_GBModifyOrd.Click
        SendMCOrderGB(True)
    End Sub

    Private Sub Btn_GBCancelOrd_Click(sender As Object, e As EventArgs) Handles Btn_GBCancelOrd.Click
        SendMCOrderGB(False)
    End Sub

    '================================
    ' 해외주식 매수/매도 주문 전송
    '================================
    Private Sub SendBSOrderGB(bBuy As Boolean)
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Dim sJmCode As String   '종목코드
        Dim sAccNo As String    '계좌번호
        Dim sAccPwd As String   '계좌비번
        Dim sOrdType As String  '주문유형
        Dim sOrdQty As String   '주문수량
        Dim sOrdPrc As String   '주문가격
        Dim sExgGubun As String '거래소구분

        'Dim sTradeGb As String  '매매구분(20:매수, 10:매도)
        'If bBuy = True Then
        '    sTradeGb = "20"
        'Else
        '    sTradeGb = "10"
        'End If
        Dim sTradeGb = If(bBuy, "20", "10") '매매구분(20:매수, 10:매도)

        sJmCode = TB_GBOrdJmCode.Text
        sAccNo = TB_GBAccNo.Text
        sAccPwd = TB_GBAccPwd.Text
        sOrdType = CB_GBOrdType.Text
        sOrdQty = UD_GBOrdQty.Text
        sOrdPrc = TB_GBOrdPrc.Text
        sExgGubun = CB_OrdExgCode.Text

        If Len(Trim(sJmCode)) = 0 Then
            MsgBox("종목코드를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccNo)) = 0 Then
            MsgBox("계좌번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccPwd)) = 0 Then
            MsgBox("계좌 비밀번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sOrdType)) = 0 Then
            MsgBox("주문유형을 선택해주세요.")
            Exit Sub
        End If

        If Val(sOrdQty) = 0 Then
            MsgBox("주문수량을 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sExgGubun)) = 0 Then
            MsgBox("거래소를 선택해주세요.")
            Exit Sub
        End If

        Dim sExgCode As String  '거래소구분코드
        sExgCode = ""
        If sExgGubun = "미국" Then
            sExgCode = "020"
        ElseIf sExgGubun = "중국상해" Then
            sExgCode = "014"
        ElseIf sExgGubun = "중국심천" Then
            sExgCode = "018"
        ElseIf sExgGubun = "홍콩" Then
            sExgCode = "001"
        End If

        '주문유형 코드값 변환
        Dim sOrdTypeCode As String
        If sOrdType = "시장가" Then
            sOrdTypeCode = "020"
        ElseIf sOrdType = "MOO" Then    '장개시 시장가
            sOrdTypeCode = "720"
        ElseIf sOrdType = "MOC" Then    '장마감 시장가
            sOrdTypeCode = "740"
        ElseIf sOrdType = "LOO" Then    '장개시 지정가
            sOrdTypeCode = "710"
        ElseIf sOrdType = "LOC" Then    '장마감 지정가
            sOrdTypeCode = "730"
        ElseIf sOrdType = "TWAP" Then   '시간분할주문
            sOrdTypeCode = "750"
        ElseIf sOrdType = "VWAP" Then   '수량분할주문
            sOrdTypeCode = "760"
        Else
            sOrdTypeCode = "010"        '지정가
        End If

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbBSOrder, "InRec1", "ACNO", sAccNo)              '계좌번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbBSOrder, "InRec1", "AC_PWD", sAccPwd)           '계좌비밀번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌 비밀번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbBSOrder, "InRec1", "EXG_COD", sExgCode)           '거래소코드
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbBSOrder, "InRec1", "ITEM_COD", sJmCode)           '종목코드
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbBSOrder, "InRec1", "ORD_Q", sOrdQty)              '주문수량
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbBSOrder, "InRec1", "FGST_ORD_UPR", sOrdPrc)       '해외증권주문단가
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbBSOrder, "InRec1", "BUY_SEL_TR_TCD", sTradeGb)    '매매구분(10:매수, 20:매도)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbBSOrder, "InRec1", "FGST_BNS_TCD", sOrdTypeCode)  '해외증권주문유형구분
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbBSOrder, "InRec1", "ORD_COND_TCD", "0")           '주문조건구분("0" 으로 고정)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbBSOrder, "InRec1", "EMC_ORD_YN", "N")             '비상주문여부("N" 으로 고정)

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_gbBSOrder, "", 20)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "해외주식 매수/매도 주문전송 실패")
        End If
    End Sub

    '================================
    ' 해외주식 정정/취소 주문 전송
    '================================
    Private Sub SendMCOrderGB(bModify As Boolean)
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Dim sAccNo As String    '계좌번호
        Dim sAccPwd As String   '계좌비번
        Dim sOrdType As String  '주문유형
        Dim sOrdQty As String   '주문수량
        Dim sOrdPrc As String   '주문가격
        Dim sOrgOrdNo As String '원주문번호
        Dim sJmCode As String   '종목코드
        Dim sExgGubun As String '거래소구분

        'Dim sTradeGb As String  '매매구분(20:정정, 30:취소)
        'If bModify = True Then
        '    sTradeGb = "20"
        'Else
        '    sTradeGb = "30"
        'End If
        Dim sTradeGb = If(bModify, "20", "30")  '매매구분(20:정정, 30:취소)

        sJmCode = TB_GBOrdJmCode.Text
        sAccNo = TB_GBAccNo.Text
        sAccPwd = TB_GBAccPwd.Text
        sOrdType = CB_GBOrdType.Text
        sOrdQty = UD_GBOrdQty.Text
        sOrdPrc = TB_GBOrdPrc.Text
        sOrgOrdNo = TB_GBOrgOrdNo.Text
        sExgGubun = CB_OrdExgCode.Text

        If Len(Trim(sJmCode)) = 0 Then
            MsgBox("종목코드를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccNo)) = 0 Then
            MsgBox("계좌번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccPwd)) = 0 Then
            MsgBox("계좌 비밀번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sOrdType)) = 0 Then
            MsgBox("주문유형을 선택해주세요.")
            Exit Sub
        End If

        If Val(sOrdQty) = 0 Then
            MsgBox("주문수량을 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sOrgOrdNo)) = 0 Then
            MsgBox("원주문번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sExgGubun)) = 0 Then
            MsgBox("거래소를 선택해주세요.")
            Exit Sub
        End If

        Dim sExgCode As String  '거래소구분코드
        sExgCode = ""
        If sExgGubun = "미국" Then
            sExgCode = "020"
        ElseIf sExgGubun = "중국상해" Then
            sExgCode = "014"
        ElseIf sExgGubun = "중국심천" Then
            sExgCode = "018"
        ElseIf sExgGubun = "홍콩" Then
            sExgCode = "001"
        End If

        '주문유형 코드값 변환
        Dim sOrdTypeCode As String
        If sOrdType = "시장가" Then
            sOrdTypeCode = "020"
        ElseIf sOrdType = "MOO" Then    '장개시 시장가
            sOrdTypeCode = "720"
        ElseIf sOrdType = "MOC" Then    '장마감 시장가
            sOrdTypeCode = "740"
        ElseIf sOrdType = "LOO" Then    '장개시 지정가
            sOrdTypeCode = "710"
        ElseIf sOrdType = "LOC" Then    '장마감 지정가
            sOrdTypeCode = "730"
        ElseIf sOrdType = "TWAP" Then   '시간분할주문
            sOrdTypeCode = "750"
        ElseIf sOrdType = "VWAP" Then   '수량분할주문
            sOrdTypeCode = "760"
        Else
            sOrdTypeCode = "010"        '지정가
        End If

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbMCOrder, "InRec1", "ACNO", sAccNo)              '계좌번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbMCOrder, "InRec1", "AC_PWD", sAccPwd)           '계좌비밀번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌 비밀번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbMCOrder, "InRec1", "OORD_NO", sOrgOrdNo)            '원주문번호
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbMCOrder, "InRec1", "ORD_MDFY_CNCL_TCD", sTradeGb)   '매매구분(20:정정, 30:취소)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbMCOrder, "InRec1", "PAT_ALL_TCD", "20")             '일부/전부 구분("20"으로 고정)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbMCOrder, "InRec1", "EXG_COD", sExgCode)             '거래소코드
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbMCOrder, "InRec1", "ITEM_COD", sJmCode)             '종목코드
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbMCOrder, "InRec1", "ORD_Q", sOrdQty)                '주문수량
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbMCOrder, "InRec1", "FGST_ORD_UPR", sOrdPrc)         '주문단가
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbMCOrder, "InRec1", "FGST_BNS_TCD", sOrdTypeCode)    '주문유형구분
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbMCOrder, "InRec1", "ORD_COND_TCD", "0")             '주문조건구분("0" 으로 고정)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbMCOrder, "InRec1", "EMC_ORD_YN", "N")               '비상주문여부("N" 으로 고정)

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_gbBSOrder, "", 20)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "해외주식 정정/취소 주문전송 실패")
        End If

    End Sub

    Private Sub TB_GBAccPwd_KeyUp(sender As Object, e As KeyEventArgs) Handles TB_GBAccPwd.KeyUp
        If e.KeyValue = Keys.Enter Then
            If g_bLogin = False Then
                MsgBox("로그인 상태를 확인 바랍니다.")
                Exit Sub
            Else
                Call Requset_GBAccInfo()    '계좌 예수금 조회
                Call Requset_GBCheList("")  '해외주식 체결내역 조회
                Call Requset_GBJanList("")  '해외주식 잔고내역 조회
            End If
        End If
    End Sub

    Private Sub Btn_GBAccInfo_Click(sender As Object, e As EventArgs) Handles Btn_GBAccInfo.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Call Requset_GBAccInfo()
    End Sub

    Private Sub Btn_GBCheList_Click(sender As Object, e As EventArgs) Handles Btn_GBCheList.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        If Rdo_Che.Checked = True Then
            Call Requset_GBCheList("")
        Else
            Call Requset_GBMiCheList("")
        End If
    End Sub

    Private Sub Btn_GBCheNext_Click(sender As Object, e As EventArgs) Handles Btn_GBCheNext.Click

        If Len(g_sNextKey_gbChe) > 0 Then
            If Rdo_Che.Checked = True Then
                Call Requset_GBCheList(g_sNextKey_gbChe)
            Else
                Call Requset_GBMiCheList(g_sNextKey_gbChe)
            End If
        Else
            MsgBox("다음조회 내역이 없습니다.")
        End If
    End Sub

    Private Sub Btn_GBJanList_Click(sender As Object, e As EventArgs) Handles Btn_GBJanList.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Call Requset_GBJanList("")
    End Sub

    Private Sub Btn_GBJanNext_Click(sender As Object, e As EventArgs) Handles Btn_GBJanNext.Click
        If Len(g_sNextKey_gbJan) > 0 Then
            Call Requset_GBJanList(g_sNextKey_gbJan)
        Else
            MsgBox("다음조회 내역이 없습니다.")
        End If
    End Sub

    Private Sub Rdo_Che_CheckedChanged(sender As Object, e As EventArgs) Handles Rdo_Che.CheckedChanged
        DT_GBCheDate.Enabled = True
    End Sub

    Private Sub Rdo_MiChe_CheckedChanged(sender As Object, e As EventArgs) Handles Rdo_MiChe.CheckedChanged
        DT_GBCheDate.Enabled = False
    End Sub

    '================================
    ' 해외주식 예수금 조회(OCA1725Q)
    '================================
    Private Sub Requset_GBAccInfo()
        Dim sAccNo = TB_GBAccNo.Text    '계좌번호
        Dim sAccPwd = TB_GBAccPwd.Text  '계좌비번

        If Len(Trim(sAccNo)) = 0 Then
            MsgBox("계좌번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccPwd)) = 0 Then
            MsgBox("계좌 비밀번호를 입력해주세요.")
            Exit Sub
        End If

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbAccInfo, "InRec1", "ACNO", sAccNo)              '계좌번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbAccInfo, "InRec1", "AC_PWD", sAccPwd)           '계좌비밀번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌 비밀번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_gbAccInfo, "", 20)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "해외주식 예수금 조회요청 실패")
        End If
    End Sub


    '================================
    ' 해외주식 체결내역 조회 응답
    '================================
    Private Sub OnGetData_GBAccInfo()
        Dim sOutPut As String
        Dim nOutVal As Long

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbAccInfo, "OutRec1", "AC_TDA", 0))        '계좌총예수금
        nOutVal = Val(sOutPut)
        LV_AccInfo.Items(0).SubItems(1).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbAccInfo, "OutRec1", "MNYO_ABLE_A", 0))        '출금가능금액
        nOutVal = Val(sOutPut)
        LV_AccInfo.Items(1).SubItems(1).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbAccInfo, "OutRec1", "CSH_DFA", 0))        '현금미수금
        nOutVal = Val(sOutPut)
        LV_AccInfo.Items(2).SubItems(1).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbAccInfo, "OutRec1", "CHCK_A", 0))        '수표금액
        nOutVal = Val(sOutPut)
        LV_AccInfo.Items(3).SubItems(1).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbAccInfo, "OutRec1", "ETC_LND_A", 0))        '기타대여금액
        nOutVal = Val(sOutPut)
        LV_AccInfo.Items(4).SubItems(1).Text = nOutVal.ToString("###,##0")
    End Sub


    '================================
    ' 해외주식 체결내역 조회 요청
    '================================
    Private Sub Requset_GBCheList(sNextKey As String)
        g_sNextKey_gbChe = sNextKey

        If g_sNextKey_gbChe = "" Then
            LV_GBCheList.Items.Clear()    '체결내역 초기화
        End If

        Dim sAccNo = TB_GBAccNo.Text    '계좌번호
        Dim sAccPwd = TB_GBAccPwd.Text  '계좌비번

        If Len(Trim(sAccNo)) = 0 Then
            MsgBox("계좌번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccPwd)) < 4 Then
            MsgBox("계좌 비밀번호를 확인해주세요.")
            Exit Sub
        End If

        Dim sExgCode As String
        If CB_CheExgCode.Text = "미국" Then
            sExgCode = "020"
        ElseIf CB_CheExgCode.Text = "중국상해" Then
            sExgCode = "014"
        ElseIf CB_CheExgCode.Text = "중국심천" Then
            sExgCode = "018"
        ElseIf CB_CheExgCode.Text = "홍콩" Then
            sExgCode = "001"
        Else
            sExgCode = "%"  '전체
        End If

        If Len(Trim(sExgCode)) = 0 Then
            MsgBox("거래소를 입력해주세요.")
            Exit Sub
        End If

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbCheList, "InRec1", "ACNO", sAccNo)          '계좌번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbCheList, "InRec1", "AC_PWD", sAccPwd)       '계좌비밀번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌 비밀번호 입력 에러")
            Exit Sub
        End If

        Dim sOrderDate = DT_GBCheDate.Value.ToString("yyyyMMdd")
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbCheList, "InRec1", "ORD_DT", sOrderDate)    '주문일자
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbCheList, "InRec1", "BUY_SEL_TR_TCD", "%")   '조회구분(%:전체, 10:매도, 20:매수)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbCheList, "InRec1", "ORD_RJT_YN", "%")       '주문거부여부(%:전체, N:완료, Y:거부)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbCheList, "InRec1", "EXG_COD", sExgCode)     '거래소코드(%:전체, 020:미국, 014:중국상해, 018:중국심천, 001:홍콩)

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_gbCheList, g_sNextKey_gbChe, 20)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "해외주식 체결내역 조회요청 실패")
        End If
    End Sub


    '================================
    ' 해외주식 미체결내역 조회 요청
    '================================
    Private Sub Requset_GBMiCheList(sNextKey As String)
        g_sNextKey_gbChe = sNextKey

        If g_sNextKey_gbChe = "" Then
            LV_GBCheList.Items.Clear()    '미체결내역 초기화
        End If

        Dim sAccNo = TB_GBAccNo.Text    '계좌번호
        Dim sAccPwd = TB_GBAccPwd.Text  '계좌비번

        If Len(Trim(sAccNo)) = 0 Then
            MsgBox("계좌번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccPwd)) < 4 Then
            MsgBox("계좌 비밀번호를 확인해주세요.")
            Exit Sub
        End If

        Dim sExgCode As String
        If CB_CheExgCode.Text = "미국" Then
            sExgCode = "020"
        ElseIf CB_CheExgCode.Text = "중국상해" Then
            sExgCode = "014"
        ElseIf CB_CheExgCode.Text = "중국심천" Then
            sExgCode = "018"
        ElseIf CB_CheExgCode.Text = "홍콩" Then
            sExgCode = "001"
        Else
            sExgCode = "%"  '전체
        End If

        If Len(Trim(sExgCode)) = 0 Then
            MsgBox("거래소를 입력해주세요.")
            Exit Sub
        End If

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbMiCheList, "InRec1", "ACNO", sAccNo)              '계좌번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbMiCheList, "InRec1", "AC_PWD", sAccPwd)           '계좌비밀번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌 비밀번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbMiCheList, "InRec1", "EXG_COD", sExgCode)       '거래소코드(%:전체, 020:미국, 014:중국상해, 018:중국심천, 001:홍콩)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbMiCheList, "InRec1", "ITEM_COD", "%")           '종목코드(%:전체)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbMiCheList, "InRec1", "BUY_SEL_TR_TCD", "%")     '조회구분(%:전체, 10:매도, 20:매수)

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_gbMiCheList, g_sNextKey_gbChe, 20)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "해외주식 미체결내역 조회요청 실패")
        End If
    End Sub

    '================================
    ' 해외주식 잔고내역 조회 요청
    '================================
    Private Sub Requset_GBJanList(sNextKey As String)
        g_sNextKey_gbJan = sNextKey

        If g_sNextKey_gbJan = "" Then
            LV_GBJanList.Items.Clear()
        End If

        Dim sAccNo = TB_GBAccNo.Text      '계좌번호
        Dim sAccPwd = TB_GBAccPwd.Text    '계좌비번

        If Len(Trim(sAccNo)) = 0 Then
            MsgBox("계좌번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccPwd)) < 4 Then
            MsgBox("계좌 비밀번호를 확인해주세요.")
            Exit Sub
        End If

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbJanList, "InRec1", "ACNO", sAccNo)        '계좌번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbJanList, "InRec1", "AC_PWD", sAccPwd)     '계좌비밀번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌 비밀번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_gbJanList, "InRec1", "CMSN_ICLN_YN", "N")   '수수료포함여부(Y:포함, N:미포함)

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_gbJanList, g_sNextKey_gbJan, 20)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "해외주식 잔고내역 조회요청 실패")
        End If
    End Sub

    '================================
    ' 해외주식 체결내역 조회 응답
    '================================
    Private Sub OnGetData_GBCheList(sTrCode As String, sNextGb As String, sNextKey As String)
        If sNextGb = "6" Or sNextGb = "7" Then '다음조회있음
            Btn_GBCheNext.Enabled = True
            g_sNextKey_gbChe = sNextKey
        Else
            Btn_GBCheNext.Enabled = False
            g_sNextKey_gbChe = ""
        End If

        Dim sOutPut As String
        Dim nOutVal As Long
        Dim nDataCnt As Integer
        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrCode, "OutRec1", "RECNM", 0))  '레코드수
        nDataCnt = Val(sOutPut)

        Dim sOrdTypeNm As String    '주문유형
        Dim sTradeGb As String      '매매구분
        Dim sOrdTime As String      '주문시간

        Dim sColText(10) As String
        sColText(0) = ""

        Dim lvitem As ListViewItem
        Dim i As Integer
        For i = 0 To (nDataCnt - 1)
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrCode, "OutRec2", "ITEM_COD", i))     '종목코드
            sColText(0) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrCode, "OutRec2", "ITEM_NM", i)) '종목명
            sColText(1) = sOutPut.Trim()

            '매매구분(매수,매도)(첨부문서참조)
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrCode, "OutRec2", "BUY_SEL_TR_TCD ", i))
            sTradeGb = If(sOutPut = "10", "매도", "매수")
            sColText(2) = sTradeGb

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrCode, "OutRec2", "FGST_ORD_UPR", i))  '해외증권주문단가
            sColText(3) = sOutPut.Trim()

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrCode, "OutRec2", "ORD_Q", i))    '주문수량
            nOutVal = Val(sOutPut)
            sColText(4) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrCode, "OutRec2", "FRGN_NCLSN_Q", i))   '해외미체결수량
            nOutVal = Val(sOutPut)
            sColText(5) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrCode, "OutRec2", "ORD_NO", i))   '주문번호
            sColText(6) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrCode, "OutRec2", "OORD_NO", i))  '원주문번호
            sColText(7) = sOutPut

            '주문유형(첨부문서참조)
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrCode, "OutRec2", "FGST_BNS_TCD ", i))
            If sOutPut = "020" Then
                sOrdTypeNm = "시장가"
            ElseIf sOutPut = "720" Then
                sOrdTypeNm = "MOO"
            ElseIf sOutPut = "740" Then
                sOrdTypeNm = "MOC"
            ElseIf sOutPut = "710" Then
                sOrdTypeNm = "LOO"
            ElseIf sOutPut = "730" Then
                sOrdTypeNm = "LOC"
            ElseIf sOutPut = "750" Then
                sOrdTypeNm = "TWAP"
            ElseIf sOutPut = "760" Then
                sOrdTypeNm = "VWAP"
            Else
                sOrdTypeNm = "지정가"
            End If
            sColText(8) = sOrdTypeNm

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrCode, "OutRec2", "ORD_TMD", i)) '주문시간
            If sOutPut.Length = 5 Then
                sOutPut = "0" & sOutPut
            End If
            sOrdTime = Strings.Left(sOutPut, 2) & ":" & Strings.Mid(sOutPut, 3, 2) & ":" & Strings.Right(sOutPut, 2)
            sColText(9) = sOrdTime

            lvitem = New ListViewItem(sColText)
            LV_GBCheList.Items.Add(lvitem)
        Next

    End Sub

    '================================
    ' 해외주식 잔고내역 조회 응답결과 처리
    '================================
    Private Sub OnGetData_GBJanList(sNextGb As String, sNextKey As String)
        If sNextGb = "6" Or sNextGb = "7" Then '다음조회있음
            Btn_GBJanNext.Enabled = True
            g_sNextKey_gbJan = sNextKey
        Else
            Btn_GBJanNext.Enabled = False
            g_sNextKey_gbJan = ""
        End If

        Dim sOutPut As String
        Dim nOutVal As Long
        Dim fOutVal As Double

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbJanList, "OutRec1", "RECNM", 0))        '레코드수
        Dim nDataCnt = Val(sOutPut)

        Dim sExgGubun As String '해외주식 시장구분
        Dim sColText(9) As String
        sColText(0) = ""

        Dim lvitem As ListViewItem
        Dim i As Integer
        For i = 0 To (nDataCnt - 1)
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbJanList, "OutRec2", "ITEM_NM", i))      '종목명
            sColText(1) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbJanList, "OutRec2", "HLDG_Q", i))    '보유수량
            nOutVal = Val(sOutPut)
            sColText(2) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbJanList, "OutRec2", "SEL_ABLE_Q", i))   '매도가능수량
            nOutVal = Val(sOutPut)
            sColText(3) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbJanList, "OutRec2", "BUY_UPR", i))      '매입단가
            fOutVal = Val(sOutPut)
            sColText(4) = fOutVal.ToString("###,##0.0000")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbJanList, "OutRec2", "FRGN_STK_CLPR", i))     '현재가
            fOutVal = Val(sOutPut)
            sColText(5) = fOutVal.ToString("###,##0.0000")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbJanList, "OutRec2", "EV_PL_SUM_A", i))      '평가손익
            fOutVal = Val(sOutPut)
            sColText(6) = fOutVal.ToString("###,##0.00")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbJanList, "OutRec2", "BNS_BAL_EA", i))       '평가금액
            fOutVal = Val(sOutPut)
            sColText(7) = fOutVal.ToString("###,##0.00")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_gbJanList, "OutRec2", "FRGN_STK_MKT_TCD", i))       '해외주식시장구분코드
            If sOutPut = "01" Then
                sExgGubun = "메인보드"
            ElseIf sOutPut = "03" Then
                sExgGubun = "NASD"
            ElseIf sOutPut = "06" Then
                sExgGubun = "상해"
            ElseIf sOutPut = "07" Then
                sExgGubun = "심천"
            ElseIf sOutPut = "08" Then
                sExgGubun = "뉴욕"
            ElseIf sOutPut = "09" Then
                sExgGubun = "낙스닥"
            ElseIf sOutPut = "10" Then
                sExgGubun = "아맥스"
            Else
                sExgGubun = ""
            End If

            sColText(8) = sExgGubun

            lvitem = New ListViewItem(sColText)
            LV_GBJanList.Items.Add(lvitem)
        Next
    End Sub

    '========================
    ' >>>>> 선물 / 옵션 <<<<<
    '========================
    Private Sub Btn_FOSearch_Click(sender As Object, e As EventArgs) Handles Btn_FOSearch.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Call AxChampionCommAgent1.AllUnRegisterReal()
        g_bSetReal = False

        Dim sJmCode As String
        sJmCode = TB_FOJmCode.Text
        If Len(sJmCode) = 0 Then
            MsgBox("종목코드 입력을 확인 해주세요.")
            Exit Sub
        End If

        Dim nMarketGb As Integer
        nMarketGb = AxChampionCommAgent1.GetMarketKubun(sJmCode, "")    '종목 시장구분 조회(24:선물, 25:옵션)
        If nMarketGb < 24 Or nMarketGb > 25 Then
            MsgBox("선물옵션 종목코드를 확인 해주세요.")
            Exit Sub
        End If

        Call Requset_FOSise(sJmCode)
        Call Requset_FOChe(sJmCode)
    End Sub

    '================================
    ' 선물옵션 현재가 조회
    '================================
    Private Sub Requset_FOSise(sCode As String)
        Dim nMarketGb As Integer
        nMarketGb = AxChampionCommAgent1.GetMarketKubun(sCode, "")  '종목 시장구분 조회(24:선물, 25:옵션)

        Dim sTrCode As String
        If nMarketGb = 24 Then
            sTrCode = g_sTrcode_FSise   '선물 현재가+호가시세 조회 TrCode
        Else
            sTrCode = g_sTrcode_OSise   '옵션 현재가+호가시세 조회 TrCode
        End If

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, sTrCode, "InRec1", "SCODE", sCode)

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, sTrCode, "", 20)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "선물옵션 현재가 조회 요청 실패")
        End If
    End Sub

    '================================
    ' 선물옵션 체결시세 조회
    '================================
    Private Sub Requset_FOChe(sCode As String)
        Dim nMarketGb As Integer
        nMarketGb = AxChampionCommAgent1.GetMarketKubun(sCode, "")  '종목 시장구분 조회(24:선물, 25:옵션)

        Dim sTrCode As String
        If nMarketGb = 24 Then
            sTrCode = g_sTrcode_FChe   '선물 체결시세 조회 TrCode
        Else
            sTrCode = g_sTrcode_OChe   '옵션 체결시세 조회 TrCode
        End If

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, sTrCode, "InRec1", "SCODE", sCode)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, sTrCode, "InRec1", "LTIME", "0")

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, sTrCode, "", 20)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "선물옵션 체결시세 조회 요청 실패")
        End If
    End Sub

    '================================
    ' 선물옵션 현재가 조회 응답결과 처리
    '================================
    Private Sub OnGetData_FOSise(sTrcode As String)
        Dim sOutPut As String
        Dim nOutVal As Long
        Dim fOutVal As Double
        Dim sTime As String

        '현재가 영역
        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", "SHNAME", 0)) '종목명
        LB_FOJmName.Text = sOutPut

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", "LCPRICE", 0)) '현재가
        fOutVal = Val(sOutPut) / 100
        LV_FOSise.Items.Item(0).SubItems(1).Text = fOutVal.ToString("###,##0.00")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", "LDIFF", 0)) '전일대비
        fOutVal = Val(sOutPut) / 100
        LV_FOSise.Items.Item(1).SubItems(1).Text = fOutVal.ToString("###,##0.00")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", "LVOLUME", 0)) '거래량
        nOutVal = Val(sOutPut)
        LV_FOSise.Items.Item(2).SubItems(1).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", "LOPRICE", 0)) '시가    
        fOutVal = Val(sOutPut) / 100
        LV_FOSise.Items.Item(3).SubItems(1).Text = fOutVal.ToString("###,##0.00")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", "LHPRICE", 0)) '고가
        fOutVal = Val(sOutPut) / 100
        LV_FOSise.Items.Item(4).SubItems(1).Text = fOutVal.ToString("###,##0.00")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", "LLPRICE", 0)) '저가
        fOutVal = Val(sOutPut) / 100
        LV_FOSise.Items.Item(5).SubItems(1).Text = fOutVal.ToString("###,##0.00")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", "LULIMITPRICE", 0)) '상한가
        fOutVal = Val(sOutPut) / 100
        LV_FOSise.Items.Item(6).SubItems(1).Text = fOutVal.ToString("###,##0.00")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", "LLLIMITPRICE", 0)) '하한가
        fOutVal = Val(sOutPut) / 100
        LV_FOSise.Items.Item(7).SubItems(1).Text = fOutVal.ToString("###,##0.00")

        '호가 하단 총합계 영역
        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", "LOFFERTOTCNT", 0)) '매도총호가건수
        nOutVal = Val(sOutPut)
        LV_FOHogaTot.Items.Item(0).SubItems(1).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", "LTOTOFFERREST", 0)) '매도총잔량
        nOutVal = Val(sOutPut)
        LV_FOHogaTot.Items.Item(0).SubItems(2).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", "LTIME", 0)) '시간
        If sOutPut.Length = 5 Then
            sOutPut = "0" & sOutPut
        End If
        sTime = Strings.Left(sOutPut, 2) & ":" & Strings.Mid(sOutPut, 3, 2) & ":" & Strings.Right(sOutPut, 2)
        LV_FOHogaTot.Items.Item(0).SubItems(3).Text = sTime

        'sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", "LTOTBIDOFFERDIFF", 0)) '총순매수잔량
        'nOutVal = Val(sOutPut)
        'LV_FOHogaTot.Items.Item(0).SubItems(3).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", "LTOTBIDREST", 0)) '매수총잔량
        nOutVal = Val(sOutPut)
        LV_FOHogaTot.Items.Item(0).SubItems(4).Text = nOutVal.ToString("###,##0")

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", "LBIDTOTCNT", 0)) '매수총호가건수
        nOutVal = Val(sOutPut)
        LV_FOHogaTot.Items.Item(0).SubItems(5).Text = nOutVal.ToString("###,##0")

        Dim sOutRecItem As String   '아웃풋 아이템명
        Dim sIdx As String          '아웃풋 아이템명 순번
        Dim nAskRow As Integer      '매도호가 Row 위치
        Dim nBidRow As Integer      '매수호가 Row 위치
        nAskRow = 9
        nBidRow = 0

        '1호가 ~ 5호가 영역
        Dim i As Integer
        For i = 1 To 5
            '2호가부터 Row위치 변경
            If i > 1 Then
                nAskRow = nAskRow - 1
                nBidRow = nBidRow + 1
            End If

            sIdx = i.ToString()
            sOutRecItem = "LOFFER" & sIdx
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", sOutRecItem, 0)) '매도 호가
            If Val(sOutPut) = 0 Then
                LV_FOMedoHoga.Items.Item(nAskRow).SubItems(3).Text = "" '0.00 표시안함
            Else
                fOutVal = Val(sOutPut) / 100
                LV_FOMedoHoga.Items.Item(nAskRow).SubItems(3).Text = fOutVal.ToString("###,##0.00")
            End If

            sOutRecItem = "LOFFERREST" & sIdx
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", sOutRecItem, 0)) '매도 잔량
            nOutVal = Val(sOutPut)
            LV_FOMedoHoga.Items.Item(nAskRow).SubItems(2).Text = nOutVal.ToString("###,###")

            sOutRecItem = "WOFFER" & sIdx & "CNT"
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", sOutRecItem, 0)) '매도호가건수
            nOutVal = Val(sOutPut)
            LV_FOMedoHoga.Items.Item(nAskRow).SubItems(1).Text = nOutVal.ToString("###,###")

            sOutRecItem = "LBID" & sIdx
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", sOutRecItem, 0)) '매수 호가
            If Val(sOutPut) = 0 Then
                LV_FOMesuHoga.Items.Item(nBidRow).SubItems(3).Text = "" '0.00 표시안함
            Else
                fOutVal = Val(sOutPut) / 100
                LV_FOMesuHoga.Items.Item(nBidRow).SubItems(3).Text = fOutVal.ToString("###,##0.00")
            End If

            sOutRecItem = "LBIDREST" & sIdx
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", sOutRecItem, 0)) '매수 잔량
            nOutVal = Val(sOutPut)
            LV_FOMesuHoga.Items.Item(nBidRow).SubItems(4).Text = nOutVal.ToString("###,###")

            sOutRecItem = "WBID" & sIdx & "CNT"
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec1", sOutRecItem, 0)) '매수호가건수
            nOutVal = Val(sOutPut)
            LV_FOMesuHoga.Items.Item(nBidRow).SubItems(5).Text = nOutVal.ToString("###,###")
        Next
    End Sub


    '================================
    ' 선물옵션 체결시세 조회 응답결과 처리
    '================================
    Private Sub OnGetData_FOChe(sTrcode As String)
        Dim sOutPut As String
        Dim nOutVal As Long
        Dim fOutVal As Double
        Dim sTime As String

        LV_FOCheSise.Items.Clear()

        Dim nDataCnt As Long
        nDataCnt = AxChampionCommAgent1.GetTranOutputRowCnt(sTrcode, "OutRec2") '조회건수
        If nDataCnt = 0 Then
            Exit Sub
        End If

        Dim sColText(4) As String
        sColText(0) = ""

        If (nDataCnt > 20) Then
            nDataCnt = 20   ' 최대 20건까지만 표시한다.
        End If

        Dim lvitem As ListViewItem
        Dim i As Integer
        For i = 0 To nDataCnt - 1
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec2", "LTIME", i))        '시간
            If sOutPut.Length = 5 Then
                sOutPut = "0" & sOutPut
            End If
            sTime = Strings.Left(sOutPut, 2) & ":" & Strings.Mid(sOutPut, 3, 2) & ":" & Strings.Right(sOutPut, 2)
            sColText(1) = sTime

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec2", "LCPRICE", i))      '현재가(체결가)
            fOutVal = Val(sOutPut) / 100
            sColText(2) = fOutVal.ToString("###,##0.00")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(sTrcode, "OutRec2", "LCURVOLUME", i))   '체결량
            nOutVal = Val(sOutPut)
            sColText(3) = nOutVal.ToString("###,##0")

            lvitem = New ListViewItem(sColText)
            LV_FOCheSise.Items.Add(lvitem)
        Next
    End Sub

    Private Sub Btn_FOSetReal_Click(sender As Object, e As EventArgs) Handles Btn_FOSetReal.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Dim sJmCode As String
        sJmCode = TB_FOJmCode.Text
        If Len(sJmCode) = 0 Then
            MsgBox("종목코드 입력을 확인 해주세요.")
            Exit Sub
        End If

        Dim nMarketGb As Integer
        nMarketGb = AxChampionCommAgent1.GetMarketKubun(sJmCode, "")
        If nMarketGb < 24 Or nMarketGb > 25 Then
            MsgBox("선물옵션 종목코드를 확인 해주세요.")
            Exit Sub
        End If

        '기존에 등록된 실시간이 있다면 모든 실시간을 해제 후 신규 등록
        If g_bSetReal = True Then
            AxChampionCommAgent1.AllUnRegisterReal() '모든 실시간 해제
        End If

        g_bSetReal = True   '실시간 등록

        Dim nRtn As Long
        If nMarketGb = 24 Then  '지수선물
            nRtn = AxChampionCommAgent1.RegisterReal(51, sJmCode)   '지수선물 호가 실시간 등록
            nRtn = AxChampionCommAgent1.RegisterReal(65, sJmCode)   '지수선물 체결시세 실시간 등록
        ElseIf nMarketGb = 25 Then  '지수옵션
            nRtn = AxChampionCommAgent1.RegisterReal(52, sJmCode)   '지수옵션 호가 실시간 등록
            nRtn = AxChampionCommAgent1.RegisterReal(66, sJmCode)   '지수옵션 체결시세 실시간 등록
        End If
    End Sub

    Private Sub Btn_FOUnReal_Click(sender As Object, e As EventArgs) Handles Btn_FOUnReal.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        g_bSetReal = False  '실시간 해제
        AxChampionCommAgent1.AllUnRegisterReal() '모든 실시간 해제

        '개별 실시간 해제
        'Dim sJmCode As String
        'sJmCode = TB_JmCode.Text
        '
        'If Len(sJmCode) = 0 Then
        '    MsgBox("종목코드 입력을 확인 해주세요")
        '    Exit Sub
        'End If
        'Dim nMarketGb As Integer
        'nMarketGb = AxChampionCommAgent1.GetMarketKubun(sJmCode, "")
        'If nMarketGb = 24 Then  '지수선물
        '    nRtn = AxChampionCommAgent1.UnRegisterReal(51, sJmCode)   '지수선물 호가 실시간 해제 
        '    nRtn = AxChampionCommAgent1.UnRegisterReal(65, sJmCode)   '지수선물 체결시세 실시간 해제 
        'ElseIf nMarketGb = 25 Then  '지수옵션
        '    nRtn = AxChampionCommAgent1.UnRegisterReal(52, sJmCode)   '지수옵션 호가 실시간 해제
        '    nRtn = AxChampionCommAgent1.UnRegisterReal(66, sJmCode)   '지수옵션 체결시세 실시간 해제 
        'End If
    End Sub

    '================================
    ' 선물옵션 호가시세 실시간 수신 처리
    '================================
    Private Sub OnGetRealData_FOHoga(nPBID As Short)
        Dim sRealData As String
        Dim fRealData As Double
        Dim nRealVal As Long
        Dim sRealItem As String '실시간 아이템명
        Dim sIdx As String      '실시간 아이템명 순번
        Dim sTime As String     '호가 시간

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LTOTOFFERCNT"))   '매도 총 호가건수
        nRealVal = Val(sRealData)
        LV_FOHogaTot.Items.Item(0).SubItems(1).Text = nRealVal.ToString("###,##0")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LTOTOFFER"))    '매도총잔량
        nRealVal = Val(sRealData)
        LV_FOHogaTot.Items.Item(0).SubItems(2).Text = nRealVal.ToString("###,##0")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LTIME"))        '호가시각
        If sRealData.Length = 5 Then
            sRealData = "0" & sRealData
        End If
        sTime = Strings.Left(sRealData, 2) & ":" & Strings.Mid(sRealData, 3, 2) & ":" & Strings.Right(sRealData, 2)
        LV_FOHogaTot.Items.Item(0).SubItems(3).Text = sTime

        'sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LTOTBIDOFFERDIFF"))    '총순매수잔량
        'nRealVal = Val(sRealData)
        'LV_FOHogaTot.Items.Item(0).SubItems(3).Text = nRealVal.ToString("###,##0")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LTOTOFFER"))    '매수총잔량
        nRealVal = Val(sRealData)
        LV_FOHogaTot.Items.Item(0).SubItems(4).Text = nRealVal.ToString("###,##0")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LTOTBIDCNT"))   '매수 총 호가건수
        nRealVal = Val(sRealData)
        LV_FOHogaTot.Items.Item(0).SubItems(5).Text = nRealVal.ToString("###,##0")

        Dim nAskRow As Integer      '매도호가 Row 위치
        Dim nBidRow As Integer      '매수호가 Row 위치
        nAskRow = 9
        nBidRow = 0

        Dim i As Integer
        For i = 1 To 5
            '2호가부터 Row위치 변경
            If i > 1 Then
                nAskRow = nAskRow - 1
                nBidRow = nBidRow + 1
            End If

            sIdx = Trim(CStr(i)) ' 문자형 변환후 공백제거

            sRealItem = "LOFFER" & sIdx
            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, sRealItem))       '매도 호가
            If Val(sRealData) = 0 Then
                LV_FOMedoHoga.Items.Item(nAskRow).SubItems(3).Text = "" '0.00 표시안함
            Else
                fRealData = Val(sRealData) / 100
                LV_FOMedoHoga.Items.Item(nAskRow).SubItems(3).Text = fRealData.ToString("###,##0.00")
            End If

            sRealItem = "LOFFERREST" & sIdx
            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, sRealItem))       '매도 잔량
            nRealVal = Val(sRealData)
            LV_FOMedoHoga.Items.Item(nAskRow).SubItems(2).Text = nRealVal.ToString("###,###")

            sRealItem = "WOFFER" & sIdx & "CNT"
            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, sRealItem))       '매도호가건수
            nRealVal = Val(sRealData)
            LV_FOMedoHoga.Items.Item(nAskRow).SubItems(1).Text = nRealVal.ToString("###,###")

            sRealItem = "LBID" & sIdx
            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, sRealItem))       '매수 호가
            If Val(sRealData) = 0 Then
                LV_FOMesuHoga.Items.Item(nBidRow).SubItems(3).Text = "" '0.00 표시안함
            Else
                fRealData = Val(sRealData) / 100
                LV_FOMesuHoga.Items.Item(nBidRow).SubItems(3).Text = fRealData.ToString("###,##0.00")
            End If

            sRealItem = "LBIDREST" & sIdx
            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, sRealItem))       '매수 잔량
            nRealVal = Val(sRealData)
            LV_FOMesuHoga.Items.Item(nBidRow).SubItems(4).Text = nRealVal.ToString("###,###")

            sRealItem = "WBID" & sIdx & "CNT"
            sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, sRealItem))       '매수호가건수
            nRealVal = Val(sRealData)
            LV_FOMesuHoga.Items.Item(nBidRow).SubItems(5).Text = nRealVal.ToString("###,###")
        Next
    End Sub

    '================================
    ' 선물옵션 체결시세 실시간 수신 처리
    '================================
    Private Sub OnGetRealData_FOChe(nPBID As Short)
        Dim sRealData As String
        Dim fRealData As Double
        Dim nRealVal As Long
        Dim sTime As String

        Dim sColText(4) As String
        sColText(0) = ""

        Dim lvitem As ListViewItem

        Dim nRowCnt As Integer
        nRowCnt = LV_FOCheSise.Items.Count

        If nRowCnt > 19 Then
            LV_FOCheSise.Items.RemoveAt(nRowCnt - 1)
        End If

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LTIME"))    '시간
        If sRealData.Length = 5 Then
            sRealData = "0" & sRealData
        End If
        sTime = Strings.Left(sRealData, 2) & ":" & Strings.Mid(sRealData, 3, 2) & ":" & Strings.Right(sRealData, 2)
        sColText(1) = sTime

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LCPRICE"))  '현재가
        fRealData = Val(sRealData) / 100
        sColText(2) = fRealData.ToString("###,##0.00")
        LV_FOSise.Items.Item(0).SubItems(1).Text = fRealData.ToString("###,##0.00")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LCURVOLUME"))  '체결량
        nRealVal = Val(sRealData)
        sColText(3) = nRealVal.ToString("###,##0")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LDIFF"))    '전일대비
        fRealData = Val(sRealData) / 100
        LV_FOSise.Items.Item(1).SubItems(1).Text = fRealData.ToString("###,##0.00")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LVOLUME"))  '누적거래량
        nRealVal = Val(sRealData)
        LV_FOSise.Items.Item(2).SubItems(1).Text = nRealVal.ToString("###,##0")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LOPRICE"))  '시가
        fRealData = Val(sRealData) / 100
        LV_FOSise.Items.Item(3).SubItems(1).Text = fRealData.ToString("###,##0.00")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LHPRICE"))  '고가
        fRealData = Val(sRealData) / 100
        LV_FOSise.Items.Item(4).SubItems(1).Text = fRealData.ToString("###,##0.00")

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "LLPRICE"))  '저가
        fRealData = Val(sRealData) / 100
        LV_FOSise.Items.Item(5).SubItems(1).Text = fRealData.ToString("###,##0.00")

        lvitem = New ListViewItem(sColText)
        LV_FOCheSise.Items.Insert(0, lvitem)
    End Sub

    '================================
    ' 선물옵션 주문 체결/미체결 실시간 통보 처리([193]RFC)
    '================================
    Private Sub OnGetRealData_FOCheList(nPBID As Short)
        Dim sRealData As String
        Dim nRealVal As Long

        Dim sOrdNo As String    '주문번호
        Dim sJmCode As String   '종목코드
        Dim sJmName As String   '종목명
        Dim nOrdPrc As Long     '주문가격
        Dim nOrdQty As Long     '주문수량
        Dim nCheQty As Long     '체결수량
        Dim nMiCheQty As Long   '미체결수량
        Dim sOrdTypeNm As String    '주문유형
        Dim sTradeGb As String      '매매구분
        Dim sOrdTime As String      '주문시간

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "ORDNO"))   '주문번호
        nRealVal = Val(sRealData)   '앞에 '0' 제거
        sOrdNo = nRealVal.ToString()

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "EXPCODE"))     '종목코드
        sJmCode = AxChampionCommAgent1.GetShCode(sRealData)

        sJmName = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "HNAME"))      '종목명

        '매매구분(매수,매도)(첨부문서참조)
        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "F_TRDE_TP"))
        If sRealData = "1" Then
            sTradeGb = "매도"
        Else
            sTradeGb = "매수"
        End If

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "JPRC"))  '주문가격
        nOrdPrc = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "JQTY"))    '주문수량
        nOrdQty = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "PERCHEQTY"))   '체결수량
        nCheQty = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "MICHEQTY"))   '미체결수량
        nMiCheQty = Val(sRealData)

        '매매구분(010:지정가, 020:시장가, 030:조건부지정가, 040:최유리지정가, 050:최우선지정가)(첨부문서참조)
        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "MEMEGB"))
        If sRealData = "020" Then
            sOrdTypeNm = "시장가"
        ElseIf sRealData = "030" Then
            sOrdTypeNm = "조건부지정가"
        ElseIf sRealData = "040" Then
            sOrdTypeNm = "최유리지정가"
        Else
            sOrdTypeNm = "지정가"
        End If

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "CHETIME")) '주문/체결시간
        If sRealData.Length = 5 Then
            sRealData = "0" & sRealData
        End If
        sOrdTime = Strings.Left(sRealData, 2) & ":" & Strings.Mid(sRealData, 3, 2) & ":" & Strings.Right(sRealData, 2)

        Dim sRealMsg As String
        sRealMsg = "종   목 : " & sJmName & "(" & sJmCode & ")" & vbCrLf
        sRealMsg = sRealMsg & "주문번호 : " & sOrdNo & vbCrLf
        sRealMsg = sRealMsg & "매매구분 : " & sTradeGb & vbCrLf
        sRealMsg = sRealMsg & "주문유형 : " & sOrdTypeNm & vbCrLf
        sRealMsg = sRealMsg & "주문수량 : " & nOrdQty.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "주문가격 : " & nOrdPrc.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "체결수량 : " & nCheQty.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "미체결수량 : " & nMiCheQty.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "체결시간 : " & sOrdTime
        MsgBox(sRealMsg, MsgBoxStyle.OkOnly, "[선물옵션 주문 체결/미체결 실시간 통보 확인]")
    End Sub

    '================================
    ' 선물옵션 잔고 실시간 통보 처리([194]RFJ)
    '================================
    Private Sub OnGetRealData_FOJanList(nPBID As Short)
        Dim sRealData As String
        Dim sJmCode As String
        Dim sJmName As String
        Dim nJanQty As Integer  '잔고수량(보유수량)
        Dim nOrdQty As Integer  '주문가능수량
        Dim nCurPrc As Integer  '현재가
        Dim nOrdPrc As Integer  '매입단가
        Dim nSonick As Long     '평가손익

        sJmCode = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "EXPCODE"))     '종목코드
        sJmCode = AxChampionCommAgent1.GetShCode(sJmCode)   '단축코드 변환

        sJmName = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "HNAME"))      '종목명

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "BQTY"))    '보유수량
        nJanQty = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "JQTY"))   '청산가능 수량
        nOrdQty = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "PAMT"))      '매입단가(평균매입지수)
        nOrdPrc = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "PRICE"))     '현재가
        nCurPrc = Val(sRealData)

        sRealData = Trim(AxChampionCommAgent1.GetRealOutputData(nPBID, "MAMT"))      '총매입금액
        nSonick = Val(sRealData)

        Dim sRealMsg As String
        sRealMsg = "종   목 : " & sJmName & "(" & sJmCode & ")" & vbCrLf
        sRealMsg = sRealMsg & "보유수량 : " & nJanQty.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "청산가능수량 : " & nOrdQty.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "매입단가 : " & nOrdPrc.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "현 재 가 : " & nCurPrc.ToString("###,##0") & vbCrLf
        sRealMsg = sRealMsg & "총매입금액 : " & nSonick.ToString("###,##0") & vbCrLf
        MsgBox(sRealMsg, MsgBoxStyle.OkOnly, "[선물옵션 잔고 실시간 통보 확인]")
    End Sub

    Private Sub Btn_FOBuyOrd_Click(sender As Object, e As EventArgs) Handles Btn_FOBuyOrd.Click
        Call SendBSOrderFO(True)
    End Sub

    Private Sub Btn_FOSellOrd_Click(sender As Object, e As EventArgs) Handles Btn_FOSellOrd.Click
        Call SendBSOrderFO(False)
    End Sub

    Private Sub Btn_FOModifyOrd_Click(sender As Object, e As EventArgs) Handles Btn_FOModifyOrd.Click
        Call SendMCOrderFO(True)
    End Sub

    Private Sub Btn_FOCancelOrd_Click(sender As Object, e As EventArgs) Handles Btn_FOCancelOrd.Click
        Call SendMCOrderFO(False)
    End Sub

    '================================
    ' 선물옵션 매수/매도 주문 전송
    '================================
    Private Sub SendBSOrderFO(bBuy As Boolean)
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Dim sAccNo As String    '계좌번호
        Dim sAccPwd As String   '계좌비번
        Dim sOrdType As String  '주문유형
        Dim sOrdQty As String   '주문수량
        Dim sOrdPrc As String   '주문가격
        Dim sJmCode As String   '종목코드

        'Dim sTradeGb As String  '매매구분(20:매수, 10:매도)
        'If bBuy = True Then
        '    sTradeGb = "20" '매수
        'Else
        '    sTradeGb = "10" '매도
        'End If
        Dim sTradeGb = If(bBuy, "20", "10") '매매구분(20:정정, 30:취소)

        sJmCode = TB_FOOrdJmCode.Text
        sAccNo = TB_FOAccNo.Text
        sAccPwd = TB_FOAccPwd.Text
        sOrdType = CB_FOOrdType.Text
        sOrdQty = UD_FOOrdQty.Text
        sOrdPrc = TB_FOOrdPrc.Text

        If Len(Trim(sJmCode)) = 0 Then
            MsgBox("종목코드를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccNo)) = 0 Then
            MsgBox("계좌번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccPwd)) = 0 Then
            MsgBox("계좌 비밀번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sOrdType)) = 0 Then
            MsgBox("주문유형을 선택해주세요.")
            Exit Sub
        End If

        If Val(sOrdQty) = 0 Then
            MsgBox("주문수량을 입력해주세요.")
            Exit Sub
        End If

        '주문유형 코드값 변환
        Dim sOrdTypeCode As String
        Dim sOrdCond As String
        sOrdTypeCode = ""
        sOrdCond = ""

        If sOrdType = "지정가" Then
            sOrdTypeCode = "010"
            sOrdCond = "0"
        ElseIf sOrdType = "시장가" Then
            sOrdTypeCode = "020"
            sOrdCond = "0"
        ElseIf sOrdType = "조건부지정가" Then
            sOrdTypeCode = "030"
            sOrdCond = "0"
        ElseIf sOrdType = "최유리지정가" Then
            sOrdTypeCode = "040"
            sOrdCond = "0"
        End If

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Integer
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOBSOrder, "InRec1", "ACNO", sAccNo)              '계좌번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOBSOrder, "InRec1", "AC_PWD", sAccPwd)           '계좌비밀번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌 비밀번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOBSOrder, "InRec1", "ITEM_COD", sJmCode)         '종목코드
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOBSOrder, "InRec1", "ORD_Q", sOrdQty)            '주문수량
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOBSOrder, "InRec1", "ORD_UPR", sOrdPrc)          '주문단가
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOBSOrder, "InRec1", "BUY_SEL_TR_TCD", sTradeGb)  '매매구분(10:매수, 20:매도)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOBSOrder, "InRec1", "ORD_BNS_TCD", sOrdTypeCode) '주문유형구분
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOBSOrder, "InRec1", "ORD_COND_TCD", sOrdCond)    '주문조건구분

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_FOBSOrder, "", 20)
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "선물옵션 매수/매도 주문전송 실패")
        End If
    End Sub

    '================================
    ' 선물옵션 정정/취소 주문 전송
    '================================
    Private Sub SendMCOrderFO(bModify As Boolean)
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Dim sAccNo As String    '계좌번호
        Dim sAccPwd As String   '계좌비번
        Dim sOrdType As String  '주문유형
        Dim sOrdQty As String   '주문수량
        Dim sOrdPrc As String   '주문가격
        Dim sOrgOrdNo As String '원주문번호
        Dim sJmCode As String   '종목코드

        'Dim sTradeGb As String  '매매구분(20:정정, 30:취소)
        'If bModify = True Then
        '    sTradeGb = "20"
        'Else
        '    sTradeGb = "30"
        'End If
        Dim sTradeGb = If(bModify, "20", "30")  '매매구분(20:정정, 30:취소)

        sJmCode = TB_FOOrdJmCode.Text
        sAccNo = TB_FOAccNo.Text
        sAccPwd = TB_FOAccPwd.Text
        sOrdType = CB_FOOrdType.Text
        sOrdQty = UD_FOOrdQty.Text
        sOrdPrc = TB_FOOrdPrc.Text
        sOrgOrdNo = TB_FOOrgOrdNo.Text

        If Len(Trim(sJmCode)) = 0 Then
            MsgBox("종목코드를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccNo)) = 0 Then
            MsgBox("계좌번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccPwd)) = 0 Then
            MsgBox("계좌 비밀번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sOrdType)) = 0 Then
            MsgBox("주문유형을 선택해주세요.")
            Exit Sub
        End If

        If Val(sOrdQty) = 0 Then
            MsgBox("주문수량을 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sOrgOrdNo)) = 0 Then
            MsgBox("원주문번호를 입력해주세요.")
            Exit Sub
        End If

        '주문유형 코드값 변환
        Dim sOrdTypeCode As String
        Dim sOrdCond As String
        sOrdTypeCode = ""
        sOrdCond = ""

        If sOrdType = "지정가" Then
            sOrdTypeCode = "010"
            sOrdCond = "0"
        ElseIf sOrdType = "시장가" Then
            sOrdTypeCode = "020"
            sOrdCond = "0"
        ElseIf sOrdType = "조건부지정가" Then
            sOrdTypeCode = "030"
            sOrdCond = "0"
        ElseIf sOrdType = "최유리지정가" Then
            sOrdTypeCode = "040"
            sOrdCond = "0"
        End If

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOMCOrder, "InRec1", "ACNO", sAccNo)                  '계좌번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOMCOrder, "InRec1", "AC_PWD", sAccPwd)               '계좌비밀번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌 비밀번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOMCOrder, "InRec1", "OORD_NO", sOrgOrdNo)            '원주문번호
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOMCOrder, "InRec1", "ITEM_COD", sJmCode)             '종목코드
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOMCOrder, "InRec1", "ORD_Q", sOrdQty)                '주문수량
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOMCOrder, "InRec1", "ORD_UPR", sOrdPrc)              '주문단가
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOMCOrder, "InRec1", "ORD_MDFY_CNCL_TCD", sTradeGb)   '정정/취소 구분(20:정정, 30:취소)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOMCOrder, "InRec1", "BUY_SEL_TR_TCD", "20")          '매수/매도 구분(10:매수, 20:매도)(테스트용 이므로 '매수정정'으로 고정)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOMCOrder, "InRec1", "PAT_ALL_TCD", "20")             '일부/전부 구분(10:일부, 20:전부)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOMCOrder, "InRec1", "ORD_BNS_TCD", sOrdTypeCode)     '주문매매구분
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOMCOrder, "InRec1", "ORD_COND_TCD", sOrdCond)        '주문조건구분

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_FOMCOrder, "", 20)
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "선물옵션 정정/취소 주문전송 실패")
        End If
    End Sub

    Private Sub Btn_FOCheList_Click(sender As Object, e As EventArgs) Handles Btn_FOCheList.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Call Requset_FOCheList("")
    End Sub

    Private Sub Btn_FOCheNext_Click(sender As Object, e As EventArgs) Handles Btn_FOCheNext.Click
        Call Requset_FOCheList(g_sNextKey_FOChe)
    End Sub

    Private Sub Btn_FOJanList_Click(sender As Object, e As EventArgs) Handles Btn_FOJanList.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Call Requset_FOJanList("")
    End Sub

    Private Sub Btn_FOJanNext_Click(sender As Object, e As EventArgs) Handles Btn_FOJanNext.Click
        Call Requset_FOJanList(g_sNextKey_FOJan)
    End Sub

    '================================
    ' 선물옵션 체결/미체결 내역 조회 버튼 클릭
    '================================
    Private Sub Requset_FOCheList(sNextKey As String)
        '다음버튼 비활성화
        Btn_FOCheNext.Enabled = False
        g_sNextKey_FOChe = sNextKey

        If g_sNextKey_FOChe = "" Then
            LV_FOCheList.Items.Clear()
        End If

        Dim sAccNo As String    '계좌번호
        Dim sAccPwd As String   '계좌비번
        sAccNo = TB_FOAccNo.Text
        sAccPwd = TB_FOAccPwd.Text

        If Len(Trim(sAccNo)) = 0 Then
            MsgBox("계좌번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccPwd)) < 4 Then
            MsgBox("계좌 비밀번호를 확인해주세요.")
            Exit Sub
        End If

        Dim nRqId As Long
        nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOCheList, "InRec1", "ACNO", sAccNo)            '계좌번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOCheList, "InRec1", "AC_PWD", sAccPwd)         '계좌 비밀번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌 비밀번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOCheList, "InRec1", "SORT_TURN_IO1CD", "2")    '주문번호를 기준으로 정순/역순 조회(1:정순, 2:역순)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOCheList, "InRec1", "CLSN_TP_IO1CD", "%")      '체결구분코드(%:전체, 1:체결, 2:미체결)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOCheList, "InRec1", "BUY_SEL_TR_TCD", "%")     '조회구분(%:전체, 10:매도, 20:매수)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOCheList, "InRec1", "ITEM_TP_IO1CD", "%")      '종목구분코드(%:전체, 1:선물, 2:Call, 3:Put, 4:스프레드)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOCheList, "InRec1", "ITEM_COD", "%")           '종목코드(%:전체)

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_FOCheList, g_sNextKey_FOChe, 20)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            Call MsgBox(g_sMsg, vbOKOnly, "선물옵션 체결/미체결 내역 조회 요청 실패")
        End If
    End Sub

    '================================
    ' 선물옵션 잔고내역 조회 버튼 클릭
    '================================
    Private Sub Requset_FOJanList(sNextKey As String)
        '다음버튼 비활성화
        Btn_FOJanNext.Enabled = False
        g_sNextKey_FOJan = sNextKey

        If g_sNextKey_FOJan = "" Then
            LV_FOJanList.Items.Clear()
        End If

        Dim sAccNo As String    '계좌번호
        Dim sAccPwd As String   '계좌비번
        sAccNo = TB_FOAccNo.Text
        sAccPwd = TB_FOAccPwd.Text

        If Len(Trim(sAccNo)) = 0 Then
            MsgBox("계좌번호를 입력해주세요.")
            Exit Sub
        End If

        If Len(Trim(sAccPwd)) < 4 Then
            MsgBox("계좌 비밀번호를 확인해주세요.")
            Exit Sub
        End If

        Dim nRqId As Long
        nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOJanList, "InRec1", "ACNO", sAccNo)        '계좌번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_FOJanList, "InRec1", "AC_PWD", sAccPwd)     '계좌 비밀번호
        If nRtn < 1 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "계좌 비밀번호 입력 에러")
            Exit Sub
        End If

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_FOJanList, g_sNextKey_FOJan, 20)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "선물옵션 잔고내역 조회 요청 실패")
        End If
    End Sub

    '================================
    ' 선물옵션 체결/미체결 내역 조회 응답결과 처리
    '================================
    Private Sub OnGetData_FOCheList(sNextGb As String, sNextKey As String)
        If sNextGb = "6" Or sNextGb = "7" Then '다음조회있음
            Btn_FOCheNext.Enabled = True
            g_sNextKey_FOChe = sNextKey
        Else
            Btn_FOCheNext.Enabled = False
            g_sNextKey_FOChe = ""
        End If

        Dim sOutPut As String
        Dim nOutVal As Long
        Dim fOutPut As Double
        Dim nDataCnt As Integer
        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOCheList, "OutRec1", "RECNM", 0))  '레코드수
        nDataCnt = Val(sOutPut)

        Dim sOrdTypeNm As String    '주문유형
        Dim sOrdTime As String      '주문시간

        Dim sColText(10) As String
        sColText(0) = ""

        Dim lvitem As ListViewItem
        Dim i As Integer
        For i = 0 To (nDataCnt - 1)
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOCheList, "OutRec2", "ITEM_COD", i))   '종목코드
            sColText(0) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOCheList, "OutRec2", "ITEM_NM", i))    '종목명
            sColText(1) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOCheList, "OutRec2", "TP_NM ", i))   '매도매수구분 + 정정취소구분 ex) “매도전부정정”
            sColText(2) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOCheList, "OutRec2", "ORD_UPR", i))  '주문가격
            fOutPut = Val(sOutPut)
            sColText(3) = fOutPut.ToString("###,##0.00")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOCheList, "OutRec2", "ORD_Q", i))    '주문수량
            nOutVal = Val(sOutPut)
            sColText(4) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOCheList, "OutRec2", "ORD_RQ", i))   '미체결수량
            nOutVal = Val(sOutPut)
            sColText(5) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOCheList, "OutRec2", "ORD_NO", i))   '주문번호
            sColText(6) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOCheList, "OutRec2", "OORD_NO", i))  '원주문번호
            sColText(7) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOCheList, "OutRec2", "NMPR_ORD_BNS_TCD ", i))  '주문유형(첨부문서참조)
            If sOutPut = "010" Then
                sOrdTypeNm = "지정가"
            ElseIf sOutPut = "020" Then
                sOrdTypeNm = "시장가"
            ElseIf sOutPut = "030" Then
                sOrdTypeNm = "조건부지정가"
            ElseIf sOutPut = "040" Then
                sOrdTypeNm = "최유리지정가"
            Else
                sOrdTypeNm = ""
            End If
            sColText(8) = sOrdTypeNm

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOCheList, "OutRec2", "ORD_TMD", i))  '주문시간
            If sOutPut.Length = 5 Then
                sOutPut = "0" & sOutPut
            End If
            sOrdTime = Strings.Left(sOutPut, 2) & ":" & Strings.Mid(sOutPut, 3, 2) & ":" & Strings.Right(sOutPut, 2)
            sColText(9) = sOrdTime

            lvitem = New ListViewItem(sColText)
            LV_FOCheList.Items.Add(lvitem)
        Next
    End Sub


    '================================
    ' 선물옵션 잔고내역 조회 응답결과 처리
    '================================
    Private Sub OnGetData_FOJanList(sNextGb As String, sNextKey As String)
        If sNextGb = "6" Or sNextGb = "7" Then '다음조회있음
            Btn_FOJanNext.Enabled = True
            g_sNextKey_FOJan = sNextKey
        Else
            Btn_FOJanNext.Enabled = False
            g_sNextKey_FOJan = ""
        End If

        Dim sOutPut As String
        Dim nOutVal As Long
        Dim fOutVal As Double
        Dim nDataCnt As Integer
        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOJanList, "OutRec1", "RECNM", 0))            '레코드수
        nDataCnt = Val(sOutPut)

        Dim sColText(9) As String
        sColText(0) = ""

        Dim lvitem As ListViewItem
        Dim i As Integer
        For i = 0 To (nDataCnt - 1)
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOJanList, "OutRec2", "ITEM_COD", i))         '종목코드
            sColText(0) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOJanList, "OutRec2", "ITEM_NM", i))          '종목명
            sColText(1) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOJanList, "OutRec2", "FUOP_USCTR_Q", i))     '보유수량
            nOutVal = Val(sOutPut)
            sColText(2) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOJanList, "OutRec2", "LQDT_ABLE_Q", i))      '청산가능수량
            nOutVal = Val(sOutPut)
            sColText(3) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOJanList, "OutRec2", "USCTR_UPR", i))        '매입단가
            fOutVal = Val(sOutPut)
            sColText(4) = fOutVal.ToString("###,##0.00")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOJanList, "OutRec2", "FUOP_CRPR", i))        '현재가
            fOutVal = Val(sOutPut)
            sColText(5) = fOutVal.ToString("###,##0.00")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOJanList, "OutRec2", "PCHS_A", i))           '매입금액
            nOutVal = Val(sOutPut)
            sColText(6) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOJanList, "OutRec2", "PL_A", i))             '평가손익
            nOutVal = Val(sOutPut)
            sColText(7) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_FOJanList, "OutRec2", "FUOP_EA", i))          '평가금액
            nOutVal = Val(sOutPut)
            sColText(8) = nOutVal.ToString("###,##0")

            lvitem = New ListViewItem(sColText)
            LV_FOJanList.Items.Add(lvitem)
        Next
    End Sub

    Private Sub TB_FOAccPwd_KeyUp(sender As Object, e As KeyEventArgs) Handles TB_FOAccPwd.KeyUp
        If e.KeyValue = Keys.Enter Then
            If g_bLogin = False Then
                MsgBox("로그인 상태를 확인 바랍니다.")
                Exit Sub
            Else
                Call Requset_FOCheList("")  '선물옵션 체결/미체결 내역 조회
                Call Requset_FOJanList("")  '선물옵션 잔고내역 조회
            End If
        End If
    End Sub

    Private Sub TabControl1_SelectedIndexChanged(sender As Object, e As EventArgs) Handles TabControl1.SelectedIndexChanged

        If Len(g_sLoginId) = 0 Or g_bLogin = False Then
            Exit Sub
        End If

        AxChampionCommAgent1.AllUnRegisterReal()    '모든 실시간 해제

        '주문체결 및 잔고 실시간 등록 및 해제
        Select Case TabControl1.SelectedIndex
            Case 0
                TB_JmCode.Select()
            Case 1
                Btn_Kwansim.Select()
            Case 2
                TB_AccNo.Select()
                AxChampionCommAgent1.RegisterReal(191, g_sLoginId)  '국내주식 주문/체결 통보
                AxChampionCommAgent1.RegisterReal(192, g_sLoginId)  '국내주식 잔고 통보
            Case 3
                TB_GBJmCode.Select()
            Case 4
                Btn_GBKwansim.Select()
            Case 5
                TB_GBAccNo.Select()
                AxChampionCommAgent1.RegisterReal(204, g_sLoginId)  '해외주식 주문/체결 통보
                AxChampionCommAgent1.RegisterReal(205, g_sLoginId)  '해외주식 잔고 통보
            Case 6
                TB_FOJmCode.Select()
            Case 7
                TB_FOAccNo.Select()
                AxChampionCommAgent1.RegisterReal(193, g_sLoginId)  '선물옵션 주문/체결 통보
                AxChampionCommAgent1.RegisterReal(194, g_sLoginId)  '선물옵션 잔고 통보
            Case 8
                Btn_007.Select()
        End Select
    End Sub

    '================================
    ' 조건검색
    '================================

    ' 조건검색 리스트 조회 요청
    Private Sub Btn_007_Click(sender As Object, e As EventArgs) Handles Btn_007.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_007, "InRec1", "SUSERID", g_sLoginId)

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_007, "", 20)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "조건검색 리스트 조회 요청 실패")
        End If
    End Sub

    ' 조건검색 리스트 조회 응답처리
    Private Sub OnGetData_007()
        Dim sOutPut As String
        Dim sTemp As String

        LV_007List.Items.Clear()

        Dim nDataCnt As Long
        nDataCnt = AxChampionCommAgent1.GetTranOutputRowCnt(g_sTrcode_007, "OutRec2") '조회건수

        If nDataCnt = 0 Then
            MsgBox("조회 내용이 없습니다.")
            Exit Sub
        End If

        Dim sColText(7) As String
        sColText(0) = ""

        Dim lvitem As ListViewItem
        Dim i As Integer

        Dim nIdx As Integer

        If nDataCnt = 0 Then
            MsgBox("조회 내용이 없습니다.")
            nDataCnt = 5
            For i = 0 To nDataCnt - 1
                nIdx = i + 1
                sTemp = nIdx.ToString()
                sColText(1) = "11111111"
                sColText(2) = "22222"
                sColText(3) = sTemp
                sColText(4) = "444"
                sColText(5) = "555"
                sColText(6) = "666"
                sColText(7) = "777"
                lvitem = New ListViewItem(sColText)
                LV_007List.Items.Add(lvitem)
            Next
        End If

        For i = 0 To nDataCnt - 1
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_007, "OutRec2", "SDATE", i))        '저장날짜
            'sTemp = Strings.Left(sOutPut, 4) & "/" & Strings.Mid(sOutPut, 5, 2) & "/" & Strings.Right(sOutPut, 2)
            sColText(1) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_007, "OutRec2", "STIME", i))        '저장시간
            'If sOutPut.Length = 5 Then
            '    sOutPut = "0" & sOutPut
            'End If
            'sTemp = Strings.Left(sOutPut, 2) & ":" & Strings.Mid(sOutPut, 3, 2) & ":" & Strings.Right(sOutPut, 2)
            sColText(2) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_007, "OutRec2", "LSEQ", i))      '시퀀스번호
            sColText(3) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_007, "OutRec2", "SCONTNAME", i))   '조건명
            sColText(4) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_007, "OutRec2", "SGROUPNAME", i))   '그룹명
            sColText(5) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_007, "OutRec2", "SMEMO", i))   '조건설명
            sColText(6) = sOutPut

            lvitem = New ListViewItem(sColText)
            LV_007List.Items.Add(lvitem)
        Next
    End Sub

    ' 조건 리스트 선택 처리
    Private Sub LV_007List_SelectedIndexChanged(sender As Object, e As EventArgs) Handles LV_007List.SelectedIndexChanged

        If LV_007List.SelectedItems.Count = 1 Then
            Dim sDate As String
            Dim sTime As String
            Dim sSeqNo As String
            Dim sName As String
            sDate = Trim(LV_007List.SelectedItems(0).SubItems(1).Text())
            sTime = Trim(LV_007List.SelectedItems(0).SubItems(2).Text())
            sSeqNo = Trim(LV_007List.SelectedItems(0).SubItems(3).Text())
            sName = Trim(LV_007List.SelectedItems(0).SubItems(4).Text())

            If Len(sDate) > 0 And Len(sTime) > 0 And Len(sSeqNo) > 0 Then
                LV_028List.Items.Item(0).SubItems(1).Text = sDate
                LV_028List.Items.Item(1).SubItems(1).Text = sTime
                LV_028List.Items.Item(2).SubItems(1).Text = sSeqNo
                LV_028List.Items.Item(3).SubItems(1).Text = sName

                Btn_027.PerformClick()
            End If
        End If
    End Sub

    Private Sub Btn_027_Click(sender As Object, e As EventArgs) Handles Btn_027.Click
        Dim sDate As String
        Dim sTime As String
        Dim sSeqNo As String
        Dim sName As String
        Dim sEditCnt As String
        Dim sEditList As String

        sDate = LV_028List.Items.Item(0).SubItems(1).Text()
        sTime = LV_028List.Items.Item(1).SubItems(1).Text()
        sSeqNo = LV_028List.Items.Item(2).SubItems(1).Text()
        sName = LV_028List.Items.Item(3).SubItems(1).Text()
        sEditCnt = TB_EditCnt.Text()
        sEditList = TB_EditList.Text()

        If Len(sDate) = 0 Or Len(sTime) = 0 Or Len(sSeqNo) = 0 Then
            MsgBox("조건 리스트에서 항목을 선택해 주세요")
            Exit Sub
        End If

        Requset_027(sDate, sTime, sSeqNo, sEditCnt, sEditList)
    End Sub

    ' 조건검색 내용조회 요청
    Private Sub Requset_027(sDate As String, sTime As String, sSeqNo As String, sEditCnt As String, sEditList As String)
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_027, "InRec1", "SUSERID", g_sLoginId)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_027, "InRec1", "SDATE", sDate)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_027, "InRec1", "STIME", sTime)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_027, "InRec1", "LSEQ", sSeqNo)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_027, "InRec1", "LFIELDEDITCNT", sEditCnt)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_027, "InRec1", "SFILEDLIST", sEditList)

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_027, "", 20)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "조건검색(OpenApi용) 조회 요청 실패")
        End If
    End Sub

    ' 조건검색 내용조회 (OPENAPI전용) 응답처리
    Private Sub OnGetData_027()
        Dim sOutPut As String
        Dim nOutVal As Long
        Dim nDataCnt As Long
        nDataCnt = AxChampionCommAgent1.GetTranOutputRowCnt(g_sTrcode_027, "OutRec2") '조회건수

        LV_027List.Items.Clear()

        If nDataCnt = 0 Then
            Exit Sub
        End If

        Dim sColText(8) As String
        sColText(0) = ""

        Dim lvitem As ListViewItem
        Dim i As Integer
        For i = 0 To nDataCnt - 1
            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_027, "OutRec2", "SCODE", i))    '종목코드
            sColText(1) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_027, "OutRec2", "SHNAME", i))   '종목명
            sColText(2) = sOutPut

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_027, "OutRec2", "SPRICE", i))   '현재가
            nOutVal = Val(sOutPut)
            sColText(3) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_027, "OutRec2", "SOPEN", i))    '시가
            nOutVal = Val(sOutPut)
            sColText(4) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_027, "OutRec2", "SHIGH", i))    '고가
            nOutVal = Val(sOutPut)
            sColText(5) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_027, "OutRec2", "SLOW", i))     '저가
            nOutVal = Val(sOutPut)
            sColText(6) = nOutVal.ToString("###,##0")

            sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_027, "OutRec2", "SRESULTFILED", i))   '결과필드
            sColText(7) = sOutPut

            lvitem = New ListViewItem(sColText)
            LV_027List.Items.Add(lvitem)
        Next
    End Sub

    ' 조건실시간등록(OpenApi용) 조회 요청
    Private Sub Requset_028(sDate As String, sTime As String, sSeqNo As String, sGubun As String, sDelSeq As String)
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Dim nRqId = AxChampionCommAgent1.CreateRequestID()

        Dim nRtn As Long
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_028, "InRec1", "SUSERID", g_sLoginId)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_028, "InRec1", "SDATE", sDate)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_028, "InRec1", "STIME", sTime)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_028, "InRec1", "LSEQ", sSeqNo)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_028, "InRec1", "SGUBUN", sGubun)
        nRtn = AxChampionCommAgent1.SetTranInputData(nRqId, g_sTrcode_028, "InRec1", "SDELSEQ", sDelSeq)

        nRtn = AxChampionCommAgent1.RequestTran(nRqId, g_sTrcode_028, "", 1)
        If nRtn <= 0 Then
            g_sMsg = Trim(AxChampionCommAgent1.GetLastErrMsg())
            MsgBox(g_sMsg, vbOKOnly, "조건실시간등록(OpenApi용) 조회 요청 실패")
        End If
    End Sub

    ' 조건 실시간등록 조회(OpenAPI) 응답처리
    Private Sub OnGetData_028()
        Dim sOutPut As String
        Dim sRealGubun As String
        Dim sRealSeq As String

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_028, "OutRec1", "SSIGNAL", 0)) '신호구분코드

        sRealGubun = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_028, "OutRec1", "SGUBUN", 0)) '등록해제구분코드
        LV_028List.Items.Item(4).SubItems(1).Text = sRealGubun

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_028, "OutRec1", "SRETURNCODE", 0)) '결과구분코드

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_028, "OutRec1", "SREGTIME", 0)) '설정시간    
        LV_028List.Items.Item(6).SubItems(1).Text = sOutPut

        sRealSeq = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_028, "OutRec1", "SREGSEQ", 0)) '설정번호
        LV_028List.Items.Item(5).SubItems(1).Text = sRealSeq

        sOutPut = Trim(AxChampionCommAgent1.GetTranOutputData(g_sTrcode_028, "OutRec1", "SERRMSG", 0)) '에러메시지

        If sRealGubun = "D" Then    '실시간 등록 응답구분
            If Len(g_sOldRealKey) > 0 Then
                AxChampionCommAgent1.UnRegisterReal(154, g_sOldRealKey)  '실시간 등록전 기존에 등록된 실시간이 있으면 해제부터 한다.
            End If
            If Len(sRealSeq) > 0 Then
                AxChampionCommAgent1.RegisterReal(154, sRealSeq)  '실시간 등록
                g_sOldRealKey = sRealSeq
            End If
        Else
            If Len(sRealSeq) > 0 Then
                AxChampionCommAgent1.UnRegisterReal(154, sRealSeq)  '실시간 해제
                g_sOldRealKey = ""
            End If
        End If

    End Sub


    Private Sub Btn_CondiSetReal_Click(sender As Object, e As EventArgs) Handles Btn_CondiSetReal.Click
        Dim sDate As String
        Dim sTime As String
        Dim sSeqNo As String
        Dim sName As String
        Dim sGubun As String
        Dim sDelSeq As String

        sDate = LV_028List.Items.Item(0).SubItems(1).Text()
        sTime = LV_028List.Items.Item(1).SubItems(1).Text()
        sSeqNo = LV_028List.Items.Item(2).SubItems(1).Text()
        sName = LV_028List.Items.Item(3).SubItems(1).Text()
        sGubun = "E"    '실시간등록 구분
        sDelSeq = ""

        If Len(sDate) = 0 Or Len(sTime) = 0 Or Len(sSeqNo) = 0 Then
            MsgBox("조건 리스트에서 항목을 선택해 주세요")
            Exit Sub
        End If

        g_bSetReal = True   '실시간 등록

        Requset_028(sDate, sTime, sSeqNo, sGubun, sDelSeq)
    End Sub

    Private Sub Btn_CondiClearReal_Click(sender As Object, e As EventArgs) Handles Btn_CondiClearReal.Click
        Dim sDate As String
        Dim sTime As String
        Dim sSeqNo As String
        Dim sName As String
        Dim sGubun As String
        Dim sDelSeq As String

        sDate = LV_028List.Items.Item(0).SubItems(1).Text()
        sTime = LV_028List.Items.Item(1).SubItems(1).Text()
        sSeqNo = LV_028List.Items.Item(2).SubItems(1).Text()
        sName = LV_028List.Items.Item(3).SubItems(1).Text()
        sGubun = "D"    ' '실시간해제 구분
        sDelSeq = LV_028List.Items.Item(5).SubItems(1).Text()

        If Len(sDate) = 0 Or Len(sTime) = 0 Or Len(sSeqNo) = 0 Then
            MsgBox("조건 리스트에서 항목을 선택해 주세요")
            Exit Sub
        End If

        If Len(sDelSeq) = 0 Then
            MsgBox("실시간 해제용 설정번호가 없습니다.")
            Exit Sub
        End If

        g_bSetReal = False   '실시간 해제

        Requset_028(sDate, sTime, sSeqNo, sGubun, sDelSeq)
    End Sub

    Private Sub AccBtn_Click(sender As Object, e As EventArgs) Handles AccBtn.Click
        If g_bLogin = False Then
            MsgBox("로그인 상태를 확인 바랍니다.")
            Exit Sub
        End If

        Dim nCnt As Long
        nCnt = AxChampionCommAgent1.GetAccCnt()

        If nCnt < 1 Then
            MsgBox("조회 가능한 계좌정보가 없습니다.")
            Exit Sub
        Else
            Dim sAcc As String
            Dim sReturn As String
            sAcc = AxChampionCommAgent1.GetAccInfo()
            sReturn = nCnt & "개 계좌 조회" & vbCrLf & "[ " & sAcc & " ]" & vbCrLf & "※계좌번호는 ';' 로 분리되어있습니다."
            MsgBox(sReturn)
            Exit Sub
        End If
    End Sub

End Class
