/*
 * Decompiled with CFR 0.152.
 */
package com.initech.core.crypto;

import com.initech.core.INISAFECore;
import com.initech.core.crypto.CryptoVerification;
import com.initech.core.util.LogUtil;
import com.initech.pki.util.Hex;
import com.initech.provider.crypto.InitechProvider;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class INIMessageDigest
extends CryptoVerification {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] doDigest(InputStream inputStream, String string) throws Exception {
        byte[] byArray;
        MessageDigest messageDigest = MessageDigest.getInstance(string, InitechProvider.NAME);
        try {
            byArray = new byte[1024];
        }
        catch (Exception exception) {
            INISAFECore.CoreLogger(1, "MessageDigest \uc0dd\uc131 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. alg=[" + string + "]");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
            throw new Exception();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            INISAFECore.CoreLogger(1, "\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc54c\uace0\ub9ac\uc998 \uc785\ub2c8\ub2e4. (\uc54c\uace0\ub9ac\uc998: " + string + ")");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, noSuchAlgorithmException);
            throw new NoSuchAlgorithmException("No such algorithm: " + string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            INISAFECore.CoreLogger(1, "provider\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, noSuchProviderException);
            throw new NoSuchProviderException("No such provider");
        }
        while (true) {
            int n2 = inputStream.read(byArray);
            if (n2 == -1) return messageDigest.digest();
            messageDigest.update(byArray, 0, n2);
            continue;
            break;
        }
    }

    public byte[] doDigest(String string, String string2) throws Exception {
        return this.doDigest(string.getBytes(), string2);
    }

    public byte[] doDigest(String string, String string2, String string3) throws Exception {
        return this.doDigest(string.getBytes(), string2, string3);
    }

    public byte[] doDigest(byte[] byArray, String string) throws Exception {
        return this.doDigest(byArray, string, InitechProvider.NAME);
    }

    public byte[] doDigest(byte[] byArray, String string, String string2) throws Exception {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string, string2);
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (Exception exception) {
            INISAFECore.CoreLogger(1, "MessageDigest \uc0dd\uc131 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. data=[" + Hex.dumpHex(byArray) + ", alg=[" + string + "], provider=[" + string2 + "]");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
            throw new Exception();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            INISAFECore.CoreLogger(1, "\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc54c\uace0\ub9ac\uc998 \uc785\ub2c8\ub2e4. (\uc54c\uace0\ub9ac\uc998: " + string + ")");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, noSuchAlgorithmException);
            throw new NoSuchAlgorithmException("No such algorithm: " + string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            INISAFECore.CoreLogger(1, "provider\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. (provider: " + string2 + ")");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, noSuchProviderException);
            throw new NoSuchProviderException("No such provider: " + string2);
        }
    }

    public int getDigestBlockSize(String string) throws Exception {
        String string2 = InitechProvider.NAME;
        try {
            return MessageDigest.getInstance(string, string2).getDigestLength();
        }
        catch (Exception exception) {
            INISAFECore.CoreLogger(1, "MessageDigest \ube14\ub7ed \ud06c\uae30\ub97c \uac00\uc838\uc624\ub294 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. alg=[" + string + "], provider=[" + (String)string2 + "]");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, exception);
            throw new Exception();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            INISAFECore.CoreLogger(1, "\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc54c\uace0\ub9ac\uc998 \uc785\ub2c8\ub2e4. (\uc54c\uace0\ub9ac\uc998: " + string + ")");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, noSuchAlgorithmException);
            throw new NoSuchAlgorithmException("No such algorithm: " + string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            INISAFECore.CoreLogger(1, "provider\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. (provider: " + (String)string2 + ")");
            LogUtil.writeStackTrace(INISAFECore.CoreLogger, noSuchProviderException);
            throw new NoSuchProviderException("No such provider: " + (String)string2);
        }
    }
}

