/*
 * Decompiled with CFR 0.152.
 */
package com.initech.license.crypto.asn1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SimpleDERCoder {
    public static final int TAG_CONSTRUCTED = 32;
    public static final int INDEF_LEN = -1;
    public int tag;
    public int valueLength;
    public InputStream input;

    public SimpleDERCoder(InputStream inputStream) {
        this.input = null;
        this.input = inputStream;
    }

    public SimpleDERCoder(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream;
        SimpleDERCoder simpleDERCoder = byteArrayInputStream2;
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        simpleDERCoder(byteArrayInputStream2);
    }

    public int getOctet() throws IOException {
        int n2 = this.input.read();
        if (n2 >= 0) {
            return n2;
        }
        throw new IOException("flag is -1");
    }

    public byte[] getOctets(int n2) throws IOException {
        byte[] byArray = new byte[n2];
        this.input.read(byArray, 0, n2);
        return byArray;
    }

    public byte[] getOctets() throws IOException {
        SimpleDERCoder simpleDERCoder = this;
        return simpleDERCoder.getOctets(simpleDERCoder.valueLength);
    }

    public boolean decodeTagAndLength() throws IOException {
        SimpleDERCoder simpleDERCoder = this;
        simpleDERCoder.tag = simpleDERCoder.getOctet();
        int n2 = simpleDERCoder.getOctet();
        if (n2 != 128) {
            if ((n2 & 0x80) == 0) {
                this.valueLength = n2;
            } else {
                this.valueLength = 0;
                n2 &= 0x7F;
                for (int i2 = 0; i2 < n2; ++i2) {
                    SimpleDERCoder simpleDERCoder2 = this;
                    int n3 = simpleDERCoder2.getOctet();
                    simpleDERCoder2.valueLength = simpleDERCoder2.valueLength << 8 | n3;
                }
            }
            return true;
        }
        this.valueLength = -1;
        throw new IOException("Idefinite length not support");
    }

    public void skip() throws IOException {
        SimpleDERCoder simpleDERCoder = this;
        simpleDERCoder.decodeTagAndLength();
        simpleDERCoder.skipValue();
    }

    public void skipValue() throws IOException {
        this.input.skip(this.valueLength);
    }

    public int getTag() {
        return this.tag;
    }

    public int getLength() {
        return this.valueLength;
    }
}

