/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pkcs.pkcs11;

import com.initech.pkcs.pkcs11.Mechanism;
import com.initech.pkcs.pkcs11.PKCS11;
import com.initech.pkcs.pkcs11.PKCS11Constants;
import com.initech.pkcs.pkcs11.PKCS11Exception;
import com.initech.pkcs.pkcs11.SessionInfo;
import com.initech.pkcs.pkcs11.Token;
import com.initech.pkcs.pkcs11.b;
import com.initech.pkcs.pkcs11.data.CK_ATTRIBUTE;
import com.initech.pkcs.pkcs11.data.CK_MECHANISM;
import com.initech.pkcs.pkcs11.objects.Key;
import com.initech.pkcs.pkcs11.objects.PKCS11Attribute;
import com.initech.pkcs.pkcs11.objects.PKCS11KeyPair;
import com.initech.pkcs.pkcs11.objects.PKCS11Object;
import com.initech.pkcs.pkcs11.objects.PrivateKey;
import com.initech.pkcs.pkcs11.objects.PublicKey;
import com.initech.pkcs.pkcs11.objects.SecretKey;

public class Session
implements PKCS11Constants {
    public static final long USER = 1L;
    public static final long SECURITY_OFFICER = 0L;
    public PKCS11 module;
    public Token token;
    public long hSession;
    public boolean closed = true;
    public b mutex;

    public Session(PKCS11 pKCS11, Token token, long l2) throws PKCS11Exception {
        b b2;
        ((Session)((Object)b3)).module = pKCS11;
        ((Session)((Object)b3)).token = token;
        ((Session)((Object)b3)).hSession = l2;
        ((Session)((Object)b3)).closed = false;
        b b3 = b2;
        b2 = new b();
        v1.mutex = b3;
    }

    public void lock() throws PKCS11Exception {
        this.mutex.a();
    }

    public void unlock() throws PKCS11Exception {
        this.mutex.b();
    }

    public Token getToken() {
        return this.token;
    }

    public boolean equals(Object object) {
        if (object instanceof Session) {
            object = (Session)object;
            if (this.closed) {
                return false;
            }
            if (this.hSession != ((Session)object).hSession) {
                return false;
            }
            if (!this.token.equals(((Session)object).token)) {
                return false;
            }
            return this.module.equals(((Session)object).module);
        }
        return false;
    }

    public synchronized void close() throws PKCS11Exception {
        if (!this.closed) {
            this.module.C_CloseSession(this.hSession);
            this.module = null;
            this.closed = true;
        }
    }

    public void login(long l2, byte[] byArray) throws PKCS11Exception {
        this.module.C_Login(this.hSession, l2, byArray);
    }

    public void logout() throws PKCS11Exception {
        this.module.C_Logout(this.hSession);
    }

    public void finalize() throws Throwable {
        this.close();
    }

    public SessionInfo getSessionInfo() throws PKCS11Exception {
        return new SessionInfo(this.module.C_GetSessionInfo(this.hSession));
    }

    public long createObject(CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
        return this.module.C_CreateObject(this.hSession, cK_ATTRIBUTEArray);
    }

    public PKCS11Object createObject(PKCS11Object cK_ATTRIBUTEArray) throws PKCS11Exception {
        Session session = this;
        cK_ATTRIBUTEArray = PKCS11Object.getCkAttributes((PKCS11Object)cK_ATTRIBUTEArray);
        long l2 = session.module.C_CreateObject(this.hSession, cK_ATTRIBUTEArray);
        return PKCS11Object.getInstance(session.module, this.hSession, l2);
    }

    public long copyObject(long l2, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
        return this.module.C_CopyObject(this.hSession, l2, cK_ATTRIBUTEArray);
    }

    public PKCS11Object copyObject(PKCS11Object cK_ATTRIBUTEArray, PKCS11Object pKCS11Object) throws PKCS11Exception {
        Session session = this;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = cK_ATTRIBUTEArray;
        cK_ATTRIBUTEArray = PKCS11Object.getCkAttributes(pKCS11Object);
        long l2 = cK_ATTRIBUTEArray2.getObjectHandle();
        long l3 = session.module.C_CopyObject(this.hSession, l2, cK_ATTRIBUTEArray);
        return PKCS11Object.getInstance(session.module, this.hSession, l3);
    }

    public void destroyObject(long l2) throws PKCS11Exception {
        this.module.C_DestroyObject(this.hSession, l2);
    }

    public void destroyObject(PKCS11Object pKCS11Object) throws PKCS11Exception {
        long l2 = this.hSession;
        long l3 = pKCS11Object.getObjectHandle();
        this.module.C_DestroyObject(l2, l3);
    }

    public void setAttributeValue(long l2, PKCS11Attribute pKCS11Attribute) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[1];
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = cK_ATTRIBUTEArray;
        cK_ATTRIBUTEArray[0] = pKCS11Attribute.getCkAttribute();
        this.module.C_SetAttributeValue(this.hSession, l2, cK_ATTRIBUTEArray2);
    }

    public void setAttributeValue(PKCS11Object pKCS11Object, PKCS11Object cK_ATTRIBUTEArray) throws PKCS11Exception {
        cK_ATTRIBUTEArray = PKCS11Object.getCkAttributes((PKCS11Object)cK_ATTRIBUTEArray);
        long l2 = this.hSession;
        long l3 = pKCS11Object.getObjectHandle();
        this.module.C_SetAttributeValue(l2, l3, cK_ATTRIBUTEArray);
    }

    public void getAttributeValue(long l2, PKCS11Attribute pKCS11Attribute) throws PKCS11Exception {
        PKCS11Exception pKCS11Exception2;
        block5: {
            block4: {
                PKCS11Attribute pKCS11Attribute2 = pKCS11Attribute;
                long l3 = pKCS11Attribute.getType();
                long[] lArray = new long[1];
                long[] lArray2 = lArray;
                try {
                    lArray[0] = l3;
                    pKCS11Attribute2.setCkAttribute(this.module.C_GetAttributeValue(this.hSession, l2, lArray2)[0]);
                    pKCS11Attribute2.setPresent(true);
                    pKCS11Attribute2.setSensitive(false);
                }
                catch (PKCS11Exception pKCS11Exception2) {
                    if (pKCS11Exception2.getErrorCode() == 18L) {
                        PKCS11Attribute pKCS11Attribute3 = pKCS11Attribute;
                        pKCS11Attribute3.setPresent(false);
                        pKCS11Attribute3.setSensitive(false);
                        break block4;
                    }
                    if (pKCS11Exception2.getErrorCode() != 17L) break block5;
                    PKCS11Attribute pKCS11Attribute4 = pKCS11Attribute;
                    pKCS11Attribute4.setPresent(true);
                    pKCS11Attribute4.setSensitive(true);
                }
            }
            return;
        }
        throw pKCS11Exception2;
    }

    public void getAttributeValues(long l2, PKCS11Attribute[] pKCS11AttributeArray) throws PKCS11Exception {
        for (int i2 = 0; i2 < pKCS11AttributeArray.length; ++i2) {
            PKCS11Attribute pKCS11Attribute = pKCS11AttributeArray[i2];
            this.getAttributeValue(l2, pKCS11Attribute);
        }
    }

    public PKCS11Object getAttributeValues(PKCS11Object pKCS11Object) throws PKCS11Exception {
        long l2 = pKCS11Object.getObjectHandle();
        return PKCS11Object.getInstance(this.module, this.hSession, l2);
    }

    public PKCS11Object getPKCS11Object(long l2) throws PKCS11Exception {
        return PKCS11Object.getInstance(this.module, this.hSession, l2);
    }

    public void findObjectsInit(CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
        this.module.C_FindObjectsInit(this.hSession, cK_ATTRIBUTEArray);
    }

    public void findObjectsInit(PKCS11Object cK_ATTRIBUTEArray) throws PKCS11Exception {
        cK_ATTRIBUTEArray = PKCS11Object.getCkAttributes((PKCS11Object)cK_ATTRIBUTEArray);
        this.module.C_FindObjectsInit(this.hSession, cK_ATTRIBUTEArray);
    }

    public long[] rawFindObjects(long l2) throws PKCS11Exception {
        return this.module.C_FindObjects(this.hSession, l2);
    }

    public PKCS11Object[] findObjects(long l2) throws PKCS11Exception {
        long[] lArray = this.module.C_FindObjects(this.hSession, l2);
        if (lArray == null) {
            return new PKCS11Object[0];
        }
        PKCS11Object[] pKCS11ObjectArray = new PKCS11Object[lArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            long l3 = this.hSession;
            long l4 = lArray[i2];
            pKCS11ObjectArray[i2] = PKCS11Object.getInstance(this.module, l3, l4);
        }
        return pKCS11ObjectArray;
    }

    public void findObjectsFinal() throws PKCS11Exception {
        this.module.C_FindObjectsFinal(this.hSession);
    }

    public void signInit(Mechanism mechanism, long l2) throws PKCS11Exception {
        long l3 = this.hSession;
        CK_MECHANISM cK_MECHANISM = mechanism.toCK_MECHANISM();
        this.module.C_SignInit(l3, cK_MECHANISM, l2);
    }

    public void signInit(Mechanism mechanism, PrivateKey object) throws PKCS11Exception {
        long l2 = ((PKCS11Object)object).getObjectHandle();
        long l3 = this.hSession;
        object = mechanism.toCK_MECHANISM();
        this.module.C_SignInit(l3, (CK_MECHANISM)object, l2);
    }

    public byte[] sign(byte[] byArray) throws PKCS11Exception {
        return this.sign(byArray, 0, byArray.length);
    }

    public byte[] sign(byte[] byArray, int n2, int n3) throws PKCS11Exception {
        return this.module.C_Sign(this.hSession, byArray, n2, n3);
    }

    public void signUpdate(byte[] byArray) throws PKCS11Exception {
        int n2 = byArray.length;
        this.signUpdate(byArray, 0, n2);
    }

    public void signUpdate(byte[] byArray, int n2, int n3) throws PKCS11Exception {
        this.module.C_SignUpdate(this.hSession, byArray, n2, n3);
    }

    public byte[] signFinal() throws PKCS11Exception {
        return this.module.C_SignFinal(this.hSession);
    }

    public void verifyInit(Mechanism mechanism, long l2) throws PKCS11Exception {
        long l3 = this.hSession;
        CK_MECHANISM cK_MECHANISM = mechanism.toCK_MECHANISM();
        this.module.C_VerifyInit(l3, cK_MECHANISM, l2);
    }

    public void verifyInit(Mechanism mechanism, PublicKey object) throws PKCS11Exception {
        long l2 = ((PKCS11Object)object).getObjectHandle();
        long l3 = this.hSession;
        object = mechanism.toCK_MECHANISM();
        this.module.C_VerifyInit(l3, (CK_MECHANISM)object, l2);
    }

    public boolean verify(byte[] byArray, byte[] byArray2) throws PKCS11Exception {
        int n2 = byArray.length;
        int n3 = byArray2.length;
        return this.verify(byArray, 0, n2, byArray2, 0, n3);
    }

    public boolean verify(byte[] byArray, int n2, int n3, byte[] byArray2) throws PKCS11Exception {
        int n4 = byArray2.length;
        return this.verify(byArray, n2, n3, byArray2, 0, n4);
    }

    public boolean verify(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) throws PKCS11Exception {
        return this.module.C_Verify(this.hSession, byArray, n2, n3, byArray2, n4, n5);
    }

    public void verifyUpdate(byte[] byArray) throws PKCS11Exception {
        int n2 = byArray.length;
        this.verifyUpdate(byArray, 0, n2);
    }

    public void verifyUpdate(byte[] byArray, int n2, int n3) throws PKCS11Exception {
        this.module.C_VerifyUpdate(this.hSession, byArray, n2, n3);
    }

    public boolean verifyFinal(byte[] byArray) throws PKCS11Exception {
        return this.verifyFinal(byArray, 0, byArray.length);
    }

    public boolean verifyFinal(byte[] byArray, int n2, int n3) throws PKCS11Exception {
        return this.module.C_VerifyFinal(this.hSession, byArray, n2, n3);
    }

    public void encryptInit(Mechanism mechanism, long l2) throws PKCS11Exception {
        long l3 = this.hSession;
        CK_MECHANISM cK_MECHANISM = mechanism.toCK_MECHANISM();
        this.module.C_EncryptInit(l3, cK_MECHANISM, l2);
    }

    public void encryptInit(Mechanism mechanism, Key object) throws PKCS11Exception {
        if (!(object instanceof SecretKey) && !(object instanceof PublicKey)) {
            throw new PKCS11Exception("Invalid encryption Key");
        }
        long l2 = ((PKCS11Object)object).getObjectHandle();
        long l3 = this.hSession;
        object = mechanism.toCK_MECHANISM();
        this.module.C_EncryptInit(l3, (CK_MECHANISM)object, l2);
    }

    public byte[] encrypt(byte[] byArray) throws PKCS11Exception {
        return this.encrypt(byArray, 0, byArray.length);
    }

    public byte[] encrypt(byte[] byArray, int n2, int n3) throws PKCS11Exception {
        return this.module.C_Encrypt(this.hSession, byArray, n2, n3);
    }

    public int encrypt(byte[] byArray, byte[] byArray2, int n2) throws PKCS11Exception {
        return this.encrypt(byArray, 0, byArray.length, byArray2, n2);
    }

    public int encrypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws PKCS11Exception {
        return (int)this.module.C_Encrypt(this.hSession, byArray, n2, n3, byArray2, n4);
    }

    public byte[] encryptUpdate(byte[] byArray) throws PKCS11Exception {
        return this.encryptUpdate(byArray, 0, byArray.length);
    }

    public byte[] encryptUpdate(byte[] byArray, int n2, int n3) throws PKCS11Exception {
        return this.module.C_EncryptUpdate(this.hSession, byArray, n2, n3);
    }

    public int encryptUpdate(byte[] byArray, byte[] byArray2, int n2) throws PKCS11Exception {
        return this.encryptUpdate(byArray, 0, byArray.length, byArray2, n2);
    }

    public int encryptUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws PKCS11Exception {
        return (int)this.module.C_EncryptUpdate(this.hSession, byArray, n2, n3, byArray2, n4);
    }

    public int encryptFinal(byte[] byArray, int n2) throws PKCS11Exception {
        return (int)this.module.C_EncryptFinal(this.hSession, byArray, n2);
    }

    public byte[] encryptFinal() throws PKCS11Exception {
        return this.module.C_EncryptFinal(this.hSession);
    }

    public void decryptInit(Mechanism mechanism, long l2) throws PKCS11Exception {
        long l3 = this.hSession;
        CK_MECHANISM cK_MECHANISM = mechanism.toCK_MECHANISM();
        this.module.C_DecryptInit(l3, cK_MECHANISM, l2);
    }

    public void decryptInit(Mechanism mechanism, Key object) throws PKCS11Exception {
        if (!(object instanceof SecretKey) && !(object instanceof PrivateKey)) {
            throw new PKCS11Exception("Invalid Decryption Key");
        }
        long l2 = ((PKCS11Object)object).getObjectHandle();
        long l3 = this.hSession;
        object = mechanism.toCK_MECHANISM();
        this.module.C_DecryptInit(l3, (CK_MECHANISM)object, l2);
    }

    public byte[] decrypt(byte[] byArray) throws PKCS11Exception {
        return this.decrypt(byArray, 0, byArray.length);
    }

    public byte[] decrypt(byte[] byArray, int n2, int n3) throws PKCS11Exception {
        return this.module.C_Decrypt(this.hSession, byArray, n2, n3);
    }

    public int decrypt(byte[] byArray, byte[] byArray2, int n2) throws PKCS11Exception {
        return this.decrypt(byArray, 0, byArray.length, byArray2, n2);
    }

    public int decrypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws PKCS11Exception {
        return (int)this.module.C_Decrypt(this.hSession, byArray, n2, n3, byArray2, n4);
    }

    public byte[] decryptUpdate(byte[] byArray) throws PKCS11Exception {
        return this.decryptUpdate(byArray, 0, byArray.length);
    }

    public byte[] decryptUpdate(byte[] byArray, int n2, int n3) throws PKCS11Exception {
        return this.module.C_DecryptUpdate(this.hSession, byArray, n2, n3);
    }

    public int decryptUpdate(byte[] byArray, byte[] byArray2, int n2) throws PKCS11Exception {
        return this.decryptUpdate(byArray, 0, byArray.length, byArray2, n2);
    }

    public int decryptUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws PKCS11Exception {
        return (int)this.module.C_DecryptUpdate(this.hSession, byArray, n2, n3, byArray2, n4);
    }

    public int decryptFinal(byte[] byArray, int n2) throws PKCS11Exception {
        return (int)this.module.C_DecryptFinal(this.hSession, byArray, n2);
    }

    public byte[] decryptFinal() throws PKCS11Exception {
        return this.module.C_DecryptFinal(this.hSession);
    }

    public void digestInit(Mechanism mechanism) throws PKCS11Exception {
        long l2 = this.hSession;
        CK_MECHANISM cK_MECHANISM = mechanism.toCK_MECHANISM();
        this.module.C_DigestInit(l2, cK_MECHANISM);
    }

    public byte[] digest(byte[] byArray) throws PKCS11Exception {
        return this.digest(byArray, 0, byArray.length);
    }

    public byte[] digest(byte[] byArray, int n2, int n3) throws PKCS11Exception {
        return this.module.C_Digest(this.hSession, byArray, n2, n3);
    }

    public void digestUpdate(byte[] byArray) throws PKCS11Exception {
        int n2 = byArray.length;
        this.digestUpdate(byArray, 0, n2);
    }

    public void digestUpdate(byte[] byArray, int n2, int n3) throws PKCS11Exception {
        this.module.C_DigestUpdate(this.hSession, byArray, n2, n3);
    }

    public byte[] digestFinal() throws PKCS11Exception {
        return this.module.C_DigestFinal(this.hSession);
    }

    public byte[] wrapKey(Mechanism mechanism, Key key, Key key2) throws PKCS11Exception {
        if (!(key instanceof PrivateKey)) {
            long l2 = key.getObjectHandle();
            long l3 = key2.getObjectHandle();
            return this.wrapKey(mechanism, l2, l3);
        }
        throw new PKCS11Exception(277L);
    }

    public byte[] wrapKey(Mechanism mechanism, long l2, long l3) throws PKCS11Exception {
        long l4 = this.hSession;
        CK_MECHANISM cK_MECHANISM = mechanism.toCK_MECHANISM();
        return this.module.C_WrapKey(l4, cK_MECHANISM, l2, l3);
    }

    public PKCS11Object unwrapKey(Mechanism mechanism, Key key, byte[] byArray, PKCS11Object pKCS11Object) throws PKCS11Exception {
        int n2 = byArray.length;
        return this.unwrapKey(mechanism, key, byArray, 0, n2, pKCS11Object);
    }

    public PKCS11Object unwrapKey(Mechanism cK_ATTRIBUTEArray, Key key, byte[] byArray, int n2, int n3, PKCS11Object pKCS11Object) throws PKCS11Exception {
        Session session = this;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = cK_ATTRIBUTEArray;
        cK_ATTRIBUTEArray = PKCS11Object.getCkAttributes(pKCS11Object);
        long l2 = session.unwrapKey((Mechanism)cK_ATTRIBUTEArray2, key.getObjectHandle(), byArray, n2, n3, cK_ATTRIBUTEArray);
        return PKCS11Object.getInstance(session.module, this.hSession, l2);
    }

    public long unwrapKey(Mechanism mechanism, long l2, byte[] byArray, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
        int n2 = byArray.length;
        return this.unwrapKey(mechanism, l2, byArray, 0, n2, cK_ATTRIBUTEArray);
    }

    public long unwrapKey(Mechanism mechanism, long l2, byte[] byArray, int n2, int n3, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
        long l3 = this.hSession;
        CK_MECHANISM cK_MECHANISM = mechanism.toCK_MECHANISM();
        return this.module.C_UnwrapKey(l3, cK_MECHANISM, l2, byArray, n2, n3, cK_ATTRIBUTEArray);
    }

    public long generateKey(Mechanism mechanism, CK_ATTRIBUTE[] cK_ATTRIBUTEArray) throws PKCS11Exception {
        if (mechanism != null) {
            long l2 = this.hSession;
            CK_MECHANISM cK_MECHANISM = mechanism.toCK_MECHANISM();
            return this.module.C_GenerateKey(l2, cK_MECHANISM, cK_ATTRIBUTEArray);
        }
        throw new PKCS11Exception("Invalid mechanism");
    }

    public SecretKey generateKey(Mechanism object, SecretKey cK_ATTRIBUTEArray) throws PKCS11Exception {
        if (object != null) {
            if (cK_ATTRIBUTEArray != null) {
                Session session = this;
                cK_ATTRIBUTEArray = PKCS11Object.getCkAttributes((PKCS11Object)cK_ATTRIBUTEArray);
                long l2 = this.hSession;
                object = ((Mechanism)object).toCK_MECHANISM();
                long l3 = session.module.C_GenerateKey(l2, (CK_MECHANISM)object, cK_ATTRIBUTEArray);
                return (SecretKey)PKCS11Object.getInstance(session.module, this.hSession, l3);
            }
            throw new PKCS11Exception("SecretKey template must be given");
        }
        throw new PKCS11Exception("Invalid mechanism");
    }

    public long[] generateKeyPair(Mechanism mechanism, CK_ATTRIBUTE[] cK_ATTRIBUTEArray, CK_ATTRIBUTE[] cK_ATTRIBUTEArray2) throws PKCS11Exception {
        if (mechanism != null) {
            if (cK_ATTRIBUTEArray != null && cK_ATTRIBUTEArray.length != 0) {
                if (cK_ATTRIBUTEArray2 != null && cK_ATTRIBUTEArray2.length != 0) {
                    long l2 = this.hSession;
                    CK_MECHANISM cK_MECHANISM = mechanism.toCK_MECHANISM();
                    return this.module.C_GenerateKeyPair(l2, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
                }
                throw new PKCS11Exception("PrivateKey template must be given");
            }
            throw new PKCS11Exception("PublicKey template must be given");
        }
        throw new PKCS11Exception("Invalid mechanism");
    }

    public PKCS11KeyPair generateKeyPair(Mechanism object, PublicKey cK_ATTRIBUTEArray, PrivateKey cK_ATTRIBUTEArray2) throws PKCS11Exception {
        if (object != null) {
            if (cK_ATTRIBUTEArray != null) {
                if (cK_ATTRIBUTEArray2 != null) {
                    long l2;
                    Object object2;
                    PKCS11 pKCS11;
                    Session session = this;
                    cK_ATTRIBUTEArray = PKCS11Object.getCkAttributes((PKCS11Object)cK_ATTRIBUTEArray);
                    cK_ATTRIBUTEArray2 = PKCS11Object.getCkAttributes((PKCS11Object)cK_ATTRIBUTEArray2);
                    Object object3 = this.hSession;
                    object = ((Mechanism)object).toCK_MECHANISM();
                    object = session.module.C_GenerateKeyPair((long)object3, (CK_MECHANISM)object, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
                    try {
                        pKCS11 = session.module;
                        object2 = object;
                        l2 = this.hSession;
                    }
                    catch (ClassCastException classCastException) {
                        throw new PKCS11Exception("Failed to generate key");
                    }
                    object3 = object2[0];
                    PublicKey publicKey = (PublicKey)PKCS11Object.getInstance(pKCS11, l2, object3);
                    PKCS11 pKCS112 = session.module;
                    Object object4 = object;
                    long l3 = this.hSession;
                    object3 = object4[1];
                    PrivateKey privateKey = (PrivateKey)PKCS11Object.getInstance(pKCS112, l3, object3);
                    return new PKCS11KeyPair(publicKey, privateKey);
                }
                throw new PKCS11Exception("PrivateKey template must be given");
            }
            throw new PKCS11Exception("PublicKey template must be given");
        }
        throw new PKCS11Exception("Invalid mechanism");
    }

    public void seedRandom(byte[] byArray) throws PKCS11Exception {
        this.module.C_SeedRandom(this.hSession, byArray);
    }

    public void generateRandom(byte[] byArray) throws PKCS11Exception {
        this.module.C_GenerateRandom(this.hSession, byArray);
    }
}

