/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pki.pkcs12;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.useful.Attributes;
import com.initech.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import com.initech.pkcs.pkcs8.PrivateKeyInfo;
import com.initech.pki.pkcs12.BagFactory;
import com.initech.pki.pkcs12.SafeContents;
import java.security.cert.CRL;
import java.security.cert.Certificate;

public class SafeBag
implements ASN1Type {
    public ASN1OID bagId;
    public Object bagValue;
    public Attributes attrs;

    public SafeBag() {
    }

    public SafeBag(Object object, Attributes attributes) {
        ASN1OID aSN1OID;
        SafeBag safeBag = safeBag2;
        SafeBag safeBag2 = aSN1OID;
        aSN1OID = new ASN1OID();
        safeBag.bagId = safeBag2;
        safeBag.set(object, attributes);
    }

    public void set(Object object, Attributes attributes) {
        this.bagValue = object;
        this.attrs = attributes;
        if (object instanceof SafeContents) {
            this.bagId.set("safeContentsBag");
        } else if (object instanceof PrivateKeyInfo) {
            this.bagId.set("keyBag");
        } else if (object instanceof EncryptedPrivateKeyInfo) {
            this.bagId.set("pkcs8ShroudedKeyBag");
        } else if (object instanceof Certificate) {
            this.bagId.set("certBag");
        } else if (object instanceof CRL) {
            this.bagId.set("crlBag");
        } else if (object instanceof byte[]) {
            this.bagId.set("secretBag");
        }
    }

    public ASN1OID getBagId() {
        return this.bagId;
    }

    public Object getBagValue() {
        return this.bagValue;
    }

    public Attributes getBagAttr() {
        return this.attrs;
    }

    public void encode(ASN1Encoder aSN1Encoder) throws ASN1Exception {
        ASN1Encoder aSN1Encoder2 = aSN1Encoder;
        ASN1Encoder aSN1Encoder3 = aSN1Encoder;
        int n2 = aSN1Encoder.encodeSequence();
        aSN1Encoder3.encodeObjectIdentifier(safeBag.bagId);
        int n3 = aSN1Encoder3.encodeExplicit(ASN1Tag.makeExplicitTag((int)0));
        try {
            aSN1Encoder2.encodeAny(BagFactory.encodeBag(safeBag.bagId, safeBag.bagValue));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ASN1Exception(exception.toString());
        }
        aSN1Encoder2.endOf(n3);
        SafeBag safeBag = safeBag.attrs;
        if (safeBag != null) {
            safeBag.encode(aSN1Encoder);
        }
        aSN1Encoder.endOf(n2);
    }

    public void decode(ASN1Decoder aSN1Decoder) throws ASN1Exception {
        ASN1Decoder aSN1Decoder2 = aSN1Decoder;
        ASN1Decoder aSN1Decoder3 = aSN1Decoder;
        int n2 = aSN1Decoder3.decodeSequence();
        this.bagId = aSN1Decoder3.decodeObjectIdentifier();
        int n3 = aSN1Decoder.decodeExplicit(ASN1Tag.makeExplicitTag((int)0));
        try {
            this.bagValue = BagFactory.decodeBag(this.bagId, aSN1Decoder.decodeAnyAsByteArray());
        }
        catch (Exception exception) {
            throw new ASN1Exception(exception.toString());
        }
        aSN1Decoder2.endOf(n3);
        if (aSN1Decoder2.nextIsOptional(17)) {
            this.attrs = null;
        } else {
            Attributes attributes;
            Attributes attributes2 = attributes;
            attributes2();
            this.attrs = attributes2;
            attributes.decode(aSN1Decoder);
        }
        aSN1Decoder.endOf(n2);
    }
}

