/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pkix.cmp.crmf;

import com.initech.asn1.ASN1BitString;
import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.useful.ASN1Object;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.asn1.useful.Extension;
import com.initech.asn1.useful.Extensions;
import com.initech.asn1.useful.Name;
import com.initech.asn1.useful.PublicKeyInfo;
import com.initech.pki.util.Hex;
import com.initech.pkix.cmp.crmf.OptionalValidity;
import com.initech.x509.X509CertImpl;
import com.initech.x509.X509ExtensionBuilder;
import com.initech.x509.X509SubjectName;
import com.initech.x509.extensions.SubjectAltName;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.Date;

public class CertTemplate
extends ASN1Object
implements X509SubjectName {
    public int a;
    public BigInteger b;
    public AlgorithmID c;
    public Name d;
    public OptionalValidity e;
    public Name f;
    public PublicKeyInfo g;
    public ASN1BitString h;
    public ASN1BitString i;
    public Extensions j;

    public CertTemplate() {
        Extensions extensions;
        Name name;
        OptionalValidity optionalValidity;
        Name name2;
        object.a = -1;
        Object object = name2;
        name2 = new Name();
        v1.d = object;
        object = optionalValidity;
        optionalValidity = new OptionalValidity();
        v1.e = object;
        object = name;
        name = new Name();
        v1.f = object;
        object = extensions;
        extensions = new Extensions();
        v1.j = object;
        v1.modified = true;
    }

    public CertTemplate(byte[] byArray) throws ASN1Exception {
        CertTemplate certTemplate = this;
        CertTemplate certTemplate2 = this;
        certTemplate2.a = -1;
        certTemplate2.d = new Name();
        certTemplate2.e = new OptionalValidity();
        certTemplate2.f = new Name();
        certTemplate2.j = new Extensions();
        certTemplate2.decode((ASN1Decoder)new DERDecoder(byArray));
        certTemplate.encoded = (byte[])byArray.clone();
        certTemplate.modified = false;
    }

    public void encode(ASN1Encoder aSN1Encoder) throws ASN1Exception {
        int n2 = aSN1Encoder.encodeSequence();
        if (this.a >= 0) {
            aSN1Encoder.nextIsImplicit(ASN1Tag.makeContextTag((int)0));
            aSN1Encoder.encodeInteger(this.a);
        }
        if (this.b != null) {
            aSN1Encoder.nextIsImplicit(ASN1Tag.makeContextTag((int)1));
            aSN1Encoder.encodeInteger(this.b);
        }
        if (this.c != null) {
            aSN1Encoder.nextIsImplicit(ASN1Tag.makeContextTag((int)2));
            this.c.encode(aSN1Encoder);
        }
        if (!this.d.isNullDN()) {
            ASN1Encoder aSN1Encoder2 = aSN1Encoder;
            int n3 = aSN1Encoder2.encodeExplicit(ASN1Tag.makeContextTag((int)3));
            this.d.encode(aSN1Encoder);
            aSN1Encoder2.endOf(n3);
        }
        if (this.e.getNotBefore() != null || this.e.getNotAfter() != null) {
            aSN1Encoder.nextIsImplicit(ASN1Tag.makeContextTag((int)4));
            this.e.encode(aSN1Encoder);
        }
        if (!this.f.isNullDN()) {
            ASN1Encoder aSN1Encoder3 = aSN1Encoder;
            int n4 = aSN1Encoder3.encodeExplicit(ASN1Tag.makeContextTag((int)5));
            this.f.encode(aSN1Encoder);
            aSN1Encoder3.endOf(n4);
        }
        if (this.g != null) {
            aSN1Encoder.nextIsImplicit(ASN1Tag.makeContextTag((int)6));
            this.g.encode(aSN1Encoder);
        }
        if (this.h != null) {
            aSN1Encoder.nextIsImplicit(ASN1Tag.makeContextTag((int)7));
            aSN1Encoder.encodeBitString(this.h);
        }
        if (this.i != null) {
            aSN1Encoder.nextIsImplicit(ASN1Tag.makeContextTag((int)8));
            aSN1Encoder.encodeBitString(this.h);
        }
        if (this.j.size() > 0) {
            aSN1Encoder.nextIsImplicit(ASN1Tag.makeContextTag((int)9));
            this.j.encode(aSN1Encoder);
        }
        aSN1Encoder.endOf(n2);
    }

    public void decode(ASN1Decoder aSN1Decoder) throws ASN1Exception {
        AlgorithmID algorithmID;
        ASN1Decoder aSN1Decoder2 = aSN1Decoder;
        int n2 = aSN1Decoder2.decodeSequence();
        if (aSN1Decoder2.nextIsOptional(ASN1Tag.makeContextTag((int)0))) {
            this.a = -1;
        } else {
            ASN1Decoder aSN1Decoder3 = aSN1Decoder;
            aSN1Decoder3.nextIsImplicit(ASN1Tag.makeContextTag((int)0));
            this.a = aSN1Decoder3.decodeIntegerAsInt();
        }
        if (aSN1Decoder.nextIsOptional(ASN1Tag.makeContextTag((int)1))) {
            this.b = null;
        } else {
            ASN1Decoder aSN1Decoder4 = aSN1Decoder;
            aSN1Decoder4.nextIsImplicit(ASN1Tag.makeContextTag((int)1));
            this.b = aSN1Decoder4.decodeInteger();
        }
        if (aSN1Decoder.nextIsOptional(ASN1Tag.makeExplicitTag((int)2))) {
            this.c = null;
        } else {
            aSN1Decoder.nextIsImplicit(ASN1Tag.makeContextTag((int)2));
            if (this.c == null) {
                AlgorithmID algorithmID2;
                algorithmID = algorithmID2;
                algorithmID2 = new AlgorithmID();
                this.c = algorithmID;
            }
            this.c.decode(aSN1Decoder);
        }
        if (aSN1Decoder.nextIsOptional(ASN1Tag.makeExplicitTag((int)3))) {
            this.d.clear();
        } else {
            ASN1Decoder aSN1Decoder5 = aSN1Decoder;
            int n3 = aSN1Decoder5.decodeExplicit(ASN1Tag.makeContextTag((int)3));
            this.d.decode(aSN1Decoder);
            aSN1Decoder5.endOf(n3);
        }
        if (aSN1Decoder.nextIsOptional(ASN1Tag.makeExplicitTag((int)4))) {
            CertTemplate certTemplate = this;
            certTemplate.e.setNotBefore(null);
            certTemplate.e.setNotAfter(null);
        } else {
            aSN1Decoder.nextIsImplicit(ASN1Tag.makeContextTag((int)4));
            this.e.decode(aSN1Decoder);
        }
        if (aSN1Decoder.nextIsOptional(ASN1Tag.makeExplicitTag((int)5))) {
            this.f.clear();
        } else {
            ASN1Decoder aSN1Decoder6 = aSN1Decoder;
            int n4 = aSN1Decoder6.decodeExplicit(ASN1Tag.makeContextTag((int)5));
            this.f.decode(aSN1Decoder);
            aSN1Decoder6.endOf(n4);
        }
        if (aSN1Decoder.nextIsOptional(ASN1Tag.makeExplicitTag((int)6))) {
            this.g = null;
        } else {
            aSN1Decoder.nextIsImplicit(ASN1Tag.makeContextTag((int)6));
            if (this.g == null) {
                PublicKeyInfo publicKeyInfo;
                algorithmID = publicKeyInfo;
                publicKeyInfo = new PublicKeyInfo();
                this.g = algorithmID;
            }
            this.g.decode(aSN1Decoder);
        }
        if (aSN1Decoder.nextIsOptional(ASN1Tag.makeContextTag((int)7))) {
            this.h = null;
        } else {
            ASN1Decoder aSN1Decoder7 = aSN1Decoder;
            aSN1Decoder7.nextIsImplicit(ASN1Tag.makeContextTag((int)7));
            this.h = aSN1Decoder7.decodeBitString();
        }
        if (aSN1Decoder.nextIsOptional(ASN1Tag.makeContextTag((int)8))) {
            this.i = null;
        } else {
            ASN1Decoder aSN1Decoder8 = aSN1Decoder;
            aSN1Decoder8.nextIsImplicit(ASN1Tag.makeContextTag((int)8));
            this.i = aSN1Decoder8.decodeBitString();
        }
        if (aSN1Decoder.nextIsOptional(ASN1Tag.makeExplicitTag((int)9))) {
            this.j.clear();
        } else {
            aSN1Decoder.nextIsImplicit(ASN1Tag.makeContextTag((int)9));
            this.j.decode(aSN1Decoder);
        }
        aSN1Decoder.endOf(n2);
    }

    public int getVersion() {
        return this.a + 1;
    }

    public void setVersion(int n2) {
        if (n2 > 0 && n2 < 4) {
            CertTemplate certTemplate = this;
            certTemplate.a = n2 - 1;
            certTemplate.modified = true;
        }
    }

    public BigInteger getSerialNumber() {
        return this.b;
    }

    public void setSerialNumber(BigInteger bigInteger) {
        CertTemplate certTemplate = this;
        certTemplate.modified = true;
        certTemplate.b = new BigInteger(bigInteger.toByteArray());
    }

    public void setSignatureAlg(AlgorithmID algorithmID) {
        this.modified = true;
        this.c = (AlgorithmID)algorithmID.clone();
    }

    public AlgorithmID getSignatureAlg() {
        CertTemplate certTemplate = certTemplate.c;
        if (certTemplate == null) {
            return null;
        }
        return (AlgorithmID)certTemplate.clone();
    }

    public Name getIssuer() {
        return this.d;
    }

    public Name getSubject() {
        return this.f;
    }

    public Date getNotAfter() {
        return this.e.getNotAfter();
    }

    public Date getNotBefore() {
        return this.e.getNotBefore();
    }

    public byte[] getIssuerUniqueID() {
        return this.h.getAsByteArray();
    }

    public byte[] getSubjectUniqueID() {
        return this.i.getAsByteArray();
    }

    public void setIssuerDN(Name name) {
        CertTemplate certTemplate = this;
        certTemplate.modified = true;
        certTemplate.d = name;
    }

    public void setIssuerDN(String string) {
        this.modified = true;
        this.d.set(string);
    }

    public void setSubjectDN(Name name) {
        CertTemplate certTemplate = this;
        certTemplate.modified = true;
        certTemplate.f = name;
    }

    public void setSubjectDN(String string) {
        this.modified = true;
        this.f.set(string);
    }

    public byte[] getPublicKeyAsIdentifier() {
        return this.g.getPublicKeyAsIdentifier();
    }

    public PublicKey getPublicKey() {
        try {
            return this.g.getPublicKey();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setPublicKey(PublicKey publicKey) throws InvalidKeyException {
        this.modified = true;
        if (this.g == null) {
            PublicKeyInfo publicKeyInfo;
            PublicKeyInfo publicKeyInfo2 = publicKeyInfo;
            publicKeyInfo = new PublicKeyInfo();
            this.g = publicKeyInfo2;
        }
        this.g.setPublicKey(publicKey);
    }

    public void addExtension(Extension extension) {
        this.modified = true;
        this.j.add(extension);
    }

    public Extensions getExtensions() {
        return this.j;
    }

    public void setExtensions(Extensions extensions) {
        this.j = extensions;
    }

    public Extension getExtension(String string) {
        return this.j.getExtension(string);
    }

    public byte[] getExtensionValue(String string) {
        CertTemplate certTemplate = certTemplate.j.getExtension(string);
        if (certTemplate != null) {
            return certTemplate.getExtValue();
        }
        return null;
    }

    public void setNotBefore(Date date) {
        this.modified = true;
        this.e.setNotBefore(date);
    }

    public void setNotAfter(Date date) {
        this.modified = true;
        this.e.setNotAfter(date);
    }

    public void setForceGeneralizedTime(boolean bl) {
        this.e.setForceGeneralizedTime(bl);
    }

    public final boolean a() {
        return this.modified;
    }

    public void setFromCertificate(X509CertImpl x509CertImpl) {
        this.setFromCertificate(x509CertImpl, false);
    }

    public void setFromCertificate(X509CertImpl x509CertImpl, boolean n2) {
        CertTemplate certTemplate = this;
        this.a = x509CertImpl.getVersion() - 1;
        this.b = x509CertImpl.getSerialNumber();
        this.f = (Name)x509CertImpl.getSubjectDN();
        certTemplate.d = (Name)x509CertImpl.getIssuerDN();
        certTemplate.e.setNotBefore(x509CertImpl.getNotBefore());
        certTemplate.e.setNotAfter(x509CertImpl.getNotAfter());
        certTemplate.j.clear();
        if (n2 != 0) {
            x509CertImpl = x509CertImpl.getExtensions();
            for (n2 = 0; n2 < x509CertImpl.size(); ++n2) {
                this.j.add(x509CertImpl.elementAt(n2));
            }
        }
        this.modified = true;
    }

    public X509CertImpl getX509CertImpl() {
        X509CertImpl x509CertImpl;
        X509CertImpl x509CertImpl2 = x509CertImpl;
        x509CertImpl = new X509CertImpl();
        BigInteger bigInteger = this.b;
        if (bigInteger != null) {
            x509CertImpl2.setSerialNumber(bigInteger);
        }
        if ((bigInteger = this.c) != null) {
            x509CertImpl2.setSigAlg((AlgorithmID)bigInteger);
        }
        if (!this.d.isNullDN()) {
            x509CertImpl2.setIssuerDN(this.d);
        }
        if (this.e.getNotBefore() != null) {
            x509CertImpl2.setNotBefore(this.e.getNotBefore());
        }
        if (this.e.getNotAfter() != null) {
            x509CertImpl2.setNotAfter(this.e.getNotAfter());
        }
        if (this.e.useGeneralizedTime()) {
            x509CertImpl2.setForceGeneralizedTime();
        }
        if (!this.f.isNullDN()) {
            x509CertImpl2.setSubjectDN(this.f);
        }
        if ((bigInteger = this.g) != null) {
            try {
                x509CertImpl2.setPublicKey(bigInteger.getPublicKey());
            }
            catch (InvalidKeyException invalidKeyException) {}
        }
        for (int i2 = 0; i2 < this.j.size(); ++i2) {
            x509CertImpl2.addExtension(this.j.elementAt(i2));
        }
        return x509CertImpl2;
    }

    public Name getSubjectName() throws CertificateException {
        return this.f;
    }

    public SubjectAltName getSubjectAltName() throws CertificateException {
        try {
            Object object = object.getExtensionValue("2.5.29.17");
        }
        catch (Exception exception) {
            throw new CertificateException(exception.getMessage());
        }
        return new SubjectAltName((byte[])object);
    }

    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer(1024);
        if (this.a >= 0) {
            StringBuffer stringBuffer3 = stringBuffer2;
            stringBuffer2.append("Version : ");
            stringBuffer3.append(this.a);
            stringBuffer3.append('\n');
        }
        if (this.b != null) {
            StringBuffer stringBuffer4 = stringBuffer2;
            stringBuffer2.append("Serial Number : 0x");
            stringBuffer4.append(this.b.toString(16));
            stringBuffer4.append('\n');
        }
        if (this.c != null) {
            StringBuffer stringBuffer5 = stringBuffer2;
            stringBuffer2.append("Signature Algorithm : ");
            stringBuffer5.append(this.c.getAlgName());
            stringBuffer5.append('\n');
        }
        if (!this.d.isNullDN()) {
            StringBuffer stringBuffer6 = stringBuffer2;
            stringBuffer2.append("Issuer : ");
            stringBuffer6.append(this.d.toString());
            stringBuffer6.append('\n');
        }
        if (this.e.getNotBefore() != null) {
            StringBuffer stringBuffer7 = stringBuffer2;
            stringBuffer2.append("Not Before : ");
            stringBuffer7.append(this.e.getNotBefore().toString());
            stringBuffer7.append('\n');
        }
        if (this.e.getNotAfter() != null) {
            StringBuffer stringBuffer8 = stringBuffer2;
            stringBuffer2.append("Not After : ");
            stringBuffer8.append(this.e.getNotAfter().toString());
            stringBuffer8.append('\n');
        }
        if (!this.f.isNullDN()) {
            StringBuffer stringBuffer9 = stringBuffer2;
            stringBuffer2.append("Subject : ");
            stringBuffer9.append(this.f.toString());
            stringBuffer9.append('\n');
        }
        if (this.g != null) {
            StringBuffer stringBuffer10 = stringBuffer2;
            StringBuffer stringBuffer11 = stringBuffer2;
            stringBuffer2.append("Public Key : ");
            stringBuffer11.append(this.g.getAlgName());
            stringBuffer11.append('\n');
            stringBuffer10.append(Hex.prettyDump(this.g.getPublicKeyAsByteArray(), 48, ' ', 1));
            stringBuffer10.append('\n');
        }
        if (this.h != null) {
            StringBuffer stringBuffer12 = stringBuffer2;
            stringBuffer2.append("Issuer User Identifier : ");
            stringBuffer12.append(Hex.dumpHex(this.h.getAsByteArray()));
            stringBuffer12.append('\n');
        }
        if (this.i != null) {
            StringBuffer stringBuffer13 = stringBuffer2;
            stringBuffer2.append("Subject User Identifier : ");
            stringBuffer13.append(Hex.dumpHex(this.i.getAsByteArray()));
            stringBuffer13.append('\n');
        }
        if (this.j.size() > 0) {
            X509ExtensionBuilder x509ExtensionBuilder;
            StringBuffer stringBuffer14 = stringBuffer2;
            X509ExtensionBuilder x509ExtensionBuilder2 = x509ExtensionBuilder;
            x509ExtensionBuilder = new X509ExtensionBuilder();
            stringBuffer14.append("X509v3 Extensions :");
            stringBuffer14.append('\n');
            for (int i2 = 0; i2 < this.j.size(); ++i2) {
                x509ExtensionBuilder2.build(this.j.elementAt(i2)).toString(stringBuffer2, 1);
            }
        }
        return new String(stringBuffer2);
    }
}

