/*
 * Decompiled with CFR 0.152.
 */
package com.initech.xsafe;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import androidx.documentfile.provider.DocumentFile;
import com.initech.license.LicenseException;
import com.initech.license.LicenseManager;
import com.initech.provider.crypto.InitechProvider;
import com.initech.xsafe.cert.CertInfo;
import com.initech.xsafe.cert.CertUtil;
import com.initech.xsafe.cert.CertificateManager;
import com.initech.xsafe.cert.INIXSAFEException;
import com.initech.xsafe.storage.CertStorageManager;
import com.initech.xsafe.util.IniSafeBaseLog;
import com.initech.xsafe.util.mlog.IniSafeLog;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class INISAFEXSAFE {
    public static volatile int a = 1;
    public static volatile boolean b = false;
    public static volatile boolean c = false;

    public static String getVersion() {
        return "1.8.36";
    }

    public static void setUseBothStorage() {
        IniSafeLog.debug("\uc678\ubd80/\ub0b4\ubd80 \uc800\uc7a5\uc18c \ubaa8\ub450 \uc0ac\uc6a9\ud558\ub3c4\ub85d \uc124\uc815 \ud568");
        a = 3;
    }

    public static void setUseOnlyExternalStorage() {
        IniSafeLog.debug("\uc678\ubd80 \uc800\uc7a5\uc18c\ub9cc \uc0ac\uc6a9\ud558\ub3c4\ub85d \uc124\uc815 \ud568");
        a = 1;
    }

    public static void setUseOnlyInternalStorage() {
        IniSafeLog.debug("\ub0b4\ubd80 \uc800\uc7a5\uc18c\ub9cc \uc0ac\uc6a9\ud558\ub3c4\ub85d \uc124\uc815 \ud568");
        a = 2;
    }

    public static void setUseInternalOtherStorage() {
        b = true;
    }

    public static void setUseAtonStorage() {
        if (Build.VERSION.SDK_INT >= 23) {
            a = 4;
        } else {
            a = 2;
            c = true;
        }
    }

    public static void setUseExternalStorageFirst() {
        IniSafeLog.debug("\uc678\ubd80 \uc800\uc7a5\uc18c\ub97c \uc6b0\uc120\uc73c\ub85c \uc0ac\uc6a9\ud558\ub3c4\ub85d \uc124\uc815 \ud568");
        a = 5;
    }

    public static boolean isUseExternalStorage() {
        return a == 1 || a == 3 || a == 5;
    }

    public static boolean isUseInternalStorage() {
        return a == 2 || a == 3 || a == 5;
    }

    @Deprecated
    public static void setUseInternalStorage(boolean useInternalStorage) {
        if (useInternalStorage) {
            IniSafeLog.debug("\ub0b4\ubd80 \uc800\uc7a5\uc18c\ub9cc \uc0ac\uc6a9\ud558\ub3c4\ub85d \uc124\uc815 \ud568");
            a = 2;
        } else {
            IniSafeLog.debug("\uc678\ubd80 \uc800\uc7a5\uc18c\ub9cc \uc0ac\uc6a9\ud558\ub3c4\ub85d \uc124\uc815 \ud568");
            a = 1;
        }
    }

    public static boolean isUseInternalOtherStorage() {
        return b;
    }

    public static boolean isUseAtonStorage() {
        return a == 4;
    }

    public static boolean isUseTwoFactorEncryption() {
        return c;
    }

    public static void setUseTwoFactorEncryption(boolean useTwoFactorEncryption) {
        c = useTwoFactorEncryption;
    }

    public static int getUseStorageType() {
        return a;
    }

    /*
     * WARNING - void declaration
     */
    public static void setLicense(Context context, String licenseFileName) {
        try {
            Context context2;
            void var1_2;
            INISAFEXSAFE.checkLicense(context.getAssets().open((String)var1_2), context2.getPackageName());
        }
        catch (IOException iOException) {
            IniSafeLog.error("License file open failed.", iOException);
        }
    }

    public static void setLicense(InputStream licenseStream) {
        INISAFEXSAFE.checkLicense(licenseStream);
    }

    public static boolean hasLicense() {
        return true;
    }

    public static void setLogger(int level) {
        IniSafeBaseLog.setLevel(level);
    }

    public static void setDebugLogger(boolean flag) {
        IniSafeBaseLog.setLevel(flag ? 2 : 5);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean checkLicense(InputStream licenseStream, String applicationId) {
        String string = "INISAFEMobilianWeb(J)";
        if (applicationId != null) {
            void var1_2;
            string = string + "__" + (String)var1_2;
        }
        try {
            InputStream inputStream;
            LicenseManager.getVerifier(inputStream, string).doVerify();
            return true;
        }
        catch (LicenseException licenseException) {
            IniSafeLog.error("\ub77c\uc774\uc120\uc2a4 \uac80\uc99d\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.", licenseException);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean checkLicense(String license, String applicationId) {
        String string = "INISAFEMobilianWeb(J)";
        if (applicationId != null) {
            void var1_2;
            string = string + "__" + (String)var1_2;
        }
        try {
            String string2;
            LicenseManager.getVerifier(string2, string).doVerify();
            return true;
        }
        catch (LicenseException licenseException) {
            IniSafeLog.error("\ub77c\uc774\uc120\uc2a4 \uac80\uc99d\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.", licenseException);
            return false;
        }
    }

    public static boolean checkLicense(InputStream licenseStream) {
        return INISAFEXSAFE.checkLicense(licenseStream, null);
    }

    public static boolean checkLicense(String license) {
        return INISAFEXSAFE.checkLicense(license, null);
    }

    public static void changeMode() {
        InitechProvider.changeMode();
    }

    public static boolean backupExist(Context context) {
        return context.getSharedPreferences("com_initech_xsafe_shared_pref", 0).getBoolean("preference_key_exist_backup", false);
    }

    public static void a(Context context) {
        SharedPreferences.Editor editor = context.getSharedPreferences("com_initech_xsafe_shared_pref", 0).edit();
        editor.putBoolean("preference_key_exist_backup", true);
        editor.apply();
    }

    public static boolean backupAvailable(Context context) {
        Context context2;
        return new CertificateManager(context2, 1).getCertList().size() > 0;
    }

    public static int backupCertList(Context context) {
        Context context2;
        return INISAFEXSAFE.a(context, new CertificateManager(context2, 1).getAllCertList());
    }

    public static int backupCertListExpiredFilter(Context context) {
        Context context2;
        CertificateManager certificateManager = new CertificateManager(context2, 1);
        return INISAFEXSAFE.a(context, certificateManager.getCertListExpiredFilter(certificateManager.getAllCertList()));
    }

    /*
     * WARNING - void declaration
     */
    public static int backupCertListIssuerCnFilter(Context context, String issuerCnFilter) {
        void var1_1;
        Context context2;
        CertificateManager certificateManager = new CertificateManager(context2, 1);
        return INISAFEXSAFE.a(context, certificateManager.getCertListIssuerCnFilter(certificateManager.getAllCertList(), (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static int backupCertListIssuerDnFilter(Context context, String issuerDnFilter) {
        void var1_1;
        Context context2;
        CertificateManager certificateManager = new CertificateManager(context2, 1);
        return INISAFEXSAFE.a(context, certificateManager.getCertListIssuerDnFilter(certificateManager.getAllCertList(), (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static int backupCertListOidFilter(Context context, String oidFilter) {
        void var1_1;
        Context context2;
        CertificateManager certificateManager = new CertificateManager(context2, 1);
        return INISAFEXSAFE.a(context, certificateManager.getCertListOidFilter(certificateManager.getAllCertList(), (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static int backupCertListOidAliasFilter(Context context, String oidAliasFilter) {
        void var1_1;
        Context context2;
        CertificateManager certificateManager = new CertificateManager(context2, 1);
        return INISAFEXSAFE.a(context, certificateManager.getCertListOidAliasFilter(certificateManager.getAllCertList(), (String)var1_1));
    }

    public static int a(Context context, ArrayList<CertInfo> arrayList) {
        int n2;
        switch (a) {
            default: {
                return 0;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
            }
        }
        int n3 = 0;
        for (CertInfo certInfo : arrayList) {
            CertInfo certInfo2 = certInfo;
            X509Certificate x509Certificate = CertUtil.getCertificate(certInfo.certPath, 1);
            try {
                if (CertStorageManager.saveCertificateAndPrivateKey(context, n2, x509Certificate, CertUtil.getPrivateKey(certInfo2.priPath, 1), true, false) == null) continue;
                ++n3;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (n3 > 0) {
            INISAFEXSAFE.a(context);
        }
        return n3;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int backupCertList(Context context, DocumentFile npkiDir) throws INIXSAFEException {
        void var0_3;
        int n2;
        void var1_4;
        if (!CertUtil.isReadPermissionGranted(context, var1_4.getUri())) {
            throw new INIXSAFEException("\uc77d\uae30 \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.", "6306");
        }
        switch (a) {
            default: {
                throw new INIXSAFEException("\ubc31\uc5c5\ud560 \uc800\uc7a5\uc18c\uac00 \uc9c0\uc815\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.", "6307");
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
            }
        }
        int n3 = 0;
        try {
            Context context2;
            ArrayList<byte[][]> arrayList = CertUtil.getCertPriListFromNpkiDir(context2, (DocumentFile)var1_4);
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                Object object = arrayList.get(i2);
                if (object[0] != null && object[1] != null) {
                    X509Certificate x509Certificate = CertUtil.getX509Certificate(object[0]);
                    if (CertStorageManager.saveCertificateAndPrivateKey(context2, n2, x509Certificate, object[1], true, false) != null) {
                        IniSafeLog.debug("\uc11c\uba85\uc6a9 \uc778\uc99d\uc11c \ubc31\uc5c5 \uc131\uacf5 [" + i2 + "]: " + x509Certificate.getSubjectDN());
                        ++n3;
                    } else {
                        IniSafeLog.debug("\uc11c\uba85\uc6a9 \uc778\uc99d\uc11c \ubc31\uc5c5 \uc2e4\ud328 [" + i2 + "]: " + x509Certificate.getSubjectDN());
                    }
                }
                if (object[2] == null || object[3] == null) continue;
                if (CertStorageManager.saveCertificateAndPrivateKey(context2, n2, (X509Certificate)(object = (Object)CertUtil.getX509Certificate(object[2])), object[3], true, false) != null) {
                    IniSafeLog.debug("\uc554\ud638\ud654\uc6a9 \uc778\uc99d\uc11c \ubc31\uc5c5 \uc131\uacf5 [" + i2 + "]: " + object.getSubjectDN());
                    continue;
                }
                IniSafeLog.debug("\uc554\ud638\ud654\uc6a9 \uc778\uc99d\uc11c \ubc31\uc5c5 \uc2e4\ud328 [" + i2 + "]: " + object.getSubjectDN());
            }
        }
        catch (INIXSAFEException iNIXSAFEException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return n3;
        IniSafeLog.error("\uc778\uc99d\uc11c \ubc31\uc5c5 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.", (Throwable)var0_3);
        throw new INIXSAFEException("\uc778\uc99d\uc11c \ubc31\uc5c5 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.", (Throwable)var0_3, "6307");
    }

    /*
     * WARNING - void declaration
     */
    public static int backupCertListToExternal(Context context, DocumentFile npkiDir) throws INIXSAFEException {
        void var1_4;
        if (CertUtil.isWritePermissionGranted(context, var1_4.getUri())) {
            void var0_3;
            block18: {
                ArrayList<CertInfo> arrayList;
                Context context2;
                CertificateManager certificateManager;
                int n2;
                switch (a) {
                    default: {
                        throw new INIXSAFEException("\ubc31\uc5c5\ud560 \uc800\uc7a5\uc18c\uac00 \uc9c0\uc815\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.", "6307");
                    }
                    case 4: {
                        n2 = 4;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: {
                        n2 = 2;
                    }
                }
                CertificateManager certificateManager2 = certificateManager;
                certificateManager = new CertificateManager(context2, n2);
                Object object = arrayList;
                ((ArrayList)object)();
                ((ArrayList)object).addAll(certificateManager2.getCertList());
                arrayList.addAll(certificateManager2.getKMCertList());
                int n3 = 0;
                try {
                    object = arrayList.iterator();
                }
                catch (INIXSAFEException iNIXSAFEException) {
                    break block18;
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
                while (true) {
                    Object object2;
                    block17: {
                        if (!object.hasNext()) break;
                        Context context3 = context2;
                        int n4 = n2;
                        Object object3 = (CertInfo)object.next();
                        object2 = CertStorageManager.loadCertificateBytes(context3, n4, ((CertInfo)object3).certPath);
                        object3 = CertStorageManager.loadPrivateKeyBytes(context2, n2, ((CertInfo)object3).priPath);
                        if (object2 == null || object3 == null) continue;
                        Context context4 = context2;
                        void v5 = var1_4;
                        X509Certificate x509Certificate = CertUtil.getX509Certificate((byte[])object2);
                        object2 = x509Certificate;
                        if (CertStorageManager.saveCertificateAndPrivateKey(context4, (DocumentFile)v5, x509Certificate, (byte[])object3, true) == null) break block17;
                        IniSafeLog.debug("\uc778\uc99d\uc11c \ubc31\uc5c5 \uc131\uacf5 : " + ((X509Certificate)object2).getSubjectDN());
                        ++n3;
                        continue;
                    }
                    IniSafeLog.debug("\uc778\uc99d\uc11c \ubc31\uc5c5 \uc2e4\ud328 : " + ((X509Certificate)object2).getSubjectDN());
                    continue;
                    break;
                }
                return n3;
            }
            IniSafeLog.error("\uc778\uc99d\uc11c \ubc31\uc5c5 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.", (Throwable)var0_3);
            throw new INIXSAFEException("\uc778\uc99d\uc11c \ubc31\uc5c5 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.", (Throwable)var0_3, "6307");
        }
        throw new INIXSAFEException("\uc4f0\uae30 \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.", "6308");
    }

    public static void decryptTwoFactorEncryption(Context context) throws INIXSAFEException {
        Context context2;
        CertificateManager certificateManager;
        Context context3 = context;
        CertificateManager certificateManager2 = certificateManager;
        INISAFEXSAFE.b(context3, new CertificateManager(context2, 2).getCertList());
        INISAFEXSAFE.b(context3, certificateManager2.getKMCertList());
        INISAFEXSAFE.b(context3, certificateManager2.getGPKIEncCertList());
    }

    public static void b(Context context, ArrayList<CertInfo> object) throws INIXSAFEException {
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            CertInfo certInfo = (CertInfo)object.next();
            byte[] byArray = CertStorageManager.loadPrivateKeyBytes(context, 2, certInfo.priPath);
            String string = certInfo.priPath;
            CertStorageManager.savePrivateKey(context, 2, false, string, byArray);
        }
    }

    static {
        InitechProvider.changeMode();
        if (Build.VERSION.SDK_INT >= 31) {
            a = 2;
        }
    }
}

