/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1StringFactory;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.cryptox.util.Hex;
import java.io.Serializable;
import java.util.Arrays;

public class ASN1Any
implements Serializable {
    private static final long serialVersionUID = 5175342535273862589L;
    private byte[] data;

    public ASN1Any() {
        this.data = null;
    }

    public ASN1Any(byte[] d) {
        this.data = d;
    }

    public boolean equals(Object o) {
        if (o instanceof ASN1Any) {
            return Arrays.equals(this.data, ((ASN1Any)o).getValue());
        }
        if (o instanceof byte[]) {
            return Arrays.equals(this.data, (byte[])o);
        }
        return false;
    }

    public void setValue(byte[] d) {
        this.data = d;
    }

    public void setValue(ASN1Type e) throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        e.encode(enc);
        this.data = enc.toByteArray();
    }

    public byte[] getValue() {
        return this.data;
    }

    public String getValueAsString() throws ASN1Exception {
        ASN1Decoder dec = this.getDecoder();
        if (dec == null) {
            return null;
        }
        return ASN1Any.decodeAsString(dec);
    }

    public void setString(String src) throws ASN1Exception {
        this.setString(src, -1);
    }

    public void setString(String src, int type) throws ASN1Exception {
        DEREncoder enc = new DEREncoder();
        ASN1Any.encodeAsString(enc, src, type);
        this.data = enc.toByteArray();
        enc.finish();
    }

    public ASN1Decoder getDecoder() {
        DERDecoder dec = null;
        if (this.data != null) {
            dec = new DERDecoder(this.data);
        }
        return dec;
    }

    public static String decodeAsString(ASN1Decoder dec) throws ASN1Exception {
        int[] t = new int[1];
        return ASN1Any.decodeAsString(dec, t);
    }

    public static String decodeAsString(ASN1Decoder dec, int[] tg) throws ASN1Exception {
        String ret = null;
        int tag = dec.peekNextTag();
        switch (tag) {
            case 20: {
                ret = dec.decodeT61String();
                break;
            }
            case 19: {
                ret = dec.decodePrintableString();
                break;
            }
            case 26: {
                ret = dec.decodeVisibleString();
                break;
            }
            case 22: {
                ret = dec.decodeIA5String();
                break;
            }
            case 12: {
                ret = dec.decodeUTF8String();
                break;
            }
            case 30: {
                ret = dec.decodeBMPString();
                break;
            }
            case 18: {
                ret = dec.decodeNumericString();
                break;
            }
            case 4: {
                byte[] d = dec.decodeOctetString();
                ret = Hex.prettyDump(d);
            }
            default: {
                throw new ASN1Exception("Unsupported String Type : " + tag);
            }
        }
        tg[0] = tag;
        return ret;
    }

    public byte[] getEncoded() {
        return this.data;
    }

    public void fixTag(int tag) {
        if (tag == 16 || tag == 17) {
            tag |= 0x20;
        }
        this.data[0] = (byte)tag;
    }

    public static void encodeAsString(ASN1Encoder enc, String src) throws ASN1Exception {
        ASN1Any.encodeAsString(enc, src, -1);
    }

    public static void encodeAsString(ASN1Encoder enc, String src, int tg) throws ASN1Exception {
        int tag = tg <= 0 ? ASN1StringFactory.identifyStringTag(src) : tg;
        switch (tag) {
            case 18: {
                enc.encodeNumericString(src);
                break;
            }
            case 19: {
                enc.encodePrintableString(src);
                break;
            }
            case 26: {
                enc.encodeVisibleString(src);
                break;
            }
            case 20: {
                enc.encodeT61String(src);
                break;
            }
            case 22: {
                enc.encodeIA5String(src);
                break;
            }
            case 12: {
                enc.encodeUTF8String(src);
                break;
            }
            case 30: {
                enc.encodeBMPString(src);
                break;
            }
            case 4: {
                byte[] d = Hex.parseHexaString(src);
                enc.encodeOctetString(d);
            }
        }
    }
}

