/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1;

import java.io.Serializable;

public class ASN1BitString
implements Serializable {
    private static final long serialVersionUID = -2305802558741639408L;
    private int unused;
    private byte[] value;
    private static final byte[] BITMASKS = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private static final byte[] CLEARMASKS = new byte[]{-1, -2, -4, -8, -16, -32, -64, -128, 0};

    public ASN1BitString() {
        this.value = null;
        this.unused = 0;
    }

    public ASN1BitString(int unused, byte[] val) {
        this.unused = unused;
        this.value = (byte[])val.clone();
    }

    public ASN1BitString(boolean[] val) {
        this.setFromBooleanArray(val);
    }

    public ASN1BitString(boolean[] val, boolean adj) {
        this.setFromBooleanArray(val, adj);
    }

    public void setByteArray(byte[] val) {
        this.value = val;
    }

    public void setUnusedBits(int n) {
        this.unused = n;
    }

    public int getUnusedBits() {
        return this.unused;
    }

    public byte[] getAsByteArray() {
        if (this.value != null && this.unused > 0) {
            byte last = this.value[this.value.length - 1];
            this.value[this.value.length - 1] = (byte)(last & CLEARMASKS[this.unused]);
        }
        return this.value;
    }

    public boolean[] getAsBooleanArray() {
        if (this.value == null) {
            return null;
        }
        int bits = this.value.length * 8 - this.unused;
        boolean[] ret = new boolean[bits];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < bits) {
            ret[i] = (byte)(this.value[k] & BITMASKS[j]) != 0;
            j = (j + 1) % 8;
            k = ++i / 8;
        }
        return ret;
    }

    public void setFromBooleanArray(boolean[] arr) {
        this.setFromBooleanArray(arr, false);
    }

    public void setFromBooleanArray(boolean[] arr, boolean adj) {
        int l = arr.length;
        if (adj) {
            while (!arr[l - 1]) {
                --l;
            }
        }
        int bytes = l / 8;
        this.unused = l % 8 == 0 ? 0 : 8 - l % 8;
        if (this.unused > 0) {
            ++bytes;
        }
        byte[] newVal = new byte[bytes];
        newVal[bytes - 1] = 0;
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < l) {
            if (arr[i]) {
                int n = k;
                newVal[n] = (byte)(newVal[n] | BITMASKS[j]);
            } else {
                int n = k;
                newVal[n] = (byte)(newVal[n] & ~BITMASKS[j]);
            }
            j = (j + 1) % 8;
            k = ++i / 8;
        }
        this.value = newVal;
    }
}

