/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1;

import com.initech.asn1.OIDDictionary;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class ASN1OID
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8228558817970406196L;
    private String value;
    private static int exp2 = (int)Math.pow(128.0, 2.0);
    private static int exp3 = (int)Math.pow(128.0, 3.0);
    private static int[] mults = new int[]{1, 128, exp2, exp3};

    public ASN1OID() {
        this.value = null;
    }

    public ASN1OID(String oid) {
        this.set(oid);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object clone() {
        ASN1OID ret = new ASN1OID();
        ret.set(this.value);
        return ret;
    }

    public void set(ASN1OID oid) {
        this.value = new String(oid.get());
    }

    public void set(String oid) {
        if (ASN1OID.isOID(oid)) {
            this.value = new String(oid);
        } else {
            this.value = OIDDictionary.getOIDbyName(oid);
            if (this.value == null) {
                // empty if block
            }
        }
    }

    public String getName() {
        String ret = OIDDictionary.getNamebyOID(this.value);
        if (ret != null) {
            return ret;
        }
        return this.value;
    }

    public String get() {
        return this.value;
    }

    public int getCategory() {
        return OIDDictionary.getCategorybyOID(this.value);
    }

    public boolean equals(Object object) {
        if (this.value == null) {
            return false;
        }
        if (object instanceof ASN1OID) {
            object = ((ASN1OID)object).get();
        }
        if (object instanceof String) {
            return this.value.equals((String)object);
        }
        return false;
    }

    public void decode(byte[] oidBytes) {
        int i;
        int numBytes;
        int valueX = 0;
        Vector<Integer> comps = new Vector<Integer>();
        valueX = oidBytes[0] / 40;
        comps.addElement(new Integer(valueX));
        valueX = oidBytes[0] % 40;
        comps.addElement(new Integer(valueX));
        for (i = 1; i < oidBytes.length; i += numBytes) {
            valueX = 0;
            numBytes = 1;
            if ((oidBytes[i] & 0x80) != 0) {
                while ((oidBytes[i + numBytes] & 0x80) != 0) {
                    ++numBytes;
                }
                ++numBytes;
            }
            for (int j = 0; j < numBytes; ++j) {
                int exponent = numBytes - j - 1;
                int multiplier = mults[exponent];
                int k = oidBytes[i + j] & 0x7F;
                valueX += multiplier * k;
            }
            comps.addElement(new Integer(valueX));
        }
        this.value = new String(comps.elementAt(0).toString());
        for (i = 1; i < comps.size(); ++i) {
            this.value = this.value.concat(".");
            this.value = this.value.concat(comps.elementAt(i).toString());
        }
    }

    public byte[] encode() {
        Vector<Object> numbers = new Vector<Object>();
        Vector<byte[]> bytes = new Vector<byte[]>();
        if (this.value == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(this.value, ".", false);
        while (st.hasMoreElements()) {
            numbers.addElement(st.nextElement());
        }
        byte[] ba = new byte[]{0};
        ba[0] = (byte)(Integer.parseInt((String)numbers.elementAt(0)) * 40);
        ba[0] = (byte)(ba[0] + (byte)Integer.parseInt((String)numbers.elementAt(1)));
        bytes.addElement(ba);
        int cl = 1;
        for (int i = 2; i < numbers.size(); ++i) {
            int num = Integer.parseInt((String)numbers.elementAt(i));
            int l = 1;
            if (num / mults[3] > 0) {
                l = 4;
            } else if (num / mults[2] > 0) {
                l = 3;
            } else if (num / mults[1] > 0) {
                l = 2;
            }
            ba = new byte[l];
            for (int j = 0; j < l; ++j) {
                int k = l - j - 1;
                ba[j] = (byte)(num / mults[k]);
                num -= ba[j] * mults[k];
                if (j >= l - 1) continue;
                ba[j] = (byte)(ba[j] | 0xFFFFFF80);
            }
            bytes.addElement(ba);
            cl += l;
        }
        byte[] contents = new byte[cl];
        int j = 0;
        for (int i = 0; i < bytes.size(); ++i) {
            ba = (byte[])bytes.elementAt(i);
            System.arraycopy(ba, 0, contents, j, ba.length);
            j += ba.length;
        }
        return contents;
    }

    public static boolean isOID(String src) {
        int status = 0;
        block4: for (int i = 0; i < src.length(); ++i) {
            char ch = src.charAt(i);
            switch (status) {
                case 0: {
                    if (ch < '0' || ch > '9') {
                        return false;
                    }
                    ++status;
                    continue block4;
                }
                case 1: {
                    if (ch == '.') {
                        --status;
                        continue block4;
                    }
                    if (ch >= '0' && ch <= '9') continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    public String toString() {
        return this.getName();
    }
}

