/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1;

import com.initech.asn1.IllegalCharactersException;

public class ASN1StringFactory {
    private static final byte P = 1;
    private static final byte I = 2;
    private static final byte N = 4;
    private static final byte V = 8;
    private static final byte PI = 3;
    private static final byte IV = 10;
    private static final byte PIN = 7;
    private static final byte PIV = 11;
    private static final byte PINV = 15;
    private static byte[] charFlags = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 10, 10, 2, 2, 10, 10, 11, 11, 11, 10, 11, 11, 11, 11, 11, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 11, 10, 10, 11, 10, 11, 2, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 2, 2, 2, 2, 2, 2, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 2, 2, 2, 2, 0};
    private static final int NUMERIC = 0;
    private static final int PRINTABLE = 1;
    private static final int VISIBLE = 2;
    private static final int IA5 = 3;
    private static final int UTF8 = 4;
    public static final String DIRECTORY_STRING = "DIRECTORYSTRING";
    public static final String IA5_STRING = "IA5STRING";
    public static final String PRINTABLE_STRING = "PRINTABLESTRING";
    public static final String UTF8_STRING = "UTF8STRING";
    public static final String NUMERIC_STRING = "NUMERICSTRING";
    public static final String VISIBLE_STRING = "VISIBLESTRING";
    public static final String PKCS9_STRING = "PKCS9STRING";
    public static final String PKCS9DIRECTORY_STRING = "PKCS9DIRECTORYSTRING";

    public static boolean isPrintable(byte ch) {
        return ch >= 0 && (charFlags[ch] & 1) != 0;
    }

    public static boolean isIA5(byte ch) {
        return ch >= 0 && (charFlags[ch] & 2) != 0;
    }

    public static boolean isVisible(byte ch) {
        return ch >= 0 && (charFlags[ch] & 8) != 0;
    }

    public static boolean isNumeric(byte ch) {
        return ch >= 0 && (charFlags[ch] & 4) != 0;
    }

    public static int identifyStringTag(String type, String src) throws IllegalCharactersException {
        int tag = ASN1StringFactory.identifyStringTag(src);
        if (type.equals(DIRECTORY_STRING)) {
            if (tag == 18) {
                tag = 19;
            } else if (tag == 22 || tag == 26) {
                tag = 20;
            }
        } else if (type.equals(PRINTABLE_STRING)) {
            if (tag != 19 && tag != 18) {
                throw new IllegalCharactersException(type, src);
            }
            tag = 19;
        } else if (type.equals(IA5_STRING)) {
            if (tag == 12) {
                throw new IllegalCharactersException(type, src);
            }
            tag = 22;
        } else if (type.equals(UTF8_STRING)) {
            tag = 12;
        } else if (type.equals(VISIBLE_STRING)) {
            if (tag == 22 || tag == 12) {
                throw new IllegalCharactersException(type, src);
            }
            tag = 26;
        } else if (type.equals(NUMERIC_STRING)) {
            if (tag != 18) {
                throw new IllegalCharactersException(type, src);
            }
            tag = 18;
        } else if (type.equals(PKCS9_STRING)) {
            if (tag != 12) {
                tag = 22;
            }
        } else if (type.equals(PKCS9DIRECTORY_STRING)) {
            tag = tag == 19 || tag == 18 ? 19 : 12;
        }
        return tag;
    }

    public static int identifyStringTag(String src) {
        int ret = 0;
        int type = 0;
        byte[] p = src.getBytes();
        try {
            p = src.getBytes("UTF8");
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 0; i < p.length; ++i) {
            if (ASN1StringFactory.isNumeric(p[i])) continue;
            if (ASN1StringFactory.isPrintable(p[i])) {
                if (type >= 1) continue;
                type = 1;
                continue;
            }
            if (ASN1StringFactory.isVisible(p[i])) {
                if (type >= 2) continue;
                type = 2;
                continue;
            }
            if (ASN1StringFactory.isIA5(p[i])) {
                if (type >= 3) continue;
                type = 3;
                continue;
            }
            type = 4;
            break;
        }
        switch (type) {
            case 0: {
                ret = 18;
                break;
            }
            case 1: {
                ret = 19;
                break;
            }
            case 2: {
                ret = 26;
                break;
            }
            case 3: {
                ret = 22;
                break;
            }
            case 4: {
                ret = 12;
            }
        }
        return ret;
    }

    public static boolean isString(int tag) {
        switch (tag) {
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 30: {
                return true;
            }
        }
        return false;
    }
}

