/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1;

public abstract class ASN1Tag {
    public static final int UNIVERSAL_TAG_CLASS = 0;
    public static final int APPLICATION_TAG_CLASS = 64;
    public static final int CONTEXT_TAG_CLASS = 128;
    public static final int PRIVATE_TAG_CLASS = 192;
    public static final int TAG_CLASS_MASK = 192;
    public static final int TAG_NUMBER_MASK = 31;
    public static final int TAG_PRIMITIVE = 0;
    public static final int TAG_CONSTRUCTED = 32;
    public static final int INDEF_LEN = -1;
    public static final int ANY = 0;
    public static final int INVALID = 0;
    public static final int BOOLEAN = 1;
    public static final int INTEGER = 2;
    public static final int BITSTRING = 3;
    public static final int OCTETSTRING = 4;
    public static final int NULL = 5;
    public static final int OID = 6;
    public static final int ENUMERATION = 10;
    public static final int UTF8STRING = 12;
    public static final int SEQUENCE = 16;
    public static final int SET = 17;
    public static final int NUMERICSTRING = 18;
    public static final int PRINTABLESTRING = 19;
    public static final int T61STRING = 20;
    public static final int IA5STRING = 22;
    public static final int UTCTIME = 23;
    public static final int GENERALIZEDTIME = 24;
    public static final int VISIBLESTRING = 26;
    public static final int BMPSTRING = 30;

    public static int getTagClass(int tag) {
        return tag & 0xC0;
    }

    public static int getTagNumber(int tag) {
        return tag & 0x1F;
    }

    public static int changeTagClass(int srcTag, int tClass) {
        return (srcTag &= 0xFFFFFF3F) | tClass;
    }

    public static int makeTag(int tagClass, int tagNumber) {
        return tagClass | tagNumber;
    }

    public static int makeUniversalTag(int tagNumber) {
        return ASN1Tag.makeTag(0, tagNumber);
    }

    public static int makeExplicitTag(int tagClass, int tagNumber) {
        return ASN1Tag.makeTag(tagClass, tagNumber | 0x20);
    }

    public static int makeExplicitTag(int tagNumber) {
        return ASN1Tag.makeContextTag(0xA0 | tagNumber);
    }

    public static int makeContextTag(int tagNumber) {
        return ASN1Tag.makeTag(128, tagNumber);
    }

    public static int makeApplicationTag(int tagNumber) {
        return ASN1Tag.makeTag(64, tagNumber);
    }

    public static int makePrivateTag(int tagNumber) {
        return ASN1Tag.makeTag(192, tagNumber);
    }

    public static String universalTagNumberToString(int tag) throws IllegalArgumentException {
        if ((tag & 0xC0) != 0) {
            throw new IllegalArgumentException("not universal tag");
        }
        return "";
    }

    public static String tagClassToString(int tag) {
        switch (tag & 0xC0) {
            case 0: {
                return "UNIVERSAL";
            }
            case 128: {
                return "CONTEXT SPECIFIC";
            }
            case 64: {
                return "APPLICATION";
            }
            case 192: {
                return "PRIVATE";
            }
        }
        return "UNKNOWN";
    }

    public static String tagToString(int tag) {
        return "";
    }
}

