/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1;

import com.initech.asn1.ASN1Any;
import com.initech.asn1.ASN1BitString;
import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.DecStatus;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Stack;
import java.util.TimeZone;

public class BERDecoder
extends ASN1Decoder {
    protected PushbackInputStream input;
    protected boolean constructed;
    protected int valueLength;
    protected int tag;
    protected int implicitTag;
    protected Stack currStack;
    protected int stackPos;
    protected int readOctets;
    protected boolean forbidIndef = false;
    public static final int SIZE_MIN = 0;
    public static final int DEFAULT_STACK_CHUNK_SIZE = 64;
    private static final String genTimeFormat = "yyyyMMddHHmmss.SSSZ";

    public BERDecoder(byte[] data) {
        this(data, 0, data.length);
    }

    public BERDecoder(byte[] data, int offset, int len) {
        ByteArrayInputStream bais = new ByteArrayInputStream(data, offset, len);
        this.input = new PushbackInputStream(new BufferedInputStream(bais), 8);
        this.readOctets = 0;
        this.currStack = new Stack();
        this.implicitTag = 0;
    }

    public BERDecoder(InputStream in) {
        this.input = new PushbackInputStream(new BufferedInputStream(in), 8);
        this.readOctets = 0;
        this.currStack = new Stack();
        this.implicitTag = 0;
    }

    public void allowIndefiniteLength(boolean allow) {
        this.forbidIndef = !allow;
    }

    public boolean IndefiniteLengthAllowed() {
        return !this.forbidIndef;
    }

    protected void pushBack(int b) throws ASN1Exception {
        try {
            this.input.unread(b);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.throwASN1Exception(ex);
        }
        --this.readOctets;
    }

    protected int getOctet() throws ASN1Exception {
        int ret = 0;
        try {
            ret = this.input.read();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new ASN1Exception(ex);
        }
        if (ret < 0) {
            this.throwASN1Exception("EOS");
        }
        ++this.readOctets;
        return ret;
    }

    protected byte[] getOctets(int len) throws ASN1Exception {
        byte[] ret = new byte[len];
        int idx = 0;
        try {
            while (len > 0) {
                int l = this.input.read(ret, idx, len);
                if (l < 0) {
                    this.throwASN1Exception("EOS");
                }
                idx += l;
                len -= l;
                this.readOctets += l;
            }
        }
        catch (IOException ex) {
            this.throwASN1Exception(ex);
        }
        return ret;
    }

    public String toString() {
        return "BER";
    }

    protected void decodeFinishing() {
        this.implicitTag = 0;
        this.tag = 0;
    }

    protected boolean decodeTagAndLength() throws ASN1Exception {
        this.tag = this.getOctet();
        this.constructed = (this.tag & 0x20) != 0;
        int tl = this.getOctet();
        if (tl == 128) {
            this.valueLength = -1;
            if (this.forbidIndef) {
                this.throwASN1Exception("INDEF encoding occured");
            }
        } else if ((tl & 0x80) == 0) {
            this.valueLength = tl;
        } else {
            this.valueLength = 0;
            int ll = tl & 0x7F;
            for (int i = 0; i < ll; ++i) {
                tl = this.getOctet();
                this.valueLength = this.valueLength << 8 | tl;
            }
        }
        return true;
    }

    protected boolean checkTag(int required) throws ASN1Exception {
        if ((required & 0x20) != 0 && this.implicitTag != 0) {
            this.implicitTag |= 0x20;
        }
        if (this.implicitTag != 0) {
            if (this.implicitTag != this.tag) {
                this.throwASN1Exception("Invalid Tag Implicit Tag required");
            }
        } else if (this.tag != required) {
            this.throwASN1Exception("Invalid Tag");
        }
        this.implicitTag = 0;
        return true;
    }

    public boolean decodeBoolean() throws ASN1Exception {
        boolean ret = false;
        this.decodeTagAndLength();
        this.checkTag(1);
        while (this.valueLength > 0) {
            int b = this.getOctet();
            if (b == 0) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public int decodeIntegerAsInt() throws ASN1Exception {
        return this.decodeInteger().intValue();
    }

    public long decodeIntegerAsLong() throws ASN1Exception {
        return this.decodeInteger().longValue();
    }

    public BigInteger decodeInteger() throws ASN1Exception {
        BigInteger ret = null;
        this.decodeTagAndLength();
        this.checkTag(2);
        ret = new BigInteger(this.getOctets(this.valueLength));
        return ret;
    }

    public int decodeEnumeration() throws ASN1Exception {
        BigInteger en = null;
        this.decodeTagAndLength();
        this.checkTag(10);
        en = new BigInteger(this.getOctets(this.valueLength));
        return en.intValue();
    }

    public void decodeNull() throws ASN1Exception {
        this.decodeTagAndLength();
        this.checkTag(5);
    }

    public Date decodeGeneralizedTime() throws ASN1Exception {
        Date ret = null;
        this.decodeTagAndLength();
        this.checkTag(24);
        int tl = 0;
        String tF = null;
        try {
            TimeZone tz;
            String dateString = new String(this.getOctets(this.valueLength), "ISO8859_1");
            switch (dateString.length()) {
                case 15: {
                    tl = 14;
                    break;
                }
                case 19: {
                    tl = 18;
                    break;
                }
                case 13: {
                    tl = 12;
                    break;
                }
                case 17: {
                    tl = 16;
                    break;
                }
                case 18: {
                    tl = 17;
                    break;
                }
                default: {
                    this.throwASN1Exception("Invalid GeneralizedTime Encoding");
                }
            }
            String shortString = dateString.substring(0, tl);
            tF = genTimeFormat.substring(0, tl);
            SimpleDateFormat sdf = new SimpleDateFormat(tF);
            int tzIdx = dateString.indexOf(90);
            if (tzIdx != -1) {
                tz = TimeZone.getTimeZone("GMT");
            } else {
                tzIdx = dateString.indexOf(43);
                if (tzIdx == -1 && (tzIdx = dateString.indexOf(45)) == -1) {
                    this.throwASN1Exception("Invalid GeneralizedTime Encoding");
                }
                String tzString = new String("GMT" + dateString.substring(tzIdx, tzIdx + 3));
                tzString = tzString.concat(":" + dateString.substring(tzIdx += 3, tzIdx + 2));
                tz = TimeZone.getTimeZone(tzString);
            }
            sdf.setTimeZone(tz);
            ret = sdf.parse(shortString);
        }
        catch (ParseException e) {
            this.throwASN1Exception(e);
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        return ret;
    }

    public Date decodeUTCTime() throws ASN1Exception {
        Date ret = null;
        this.decodeTagAndLength();
        this.checkTag(23);
        try {
            TimeZone tz;
            SimpleDateFormat sdf;
            String shortString;
            String dateString = new String(this.getOctets(this.valueLength), "ISO8859_1");
            if (dateString.charAt(10) >= '0' && dateString.charAt(10) <= '9') {
                shortString = dateString.substring(0, 12);
                sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            } else {
                shortString = dateString.substring(0, 10);
                sdf = new SimpleDateFormat("yyyyMMddHHmm");
            }
            shortString = shortString.charAt(0) < '5' ? "20" + shortString : "19" + shortString;
            int tzIdx = dateString.indexOf(90);
            if (tzIdx != -1) {
                tz = TimeZone.getTimeZone("GMT");
            } else {
                tzIdx = dateString.indexOf(43);
                if (tzIdx == -1 && (tzIdx = dateString.indexOf(45)) == -1) {
                    this.throwASN1Exception("Invalid UTCTime Encoding");
                }
                String tzString = new String("GMT" + dateString.substring(tzIdx, tzIdx + 3));
                tzString = tzString.concat(":" + dateString.substring(tzIdx += 3, tzIdx + 2));
                tz = TimeZone.getTimeZone(tzString);
            }
            sdf.setTimeZone(tz);
            ret = sdf.parse(shortString);
        }
        catch (ParseException e) {
            this.throwASN1Exception(e);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    public ASN1OID decodeObjectIdentifier() throws ASN1Exception {
        ASN1OID ret = new ASN1OID();
        this.decodeTagAndLength();
        this.checkTag(6);
        byte[] oidBytes = this.getOctets(this.valueLength);
        ret = new ASN1OID();
        ret.decode(oidBytes);
        return ret;
    }

    public String decodePrintableString() throws ASN1Exception {
        return this.decodeString(19);
    }

    public String decodeVisibleString() throws ASN1Exception {
        return this.decodeString(26);
    }

    public String decodeT61String() throws ASN1Exception {
        return this.decodeString(20);
    }

    public String decodeIA5String() throws ASN1Exception {
        return this.decodeString(22);
    }

    public String decodeNumericString() throws ASN1Exception {
        return this.decodeString(18);
    }

    protected String decodeString(int tag) throws ASN1Exception {
        this.decodeTagAndLength();
        this.checkTag(tag);
        try {
            String ret = new String(this.getOctets(this.valueLength), "ISO8859_1");
            return ret;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private char[] byteArrayToCharArray(byte[] src, int idx, int len) {
        char[] ret = new char[len / 2];
        int i = idx;
        int j = 0;
        while (i < idx + len) {
            ret[j] = (char)(src[i] << 8 | (char)src[i + 1] & 0xFF);
            i += 2;
            ++j;
        }
        return ret;
    }

    public String decodeBMPString() throws ASN1Exception {
        this.decodeTagAndLength();
        this.checkTag(30);
        String ret = null;
        try {
            ret = new String(this.byteArrayToCharArray(this.getOctets(this.valueLength), 0, this.valueLength));
        }
        catch (Exception e) {
            this.throwASN1Exception(e, e.getMessage());
        }
        return ret;
    }

    public String decodeUTF8String() throws ASN1Exception {
        this.decodeTagAndLength();
        this.checkTag(12);
        String ret = null;
        try {
            ret = new String(this.getOctets(this.valueLength), "UTF8");
        }
        catch (Exception e) {
            this.throwASN1Exception(e, e.getMessage());
        }
        return ret;
    }

    public String decodeUTF8StringBadEncoding(String charset) throws ASN1Exception {
        this.decodeTagAndLength();
        this.checkTag(12);
        String ret = null;
        try {
            ret = new String(this.getOctets(this.valueLength), charset);
        }
        catch (Exception e) {
            this.throwASN1Exception(e, e.getMessage());
        }
        return ret;
    }

    public int decodeChoice(int[] taglist) throws ASN1Exception {
        int t = this.peekNextTag();
        for (int i = 0; i < taglist.length; ++i) {
            if (t != taglist[i]) continue;
            return t;
        }
        return 0;
    }

    public ASN1Any decodeAny() throws ASN1Exception {
        ASN1Any any = null;
        Object data = null;
        int len = this.getTLVLength();
        if (len == -1) {
            if (this.forbidIndef) {
                this.throwASN1Exception("INDEF encoding occured");
            }
        } else {
            any = new ASN1Any(this.getOctets(len));
        }
        return any;
    }

    public byte[] decodeAnyAsByteArray() throws ASN1Exception {
        byte[] data = null;
        int len = this.getTLVLength();
        if (len == -1) {
            if (this.forbidIndef) {
                this.throwASN1Exception("INDEF encoding occured");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                int depth = 0;
                int l = 0;
                baos.write(this.getOctets(2));
                ++depth;
                while (depth > 0) {
                    int nextTag = this.getOctet();
                    int nextLen = this.getOctet();
                    if (nextTag == 0 && nextLen == 0) {
                        if (--depth <= 0) continue;
                        baos.write(this.getOctets(2));
                        continue;
                    }
                    this.pushBack(nextLen);
                    this.pushBack(nextTag);
                    l = this.getTLVLength();
                    if (l == -1) {
                        baos.write(this.getOctets(2));
                        ++depth;
                        continue;
                    }
                    baos.write(this.getOctets(l));
                }
                baos.close();
            }
            catch (IOException ex) {
                this.throwASN1Exception(ex.toString());
            }
            data = baos.toByteArray();
        } else {
            data = this.getOctets(len);
        }
        return data;
    }

    protected void push() {
        DecStatus stat = new DecStatus(this.tag, this.valueLength, this.readOctets);
        this.currStack.push(stat);
    }

    public byte[] decodeOctetString() throws ASN1Exception {
        this.decodeTagAndLength();
        this.checkTag(4);
        byte[] ret = this.getOctets(this.valueLength);
        return ret;
    }

    public ASN1BitString decodeBitString() throws ASN1Exception {
        this.decodeTagAndLength();
        this.checkTag(3);
        int unused = this.getOctet();
        byte[] val = this.getOctets(this.valueLength - 1);
        ASN1BitString ret = new ASN1BitString(unused, val);
        return ret;
    }

    public int decodeExplicit(int tag) throws ASN1Exception {
        this.decodeTagAndLength();
        this.checkTag(tag | 0x20);
        this.push();
        return this.currStack.size();
    }

    public int decodeSequence() throws ASN1Exception {
        this.decodeTagAndLength();
        this.checkTag(48);
        this.push();
        return this.currStack.size();
    }

    public int decodeSet() throws ASN1Exception {
        this.decodeTagAndLength();
        this.checkTag(49);
        this.push();
        return this.currStack.size();
    }

    public int decodeSequenceOf() throws ASN1Exception {
        return this.decodeSequence();
    }

    public int decodeSetOf() throws ASN1Exception {
        return this.decodeSet();
    }

    private boolean endOf(int x, boolean action) throws ASN1Exception {
        if (this.currStack.size() != x) {
            return false;
        }
        DecStatus stat = (DecStatus)this.currStack.peek();
        if (stat.isIndefinite()) {
            int nextTag = this.getOctet();
            int nextLen = this.getOctet();
            if (nextTag != 0 || nextLen != 0) {
                this.pushBack(nextLen);
                this.pushBack(nextTag);
                return false;
            }
            if (!action) {
                this.pushBack(nextLen);
                this.pushBack(nextTag);
                return true;
            }
        } else if (!stat.isEnd(this.readOctets)) {
            return false;
        }
        if (action) {
            this.currStack.pop();
        }
        return true;
    }

    public boolean endOf(int x) throws ASN1Exception {
        return this.endOf(x, true);
    }

    private void sureSkip(long l) throws IOException {
        long sl = 0L;
        while (l > 0L) {
            sl = this.input.skip(l);
            l -= sl;
            this.readOctets = (int)((long)this.readOctets + sl);
        }
    }

    public void skipNextTag() throws ASN1Exception {
        long l = this.getTLVLength();
        try {
            if (l == -1L) {
                int depth = 0;
                this.sureSkip(2L);
                ++depth;
                while (depth > 0) {
                    int nextTag = this.getOctet();
                    int nextLen = this.getOctet();
                    if (nextTag == 0 && nextLen == 0) {
                        --depth;
                        continue;
                    }
                    this.pushBack(nextLen);
                    this.pushBack(nextTag);
                    l = this.getTLVLength();
                    if (l == -1L) {
                        this.sureSkip(2L);
                        ++depth;
                        continue;
                    }
                    this.sureSkip(l);
                }
            } else {
                this.sureSkip(l);
            }
        }
        catch (IOException ex) {
            throw new ASN1Exception(ex);
        }
    }

    public int peekNextTag() throws ASN1Exception {
        int ret = this.getOctet();
        this.pushBack(ret);
        return ret;
    }

    public int getTLVLength() throws ASN1Exception {
        int ret = this.peekNextValueLength();
        int ll = 0;
        if (ret == -1) {
            return ret;
        }
        ll = ret > 127 ? (ret > 255 ? (ret > 65535 ? (ret > 0xFFFFFF ? 5 : 4) : 3) : 2) : 1;
        return 1 + ll + ret;
    }

    public int peekNextValueLength() throws ASN1Exception {
        int[] buf = new int[6];
        int bp = 0;
        int ret = 0;
        buf[bp++] = this.getOctet();
        buf[bp++] = this.getOctet();
        if (buf[1] == 128) {
            ret = -1;
            if (this.forbidIndef) {
                this.throwASN1Exception("INDEF encoding occured");
            }
        } else if ((buf[1] & 0x80) == 0) {
            ret = buf[1];
        } else {
            ret = 0;
            int ll = buf[1] & 0x7F;
            for (int i = 0; i < ll; ++i) {
                buf[bp] = this.getOctet();
                ret = ret << 8 | buf[bp];
                ++bp;
            }
        }
        for (int i = bp - 1; i >= 0; --i) {
            this.pushBack(buf[i]);
        }
        return ret;
    }

    public void nextIsImplicit(int tag) throws ASN1Exception {
        this.implicitTag = tag;
    }

    public boolean nextIsOptional(int tag) throws ASN1Exception {
        if (!this.currStack.empty() && this.endOf(this.currStack.size(), false)) {
            return true;
        }
        int t = this.getOctet();
        if (tag == 0) {
            this.pushBack(t);
            return false;
        }
        if (tag == 16 || tag == 17) {
            tag |= 0x20;
        }
        if (t == tag) {
            this.pushBack(t);
            return false;
        }
        if (t == (tag |= 0x20)) {
            this.pushBack(t);
            return false;
        }
        this.pushBack(t);
        return true;
    }

    public boolean nextIsDefault(int tag) throws ASN1Exception {
        if (!this.currStack.empty() && this.endOf(this.currStack.size(), false)) {
            return true;
        }
        int t = this.getOctet();
        if (tag == 16 || tag == 17) {
            tag |= 0x20;
        }
        if (t == tag) {
            this.pushBack(t);
            return false;
        }
        if (t == (tag |= 0x20)) {
            this.pushBack(t);
            return false;
        }
        this.pushBack(t);
        return true;
    }

    public boolean nextTagConstructed() throws ASN1Exception {
        int ret = this.peekNextTag();
        return (ret & 0x20) != 0;
    }

    public InputStream setInputStream(InputStream input) {
        InputStream ret = input;
        this.input = new PushbackInputStream(input, 8);
        this.readOctets = 0;
        this.currStack.removeAllElements();
        this.implicitTag = 0;
        return ret;
    }

    protected void throwASN1Exception(Exception ex) throws ASN1Exception {
        throw new ASN1Exception(ex);
    }

    protected void throwASN1Exception(String msg) throws ASN1Exception {
        throw new ASN1Exception(msg);
    }

    protected void throwASN1Exception(Exception ex, String msg) throws ASN1Exception {
        throw new ASN1Exception(ex, msg);
    }

    public void nextHasSizeConstraints(long from, long to) throws ASN1Exception {
    }

    public void nextHasAlphabetConstraint(String a) throws ASN1Exception {
    }
}

