/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.BaseBEREncoder;
import com.initech.asn1.EncBufTree;
import java.io.OutputStream;

public class BEREncoder
extends BaseBEREncoder {
    private static final String RULE_NAME = "BER";
    protected EncBufTree encTree;

    public BEREncoder(OutputStream out) {
        this.encTree = new EncBufTree(out);
    }

    public String toString() {
        return RULE_NAME;
    }

    public OutputStream setOutputStream(OutputStream out) {
        return this.encTree.setOutputStream(out);
    }

    public OutputStream getOutputStream() {
        return this.encTree.getOutputStream();
    }

    protected int encodeGenericConstructed(int tag, boolean indef) throws ASN1Exception {
        int t = this.encodeTag(true, tag, false);
        return this.encTree.addConstructedNode(t, indef);
    }

    public int encodeExplicit(int tag) throws ASN1Exception {
        return this.encodeGenericConstructed(tag, false);
    }

    public int encodeExplicit(int tag, boolean indef) throws ASN1Exception {
        return this.encodeGenericConstructed(tag, indef);
    }

    public int encodeSequence() throws ASN1Exception {
        return this.encodeGenericConstructed(16, false);
    }

    public int encodeSequence(boolean indef) throws ASN1Exception {
        return this.encodeGenericConstructed(16, indef);
    }

    public int encodeSet() throws ASN1Exception {
        return this.encodeGenericConstructed(17, false);
    }

    public int encodeSet(boolean indef) throws ASN1Exception {
        return this.encodeGenericConstructed(17, indef);
    }

    public int encodeSequenceOf() throws ASN1Exception {
        return this.encodeGenericConstructed(16, false);
    }

    public int encodeSequenceOf(boolean indef) throws ASN1Exception {
        return this.encodeGenericConstructed(16, indef);
    }

    public int encodeSetOf() throws ASN1Exception {
        return this.encodeGenericConstructed(17, false);
    }

    public int encodeSetOf(boolean indef) throws ASN1Exception {
        return this.encodeGenericConstructed(17, indef);
    }

    public int encodeConstructedString(int tag) throws ASN1Exception {
        return this.encodeGenericConstructed(tag, true);
    }

    public void endOf(int x) throws ASN1Exception {
        this.encTree.endOf(x);
    }

    public void finish() throws ASN1Exception {
        this.encTree.finish();
    }

    protected void putOctet(int o) throws ASN1Exception {
        this.encTree.putOctet(o);
    }

    protected void putOctets(byte[] data, int offset, int len) throws ASN1Exception {
        this.encTree.putOctets(data, offset, len);
    }
}

