/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1;

import com.initech.asn1.ASN1Any;
import com.initech.asn1.ASN1BitString;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1Tag;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public abstract class BaseBEREncoder
extends ASN1Encoder {
    protected int implicitTag = 0;
    protected boolean specialTag = false;
    protected int[] expectedTaglist;
    private static final String[] timeFormat = new String[]{"yyyyMMddHHmmss.SSS'Z'", "yyyyMMddHHmmss.SS'Z'", "yyyyMMddHHmmss.S'Z'", "yyyyMMddHHmmss'Z'"};

    protected int encodeTag(boolean constructed, int tag) throws ASN1Exception {
        return this.encodeTag(constructed, tag, true);
    }

    protected int encodeTag(boolean constructed, int tag, boolean emit) throws ASN1Exception {
        if (this.specialTag) {
            tag = this.implicitTag;
            this.specialTag = false;
        }
        if (constructed) {
            tag |= 0x20;
        }
        if (this.expectedTaglist != null) {
            boolean matched = false;
            for (int i = 0; i < this.expectedTaglist.length; ++i) {
                if (tag != this.expectedTaglist[i]) continue;
                matched = true;
                break;
            }
            this.expectedTaglist = null;
            if (!matched) {
                this.throwASN1Exception("Unexpected Tag : " + ASN1Tag.tagToString(tag));
            }
        }
        if (emit) {
            this.putOctet(tag);
        }
        return tag;
    }

    protected void encodeLength(int len) throws ASN1Exception {
        if (len == 0) {
            this.putOctet(0);
            return;
        }
        if (len == -1) {
            this.putOctet(128);
            return;
        }
        if (len < 128) {
            this.putOctet(len);
        } else {
            int llen;
            int startPos;
            byte[] llb = new byte[]{(byte)(len >>> 24), (byte)(len >>> 16 & 0xFF), (byte)(len >>> 8 & 0xFF), (byte)(len & 0xFF)};
            if (len > 255) {
                if (len > 65535) {
                    if (len > 0xFFFFFF) {
                        startPos = 0;
                        llen = 4;
                    } else {
                        startPos = 1;
                        llen = 3;
                    }
                } else {
                    startPos = 2;
                    llen = 2;
                }
            } else {
                startPos = 3;
                llen = 1;
            }
            this.putOctet(llen | 0x80);
            this.putOctets(llb, startPos, llen);
        }
    }

    protected void encodeTagAndLength(boolean constructed, int tag, int len) throws ASN1Exception {
        this.encodeTag(constructed, tag);
        this.encodeLength(len);
    }

    public void encodeBoolean(boolean b) throws ASN1Exception {
        this.encodeTagAndLength(false, 1, 1);
        if (b) {
            this.putOctet(255);
        } else {
            this.putOctet(0);
        }
    }

    public void encodeInteger(int i) throws ASN1Exception {
        this.encodeInteger(BigInteger.valueOf(i));
    }

    public void encodeInteger(long i) throws ASN1Exception {
        this.encodeInteger(BigInteger.valueOf(i));
    }

    public void encodeInteger(BigInteger i) throws ASN1Exception {
        byte[] tmp = i.toByteArray();
        int startPos = 0;
        if (tmp.length > 1) {
            while (true) {
                if (tmp[startPos] == 0 && (tmp[startPos + 1] & 0x80) == 0) {
                    ++startPos;
                    continue;
                }
                if (!(tmp[startPos] == 255 & (tmp[startPos + 1] & 0x80) != 0)) break;
                ++startPos;
            }
        }
        this.encodeTagAndLength(false, 2, tmp.length - startPos);
        this.putOctets(tmp, startPos, tmp.length - startPos);
    }

    public void encodeNull() throws ASN1Exception {
        this.encodeTagAndLength(false, 5, 0);
    }

    public void encodeEnumeration(int i) throws ASN1Exception {
        BigInteger t = BigInteger.valueOf(i);
        byte[] tmp = t.toByteArray();
        int startPos = 0;
        if (tmp.length > 1) {
            while (true) {
                if (tmp[startPos] == 0 && (tmp[startPos + 1] & 0x80) == 0) {
                    ++startPos;
                    continue;
                }
                if (!(tmp[startPos] == 255 & (tmp[startPos + 1] & 0x80) != 0)) break;
                ++startPos;
            }
        }
        this.encodeTagAndLength(false, 10, tmp.length - startPos);
        this.putOctets(tmp, startPos, tmp.length - startPos);
    }

    public void encodeUTCTime(Date d) throws ASN1Exception {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss'Z'");
        sdf.setTimeZone(tz);
        String x = sdf.format(d);
        try {
            byte[] t = x.getBytes("ISO8859_1");
            this.encodeTagAndLength(false, 23, t.length);
            this.putOctets(t, 0, t.length);
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
    }

    public void encodeGeneralizedTime(Date d) throws ASN1Exception {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        sdf.setTimeZone(tz);
        String x = sdf.format(d);
        try {
            byte[] t = x.getBytes("ISO8859_1");
            this.encodeTagAndLength(false, 24, t.length);
            this.putOctets(t, 0, t.length);
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
    }

    public void encodeGeneralizedTimeMillis(Date d) throws ASN1Exception {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        long mt = d.getTime();
        String form = mt % 1000L == 0L ? timeFormat[3] : (mt % 100L == 0L ? timeFormat[2] : (mt % 10L == 0L ? timeFormat[1] : timeFormat[0]));
        SimpleDateFormat sdf = new SimpleDateFormat(form);
        sdf.setTimeZone(tz);
        String x = sdf.format(d);
        try {
            byte[] t = x.getBytes("ISO8859_1");
            this.encodeTagAndLength(false, 24, t.length);
            this.putOctets(t, 0, t.length);
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
    }

    public void encodeObjectIdentifier(String oid) throws ASN1Exception {
        this.encodeObjectIdentifier(new ASN1OID(oid));
    }

    public void encodeObjectIdentifier(ASN1OID oid) throws ASN1Exception {
        byte[] t = oid.encode();
        if (t == null) {
            this.throwASN1Exception("Invalid OID");
        }
        this.encodeTagAndLength(false, 6, t.length);
        this.putOctets(t, 0, t.length);
    }

    public void encodeOctetString(byte[] data, int begin, int len) throws ASN1Exception {
        this.encodeTagAndLength(false, 4, len);
        this.putOctets(data, begin, len);
    }

    public void encodeBitString(ASN1BitString b) throws ASN1Exception {
        int unused = b.getUnusedBits();
        byte[] content = b.getAsByteArray();
        this.encodeTagAndLength(false, 3, 1 + content.length);
        this.putOctet(unused);
        this.putOctets(content, 0, content.length);
    }

    public void encodePrintableString(String b) throws ASN1Exception {
        this.encodeGenericString(19, b);
    }

    public void encodeVisibleString(String b) throws ASN1Exception {
        this.encodeGenericString(26, b);
    }

    public void encodeT61String(String b) throws ASN1Exception {
        this.encodeGenericString(20, b);
    }

    public void encodeIA5String(String b) throws ASN1Exception {
        this.encodeGenericString(22, b);
    }

    public void encodeNumericString(String b) throws ASN1Exception {
        this.encodeGenericString(18, b);
    }

    protected void encodeGenericString(int tag, String b) throws ASN1Exception {
        if (b == null) {
            this.encodeTagAndLength(false, tag, 0);
        } else {
            try {
                byte[] content = b.getBytes("ISO8859_1");
                this.encodeTagAndLength(false, tag, content.length);
                this.putOctets(content, 0, content.length);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    protected static byte[] charArrayToByteArray(char[] src) {
        byte[] ret = new byte[src.length * 2];
        int i = 0;
        int j = 0;
        while (i < src.length) {
            ret[j] = (byte)((src[i] & 0xFF00) >>> 8);
            ret[j + 1] = (byte)(src[i] & 0xFF);
            ++i;
            j += 2;
        }
        return ret;
    }

    public void encodeBMPString(String b) throws ASN1Exception {
        byte[] content = BaseBEREncoder.charArrayToByteArray(b.toCharArray());
        this.encodeTagAndLength(false, 30, content.length);
        this.putOctets(content, 0, content.length);
    }

    public void encodeUTF8String(String b) throws ASN1Exception {
        byte[] content = null;
        try {
            content = b.getBytes("UTF8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.throwASN1Exception(ex, "Unsupported Encoding");
        }
        if (content != null) {
            this.encodeTagAndLength(false, 12, content.length);
            this.putOctets(content, 0, content.length);
        }
    }

    public void encodeAny(byte[] any) throws ASN1Exception {
        this.encodeAny(any, 0, any.length);
    }

    public void encodeAny(ASN1Any any) throws ASN1Exception {
        byte[] d = any.getEncoded();
        this.encodeAny(d, 0, d.length);
    }

    public void encodeAny(byte[] any, int begin, int len) throws ASN1Exception {
        if (begin < 0 || len > any.length || len - begin < 0 || len < 0) {
            this.throwASN1Exception(new IndexOutOfBoundsException());
        }
        if (len == 0) {
            return;
        }
        boolean constructed = (any[begin] & 0x20) != 0;
        int tag = any[begin] & 0xFF;
        this.encodeTag(constructed, tag);
        this.putOctets(any, begin + 1, len - 1);
    }

    public void encodeChoice(int tag, int[] taglist) throws ASN1Exception {
        this.expectedTaglist = taglist;
    }

    public void nextIsImplicit(int tag) throws ASN1Exception {
        this.specialTag = true;
        this.implicitTag = tag;
    }

    public boolean encodeDefault() throws ASN1Exception {
        return false;
    }

    protected void throwASN1Exception(Exception ex) throws ASN1Exception {
        throw new ASN1Exception(ex);
    }

    protected void throwASN1Exception(String msg) throws ASN1Exception {
        throw new ASN1Exception(msg);
    }

    protected void throwASN1Exception(Exception ex, String msg) throws ASN1Exception {
        throw new ASN1Exception(ex, msg);
    }

    protected abstract void putOctet(int var1) throws ASN1Exception;

    protected abstract void putOctets(byte[] var1, int var2, int var3) throws ASN1Exception;

    public void nextHasSizeConstraints(long from, long to) throws ASN1Exception {
    }

    public void nextHasAlphabetConstraint(String a) throws ASN1Exception {
    }
}

