/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.BaseBEREncoder;
import com.initech.asn1.EncBufTree;
import java.io.IOException;
import java.io.OutputStream;

public class DEREncoder
extends BaseBEREncoder {
    private static final String RULE_NAME = "DER";
    protected EncBufTree encTree = new EncBufTree();

    public String toString() {
        return RULE_NAME;
    }

    protected int encodeGenericConstructed(int tag) throws ASN1Exception {
        int t = this.encodeTag(true, tag, false);
        return this.encTree.addConstructedNode(t, false);
    }

    public int encodeExplicit(int tag) throws ASN1Exception {
        return this.encodeGenericConstructed(tag);
    }

    public int encodeExplicit(int tag, boolean indef) throws ASN1Exception {
        return this.encodeGenericConstructed(tag);
    }

    public int encodeSequence() throws ASN1Exception {
        return this.encodeGenericConstructed(16);
    }

    public int encodeSequence(boolean indef) throws ASN1Exception {
        return this.encodeGenericConstructed(16);
    }

    public int encodeSet() throws ASN1Exception {
        return this.encodeGenericConstructed(17);
    }

    public int encodeSet(boolean indef) throws ASN1Exception {
        return this.encodeGenericConstructed(17);
    }

    public int encodeSequenceOf() throws ASN1Exception {
        return this.encodeGenericConstructed(16);
    }

    public int encodeSequenceOf(boolean indef) throws ASN1Exception {
        return this.encodeGenericConstructed(16);
    }

    public int encodeSetOf() throws ASN1Exception {
        return this.encodeGenericConstructed(17);
    }

    public int encodeSetOf(boolean indef) throws ASN1Exception {
        return this.encodeGenericConstructed(17);
    }

    public int encodeConstructedString(int tag) throws ASN1Exception {
        this.throwASN1Exception("You can't use constructed string in DER encoding");
        return 0;
    }

    public void endOf(int x) throws ASN1Exception {
        this.encTree.endOf(x);
    }

    public void finish() throws ASN1Exception {
        this.encTree.finish();
    }

    public void reset() {
        this.encTree.reset();
    }

    public byte[] toByteArray() throws ASN1Exception {
        byte[] data = this.encTree.toByteArray();
        int size = this.encTree.available();
        byte[] ret = new byte[size];
        System.arraycopy(data, 0, ret, 0, size);
        return ret;
    }

    public int writeTo(OutputStream output) throws ASN1Exception, IOException {
        byte[] data = this.encTree.toByteArray();
        int size = this.encTree.available();
        output.write(data, 0, size);
        return size;
    }

    protected void putOctet(int o) throws ASN1Exception {
        this.encTree.putOctet(o);
    }

    protected void putOctets(byte[] data, int offset, int len) throws ASN1Exception {
        this.encTree.putOctets(data, offset, len);
    }
}

