/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.BEREncoder;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Stack;

public class DigestedBEREncoder
extends BEREncoder {
    private Stack filterStack = new Stack();

    public DigestedBEREncoder(OutputStream out) {
        super(out);
    }

    protected void putOctet(int o) throws ASN1Exception {
        super.putOctet(o);
        try {
            for (int i = 0; i < this.filterStack.size(); ++i) {
                MessageDigest[] mds = (MessageDigest[])this.filterStack.elementAt(i);
                for (int j = 0; j < mds.length; ++j) {
                    mds[i].update((byte)(o & 0xFF));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ASN1Exception(e.toString());
        }
    }

    protected void putOctets(byte[] data, int offset, int len) throws ASN1Exception {
        super.putOctets(data, offset, len);
        try {
            for (int i = 0; i < this.filterStack.size(); ++i) {
                MessageDigest[] mds = (MessageDigest[])this.filterStack.elementAt(i);
                for (int j = 0; j < mds.length; ++j) {
                    mds[i].update(data, offset, len);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ASN1Exception(e.toString());
        }
    }

    public void pushMessageDigest(MessageDigest[] mds) {
        this.filterStack.push(mds);
    }

    public MessageDigest[] popMessageDigest() {
        return (MessageDigest[])this.filterStack.pop();
    }
}

