/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.DEREncoder;
import java.io.FileOutputStream;
import java.security.MessageDigest;
import java.util.Stack;

public class DigestedDEREncoder
extends DEREncoder {
    private Stack filterStack = new Stack();
    private boolean flag = false;
    private FileOutputStream fos;

    protected void putOctet(int o) throws ASN1Exception {
        if (this.flag) {
            try {
                this.fos.write(o);
                for (int i = 0; i < this.filterStack.size(); ++i) {
                    MessageDigest[] mds = (MessageDigest[])this.filterStack.elementAt(i);
                    for (int j = 0; j < mds.length; ++j) {
                        mds[i].update((byte)(o & 0xFF));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ASN1Exception(e.toString());
            }
        }
        super.putOctet(o);
    }

    protected void putOctets(byte[] data, int offset, int len) throws ASN1Exception {
        if (this.flag) {
            try {
                this.fos.write(data, offset, len);
                for (int i = 0; i < this.filterStack.size(); ++i) {
                    MessageDigest[] mds = (MessageDigest[])this.filterStack.elementAt(i);
                    for (int j = 0; j < mds.length; ++j) {
                        mds[i].update(data, offset, len);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ASN1Exception(e.toString());
            }
        }
        super.putOctets(data, offset, len);
    }

    public void pushMessageDigest(MessageDigest[] mds) {
        this.filterStack.push(mds);
    }

    public MessageDigest[] popMessageDigest() {
        return (MessageDigest[])this.filterStack.pop();
    }

    public boolean digestStart() {
        try {
            this.fos = new FileOutputStream("/tmp/output");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.flag = true;
        return true;
    }

    public void digestStop() {
        try {
            this.fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.flag = false;
    }
}

