/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.security.MessageDigest;
import java.util.Stack;

public class DigestedInputStream
extends PushbackInputStream {
    protected byte[] buf;
    protected int pos;
    private Stack filterStack;
    private int cnt;
    private byte[] buffer;
    private int bufpos;
    private FileOutputStream fos;
    private boolean flag;

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public DigestedInputStream(InputStream in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.buf = new byte[size];
        this.pos = size;
        this.filterStack = new Stack();
        this.flag = false;
    }

    public DigestedInputStream(InputStream in) {
        this(in, 1);
    }

    public int read() throws IOException {
        this.ensureOpen();
        if (this.pos < this.buf.length) {
            return this.buf[this.pos++] & 0xFF;
        }
        int m = super.read();
        if (this.flag) {
            try {
                this.fos.write(m);
                for (int i = 0; i < this.filterStack.size(); ++i) {
                    MessageDigest[] mds = (MessageDigest[])this.filterStack.elementAt(i);
                    for (int j = 0; j < mds.length; ++j) {
                        mds[i].update((byte)(m & 0xFF));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e.toString());
            }
        }
        return m;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int avail = this.buf.length - this.pos;
        if (avail > 0) {
            if (len < avail) {
                avail = len;
            }
            System.arraycopy(this.buf, this.pos, b, off, avail);
            this.pos += avail;
            off += avail;
            len -= avail;
        }
        if (len > 0) {
            len = super.read(b, off, len);
            if (this.flag) {
                try {
                    this.fos.write(b, off, len);
                    for (int i = 0; i < this.filterStack.size(); ++i) {
                        MessageDigest[] mds = (MessageDigest[])this.filterStack.elementAt(i);
                        for (int j = 0; j < mds.length; ++j) {
                            mds[i].update(b, off, len);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException(e.toString());
                }
            }
            if (len == -1) {
                return avail == 0 ? -1 : avail;
            }
            return avail + len;
        }
        return avail;
    }

    public void unread(int b) throws IOException {
        this.ensureOpen();
        if (this.pos == 0) {
            throw new IOException("Push back buffer is full");
        }
        this.buf[--this.pos] = (byte)b;
    }

    public void unread(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (len > this.pos) {
            throw new IOException("Push back buffer is full");
        }
        this.pos -= len;
        System.arraycopy(b, off, this.buf, this.pos, len);
    }

    public void unread(byte[] b) throws IOException {
        this.unread(b, 0, b.length);
    }

    public int available() throws IOException {
        this.ensureOpen();
        return this.buf.length - this.pos + super.available();
    }

    public long skip(long n) throws IOException {
        this.ensureOpen();
        if (n <= 0L) {
            return 0L;
        }
        long pskip = this.buf.length - this.pos;
        if (pskip > 0L) {
            if (n < pskip) {
                pskip = n;
            }
            this.pos = (int)((long)this.pos + pskip);
            n -= pskip;
        }
        if (n > 0L) {
            pskip += super.skip(n);
        }
        return pskip;
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        this.buf = null;
    }

    public void pushMessageDigest(MessageDigest[] mds) {
        this.filterStack.push(mds);
    }

    public boolean digestStart() {
        block6: {
            try {
                this.fos = new FileOutputStream("/tmp/test.der");
                int avail = this.buf.length - this.pos;
                if (avail <= 0) break block6;
                try {
                    this.fos.write(this.buf, this.pos, avail);
                    for (int i = 0; i < this.filterStack.size(); ++i) {
                        MessageDigest[] mds2 = (MessageDigest[])this.filterStack.elementAt(i);
                        for (int j = 0; j < mds2.length; ++j) {
                            mds2[i].update(this.buf, this.pos, avail);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException(e.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.flag = true;
        return true;
    }

    public MessageDigest[] popMessageDigest() {
        return (MessageDigest[])this.filterStack.pop();
    }

    public void digestStop() {
        --this.cnt;
        try {
            this.fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.flag = false;
    }
}

