/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.util.ASN1ByteArrayOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;

public class EncBufTree {
    protected Stack encStack;
    protected OutputStream output;
    protected ParseTreeNode root;
    protected RootPrimitivesNode primRoot;
    protected boolean shouldbeFreed;

    public EncBufTree() {
        this(new ASN1ByteArrayOutputStream(), true);
    }

    public EncBufTree(OutputStream out) {
        this(out, false);
    }

    public EncBufTree(OutputStream out, boolean freed) {
        this.output = out;
        this.encStack = new Stack();
        this.primRoot = new RootPrimitivesNode();
        this.root = null;
        this.shouldbeFreed = freed;
    }

    protected OutputStream setOutputStream(OutputStream out) {
        OutputStream ret = this.output;
        this.output = out;
        return ret;
    }

    protected OutputStream getOutputStream() {
        return this.output;
    }

    protected void putOctet(int o) throws ASN1Exception {
        ParseTreeNode pn = null;
        pn = this.encStack.empty() ? this.primRoot : (ParseTreeNode)this.encStack.peek();
        if (pn.isIndefinite()) {
            try {
                this.output.write(o);
            }
            catch (IOException ex) {
                throw new ASN1Exception(ex);
            }
        } else {
            pn.putOctet(o);
        }
    }

    protected void putOctets(byte[] data, int offset, int len) throws ASN1Exception {
        ParseTreeNode pn = null;
        pn = this.encStack.empty() ? this.primRoot : (ParseTreeNode)this.encStack.peek();
        if (pn.isIndefinite()) {
            try {
                this.output.write(data, offset, len);
            }
            catch (IOException ex) {
                throw new ASN1Exception(ex);
            }
        } else {
            pn.putOctets(data, offset, len);
        }
    }

    public int addConstructedNode(int tag, boolean indef) throws ASN1Exception {
        ConstructedNode node = new ConstructedNode(tag, indef);
        if (this.encStack.empty()) {
            this.root = node;
        } else {
            ConstructedNode parent = (ConstructedNode)this.encStack.peek();
            parent.add(node);
        }
        this.encStack.push(node);
        if (indef) {
            tag |= 0x20;
            try {
                this.output.write(tag);
                this.output.write(128);
            }
            catch (IOException ex) {
                throw new ASN1Exception(ex);
            }
        }
        return this.encStack.size();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endOf(int x) throws ASN1Exception {
        block9: {
            if (this.encStack.size() != x) {
                return;
            }
            ConstructedNode cn = (ConstructedNode)this.encStack.pop();
            cn.finish();
            ConstructedNode parent = null;
            if (cn != this.root) {
                parent = (ConstructedNode)this.encStack.peek();
            }
            try {
                if (parent != null && parent.indefinite || parent == null) {
                    if (cn.indefinite) {
                        this.output.write(0);
                        this.output.write(0);
                        break block9;
                    } else {
                        cn.writeTo(this.output);
                    }
                    break block9;
                }
                if (parent != null && parent.indefinite) {
                    // empty if block
                }
            }
            catch (IOException ex) {
                throw new ASN1Exception(ex);
            }
        }
        if (this.encStack.empty()) {
            this.root = null;
        }
    }

    public void finish() throws ASN1Exception {
        this.encStack.removeAllElements();
        this.root = null;
        if (this.shouldbeFreed) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void reset() {
        this.encStack.removeAllElements();
        this.root = null;
        if (this.output instanceof ByteArrayOutputStream) {
            ((ByteArrayOutputStream)this.output).reset();
        }
    }

    protected byte[] toByteArray() throws ASN1Exception {
        return ((ASN1ByteArrayOutputStream)this.output).getBuffer();
    }

    protected int available() throws ASN1Exception {
        return ((ASN1ByteArrayOutputStream)this.output).getValidBytes();
    }

    class RootPrimitivesNode
    implements ParseTreeNode {
        RootPrimitivesNode() {
        }

        public boolean isIndefinite() {
            return true;
        }

        public int getContentLength() {
            return 0;
        }

        public void putOctet(int o) throws ASN1Exception {
        }

        public void putOctets(byte[] d, int off, int len) throws ASN1Exception {
        }

        public int writeTo(OutputStream out) throws ASN1Exception, IOException {
            return 0;
        }
    }

    class PrimitivesNode
    implements ParseTreeNode {
        byte[] chunk;
        int chunkPos;

        protected PrimitivesNode() {
            this(1024);
        }

        protected PrimitivesNode(int chunksize) {
            this.chunk = new byte[chunksize];
            this.chunkPos = 0;
        }

        public void init() {
            this.chunkPos = 0;
        }

        public boolean isIndefinite() {
            return false;
        }

        public int getContentLength() {
            return this.chunkPos;
        }

        public int writeTo(OutputStream out) throws ASN1Exception, IOException {
            out.write(this.chunk, 0, this.chunkPos);
            return this.chunkPos;
        }

        public void putOctet(int o) throws ASN1Exception {
            int newcount = this.chunkPos + 1;
            if (this.chunk.length < newcount) {
                byte[] newbuf = new byte[Math.max(this.chunk.length << 1, newcount)];
                System.arraycopy(this.chunk, 0, newbuf, 0, this.chunkPos);
                this.chunk = newbuf;
            }
            this.chunk[this.chunkPos] = (byte)o;
            this.chunkPos = newcount;
        }

        public void putOctets(byte[] d, int off, int len) throws ASN1Exception {
            if (off < 0 || off > d.length || len < 0 || off + len > d.length || off + len < 0) {
                throw new ASN1Exception(new IndexOutOfBoundsException());
            }
            if (len == 0) {
                return;
            }
            int newcount = this.chunkPos + len;
            if (this.chunk.length < newcount) {
                byte[] newbuf = new byte[Math.max(this.chunk.length << 1, newcount)];
                System.arraycopy(this.chunk, 0, newbuf, 0, this.chunkPos);
                this.chunk = newbuf;
            }
            System.arraycopy(d, off, this.chunk, this.chunkPos, len);
            this.chunkPos = newcount;
        }
    }

    class ConstructedNode
    implements ParseTreeNode {
        int tag;
        int totLen;
        Vector children = new Vector();
        boolean indefinite;
        boolean finished;

        protected ConstructedNode(int tag, boolean indef) {
            this.indefinite = indef;
            this.tag = tag | 0x20;
            this.totLen = 0;
            this.finished = false;
        }

        public void finish() {
            this.totLen = 0;
            if (!this.indefinite) {
                Enumeration e = this.children.elements();
                while (e.hasMoreElements()) {
                    Object v = e.nextElement();
                    if (v instanceof PrimitivesNode) {
                        this.totLen += ((PrimitivesNode)v).getContentLength();
                        continue;
                    }
                    this.totLen += ((ConstructedNode)v).getContentLength();
                }
            }
            this.finished = true;
        }

        public void add(ParseTreeNode node) {
            this.children.addElement(node);
        }

        private ParseTreeNode addPrimitivesNode() {
            PrimitivesNode node = new PrimitivesNode();
            this.children.addElement(node);
            return node;
        }

        public boolean isIndefinite() {
            return this.indefinite;
        }

        public void putOctet(int o) throws ASN1Exception {
            ParseTreeNode node = null;
            try {
                node = (ParseTreeNode)this.children.lastElement();
                if (node instanceof ConstructedNode) {
                    node = this.addPrimitivesNode();
                }
            }
            catch (NoSuchElementException ex) {
                node = this.addPrimitivesNode();
            }
            node.putOctet(o);
        }

        public void putOctets(byte[] d, int off, int len) throws ASN1Exception {
            ParseTreeNode node = null;
            try {
                node = (ParseTreeNode)this.children.lastElement();
                if (node instanceof ConstructedNode) {
                    node = this.addPrimitivesNode();
                }
            }
            catch (NoSuchElementException ex) {
                node = this.addPrimitivesNode();
            }
            node.putOctets(d, off, len);
        }

        public int getContentLength() {
            int length = 0;
            int eoc = 0;
            if (this.indefinite) {
                length = 1;
                eoc = 2;
            } else {
                length = this.totLen > 127 ? (this.totLen > 255 ? (this.totLen > 65535 ? (this.totLen > 0xFFFFFF ? 5 : 4) : 3) : 2) : 1;
            }
            return 1 + length + this.totLen + eoc;
        }

        private void writeTagLength(OutputStream out) throws ASN1Exception, IOException {
            out.write(this.tag);
            if (this.indefinite) {
                out.write(128);
                return;
            }
            if (this.totLen == 0) {
                out.write(0);
            } else if (this.totLen < 128) {
                out.write(this.totLen);
            } else {
                String ls = Integer.toString(this.totLen);
                BigInteger bi = new BigInteger(ls);
                byte[] llb = bi.toByteArray();
                int startPos = 0;
                int llen = llb.length;
                if (llb[0] == 0) {
                    startPos = 1;
                    llen = llb.length - 1;
                }
                out.write(llen | 0x80);
                out.write(llb, startPos, llen);
            }
        }

        public int writeTo(OutputStream out) throws ASN1Exception, IOException {
            if (!this.finished) {
                this.finish();
            }
            this.writeTagLength(out);
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                ParseTreeNode v = (ParseTreeNode)e.nextElement();
                v.writeTo(out);
            }
            return this.getContentLength();
        }
    }

    static interface ParseTreeNode {
        public int getContentLength();

        public boolean isIndefinite();

        public void putOctet(int var1) throws ASN1Exception;

        public void putOctets(byte[] var1, int var2, int var3) throws ASN1Exception;

        public int writeTo(OutputStream var1) throws ASN1Exception, IOException;
    }
}

