/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1;

import com.initech.asn1.OIDCategory;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class OIDDictionary
implements OIDCategory {
    private static Hashtable name2id = new Hashtable();
    private static Hashtable id2name = new Hashtable();
    private static Hashtable id2category = new Hashtable();

    public static void loadDictionary(String prop) throws Exception {
        OIDDictionary.loadDictionary(OIDDictionary.class, prop);
    }

    public static synchronized void loadDictionary(Class provider, String prop) throws Exception {
        InputStream is = provider.getResourceAsStream(prop);
        if (is == null) {
            is = provider.getClassLoader().getResourceAsStream(prop);
        }
        Properties dict = new Properties();
        if (is != null) {
            try {
                dict.load(is);
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Enumeration<?> e = dict.propertyNames();
        while (e.hasMoreElements()) {
            String name;
            String oid = (String)e.nextElement();
            String names = dict.getProperty(oid);
            if ("2.5.8.1.1".equals(oid)) continue;
            StringTokenizer st = new StringTokenizer(names, ":");
            if (st.hasMoreTokens()) {
                name = st.nextToken();
                id2name.put(oid, name);
                name2id.put(name, oid);
            }
            while (st.hasMoreTokens()) {
                name = st.nextToken();
                if (name.charAt(0) == '<') {
                    char t = name.charAt(1);
                    int rt = t == 'A' ? 0 : (t == 'E' ? 2 : (t == 'C' ? 1 : (t == 'S' ? 6 : (t == 'H' ? 3 : (t == 'M' ? 5 : (t == 'K' ? 4 : -1))))));
                    id2category.put(oid, new Integer(rt));
                    continue;
                }
                name2id.put(name, oid);
            }
        }
    }

    public static String getOIDbyName(String name) {
        return (String)name2id.get(name);
    }

    public static String getNamebyOID(String oid) {
        return (String)id2name.get(oid);
    }

    public static int getCategorybyOID(String oid) {
        Integer i = (Integer)id2category.get(oid);
        if (i == null) {
            return -1;
        }
        return i;
    }

    static {
        try {
            OIDDictionary.loadDictionary("OIDDictionary.properties");
        }
        catch (Exception ex) {
            System.err.println("Failed to load default OID Dictionary");
        }
    }
}

