/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.BERDecoder;
import java.io.IOException;
import java.io.InputStream;

public class OctetStringInputStream
extends InputStream {
    private ASN1Decoder dec;
    private boolean isBER;
    private int tag;
    private byte[] buffer;
    private int bufferPointer;
    private int id;
    private boolean readEnd;

    public OctetStringInputStream(ASN1Decoder dec, int tag) {
        this.dec = dec;
        this.isBER = dec instanceof BERDecoder;
        this.tag = tag;
        this.bufferPointer = 0;
        this.buffer = null;
    }

    public void prepareDecode() throws ASN1Exception {
        if ((this.dec.peekNextTag() & 0x20) != 0) {
            this.dec.nextIsImplicit(this.tag);
            this.id = this.dec.decodeSequence();
        } else {
            if (this.tag != 4) {
                this.dec.nextIsImplicit(this.tag);
            }
            this.id = -1;
        }
        this.readEnd = false;
    }

    public int read() throws IOException {
        if (!(this.buffer != null && this.buffer.length > this.bufferPointer || this.update())) {
            return -1;
        }
        int a = this.buffer[this.bufferPointer++] & 0xFF;
        return a;
    }

    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    public int read(byte[] bytes, int offset, int len) throws IOException {
        for (int i = offset; i < offset + len; ++i) {
            int m = this.read();
            bytes[i] = (byte)(m & 0xFF);
            if (m >= 0) continue;
            if (i == offset) {
                return -1;
            }
            return i - offset;
        }
        return len;
    }

    private boolean update() throws IOException {
        try {
            if (this.readEnd) {
                return false;
            }
            if (this.id < 0) {
                this.buffer = this.dec.decodeOctetString();
                if (this.buffer == null || this.buffer.length == 0) {
                    this.readEnd = true;
                    return false;
                }
                this.readEnd = true;
                return true;
            }
            if (!this.dec.endOf(this.id)) {
                this.buffer = this.dec.decodeOctetString();
                return this.buffer != null && this.buffer.length != 0;
            }
            this.readEnd = true;
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.toString());
        }
    }

    public void finalizeDecode() throws ASN1Exception {
        if (this.id >= 0 && !this.readEnd) {
            while (!this.dec.endOf(this.id)) {
                this.buffer = this.dec.decodeOctetString();
            }
        }
    }

    public long skip(long n) throws IOException {
        for (long i = 0L; i < n; ++i) {
            if (this.read() >= 0) continue;
            return i;
        }
        return n;
    }

    public int available() throws IOException {
        if (this.buffer == null && !this.update()) {
            return 0;
        }
        return this.buffer.length - this.bufferPointer;
    }
}

