/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1;

import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.BEREncoder;
import java.io.IOException;
import java.io.OutputStream;

public class OctetStringOutputStream
extends OutputStream {
    private ASN1Encoder enc;
    private boolean isBER;
    private int tag;
    private byte[] buffer;
    private int bufferPointer;
    private int id;

    public OctetStringOutputStream(ASN1Encoder enc, int tag) {
        this.enc = enc;
        this.isBER = enc instanceof BEREncoder;
        this.tag = tag;
        this.buffer = new byte[1024];
        this.bufferPointer = 0;
    }

    public OctetStringOutputStream(ASN1Encoder enc, boolean isBER, int tag) {
        this.enc = enc;
        this.isBER = enc instanceof BEREncoder;
        this.isBER = this.isBER && isBER;
        this.tag = tag;
        this.buffer = new byte[1024];
        this.bufferPointer = 0;
    }

    public void prepareEncode() throws ASN1Exception {
        if (this.isBER) {
            this.enc.nextIsImplicit(this.tag);
            this.id = this.enc.encodeSequence(true);
        }
    }

    public void write(int i) throws IOException {
        if (this.buffer.length <= this.bufferPointer) {
            this.update();
        }
        this.buffer[this.bufferPointer++] = (byte)(i & 0xFF);
    }

    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    public void write(byte[] bytes, int offset, int len) throws IOException {
        for (int i = offset; i < offset + len; ++i) {
            this.write(bytes[i] & 0xFF);
        }
    }

    private void update() throws IOException {
        try {
            if (this.isBER) {
                this.enc.encodeOctetString(this.buffer, 0, this.bufferPointer);
                this.bufferPointer = 0;
            } else {
                byte[] newBuffer = new byte[this.buffer.length + 1024];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                this.buffer = newBuffer;
            }
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public void finalizeEncode() throws ASN1Exception {
        if (this.isBER) {
            try {
                this.update();
            }
            catch (Exception e) {
                throw new ASN1Exception(e.toString());
            }
            this.enc.endOf(this.id);
        } else {
            if (this.tag != 4) {
                this.enc.nextIsImplicit(this.tag);
            }
            this.enc.encodeOctetString(this.buffer, 0, this.bufferPointer);
        }
    }
}

