/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Any;
import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1StringFactory;
import com.initech.asn1.BERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.IllegalCharactersException;
import com.initech.asn1.OIDDictionary;
import com.initech.asn1.useful.ASN1Object;
import com.initech.asn1.useful.Name;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import java.util.Properties;

public class AVA
extends ASN1Object
implements Cloneable {
    private static final long serialVersionUID = -6095951514087201220L;
    protected ASN1OID type;
    protected int[] tag;
    protected String value;
    protected byte[] binary;
    private static final String SPECIALS = ",+=\n<>#;";
    private static final String HEXASTRING = "0123456789ABCDEF";
    static Properties typeTable = new Properties();

    public AVA() {
        this.type = new ASN1OID();
        this.value = null;
        this.tag = new int[1];
        this.tag[0] = -1;
        this.modified = true;
    }

    public AVA(String v) throws IllegalArgumentException {
        this();
        this.set(v);
    }

    public AVA(String id, String val) {
        this.type = new ASN1OID(id);
        this.value = new String(val);
        this.tag = new int[1];
        this.tag[0] = -1;
        this.modified = true;
    }

    public Object clone() {
        AVA ret = new AVA();
        ret.type = (ASN1OID)this.type.clone();
        ret.value = this.value != null ? new String(this.value) : null;
        ret.tag = (int[])this.tag.clone();
        ret.binary = this.binary != null ? (byte[])this.binary.clone() : null;
        ret.encoded = this.encoded != null ? (byte[])this.encoded.clone() : null;
        return ret;
    }

    public void setEncodingRule(String rule) {
        String strType;
        if (rule.equals("WHOLE_TO_UTF8")) {
            this.tag[0] = 12;
        } else if (rule.equals("DIRECTORY_STRING_TO_UTF8") && (strType = typeTable.getProperty(this.type.get())) != null) {
            if (strType.equals("DIRECTORYSTRING")) {
                this.tag[0] = 12;
            } else if (strType.equals("PKCS9DIRECTORYSTRING")) {
                this.tag[0] = 12;
            }
        }
    }

    private void checkCorrectTag() throws IllegalCharactersException {
        if (this.tag[0] <= 0) {
            String strType = typeTable.getProperty(this.type.get());
            this.tag[0] = strType == null ? ASN1StringFactory.identifyStringTag(this.value) : ASN1StringFactory.identifyStringTag(strType, this.value);
        }
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id = dec.decodeSequence();
        this.type = dec.decodeObjectIdentifier();
        if (ASN1StringFactory.isString(dec.peekNextTag())) {
            this.value = ASN1Any.decodeAsString(dec, this.tag);
            this.binary = null;
        } else {
            this.binary = dec.decodeAnyAsByteArray();
            this.value = null;
        }
        dec.endOf(id);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequence();
        enc.encodeObjectIdentifier(this.type);
        if (this.binary != null) {
            enc.encodeAny(this.binary);
        } else {
            this.checkCorrectTag();
            ASN1Any.encodeAsString(enc, this.value, this.tag[0]);
        }
        enc.endOf(id);
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public String getType() {
        return this.type.get();
    }

    public boolean isBinary() {
        return this.binary != null;
    }

    public String getValue() {
        return new String(this.value);
    }

    public byte[] getBinaryValue() {
        return (byte[])this.binary.clone();
    }

    public boolean equals(AVA obj) {
        if (obj == null) {
            return false;
        }
        return this.toRFC2253CanonicalString().equals(obj.toRFC2253CanonicalString());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AVA)) {
            return false;
        }
        return this.equals((AVA)obj);
    }

    public void set(String name) throws IllegalArgumentException {
        try {
            char c;
            StringReader sr = new StringReader(name);
            StringBuffer buf = new StringBuffer(name.length());
            while (true) {
                int l;
                if ((l = sr.read()) == -1) {
                    throw new IllegalArgumentException("Incorrect Value");
                }
                if ((char)l == '=') break;
                buf.append((char)l);
            }
            String oid = buf.toString().toUpperCase().trim();
            if (oid.equals("CN")) {
                this.type = Name.CN;
            } else if (oid.equals("OU")) {
                this.type = Name.OU;
            } else if (oid.equals("O")) {
                this.type = Name.O;
            } else if (oid.equals("C")) {
                this.type = Name.C;
            } else if (oid.equals("DC")) {
                this.type = Name.DC;
            } else if (oid.equals("SERIAL") || oid.equals("SERIALNUMBER")) {
                this.type = Name.SERIAL;
            } else if (oid.equals("UID")) {
                this.type = Name.UID;
            } else if (oid.equals("L")) {
                this.type = Name.L;
            } else if (oid.equals("S") || oid.equals("ST")) {
                this.type = Name.ST;
            } else if (oid.equals("STREET")) {
                this.type = Name.STREET;
            } else if (oid.equals("T")) {
                this.type = Name.T;
            } else if (oid.equals("GIVENNAME")) {
                this.type = Name.GIVENNAME;
            } else if (oid.equals("INITIALS")) {
                this.type = Name.INITIALS;
            } else if (oid.equals("GENERATION")) {
                this.type = Name.GENERATION;
            } else if (oid.equals("DNQ") || oid.equals("DNQUALIFIER")) {
                this.type = Name.DNQ;
            } else if (oid.equals("SURNAME") || oid.equals("SN")) {
                this.type = Name.SURNAME;
            } else if (oid.equals("MAIL")) {
                this.type = Name.MAIL;
            } else if (oid.equals("EMAILADDRESS") || oid.equals("EMAIL")) {
                this.type = Name.EMAIL;
            } else {
                String t = oid.startsWith("OID.") ? oid.substring(4) : oid;
                if (!ASN1OID.isOID(t)) {
                    String t2 = OIDDictionary.getOIDbyName(t);
                    if (t2 == null) {
                        throw new IllegalArgumentException("Invalid OID : " + t);
                    }
                    t = t2;
                }
                this.type = new ASN1OID(t);
            }
            buf = new StringBuffer();
            int j = 0;
            while ((c = (char)sr.read()) == ' ' || c == '\n') {
            }
            if (c == '\uffff') {
                throw new IllegalArgumentException("Incorrect AVA");
            }
            if (c == '#') {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int b = 0;
                while (true) {
                    int i = sr.read();
                    c = (char)i;
                    if (i == -1 || c == '+' || c == ',' || c == ';' || c == '>') break;
                    int k = HEXASTRING.indexOf(Character.toUpperCase(c));
                    if (k == -1) {
                        throw new IllegalArgumentException("Invalid Hexa Digit : " + c);
                    }
                    if (j % 2 == 1) {
                        b = (byte)(b * 16 + (byte)k);
                        baos.write(b);
                    } else {
                        b = (byte)k;
                    }
                    ++j;
                }
                if (j == 0) {
                    throw new IllegalArgumentException("Zero hex digits");
                }
                if (j % 2 == 1) {
                    throw new IllegalArgumentException("Odd number of hex digits");
                }
                this.binary = baos.toByteArray();
                try {
                    BERDecoder dec = new BERDecoder(this.binary);
                    this.value = ASN1Any.decodeAsString(dec, this.tag);
                    this.binary = null;
                }
                catch (ASN1Exception ex) {
                    this.value = null;
                }
            } else if (c == '\"') {
                j = sr.read();
                c = (char)j;
                if (j == -1) {
                    throw new IllegalArgumentException("String did not end in Quote");
                }
                while (c != '\"') {
                    if (c == '\\') {
                        j = sr.read();
                        c = (char)j;
                        if (j == -1) {
                            throw new IllegalArgumentException("Quoted string did not end in quote");
                        }
                        if (c != '\\' && c != '\"' && SPECIALS.indexOf(c) < 0) {
                            if (HEXASTRING.indexOf(c = Character.toUpperCase(c)) < 0) {
                                throw new IllegalArgumentException("Invalid escaped character");
                            }
                            j = sr.read();
                            if (j == -1) {
                                throw new IllegalArgumentException("Quoted string did not end in quote");
                            }
                            char c2 = Character.toUpperCase((char)j);
                            if (HEXASTRING.indexOf(c2) < 0) {
                                throw new IllegalArgumentException("Invalid escaped character");
                            }
                            c = (char)(HEXASTRING.indexOf(c) * 16 + HEXASTRING.indexOf(c2));
                        }
                    }
                    buf.append(c);
                    j = sr.read();
                    c = (char)j;
                    if (j != -1) continue;
                    throw new IllegalArgumentException("String did not end in Quote");
                }
                do {
                    j = sr.read();
                    c = (char)j;
                } while (j != -1 && (c == '\n' || c == ' '));
                if (j != -1) {
                    throw new IllegalArgumentException("AVA had characters other than white space after terminating quote");
                }
                this.binary = null;
                this.value = buf.toString().trim();
            } else {
                do {
                    if (c == '\\') {
                        j = sr.read();
                        c = (char)j;
                        if (j == -1) {
                            throw new IllegalArgumentException("Invalid escape character");
                        }
                        if (c != '\\' && c != '\"' && SPECIALS.indexOf(c) < 0) {
                            if (HEXASTRING.indexOf(c = Character.toUpperCase(c)) < 0) {
                                throw new IllegalArgumentException("Invalid escaped character");
                            }
                            j = sr.read();
                            if (j == -1) {
                                throw new IllegalArgumentException("Invalid escaped character");
                            }
                            char c2 = Character.toUpperCase((char)j);
                            if (HEXASTRING.indexOf(c2) < 0) {
                                throw new IllegalArgumentException("Invalid escaped character");
                            }
                            c = (char)(HEXASTRING.indexOf(c) * 16 + HEXASTRING.indexOf(c2));
                        }
                    }
                    buf.append(c);
                    j = sr.read();
                    c = (char)j;
                } while (j != -1 && c != '+' && c != ';' && c != ',' && c != '>');
                this.binary = null;
                this.value = buf.toString().trim();
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Illegal AVA : " + name);
        }
        this.modified = true;
    }

    private String toRFC1779AttributeName() {
        if (this.type.equals(Name.CN)) {
            return "CN";
        }
        if (this.type.equals(Name.L)) {
            return "L";
        }
        if (this.type.equals(Name.ST)) {
            return "ST";
        }
        if (this.type.equals(Name.O)) {
            return "O";
        }
        if (this.type.equals(Name.OU)) {
            return "OU";
        }
        if (this.type.equals(Name.C)) {
            return "C";
        }
        if (this.type.equals(Name.STREET)) {
            return "STREET";
        }
        return "OID." + this.type.get();
    }

    private String toRFC2253AttributeName() {
        if (this.type.equals(Name.CN)) {
            return "CN";
        }
        if (this.type.equals(Name.L)) {
            return "L";
        }
        if (this.type.equals(Name.ST)) {
            return "ST";
        }
        if (this.type.equals(Name.O)) {
            return "O";
        }
        if (this.type.equals(Name.OU)) {
            return "OU";
        }
        if (this.type.equals(Name.C)) {
            return "C";
        }
        if (this.type.equals(Name.STREET)) {
            return "STREET";
        }
        if (this.type.equals(Name.DC)) {
            return "DC";
        }
        if (this.type.equals(Name.UID)) {
            return "UID";
        }
        return this.type.get();
    }

    private String toAttributeName() {
        return this.type.getName();
    }

    public String toString() {
        return this.toRFC2253String(this.toAttributeName());
    }

    public String toRFC2253CanonicalString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append(this.toRFC2253AttributeName());
        buf.append('=');
        if (this.binary != null || '0' <= buf.charAt(0) && buf.charAt(0) <= '9') {
            byte[] data = null;
            buf.append('#');
            if (this.binary == null) {
                DEREncoder enc = new DEREncoder();
                try {
                    this.checkCorrectTag();
                    ASN1Any.encodeAsString(enc, this.value, this.tag[0]);
                    data = enc.toByteArray();
                }
                catch (ASN1Exception ex) {
                    throw new IllegalArgumentException("Failed to encode String : " + this.value);
                }
            } else {
                data = this.binary;
            }
            for (int i = 0; i < data.length; ++i) {
                buf.append(HEXASTRING.charAt(data[i] >>> 4));
                buf.append(HEXASTRING.charAt(data[i] & 0xF));
            }
        } else {
            int k;
            char[] ca = this.value.toCharArray();
            for (int j = 0; j < ca.length && Character.isWhitespace(ca[j]); ++j) {
            }
            for (k = ca.length - 1; k >= 0 && Character.isWhitespace(ca[k]); --k) {
            }
            boolean inWhiteSpace = false;
            for (int i = j; i <= k; ++i) {
                char c = ca[i];
                if (!Character.isWhitespace(c)) {
                    inWhiteSpace = false;
                    if (SPECIALS.indexOf(c) >= 0) {
                        buf.append('\\');
                    }
                    buf.append(c);
                    continue;
                }
                if (inWhiteSpace) continue;
                inWhiteSpace = true;
                buf.append(c);
            }
        }
        return buf.toString().toUpperCase(Locale.US).toLowerCase(Locale.US);
    }

    public String toRFC2253String() {
        return this.toRFC2253String(this.toRFC2253AttributeName());
    }

    private String toRFC2253String(String t) {
        StringBuffer buf = new StringBuffer(64);
        buf.append(t);
        buf.append('=');
        if (this.binary != null || '0' <= buf.charAt(0) && buf.charAt(0) <= '9') {
            byte[] data = null;
            buf.append('#');
            if (this.binary == null) {
                DEREncoder enc = new DEREncoder();
                try {
                    this.checkCorrectTag();
                    ASN1Any.encodeAsString(enc, this.value, this.tag[0]);
                    data = enc.toByteArray();
                }
                catch (ASN1Exception ex) {
                    throw new IllegalArgumentException("Failed to encode String : " + this.value);
                }
            } else {
                data = this.binary;
            }
            for (int i = 0; i < data.length; ++i) {
                buf.append(HEXASTRING.charAt(data[i] >>> 4));
                buf.append(HEXASTRING.charAt(data[i] & 0xF));
            }
        } else {
            int k;
            int j;
            char[] ca = this.value.toCharArray();
            for (j = 0; j < ca.length && (ca[j] == '\n' || ca[j] == '\r'); ++j) {
            }
            for (k = ca.length - 1; k >= 0 && (ca[k] == '\n' || ca[k] == '\r'); --k) {
            }
            for (int i = 0; i < ca.length; ++i) {
                if (i < j || i > k) {
                    buf.append('\\');
                    buf.append(HEXASTRING.charAt(ca[i] >>> 4));
                    buf.append(HEXASTRING.charAt(ca[i] & 0xF));
                    continue;
                }
                if (SPECIALS.indexOf(ca[i]) >= 0) {
                    buf.append('\\');
                    buf.append(ca[i]);
                    continue;
                }
                buf.append(ca[i]);
            }
        }
        return new String(buf);
    }

    public String toRFC1779String() {
        StringBuffer buf = new StringBuffer(64);
        String t = this.toRFC1779AttributeName();
        boolean oid = t.startsWith("OID.");
        buf.append(t);
        buf.append('=');
        if (this.binary != null || oid) {
            byte[] data = null;
            buf.append('#');
            if (oid) {
                DEREncoder enc = new DEREncoder();
                try {
                    this.checkCorrectTag();
                    ASN1Any.encodeAsString(enc, this.value, this.tag[0]);
                    data = enc.toByteArray();
                }
                catch (ASN1Exception ex) {
                    throw new IllegalArgumentException("Failed to encode String : " + this.value);
                }
            } else {
                data = this.binary;
            }
            for (int i = 0; i < data.length; ++i) {
                buf.append(HEXASTRING.charAt(data[i] >>> 4));
                buf.append(HEXASTRING.charAt(data[i] & 0xF));
            }
        } else {
            char[] ca = this.value.toCharArray();
            boolean quoted = false;
            for (int i = 0; i < SPECIALS.length(); ++i) {
                if (this.value.indexOf(SPECIALS.charAt(i)) < 0) continue;
                quoted = true;
                break;
            }
            int l = this.value.length() - 1;
            if (!(quoted || this.value.charAt(0) != ' ' && this.value.charAt(0) != '\n' && this.value.charAt(l) != ' ' && this.value.charAt(l) != '\n')) {
                quoted = true;
            }
            if (quoted) {
                buf.append('\"');
            }
            for (int i = 0; i < this.value.length(); ++i) {
                char c = this.value.charAt(i);
                if (c == '\\' || c == '\"') {
                    buf.append('\\');
                }
                buf.append(c);
            }
            if (quoted) {
                buf.append('\"');
            }
        }
        return new String(buf);
    }

    public int hashCode() {
        return this.toRFC2253CanonicalString().hashCode();
    }

    static {
        typeTable.setProperty("2.5.4.3", "DIRECTORYSTRING");
        typeTable.setProperty("2.5.4.4", "DIRECTORYSTRING");
        typeTable.setProperty("2.5.4.5", "PRINTABLESTRING");
        typeTable.setProperty("2.5.4.6", "PRINTABLESTRING");
        typeTable.setProperty("2.5.4.7", "DIRECTORYSTRING");
        typeTable.setProperty("2.5.4.8", "DIRECTORYSTRING");
        typeTable.setProperty("2.5.4.9", "DIRECTORYSTRING");
        typeTable.setProperty("2.5.4.10", "DIRECTORYSTRING");
        typeTable.setProperty("2.5.4.11", "DIRECTORYSTRING");
        typeTable.setProperty("2.5.4.12", "DIRECTORYSTRING");
        typeTable.setProperty("2.5.4.42", "DIRECTORYSTRING");
        typeTable.setProperty("2.5.4.43", "DIRECTORYSTRING");
        typeTable.setProperty("2.5.4.44", "DIRECTORYSTRING");
        typeTable.setProperty("2.5.4.46", "PRINTABLESTRING");
        typeTable.setProperty("1.2.840.113549.1.9.1", "IA5STRING");
        typeTable.setProperty("1.2.840.113549.1.9.2", "PKCS9STRING");
        typeTable.setProperty("1.2.840.113549.1.9.8", "PKCS9DIRECTORYSTRING");
        typeTable.setProperty("1.3.6.1.5.5.7.9.2", "PKCS9DIRECTORYSTRING");
        typeTable.setProperty("1.3.6.1.5.5.7.9.3", "PRINTABLESTRING");
        typeTable.setProperty("1.3.6.1.5.5.7.9.4", "PRINTABLESTRING");
        typeTable.setProperty("1.3.6.1.5.5.7.9.5", "PRINTABLESTRING");
        typeTable.setProperty("0.9.2342.19200300.100.1.1", "DIRECTORYSTRING");
        typeTable.setProperty("0.9.2342.19200300.100.1.3", "IA5STRING");
        typeTable.setProperty("0.9.2342.19200300.100.1.25", "IA5STRING");
    }
}

