/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.DEREncoder;

public class AlgorithmID
implements ASN1Type,
Cloneable {
    private static final long serialVersionUID = -7917154495742410009L;
    private ASN1OID oid;
    private byte[] param;
    private boolean omitparam;
    private boolean modified = true;
    private byte[] encoded;
    public static final AlgorithmID rsaEncryption = new AlgorithmID("1.2.840.113549.1.1.1", null);
    public static final AlgorithmID dsa = new AlgorithmID("1.2.840.10040.4.1", null);
    public static final AlgorithmID dhPublicKey = new AlgorithmID("1.2.840.10046.2.1", null);
    public static final AlgorithmID ecPublicKey = new AlgorithmID("1.2.840.10045.2.1", null);
    public static final AlgorithmID kcdsa1 = new AlgorithmID("1.2.410.200004.1.21", null);
    public static final AlgorithmID MD5WithRSA = new AlgorithmID("1.2.840.113549.1.1.4", null);
    public static final AlgorithmID SHA1WithRSA = new AlgorithmID("1.2.840.113549.1.1.5", null);
    public static final AlgorithmID rsassaPSS = new AlgorithmID("1.2.840.113549.1.1.10", null);
    public static final AlgorithmID SHA224WithRSA = new AlgorithmID("1.2.840.113549.1.1.14", null);
    public static final AlgorithmID SHA256WithRSA = new AlgorithmID("1.2.840.113549.1.1.11", null);
    public static final AlgorithmID SHA384WithRSA = new AlgorithmID("1.2.840.113549.1.1.12", null);
    public static final AlgorithmID SHA512WithRSA = new AlgorithmID("1.2.840.113549.1.1.13", null);
    public static final AlgorithmID SHA1WithDSA = new AlgorithmID("1.2.840.10040.4.3");
    public static final AlgorithmID HMACWithSHA1 = new AlgorithmID("1.2.840.113549.2.7", null);
    public static final AlgorithmID HMACWithSHA224 = new AlgorithmID("1.2.840.113549.2.8", null);
    public static final AlgorithmID HMACWithSHA256 = new AlgorithmID("1.2.840.113549.2.9", null);
    public static final AlgorithmID HMACWithSHA384 = new AlgorithmID("1.2.840.113549.2.10", null);
    public static final AlgorithmID HMACWithSHA512 = new AlgorithmID("1.2.840.113549.2.11", null);
    public static final AlgorithmID SHA1 = new AlgorithmID("1.3.14.3.2.26", null);
    public static final AlgorithmID SHA224 = new AlgorithmID("2.16.840.1.101.3.4.2.4", null);
    public static final AlgorithmID SHA256 = new AlgorithmID("2.16.840.1.101.3.4.2.1", null);
    public static final AlgorithmID SHA384 = new AlgorithmID("2.16.840.1.101.3.4.2.2", null);
    public static final AlgorithmID SHA512 = new AlgorithmID("2.16.840.1.101.3.4.2.3", null);
    public static final AlgorithmID MD5 = new AlgorithmID("1.2.840.113549.2.5", null);
    public static final AlgorithmID HAS160 = new AlgorithmID("1.2.410.200004.1.2", null);
    public static final AlgorithmID SHA224withECDSA = new AlgorithmID("1.2.840.10045.4.3.1", null);
    public static final AlgorithmID SHA256withECDSA = new AlgorithmID("1.2.840.10045.4.3.2", null);
    public static final AlgorithmID SHA384withECDSA = new AlgorithmID("1.2.840.10045.4.3.3", null);
    public static final AlgorithmID SHA512withECDSA = new AlgorithmID("1.2.840.10045.4.3.4", null);
    public static final AlgorithmID nfcObjectBasedEncryption = new AlgorithmID("1.3.6.1.4.1.7150.11.30", null);
    public static final AlgorithmID bluetoothObjectBasedEncryption = new AlgorithmID("1.3.6.1.4.1.7150.11.31", null);
    public static final AlgorithmID fingerprintBasedEncryption = new AlgorithmID("1.3.6.1.4.1.7150.11.40", null);
    public static final AlgorithmID irisBasedEncryption = new AlgorithmID("1.3.6.1.4.1.7150.11.41", null);
    public static final AlgorithmID smartsignBasedEncryption = new AlgorithmID("1.3.6.1.4.1.7150.11.42", null);
    public static final AlgorithmID voiceBasedEncryption = new AlgorithmID("1.3.6.1.4.1.7150.11.43", null);

    public AlgorithmID() {
        this.oid = new ASN1OID();
        this.param = null;
        this.omitparam = true;
    }

    public AlgorithmID(String id) {
        this.oid = new ASN1OID(id);
        this.param = null;
        this.omitparam = true;
    }

    public AlgorithmID(String id, byte[] p) {
        this.oid = new ASN1OID(id);
        this.omitparam = false;
        this.param = (byte[])(p == null ? null : (byte[])p.clone());
    }

    public AlgorithmID(ASN1OID id, byte[] p) {
        this.oid = id;
        this.omitparam = false;
        this.param = (byte[])(p == null ? null : (byte[])p.clone());
    }

    public Object clone() {
        AlgorithmID ret = new AlgorithmID();
        ret.setAlgorithm(this.oid);
        ret.omitParameter(this.omitparam);
        if (!this.omitparam) {
            ret.setParameter(this.param);
        }
        return ret;
    }

    public String getAlgName() {
        return this.oid.getName();
    }

    public String getAlg() {
        return this.oid.get();
    }

    public int getAlgorithmCategory() {
        return this.oid.getCategory();
    }

    public void setAlgorithm(String id) {
        this.oid.set(id);
        this.modified = true;
    }

    public void setAlgorithm(ASN1OID id) {
        this.oid.set(id);
        this.modified = true;
    }

    public void omitParameter(boolean omit) {
        this.omitparam = omit;
        this.modified = true;
    }

    public boolean hasParameter() {
        if (this.omitparam) {
            return false;
        }
        return this.param != null;
    }

    public byte[] getParameter() {
        if (this.param == null) {
            return null;
        }
        return (byte[])this.param.clone();
    }

    public void setParameter(byte[] p) {
        this.omitparam = false;
        this.param = (byte[])(p != null ? (byte[])p.clone() : null);
        this.modified = true;
    }

    public byte[] getEncoded() {
        if (this.modified || this.encoded == null) {
            try {
                DEREncoder enc = new DEREncoder();
                this.encode(enc);
                this.encoded = enc.toByteArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.modified = false;
        }
        return this.encoded;
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id = dec.decodeSequence();
        this.oid = dec.decodeObjectIdentifier();
        if (dec.nextIsOptional(0)) {
            this.omitparam = true;
            this.param = null;
        } else {
            int tag = dec.peekNextTag();
            switch (ASN1Tag.getTagNumber(tag)) {
                case 5: {
                    this.omitparam = false;
                    this.param = null;
                    dec.decodeAnyAsByteArray();
                    break;
                }
                default: {
                    this.omitparam = false;
                    this.param = dec.decodeAnyAsByteArray();
                }
            }
        }
        dec.endOf(id);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequence();
        enc.encodeObjectIdentifier(this.oid);
        if (!this.omitparam) {
            if (this.param == null) {
                enc.encodeNull();
            } else {
                enc.encodeAny(this.param);
            }
        }
        enc.endOf(id);
    }
}

