/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Any;
import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.useful.GeneralNameInterface;
import com.initech.cryptox.util.Hex;

public class AnotherName
implements GeneralNameInterface {
    private static final long serialVersionUID = 1054329994733494599L;
    protected ASN1OID typeid = new ASN1OID();
    protected ASN1Any value = new ASN1Any();

    public AnotherName() {
    }

    AnotherName(ASN1Decoder dec) throws ASN1Exception {
        this.decode(dec);
    }

    public AnotherName(String id, String value) throws ASN1Exception {
        this.typeid.set(id);
        this.value.setString(value);
    }

    public AnotherName(ASN1OID id, String value) throws ASN1Exception {
        this.typeid = id;
        this.value.setString(value);
    }

    public AnotherName(String id, ASN1Any value) {
        this.typeid.set(id);
        this.value = value;
    }

    public AnotherName(ASN1OID id, ASN1Any value) {
        this.typeid = id;
        this.value = value;
    }

    public ASN1OID getOID() {
        return this.typeid;
    }

    public byte[] getBytes() {
        return this.value.getValue();
    }

    public String getString() {
        try {
            return this.value.getValueAsString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setOID(String oid) {
        this.typeid = new ASN1OID(oid);
    }

    public void setOID(ASN1OID oid) {
        this.typeid = oid;
    }

    public void setValue(String s) throws ASN1Exception {
        this.value.setString(s);
    }

    public void setValue(String s, int type) throws ASN1Exception {
        this.value.setString(s, type);
    }

    public int getType() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AnotherName)) {
            return false;
        }
        AnotherName other = (AnotherName)obj;
        if (!this.typeid.equals(other.typeid)) {
            return false;
        }
        return this.value.equals(other.value);
    }

    public int constrains(GeneralNameInterface gni) throws UnsupportedOperationException {
        int ret;
        if (gni == null) {
            ret = -1;
        } else if (gni.getType() != 0) {
            ret = -1;
        } else if (this.equals((AnotherName)gni)) {
            ret = 0;
        } else {
            throw new UnsupportedOperationException("Narrowing, widening and matching are not supported for OtherName");
        }
        return ret;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not defined for AnotherName");
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean can) {
        return this.toString(can, false);
    }

    public String toString(boolean can, boolean withType) {
        StringBuffer buf = new StringBuffer(40);
        buf.append(this.typeid.getName());
        buf.append('=');
        String val = null;
        try {
            val = this.value.getValueAsString();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (val == null) {
            val = Hex.prettyDump(this.value.getValue(), 48, ' ');
        }
        buf.append(val);
        String ret = new String(buf);
        if (withType) {
            ret = "OtherName: " + ret;
        }
        return ret;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequence();
        enc.encodeObjectIdentifier(this.typeid);
        int id2 = enc.encodeExplicit(ASN1Tag.makeContextTag(0));
        enc.encodeAny(this.value);
        enc.endOf(id2);
        enc.endOf(id);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id = dec.decodeSequence();
        this.typeid = dec.decodeObjectIdentifier();
        int id2 = dec.decodeExplicit(ASN1Tag.makeContextTag(0));
        this.value = dec.decodeAny();
        dec.endOf(id2);
        dec.endOf(id);
    }
}

