/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.ASN1Object;
import com.initech.cryptox.util.Hex;
import com.initech.cryptox.util.StringUtil;
import java.util.Enumeration;
import java.util.Vector;

public class Attribute
implements ASN1Type {
    private static final long serialVersionUID = 7760519940501632509L;
    ASN1OID type;
    Vector attrs;

    public Attribute() {
        this.type = new ASN1OID();
        this.attrs = new Vector(2);
    }

    public Attribute(String tname) {
        this.type = new ASN1OID(tname);
        this.attrs = new Vector(2);
    }

    public Attribute(String tname, Vector attrs) {
        this.type = new ASN1OID(tname);
        this.attrs = attrs;
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.attrs.removeAllElements();
        int id = dec.decodeSequence();
        this.type = dec.decodeObjectIdentifier();
        int atid = dec.decodeSetOf();
        while (!dec.endOf(atid)) {
            byte[] data = dec.decodeAnyAsByteArray();
            this.attrs.addElement(data);
        }
        dec.endOf(id);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        if (this.attrs.size() == 0) {
            return;
        }
        int id = enc.encodeSequence();
        enc.encodeObjectIdentifier(this.type);
        int atid = enc.encodeSetOf();
        for (int i = 0; i < this.attrs.size(); ++i) {
            byte[] data = (byte[])this.attrs.elementAt(i);
            enc.encodeAny(data);
        }
        enc.endOf(atid);
        enc.endOf(id);
    }

    public String getAttrName() {
        return this.type.getName();
    }

    public String getAttrID() {
        return this.type.get();
    }

    public int size() {
        return this.attrs.size();
    }

    public Enumeration elements() {
        return this.attrs.elements();
    }

    public byte[] attributeAt(int i) {
        return (byte[])this.attrs.elementAt(i);
    }

    public void setAttrName(String name) {
        this.type.set(name);
    }

    public void setAttrValues(Vector dats) {
        this.attrs = dats;
    }

    public void add(byte[] data) {
        this.attrs.addElement(data);
    }

    public void add(ASN1Type data) {
        try {
            if (data instanceof ASN1Object) {
                this.attrs.addElement(((ASN1Object)data).getEncoded());
            } else {
                DEREncoder enc = new DEREncoder();
                data.encode(enc);
                this.attrs.addElement(enc.toByteArray());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void toString(StringBuffer buf, int n) {
        StringUtil.indent(buf, n + 1);
        buf.append("Type: ");
        buf.append(this.type.getName());
        buf.append("\n");
        for (int i = 0; i < this.attrs.size(); ++i) {
            byte[] data = (byte[])this.attrs.elementAt(i);
            StringUtil.indent(buf, n + 1);
            buf.append("Value: ");
            buf.append(Hex.prettyDump(data, 48, ' '));
            buf.append('\n');
        }
    }

    public String toString(int n) {
        StringBuffer buf = new StringBuffer(80);
        this.toString(buf, n);
        return new String(buf);
    }

    public String toString() {
        return this.toString(0);
    }
}

