/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Attribute;
import java.util.Enumeration;
import java.util.Vector;

public class Attributes
implements ASN1Type {
    private static final long serialVersionUID = 8103779731126022681L;
    Vector attrs = new Vector();

    public Attribute get(String id) {
        ASN1OID oid = new ASN1OID(id);
        String target = oid.get();
        for (int i = 0; i < this.attrs.size(); ++i) {
            Attribute at = (Attribute)this.attrs.elementAt(i);
            if (!target.equals(at.getAttrID())) continue;
            return at;
        }
        return null;
    }

    public void add(Attribute at) {
        this.attrs.addElement(at);
    }

    public int size() {
        return this.attrs.size();
    }

    public Enumeration elements() {
        return this.attrs.elements();
    }

    public void clear() {
        this.attrs.removeAllElements();
    }

    public void sort() throws ASN1Exception {
        byte[][] array = new byte[this.attrs.size()][];
        for (int i = 0; i < this.attrs.size(); ++i) {
            DEREncoder enc = new DEREncoder();
            Attribute at = (Attribute)this.attrs.elementAt(i);
            at.encode(enc);
            array[i] = enc.toByteArray();
        }
        for (int i = 0; i < this.attrs.size() - 1; ++i) {
            for (int j = i + 1; j < this.attrs.size(); ++j) {
                if (this.compare(array[i], array[j]) <= 0) continue;
                byte[] temp = array[i];
                array[i] = array[j];
                array[j] = temp;
                Object tempObj = this.attrs.elementAt(i);
                this.attrs.setElementAt(this.attrs.elementAt(j), i);
                this.attrs.setElementAt(tempObj, j);
            }
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        this.sort();
        int id = enc.encodeSetOf();
        for (int i = 0; i < this.attrs.size(); ++i) {
            Attribute at = (Attribute)this.attrs.elementAt(i);
            at.encode(enc);
        }
        enc.endOf(id);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.attrs.removeAllElements();
        int id = dec.decodeSetOf();
        while (!dec.endOf(id)) {
            Attribute at = new Attribute();
            at.decode(dec);
            this.attrs.addElement(at);
        }
        this.sort();
    }

    public int compare(byte[] a, byte[] b) {
        if (a.length > b.length) {
            return 1;
        }
        if (a.length < b.length) {
            return -1;
        }
        for (int i = 0; i < a.length; ++i) {
            int an = a[i] & 0xFF;
            int bn = b[i] & 0xFF;
            if (an > bn) {
                return 1;
            }
            if (an >= bn) continue;
            return -1;
        }
        return 0;
    }
}

