/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.useful.GeneralNameInterface;

public class DNSName
implements GeneralNameInterface {
    private static final long serialVersionUID = 7777353347225714396L;
    String name;
    private static final String ALPHA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String DIGITS_AND_HYPHEN = "0123456789-";
    private static final String ALPHA_DIGITS_AND_HYPHEN = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-";

    DNSName(ASN1Decoder dec) throws ASN1Exception {
        this.decode(dec);
    }

    public DNSName(String s) throws IllegalArgumentException {
        if (s == null || s.length() != 0) {
            this.parseName(s);
        }
        this.name = s;
    }

    public void parseName(String s) throws IllegalArgumentException {
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("DNS name must not be null");
        }
        if (s.indexOf(32) != -1) {
            throw new IllegalArgumentException("DNS names or NameConstraints with blank components are not permitted");
        }
        if (s.charAt(0) == '.' || s.charAt(s.length() - 1) == '.') {
            throw new IllegalArgumentException("DNS names or NameConstraints may not begin or end with a .");
        }
        int j = 0;
        while (j < s.length()) {
            int i = s.indexOf(46, j);
            if (i < 0) {
                i = s.length();
            }
            if (i - j < 1) {
                throw new IllegalArgumentException("DNSName SubjectAltNames with empty components are not permitted");
            }
            if (ALPHA.indexOf(s.charAt(j)) < 0) {
                throw new IllegalArgumentException("DNSName components must begin with a letter");
            }
            for (int k = j + 1; k < i; ++k) {
                char c = s.charAt(k);
                if (ALPHA_DIGITS_AND_HYPHEN.indexOf(c) >= 0) continue;
                throw new IllegalArgumentException("DNSName components must consists of letters, digits, and hyphens");
            }
            j = i + 1;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof DNSName) {
            DNSName n = (DNSName)o;
            return this.name.equalsIgnoreCase(n.name);
        }
        if (o instanceof String) {
            return this.name.equalsIgnoreCase((String)o);
        }
        return false;
    }

    public int getType() {
        return 2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) throws IllegalArgumentException {
        this.parseName(s);
        this.name = s;
    }

    public int hashCode() {
        return this.name.toUpperCase().hashCode();
    }

    public int constrains(GeneralNameInterface gni) throws UnsupportedOperationException {
        int ret;
        if (gni == null) {
            ret = -1;
        } else if (gni.getType() != 2) {
            ret = -1;
        } else {
            String other = ((DNSName)gni).getName().toLowerCase();
            String my = this.name.toLowerCase();
            if (other.length() > 0) {
                other = "." + other;
            }
            if (my.length() > 0) {
                my = "." + my;
            }
            ret = my.equals(other) ? 0 : (my.endsWith(other) ? 1 : (other.endsWith(my) ? 2 : 3));
        }
        return ret;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        int j;
        String s = this.name;
        int k = s.length() - 1;
        int i = 1;
        while ((j = s.lastIndexOf(46, k)) >= 0) {
            k = j - 1;
            ++i;
        }
        return i;
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean can) {
        return this.toString(can, false);
    }

    public String toString(boolean can, boolean withType) {
        String ret = can ? this.name.toLowerCase() : this.name.toString();
        if (withType) {
            ret = "DNSName: " + ret;
        }
        return ret;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.encodeIA5String(this.name);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.name = dec.decodeIA5String();
        this.parseName(this.name);
    }
}

