/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Any;
import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.useful.GeneralNameInterface;

public class EDIPartyName
implements GeneralNameInterface {
    private static final long serialVersionUID = -8585420041855353015L;
    String assigner;
    String party;

    EDIPartyName(ASN1Decoder dec) throws ASN1Exception {
        this.decode(dec);
    }

    public EDIPartyName(String a, String p) {
        this.assigner = a;
        this.party = p;
    }

    public EDIPartyName(String p) throws ASN1Exception {
        this.party = p;
    }

    public String getAssigner() {
        return this.assigner;
    }

    public String getParty() {
        return this.party;
    }

    public int getType() {
        return 5;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EDIPartyName)) {
            return false;
        }
        EDIPartyName other = (EDIPartyName)obj;
        if (this.assigner == null ? other.assigner != null : !this.assigner.equals(other.assigner)) {
            return false;
        }
        return !(this.party == null ? other.party != null : !this.party.equals(other.party));
    }

    public int constrains(GeneralNameInterface gni) throws UnsupportedOperationException {
        int ret;
        if (gni == null) {
            ret = -1;
        } else if (gni.getType() != 3) {
            ret = -1;
        } else {
            throw new UnsupportedOperationException("Narrowing, widening and matching are not supported for EDIPartyName");
        }
        return ret;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not defined for EDIPartyName");
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean can) {
        return this.toString(can, false);
    }

    public String toString(boolean can, boolean withType) {
        StringBuffer buf = new StringBuffer(40);
        if (this.assigner != null) {
            buf.append("Name Assigner: ");
            buf.append(this.assigner);
            buf.append(", ");
        }
        buf.append("Party Name: " + this.party);
        String ret = new String(buf);
        if (withType) {
            ret = "EDIPartyName: " + ret;
        }
        return ret;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id2;
        int id = enc.encodeSequence();
        if (this.assigner != null) {
            id2 = enc.encodeExplicit(ASN1Tag.makeContextTag(0));
            ASN1Any.encodeAsString(enc, this.assigner, -1);
            enc.endOf(id2);
        }
        id2 = enc.encodeExplicit(ASN1Tag.makeContextTag(1));
        ASN1Any.encodeAsString(enc, this.party, -1);
        enc.endOf(id2);
        enc.endOf(id);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id2;
        int id = dec.decodeSequence();
        if (dec.nextIsOptional(ASN1Tag.makeExplicitTag(0))) {
            this.assigner = null;
        } else {
            id2 = dec.decodeExplicit(ASN1Tag.makeExplicitTag(0));
            this.assigner = ASN1Any.decodeAsString(dec);
            dec.endOf(id2);
        }
        id2 = dec.decodeExplicit(ASN1Tag.makeExplicitTag(1));
        this.party = ASN1Any.decodeAsString(dec);
        dec.endOf(id2);
        dec.endOf(id);
    }
}

