/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.asn1.useful.EncryptContent;
import com.initech.asn1.useful.HashContent;
import com.initech.asn1.useful.IssuerAndSerialNumber;
import com.initech.asn1.useful.VID;
import com.initech.cryptox.BadPaddingException;
import com.initech.cryptox.Cipher;
import com.initech.cryptox.IllegalBlockSizeException;
import com.initech.cryptox.NoSuchPaddingException;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.spec.RSAOAEPParameterSpec;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;

public class EVID
implements ASN1Type {
    private static final long serialVersionUID = 2182716391110096582L;
    public static ASN1OID OID = new ASN1OID("1.2.410.200004.10.1.1.2");
    private static int DEFAULT_VERSION = 0;
    private int version;
    private AlgorithmID hashAlg = new AlgorithmID();
    private AlgorithmID encAlg = new AlgorithmID();
    private IssuerAndSerialNumber certId = new IssuerAndSerialNumber();
    private byte[] evid;
    private AlgorithmID encHashAlg = new AlgorithmID("1.3.14.3.2.26");

    public EVID() {
    }

    public EVID(int i, AlgorithmID algorithmid, AlgorithmID algorithmid1, IssuerAndSerialNumber issuerandserialnumber) {
        this.version = i;
        this.hashAlg = algorithmid;
        this.encAlg = algorithmid1;
        this.certId = issuerandserialnumber;
    }

    public EVID(int i, String s, String s1, IssuerAndSerialNumber issuerandserialnumber) {
        this(i, new AlgorithmID(s), new AlgorithmID(s1), issuerandserialnumber);
    }

    public EVID(AlgorithmID algorithmid, AlgorithmID algorithmid1, IssuerAndSerialNumber issuerandserialnumber) {
        this(DEFAULT_VERSION, algorithmid, algorithmid1, issuerandserialnumber);
    }

    public EVID(String s, String s1, IssuerAndSerialNumber issuerandserialnumber) {
        this(new AlgorithmID(s), new AlgorithmID(s1), issuerandserialnumber);
    }

    public EVID(byte[] abyte0) throws ASN1Exception {
        DEREncoder derencoder = new DEREncoder();
        this.encode(derencoder);
    }

    public void decode(ASN1Decoder asn1decoder) throws ASN1Exception {
        int i = asn1decoder.decodeSequence();
        int j = asn1decoder.decodeExplicit(ASN1Tag.makeContextTag(0));
        this.version = asn1decoder.decodeIntegerAsInt();
        asn1decoder.endOf(j);
        if (asn1decoder.nextIsOptional(ASN1Tag.makeExplicitTag(1))) {
            this.hashAlg = null;
        } else {
            j = asn1decoder.decodeExplicit(ASN1Tag.makeContextTag(1));
            this.hashAlg.decode(asn1decoder);
            asn1decoder.endOf(j);
        }
        j = asn1decoder.decodeExplicit(ASN1Tag.makeContextTag(2));
        this.encAlg.decode(asn1decoder);
        asn1decoder.endOf(j);
        j = asn1decoder.decodeExplicit(ASN1Tag.makeContextTag(3));
        this.certId.decode(asn1decoder);
        asn1decoder.endOf(j);
        j = asn1decoder.decodeExplicit(ASN1Tag.makeContextTag(4));
        this.evid = asn1decoder.decodeOctetString();
        asn1decoder.endOf(j);
        asn1decoder.endOf(i);
    }

    public void encode(ASN1Encoder asn1encoder) throws ASN1Exception {
        int i = asn1encoder.encodeSequence();
        int j = asn1encoder.encodeExplicit(ASN1Tag.makeContextTag(0));
        asn1encoder.encodeInteger(this.version);
        asn1encoder.endOf(j);
        if (this.hashAlg != null) {
            j = asn1encoder.encodeExplicit(ASN1Tag.makeContextTag(1));
            this.hashAlg.encode(asn1encoder);
            asn1encoder.endOf(j);
        }
        j = asn1encoder.encodeExplicit(ASN1Tag.makeContextTag(2));
        this.encAlg.encode(asn1encoder);
        asn1encoder.endOf(j);
        j = asn1encoder.encodeExplicit(ASN1Tag.makeContextTag(3));
        this.certId.encode(asn1encoder);
        asn1encoder.endOf(j);
        j = asn1encoder.encodeExplicit(ASN1Tag.makeContextTag(4));
        asn1encoder.encodeOctetString(this.evid);
        asn1encoder.endOf(j);
        asn1encoder.endOf(i);
    }

    public AlgorithmID getEncAlg() {
        return this.encAlg;
    }

    public byte[] getEncoded() throws ASN1Exception {
        DEREncoder derencoder = new DEREncoder();
        this.encode(derencoder);
        return derencoder.toByteArray();
    }

    public AlgorithmID getHashAlg() {
        return this.hashAlg;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.certId;
    }

    public int getVersion() {
        return this.version;
    }

    public AlgorithmID getEncHashAlg() {
        return this.encHashAlg;
    }

    public void set(int i, AlgorithmID algorithmid, AlgorithmID algorithmid1, IssuerAndSerialNumber issuerandserialnumber, HashContent hashcontent, PublicKey publickey) throws ASN1Exception, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, DigestException, NoSuchPaddingException, NoSuchProviderException {
        this.setVersion(i);
        this.setHashAlg(algorithmid);
        this.setEncAlg(algorithmid1);
        this.setIssuerAndSerialNumber(issuerandserialnumber);
        this.setEVID(hashcontent, publickey);
    }

    public void set(int i, AlgorithmID algorithmid, AlgorithmID algorithmid1, IssuerAndSerialNumber issuerandserialnumber, HashContent hashcontent, PublicKey publickey, AlgorithmID algorithmid2) throws ASN1Exception, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, DigestException, NoSuchPaddingException, NoSuchProviderException {
        this.setVersion(i);
        this.setHashAlg(algorithmid);
        this.setEncAlg(algorithmid1);
        this.setIssuerAndSerialNumber(issuerandserialnumber);
        this.setEncHashAlg(algorithmid2);
        this.setEVID(hashcontent, publickey);
    }

    public void setEVID(HashContent hashcontent, PublicKey publickey) throws ASN1Exception, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, DigestException, NoSuchPaddingException, NoSuchProviderException {
        Cipher cipher;
        VID vid = null;
        vid = this.hashAlg != null ? new VID(this.hashAlg) : new VID();
        vid.setVID(hashcontent);
        EncryptContent encryptcontent = new EncryptContent();
        encryptcontent.set(vid, hashcontent.getRandom());
        try {
            if (this.encAlg.getAlg().equals("1.2.840.113549.1.1.7")) {
                cipher = Cipher.getInstance("RSA/ECB/OAEPPadding", InitechProvider.NAME);
                cipher.init(1, (Key)publickey, new RSAOAEPParameterSpec(this.encHashAlg.getAlgName(), null));
            } else {
                cipher = Cipher.getInstance(this.encAlg.getAlgName());
                cipher.init(1, publickey);
            }
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeyException(e.getMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new DigestException(e.getMessage());
        }
        this.evid = cipher.doFinal(encryptcontent.getEncoded());
    }

    public void setEncAlg(AlgorithmID algorithmid) {
        this.encAlg = algorithmid;
    }

    public void setEncAlg(String s) {
        this.setEncAlg(new AlgorithmID(s));
    }

    public void setHashAlg(AlgorithmID algorithmid) {
        this.hashAlg = algorithmid;
    }

    public void setHashAlg(String s) {
        this.setHashAlg(new AlgorithmID(s));
    }

    public void setIssuerAndSerialNumber(IssuerAndSerialNumber issuerandserialnumber) {
        this.certId = issuerandserialnumber;
    }

    public void setVersion(int i) {
        this.version = i;
    }

    public void setEncHashAlg(AlgorithmID algorithmid) {
        this.encHashAlg = algorithmid;
    }
}

