/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1BitString;
import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.VID;

public class EncryptContent
implements ASN1Type {
    private static final long serialVersionUID = 9082240401198857981L;
    private VID vid = new VID();
    private ASN1BitString random;
    private static int RANDOM_SIZE = 20;

    public EncryptContent() {
    }

    public EncryptContent(VID vid1, byte[] abyte0) {
        this.setVID(vid1);
        this.setRandom(abyte0);
    }

    public EncryptContent(byte[] abyte0) throws ASN1Exception {
        DERDecoder derdecoder = new DERDecoder(abyte0);
        this.decode(derdecoder);
    }

    public void decode(ASN1Decoder asn1decoder) throws ASN1Exception {
        int i = asn1decoder.decodeSequence();
        this.vid.decode(asn1decoder);
        this.random = asn1decoder.decodeBitString();
        asn1decoder.endOf(i);
    }

    public void encode(ASN1Encoder asn1encoder) throws ASN1Exception {
        int i = asn1encoder.encodeSequence();
        this.vid.encode(asn1encoder);
        asn1encoder.encodeBitString(this.random);
        asn1encoder.endOf(i);
    }

    public byte[] getEncoded() throws ASN1Exception {
        DEREncoder derencoder = new DEREncoder();
        this.encode(derencoder);
        return derencoder.toByteArray();
    }

    public byte[] getRandom() {
        return this.random.getAsByteArray();
    }

    public VID getVID() {
        return this.vid;
    }

    public void set(VID vid1, byte[] abyte0) {
        this.setVID(vid1);
        this.setRandom(abyte0);
    }

    public void setRandom(byte[] abyte0) {
        this.random = new ASN1BitString();
        this.random.setByteArray(abyte0);
    }

    public void setVID(VID vid1) {
        this.vid = vid1;
    }
}

