/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Any;
import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1StringFactory;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.useful.ASN1Object;
import com.initech.cryptox.util.Hex;

public class Extension
extends ASN1Object {
    private static final long serialVersionUID = 6288187222548444548L;
    protected ASN1OID extId = new ASN1OID();
    protected boolean critical = false;
    protected byte[] extVal = null;

    public Extension() {
    }

    public Extension(byte[] arr) throws ASN1Exception {
        DERDecoder dec = new DERDecoder(arr);
        this.decode(dec);
        this.encoded = (byte[])arr.clone();
        this.modified = false;
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id = dec.decodeSequence();
        this.extId = dec.decodeObjectIdentifier();
        this.critical = dec.nextIsOptional(1) ? false : dec.decodeBoolean();
        this.extVal = dec.decodeAnyAsByteArray();
        dec.endOf(id);
        this.decodeExtValue0();
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        if (this.shouldOmitted()) {
            return;
        }
        if (this.getClass() != Extension.class) {
            this.encodeExtValue0();
        }
        int id = enc.encodeSequence();
        enc.encodeObjectIdentifier(this.extId);
        if (this.critical) {
            enc.encodeBoolean(true);
        }
        enc.encodeAny(this.extVal);
        enc.endOf(id);
    }

    public boolean isCritical() {
        return this.critical;
    }

    public String getExtName() {
        return this.extId.getName();
    }

    public String getExtOID() {
        return this.extId.get();
    }

    public byte[] getExtValue() {
        if (this.modified || this.extVal == null) {
            try {
                this.encodeExtValue0();
            }
            catch (Exception ignore) {
                this.extVal = null;
            }
        }
        return this.extVal;
    }

    public void setCritical(boolean cri) {
        this.modified = true;
        this.critical = cri;
    }

    public void setExtensionID(String id) {
        this.modified = true;
        this.extId.set(id);
    }

    public void setExtension(byte[] dat) {
        this.modified = true;
        this.extVal = dat;
    }

    protected void encodeExtValue0() throws ASN1Exception {
        byte[] b;
        this.encodeExtValue();
        int clen = this.extVal.length;
        if (clen < 128) {
            b = new byte[2 + clen];
            b[0] = 4;
            b[1] = (byte)clen;
            System.arraycopy(this.extVal, 0, b, 2, clen);
        } else {
            byte[] lb = new byte[]{(byte)(clen >>> 24), (byte)(clen >>> 16 & 0xFF), (byte)(clen >>> 8 & 0xFF), (byte)(clen & 0xFF)};
            int llen = clen > 255 ? (clen > 65535 ? (clen > 0xFFFFFF ? 4 : 3) : 2) : 1;
            b = new byte[2 + llen + this.extVal.length];
            b[0] = 4;
            b[1] = (byte)(llen | 0x80);
            System.arraycopy(lb, 4 - llen, b, 2, llen);
            System.arraycopy(this.extVal, 0, b, 2 + llen, this.extVal.length);
        }
        this.extVal = b;
        this.modified = false;
    }

    protected void decodeExtValue0() throws ASN1Exception {
        byte[] o = this.extVal;
        if ((o[1] & 0x80) == 0) {
            this.extVal = new byte[o[1] & 0x7F];
            System.arraycopy(o, 2, this.extVal, 0, this.extVal.length);
        } else {
            int ll = o[1] & 0x7F;
            this.extVal = new byte[o.length - ll - 1 - 1];
            System.arraycopy(o, 2 + ll, this.extVal, 0, this.extVal.length);
        }
        this.decodeExtValue();
        this.extVal = o;
        this.modified = false;
    }

    protected void encodeExtValue() throws ASN1Exception {
    }

    protected void decodeExtValue() throws ASN1Exception {
    }

    protected boolean shouldOmitted() {
        return false;
    }

    protected void indent(StringBuffer buf, int i) {
        for (int j = 0; j < i; ++j) {
            buf.append("    ");
        }
    }

    public void toString(StringBuffer buf, int n) {
        this.indent(buf, n);
        buf.append("X509v3 ");
        buf.append(this.extId.get());
        buf.append(':');
        if (this.critical) {
            buf.append(" critical");
        }
        buf.append("\n");
        if (this.extVal == null) {
            this.indent(buf, n + 1);
            buf.append("<null>\n");
        } else {
            int valPos = (this.extVal[1] & 0x80) == 0 ? 2 : (this.extVal[1] & 0x7F) + 2;
            int tag = this.extVal[valPos] & 0xFF;
            int valLen = this.extVal.length - valPos;
            String strVal = null;
            if (ASN1StringFactory.isString(tag)) {
                try {
                    DERDecoder dec = new DERDecoder(this.extVal, valPos, valLen);
                    strVal = ASN1Any.decodeAsString(dec);
                    this.indent(buf, n + 1);
                }
                catch (ASN1Exception ex) {
                    strVal = Hex.prettyDump(this.extVal, 48, ' ', n + 1);
                }
            } else {
                strVal = Hex.prettyDump(this.extVal, 48, ' ', n + 1);
            }
            buf.append(strVal);
            buf.append('\n');
        }
    }

    public final String toString(int n) {
        StringBuffer buf = new StringBuffer(80);
        this.toString(buf, n);
        return new String(buf);
    }

    public final String toString() {
        return this.toString(0);
    }
}

