/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.OIDDictionary;
import com.initech.asn1.useful.ASN1Object;
import com.initech.asn1.useful.Extension;
import com.initech.asn1.useful.ExtensionBuilder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class Extensions
extends ASN1Object {
    private static final long serialVersionUID = 5994198829176236496L;
    private Vector extensions = new Vector(8);
    private ExtensionBuilder builder;

    public Extensions() {
    }

    public Extensions(ExtensionBuilder b) {
        this.builder = b;
    }

    public Set getCriticalOIDs() {
        HashSet<String> retval = new HashSet<String>();
        Enumeration e = this.extensions.elements();
        while (e.hasMoreElements()) {
            Extension extn = (Extension)e.nextElement();
            if (!extn.isCritical()) continue;
            retval.add(extn.getExtOID());
        }
        return retval;
    }

    public Set getNonCriticalOIDs() {
        HashSet<String> retval = new HashSet<String>();
        Enumeration e = this.extensions.elements();
        while (e.hasMoreElements()) {
            Extension extn = (Extension)e.nextElement();
            if (extn.isCritical()) continue;
            retval.add(extn.getExtOID());
        }
        return retval;
    }

    public void forceAdd(Extension ext) {
        this.modified = true;
        this.extensions.addElement(ext);
    }

    public void add(Extension ext) {
        this.modified = true;
        String oid = ext.getExtOID();
        for (int i = 0; i < this.extensions.size(); ++i) {
            Extension extn = (Extension)this.extensions.elementAt(i);
            if (!oid.equals(extn.getExtOID())) continue;
            this.extensions.setElementAt(ext, i);
            return;
        }
        this.extensions.addElement(ext);
    }

    public void remove(String oid) {
        String id = oid;
        if (!ASN1OID.isOID(id) && (id = OIDDictionary.getOIDbyName(oid)) == null) {
            return;
        }
        for (int i = 0; i < this.extensions.size(); ++i) {
            Extension extn = (Extension)this.extensions.elementAt(i);
            if (!id.equals(extn.getExtOID())) continue;
            this.extensions.removeElementAt(i);
            break;
        }
        this.modified = true;
    }

    public void clear() {
        this.extensions.removeAllElements();
        this.modified = true;
    }

    public int size() {
        return this.extensions.size();
    }

    public Enumeration elements() {
        return this.extensions.elements();
    }

    public Extension elementAt(int i) {
        if (i < 0 || i >= this.extensions.size()) {
            return null;
        }
        return (Extension)this.extensions.elementAt(i);
    }

    public Extension getExtension(ASN1OID oid) {
        Enumeration e = this.extensions.elements();
        while (e.hasMoreElements()) {
            Extension extn = (Extension)e.nextElement();
            if (!oid.equals(extn.getExtOID())) continue;
            return extn;
        }
        return null;
    }

    public Extension getExtension(String oid) {
        return this.getExtension(new ASN1OID(oid));
    }

    public byte[] getExtensionValue(ASN1OID oid) {
        Extension extn = this.getExtension(oid);
        if (extn != null) {
            return extn.getExtValue();
        }
        return null;
    }

    public byte[] getExtensionValue(String oid) {
        Extension extn = this.getExtension(oid);
        if (extn != null) {
            return extn.getExtValue();
        }
        return null;
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.extensions.removeAllElements();
        int id = dec.decodeSequenceOf();
        while (!dec.endOf(id)) {
            Extension ext = new Extension();
            ext.decode(dec);
            if (this.builder != null) {
                ext = this.builder.build(ext);
            }
            this.extensions.addElement(ext);
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequenceOf();
        Enumeration e = this.extensions.elements();
        while (e.hasMoreElements()) {
            Extension extn = (Extension)e.nextElement();
            enc.encodeAny(extn.getEncoded());
        }
        enc.endOf(id);
    }
}

