/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.useful.AnotherName;
import com.initech.asn1.useful.DNSName;
import com.initech.asn1.useful.EDIPartyName;
import com.initech.asn1.useful.GeneralNameInterface;
import com.initech.asn1.useful.IPAddressName;
import com.initech.asn1.useful.Name;
import com.initech.asn1.useful.OIDName;
import com.initech.asn1.useful.RFC822Name;
import com.initech.asn1.useful.URIName;
import com.initech.asn1.useful.X400Address;
import java.net.InetAddress;
import java.net.URL;

public class GeneralName
implements ASN1Type {
    private static final long serialVersionUID = -9119953320471900923L;
    GeneralNameInterface name;
    private static final byte[] NULL_DN = new byte[]{-92, 2, 48, 0};
    public static final int NullDN = -1;
    public static final int otherName = 0;
    public static final int rfc822Name = 1;
    public static final int dNSName = 2;
    public static final int x400Address = 3;
    public static final int directoryName = 4;
    public static final int ediPartyName = 5;
    public static final int URI = 6;
    public static final int IP = 7;
    public static final int RID = 8;
    private static final int[] taglist = new int[]{160, 129, 130, 163, 164, 165, 134, 135, 136};

    public GeneralName() {
    }

    public GeneralName(GeneralNameInterface gni) {
        this.set(gni);
    }

    public GeneralName(String name) {
        this.setFromString(name);
    }

    public void setNull() {
        this.name = null;
    }

    public boolean isNullName() {
        return this.name == null;
    }

    public int getType() {
        return this.name != null ? this.name.getType() : -1;
    }

    public GeneralNameInterface getGeneralNameInterface() {
        return this.name;
    }

    public void set(GeneralNameInterface gni) {
        this.name = gni;
    }

    public void set(ASN1OID id) {
        this.name = new OIDName(id);
    }

    public void set(InetAddress addr) {
        this.name = new IPAddressName(addr);
    }

    public void set(URL url) {
        this.name = new URIName(url.toString());
    }

    public void set(int type, String val) throws IllegalArgumentException {
        switch (type) {
            case 4: {
                this.name = new Name(val);
                break;
            }
            case 1: {
                this.name = new RFC822Name(val);
                break;
            }
            case 2: {
                this.name = new DNSName(val);
                break;
            }
            case 7: {
                this.name = new IPAddressName(val);
                break;
            }
            case 6: {
                this.name = new URIName(val);
                break;
            }
            case 8: {
                this.name = new OIDName(val);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public int hashCode() {
        if (this.name == null) {
            return 0;
        }
        return this.name.hashCode();
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int tag = dec.decodeChoice(taglist);
        if (tag == taglist[0]) {
            dec.nextIsImplicit(tag);
            this.name = new AnotherName(dec);
        } else if (tag == taglist[1]) {
            dec.nextIsImplicit(tag);
            this.name = new RFC822Name(dec);
        } else if (tag == taglist[2]) {
            dec.nextIsImplicit(tag);
            this.name = new DNSName(dec);
        } else if (tag == taglist[3]) {
            dec.nextIsImplicit(tag);
            this.name = new X400Address(dec);
        } else if (tag == taglist[4]) {
            Name dirName = new Name();
            int id = dec.decodeExplicit(taglist[4]);
            dirName.decode(dec);
            dec.endOf(id);
            this.name = dirName;
            if (dirName.isNullDN()) {
                this.name = null;
            }
        } else if (tag == taglist[5]) {
            dec.nextIsImplicit(tag);
            this.name = new EDIPartyName(dec);
        } else if (tag == taglist[6]) {
            dec.nextIsImplicit(tag);
            this.name = new URIName(dec);
        } else if (tag == taglist[7]) {
            dec.nextIsImplicit(tag);
            this.name = new IPAddressName(dec);
        } else if (tag == taglist[8]) {
            dec.nextIsImplicit(tag);
            this.name = new OIDName(dec);
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        if (this.name == null) {
            enc.encodeAny(NULL_DN);
        } else if (this.name.getType() == 4) {
            int id = enc.encodeExplicit(taglist[4]);
            this.name.encode(enc);
            enc.endOf(id);
        } else {
            enc.nextIsImplicit(taglist[this.name.getType()]);
            this.name.encode(enc);
        }
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        boolean ret = false;
        if (another instanceof GeneralName) {
            GeneralName o = (GeneralName)another;
            if (this.name == null) {
                return o.name == null;
            }
            if (o.name == null) {
                return false;
            }
            try {
                ret = this.name.constrains(o.name) == 0;
            }
            catch (UnsupportedOperationException ex) {
                ret = false;
            }
        } else if (another instanceof GeneralNameInterface) {
            GeneralNameInterface o = (GeneralNameInterface)another;
            if (this.name == null) {
                return o == null;
            }
            if (o == null) {
                return false;
            }
            try {
                ret = this.name.constrains(o) == 0;
            }
            catch (UnsupportedOperationException ex) {
                ret = false;
            }
        } else {
            ret = false;
        }
        return ret;
    }

    public void setFromString(String raw) throws IllegalArgumentException {
        String value = null;
        if ((raw = raw.trim()).length() == 0) {
            throw new IllegalArgumentException("Zero length string");
        }
        if (raw.startsWith("MAIL:")) {
            value = raw.substring(raw.indexOf("MAIL:") + 5);
            value = value.trim();
            this.name = new RFC822Name(value);
        } else if (raw.startsWith("URI:")) {
            value = raw.substring(raw.indexOf("URI:") + 4);
            value = value.trim();
            this.name = new URIName(value);
        } else if (raw.startsWith("DN:")) {
            value = raw.substring(raw.indexOf("DN:") + 3);
            value = value.trim();
            this.name = new Name(value);
        } else if (raw.startsWith("IP:")) {
            value = raw.substring(raw.indexOf("IP:") + 3);
            value = value.trim();
            this.name = new IPAddressName(value);
        } else if (raw.startsWith("DNS:")) {
            value = raw.substring(raw.indexOf("DNS:") + 4);
            value = value.trim();
            this.name = new DNSName(value);
        } else if (raw.startsWith("RID:")) {
            value = raw.substring(raw.indexOf("RID:") + 4);
            value = value.trim();
            this.name = new OIDName(value);
        } else {
            throw new IllegalArgumentException("Unsupported GeneralName type & value : " + raw);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean can, boolean withType) {
        String ret = null;
        ret = this.name == null ? "<NULL NAME>" : this.name.toString(can, withType);
        return ret;
    }

    public String toString(boolean can) {
        return this.toString(can, false);
    }
}

