/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.useful.GeneralName;
import com.initech.asn1.useful.GeneralNameInterface;
import com.initech.cryptox.util.StringUtil;
import java.util.Enumeration;
import java.util.Vector;

public class GeneralNames
implements ASN1Type {
    private static final long serialVersionUID = 8554909483829749932L;
    Vector names = new Vector();

    public int size() {
        return this.names.size();
    }

    public Enumeration elements() {
        return this.names.elements();
    }

    public GeneralName elementAt(int i) {
        if (i < 0 || i >= this.names.size()) {
            return null;
        }
        return (GeneralName)this.names.elementAt(i);
    }

    public void clear() {
        this.names.removeAllElements();
    }

    public void add(GeneralName name) {
        if (!this.names.contains(name)) {
            this.names.addElement(name);
        }
    }

    public boolean contains(GeneralName name) {
        return this.names.contains(name);
    }

    public boolean contains(GeneralNameInterface gni) {
        return this.names.contains(gni);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.names.removeAllElements();
        int id = dec.decodeSequenceOf();
        while (!dec.endOf(id)) {
            GeneralName name = new GeneralName();
            name.decode(dec);
            this.names.addElement(name);
        }
        dec.endOf(id);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        if (this.names.size() == 0) {
            return;
        }
        int id = enc.encodeSequenceOf();
        for (int i = 0; i < this.names.size(); ++i) {
            GeneralName name = (GeneralName)this.names.elementAt(i);
            name.encode(enc);
        }
        enc.endOf(id);
    }

    public void toString(StringBuffer buf, int n, boolean withType) {
        for (int i = 0; i < this.names.size(); ++i) {
            GeneralName name = (GeneralName)this.names.elementAt(i);
            StringUtil.indent(buf, n);
            buf.append(name.toString(false, withType));
            buf.append('\n');
        }
    }

    public void toString(StringBuffer buf, int n) {
        this.toString(buf, n, false);
    }

    public String toString(int n) {
        StringBuffer buf = new StringBuffer(40 * this.names.size());
        this.toString(buf, n);
        return new String(buf);
    }

    public String toString() {
        return this.toString(0);
    }
}

