/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1BitString;
import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.provider.crypto.random.HashDRBG;

public class HashContent
implements ASN1Type {
    private static final long serialVersionUID = 8442482668932214116L;
    private String idn;
    private ASN1BitString random;
    private static int RANDOM_SIZE = 20;

    public HashContent() {
        byte[] abyte0 = new byte[RANDOM_SIZE];
        try {
            HashDRBG random1 = new HashDRBG("SHA224");
            random1.nextBytes(abyte0);
        }
        catch (Exception e) {
            throw new RuntimeException("fail to generate salt");
        }
        this.random = new ASN1BitString();
        this.random.setByteArray(abyte0);
    }

    public HashContent(String s) {
        this();
        this.setIdn(s);
    }

    public HashContent(byte[] abyte0) throws ASN1Exception {
        DERDecoder derdecoder = new DERDecoder(abyte0);
        this.decode(derdecoder);
    }

    public void decode(ASN1Decoder asn1decoder) throws ASN1Exception {
        int i = asn1decoder.decodeSequence();
        this.idn = asn1decoder.decodePrintableString();
        this.random = asn1decoder.decodeBitString();
        asn1decoder.endOf(i);
    }

    public void encode(ASN1Encoder asn1encoder) throws ASN1Exception {
        int i = asn1encoder.encodeSequence();
        asn1encoder.encodePrintableString(this.idn);
        asn1encoder.encodeBitString(this.random);
        asn1encoder.endOf(i);
    }

    public byte[] getEncoded() throws ASN1Exception {
        DEREncoder derencoder = new DEREncoder();
        this.encode(derencoder);
        return derencoder.toByteArray();
    }

    public String getIdn() {
        return this.idn;
    }

    public byte[] getRandom() {
        return this.random.getAsByteArray();
    }

    public void setIdn(String s) {
        this.idn = s;
    }
}

