/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.useful.GeneralNameInterface;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.StringTokenizer;

public class IPAddressName
implements GeneralNameInterface {
    private static final long serialVersionUID = -5268242452171833944L;
    private byte[] address;
    static final byte[] BITMASK = new byte[]{0, -128, -64, -32, -16, -8, -4, -2};

    IPAddressName(ASN1Decoder dec) throws ASN1Exception {
        this.decode(dec);
    }

    public IPAddressName(String s) throws IllegalArgumentException {
        this.parseName(s);
    }

    public IPAddressName(InetAddress a) {
        this.address = a.getAddress();
    }

    public IPAddressName(byte[] d) throws IllegalArgumentException {
        if (d != null && d.length != 4 && d.length != 8 && d.length != 16 && d.length != 32) {
            throw new IllegalArgumentException("Invalid IP address bytes");
        }
        this.address = d;
    }

    public void parseName(String s) throws IllegalArgumentException {
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("IP address name must not be null");
        }
        if (s.indexOf(58) >= 0) {
            int j = s.indexOf(47);
            if (j < 0) {
                this.address = IPAddressName.getIPv6Address(s);
            } else {
                this.address = new byte[32];
                byte[] ip = IPAddressName.getIPv6Address(s.substring(0, j));
                String bits = s.substring(j + 1);
                int bitLen = Integer.parseInt(bits, 10);
                if (bitLen < 0 || bitLen > 128) {
                    throw new IllegalArgumentException("Invalid IPAddressName " + s);
                }
                System.arraycopy(ip, 0, this.address, 0, 16);
                int byteIdx = bitLen / 8 + 16;
                int bitIdx = bitLen % 8;
                for (int i = 16; i < byteIdx; ++i) {
                    this.address[i] = -1;
                }
                this.address[byteIdx] = BITMASK[bitIdx];
            }
        } else if (s.indexOf(46) >= 0) {
            int j = s.indexOf(47);
            if (j < 0) {
                this.address = IPAddressName.getIPv4Address(s);
            } else {
                this.address = new byte[8];
                byte[] ip = IPAddressName.getIPv4Address(s.substring(0, j));
                byte[] mask = IPAddressName.getIPv4Address(s.substring(j + 1));
                if (ip == null || mask == null) {
                    throw new IllegalArgumentException("Invalid IPAddressName " + s);
                }
                System.arraycopy(ip, 0, this.address, 0, 4);
                System.arraycopy(mask, 0, this.address, 4, 4);
            }
        } else {
            throw new IllegalArgumentException("Invalid IPAddressName " + s);
        }
    }

    private static byte[] getIPv4Address(String s) throws IllegalArgumentException {
        StringTokenizer stk = new StringTokenizer(s, ".");
        int n = stk.countTokens();
        if (n != 4) {
            throw new IllegalArgumentException("Invalid IPv4 address : " + s);
        }
        byte[] ret = new byte[4];
        for (int i = 0; i < 4; ++i) {
            String tk = stk.nextToken();
            try {
                ret[i] = (byte)Integer.parseInt(tk, 10);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Invalid IPv4 address : " + s);
            }
        }
        return ret;
    }

    private static int getIPv6Frag(byte[] addr, int off, String s) throws IllegalArgumentException {
        int bytes = 0;
        int i = 0;
        int bIdx = off;
        while (i < s.length()) {
            int j = s.indexOf(58, i);
            String frag = j < 0 ? s.substring(i) : s.substring(i, j);
            int k = Integer.parseInt(frag, 16);
            if (k > 65535) {
                throw new IllegalArgumentException("Invalid IPv6 address : " + s);
            }
            addr[bIdx++] = (byte)(k >>> 8);
            addr[bIdx++] = (byte)(k & 0xFF);
            bytes += 2;
        }
        return bytes;
    }

    private static byte[] getIPv6Address(String s) throws IllegalArgumentException {
        byte[] addr = new byte[16];
        boolean compressed = false;
        int l_s = 0;
        int l_e = s.indexOf("::");
        if (l_e < 0) {
            if (IPAddressName.getIPv6Frag(addr, 0, s) != 16) {
                throw new IllegalArgumentException("Invalid IPv6 address : " + s);
            }
        } else {
            int r_s = l_e + 2;
            if (s.indexOf("::", r_s) >= 0) {
                throw new IllegalArgumentException("Invalid IPv6 address : " + s);
            }
            String left = s.substring(l_s, l_e);
            int len = IPAddressName.getIPv6Frag(addr, 0, left);
            byte[] rightBytes = new byte[16 - len];
            String right = s.substring(r_s);
            if ((len = IPAddressName.getIPv6Frag(rightBytes, 0, right)) > 0) {
                System.arraycopy(rightBytes, 0, addr, 16 - len, len);
            }
        }
        return addr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IPAddressName)) {
            return false;
        }
        IPAddressName other = (IPAddressName)o;
        byte[] oip = other.getBytes();
        if (oip == null && this.address == null) {
            return true;
        }
        if (this.address.length != oip.length) {
            return false;
        }
        if (this.address.length == 8 || this.address.length == 32) {
            int l = this.address.length / 2;
            byte[] thisAddr = new byte[l];
            byte[] thatAddr = new byte[l];
            for (int j = 0; j < l; ++j) {
                thisAddr[j] = (byte)(this.address[j] & this.address[j + l]);
                thatAddr[j] = (byte)(oip[j] & oip[j + l]);
                if (thisAddr[j] == thatAddr[j]) continue;
                return false;
            }
            for (int k = l; k < this.address.length; ++k) {
                if (this.address[k] == oip[k]) continue;
                return false;
            }
            return true;
        }
        return Arrays.equals(this.address, oip);
    }

    public int getType() {
        return 7;
    }

    public byte[] getBytes() {
        return this.address;
    }

    public String getName() {
        String s = "";
        if (this.address == null) {
            s = "<root ip address space>";
        } else if (this.address.length == 4 || this.address.length == 8) {
            s = (this.address[0] & 0xFF) + "." + (this.address[1] & 0xFF) + "." + (this.address[2] & 0xFF) + "." + (this.address[3] & 0xFF);
            if (this.address.length == 8) {
                s = s + "/" + (this.address[4] & 0xFF) + "." + (this.address[5] & 0xFF) + (this.address[6] & 0xFF) + "." + (this.address[7] & 0xFF);
            }
        } else if (this.address.length == 16 || this.address.length == 32) {
            int i = this.address.length;
            for (int j = 0; j < 8; ++j) {
                int k = ((this.address[j * 2] & 0xFF) << 8) + (this.address[j * 2 + 1] & 0xFF);
                String octs = Integer.toHexString(k);
                if (octs.length() > 4) {
                    octs = octs.substring(octs.length() - 4, octs.length());
                }
                String delim = j == 7 ? (i == 16 ? "" : "/") : ":";
                s = s + octs + delim;
            }
            if (i == 32) {
                int bits = 0;
                block1: for (int j = 16; j < 32; ++j) {
                    if (this.address[j] == -1) {
                        bits += 8;
                        continue;
                    }
                    for (int k = 0; k < 8; ++k) {
                        if (this.address[j] != BITMASK[k]) continue;
                        bits += k;
                        break block1;
                    }
                    break;
                }
                s = s + bits;
            }
        } else {
            throw new IllegalArgumentException("Invalid length " + this.address.length);
        }
        return s;
    }

    public int hashCode() {
        int i = 0;
        for (int j = 0; j < this.address.length; ++j) {
            i += this.address[j] * j;
        }
        return i;
    }

    public int constrains(GeneralNameInterface gni) throws UnsupportedOperationException {
        int ret = -1;
        if (gni == null) {
            ret = -1;
        } else if (gni.getType() != 7) {
            ret = -1;
        } else if (this.equals((IPAddressName)gni)) {
            ret = 0;
        } else {
            byte[] oip = ((IPAddressName)gni).getBytes();
            if (oip == null) {
                ret = 1;
            } else if (this.address == null) {
                ret = 2;
            } else if (oip.length == 4 && this.address.length == 4) {
                ret = 3;
            } else if (oip.length == 8 && this.address.length == 8 || oip.length == 32 && this.address.length == 32) {
                boolean f1 = true;
                boolean f2 = true;
                boolean f3 = false;
                boolean f4 = false;
                int l = this.address.length / 2;
                for (int j = 0; j < l; ++j) {
                    byte AM = this.address[l + j];
                    byte OM = oip[l + j];
                    byte AA_AM = (byte)(this.address[j] & AM);
                    byte AA_OM = (byte)(this.address[j] & OM);
                    byte OA_AM = (byte)(oip[j] & AM);
                    byte OA_OM = (byte)(oip[j] & OM);
                    byte AM_OM = (byte)(AM & OM);
                    if (AA_AM != this.address[j]) {
                        f3 = true;
                    }
                    if (OA_OM != oip[j]) {
                        f4 = true;
                    }
                    if (AM_OM != AM || AA_AM != OA_AM) {
                        f1 = false;
                    }
                    if (AM_OM == OM && OA_OM == AA_OM) continue;
                    f2 = false;
                }
                ret = f3 || f4 ? (f3 && f4 ? 0 : (f3 ? 2 : 1)) : (f1 ? 1 : (f2 ? 2 : 3));
            } else if (oip.length == 8 || oip.length == 32) {
                int i;
                int l = oip.length / 2;
                for (i = 0; i < l && (this.address[i] & oip[l + i]) == oip[i]; ++i) {
                }
                ret = i == l ? 2 : 3;
            } else if (this.address.length == 8 || this.address.length == 32) {
                int i;
                int l = this.address.length / 2;
                for (i = 0; i < l && (oip[i] & this.address[l + i]) == this.address[i]; ++i) {
                }
                ret = i == l ? 1 : 3;
            } else {
                ret = 3;
            }
        }
        return ret;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not defined for IPAddressName");
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean can) {
        return this.toString(can, false);
    }

    public String toString(boolean can, boolean withType) {
        String ret = this.getName();
        if (withType) {
            ret = "IP: " + ret;
        }
        return ret;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.encodeOctetString(this.address);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.address = dec.decodeOctetString();
        if (this.address.length != 4 && this.address.length != 8 && this.address.length != 16 && this.address.length != 32) {
            throw new IllegalArgumentException("Invalid IP address bytes");
        }
    }
}

