/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.Name;
import com.initech.x509.X509CertImpl;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;

public class IssuerAndSerialNumber
implements ASN1Type {
    private static final long serialVersionUID = -5480828556331208944L;
    private Name name = new Name();
    private BigInteger certificateSerialNumber = new BigInteger("0");
    private int hash;

    public IssuerAndSerialNumber() {
        this.updateHashCode();
    }

    public void set(String name, BigInteger serialNumber) {
        this.name.set(name);
        this.certificateSerialNumber = serialNumber;
        this.updateHashCode();
    }

    public void set(Name name, BigInteger serialNumber) {
        this.name = name;
        this.certificateSerialNumber = serialNumber;
        this.updateHashCode();
    }

    public void set(String name, X509Certificate cert) {
        this.name.set(name);
        this.certificateSerialNumber = cert.getSerialNumber();
        this.updateHashCode();
    }

    public void set(Name name, X509Certificate cert) {
        this.name = name;
        this.certificateSerialNumber = cert.getSerialNumber();
        this.updateHashCode();
    }

    public void set(X509Certificate cert) {
        if (cert instanceof X509CertImpl) {
            this.set((Name)cert.getIssuerDN(), cert);
        } else {
            this.set(((Object)cert.getIssuerDN()).toString(), cert);
        }
    }

    public BigInteger getSerialNumber() {
        return this.certificateSerialNumber;
    }

    public Name getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IssuerAndSerialNumber)) {
            return false;
        }
        IssuerAndSerialNumber iasn = (IssuerAndSerialNumber)o;
        return iasn.name.equals(this.name) && this.certificateSerialNumber.equals(iasn.certificateSerialNumber);
    }

    public int hashCode() {
        return this.hash;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequence();
        this.name.encode(enc);
        enc.encodeInteger(this.certificateSerialNumber);
        enc.endOf(id);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id = dec.decodeSequence();
        this.name.decode(dec);
        this.certificateSerialNumber = dec.decodeInteger();
        dec.endOf(id);
        this.updateHashCode();
    }

    private void updateHashCode() {
        try {
            DEREncoder enc = new DEREncoder();
            this.encode(enc);
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] aa = md.digest(enc.toByteArray());
            this.hash = aa[0] << 24 & 0xFF000000 | aa[1] << 16 & 0xFF0000 | aa[2] << 8 & 0xFF00 | aa[3] << 0 & 0xFF;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

