/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.OIDDictionary;
import com.initech.asn1.useful.AVA;
import com.initech.asn1.useful.GeneralName;
import com.initech.asn1.useful.GeneralNameInterface;
import com.initech.asn1.useful.RDN;
import com.initech.asn1.useful.RFC822Name;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Vector;

public class Name
implements ASN1Type,
Principal,
Cloneable,
GeneralNameInterface {
    private static final long serialVersionUID = 6119432067588009521L;
    public static final String RFC1779 = "RFC1779";
    public static final String RFC2253 = "RFC2253";
    public static final String CANONICAL = "CANONICAL";
    public static final ASN1OID CN = new ASN1OID("2.5.4.3");
    public static final ASN1OID SURNAME = new ASN1OID("2.5.4.4");
    public static final ASN1OID SERIAL = new ASN1OID("2.5.4.5");
    public static final ASN1OID C = new ASN1OID("2.5.4.6");
    public static final ASN1OID L = new ASN1OID("2.5.4.7");
    public static final ASN1OID ST = new ASN1OID("2.5.4.8");
    public static final ASN1OID STREET = new ASN1OID("2.5.4.9");
    public static final ASN1OID O = new ASN1OID("2.5.4.10");
    public static final ASN1OID OU = new ASN1OID("2.5.4.11");
    public static final ASN1OID T = new ASN1OID("2.5.4.12");
    public static final ASN1OID GIVENNAME = new ASN1OID("2.5.4.42");
    public static final ASN1OID INITIALS = new ASN1OID("2.5.4.43");
    public static final ASN1OID GENERATION = new ASN1OID("2.5.4.44");
    public static final ASN1OID DNQ = new ASN1OID("2.5.4.46");
    public static final ASN1OID EMAIL = new ASN1OID("1.2.840.113549.1.9.1");
    public static final ASN1OID UID = new ASN1OID("0.9.2342.19200300.100.1.1");
    public static final ASN1OID MAIL = new ASN1OID("0.9.2342.19200300.100.1.3");
    public static final ASN1OID DC = new ASN1OID("0.9.2342.19200300.100.1.25");
    public static final String WHOLE_TO_UTF8 = "WHOLE_TO_UTF8";
    public static final String DIRECTORY_STRING_TO_UTF8 = "DIRECTORY_STRING_TO_UTF8";
    Vector rdns = new Vector(8);
    boolean dnMod;
    String dn;
    boolean rfc1779Mod;
    String rfc1779dn;
    boolean rfc2253Mod;
    String rfc2253dn;
    boolean cannMod;
    String cannon;

    public Name() {
    }

    Name(ASN1Decoder dec) throws ASN1Exception {
        this.decode(dec);
    }

    public Name(String dn) throws IllegalArgumentException {
        this.set(dn);
    }

    public Name(byte[] data) throws ASN1Exception {
        DERDecoder dec = new DERDecoder(data);
        this.decode(dec);
    }

    public Object clone() {
        Name ret = new Name();
        for (int i = 0; i < this.rdns.size(); ++i) {
            RDN r = (RDN)this.rdns.elementAt(i);
            ret.add((RDN)r.clone());
        }
        return ret;
    }

    private void invalidate() {
        this.dnMod = true;
        this.rfc1779Mod = true;
        this.rfc2253Mod = true;
        this.cannMod = true;
    }

    public void setEncodingRule(String rule) {
        for (int i = 0; i < this.rdns.size(); ++i) {
            RDN r = (RDN)this.rdns.elementAt(i);
            r.setEncodingRule(rule);
        }
        this.invalidate();
    }

    public Name getParent() {
        Name ret = new Name();
        if (this.rdns.size() == 1) {
            return null;
        }
        for (int i = 0; i < this.rdns.size() - 1; ++i) {
            RDN r = (RDN)this.rdns.elementAt(i);
            ret.add((RDN)r.clone());
        }
        return ret;
    }

    public Name getPrefix(int pos) throws ArrayIndexOutOfBoundsException {
        if (pos < 0 || pos > this.rdns.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Name ret = new Name();
        for (int i = 0; i < pos; ++i) {
            RDN r = (RDN)this.rdns.elementAt(i);
            ret.add((RDN)r.clone());
        }
        return ret;
    }

    public Name getSuffix(int pos) throws ArrayIndexOutOfBoundsException {
        if (pos < 0 || pos > this.rdns.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Name ret = new Name();
        for (int i = pos; i < this.rdns.size(); ++i) {
            RDN r = (RDN)this.rdns.elementAt(i);
            ret.add((RDN)r.clone());
        }
        return ret;
    }

    public boolean isNullDN() {
        return this.rdns.size() <= 0;
    }

    public void clear() {
        this.rdns.removeAllElements();
    }

    public Enumeration elements() {
        return this.rdns.elements();
    }

    public int size() {
        return this.rdns.size();
    }

    public void add(RDN r) {
        this.rdns.addElement(r);
        this.invalidate();
    }

    public byte[] getEncoded() {
        byte[] ret = null;
        try {
            DEREncoder enc = new DEREncoder();
            this.encode(enc);
            ret = enc.toByteArray();
        }
        catch (ASN1Exception ex) {
            ret = null;
        }
        return ret;
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.rdns.removeAllElements();
        int id = dec.decodeSequenceOf();
        while (!dec.endOf(id)) {
            RDN rdn = new RDN();
            rdn.decode(dec);
            this.rdns.addElement(rdn);
        }
        this.invalidate();
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequenceOf();
        Enumeration e = this.rdns.elements();
        while (e.hasMoreElements()) {
            RDN rdn = (RDN)e.nextElement();
            rdn.encode(enc);
        }
        enc.endOf(id);
    }

    public String getName() {
        return this.toString();
    }

    public String getRFC2253Name() {
        if (!this.rfc2253Mod && this.rfc2253dn != null) {
            return this.rfc2253dn;
        }
        if (this.rdns.size() == 0) {
            this.rfc2253dn = "";
            return this.rfc2253dn;
        }
        StringBuffer buf = new StringBuffer(80);
        for (int i = this.rdns.size() - 1; i >= 0; --i) {
            RDN rdn = (RDN)this.rdns.elementAt(i);
            buf.append(rdn.toRFC2253String());
            if (i <= 0) continue;
            buf.append(',');
        }
        this.rfc2253dn = new String(buf);
        this.rfc2253Mod = false;
        return this.rfc2253dn;
    }

    public String getRFC2253CanonicalName() {
        if (!this.cannMod && this.cannon != null) {
            return this.cannon;
        }
        if (this.rdns.size() == 0) {
            this.cannon = "";
            return this.cannon;
        }
        StringBuffer buf = new StringBuffer(80);
        for (int i = this.rdns.size() - 1; i >= 0; --i) {
            RDN rdn = (RDN)this.rdns.elementAt(i);
            buf.append(rdn.toRFC2253String());
            if (i <= 0) continue;
            buf.append(',');
        }
        this.cannon = new String(buf);
        this.cannMod = false;
        return this.cannon;
    }

    public String getRFC1779Name() {
        if (!this.rfc1779Mod && this.rfc1779dn != null) {
            return this.rfc1779dn;
        }
        if (this.rdns.size() == 0) {
            this.rfc1779dn = "";
            return this.rfc1779dn;
        }
        StringBuffer buf = new StringBuffer(80);
        for (int i = this.rdns.size() - 1; i >= 0; --i) {
            RDN rdn = (RDN)this.rdns.elementAt(i);
            buf.append(rdn.toRFC1779String());
            if (i <= 0) continue;
            buf.append(',');
        }
        this.rfc1779dn = new String(buf);
        this.rfc1779Mod = false;
        return this.rfc1779dn;
    }

    public String toString() {
        if (!this.dnMod && this.dn != null) {
            return this.dn;
        }
        if (this.rdns.size() == 0) {
            this.dn = "";
            return this.dn;
        }
        StringBuffer buf = new StringBuffer(80);
        for (int i = this.rdns.size() - 1; i >= 0; --i) {
            RDN rdn = (RDN)this.rdns.elementAt(i);
            buf.append(rdn.toString());
            if (i <= 0) continue;
            buf.append(',');
        }
        this.dn = new String(buf);
        this.dnMod = false;
        return this.dn;
    }

    public boolean equals(Object another) {
        if (another instanceof Name) {
            return this.equals((Name)another);
        }
        if (another instanceof String) {
            try {
                Name n = new Name((String)another);
                return this.equals(n);
            }
            catch (Exception ignore) {
                return false;
            }
        }
        if (another instanceof Principal) {
            try {
                Name n = new Name(((Object)((Principal)another)).toString());
                return this.equals(n);
            }
            catch (Exception ignore) {
                return false;
            }
        }
        if (another instanceof GeneralName) {
            GeneralName gn = (GeneralName)another;
            if (gn.getType() != 4) {
                return false;
            }
            return this.equals((Name)gn.getGeneralNameInterface());
        }
        return false;
    }

    public synchronized boolean equals(Name name) {
        if (this == name) {
            return true;
        }
        if (name == null) {
            return false;
        }
        if (this.rdns.size() == 0) {
            return name.isNullDN();
        }
        if (this.rdns.size() != name.size()) {
            return false;
        }
        for (int i = 0; i < this.rdns.size(); ++i) {
            RDN rdn = (RDN)this.rdns.elementAt(i);
            if (rdn.equals(name.get(i))) continue;
            return false;
        }
        return true;
    }

    public void set(String name) throws IllegalArgumentException {
        boolean inQuote = false;
        Vector<RDN> vec = new Vector<RDN>(8);
        String s = null;
        try {
            RDN rdn;
            int i;
            int start = 0;
            for (i = 0; i < name.length(); ++i) {
                if (name.charAt(i) == '\\') {
                    ++i;
                    continue;
                }
                if (name.charAt(i) == '\"') {
                    inQuote = !inQuote;
                    continue;
                }
                if (name.charAt(i) != ',' && name.charAt(i) != ';' || inQuote) continue;
                s = name.substring(start, i).trim();
                if (s.length() == 0) {
                    throw new IOException("There's empty RDN in \"" + name + "\"");
                }
                rdn = new RDN(s);
                vec.addElement(rdn);
                start = i + 1;
            }
            if (start < name.length()) {
                s = name.substring(start).trim();
                if (s.length() == 0) {
                    throw new IOException("There's empty RDN in \"" + name + "\"");
                }
                rdn = new RDN(s);
                vec.addElement(rdn);
            }
            this.rdns = new Vector(vec.size() + 2);
            for (i = vec.size() - 1; i >= 0; --i) {
                rdn = (RDN)vec.elementAt(i);
                this.rdns.addElement(rdn);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public RDN getLastRDN() {
        return (RDN)this.rdns.lastElement();
    }

    public RDN get(int pos) {
        return (RDN)this.rdns.elementAt(pos);
    }

    public String[] get(String type) {
        String id = type;
        Vector<String> vec = new Vector<String>(2);
        if (!ASN1OID.isOID(id)) {
            id = OIDDictionary.getOIDbyName(id);
        }
        if (id == null) {
            return null;
        }
        Enumeration e = this.rdns.elements();
        while (e.hasMoreElements()) {
            RDN rdn = (RDN)e.nextElement();
            Enumeration e2 = rdn.elements();
            while (e2.hasMoreElements()) {
                AVA av = (AVA)e2.nextElement();
                if (!id.equals(av.getType())) continue;
                vec.addElement(av.getValue());
            }
        }
        if (vec.size() == 0) {
            return new String[0];
        }
        String[] ret = new String[vec.size()];
        for (int i = vec.size() - 1; i >= 0; --i) {
            ret[i] = (String)vec.elementAt(i);
        }
        return ret;
    }

    public int hashCode() {
        String c = this.getRFC2253CanonicalName();
        return c.hashCode();
    }

    public int getType() {
        return 4;
    }

    public int constrains(GeneralNameInterface gni) throws UnsupportedOperationException {
        int ret;
        block9: {
            if (gni == null) {
                ret = -1;
            } else if (gni.getType() != 4) {
                if (gni.getType() == 1) {
                    ret = -1;
                    int i = 0;
                    String[] mails = this.get("1.2.840.113549.1.9.1");
                    if (i < mails.length) {
                        RFC822Name rfc822name;
                        try {
                            rfc822name = new RFC822Name(mails[0]);
                        }
                        catch (IllegalArgumentException ex) {
                            break block9;
                        }
                        ret = rfc822name.constrains((RFC822Name)gni);
                    }
                } else {
                    ret = -1;
                }
            } else {
                ret = ((Name)gni).equals(this) ? 0 : (((Name)gni).isWithinSubtree(this) ? 2 : (this.isWithinSubtree((Name)gni) ? 1 : 3));
            }
        }
        return ret;
    }

    private synchronized boolean isWithinSubtree(Name other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.isNullDN()) {
            return true;
        }
        if (this.isNullDN()) {
            return false;
        }
        if (this.size() < other.size()) {
            return false;
        }
        for (int i = 0; i < other.size(); ++i) {
            RDN or = other.get(i);
            RDN mr = this.get(i);
            if (mr.equals(or)) continue;
            return false;
        }
        return true;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        if (this.isNullDN()) {
            return 0;
        }
        return this.size();
    }

    public String toString(boolean can) {
        return this.toString(can, false);
    }

    public String toString(boolean can, boolean withType) {
        String ret = can ? this.getRFC2253CanonicalName() : this.toString();
        if (withType) {
            ret = "DirectoryName: " + ret;
        }
        return ret;
    }

    public Name commonAncestor(Name n) {
        int l;
        if (n == null || n.isNullDN() || this.isNullDN()) {
            return null;
        }
        int i = n.size();
        int j = this.size();
        if (i == 0 || j == 0) {
            return null;
        }
        int k = j >= i ? i : j;
        for (l = 0; l < k; ++l) {
            RDN or;
            RDN mr = this.get(l);
            if (mr.equals(or = n.get(l))) continue;
            if (l != 0) break;
            return null;
        }
        try {
            return this.getPrefix(l);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

