/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.OIDDictionary;
import com.initech.asn1.useful.GeneralNameInterface;

public class OIDName
implements GeneralNameInterface {
    private static final long serialVersionUID = -8933930835541321379L;
    ASN1OID oid;

    public OIDName() {
    }

    OIDName(ASN1Decoder dec) throws ASN1Exception {
        this.decode(dec);
    }

    public OIDName(String o) {
        this.oid = new ASN1OID(o);
    }

    public OIDName(ASN1OID o) {
        this.oid = o;
    }

    public int getType() {
        return 8;
    }

    public String getName() {
        return this.oid.get();
    }

    public ASN1OID getOID() {
        return this.oid;
    }

    public int hashCode() {
        return this.oid.get().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OIDName) {
            return this.oid.equals(((OIDName)obj).oid);
        }
        if (obj instanceof ASN1OID) {
            return this.oid.equals((ASN1OID)obj);
        }
        if (obj instanceof String) {
            if (ASN1OID.isOID((String)obj)) {
                return this.oid.equals(obj);
            }
            String n = OIDDictionary.getOIDbyName((String)obj);
            if (n == null) {
                return false;
            }
            return this.oid.equals(n);
        }
        return false;
    }

    public int constrains(GeneralNameInterface gni) throws UnsupportedOperationException {
        int ret;
        if (gni == null) {
            ret = -1;
        } else if (gni.getType() != 8) {
            ret = -1;
        } else if (this.equals((OIDName)gni)) {
            ret = 0;
        } else {
            throw new UnsupportedOperationException("Narrowing, widening and matching are not supported for OIDName");
        }
        return ret;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not defined for OIDName");
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean can) {
        return this.toString(can, false);
    }

    public String toString(boolean can, boolean withType) {
        String ret = this.oid.get();
        if (withType) {
            ret = "RID: " + ret;
        }
        return ret;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.encodeObjectIdentifier(this.oid);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.oid = dec.decodeObjectIdentifier();
    }
}

