/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1BitString;
import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.useful.ASN1Object;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.cryptox.util.Hex;
import com.initech.cryptox.util.StringUtil;
import com.initech.provider.crypto.InitechProvider;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;

public class PublicKeyInfo
extends ASN1Object
implements PublicKey {
    private static final long serialVersionUID = -3215331921801536598L;
    protected AlgorithmID algId = new AlgorithmID();
    protected ASN1BitString pkey = new ASN1BitString();

    public PublicKeyInfo() {
        this.modified = false;
        this.encoded = null;
    }

    public PublicKeyInfo(byte[] eKey) throws ASN1Exception {
        this();
        DERDecoder dec = new DERDecoder(eKey);
        this.decode(dec);
        this.encoded = (byte[])eKey.clone();
        this.modified = false;
    }

    public PublicKeyInfo(PublicKey key) throws InvalidKeyException {
        this();
        this.algId.setAlgorithm(key.getAlgorithm());
        this.setPublicKey(key);
    }

    public byte[] getAlgParameter() {
        byte[] ret = null;
        if (this.algId.hasParameter()) {
            ret = this.algId.getParameter();
        }
        return ret;
    }

    public void setAlgParameter(byte[] param) {
        this.modified = true;
        this.algId.setParameter(param);
    }

    public String getAlgName() {
        return this.algId.getAlgName();
    }

    public String getAlg() {
        return this.algId.getAlg();
    }

    public byte[] getPublicKeyAsByteArray() {
        return this.pkey.getAsByteArray();
    }

    public byte[] getPublicKeyAsIdentifier() {
        return this.getPublicKeyAsIdentifier("SHA1");
    }

    public byte[] getPublicKeyAsIdentifier(String alg) {
        try {
            MessageDigest dgst = MessageDigest.getInstance(alg, InitechProvider.NAME);
            return dgst.digest(this.pkey.getAsByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setAlgorithm(AlgorithmID id) {
        this.modified = true;
        this.algId = (AlgorithmID)id.clone();
    }

    public void setAlgName(String name) {
        this.modified = true;
        this.algId.setAlgorithm(name);
    }

    public void setAlgName(ASN1OID name) {
        this.modified = true;
        this.algId.setAlgorithm(name);
    }

    public void setPublicKey(byte[] data) {
        this.modified = true;
        this.pkey.setByteArray(data);
    }

    public void setPublicKey(PublicKey key) throws InvalidKeyException {
        String format = key.getFormat();
        if ("X.509".equals(format) || "X509".equals(format)) {
            try {
                byte[] t = key.getEncoded();
                DERDecoder dec = new DERDecoder(t);
                this.decode(dec);
                this.encoded = t;
                this.modified = false;
            }
            catch (Exception ex) {
                throw new InvalidKeyException(ex.toString());
            }
        } else {
            throw new InvalidKeyException("Format " + key.getFormat() + " is not supported");
        }
    }

    public PublicKey getPublicKey() {
        try {
            byte[] ePkey = this.getEncoded();
            if (ePkey == null) {
                return null;
            }
            KeyFactory keyFact = KeyFactory.getInstance(this.algId.getAlgName(), InitechProvider.NAME);
            return keyFact.generatePublic(new X509EncodedKeySpec(ePkey));
        }
        catch (Exception ex) {
            return this;
        }
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id = dec.decodeSequence();
        this.algId.decode(dec);
        this.pkey = dec.decodeBitString();
        dec.endOf(id);
    }

    public String getFormat() {
        return "X.509";
    }

    public String getAlgorithm() {
        return this.algId.getAlgName();
    }

    public byte[] getEncoded() {
        try {
            return super.getEncoded();
        }
        catch (ASN1Exception ex) {
            return null;
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequence();
        this.algId.encode(enc);
        enc.encodeBitString(this.pkey);
        enc.endOf(id);
    }

    public void toString(StringBuffer buf, int n) {
        StringUtil.indent(buf, n);
        buf.append("Public Key : ");
        buf.append(this.algId.getAlgName());
        buf.append('\n');
        buf.append(Hex.prettyDump(this.pkey.getAsByteArray(), 48, ' ', n + 1));
        buf.append('\n');
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(80);
        this.toString(buf, 0);
        return new String(buf);
    }
}

