/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.OIDDictionary;
import com.initech.asn1.useful.AVA;
import java.util.Enumeration;
import java.util.Vector;

public class RDN
implements ASN1Type,
Cloneable {
    private static final long serialVersionUID = -5404992005900429178L;
    Vector avas = new Vector(3);
    Vector canonAvas = new Vector(3);
    boolean sorted = true;
    boolean preserveOrder = false;
    boolean canMod = true;
    String canStr = null;

    public RDN() {
    }

    public RDN(String id, String val) {
        this();
        AVA ava = new AVA(id, val);
        this.avas.addElement(ava);
        this.canonAvas.addElement(ava);
        this.sorted = true;
    }

    public RDN(String s) throws IllegalArgumentException {
        this();
        this.set(s);
    }

    private void invalidate() {
        this.canMod = true;
    }

    public void setEncodingRule(String rule) {
        for (int i = 0; i < this.avas.size(); ++i) {
            AVA a = (AVA)this.avas.elementAt(i);
            a.setEncodingRule(rule);
        }
        this.invalidate();
    }

    public void clear() {
        this.avas.removeAllElements();
        this.canonAvas.removeAllElements();
        this.sorted = true;
        this.preserveOrder = false;
        this.invalidate();
    }

    public boolean isNull() {
        return this.avas.size() == 0;
    }

    public Enumeration elements() {
        return this.avas.elements();
    }

    public AVA elementAt(int i) {
        if (i < 0 || i >= this.avas.size()) {
            return null;
        }
        return (AVA)this.avas.elementAt(i);
    }

    public int size() {
        return this.avas.size();
    }

    public Object clone() {
        AVA a;
        int i;
        RDN ret = new RDN();
        for (i = 0; i < this.avas.size(); ++i) {
            a = (AVA)this.avas.elementAt(i);
            ret.avas.addElement((AVA)a.clone());
        }
        for (i = 0; i < this.canonAvas.size(); ++i) {
            a = (AVA)this.canonAvas.elementAt(i);
            ret.canonAvas.addElement((AVA)a.clone());
        }
        ret.sorted = this.sorted;
        ret.preserveOrder = this.preserveOrder;
        ret.canMod = this.canMod;
        ret.canStr = this.canStr != null ? new String(this.canStr) : null;
        return ret;
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.avas.removeAllElements();
        this.canonAvas.removeAllElements();
        int id = dec.decodeSetOf();
        while (!dec.endOf(id)) {
            AVA a = new AVA();
            a.decode(dec);
            this.avas.addElement(a);
            this.canonAvas.addElement(a);
        }
        this.sorted = false;
        this.preserveOrder = true;
        this.invalidate();
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        Vector v;
        if (this.preserveOrder) {
            v = this.avas;
        } else {
            v = this.canonAvas;
            if (!this.sorted) {
                this.sort();
            }
        }
        int id = enc.encodeSetOf();
        for (int i = 0; i < v.size(); ++i) {
            AVA a = (AVA)v.elementAt(i);
            enc.encodeAny(a.getEncoded());
        }
        enc.endOf(id);
    }

    public void add(AVA a) throws IllegalArgumentException {
        if (this.avas.size() == 0 || !this.sorted) {
            this.canonAvas.add(a);
        } else {
            try {
                byte[] ae = a.getEncoded();
                for (int i = this.canonAvas.size() - 1; i >= 0; --i) {
                    AVA b = (AVA)this.canonAvas.elementAt(i);
                    byte[] be = b.getEncoded();
                    int comp = this.compare(ae, be);
                    if (comp < 0) continue;
                    if (comp > 0) {
                        this.canonAvas.insertElementAt(a, i + 1);
                        break;
                    }
                    throw new IllegalArgumentException(a.toString() + " arleady exists in this RDN");
                }
            }
            catch (ASN1Exception ex) {
                throw new IllegalArgumentException("Failed to encode : " + a.toString());
            }
        }
        this.avas.add(a);
        this.invalidate();
    }

    public void add(String s) throws IllegalArgumentException {
        this.add(new AVA(s));
    }

    public String toRFC2253String() {
        StringBuffer buf = new StringBuffer(64);
        for (int i = 0; i < this.avas.size(); ++i) {
            AVA a = (AVA)this.avas.elementAt(i);
            if (i == 0) {
                buf.append(a.toRFC2253String());
                continue;
            }
            buf.append('+');
            buf.append(a.toRFC2253String());
        }
        return new String(buf);
    }

    public String toRFC2253CanonicalString() {
        if (this.canMod || this.canStr == null) {
            if (!this.sorted) {
                try {
                    this.sort();
                }
                catch (ASN1Exception ignore) {
                    // empty catch block
                }
            }
            StringBuffer buf = new StringBuffer(64);
            for (int i = 0; i < this.canonAvas.size(); ++i) {
                AVA a = (AVA)this.canonAvas.elementAt(i);
                if (i == 0) {
                    buf.append(a.toRFC2253CanonicalString());
                    continue;
                }
                buf.append('+');
                buf.append(a.toRFC2253CanonicalString());
            }
            this.canStr = new String(buf);
            this.canMod = false;
        }
        return this.canStr;
    }

    public String toRFC1779String() {
        StringBuffer buf = new StringBuffer(64);
        for (int i = 0; i < this.avas.size(); ++i) {
            AVA a = (AVA)this.avas.elementAt(i);
            if (i == 0) {
                buf.append(a.toRFC1779String());
                continue;
            }
            buf.append('+');
            buf.append(a.toRFC1779String());
        }
        return new String(buf);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        for (int i = 0; i < this.avas.size(); ++i) {
            AVA a = (AVA)this.avas.elementAt(i);
            if (i == 0) {
                buf.append(a.toString());
                continue;
            }
            buf.append('+');
            buf.append(a.toString());
        }
        return new String(buf);
    }

    public String get(String id) {
        String ret = null;
        String oid = id;
        if (!ASN1OID.isOID(id)) {
            oid = OIDDictionary.getOIDbyName(id);
        }
        if (oid == null) {
            return null;
        }
        for (int i = 0; i < this.avas.size(); ++i) {
            AVA a = (AVA)this.avas.elementAt(i);
            if (!oid.equals(a.getType())) continue;
            ret = a.getValue();
            break;
        }
        return ret;
    }

    public void set(String name) throws IllegalArgumentException {
        AVA ava;
        String s;
        boolean inQuote = false;
        this.clear();
        this.sorted = false;
        int start = 0;
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '\\') {
                ++i;
                continue;
            }
            if (name.charAt(i) == '\"') {
                inQuote = !inQuote;
                continue;
            }
            if (name.charAt(i) != '+' || inQuote) continue;
            s = name.substring(start, i).trim();
            if (s.length() == 0) {
                throw new IllegalArgumentException("empty AVA in RDN \"" + name + "\"");
            }
            ava = new AVA(s);
            this.add(ava);
            start = i + 1;
        }
        if (start < name.length()) {
            s = name.substring(start).trim();
            if (s.length() == 0) {
                throw new IllegalArgumentException("empty AVA in RDN \"" + name + "\"");
            }
            ava = new AVA(s);
            this.add(ava);
        }
        this.invalidate();
    }

    public int hashCode() {
        String c = this.toRFC2253CanonicalString();
        return c.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof RDN) {
            return this.equals((RDN)o);
        }
        return false;
    }

    public boolean equals(RDN rdn) {
        if (rdn == null) {
            return false;
        }
        if (rdn == this) {
            return true;
        }
        if (this.avas.size() != rdn.size()) {
            return false;
        }
        String c = this.toRFC2253CanonicalString();
        String c2 = rdn.toRFC2253CanonicalString();
        return c.equals(c2);
    }

    private void sort() throws ASN1Exception {
        if (this.canonAvas.size() <= 1) {
            this.sorted = true;
            return;
        }
        byte[][] array = new byte[this.canonAvas.size()][];
        for (int i = 0; i < this.canonAvas.size(); ++i) {
            AVA a = (AVA)this.canonAvas.elementAt(i);
            array[i] = a.getEncoded();
        }
        for (int i = 0; i < this.canonAvas.size() - 1; ++i) {
            for (int j = i + 1; j < this.canonAvas.size(); ++j) {
                if (this.compare(array[i], array[j]) <= 0) continue;
                byte[] temp = array[i];
                array[i] = array[j];
                array[j] = temp;
                Object tempObj = this.canonAvas.elementAt(i);
                this.canonAvas.setElementAt(this.canonAvas.elementAt(j), i);
                this.canonAvas.setElementAt(tempObj, j);
            }
        }
        this.sorted = true;
    }

    public int compare(byte[] a, byte[] b) {
        if (a.length > b.length) {
            return 1;
        }
        if (a.length < b.length) {
            return -1;
        }
        for (int i = 0; i < a.length; ++i) {
            int an = a[i] & 0xFF;
            int bn = b[i] & 0xFF;
            if (an > bn) {
                return 1;
            }
            if (an >= bn) continue;
            return -1;
        }
        return 0;
    }
}

