/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.useful.GeneralNameInterface;

public class RFC822Name
implements GeneralNameInterface {
    private static final long serialVersionUID = -880679958108202901L;
    String name;

    RFC822Name(ASN1Decoder dec) throws ASN1Exception {
        this.decode(dec);
    }

    public RFC822Name(String s) throws IllegalArgumentException {
        if (s == null || s.length() != 0) {
            this.parseName(s);
        }
        this.name = s;
    }

    public void parseName(String s) throws IllegalArgumentException {
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("RFC822Name may not be null or empty");
        }
        String s1 = s.substring(s.indexOf(64) + 1);
        if (s1.startsWith(".") && s1.length() == 1) {
            throw new IllegalArgumentException("RFC822Name domain may not be just .");
        }
    }

    public boolean equals(Object o) {
        if (o instanceof RFC822Name) {
            RFC822Name n = (RFC822Name)o;
            return this.name.equalsIgnoreCase(n.name);
        }
        if (o instanceof String) {
            return this.name.equalsIgnoreCase((String)o);
        }
        return false;
    }

    public int getType() {
        return 1;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.toUpperCase().hashCode();
    }

    public int constrains(GeneralNameInterface gni) throws UnsupportedOperationException {
        int ret;
        if (gni == null) {
            ret = -1;
        } else if (gni.getType() != 1) {
            ret = -1;
        } else {
            int i;
            String other = ((RFC822Name)gni).getName().toLowerCase();
            String my = this.name.toLowerCase();
            ret = my.equals(other) ? 0 : (my.endsWith(other) ? (other.length() == 0 ? 1 : (other.indexOf(64) != -1 ? 3 : (other.startsWith(".") ? 1 : (my.charAt((i = my.lastIndexOf(other)) - 1) == '@' ? 1 : 3)))) : (other.endsWith(my) ? (my.length() == 0 ? 2 : (my.indexOf(64) != -1 ? 3 : (my.startsWith(".") ? 2 : (other.charAt((i = other.lastIndexOf(my)) - 1) == '@' ? 2 : 3)))) : 3));
        }
        return ret;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        String s = this.name;
        int i = 1;
        int j = s.lastIndexOf(64);
        if (j >= 0) {
            ++i;
            s = s.substring(j + 1);
        }
        int k = s.length() - 1;
        while ((j = s.lastIndexOf(46, k)) >= 0) {
            k = j - 1;
            ++i;
        }
        return i;
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean can) {
        return this.toString(can, false);
    }

    public String toString(boolean can, boolean withType) {
        String ret = can ? this.name.toLowerCase() : this.name.toString();
        if (withType) {
            ret = "RFC822Name: " + ret;
        }
        return ret;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.encodeIA5String(this.name);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.name = dec.decodeIA5String();
        this.parseName(this.name);
    }
}

